/**
 * WordPress dependencies
 */
import { G, Path, SVG, Rect, Polygon } from '@wordpress/primitives';

/**
 * Custom icons
 */
const icons = {};

icons.gutenslider = <SVG width="243pt" height="243pt" viewBox="0 0 243 243" version="1.1" xmlns="http://www.w3.org/2000/SVG">
	<G id="#492c6bff">
		<Path fill="#492c6b" opacity="1.00" d=" M 80.95 31.16 C 92.87 22.33 107.35 16.93 122.19 16.14 C 134.32 15.39 146.54 17.27 158.08 20.98 C 161.51 19.31 164.97 17.69 168.46 16.15 C 173.29 15.75 178.16 16.12 183.00 16.00 C 182.87 26.78 183.20 37.55 183.21 48.33 C 198.87 37.45 214.66 26.77 230.26 15.82 C 219.34 33.91 208.23 51.88 197.52 70.09 C 199.15 74.90 201.51 79.54 202.74 84.53 C 207.95 103.12 215.80 120.86 225.44 137.56 C 227.75 141.90 230.08 146.80 228.89 151.84 C 227.24 159.09 221.50 164.58 215.29 168.24 C 207.15 172.78 198.41 176.23 189.38 178.54 C 176.67 167.46 163.87 155.62 147.83 149.60 C 139.17 147.82 130.20 147.04 122.17 142.98 C 125.90 158.61 132.38 173.43 136.33 189.02 C 140.33 203.91 142.67 219.31 142.58 234.76 C 135.25 234.66 127.92 234.94 120.59 234.60 C 120.93 214.35 115.94 194.48 109.51 175.43 C 104.73 160.63 99.20 145.90 97.29 130.37 C 95.23 115.18 97.16 99.44 103.00 85.26 C 106.58 79.07 110.48 72.72 116.42 68.51 C 120.69 74.42 125.32 80.06 129.56 86.00 C 124.79 90.76 120.63 96.85 120.74 103.85 C 120.84 109.87 121.55 117.12 127.02 120.79 C 136.36 127.98 149.03 126.16 159.52 130.57 C 172.61 135.92 183.98 144.70 194.52 153.97 C 198.55 152.16 202.71 150.55 206.21 147.79 C 195.86 129.68 187.43 110.45 181.53 90.43 C 179.10 83.40 178.05 75.62 173.30 69.64 C 169.98 65.81 165.60 63.10 161.54 60.13 C 161.39 54.75 161.39 49.36 161.53 43.98 C 149.62 40.47 137.35 37.57 124.84 37.76 C 112.05 38.28 99.78 43.72 90.01 51.84 C 72.82 65.32 61.17 84.41 52.10 103.99 C 40.05 131.33 33.51 161.11 33.19 191.00 C 25.89 191.00 18.60 191.00 11.31 191.00 C 11.77 145.70 24.63 100.02 50.48 62.59 C 58.92 50.63 68.98 39.66 80.95 31.16 M 183.27 50.19 C 183.81 50.81 183.81 50.81 183.27 50.19 Z" />
		<Path fill="#492c6b" opacity="1.00" d=" M 154.58 81.72 C 159.22 78.52 166.77 82.20 166.50 87.98 C 166.90 93.85 159.20 97.97 154.52 94.53 C 150.14 91.74 150.00 84.42 154.58 81.72 Z" />
	</G>
</SVG>;

icons.gutenslider = <SVG className="icon-gutenslider" width="26px" height="18px" viewBox="0 0 26 18" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlnsXlink="http://www.w3.org/1999/xlink">
	<G id="Page-1" strokeWidth="1">
		<G id="image" transform="translate(0.000000, -3.000000)">
			<Path id="outer" d="M20,5 L20,19 L6,19 L6,5 L20,5 L20,5 Z M20,3 L6,3 C4.9,3 4,3.9 4,5 L4,19 C4,20.1 4.9,21 6,21 L20,21 C21.1,21 22,20.1 22,19 L22,5 C22,3.9 21.1,3 20,3 Z" fillRule="nonzero"></Path>
			<Polygon fillRule="nonzero" points="15.14 12 12.14 15.7645914 10 13.2451362 7 17 19 17"></Polygon>
			<Rect x="7" y="9" width="12" height="1"></Rect>
			<Rect x="7" y="7" width="12" height="1"></Rect>
			<Polygon transform="translate(24.500000, 12.000000) rotate(-270.000000) translate(-24.500000, -12.000000) " points="24.5 10.5 27.5 13.5 21.5 13.5"></Polygon>
			<Polygon transform="translate(1.500000, 12.000000) rotate(-90.000000) translate(-1.500000, -12.000000) " points="1.5 10.5 4.5 13.5 -1.5 13.5"></Polygon>
		</G>
	</G>
</SVG>;

icons.gutenslide = <SVG className="icon-gutenslider" width="26px" height="18px" viewBox="0 0 26 18" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlnsXlink="http://www.w3.org/1999/xlink">
	<G id="Page-1" strokeWidth="1">
		<G id="image" transform="translate(0.000000, -3.000000)">
			<Path id="outer" d="M20,5 L20,19 L6,19 L6,5 L20,5 L20,5 Z M20,3 L6,3 C4.9,3 4,3.9 4,5 L4,19 C4,20.1 4.9,21 6,21 L20,21 C21.1,21 22,20.1 22,19 L22,5 C22,3.9 21.1,3 20,3 Z" fillRule="nonzero"></Path>
			<Polygon fillRule="nonzero" points="15.14 12 12.14 15.7645914 10 13.2451362 7 17 19 17"></Polygon>
			<Rect x="7" y="9" width="12" height="1"></Rect>
			<Rect x="7" y="7" width="12" height="1"></Rect>
		</G>
	</G>
</SVG>;

icons.progress =
	<SVG xmlns="http://www.w3.org/2000/svg" aria-hidden="true" focusable="false" width="20" height="20" preserveAspectRatio="xMidYMid meet" viewBox="0 0 32 32">
		<Path d="M16 2a14 14 0 1 0 14 14A14.016 14.016 0 0 0 16 2zm0 26a12 12 0 0 1 0-24v12l8.481 8.481A11.963 11.963 0 0 1 16 28z" fill="#000"/>
	</SVG>

icons.tablet =
	<svg className="dashicon" height="16" viewBox="0 0 16 16" width="16" xmlns="http://www.w3.org/2000/svg"><path d="m11.25 0h-9c-.825 0-1.5.61363636-1.5 1.36363636v13.27272724c0 .75.675 1.3636364 1.5 1.3636364h9c.825 0 1.5-.6136364 1.5-1.3636364v-13.27272724c0-.75-.675-1.36363636-1.5-1.36363636zm-.5 14h-8v-12h8z" transform="translate(1.25)" /></svg>;

icons.mobile =
	<svg className="dashicon" height="16" viewBox="0 0 16 16" width="16" xmlns="http://www.w3.org/2000/svg"><path d="m6.5 0h-5c-.825 0-1.5.61363636-1.5 1.36363636v9.27272724c0 .75.675 1.3636364 1.5 1.3636364h5c.825 0 1.5-.6136364 1.5-1.3636364v-9.27272724c0-.75-.675-1.36363636-1.5-1.36363636zm-.5 10h-4v-8h4z" transform="translate(4 2)" /></svg>;

icons.desktop =
	<svg className="dashicon" height="16" viewBox="0 0 16 16" width="16" xmlns="http://www.w3.org/2000/svg"><path d="m12.5 0c.8325 0 1.5.61363636 1.5 1.36363636v11.27272724c0 .75-.675 1.3636364-1.5 1.3636364l-.5-2v-9h-10v9h10l.5 2h-11c-.8325 0-1.5-.6136364-1.5-1.3636364v-11.27272724c0-.75.6675-1.36363636 1.5-1.36363636zm-10 1c-.27614237 0-.5.22385763-.5.5s.22385763.5.5.5.5-.22385763.5-.5-.22385763-.5-.5-.5z" transform="translate(1 1.001872)" /></svg>;

icons.arrowRight =
	<svg className="dashicon" aria-hidden="true" focusable="false" width="16px" height="16px" preserveAspectRatio="xMidYMid meet" viewBox="0 0 24 24"><path d="M12 22C6.477 22 2 17.523 2 12S6.477 2 12 2s10 4.477 10 10s-4.477 10-10 10zm0-2a8 8 0 1 0 0-16a8 8 0 0 0 0 16zm1.586-7H8a1 1 0 0 1 0-2h5.586L11.05 8.464a1 1 0 1 1 1.414-1.414l4.243 4.243a.997.997 0 0 1 0 1.414l-4.243 4.243a1 1 0 1 1-1.414-1.414L13.586 13z" fill="#000" /><rect x="0" y="0" width="24" height="24" fill="rgba(0, 0, 0, 0)" /></svg>;

icons.mix = (
	<SVG aria-hidden="true" focusable="false" width="24" height="24" preserveAspectRatio="xMidYMid meet" viewBox="0 0 15 15">
		<G fill="none">
			<Path fillRule="evenodd" clipRule="evenodd" d="M3 9c0-2.5 1.5-4.75 4.5-7.5c3 2.75 4.5 5 4.5 7.5a4.5 4.5 0 1 1-9 0zm7.952-.697c-1.279-.482-2.664.16-3.962.76c-1.057.488-2.056.95-2.893.759A3.51 3.51 0 0 1 4 9c0-1.888 1.027-3.728 3.5-6.126c2.168 2.102 3.225 3.776 3.452 5.43z" fill="#000"/>
		</G>
	</SVG>
);

icons.difference = (
	<SVG aria-hidden="true" focusable="false" width="24" height="24" preserveAspectRatio="xMidYMid meet" viewBox="0 0 24 24"><Path d="M15 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-8a2 2 0 0 1 2-2h4V5a2 2 0 0 1 2-2h8a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2h-4zm-4-6h4v4h4V5h-8v4zm-6 2v8h8v-4H9v-4H5z" fillRule="evenodd"/></SVG>
);

icons.lighten = (
	<SVG aria-hidden="true" focusable="false" width="24" height="24" preserveAspectRatio="xMidYMid meet" viewBox="0 0 24 24"><Path d="M12 7c-2.76 0-5 2.24-5 5s2.24 5 5 5s5-2.24 5-5s-2.24-5-5-5zM2 13h2c.55 0 1-.45 1-1s-.45-1-1-1H2c-.55 0-1 .45-1 1s.45 1 1 1zm18 0h2c.55 0 1-.45 1-1s-.45-1-1-1h-2c-.55 0-1 .45-1 1s.45 1 1 1zM11 2v2c0 .55.45 1 1 1s1-.45 1-1V2c0-.55-.45-1-1-1s-1 .45-1 1zm0 18v2c0 .55.45 1 1 1s1-.45 1-1v-2c0-.55-.45-1-1-1s-1 .45-1 1zM5.99 4.58a.996.996 0 0 0-1.41 0a.996.996 0 0 0 0 1.41l1.06 1.06c.39.39 1.03.39 1.41 0s.39-1.03 0-1.41L5.99 4.58zm12.37 12.37a.996.996 0 0 0-1.41 0a.996.996 0 0 0 0 1.41l1.06 1.06c.39.39 1.03.39 1.41 0a.996.996 0 0 0 0-1.41l-1.06-1.06zm1.06-10.96a.996.996 0 0 0 0-1.41a.996.996 0 0 0-1.41 0l-1.06 1.06c-.39.39-.39 1.03 0 1.41s1.03.39 1.41 0l1.06-1.06zM7.05 18.36a.996.996 0 0 0 0-1.41a.996.996 0 0 0-1.41 0l-1.06 1.06c-.39.39-.39 1.03 0 1.41s1.03.39 1.41 0l1.06-1.06z"/></SVG>
);

icons.darken = (
	<SVG aria-hidden="true" focusable="false" width="24" height="24" preserveAspectRatio="xMidYMid meet" viewBox="0 0 24 24"><Path d="M12 3a9 9 0 1 0 9 9c0-.46-.04-.92-.1-1.36a5.389 5.389 0 0 1-4.4 2.26a5.403 5.403 0 0 1-3.14-9.8c-.44-.06-.9-.1-1.36-.1z"/></SVG>
);

icons.divider =
	<svg aria-hidden="true" focusable="false" width="22" height="22" preserveAspectRatio="xMidYMid meet" viewBox="0 0 24 24"><g fill="none" stroke="#000000" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round"><rect x="3" y="3" width="18" height="18" rx="2" ry="2" /><path d="M8 12h8" /><path d="M12 16h0" /><path d="M12 8h0" /></g></svg>;

export default icons;
