# WordPress Slider Block Gutenslider

**Contributors:** eedee, wordpressslider, gutenbergslider \
**Tags:** slider, slider block, image slider, video slider, wordpress slider, carousel, gallery, responsive, media slider, content slider \
**Requires at least:** 5.6 \
**Tested up to:** 6.2.2 \
**License:** GPLv2 or later \
**License URI:** http://www.gnu.org/licenses/gpl-2.0.html \
**Stable tag:** 5.10.2

Slider plugin for Gutenberg. Create a image slider, video slider, fullscreen slider with this powerful slider block and add any block on top. Slide anything!

## Description

Gutenslider is an image slider and video slider plugin for WordPress that adds a simple to use Gutenberg slider block to your WordPress editor. You do not need
other editors but can manage everything directly in the Gutenberg editor you already know and love. You can add any content on top that you want! Gutenslider is faster and slicker than any other slider around.
Go and try it out yourself and make use of a content slider, image slider and video slider **that will increase user engagement on your website** and allow you to **create your sliders in seconds** not in minutes, by using the Gutenberg backend editor you know already. No need to study complicated backend editors. Gutenslider is the best match for you and your customers.

[youtube https://youtu.be/iuZg4RTcZQ4]

[Live Examples](https://gutenslider.org/)

With Gutenslider, enhancing your blog or website is easier than ever:

1. Simply add the Gutenslider Block from the Gutenberg backend
2. Select images from your Media Library
3. Add any Block you like on top
4. Customize Gutenslider to your needs in the backend
5. Slide! 👩‍🎤

Gutenslider is easy to use, fast, and very powerful and developed by trusted developers, that also contribute to the Gutenberg core repository.

## Plugin Features

- Add unlimited slides
- Change the [transition mode](https://gutenslider.org/examples/transition-animation/): `fade`, `slide`, `flip`
- [Add any block on top that you want](https://gutenslider.org/adding-content-examples/)
- Block alignment: `wide`, `full`
- Content alignment: `top`, `center`, `bottom`, `left`, `right`
- Fixed Content / Changing Content
- Slides to show: `auto` or `1`
- Arrows on/off
- Arrow size
- 3 Arrow Colors
- Dots on/off
- Dots size
- 3 Dot Colors
- Spacing: top/bottom and left/right
- Margin: top/bottom and left/right
- [Automatic Captions](https://gutenslider.org/automatic-photo-captions/)
- [Fullscreen slider](https://gutenslider.org/examples/fullscreen-background-slider-example/) (slider will be in the background of your content).
- Very easy to use because it is a Gutenberg block - no need to go away from your backend editor
- Hyperlink Slides
- Simple [lightGallery](https://gutenslider.org/gutenslider-x-lightgallery/) integration
- webp support
- Hash navigation
- [Custom Css for Slider](https://gutenslider.org/custom-css-wordpress-slider/)

## Plugin Pro Features 💎

- Video Slider: add videos to your slide backgrounds
- [Parallax Sliders](https://gutenslider.org/parallax-slider-for-wordpress/)
- 5 transition modes: `fade`, `slide`, `flip`, `coverflow`, `cube`, `cards`
- Transition time
- Time of a slide
- Color overlays of slides
- Gradient overlay of slides
- Space between slides
- Bulk Editing
- Arrow color / Arrow Background Color
- [Advanced Arrow Styles](https://gutenslider.org/wordpress-slider-arrow-styles/)
	- Pick from 10 styles or add your own svg
	- Position ( `Sides`, `Top Left`, `Bottom Left`, `Top Right`, `Bottom Right` )
	- [Arrows Follow Mouse](https://gutenslider.org/wordpress-slider-arrows-follow-mouse/)
	- Unlimited Color Options
	- Background Color
	- Hover Colors
	- Arrow horizontal and vertical offset
	- Arrow Mix Blending
	- [Custom SVG arrows](https://gutenslider.org/adding-custom-arrows-to-your-wordpress-sliders/)
- [Advanced Progress options](https://gutenslider.org/gutenslider-progress-styles/)
	- Style ( dots, dynamic dots, numbers, progressbar )
	- Position ( `Top`, `Bottom`, `Left`, `Right` )
	- Offset
	- Unlimited Color Options
- Advanced [lightgallery](https://gutenslider.org/gutenslider-x-lightgallery/) styles
  - choose any background color
	- pick from 30 transitions
	- enable/disable counter
	- enable and set image caption
- Dots style
- Advanced Responsive Controls
- Slides to show: either `auto` or maximum of `8`
- Advanced Hash Navigation Settings: customize hash for slider + slides
- ... and of course all free features

[Free 7-day trial, no credit card required](https://checkout.freemius.com/mode/dialog/plugin/3804/plan/6127/?trial

### free)

So you can easily create a [Fullscreen Video Slider](https://gutenslider.org/full-screen-video-background/) for your blog or websitee with Gutenslider Pro. And even go more custom by, creating Full Screen Video Background ! Sliders !. There is no limit to your creativity.

## Slider Modes

### Changing Content

The slider mode you will most probably know. Each slide has a custom background and custom content.

### Fixed Content

In this mode you select fixed content, that will stay on top, while the background changes and loops all slides. Great for headlines, call to actions. You name it!

Gutenslider is built using WordPress, CSS, Javascript, best practices both on the front and the backend. And it's seo optimized. It makes use of the new Gutenberg powers built in react. As a result, it is robust, easy to use and lightning fast. It works with any theme. Go and check it out.

## Help us get better

We know, that Gutenslider is nice, but we also know, that we can constantly improve. Not only code quality and security, but also features and user experience. For the latter, we need your help. If you think that we should change things. [Be so kind and leave us a support or feature request in the support forum.](https://wordpress.org/support/plugin/gutenslider/) Thanks.

## Installation 🔧

### Minimum Requirements

You’ll need WordPress version 5.0 or higher for this to work. For versions below 5.0, you will need to use the Gutenberg plugin.

### Quick and Fast

1. Go to the Plugins Menu in WordPress
2. Search for "Gutenslider"
3. Click "Install"
4. Activate the Gutenslider Plugin on your Plugins Menu

# Experienced Users (same result)

1. Upload the gutenslider folder to the /wp-content/plugins/ directory
2. Activate the plugin through the 'Plugins' menu in WordPress

## Frequently Asked Questions ❓

### What blocks are supported

Gutenslider works with any blocks on top. However there might be styling issues or things to improve. Either write your own custom css or submit a support request in the [support forum](https://wordpress.org/support/plugin/gutenslider/). If it is a commonly used block, we will integrate the needed styles into Gutenslider.

### Can I use Gutenslider with any theme?

Yes, you can use Gutenslider with any theme. If you experience difficulties, please contact your theme author first, before submitting a topic in the [support forum](https://wordpress.org/support/plugin/gutenslider/).

### Is Gutenslider free?

Yes! Gutenslider's core features are absolutely free. If you want more control over the slider settings and many more features, you can buy the pro version of the plugin.

### Can you provide support?

Yes, just post a question on the support tab, and we will answer as soon as possible.

### Can you add this feature I need?

We are happy to extend Gutenslider to our users' needs. Just contact us on our website at [https://gutenslider.org](https://gutenslider.org) and we will see what we can do.

### What is Gutenberg

To get the full experience of the next-generation WordPress block editor, you’ll need a Gutenberg-ready WordPress theme then install the Gutenberg WordPress plugin or simply update your site to WordPress 5.0. That’s it! 💥

### Can I have Gutenslider in my language

You can contribute to translating Gutenslider for you and all other users of your language here: https://translate.wordpress.org/projects/wp-plugins/gutenslider/ . Just submit your translations and once they are accepted, Gutenslider will immediately work in your language.

## Screenshots

### 1. Gutenslider in Action (Frontend)

[missing image]

### 2. Gutenslider Creation (Backend + Frontend)

[missing image]


## Changelog

### 5.9.5

* critical security update in freemius

### 5.9.4

* reset default background of lightgallery

### 5.9.3

* add new `gutenslider_attributes` filter to change default Gutenslider attributes with a WordPress filter
* add new `gutenslide_attributes` filter to change default Gutenslide attributes with a WordPress filter

### 5.9.2

* add links to plugin description

### 5.9.1

* improve backwards compatibility with older safari versions

### 5.9.0

* Update swiper library to latest 8.3.2
* UI improvements for editor controls
* removed 1 critical and 3 high security issues in used js packages (added 60 packages, removed 35 packages, changed 167 packages, and audited 1570 packages)

### 5.8.4

* Fix a bug with content not displaying in slider mode "fixed"
* Upadte freemius SDK to 2.4.5

### 5.8.3

* Fix a bug with adaptive height sliders

### 5.8.2

* Fix WordPress 6.0 css issue
* Add Arrows Follow Mouse functionality on Pro

### 5.8.1

* Fix a bug with slide links
* Add option to hide slides in slide controls

### 5.8.0

* Test and approve WordPress 6.0 compatibility
* Add effect cards to Pro
* Update swiper library

### 5.7.0

* Fix critical security issue with freemius sdk

### 5.6.1

* Increase performance for responsive editor preview

### 5.6.0

* Update compatibility to WordPress 5.9
* Fix broken responsive preview styles due to new iframe editor preview
* Fix slides auto on safari bug
* Fix slides per view with float values on frontend
* Fix a bug with image positioning
* Update Packages (swiper 7, @wordpress/scripts 20, lightgallery 2.3)

### 5.5.7

* Improve page speed and requests by removing unneded script dependencies ( thank you [straightvisions](https://straightvisions.com/ ))

### 5.5.6

* Add better alignment controls to free version
* Fix block selection in editor for content mode: fixed sliders

### 5.5.5

* Add visual arrow select component
* Fix UI editor control style
* Improve divider controls / pro
* remove console logs in rare cases

### 5.5.4

* Fix transition animation preview in editor (Gutenslider free)
* Fix media select modal for free + pro (if only images, make reorder possible)

### 5.5.3

* Fix a bug with margin top + bottom controls
* Fix Gutenberg Plugin > 12.x style issue with range control
* Add hash functionality for links
* Fix a bug with dividers and downgrading from pro -> free

### 5.5.2

* Add hash navigation functionality to add direct links to slides
* Add Gutenslider instance to dom element for easier javascript manipulation

### 5.5.1

* Add `gutenslider_arrow` hook to allow easier integration of custom arrow styles, see https://gutenslider.org/adding-custom-arrows-to-your-wordpress-sliders/

### 5.5.0

* Fix gutenslider not working in widgets and

### 5.4.6

* Fix compatibility issue with Gutenberg 11.9.0

### 5.4.5

* Upadte readme and links

### 5.4.4

* Fix a bug with lightgallery on safari

### 5.4.3

* Fix a bug with lightgallery

### 5.4.2

* Fix a bug where slider is not shown in editor in some configurations

### 5.4.1

* Fix lightgallery not showing in some themes

### 5.4.0

* Add lightgallery for image / video slides (does only enlarge the media not the slide content)
* Add unminified gutenslider-front-unmin.js to allow a higher level of customization for users
* Add front.js to package to allow a higher level of customization for users
* Fix issue with slide links not being saved when adding slides to slider
* Update bootstrap to 5 (used in admin only partially)
* Add: Enable keyboard controls

### 5.3.3

* Make more strings translatable

### 5.3.2

* Update readme

### 5.3.1

* Update readme to reflect latest stable tag (used for translation), and information for translators

### 5.3.0

* Fix: make Gutenslider ready for i18n in all languages that can now be pulled from the official WordPress translate directory

### 5.2.3

* Fix: remove empty style tag from frontend for w3c validation

### 5.2.2

* Fix i18n: pot file generation works
* Fix i18n: updated german translations
* Fix i18n: make more strings translatable

### 5.2.1

* fix 5.2 compatibility issue with Gutenberg Plugin

### 5.2.0

* fix possible xss attack vectors for users with contributor role and above

### 5.1.5

* add one more block Pattern: "Full Height Slider"
* fix block appender layout in fixed content slider
* fix now backwards compatible to PHP 5.3

### 5.1.4

* fix dots showing on mobile even if turned off
* fix "Add Empty Slide" button not working on some setups

### 5.1.3

* fix a bug in GradientPicker component

### 5.1.2

* fix unique block ids on block copying
* fix blurry images on large screens by adding more image sizes

### 5.1.1

* more discretion: move from top level admin menu to Settings -> Gutenslider
* more discretion: improve admin style

### 5.1.0

* Add dividers
* fix unable to select text in editor because of dragging slide [forum](https://wordpress.org/support/topic/editorview-unable-to-mark-text-content-because-of-dragging/)
* improve block settings css

### 5.0.18

* fix a bug in transform to cover
* enable block transforms for all gutenslider versions

### 5.0.17

* improve slide link control with updated component and `target="_blank"` which automatically sets `rel

### "noreferrer noopener"`

* add block transform from and to gallery block (`core/gallery`)
* fix slide block selection in `contentMode: 'fixed'`

### 5.0.16

* fix editor slider not updating when changing slidesToShow
* fix WordPress custom class missing on slides

### 5.0.15

* add first gutenslider block pattern: testimonial slider
* fix automatic css block id
* fix video autoplay issue on some setups
* fix sliders with autoheight and slide backgrounds without media
* remove unneeded admin notice
* improve editor speed
* improve responsive editor buttons

### 5.0.14

* Fix content positioning in editor

### 5.0.13

* fix a issue with automatic media captions
* fix code that produced console warnings
* fix default margin setting
* fix a responsive height issue on fixed sliders
* remove unneeded attributes from frontend

### 5.0.12

* fix content alignment of new empty slides (click add empty slide button)
* fix content alignment of new media slides (selected from media library)
[//]: # fs_premium_only_begin
* add option to show overlapping neighboring slides (pro)
[//]: # fs_premium_only_end

### 5.0.11

* Improve editor UX by smaller block json requests for fixed sliders
* Improve editor UX on fixed content sliders: click on slide now selects slide block

### 5.0.10

* Fix videos in slides per view auto

### 5.0.9

* Fix Full Screen Background Slider + margins [forum](https://wordpress.org/support/topic/fullscreen-background-slider-top-bottom-margins/)

### 5.0.8

* Style appearance of add empty slide button
* Fix a style issue with wide slider and fixed content
* Fix a dot overflowing issue in some themes

### 5.0.7

* Fix a white slider error on safari 13.x
* Add flip animation to free version
* Remove `mix blend mode` settings from InspectorControls

### 5.0.6

* Update readme with new intro video
* Fix a styling issue in new admin changelog display

### 5.0.5

* Fix no media slide width with multiple slides per view

### 5.0.4

* Fix slide links, you can now again link your slides to urls

### 5.0.3

* Fix an error with headers already sent in free version and pro version

### 5.0.0

* Move from slick to [swiper](https://swiperjs.com/) as slider library because of maintainablity, usability and security reasons
* Added three more animations ( pro ):
  * coverflow
	* cube
* Added more Progress options ( pro ):
  * Fraction - Display Slide Number
	* Progress - Display a Progressbar
	* Dynamic - Display dynamic bullets
* Space between slides ( pro )
* Insert images from url
* Slides per view auto
* Advanced more finegrained responsive controls ( pro )
* Conditional assets loading ( only load gutenslider css and js on posts/pages with Gutenslider blocks )
* Reduced file size - faster loading - better SEO score
* Improve Lazy Loading and srcset

* Fix: desktop slider appears on mobile [forum1](https://wordpress.org/support/topic/mobile-and-desktop-videos-appearing-at-the-same-time/) [forum2](https://wordpress.org/support/topic/desktop-hidden-slider-appears-on-mobile/)
* Fix: slider crashes in some cases when changing back and forth adaptive height
* Fix: block example now working
* Fix: replace slides / add empty slide now working
* Fix: edit / preview mode switch error
* Fix: slide width can now be set on transparent / gradient / color bg

### 4.5.0

* Easier responsive controls + preview (Pro)
* Fix a bug with Gutenslider inside Columns

### 4.4.13

* Add 3 color options to choose from for dot colors (free) - unlimited (pro)

### 4.4.12

* Fix insert empty slide button
* add new editor icon style

### 4.4.11

* add editor styles for media picker
* Remove affiliation link from menu

### 4.4.10

* fix a compatibility issue with WordPress 5.6 that broke the editor with full width slider blocks

### 4.4.9

* enable multisite integration
* fix css again

### 4.4.8

* fix css that interferred with other slick sliders on page

### 4.4.7

* Add WordPress 5.5.3 compatibility

### 4.4.6

* Fix all w3c validation errors and warnings. Gutenslider is now 100% w3c valid.

### 4.4.5

* Fix a block validation console error

### 4.4.4

* Update Maximum slide animation duration

### 4.4.3

* Fix arrows styles in pro.

### 4.4.2

* Fix arrows always displaying issue.

### 4.4.1

* Add affiliation program with 30% commission

### 4.4.0

* Add arrow color customization to free version
* Add arrow styles, all arrow colors, arrow background color, arrow mix-blend-mode to pro version

### 4.3.9

* Fix a bug with background images on transparent background slides

### 4.3.8

* Add a contact page to the Gutenberg Admin

### 4.3.7

* Update style and functionality of the Unit Button to match new Gutenberg style

### 4.3.6

* [Add automatic captions](https://gutenslider.org/automatic-photo-captions/)

### 4.3.5

* (re)add slide parallax to pro slider

### 4.3.4

* fix alignment matrix and unique id deprecation bugs

### 4.3.3

* add an unique id to sliders and slides for developers and designers

### 4.3.2

* remove obsolte inspector controls
* update readme

### 4.3.1

* Fix a bug where dots overlay slide content too much

### 4.3.0

* Add new alignment matrix feature
* fix adaptive height + fixed content bug
* fix responsive paddings on small devices bug

### 4.2.2

* Update readme to reflect changes in slider

### 4.2.1

* adaptive height fix in free version

### 4.2.0

* add Auto Height slider option

### 4.1.1

* increase overall speed by minifying slick css and merging into 1 file
* increase page speed score by unloading slick font
* fix automatic video playing on iOS

### 4.1.0

* increase WordPress compatibility to 5.5.1
* fixed 916 vulnerabilities in 1263 node packages
* update vertical alignment toolbar
* fix a bug that made adding two sliders to a page/post impossible
* fix styles
* update gradient picker ( pro )

### 4.0.5

* increase WordPress compatibility to 5.5
* update freemius sdk to 2.4.0

### 4.0.4

* fix dots and arrow enable/disable in free version

### 4.0.3

* update plugin description

### 4.0.2

* Add editor block preview

### 4.0.1

* Remove redundant add slide button from user interface

### 4.0.0

* Add Feature: Focal Point Picker for Background
* Add Feature: Gradient Background (Pro)
* Add Feature: Transparent Background
* Add Feature: Contain Background
* User Interface Improvements
* User Experience Improvements

### 3.0.7

* Undo conditional loading due to complications on different users' themes (will come back to that later, when there is more time for testing)

### 3.0.6

* Improve performance: Only load gutenslider scripts and css if block is used on the page / post. Dramatically improve performance for all pages that do not use the gutenslider block.

### 3.0.5

* Fix a bug that was not displaying buttons on WordPress 5.3

### 3.0.4

* Style fixes for Gutenberg 7.7
* Update deprecated functions

### 3.0.3

* Style fixes for WordPress 5.4

### 3.0.2

* Security: Fix 12 low level vulnerabilities
* Code Quality: update deprecated methods
* increase compatibility for WordPress 5.4

### 3.0.1

* Fix a bug with responsive spacing on fixed content sliders

### 3.0.0

* add responsive controls
* add icons to editor panels
* decrease file size (remove unneeded css)
* restructure code (make more fail safe)
* update all npm dependencies (security++)

### 2.9.5

* fixed a bug introduced in 2.9.4

### 2.9.4

* Improve and remove unused CSS - dont override other slick sliders,

### 2.9.3

* Add a "loop" setting to Gutenslider that allows disabling infinite mode (default: true)

### 2.9.2

* Fix a fatal error when updating Gutenslider

### 2.9.1

* Update the readme to reflect new features
* Update language strings, i18n

### 2.9.0

* improve admin page style and load time
* update freemius version to 2.3.2

### 2.8.11

* Fix an issue with uploads (https://wordpress.org/support/topic/images-are-duplicated-when-uploaded-from-the-gutenslider-block/)

### 2.8.10

* Fix an issue with unit button (https://wordpress.org/support/topic/the-percent-pixel-height-selector-doesnt-work/)

### 2.8.9

* Fix an issue that did not show slides with only video content in the frontend

### 2.8.8

* Update WordPress compatibility to 5.3

### 2.8.7

* Update WordPress compatibility to 5.2.4

### 2.8.6

* Small style bugfixes

### 2.8.5

* Small style bugfixes

### 2.8.5

* Add admin page with tutorials

### 2.8.4

* Increase compliance with WordPress plaugin naming conventions
* Reduce possible interference with other plugins

### 2.8.3

* Update the readme to mirror all updates

### 2.8.2

* Fix a bug with vertical align and refactor code
* Fix a overflow bug in the editor that showed a scrollbar when not needed

### 2.8.1

* Remove left, center, right align

### 2.8.0

* Add vertical align option to the WordPress slider and to carousel slides

### 2.7.0

* Compatibility with cutting edge features in Gutenberg 2.6.0
* added a LICENSE

### 2.6.7

* rewrite of UnitButton Component

### 2.6.6

* possible fix of a recursive error in the react component

### 2.6.5

* increase WordPress compatibility to 5.2.3

### 2.6.4

* add an option that allows to hyperlink your slides

### 2.6.3

* update demo video + small bugfixes
* fixed a bug with the slider height

### 2.6.2

* fix unwanted slider height changes introduced in 2.6.0

### 2.6.1

* fix migration errors that occured in 2.6.0

### 2.6.0

* allow to set fixed slider height in pixels (px) besides the option to set it relatively to the viewport height.

### 2.5.3

* update description
* fix linter errors
* fix error with dragging slides

### 2.5.2

* update description and wrong links

### 2.5.1

* fix an issue that did not allow custom class names

### 2.5.0

* add inner block background color for easier visual grepping

### 2.4.3

* remove blinking of the slider when fade mode is set

### 2.4.2

* Improve fade Transition to fade more smoothly

### 2.4.1

* improve fade transition

### 2.4.0

* make user experience much better by preloading first slide

### 2.3.2

* add slider a background color to show when loading

### 2.3.1

* style fixes
* change default spacing to 30px

### 2.3.0

* add more image sizes to improve page loading speed - recommended plugin: regenerate thumbnails

### 2.2.5

* improve ui and add introduction video

### 2.2.4

* improve ui to show block inserter better

### 2.2.3

* include dashicons on frontend

### 2.2.2

* fix a bug with responsive image preloading

### 2.2.1

* fix a bug with multiple sliders per page

### 2.2.0

* include imagesLoaded for smother sliding

### 2.1.0

* Reorder backend for better user experience
* add arrow styles
* add dot styles
* fix image drop upload
* fix error with old Wordpress Versions without `register_block_type`
* update icons

### 2.0.4

* Increase user experience by fixing an error when dropping files on Gutenslider Block

### 2.0.3

* Enable block alignment left, center, right
* style inner blocks

### 2.0.2

* Style inner blocks

### 2.0.1

* Fix dynamic block frontend

### 2.0.0

* Add sliding content mode
* Make Gutenslider a dynamic block

### 1.1.1

* Update Styles for more default block integration (twitter, soundcloud, spotify, youtube)
* Update Readme

### 1.1.0

* Block Deprecation now works, removed unneeded scripts, smaller size

### 1.0

* First Version

## Visit us 🔗

Visit us on [https://gutenslider.org](https://gutenslider.org) to see a full overview
of features or follow our blog.

## Powered by

Gutenslider is made possible by awesome developers who release their code under reusable licenses. We use the following open source software:

- [swiper](https://swiperjs.com/) ([github](https://github.com/nolimits4web/swiper))
- [lightGallery](https://www.lightgalleryjs.com/) ([github](https://github.com/sachinchoolur/lightGallery))
- [SimpleParallax](https://simpleparallax.com/) ([github](https://github.com/geosigno/simpleParallax))
