/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2023-07-27 09:01:59 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wpeng_aiowps_events` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `event_type` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `username` varchar(150) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `event_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `ip_or_host` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `referer_info` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `country_code` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `event_data` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpeng_aiowps_failed_logins` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `user_login` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `failed_login_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `login_attempt_ip` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7291 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpeng_aiowps_global_meta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `date_time` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `meta_key1` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_key2` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_key3` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_key4` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_key5` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value1` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value2` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value3` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value4` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value5` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`meta_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpeng_aiowps_login_activity` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `user_login` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `login_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `logout_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `login_ip` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `login_country` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `browser_type` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpeng_aiowps_login_lockdown` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `user_login` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `lockdown_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `release_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `failed_login_ip` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `lock_reason` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `unlock_key` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpeng_aiowps_permanent_block` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `blocked_ip` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `block_reason` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `country_origin` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `blocked_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `unblock` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpeng_cf7_vdata` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpeng_cf7_vdata_entry` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cf7_id` int(11) NOT NULL,
  `data_id` int(11) NOT NULL,
  `name` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `value` text COLLATE utf8mb4_unicode_520_ci,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpeng_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpeng_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpeng_db7_forms` (
  `form_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `form_post_id` bigint(20) NOT NULL,
  `form_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `form_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpeng_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `package` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpeng_ewwwio_images` (
  `id` int(14) unsigned NOT NULL AUTO_INCREMENT,
  `attachment_id` bigint(20) unsigned DEFAULT NULL,
  `gallery` varchar(10) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `resize` varchar(75) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `path` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `converted` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `results` varchar(75) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `image_size` int(10) unsigned DEFAULT NULL,
  `orig_size` int(10) unsigned DEFAULT NULL,
  `backup` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `level` int(5) unsigned DEFAULT NULL,
  `pending` tinyint(1) NOT NULL DEFAULT '0',
  `updates` int(5) unsigned DEFAULT NULL,
  `updated` timestamp NOT NULL DEFAULT '1971-01-01 00:00:00' ON UPDATE CURRENT_TIMESTAMP,
  `trace` blob,
  UNIQUE KEY `id` (`id`),
  KEY `path_image_size` (`path`(191),`image_size`),
  KEY `attachment_info` (`gallery`(3),`attachment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpeng_hidemysiteSecure` (
  `id` mediumint(12) NOT NULL AUTO_INCREMENT,
  `ip` text NOT NULL,
  `time` varchar(20) NOT NULL,
  `repeated_fails` varchar(20) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=latin1;

CREATE TABLE `wpeng_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpeng_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=29234 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpeng_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpeng_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpeng_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpeng_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpeng_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpeng_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpeng_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=503 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpeng_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpeng_wfBlockedIPLog` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `countryCode` varchar(2) CHARACTER SET utf8 NOT NULL,
  `blockCount` int(10) unsigned NOT NULL DEFAULT '0',
  `unixday` int(10) unsigned NOT NULL,
  `blockType` varchar(50) CHARACTER SET utf8 NOT NULL DEFAULT 'generic',
  PRIMARY KEY (`IP`,`unixday`,`blockType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpeng_wfBlocks7` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` int(10) unsigned NOT NULL DEFAULT '0',
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `blockedTime` bigint(20) NOT NULL,
  `reason` varchar(255) CHARACTER SET utf8 NOT NULL,
  `lastAttempt` int(10) unsigned DEFAULT '0',
  `blockedHits` int(10) unsigned DEFAULT '0',
  `expiration` bigint(20) unsigned NOT NULL DEFAULT '0',
  `parameters` text CHARACTER SET utf8,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `IP` (`IP`),
  KEY `expiration` (`expiration`)
) ENGINE=InnoDB AUTO_INCREMENT=8286 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpeng_wfConfig` (
  `name` varchar(100) CHARACTER SET utf8 NOT NULL,
  `val` longblob,
  `autoload` enum('no','yes') CHARACTER SET utf8 NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpeng_wfCrawlers` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `patternSig` binary(16) NOT NULL,
  `status` char(8) CHARACTER SET utf8 NOT NULL,
  `lastUpdate` int(10) unsigned NOT NULL,
  `PTR` varchar(255) CHARACTER SET utf8 DEFAULT '',
  PRIMARY KEY (`IP`,`patternSig`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpeng_wfFileChanges` (
  `filenameHash` char(64) CHARACTER SET utf8 NOT NULL,
  `file` varchar(1000) CHARACTER SET utf8 NOT NULL,
  `md5` char(32) CHARACTER SET utf8 NOT NULL,
  PRIMARY KEY (`filenameHash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpeng_wfFileMods` (
  `filenameMD5` binary(16) NOT NULL,
  `filename` varchar(1000) CHARACTER SET utf8 NOT NULL,
  `real_path` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `knownFile` tinyint(3) unsigned NOT NULL,
  `oldMD5` binary(16) NOT NULL,
  `newMD5` binary(16) NOT NULL,
  `SHAC` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `stoppedOnSignature` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `stoppedOnPosition` int(10) unsigned NOT NULL DEFAULT '0',
  `isSafeFile` varchar(1) CHARACTER SET utf8 NOT NULL DEFAULT '?',
  PRIMARY KEY (`filenameMD5`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpeng_wfHits` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `attackLogTime` double(17,6) unsigned NOT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `jsRun` tinyint(4) DEFAULT '0',
  `statusCode` int(11) NOT NULL DEFAULT '200',
  `isGoogle` tinyint(4) NOT NULL,
  `userID` int(10) unsigned NOT NULL,
  `newVisit` tinyint(3) unsigned NOT NULL,
  `URL` text CHARACTER SET utf8,
  `referer` text CHARACTER SET utf8,
  `UA` text CHARACTER SET utf8,
  `action` varchar(64) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `actionDescription` text CHARACTER SET utf8,
  `actionData` text CHARACTER SET utf8,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`IP`,`ctime`),
  KEY `attackLogTime` (`attackLogTime`)
) ENGINE=InnoDB AUTO_INCREMENT=26971 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpeng_wfHoover` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `owner` text CHARACTER SET utf8,
  `host` text CHARACTER SET utf8,
  `path` text CHARACTER SET utf8,
  `hostKey` varbinary(124) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k2` (`hostKey`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpeng_wfIssues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL,
  `lastUpdated` int(10) unsigned NOT NULL,
  `status` varchar(10) CHARACTER SET utf8 NOT NULL,
  `type` varchar(20) CHARACTER SET utf8 NOT NULL,
  `severity` tinyint(3) unsigned NOT NULL,
  `ignoreP` char(32) CHARACTER SET utf8 NOT NULL,
  `ignoreC` char(32) CHARACTER SET utf8 NOT NULL,
  `shortMsg` varchar(255) CHARACTER SET utf8 NOT NULL,
  `longMsg` text CHARACTER SET utf8,
  `data` text CHARACTER SET utf8,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=InnoDB AUTO_INCREMENT=194 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpeng_wfKnownFileList` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `path` text CHARACTER SET utf8 NOT NULL,
  `wordpress_path` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7614 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpeng_wfLiveTrafficHuman` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `identifier` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `expiration` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`,`identifier`),
  KEY `expiration` (`expiration`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpeng_wfLocs` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `ctime` int(10) unsigned NOT NULL,
  `failed` tinyint(3) unsigned NOT NULL,
  `city` varchar(255) CHARACTER SET utf8 DEFAULT '',
  `region` varchar(255) CHARACTER SET utf8 DEFAULT '',
  `countryName` varchar(255) CHARACTER SET utf8 DEFAULT '',
  `countryCode` char(2) CHARACTER SET utf8 DEFAULT '',
  `lat` float(10,7) DEFAULT '0.0000000',
  `lon` float(10,7) DEFAULT '0.0000000',
  PRIMARY KEY (`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpeng_wfLogins` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `hitID` int(11) DEFAULT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `fail` tinyint(3) unsigned NOT NULL,
  `action` varchar(40) CHARACTER SET utf8 NOT NULL,
  `username` varchar(255) CHARACTER SET utf8 NOT NULL,
  `userID` int(10) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `UA` text CHARACTER SET utf8,
  PRIMARY KEY (`id`),
  KEY `k1` (`IP`,`fail`),
  KEY `hitID` (`hitID`)
) ENGINE=InnoDB AUTO_INCREMENT=6618 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpeng_wfNotifications` (
  `id` varchar(32) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `new` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `category` varchar(255) CHARACTER SET utf8 NOT NULL,
  `priority` int(11) NOT NULL DEFAULT '1000',
  `ctime` int(10) unsigned NOT NULL,
  `html` text CHARACTER SET utf8 NOT NULL,
  `links` text CHARACTER SET utf8 NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpeng_wfPendingIssues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL,
  `lastUpdated` int(10) unsigned NOT NULL,
  `status` varchar(10) CHARACTER SET utf8 NOT NULL,
  `type` varchar(20) CHARACTER SET utf8 NOT NULL,
  `severity` tinyint(3) unsigned NOT NULL,
  `ignoreP` char(32) CHARACTER SET utf8 NOT NULL,
  `ignoreC` char(32) CHARACTER SET utf8 NOT NULL,
  `shortMsg` varchar(255) CHARACTER SET utf8 NOT NULL,
  `longMsg` text CHARACTER SET utf8,
  `data` text CHARACTER SET utf8,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpeng_wfReverseCache` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `host` varchar(255) CHARACTER SET utf8 NOT NULL,
  `lastUpdate` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpeng_wfSNIPCache` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `IP` varchar(45) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `expiration` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `body` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `count` int(10) unsigned NOT NULL DEFAULT '0',
  `type` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `expiration` (`expiration`),
  KEY `IP` (`IP`),
  KEY `type` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpeng_wfSecurityEvents` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL DEFAULT '',
  `data` text NOT NULL,
  `event_time` double(14,4) NOT NULL,
  `state` enum('new','sending','sent') NOT NULL DEFAULT 'new',
  `state_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wpeng_wfStatus` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `ctime` double(17,6) unsigned NOT NULL,
  `level` tinyint(3) unsigned NOT NULL,
  `type` char(5) CHARACTER SET utf8 NOT NULL,
  `msg` varchar(1000) CHARACTER SET utf8 NOT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=83717 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpeng_wfTrafficRates` (
  `eMin` int(10) unsigned NOT NULL,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `hitType` enum('hit','404') NOT NULL DEFAULT 'hit',
  `hits` int(10) unsigned NOT NULL,
  PRIMARY KEY (`eMin`,`IP`,`hitType`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wpeng_wfWafFailures` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `throwable` text NOT NULL,
  `rule_id` int(10) unsigned DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wpeng_wfls_2fa_secrets` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `secret` tinyblob NOT NULL,
  `recovery` blob NOT NULL,
  `ctime` int(10) unsigned NOT NULL,
  `vtime` int(10) unsigned NOT NULL,
  `mode` enum('authenticator') NOT NULL DEFAULT 'authenticator',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wpeng_wfls_role_counts` (
  `serialized_roles` varbinary(255) NOT NULL,
  `two_factor_inactive` tinyint(1) NOT NULL,
  `user_count` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`serialized_roles`,`two_factor_inactive`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8;

CREATE TABLE `wpeng_wfls_settings` (
  `name` varchar(191) NOT NULL DEFAULT '',
  `value` longblob,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wpeng_yoast_indexable` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `permalink` longtext COLLATE utf8mb4_unicode_520_ci,
  `permalink_hash` varchar(40) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `object_id` bigint(20) DEFAULT NULL,
  `object_type` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `object_sub_type` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `author_id` bigint(20) DEFAULT NULL,
  `post_parent` bigint(20) DEFAULT NULL,
  `title` text COLLATE utf8mb4_unicode_520_ci,
  `description` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `breadcrumb_title` text COLLATE utf8mb4_unicode_520_ci,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `is_protected` tinyint(1) DEFAULT '0',
  `has_public_posts` tinyint(1) DEFAULT NULL,
  `number_of_pages` int(11) unsigned DEFAULT NULL,
  `canonical` longtext COLLATE utf8mb4_unicode_520_ci,
  `primary_focus_keyword` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `primary_focus_keyword_score` int(3) DEFAULT NULL,
  `readability_score` int(3) DEFAULT NULL,
  `is_cornerstone` tinyint(1) DEFAULT '0',
  `is_robots_noindex` tinyint(1) DEFAULT '0',
  `is_robots_nofollow` tinyint(1) DEFAULT '0',
  `is_robots_noarchive` tinyint(1) DEFAULT '0',
  `is_robots_noimageindex` tinyint(1) DEFAULT '0',
  `is_robots_nosnippet` tinyint(1) DEFAULT '0',
  `twitter_title` text COLLATE utf8mb4_unicode_520_ci,
  `twitter_image` longtext COLLATE utf8mb4_unicode_520_ci,
  `twitter_description` longtext COLLATE utf8mb4_unicode_520_ci,
  `twitter_image_id` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `twitter_image_source` text COLLATE utf8mb4_unicode_520_ci,
  `open_graph_title` text COLLATE utf8mb4_unicode_520_ci,
  `open_graph_description` longtext COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image` longtext COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image_id` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `open_graph_image_source` text COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image_meta` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `link_count` int(11) DEFAULT NULL,
  `incoming_link_count` int(11) DEFAULT NULL,
  `prominent_words_version` int(11) unsigned DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` bigint(20) NOT NULL DEFAULT '1',
  `language` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `region` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schema_page_type` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schema_article_type` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `has_ancestors` tinyint(1) DEFAULT '0',
  `estimated_reading_time_minutes` int(11) DEFAULT NULL,
  `version` int(11) DEFAULT '1',
  `object_last_modified` datetime DEFAULT NULL,
  `object_published_at` datetime DEFAULT NULL,
  `inclusive_language_score` int(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `object_type_and_sub_type` (`object_type`,`object_sub_type`),
  KEY `object_id_and_type` (`object_id`,`object_type`),
  KEY `subpages` (`post_parent`,`object_type`,`post_status`,`object_id`),
  KEY `permalink_hash_and_object_type` (`permalink_hash`,`object_type`),
  KEY `prominent_words` (`prominent_words_version`,`object_type`,`object_sub_type`,`post_status`),
  KEY `published_sitemap_index` (`object_published_at`,`is_robots_noindex`,`object_type`,`object_sub_type`)
) ENGINE=MyISAM AUTO_INCREMENT=75 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpeng_yoast_indexable_hierarchy` (
  `indexable_id` int(11) unsigned NOT NULL DEFAULT '0',
  `ancestor_id` int(11) unsigned NOT NULL DEFAULT '0',
  `depth` int(11) unsigned DEFAULT NULL,
  `blog_id` bigint(20) NOT NULL DEFAULT '1',
  PRIMARY KEY (`indexable_id`,`ancestor_id`),
  KEY `indexable_id` (`indexable_id`),
  KEY `ancestor_id` (`ancestor_id`),
  KEY `depth` (`depth`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpeng_yoast_migrations` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `version` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_wpeng_yoast_migrations_version` (`version`)
) ENGINE=MyISAM AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpeng_yoast_primary_term` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) DEFAULT NULL,
  `term_id` bigint(20) DEFAULT NULL,
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` bigint(20) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `post_taxonomy` (`post_id`,`taxonomy`),
  KEY `post_term` (`post_id`,`term_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpeng_yoast_seo_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_id` bigint(20) unsigned NOT NULL,
  `target_post_id` bigint(20) unsigned NOT NULL,
  `type` varchar(8) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `indexable_id` int(11) unsigned DEFAULT NULL,
  `target_indexable_id` int(11) unsigned DEFAULT NULL,
  `height` int(11) unsigned DEFAULT NULL,
  `width` int(11) unsigned DEFAULT NULL,
  `size` int(11) unsigned DEFAULT NULL,
  `language` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `region` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`),
  KEY `indexable_link_direction` (`indexable_id`,`type`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpeng_yoast_seo_meta` (
  `object_id` bigint(20) unsigned NOT NULL,
  `internal_link_count` int(10) unsigned DEFAULT NULL,
  `incoming_link_count` int(10) unsigned DEFAULT NULL,
  UNIQUE KEY `object_id` (`object_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wpeng_aiowps_failed_logins */
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2287", "1", "digitaladmin", "2021-11-11 02:37:21", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2288", "1", "digitaladmin", "2021-11-11 02:37:22", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2289", "1", "digitaladmin", "2021-11-11 02:37:23", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2290", "1", "digitaladmin", "2021-11-11 02:37:24", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2291", "1", "digitaladmin", "2021-11-11 02:37:25", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2292", "1", "digitaladmin", "2021-11-11 02:37:26", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2293", "1", "digitaladmin", "2021-11-11 02:37:27", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2294", "1", "digitaladmin", "2021-11-11 02:37:28", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2295", "1", "digitaladmin", "2021-11-11 02:37:29", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2296", "1", "digitaladmin", "2021-11-11 02:37:30", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2297", "1", "digitaladmin", "2021-11-11 02:37:31", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2298", "1", "digitaladmin", "2021-11-11 02:37:33", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2299", "1", "digitaladmin", "2021-11-11 02:37:33", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2300", "1", "digitaladmin", "2021-11-11 02:37:34", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2301", "1", "digitaladmin", "2021-11-11 02:37:35", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2302", "1", "digitaladmin", "2021-11-11 02:37:36", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2303", "1", "digitaladmin", "2021-11-11 02:37:37", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2304", "1", "digitaladmin", "2021-11-11 02:37:38", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2305", "1", "digitaladmin", "2021-11-11 02:37:39", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2306", "1", "digitaladmin", "2021-11-11 02:37:40", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2307", "1", "digitaladmin", "2021-11-11 02:37:41", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2308", "1", "digitaladmin", "2021-11-11 02:37:42", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2309", "1", "digitaladmin", "2021-11-11 02:37:43", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2310", "1", "digitaladmin", "2021-11-11 02:37:45", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2311", "1", "digitaladmin", "2021-11-11 02:37:46", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2312", "1", "digitaladmin", "2021-11-11 02:37:47", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2313", "1", "digitaladmin", "2021-11-11 02:37:48", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2314", "1", "digitaladmin", "2021-11-11 02:37:49", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2315", "1", "digitaladmin", "2021-11-11 02:37:50", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2316", "1", "digitaladmin", "2021-11-11 02:37:51", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2317", "1", "digitaladmin", "2021-11-11 02:37:52", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2318", "1", "digitaladmin", "2021-11-11 02:37:53", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2319", "1", "digitaladmin", "2021-11-11 02:37:54", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2320", "1", "digitaladmin", "2021-11-11 02:37:55", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2321", "1", "digitaladmin", "2021-11-11 02:37:56", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2322", "1", "digitaladmin", "2021-11-11 02:37:57", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2323", "1", "digitaladmin", "2021-11-11 02:37:58", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2324", "1", "digitaladmin", "2021-11-11 02:37:59", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2325", "1", "digitaladmin", "2021-11-11 02:38:00", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2326", "1", "digitaladmin", "2021-11-11 02:38:01", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2327", "1", "digitaladmin", "2021-11-11 02:38:02", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2328", "1", "digitaladmin", "2021-11-11 02:38:03", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2329", "1", "digitaladmin", "2021-11-11 02:38:04", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2330", "1", "digitaladmin", "2021-11-11 02:38:05", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2331", "1", "digitaladmin", "2021-11-11 02:38:06", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2332", "1", "digitaladmin", "2021-11-11 02:38:07", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2333", "1", "digitaladmin", "2021-11-11 02:38:08", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2334", "1", "digitaladmin", "2021-11-11 02:38:09", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2335", "1", "digitaladmin", "2021-11-11 02:38:10", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2336", "1", "digitaladmin", "2021-11-11 02:38:11", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2337", "1", "digitaladmin", "2021-11-11 02:38:12", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2338", "1", "digitaladmin", "2021-11-11 02:38:13", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2339", "1", "digitaladmin", "2021-11-11 02:38:14", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2340", "1", "digitaladmin", "2021-11-11 02:38:15", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2341", "1", "digitaladmin", "2021-11-11 02:38:16", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2342", "1", "digitaladmin", "2021-11-11 02:38:17", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2343", "1", "digitaladmin", "2021-11-11 02:38:18", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2344", "1", "digitaladmin", "2021-11-11 02:38:19", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2345", "1", "digitaladmin", "2021-11-11 02:38:21", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2346", "1", "digitaladmin", "2021-11-11 02:38:22", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2347", "1", "digitaladmin", "2021-11-11 02:38:23", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2348", "1", "digitaladmin", "2021-11-11 02:38:24", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2349", "1", "digitaladmin", "2021-11-11 02:38:25", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2350", "1", "digitaladmin", "2021-11-11 02:38:26", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2351", "1", "digitaladmin", "2021-11-11 02:38:27", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2352", "1", "digitaladmin", "2021-11-11 02:38:28", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2353", "1", "digitaladmin", "2021-11-11 02:38:29", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2354", "1", "digitaladmin", "2021-11-11 02:38:30", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2355", "1", "digitaladmin", "2021-11-11 02:38:31", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2356", "1", "digitaladmin", "2021-11-11 02:38:32", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2357", "1", "digitaladmin", "2021-11-11 02:38:33", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2358", "1", "digitaladmin", "2021-11-11 02:38:34", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2359", "1", "digitaladmin", "2021-11-11 02:38:35", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2360", "1", "digitaladmin", "2021-11-11 02:38:36", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2361", "1", "digitaladmin", "2021-11-11 02:38:37", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2362", "1", "digitaladmin", "2021-11-11 02:38:38", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2363", "1", "digitaladmin", "2021-11-11 02:38:39", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2364", "1", "digitaladmin", "2021-11-11 02:38:40", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2365", "1", "digitaladmin", "2021-11-11 02:38:41", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2366", "1", "digitaladmin", "2021-11-11 02:38:42", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2367", "1", "digitaladmin", "2021-11-11 02:38:43", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2368", "1", "digitaladmin", "2021-11-11 02:38:44", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2369", "1", "digitaladmin", "2021-11-11 02:38:45", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2370", "1", "digitaladmin", "2021-11-11 02:38:46", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2371", "1", "digitaladmin", "2021-11-11 02:38:47", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2372", "1", "digitaladmin", "2021-11-11 02:38:48", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2373", "1", "digitaladmin", "2021-11-11 02:38:49", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2374", "1", "digitaladmin", "2021-11-11 02:38:50", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2375", "1", "digitaladmin", "2021-11-11 02:38:51", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2376", "1", "digitaladmin", "2021-11-11 02:38:52", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2377", "1", "digitaladmin", "2021-11-11 02:38:53", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2378", "1", "digitaladmin", "2021-11-11 02:38:54", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2379", "1", "digitaladmin", "2021-11-11 02:38:55", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2380", "1", "digitaladmin", "2021-11-11 02:38:56", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2381", "1", "digitaladmin", "2021-11-11 02:38:57", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2382", "1", "digitaladmin", "2021-11-11 02:38:58", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2383", "1", "digitaladmin", "2021-11-11 02:38:59", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2384", "1", "digitaladmin", "2021-11-11 02:39:00", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2385", "1", "digitaladmin", "2021-11-11 02:39:01", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2386", "1", "digitaladmin", "2021-11-11 02:39:02", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2387", "1", "digitaladmin", "2021-11-11 02:39:03", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2388", "1", "digitaladmin", "2021-11-11 02:39:04", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2389", "1", "digitaladmin", "2021-11-11 02:39:05", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2390", "1", "digitaladmin", "2021-11-11 02:39:06", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2391", "1", "digitaladmin", "2021-11-11 02:39:07", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2392", "1", "digitaladmin", "2021-11-11 02:39:08", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2393", "1", "digitaladmin", "2021-11-11 02:39:09", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2394", "1", "digitaladmin", "2021-11-11 02:39:10", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2395", "1", "digitaladmin", "2021-11-11 02:39:11", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2396", "1", "digitaladmin", "2021-11-11 02:39:12", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2397", "1", "digitaladmin", "2021-11-11 02:39:13", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2398", "1", "digitaladmin", "2021-11-11 02:39:14", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2399", "1", "digitaladmin", "2021-11-11 02:39:15", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2400", "1", "digitaladmin", "2021-11-11 02:39:16", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2401", "1", "digitaladmin", "2021-11-11 02:39:17", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2402", "1", "digitaladmin", "2021-11-11 02:39:18", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2403", "1", "digitaladmin", "2021-11-11 02:39:19", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2404", "1", "digitaladmin", "2021-11-11 02:39:20", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2405", "1", "digitaladmin", "2021-11-11 02:39:21", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2406", "1", "digitaladmin", "2021-11-11 02:39:22", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2407", "1", "digitaladmin", "2021-11-11 02:39:23", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2408", "1", "digitaladmin", "2021-11-11 02:39:24", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2409", "1", "digitaladmin", "2021-11-11 02:39:25", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2410", "1", "digitaladmin", "2021-11-11 02:39:26", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2411", "1", "digitaladmin", "2021-11-11 02:39:27", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2412", "1", "digitaladmin", "2021-11-11 02:39:28", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2413", "1", "digitaladmin", "2021-11-11 02:39:29", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2414", "1", "digitaladmin", "2021-11-11 02:39:30", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2415", "1", "digitaladmin", "2021-11-11 02:39:31", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2416", "1", "digitaladmin", "2021-11-11 02:39:32", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2417", "1", "digitaladmin", "2021-11-11 02:39:33", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2418", "1", "digitaladmin", "2021-11-11 02:39:34", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2419", "1", "digitaladmin", "2021-11-11 02:39:35", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2420", "1", "digitaladmin", "2021-11-11 02:39:36", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2421", "1", "digitaladmin", "2021-11-11 02:39:37", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2422", "1", "digitaladmin", "2021-11-11 02:39:38", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2423", "1", "digitaladmin", "2021-11-11 02:39:39", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2424", "1", "digitaladmin", "2021-11-11 02:39:40", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2425", "1", "digitaladmin", "2021-11-11 02:39:41", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2426", "1", "digitaladmin", "2021-11-11 02:39:42", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2427", "1", "digitaladmin", "2021-11-11 02:39:43", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2428", "1", "digitaladmin", "2021-11-11 02:39:44", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2429", "1", "digitaladmin", "2021-11-11 02:39:45", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2430", "1", "digitaladmin", "2021-11-11 02:39:46", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2431", "1", "digitaladmin", "2021-11-11 02:39:47", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2432", "1", "digitaladmin", "2021-11-11 02:39:48", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2433", "1", "digitaladmin", "2021-11-11 02:39:49", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2434", "1", "digitaladmin", "2021-11-11 02:39:50", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2435", "1", "digitaladmin", "2021-11-11 02:39:51", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2436", "1", "digitaladmin", "2021-11-11 02:39:52", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2437", "1", "digitaladmin", "2021-11-11 02:39:53", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2438", "1", "digitaladmin", "2021-11-11 02:39:54", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2439", "1", "digitaladmin", "2021-11-11 02:39:55", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2440", "1", "digitaladmin", "2021-11-11 02:39:56", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2441", "1", "digitaladmin", "2021-11-11 02:39:57", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2442", "1", "digitaladmin", "2021-11-11 02:39:58", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2443", "1", "digitaladmin", "2021-11-11 02:39:59", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2444", "1", "digitaladmin", "2021-11-11 02:40:00", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2445", "1", "digitaladmin", "2021-11-11 02:40:01", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2446", "1", "digitaladmin", "2021-11-11 02:40:02", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2447", "1", "digitaladmin", "2021-11-11 02:40:04", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2448", "1", "digitaladmin", "2021-11-11 02:40:05", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2449", "1", "digitaladmin", "2021-11-11 02:40:06", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2450", "1", "digitaladmin", "2021-11-11 02:40:07", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2451", "1", "digitaladmin", "2021-11-11 02:40:08", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2452", "1", "digitaladmin", "2021-11-11 02:40:09", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2453", "1", "digitaladmin", "2021-11-11 02:40:10", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2454", "1", "digitaladmin", "2021-11-11 02:40:11", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2455", "1", "digitaladmin", "2021-11-11 02:40:12", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2456", "1", "digitaladmin", "2021-11-11 02:40:13", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2457", "1", "digitaladmin", "2021-11-11 02:40:14", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2458", "1", "digitaladmin", "2021-11-11 02:40:15", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2459", "1", "digitaladmin", "2021-11-11 02:40:16", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2460", "1", "digitaladmin", "2021-11-11 02:40:17", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2461", "1", "digitaladmin", "2021-11-11 02:40:18", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2462", "1", "digitaladmin", "2021-11-11 02:40:20", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2463", "1", "digitaladmin", "2021-11-11 02:40:21", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2464", "1", "digitaladmin", "2021-11-11 02:40:22", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2465", "1", "digitaladmin", "2021-11-11 02:40:23", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2466", "1", "digitaladmin", "2021-11-11 02:40:24", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2467", "1", "digitaladmin", "2021-11-11 02:40:25", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2468", "1", "digitaladmin", "2021-11-11 02:40:26", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2469", "1", "digitaladmin", "2021-11-11 02:40:27", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2470", "1", "digitaladmin", "2021-11-11 02:40:28", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2471", "1", "digitaladmin", "2021-11-11 02:40:29", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2472", "1", "digitaladmin", "2021-11-11 02:40:30", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2473", "1", "digitaladmin", "2021-11-11 02:40:31", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2474", "1", "digitaladmin", "2021-11-11 02:40:32", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2475", "1", "digitaladmin", "2021-11-11 02:40:33", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2476", "1", "digitaladmin", "2021-11-11 02:40:34", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2477", "1", "digitaladmin", "2021-11-11 02:40:35", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2478", "1", "digitaladmin", "2021-11-11 02:40:36", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2479", "1", "digitaladmin", "2021-11-11 02:40:37", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2480", "1", "digitaladmin", "2021-11-11 02:40:38", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2481", "1", "digitaladmin", "2021-11-11 02:40:39", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2482", "1", "digitaladmin", "2021-11-11 02:40:40", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2483", "1", "digitaladmin", "2021-11-11 02:40:41", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2484", "1", "digitaladmin", "2021-11-11 02:40:43", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2485", "1", "digitaladmin", "2021-11-11 02:40:44", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2486", "1", "digitaladmin", "2021-11-11 02:40:45", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2487", "1", "digitaladmin", "2021-11-11 02:40:46", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2488", "1", "digitaladmin", "2021-11-11 02:40:46", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2489", "1", "digitaladmin", "2021-11-11 02:40:48", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2490", "1", "digitaladmin", "2021-11-11 02:40:49", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2491", "1", "digitaladmin", "2021-11-11 02:40:50", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2492", "1", "digitaladmin", "2021-11-11 02:40:51", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2493", "1", "digitaladmin", "2021-11-11 02:40:52", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2494", "1", "digitaladmin", "2021-11-11 02:40:53", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2495", "1", "digitaladmin", "2021-11-11 02:40:54", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2496", "1", "digitaladmin", "2021-11-11 02:40:55", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2497", "1", "digitaladmin", "2021-11-11 02:40:56", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2498", "1", "digitaladmin", "2021-11-11 02:40:57", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2499", "1", "digitaladmin", "2021-11-11 02:40:58", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2500", "1", "digitaladmin", "2021-11-11 02:40:59", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2501", "1", "digitaladmin", "2021-11-11 02:41:00", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2502", "1", "digitaladmin", "2021-11-11 02:41:01", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2503", "1", "digitaladmin", "2021-11-11 02:41:02", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2504", "1", "digitaladmin", "2021-11-11 02:41:03", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2505", "1", "digitaladmin", "2021-11-11 02:41:04", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2506", "1", "digitaladmin", "2021-11-11 02:41:05", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2507", "1", "digitaladmin", "2021-11-11 02:41:06", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2508", "1", "digitaladmin", "2021-11-11 02:41:07", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2509", "1", "digitaladmin", "2021-11-11 02:41:08", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2510", "1", "digitaladmin", "2021-11-11 02:41:09", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2511", "1", "digitaladmin", "2021-11-11 02:41:10", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2512", "1", "digitaladmin", "2021-11-11 02:41:11", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2513", "1", "digitaladmin", "2021-11-11 02:41:12", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2514", "1", "digitaladmin", "2021-11-11 02:41:13", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2515", "1", "digitaladmin", "2021-11-11 02:41:14", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2516", "1", "digitaladmin", "2021-11-11 02:41:15", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2517", "1", "digitaladmin", "2021-11-11 02:41:16", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2518", "1", "digitaladmin", "2021-11-11 02:41:17", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2519", "1", "digitaladmin", "2021-11-11 02:41:18", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2520", "1", "digitaladmin", "2021-11-11 02:41:19", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2521", "1", "digitaladmin", "2021-11-11 02:41:20", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2522", "1", "digitaladmin", "2021-11-11 02:41:21", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2523", "1", "digitaladmin", "2021-11-11 02:41:22", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2524", "1", "digitaladmin", "2021-11-11 02:41:23", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2525", "1", "digitaladmin", "2021-11-11 02:41:24", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2526", "1", "digitaladmin", "2021-11-11 02:41:25", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2527", "1", "digitaladmin", "2021-11-11 02:41:26", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2528", "1", "digitaladmin", "2021-11-11 02:41:27", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2529", "1", "digitaladmin", "2021-11-11 02:41:28", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2530", "1", "digitaladmin", "2021-11-11 02:41:29", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2531", "1", "digitaladmin", "2021-11-11 02:41:30", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2532", "1", "digitaladmin", "2021-11-11 02:41:31", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2533", "1", "digitaladmin", "2021-11-11 02:41:32", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2534", "1", "digitaladmin", "2021-11-11 02:41:33", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2535", "1", "digitaladmin", "2021-11-11 02:41:34", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2536", "1", "digitaladmin", "2021-11-11 02:41:35", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2537", "1", "digitaladmin", "2021-11-11 02:41:36", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2538", "1", "digitaladmin", "2021-11-11 02:41:37", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2539", "1", "digitaladmin", "2021-11-11 02:41:38", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2540", "1", "digitaladmin", "2021-11-11 02:41:39", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2541", "1", "digitaladmin", "2021-11-11 02:41:40", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2542", "1", "digitaladmin", "2021-11-11 02:41:41", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2543", "1", "digitaladmin", "2021-11-11 02:41:42", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2544", "1", "digitaladmin", "2021-11-11 02:41:43", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2545", "1", "digitaladmin", "2021-11-11 02:41:44", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2546", "1", "digitaladmin", "2021-11-11 02:41:45", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2547", "1", "digitaladmin", "2021-11-11 02:41:46", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2548", "1", "digitaladmin", "2021-11-11 02:41:47", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2549", "1", "digitaladmin", "2021-11-11 02:41:47", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2550", "1", "digitaladmin", "2021-11-11 02:41:48", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2551", "1", "digitaladmin", "2021-11-11 02:41:49", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2552", "1", "digitaladmin", "2021-11-11 02:41:50", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2553", "1", "digitaladmin", "2021-11-11 02:41:51", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2554", "1", "digitaladmin", "2021-11-11 02:41:52", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2555", "1", "digitaladmin", "2021-11-11 02:41:53", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2556", "1", "digitaladmin", "2021-11-11 02:41:54", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2557", "1", "digitaladmin", "2021-11-11 02:41:55", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2558", "1", "digitaladmin", "2021-11-11 02:41:56", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2559", "1", "digitaladmin", "2021-11-11 02:41:57", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2560", "1", "digitaladmin", "2021-11-11 02:41:58", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2561", "1", "digitaladmin", "2021-11-11 02:41:59", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2562", "1", "digitaladmin", "2021-11-11 02:42:00", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2563", "1", "digitaladmin", "2021-11-11 02:42:01", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2564", "1", "digitaladmin", "2021-11-11 02:42:02", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2565", "1", "digitaladmin", "2021-11-11 02:42:03", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2566", "1", "digitaladmin", "2021-11-11 02:42:04", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2567", "1", "digitaladmin", "2021-11-11 02:42:05", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2568", "1", "digitaladmin", "2021-11-11 02:42:06", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2569", "1", "digitaladmin", "2021-11-11 02:42:07", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2570", "1", "digitaladmin", "2021-11-11 02:42:08", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2571", "1", "digitaladmin", "2021-11-11 02:42:09", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2572", "1", "digitaladmin", "2021-11-11 02:42:10", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2573", "1", "digitaladmin", "2021-11-11 02:42:11", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2574", "1", "digitaladmin", "2021-11-11 02:42:12", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2575", "1", "digitaladmin", "2021-11-11 02:42:13", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2576", "1", "digitaladmin", "2021-11-11 02:42:14", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2577", "1", "digitaladmin", "2021-11-11 02:42:15", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2578", "1", "digitaladmin", "2021-11-11 02:42:16", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2579", "1", "digitaladmin", "2021-11-11 02:42:17", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2580", "1", "digitaladmin", "2021-11-11 02:42:18", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2581", "1", "digitaladmin", "2021-11-11 02:42:19", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2582", "1", "digitaladmin", "2021-11-11 02:42:20", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2583", "1", "digitaladmin", "2021-11-11 02:42:20", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2584", "1", "digitaladmin", "2021-11-11 02:42:22", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2585", "1", "digitaladmin", "2021-11-11 02:42:22", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2586", "1", "digitaladmin", "2021-11-11 02:42:23", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2587", "1", "digitaladmin", "2021-11-11 02:42:25", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2588", "1", "digitaladmin", "2021-11-11 02:42:26", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2589", "1", "digitaladmin", "2021-11-11 02:42:27", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2590", "1", "digitaladmin", "2021-11-11 02:42:28", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2591", "1", "digitaladmin", "2021-11-11 02:42:29", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2592", "1", "digitaladmin", "2021-11-11 02:42:30", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2593", "1", "digitaladmin", "2021-11-11 02:42:31", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2594", "1", "digitaladmin", "2021-11-11 02:42:32", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2595", "1", "digitaladmin", "2021-11-11 02:42:33", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2596", "1", "digitaladmin", "2021-11-11 02:42:34", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2597", "1", "digitaladmin", "2021-11-11 02:42:35", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2598", "1", "digitaladmin", "2021-11-11 02:42:36", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2599", "1", "digitaladmin", "2021-11-11 02:42:37", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2600", "1", "digitaladmin", "2021-11-11 02:42:38", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2601", "1", "digitaladmin", "2021-11-11 02:42:39", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2602", "1", "digitaladmin", "2021-11-11 02:42:40", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2603", "1", "digitaladmin", "2021-11-11 02:42:41", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2604", "1", "digitaladmin", "2021-11-11 02:42:42", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2605", "1", "digitaladmin", "2021-11-11 02:42:43", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2606", "1", "digitaladmin", "2021-11-11 02:42:44", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2607", "1", "digitaladmin", "2021-11-11 02:42:45", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2608", "1", "digitaladmin", "2021-11-11 02:42:46", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2609", "1", "digitaladmin", "2021-11-11 02:42:47", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2610", "1", "digitaladmin", "2021-11-11 02:42:48", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2611", "1", "digitaladmin", "2021-11-11 02:42:49", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2612", "1", "digitaladmin", "2021-11-11 02:42:50", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2613", "1", "digitaladmin", "2021-11-11 02:42:51", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2614", "1", "digitaladmin", "2021-11-11 02:42:52", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2615", "1", "digitaladmin", "2021-11-11 02:42:53", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2616", "1", "digitaladmin", "2021-11-11 02:42:54", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2617", "1", "digitaladmin", "2021-11-11 02:42:55", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2618", "1", "digitaladmin", "2021-11-11 02:42:56", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2619", "1", "digitaladmin", "2021-11-11 02:42:57", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2620", "1", "digitaladmin", "2021-11-11 02:42:58", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2621", "1", "digitaladmin", "2021-11-11 02:42:59", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2622", "1", "digitaladmin", "2021-11-11 02:43:00", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2623", "1", "digitaladmin", "2021-11-11 02:43:01", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2624", "1", "digitaladmin", "2021-11-11 02:43:02", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2625", "1", "digitaladmin", "2021-11-11 02:43:03", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2626", "1", "digitaladmin", "2021-11-11 02:43:04", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2627", "1", "digitaladmin", "2021-11-11 02:43:05", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2628", "1", "digitaladmin", "2021-11-11 02:43:06", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2629", "1", "digitaladmin", "2021-11-11 02:43:07", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2630", "1", "digitaladmin", "2021-11-11 02:43:08", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2631", "1", "digitaladmin", "2021-11-11 02:43:09", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2632", "1", "digitaladmin", "2021-11-11 02:43:10", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2633", "1", "digitaladmin", "2021-11-11 02:43:11", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2634", "1", "digitaladmin", "2021-11-11 02:43:12", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2635", "1", "digitaladmin", "2021-11-11 02:43:13", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2636", "1", "digitaladmin", "2021-11-11 02:43:14", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2637", "1", "digitaladmin", "2021-11-11 02:43:16", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2638", "1", "digitaladmin", "2021-11-11 02:43:17", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2639", "1", "digitaladmin", "2021-11-11 02:43:18", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2640", "1", "digitaladmin", "2021-11-11 02:43:19", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2641", "1", "digitaladmin", "2021-11-11 02:43:20", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2642", "1", "digitaladmin", "2021-11-11 02:43:20", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2643", "1", "digitaladmin", "2021-11-11 02:43:21", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2644", "1", "digitaladmin", "2021-11-11 02:43:22", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2645", "1", "digitaladmin", "2021-11-11 02:43:23", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2646", "1", "digitaladmin", "2021-11-11 02:43:24", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2647", "1", "digitaladmin", "2021-11-11 02:43:25", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2648", "1", "digitaladmin", "2021-11-11 02:43:26", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2649", "1", "digitaladmin", "2021-11-11 02:43:28", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2650", "1", "digitaladmin", "2021-11-11 02:43:29", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2651", "1", "digitaladmin", "2021-11-11 02:43:30", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2652", "1", "digitaladmin", "2021-11-11 02:43:31", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2653", "1", "digitaladmin", "2021-11-11 02:43:32", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2654", "1", "digitaladmin", "2021-11-11 02:43:33", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2655", "1", "digitaladmin", "2021-11-11 02:43:34", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2656", "1", "digitaladmin", "2021-11-11 02:43:35", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2657", "1", "digitaladmin", "2021-11-11 02:43:36", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2658", "1", "digitaladmin", "2021-11-11 02:43:37", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2659", "1", "digitaladmin", "2021-11-11 02:43:38", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2660", "1", "digitaladmin", "2021-11-11 02:43:39", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2661", "1", "digitaladmin", "2021-11-11 02:43:40", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2662", "1", "digitaladmin", "2021-11-11 02:43:41", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2663", "1", "digitaladmin", "2021-11-11 02:43:42", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2664", "1", "digitaladmin", "2021-11-11 02:43:43", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2665", "1", "digitaladmin", "2021-11-11 02:43:44", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2666", "1", "digitaladmin", "2021-11-11 02:43:45", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2667", "1", "digitaladmin", "2021-11-11 02:43:46", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2668", "1", "digitaladmin", "2021-11-11 02:43:47", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2669", "1", "digitaladmin", "2021-11-11 02:43:48", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2670", "1", "digitaladmin", "2021-11-11 02:43:49", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2671", "1", "digitaladmin", "2021-11-11 02:43:50", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2672", "1", "digitaladmin", "2021-11-11 02:43:51", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2673", "1", "digitaladmin", "2021-11-11 02:43:52", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2674", "1", "digitaladmin", "2021-11-11 02:43:53", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2675", "1", "digitaladmin", "2021-11-11 02:43:54", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2676", "1", "digitaladmin", "2021-11-11 02:43:55", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2677", "1", "digitaladmin", "2021-11-11 02:43:56", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2678", "1", "digitaladmin", "2021-11-11 02:43:57", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2679", "1", "digitaladmin", "2021-11-11 02:43:58", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2680", "1", "digitaladmin", "2021-11-11 02:44:00", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2681", "1", "digitaladmin", "2021-11-11 02:44:01", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2682", "1", "digitaladmin", "2021-11-11 02:44:02", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2683", "1", "digitaladmin", "2021-11-11 02:44:03", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2684", "1", "digitaladmin", "2021-11-11 02:44:04", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2685", "1", "digitaladmin", "2021-11-11 02:44:05", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2686", "1", "digitaladmin", "2021-11-11 02:44:06", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2687", "1", "digitaladmin", "2021-11-11 02:44:07", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2688", "1", "digitaladmin", "2021-11-11 02:44:08", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2689", "1", "digitaladmin", "2021-11-11 02:44:09", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2690", "1", "digitaladmin", "2021-11-11 02:44:10", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2691", "1", "digitaladmin", "2021-11-11 02:44:11", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2692", "1", "digitaladmin", "2021-11-11 02:44:12", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2693", "1", "digitaladmin", "2021-11-11 02:44:14", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2694", "1", "digitaladmin", "2021-11-11 02:44:15", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2695", "1", "digitaladmin", "2021-11-11 02:44:16", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2696", "1", "digitaladmin", "2021-11-11 02:44:17", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2697", "1", "digitaladmin", "2021-11-11 02:44:18", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2698", "1", "digitaladmin", "2021-11-11 02:44:19", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2699", "1", "digitaladmin", "2021-11-11 02:44:20", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2700", "1", "digitaladmin", "2021-11-11 02:44:21", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2701", "1", "digitaladmin", "2021-11-11 02:44:22", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2702", "1", "digitaladmin", "2021-11-11 02:44:23", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2703", "1", "digitaladmin", "2021-11-11 02:44:24", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2704", "1", "digitaladmin", "2021-11-11 02:44:25", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2705", "1", "digitaladmin", "2021-11-11 02:44:26", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2706", "1", "digitaladmin", "2021-11-11 02:44:27", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2707", "1", "digitaladmin", "2021-11-11 02:44:28", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2708", "1", "digitaladmin", "2021-11-11 02:44:29", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2709", "1", "digitaladmin", "2021-11-11 02:44:30", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2710", "1", "digitaladmin", "2021-11-11 02:44:31", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2711", "1", "digitaladmin", "2021-11-11 02:44:32", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2712", "1", "digitaladmin", "2021-11-11 02:44:33", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2713", "1", "digitaladmin", "2021-11-11 02:44:34", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2714", "1", "digitaladmin", "2021-11-11 02:44:35", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2715", "1", "digitaladmin", "2021-11-11 02:44:36", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2716", "1", "digitaladmin", "2021-11-11 02:44:37", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2717", "1", "digitaladmin", "2021-11-11 02:44:39", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2718", "1", "digitaladmin", "2021-11-11 02:44:40", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2719", "1", "digitaladmin", "2021-11-11 02:44:41", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2720", "1", "digitaladmin", "2021-11-11 02:44:42", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2721", "1", "digitaladmin", "2021-11-11 02:44:43", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2722", "1", "digitaladmin", "2021-11-11 02:44:44", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2723", "1", "digitaladmin", "2021-11-11 02:44:45", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2724", "1", "digitaladmin", "2021-11-11 02:44:46", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2725", "1", "digitaladmin", "2021-11-11 02:44:47", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2726", "1", "digitaladmin", "2021-11-11 02:44:48", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2727", "1", "digitaladmin", "2021-11-11 02:44:49", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2728", "1", "digitaladmin", "2021-11-11 02:44:50", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2729", "1", "digitaladmin", "2021-11-11 02:44:51", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2730", "1", "digitaladmin", "2021-11-11 02:44:52", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2731", "1", "digitaladmin", "2021-11-11 02:44:53", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2732", "1", "digitaladmin", "2021-11-11 02:44:54", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2733", "1", "digitaladmin", "2021-11-11 02:44:55", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2734", "1", "digitaladmin", "2021-11-11 02:44:56", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2735", "1", "digitaladmin", "2021-11-11 02:44:57", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2736", "1", "digitaladmin", "2021-11-11 02:44:58", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2737", "1", "digitaladmin", "2021-11-11 02:44:59", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2738", "1", "digitaladmin", "2021-11-11 02:45:00", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2739", "1", "digitaladmin", "2021-11-11 02:45:01", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2740", "1", "digitaladmin", "2021-11-11 02:45:03", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2741", "1", "digitaladmin", "2021-11-11 02:45:04", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2742", "1", "digitaladmin", "2021-11-11 02:45:05", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2743", "1", "digitaladmin", "2021-11-11 02:45:06", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2744", "1", "digitaladmin", "2021-11-11 02:45:07", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2745", "1", "digitaladmin", "2021-11-11 02:45:08", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2746", "1", "digitaladmin", "2021-11-11 02:45:09", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2747", "1", "digitaladmin", "2021-11-11 02:45:10", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2748", "1", "digitaladmin", "2021-11-11 02:45:11", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2749", "1", "digitaladmin", "2021-11-11 02:45:12", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2750", "1", "digitaladmin", "2021-11-11 02:45:14", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2751", "1", "digitaladmin", "2021-11-11 02:45:15", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2752", "1", "digitaladmin", "2021-11-11 02:45:16", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2753", "1", "digitaladmin", "2021-11-11 02:45:17", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2754", "1", "digitaladmin", "2021-11-11 02:45:18", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2755", "1", "digitaladmin", "2021-11-11 02:45:19", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2756", "1", "digitaladmin", "2021-11-11 02:45:20", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2757", "1", "digitaladmin", "2021-11-11 02:45:21", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2758", "1", "digitaladmin", "2021-11-11 02:45:22", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2759", "1", "digitaladmin", "2021-11-11 02:45:23", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2760", "1", "digitaladmin", "2021-11-11 02:45:24", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2761", "1", "digitaladmin", "2021-11-11 02:45:25", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2762", "1", "digitaladmin", "2021-11-11 02:45:26", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2763", "1", "digitaladmin", "2021-11-11 02:45:27", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2764", "1", "digitaladmin", "2021-11-11 02:45:28", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2765", "1", "digitaladmin", "2021-11-11 02:45:29", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2766", "1", "digitaladmin", "2021-11-11 02:45:30", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2767", "1", "digitaladmin", "2021-11-11 02:45:31", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2768", "1", "digitaladmin", "2021-11-11 02:45:32", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2769", "1", "digitaladmin", "2021-11-11 02:45:33", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2770", "1", "digitaladmin", "2021-11-11 02:45:34", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2771", "1", "digitaladmin", "2021-11-11 02:45:35", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2772", "1", "digitaladmin", "2021-11-11 02:45:36", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2773", "1", "digitaladmin", "2021-11-11 02:45:37", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2774", "1", "digitaladmin", "2021-11-11 02:45:38", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2775", "1", "digitaladmin", "2021-11-11 02:45:39", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2776", "1", "digitaladmin", "2021-11-11 02:45:40", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2777", "1", "digitaladmin", "2021-11-11 02:45:41", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2778", "1", "digitaladmin", "2021-11-11 02:45:42", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2779", "1", "digitaladmin", "2021-11-11 02:45:43", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2780", "1", "digitaladmin", "2021-11-11 02:45:44", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2781", "1", "digitaladmin", "2021-11-11 02:45:45", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2782", "1", "digitaladmin", "2021-11-11 02:45:46", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2783", "1", "digitaladmin", "2021-11-11 02:45:47", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2784", "1", "digitaladmin", "2021-11-11 02:45:48", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2785", "1", "digitaladmin", "2021-11-11 02:45:49", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2786", "1", "digitaladmin", "2021-11-11 02:45:50", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2787", "1", "digitaladmin", "2021-11-11 02:45:51", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2788", "1", "digitaladmin", "2021-11-11 02:45:52", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2789", "1", "digitaladmin", "2021-11-11 02:45:53", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2790", "1", "digitaladmin", "2021-11-11 02:45:54", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2791", "1", "digitaladmin", "2021-11-11 02:45:55", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2792", "1", "digitaladmin", "2021-11-11 02:45:56", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2793", "1", "digitaladmin", "2021-11-11 02:45:57", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2794", "1", "digitaladmin", "2021-11-11 02:45:58", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2795", "1", "digitaladmin", "2021-11-11 02:45:59", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2796", "1", "digitaladmin", "2021-11-11 02:46:00", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2797", "1", "digitaladmin", "2021-11-11 02:46:01", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2798", "1", "digitaladmin", "2021-11-11 02:46:02", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2799", "1", "digitaladmin", "2021-11-11 02:46:03", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2800", "1", "digitaladmin", "2021-11-11 02:46:04", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2801", "1", "digitaladmin", "2021-11-11 02:46:05", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2802", "1", "digitaladmin", "2021-11-11 02:46:06", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2803", "1", "digitaladmin", "2021-11-11 02:46:06", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2804", "1", "digitaladmin", "2021-11-11 02:46:07", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2805", "1", "digitaladmin", "2021-11-11 02:46:08", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2806", "1", "digitaladmin", "2021-11-11 02:46:09", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2807", "1", "digitaladmin", "2021-11-11 02:46:10", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2808", "1", "digitaladmin", "2021-11-11 02:46:11", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2809", "1", "digitaladmin", "2021-11-11 02:46:12", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2810", "1", "digitaladmin", "2021-11-11 02:46:13", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2811", "1", "digitaladmin", "2021-11-11 02:46:14", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2812", "1", "digitaladmin", "2021-11-11 02:46:15", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2813", "1", "digitaladmin", "2021-11-11 02:46:16", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2814", "1", "digitaladmin", "2021-11-11 02:46:17", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2815", "1", "digitaladmin", "2021-11-11 02:46:18", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2816", "1", "digitaladmin", "2021-11-11 02:46:19", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2817", "1", "digitaladmin", "2021-11-11 02:46:20", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2818", "1", "digitaladmin", "2021-11-11 02:46:21", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2819", "1", "digitaladmin", "2021-11-11 02:46:22", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2820", "1", "digitaladmin", "2021-11-11 02:46:23", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2821", "1", "digitaladmin", "2021-11-11 02:46:24", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2822", "1", "digitaladmin", "2021-11-11 02:46:25", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2823", "1", "digitaladmin", "2021-11-11 02:46:26", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2824", "1", "digitaladmin", "2021-11-11 02:46:27", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2825", "1", "digitaladmin", "2021-11-11 02:46:28", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2826", "1", "digitaladmin", "2021-11-11 02:46:29", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2827", "1", "digitaladmin", "2021-11-11 02:46:30", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2828", "1", "digitaladmin", "2021-11-11 02:46:31", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2829", "1", "digitaladmin", "2021-11-11 02:46:32", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2830", "1", "digitaladmin", "2021-11-11 02:46:33", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2831", "1", "digitaladmin", "2021-11-11 02:46:34", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2832", "1", "digitaladmin", "2021-11-11 02:46:35", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2833", "1", "digitaladmin", "2021-11-11 02:46:36", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2834", "1", "digitaladmin", "2021-11-11 02:46:38", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2835", "1", "digitaladmin", "2021-11-11 02:46:39", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2836", "1", "digitaladmin", "2021-11-11 02:46:40", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2837", "1", "digitaladmin", "2021-11-11 02:46:41", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2838", "1", "digitaladmin", "2021-11-11 02:46:41", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2839", "1", "digitaladmin", "2021-11-11 02:46:42", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2840", "1", "digitaladmin", "2021-11-11 02:46:43", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2841", "1", "digitaladmin", "2021-11-11 02:46:44", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2842", "1", "digitaladmin", "2021-11-11 02:46:45", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2843", "1", "digitaladmin", "2021-11-11 02:46:46", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2844", "1", "digitaladmin", "2021-11-11 02:46:47", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2845", "1", "digitaladmin", "2021-11-11 02:46:48", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2846", "1", "digitaladmin", "2021-11-11 02:46:49", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2847", "1", "digitaladmin", "2021-11-11 02:46:50", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2848", "1", "digitaladmin", "2021-11-11 02:46:51", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2849", "1", "digitaladmin", "2021-11-11 02:46:52", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2850", "1", "digitaladmin", "2021-11-11 02:46:53", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2851", "1", "digitaladmin", "2021-11-11 02:46:54", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2852", "1", "digitaladmin", "2021-11-11 02:46:55", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2853", "1", "digitaladmin", "2021-11-11 02:46:56", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2854", "1", "digitaladmin", "2021-11-11 02:46:57", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2855", "1", "digitaladmin", "2021-11-11 02:46:58", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2856", "1", "digitaladmin", "2021-11-11 02:46:59", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2857", "1", "digitaladmin", "2021-11-11 02:47:00", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2858", "1", "digitaladmin", "2021-11-11 02:47:01", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2859", "1", "digitaladmin", "2021-11-11 02:47:02", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2860", "1", "digitaladmin", "2021-11-11 02:47:03", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2861", "1", "digitaladmin", "2021-11-11 02:47:04", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2862", "1", "digitaladmin", "2021-11-11 02:47:05", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2863", "1", "digitaladmin", "2021-11-11 02:47:06", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2864", "1", "digitaladmin", "2021-11-11 02:47:07", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2865", "1", "digitaladmin", "2021-11-11 02:47:08", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2866", "1", "digitaladmin", "2021-11-11 02:47:09", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2867", "1", "digitaladmin", "2021-11-11 02:47:10", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2868", "1", "digitaladmin", "2021-11-11 02:47:11", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2869", "1", "digitaladmin", "2021-11-11 02:47:12", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2870", "1", "digitaladmin", "2021-11-11 02:47:13", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2871", "1", "digitaladmin", "2021-11-11 02:47:14", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2872", "1", "digitaladmin", "2021-11-11 02:47:15", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2873", "1", "digitaladmin", "2021-11-11 02:47:16", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2874", "1", "digitaladmin", "2021-11-11 02:47:17", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2875", "1", "digitaladmin", "2021-11-11 02:47:18", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2876", "1", "digitaladmin", "2021-11-11 02:47:19", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2877", "1", "digitaladmin", "2021-11-11 02:47:20", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2878", "1", "digitaladmin", "2021-11-11 02:47:21", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2879", "1", "digitaladmin", "2021-11-11 02:47:22", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2880", "1", "digitaladmin", "2021-11-11 02:47:23", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2881", "1", "digitaladmin", "2021-11-11 02:47:24", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2882", "1", "digitaladmin", "2021-11-11 02:47:25", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2883", "1", "digitaladmin", "2021-11-11 02:47:26", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2884", "1", "digitaladmin", "2021-11-11 02:47:27", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2885", "1", "digitaladmin", "2021-11-11 02:47:28", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2886", "1", "digitaladmin", "2021-11-11 02:47:29", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2887", "1", "digitaladmin", "2021-11-11 02:47:30", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2888", "1", "digitaladmin", "2021-11-11 02:47:31", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2889", "1", "digitaladmin", "2021-11-11 02:47:32", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2890", "1", "digitaladmin", "2021-11-11 02:47:33", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2891", "1", "digitaladmin", "2021-11-11 02:47:34", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2892", "1", "digitaladmin", "2021-11-11 02:47:35", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2893", "1", "digitaladmin", "2021-11-11 02:47:36", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2894", "1", "digitaladmin", "2021-11-11 02:47:37", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2895", "1", "digitaladmin", "2021-11-11 02:47:38", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2896", "1", "digitaladmin", "2021-11-11 02:47:39", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2897", "1", "digitaladmin", "2021-11-11 02:47:40", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2898", "1", "digitaladmin", "2021-11-11 02:47:41", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2899", "1", "digitaladmin", "2021-11-11 02:47:42", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2900", "1", "digitaladmin", "2021-11-11 02:47:43", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2901", "1", "digitaladmin", "2021-11-11 02:47:44", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2902", "1", "digitaladmin", "2021-11-11 02:47:45", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2903", "1", "digitaladmin", "2021-11-11 02:47:46", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2904", "1", "digitaladmin", "2021-11-11 02:47:47", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2905", "1", "digitaladmin", "2021-11-11 02:47:48", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2906", "1", "digitaladmin", "2021-11-11 02:47:49", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2907", "1", "digitaladmin", "2021-11-11 02:47:50", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2908", "1", "digitaladmin", "2021-11-11 02:47:51", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2909", "1", "digitaladmin", "2021-11-11 02:47:52", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2910", "1", "digitaladmin", "2021-11-11 02:47:53", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2911", "1", "digitaladmin", "2021-11-11 02:47:54", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2912", "1", "digitaladmin", "2021-11-11 02:47:55", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2913", "1", "digitaladmin", "2021-11-11 02:47:56", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2914", "1", "digitaladmin", "2021-11-11 02:47:57", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2915", "1", "digitaladmin", "2021-11-11 02:47:58", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2916", "1", "digitaladmin", "2021-11-11 02:47:59", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2917", "1", "digitaladmin", "2021-11-11 02:48:00", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2918", "1", "digitaladmin", "2021-11-11 02:48:01", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2919", "1", "digitaladmin", "2021-11-11 02:48:02", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2920", "1", "digitaladmin", "2021-11-11 02:48:03", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2921", "1", "digitaladmin", "2021-11-11 02:48:04", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2922", "1", "digitaladmin", "2021-11-11 02:48:05", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2923", "1", "digitaladmin", "2021-11-11 02:48:06", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2924", "1", "digitaladmin", "2021-11-11 02:48:07", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2925", "1", "digitaladmin", "2021-11-11 02:48:08", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2926", "1", "digitaladmin", "2021-11-11 02:48:09", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2927", "1", "digitaladmin", "2021-11-11 02:48:10", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2928", "1", "digitaladmin", "2021-11-11 02:48:11", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2929", "1", "digitaladmin", "2021-11-11 02:48:12", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2930", "1", "digitaladmin", "2021-11-11 02:48:13", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2931", "1", "digitaladmin", "2021-11-11 02:48:14", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2932", "1", "digitaladmin", "2021-11-11 02:48:15", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2933", "1", "digitaladmin", "2021-11-11 02:48:16", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2934", "1", "digitaladmin", "2021-11-11 02:48:17", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2935", "1", "digitaladmin", "2021-11-11 02:48:18", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2936", "1", "digitaladmin", "2021-11-11 02:48:19", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2937", "1", "digitaladmin", "2021-11-11 02:48:20", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2938", "1", "digitaladmin", "2021-11-11 02:48:21", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2939", "1", "digitaladmin", "2021-11-11 02:48:22", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2940", "1", "digitaladmin", "2021-11-11 02:48:23", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2941", "1", "digitaladmin", "2021-11-11 02:48:24", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2942", "1", "digitaladmin", "2021-11-11 02:48:24", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2943", "1", "digitaladmin", "2021-11-11 02:48:25", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2944", "1", "digitaladmin", "2021-11-11 02:48:26", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2945", "1", "digitaladmin", "2021-11-11 02:48:27", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2946", "1", "digitaladmin", "2021-11-11 02:48:29", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2947", "1", "digitaladmin", "2021-11-11 02:48:29", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2948", "1", "digitaladmin", "2021-11-11 02:48:30", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2949", "1", "digitaladmin", "2021-11-11 02:48:31", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2950", "1", "digitaladmin", "2021-11-11 02:48:32", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2951", "1", "digitaladmin", "2021-11-11 02:48:33", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2952", "1", "digitaladmin", "2021-11-11 02:48:35", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2953", "1", "digitaladmin", "2021-11-11 02:48:36", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2954", "1", "digitaladmin", "2021-11-11 02:48:37", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2955", "1", "digitaladmin", "2021-11-11 02:48:37", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2956", "1", "digitaladmin", "2021-11-11 02:48:38", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2957", "1", "digitaladmin", "2021-11-11 02:48:39", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2958", "1", "digitaladmin", "2021-11-11 02:48:40", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2959", "1", "digitaladmin", "2021-11-11 02:48:41", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2960", "1", "digitaladmin", "2021-11-11 02:48:42", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2961", "1", "digitaladmin", "2021-11-11 02:48:43", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2962", "1", "digitaladmin", "2021-11-11 02:48:44", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2963", "1", "digitaladmin", "2021-11-11 02:48:45", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2964", "1", "digitaladmin", "2021-11-11 02:48:46", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2965", "1", "digitaladmin", "2021-11-11 02:48:47", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2966", "1", "digitaladmin", "2021-11-11 02:48:48", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2967", "1", "digitaladmin", "2021-11-11 02:48:49", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2968", "1", "digitaladmin", "2021-11-11 02:48:50", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2969", "1", "digitaladmin", "2021-11-11 02:48:51", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2970", "1", "digitaladmin", "2021-11-11 02:48:53", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2971", "1", "digitaladmin", "2021-11-11 02:48:54", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2972", "1", "digitaladmin", "2021-11-11 02:48:55", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2973", "1", "digitaladmin", "2021-11-11 02:48:56", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2974", "1", "digitaladmin", "2021-11-11 02:48:57", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2975", "1", "digitaladmin", "2021-11-11 02:48:58", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2976", "1", "digitaladmin", "2021-11-11 02:48:59", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2977", "1", "digitaladmin", "2021-11-11 02:49:00", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2978", "1", "digitaladmin", "2021-11-11 02:49:01", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2979", "1", "digitaladmin", "2021-11-11 02:49:02", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2980", "1", "digitaladmin", "2021-11-11 02:49:03", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2981", "1", "digitaladmin", "2021-11-11 02:49:04", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2982", "1", "digitaladmin", "2021-11-11 02:49:05", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2983", "1", "digitaladmin", "2021-11-11 02:49:06", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2984", "1", "digitaladmin", "2021-11-11 02:49:07", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2985", "1", "digitaladmin", "2021-11-11 02:49:08", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2986", "1", "digitaladmin", "2021-11-11 02:49:09", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2987", "1", "digitaladmin", "2021-11-11 02:49:10", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2988", "1", "digitaladmin", "2021-11-11 02:49:11", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2989", "1", "digitaladmin", "2021-11-11 02:49:12", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2990", "1", "digitaladmin", "2021-11-11 02:49:13", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2991", "1", "digitaladmin", "2021-11-11 02:49:14", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2992", "1", "digitaladmin", "2021-11-11 02:49:15", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2993", "1", "digitaladmin", "2021-11-11 02:49:16", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2994", "1", "digitaladmin", "2021-11-11 02:49:17", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2995", "1", "digitaladmin", "2021-11-11 02:49:18", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2996", "1", "digitaladmin", "2021-11-11 02:49:19", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2997", "1", "digitaladmin", "2021-11-11 02:49:20", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2998", "1", "digitaladmin", "2021-11-11 02:49:21", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("2999", "1", "digitaladmin", "2021-11-11 02:49:22", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3000", "1", "digitaladmin", "2021-11-11 02:49:23", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3001", "1", "digitaladmin", "2021-11-11 02:49:24", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3002", "1", "digitaladmin", "2021-11-11 02:49:26", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3003", "1", "digitaladmin", "2021-11-11 02:49:27", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3004", "1", "digitaladmin", "2021-11-11 02:49:28", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3005", "1", "digitaladmin", "2021-11-11 02:49:29", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3006", "1", "digitaladmin", "2021-11-11 02:49:30", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3007", "1", "digitaladmin", "2021-11-11 02:49:31", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3008", "1", "digitaladmin", "2021-11-11 02:49:32", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3009", "1", "digitaladmin", "2021-11-11 02:49:33", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3010", "1", "digitaladmin", "2021-11-11 02:49:34", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3011", "1", "digitaladmin", "2021-11-11 02:49:35", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3012", "1", "digitaladmin", "2021-11-11 02:49:36", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3013", "1", "digitaladmin", "2021-11-11 02:49:37", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3014", "1", "digitaladmin", "2021-11-11 02:49:38", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3015", "1", "digitaladmin", "2021-11-11 02:49:39", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3016", "1", "digitaladmin", "2021-11-11 02:49:40", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3017", "1", "digitaladmin", "2021-11-11 02:49:41", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3018", "1", "digitaladmin", "2021-11-11 02:49:42", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3019", "1", "digitaladmin", "2021-11-11 02:49:43", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3020", "1", "digitaladmin", "2021-11-11 02:49:44", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3021", "1", "digitaladmin", "2021-11-11 02:49:45", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3022", "1", "digitaladmin", "2021-11-11 02:49:46", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3023", "1", "digitaladmin", "2021-11-11 02:49:47", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3024", "1", "digitaladmin", "2021-11-11 02:49:48", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3025", "1", "digitaladmin", "2021-11-11 02:49:49", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3026", "1", "digitaladmin", "2021-11-11 02:49:50", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3027", "1", "digitaladmin", "2021-11-11 02:49:51", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3028", "1", "digitaladmin", "2021-11-11 02:49:52", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3029", "1", "digitaladmin", "2021-11-11 02:49:54", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3030", "1", "digitaladmin", "2021-11-11 02:49:55", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3031", "1", "digitaladmin", "2021-11-11 02:49:56", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3032", "1", "digitaladmin", "2021-11-11 02:49:57", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3033", "1", "digitaladmin", "2021-11-11 02:49:58", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3034", "1", "digitaladmin", "2021-11-11 02:49:59", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3035", "1", "digitaladmin", "2021-11-11 02:50:00", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3036", "1", "digitaladmin", "2021-11-11 02:50:01", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3037", "1", "digitaladmin", "2021-11-11 02:50:03", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3038", "1", "digitaladmin", "2021-11-11 02:50:04", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3039", "1", "digitaladmin", "2021-11-11 02:50:05", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3040", "1", "digitaladmin", "2021-11-11 02:50:06", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3041", "1", "digitaladmin", "2021-11-11 02:50:07", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3042", "1", "digitaladmin", "2021-11-11 02:50:09", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3043", "1", "digitaladmin", "2021-11-11 02:50:10", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3044", "1", "digitaladmin", "2021-11-11 02:50:11", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3045", "1", "digitaladmin", "2021-11-11 02:50:12", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3046", "1", "digitaladmin", "2021-11-11 02:50:13", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3047", "1", "digitaladmin", "2021-11-11 02:50:14", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3048", "1", "digitaladmin", "2021-11-11 02:50:15", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3049", "1", "digitaladmin", "2021-11-11 02:50:16", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3050", "1", "digitaladmin", "2021-11-11 02:50:17", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3051", "1", "digitaladmin", "2021-11-11 02:50:18", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3052", "1", "digitaladmin", "2021-11-11 02:50:19", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3053", "1", "digitaladmin", "2021-11-11 02:50:20", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3054", "1", "digitaladmin", "2021-11-11 02:50:21", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3055", "1", "digitaladmin", "2021-11-11 02:50:22", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3056", "1", "digitaladmin", "2021-11-11 02:50:23", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3057", "1", "digitaladmin", "2021-11-11 02:50:24", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3058", "1", "digitaladmin", "2021-11-11 02:50:25", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3059", "1", "digitaladmin", "2021-11-11 02:50:26", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3060", "1", "digitaladmin", "2021-11-11 02:50:27", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3061", "1", "digitaladmin", "2021-11-11 02:50:28", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3062", "1", "digitaladmin", "2021-11-11 02:50:29", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3063", "1", "digitaladmin", "2021-11-11 02:50:30", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3064", "1", "digitaladmin", "2021-11-11 02:50:31", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3065", "1", "digitaladmin", "2021-11-11 02:50:32", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3066", "1", "digitaladmin", "2021-11-11 02:50:33", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3067", "1", "digitaladmin", "2021-11-11 02:50:34", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3068", "1", "digitaladmin", "2021-11-11 02:50:35", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3069", "1", "digitaladmin", "2021-11-11 02:50:36", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3070", "1", "digitaladmin", "2021-11-11 02:50:37", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3071", "1", "digitaladmin", "2021-11-11 02:50:38", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3072", "1", "digitaladmin", "2021-11-11 02:50:39", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3073", "1", "digitaladmin", "2021-11-11 02:50:40", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3074", "1", "digitaladmin", "2021-11-11 02:50:41", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3075", "1", "digitaladmin", "2021-11-11 02:50:42", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3076", "1", "digitaladmin", "2021-11-11 02:50:43", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3077", "1", "digitaladmin", "2021-11-11 02:50:44", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3078", "1", "digitaladmin", "2021-11-11 02:50:45", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3079", "1", "digitaladmin", "2021-11-11 02:50:46", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3080", "1", "digitaladmin", "2021-11-11 02:50:47", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3081", "1", "digitaladmin", "2021-11-11 02:50:48", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3082", "1", "digitaladmin", "2021-11-11 02:50:49", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3083", "1", "digitaladmin", "2021-11-11 02:50:50", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3084", "1", "digitaladmin", "2021-11-11 02:50:51", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3085", "1", "digitaladmin", "2021-11-11 02:50:52", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3086", "1", "digitaladmin", "2021-11-11 02:50:53", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3087", "1", "digitaladmin", "2021-11-11 02:50:54", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3088", "1", "digitaladmin", "2021-11-11 02:50:55", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3089", "1", "digitaladmin", "2021-11-11 02:50:56", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3090", "1", "digitaladmin", "2021-11-11 02:50:56", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3091", "1", "digitaladmin", "2021-11-11 02:50:57", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3092", "1", "digitaladmin", "2021-11-11 02:50:58", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3093", "1", "digitaladmin", "2021-11-11 02:50:59", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3094", "1", "digitaladmin", "2021-11-11 02:51:00", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3095", "1", "digitaladmin", "2021-11-11 02:51:01", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3096", "1", "digitaladmin", "2021-11-11 02:51:03", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3097", "1", "digitaladmin", "2021-11-11 02:51:04", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3098", "1", "digitaladmin", "2021-11-11 02:51:05", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3099", "1", "digitaladmin", "2021-11-11 02:51:05", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3100", "1", "digitaladmin", "2021-11-11 02:51:06", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3101", "1", "digitaladmin", "2021-11-11 02:51:07", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3102", "1", "digitaladmin", "2021-11-11 02:51:08", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3103", "1", "digitaladmin", "2021-11-11 02:51:09", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3104", "1", "digitaladmin", "2021-11-11 02:51:10", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3105", "1", "digitaladmin", "2021-11-11 02:51:11", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3106", "1", "digitaladmin", "2021-11-11 02:51:12", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3107", "1", "digitaladmin", "2021-11-11 02:51:13", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3108", "1", "digitaladmin", "2021-11-11 02:51:14", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3109", "1", "digitaladmin", "2021-11-11 02:51:15", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3110", "1", "digitaladmin", "2021-11-11 02:51:16", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3111", "1", "digitaladmin", "2021-11-11 02:51:17", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3112", "1", "digitaladmin", "2021-11-11 02:51:18", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3113", "1", "digitaladmin", "2021-11-11 02:51:19", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3114", "1", "digitaladmin", "2021-11-11 02:51:20", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3115", "1", "digitaladmin", "2021-11-11 02:51:21", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3116", "1", "digitaladmin", "2021-11-11 02:51:22", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3117", "1", "digitaladmin", "2021-11-11 02:51:23", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3118", "1", "digitaladmin", "2021-11-11 02:51:24", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3119", "1", "digitaladmin", "2021-11-11 02:51:25", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3120", "1", "digitaladmin", "2021-11-11 02:51:26", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3121", "1", "digitaladmin", "2021-11-11 02:51:27", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3122", "1", "digitaladmin", "2021-11-11 02:51:28", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3123", "1", "digitaladmin", "2021-11-11 02:51:29", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3124", "1", "digitaladmin", "2021-11-11 02:51:30", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3125", "1", "digitaladmin", "2021-11-11 02:51:31", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3126", "1", "digitaladmin", "2021-11-11 02:51:32", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3127", "1", "digitaladmin", "2021-11-11 02:51:33", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3128", "1", "digitaladmin", "2021-11-11 02:51:34", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3129", "1", "digitaladmin", "2021-11-11 02:51:35", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3130", "1", "digitaladmin", "2021-11-11 02:51:36", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3131", "1", "digitaladmin", "2021-11-11 02:51:37", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3132", "1", "digitaladmin", "2021-11-11 02:51:38", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3133", "1", "digitaladmin", "2021-11-11 02:51:39", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3134", "1", "digitaladmin", "2021-11-11 02:51:40", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3135", "1", "digitaladmin", "2021-11-11 02:51:41", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3136", "1", "digitaladmin", "2021-11-11 02:51:42", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3137", "1", "digitaladmin", "2021-11-11 02:51:43", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3138", "1", "digitaladmin", "2021-11-11 02:51:44", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3139", "1", "digitaladmin", "2021-11-11 02:51:45", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3140", "1", "digitaladmin", "2021-11-11 02:51:46", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3141", "1", "digitaladmin", "2021-11-11 02:51:47", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3142", "1", "digitaladmin", "2021-11-11 02:51:48", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3143", "1", "digitaladmin", "2021-11-11 02:51:49", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3144", "1", "digitaladmin", "2021-11-11 02:51:50", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3145", "1", "digitaladmin", "2021-11-11 02:51:51", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3146", "1", "digitaladmin", "2021-11-11 02:51:52", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3147", "1", "digitaladmin", "2021-11-11 02:51:53", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3148", "1", "digitaladmin", "2021-11-11 02:51:54", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3149", "1", "digitaladmin", "2021-11-11 02:51:55", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3150", "1", "digitaladmin", "2021-11-11 02:51:56", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3151", "1", "digitaladmin", "2021-11-11 02:51:57", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3152", "1", "digitaladmin", "2021-11-11 02:51:58", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3153", "1", "digitaladmin", "2021-11-11 02:51:59", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3154", "1", "digitaladmin", "2021-11-11 02:52:01", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3155", "1", "digitaladmin", "2021-11-11 02:52:02", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3156", "1", "digitaladmin", "2021-11-11 02:52:03", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3157", "1", "digitaladmin", "2021-11-11 02:52:04", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3158", "1", "digitaladmin", "2021-11-11 02:52:05", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3159", "1", "digitaladmin", "2021-11-11 02:52:06", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3160", "1", "digitaladmin", "2021-11-11 02:52:07", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3161", "1", "digitaladmin", "2021-11-11 02:52:08", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3162", "1", "digitaladmin", "2021-11-11 02:52:09", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3163", "1", "digitaladmin", "2021-11-11 02:52:10", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3164", "1", "digitaladmin", "2021-11-11 02:52:11", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3165", "1", "digitaladmin", "2021-11-11 02:52:12", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3166", "1", "digitaladmin", "2021-11-11 02:52:13", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3167", "1", "digitaladmin", "2021-11-11 02:52:14", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3168", "1", "digitaladmin", "2021-11-11 02:52:15", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3169", "1", "digitaladmin", "2021-11-11 02:52:16", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3170", "1", "digitaladmin", "2021-11-11 02:52:17", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3171", "1", "digitaladmin", "2021-11-11 02:52:17", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3172", "1", "digitaladmin", "2021-11-11 02:52:18", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3173", "1", "digitaladmin", "2021-11-11 02:52:19", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3174", "1", "digitaladmin", "2021-11-11 02:52:20", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3175", "1", "digitaladmin", "2021-11-11 02:52:21", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3176", "1", "digitaladmin", "2021-11-11 02:52:22", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3177", "1", "digitaladmin", "2021-11-11 02:52:23", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3178", "1", "digitaladmin", "2021-11-11 02:52:24", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3179", "1", "digitaladmin", "2021-11-11 02:52:25", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3180", "1", "digitaladmin", "2021-11-11 02:52:26", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3181", "1", "digitaladmin", "2021-11-11 02:52:27", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3182", "1", "digitaladmin", "2021-11-11 02:52:28", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3183", "1", "digitaladmin", "2021-11-11 02:52:29", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3184", "1", "digitaladmin", "2021-11-11 02:52:30", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3185", "1", "digitaladmin", "2021-11-11 02:52:31", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3186", "1", "digitaladmin", "2021-11-11 02:52:32", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3187", "1", "digitaladmin", "2021-11-11 02:52:33", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3188", "1", "digitaladmin", "2021-11-11 02:52:34", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3189", "1", "digitaladmin", "2021-11-11 02:52:35", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3190", "1", "digitaladmin", "2021-11-11 02:52:36", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3191", "1", "digitaladmin", "2021-11-11 02:52:37", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3192", "1", "digitaladmin", "2021-11-11 02:52:38", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3193", "1", "digitaladmin", "2021-11-11 02:52:39", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3194", "1", "digitaladmin", "2021-11-11 02:52:40", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3195", "1", "digitaladmin", "2021-11-11 02:52:41", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3196", "1", "digitaladmin", "2021-11-11 02:52:42", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3197", "1", "digitaladmin", "2021-11-11 02:52:43", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3198", "1", "digitaladmin", "2021-11-11 02:52:44", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3199", "1", "digitaladmin", "2021-11-11 02:52:45", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3200", "1", "digitaladmin", "2021-11-11 02:52:46", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3201", "1", "digitaladmin", "2021-11-11 02:52:47", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3202", "1", "digitaladmin", "2021-11-11 02:52:48", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3203", "1", "digitaladmin", "2021-11-11 02:52:49", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3204", "1", "digitaladmin", "2021-11-11 02:52:50", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3205", "1", "digitaladmin", "2021-11-11 02:52:51", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3206", "1", "digitaladmin", "2021-11-11 02:52:52", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3207", "1", "digitaladmin", "2021-11-11 02:52:53", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3208", "1", "digitaladmin", "2021-11-11 02:52:54", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3209", "1", "digitaladmin", "2021-11-11 02:52:55", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3210", "1", "digitaladmin", "2021-11-11 02:52:56", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3211", "1", "digitaladmin", "2021-11-11 02:52:57", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3212", "1", "digitaladmin", "2021-11-11 02:52:58", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3213", "1", "digitaladmin", "2021-11-11 02:52:59", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3214", "1", "digitaladmin", "2021-11-11 02:53:00", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3215", "1", "digitaladmin", "2021-11-11 02:53:01", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3216", "1", "digitaladmin", "2021-11-11 02:53:02", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3217", "1", "digitaladmin", "2021-11-11 02:53:03", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3218", "1", "digitaladmin", "2021-11-11 02:53:04", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3219", "1", "digitaladmin", "2021-11-11 02:53:05", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3220", "1", "digitaladmin", "2021-11-11 02:53:06", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3221", "1", "digitaladmin", "2021-11-11 02:53:07", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3222", "1", "digitaladmin", "2021-11-11 02:53:08", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3223", "1", "digitaladmin", "2021-11-11 02:53:09", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3224", "1", "digitaladmin", "2021-11-11 02:53:10", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3225", "1", "digitaladmin", "2021-11-11 02:53:11", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3226", "1", "digitaladmin", "2021-11-11 02:53:12", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3227", "1", "digitaladmin", "2021-11-11 02:53:13", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3228", "1", "digitaladmin", "2021-11-11 02:53:13", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3229", "1", "digitaladmin", "2021-11-11 02:53:14", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3230", "1", "digitaladmin", "2021-11-11 02:53:15", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3231", "1", "digitaladmin", "2021-11-11 02:53:16", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3232", "1", "digitaladmin", "2021-11-11 02:53:17", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3233", "1", "digitaladmin", "2021-11-11 02:53:18", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3234", "1", "digitaladmin", "2021-11-11 02:53:19", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3235", "1", "digitaladmin", "2021-11-11 02:53:20", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3236", "1", "digitaladmin", "2021-11-11 02:53:21", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3237", "1", "digitaladmin", "2021-11-11 02:53:22", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3238", "1", "digitaladmin", "2021-11-11 02:53:23", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3239", "1", "digitaladmin", "2021-11-11 02:53:24", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3240", "1", "digitaladmin", "2021-11-11 02:53:25", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3241", "1", "digitaladmin", "2021-11-11 02:53:26", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3242", "1", "digitaladmin", "2021-11-11 02:53:27", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3243", "1", "digitaladmin", "2021-11-11 02:53:28", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3244", "1", "digitaladmin", "2021-11-11 02:53:29", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3245", "1", "digitaladmin", "2021-11-11 02:53:30", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3246", "1", "digitaladmin", "2021-11-11 02:53:31", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3247", "1", "digitaladmin", "2021-11-11 02:53:32", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3248", "1", "digitaladmin", "2021-11-11 02:53:33", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3249", "1", "digitaladmin", "2021-11-11 02:53:34", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3250", "1", "digitaladmin", "2021-11-11 02:53:35", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3251", "1", "digitaladmin", "2021-11-11 02:53:36", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3252", "1", "digitaladmin", "2021-11-11 02:53:37", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3253", "1", "digitaladmin", "2021-11-11 02:53:38", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3254", "1", "digitaladmin", "2021-11-11 02:53:39", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3255", "1", "digitaladmin", "2021-11-11 02:53:40", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3256", "1", "digitaladmin", "2021-11-11 02:53:41", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3257", "1", "digitaladmin", "2021-11-11 02:53:42", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3258", "1", "digitaladmin", "2021-11-11 02:53:43", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3259", "1", "digitaladmin", "2021-11-11 02:53:44", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3260", "1", "digitaladmin", "2021-11-11 02:53:45", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3261", "1", "digitaladmin", "2021-11-11 02:53:46", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3262", "1", "digitaladmin", "2021-11-11 02:53:47", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3263", "1", "digitaladmin", "2021-11-11 02:53:48", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3264", "1", "digitaladmin", "2021-11-11 02:53:49", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3265", "1", "digitaladmin", "2021-11-11 02:53:50", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3266", "1", "digitaladmin", "2021-11-11 02:53:51", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3267", "1", "digitaladmin", "2021-11-11 02:53:52", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3268", "1", "digitaladmin", "2021-11-11 02:53:53", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3269", "1", "digitaladmin", "2021-11-11 02:53:54", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3270", "1", "digitaladmin", "2021-11-11 02:53:55", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3271", "1", "digitaladmin", "2021-11-11 02:53:56", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3272", "1", "digitaladmin", "2021-11-11 02:53:57", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3273", "1", "digitaladmin", "2021-11-11 02:53:58", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3274", "1", "digitaladmin", "2021-11-11 02:53:59", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3275", "1", "digitaladmin", "2021-11-11 02:54:00", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3276", "1", "digitaladmin", "2021-11-11 02:54:01", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3277", "1", "digitaladmin", "2021-11-11 02:54:02", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3278", "1", "digitaladmin", "2021-11-11 02:54:03", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3279", "1", "digitaladmin", "2021-11-11 02:54:04", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3280", "1", "digitaladmin", "2021-11-11 02:54:05", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3281", "1", "digitaladmin", "2021-11-11 02:54:06", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3282", "1", "digitaladmin", "2021-11-11 02:54:07", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3283", "1", "digitaladmin", "2021-11-11 02:54:08", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3284", "1", "digitaladmin", "2021-11-11 02:54:09", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3285", "1", "digitaladmin", "2021-11-11 02:54:10", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3286", "1", "digitaladmin", "2021-11-11 02:54:11", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3287", "1", "digitaladmin", "2021-11-11 02:54:12", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3288", "1", "digitaladmin", "2021-11-11 02:54:13", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3289", "1", "digitaladmin", "2021-11-11 02:54:14", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3290", "1", "digitaladmin", "2021-11-11 02:54:15", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3291", "1", "digitaladmin", "2021-11-11 02:54:16", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3292", "1", "digitaladmin", "2021-11-11 02:54:17", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3293", "1", "digitaladmin", "2021-11-11 02:54:18", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3294", "1", "digitaladmin", "2021-11-11 02:54:19", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3295", "1", "digitaladmin", "2021-11-11 02:54:20", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3296", "1", "digitaladmin", "2021-11-11 02:54:21", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3297", "1", "digitaladmin", "2021-11-11 02:54:22", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3298", "1", "digitaladmin", "2021-11-11 02:54:23", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3299", "1", "digitaladmin", "2021-11-11 02:54:24", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3300", "1", "digitaladmin", "2021-11-11 02:54:25", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3301", "1", "digitaladmin", "2021-11-11 02:54:26", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3302", "1", "digitaladmin", "2021-11-11 02:54:27", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3303", "1", "digitaladmin", "2021-11-11 02:54:28", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3304", "1", "digitaladmin", "2021-11-11 02:54:29", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3305", "1", "digitaladmin", "2021-11-11 02:54:30", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3306", "1", "digitaladmin", "2021-11-11 02:54:31", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3307", "1", "digitaladmin", "2021-11-11 02:54:32", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3308", "1", "digitaladmin", "2021-11-11 02:54:33", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3309", "1", "digitaladmin", "2021-11-11 02:54:34", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3310", "1", "digitaladmin", "2021-11-11 02:54:35", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3311", "1", "digitaladmin", "2021-11-11 02:54:36", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3312", "1", "digitaladmin", "2021-11-11 02:54:37", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3313", "1", "digitaladmin", "2021-11-11 02:54:38", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3314", "1", "digitaladmin", "2021-11-11 02:54:39", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3315", "1", "digitaladmin", "2021-11-11 02:54:40", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3316", "1", "digitaladmin", "2021-11-11 02:54:41", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3317", "1", "digitaladmin", "2021-11-11 02:54:42", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3318", "1", "digitaladmin", "2021-11-11 02:54:43", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3319", "1", "digitaladmin", "2021-11-11 02:54:44", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3320", "1", "digitaladmin", "2021-11-11 02:54:45", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3321", "1", "digitaladmin", "2021-11-11 02:54:46", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3322", "1", "digitaladmin", "2021-11-11 02:54:47", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3323", "1", "digitaladmin", "2021-11-11 02:54:48", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3324", "1", "digitaladmin", "2021-11-11 02:54:49", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3325", "1", "digitaladmin", "2021-11-11 02:54:50", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3326", "1", "digitaladmin", "2021-11-11 02:54:51", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3327", "1", "digitaladmin", "2021-11-11 02:54:52", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3328", "1", "digitaladmin", "2021-11-11 02:54:53", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3329", "1", "digitaladmin", "2021-11-11 02:54:54", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3330", "1", "digitaladmin", "2021-11-11 02:54:55", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3331", "1", "digitaladmin", "2021-11-11 02:54:56", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3332", "1", "digitaladmin", "2021-11-11 02:54:57", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3333", "1", "digitaladmin", "2021-11-11 02:54:58", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3334", "1", "digitaladmin", "2021-11-11 02:54:59", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3335", "1", "digitaladmin", "2021-11-11 02:55:00", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3336", "1", "digitaladmin", "2021-11-11 02:55:01", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3337", "1", "digitaladmin", "2021-11-11 02:55:02", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3338", "1", "digitaladmin", "2021-11-11 02:55:03", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3339", "1", "digitaladmin", "2021-11-11 02:55:04", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3340", "1", "digitaladmin", "2021-11-11 02:55:05", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3341", "1", "digitaladmin", "2021-11-11 02:55:06", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3342", "1", "digitaladmin", "2021-11-11 02:55:07", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3343", "1", "digitaladmin", "2021-11-11 02:55:09", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3344", "1", "digitaladmin", "2021-11-11 02:55:10", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3345", "1", "digitaladmin", "2021-11-11 02:55:11", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3346", "1", "digitaladmin", "2021-11-11 02:55:12", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3347", "1", "digitaladmin", "2021-11-11 02:55:13", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3348", "1", "digitaladmin", "2021-11-11 02:55:14", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3349", "1", "digitaladmin", "2021-11-11 02:55:15", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3350", "1", "digitaladmin", "2021-11-11 02:55:16", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3351", "1", "digitaladmin", "2021-11-11 02:55:17", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3352", "1", "digitaladmin", "2021-11-11 02:55:18", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3353", "1", "digitaladmin", "2021-11-11 02:55:19", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3354", "1", "digitaladmin", "2021-11-11 02:55:20", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3355", "1", "digitaladmin", "2021-11-11 02:55:21", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3356", "1", "digitaladmin", "2021-11-11 02:55:23", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3357", "1", "digitaladmin", "2021-11-11 02:55:24", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3358", "1", "digitaladmin", "2021-11-11 02:55:25", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3359", "1", "digitaladmin", "2021-11-11 02:55:26", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3360", "1", "digitaladmin", "2021-11-11 02:55:27", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3361", "1", "digitaladmin", "2021-11-11 02:55:28", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3362", "1", "digitaladmin", "2021-11-11 02:55:29", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3363", "1", "digitaladmin", "2021-11-11 02:55:30", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3364", "1", "digitaladmin", "2021-11-11 02:55:31", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3365", "1", "digitaladmin", "2021-11-11 02:55:32", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3366", "1", "digitaladmin", "2021-11-11 02:55:33", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3367", "1", "digitaladmin", "2021-11-11 02:55:34", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3368", "1", "digitaladmin", "2021-11-11 02:55:35", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3369", "1", "digitaladmin", "2021-11-11 02:55:36", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3370", "1", "digitaladmin", "2021-11-11 02:55:37", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3371", "1", "digitaladmin", "2021-11-11 02:55:38", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3372", "1", "digitaladmin", "2021-11-11 02:55:39", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3373", "1", "digitaladmin", "2021-11-11 02:55:40", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3374", "1", "digitaladmin", "2021-11-11 02:55:41", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3375", "1", "digitaladmin", "2021-11-11 02:55:42", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3376", "1", "digitaladmin", "2021-11-11 02:55:43", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3377", "1", "digitaladmin", "2021-11-11 02:55:44", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3378", "1", "digitaladmin", "2021-11-11 02:55:45", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3379", "1", "digitaladmin", "2021-11-11 02:55:47", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3380", "1", "digitaladmin", "2021-11-11 02:55:48", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3381", "1", "digitaladmin", "2021-11-11 02:55:49", "136.144.41.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3382", "0", "d g", "2021-11-17 05:55:44", "3.143.144.36");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3383", "1", "digitaladmin", "2021-11-17 05:55:47", "3.143.144.36");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3384", "0", "home", "2021-11-17 05:55:50", "3.143.144.36");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3385", "0", "password", "2021-11-17 05:55:53", "3.143.144.36");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3386", "0", "wordpress engine", "2021-11-17 05:55:55", "3.143.144.36");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3387", "1", "digitaladmin", "2021-11-19 07:14:34", "3.137.146.164");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3388", "1", "digitaladmin", "2021-11-19 07:35:44", "3.140.248.168");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3389", "1", "digitaladmin", "2021-11-19 07:41:19", "18.224.24.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3390", "1", "digitaladmin", "2021-11-19 08:03:00", "3.84.91.122");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3391", "1", "digitaladmin", "2021-11-19 08:21:53", "52.15.109.32");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3392", "1", "digitaladmin", "2021-11-19 08:28:19", "3.142.45.173");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3393", "1", "digitaladmin", "2021-11-19 08:48:01", "3.129.61.23");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3394", "1", "digitaladmin", "2021-11-19 09:05:20", "18.119.156.123");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3395", "1", "digitaladmin", "2021-11-19 09:16:16", "3.140.216.50");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3396", "1", "digitaladmin", "2021-11-19 09:32:13", "18.188.123.30");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3397", "1", "digitaladmin", "2021-11-19 09:50:14", "18.222.205.92");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3398", "1", "digitaladmin", "2021-11-19 10:06:53", "52.201.224.39");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3399", "1", "digitaladmin", "2021-11-19 10:16:08", "3.138.183.171");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3400", "1", "digitaladmin", "2021-11-19 10:34:37", "3.140.190.157");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3401", "1", "digitaladmin", "2021-11-19 10:49:38", "3.20.204.226");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3402", "1", "digitaladmin", "2021-11-19 11:08:31", "3.144.240.62");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3403", "1", "digitaladmin", "2021-11-19 11:34:25", "3.86.113.104");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3404", "1", "digitaladmin", "2021-11-19 11:49:16", "3.94.121.132");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3405", "1", "digitaladmin", "2021-11-19 11:56:47", "18.188.253.184");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3406", "1", "digitaladmin", "2021-11-19 12:15:56", "3.141.10.168");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3407", "1", "digitaladmin", "2021-11-19 12:32:06", "3.142.153.204");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3408", "1", "digitaladmin", "2021-11-19 12:43:13", "3.16.131.78");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3409", "1", "digitaladmin", "2021-11-19 12:59:40", "18.217.89.152");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3410", "1", "digitaladmin", "2021-11-19 13:21:28", "3.142.185.181");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3411", "1", "digitaladmin", "2021-11-19 13:26:57", "18.117.118.159");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3412", "1", "digitaladmin", "2021-11-19 13:50:16", "18.222.204.251");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3413", "1", "digitaladmin", "2021-11-19 14:01:27", "18.218.245.124");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3414", "1", "digitaladmin", "2021-11-19 14:14:24", "18.189.31.226");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3415", "1", "digitaladmin", "2021-11-19 14:29:03", "52.15.182.65");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3416", "1", "digitaladmin", "2021-11-19 14:45:30", "18.221.154.162");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3417", "1", "digitaladmin", "2021-11-19 14:59:30", "3.129.90.152");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3418", "1", "digitaladmin", "2021-11-19 15:16:09", "3.140.254.11");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3419", "1", "digitaladmin", "2021-11-19 15:33:33", "3.129.58.226");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3420", "1", "digitaladmin", "2021-11-19 15:45:13", "18.222.130.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3421", "1", "digitaladmin", "2021-11-19 16:04:12", "18.191.133.92");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3422", "1", "digitaladmin", "2021-11-19 16:22:39", "18.119.0.192");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3423", "1", "digitaladmin", "2021-11-19 16:35:12", "18.188.225.250");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3424", "1", "digitaladmin", "2021-11-19 16:52:08", "18.117.123.226");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3425", "1", "digitaladmin", "2021-11-19 17:10:25", "3.141.9.180");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3426", "1", "digitaladmin", "2021-11-19 17:20:38", "18.224.107.25");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3427", "1", "digitaladmin", "2021-11-19 17:38:15", "18.212.30.122");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3428", "1", "digitaladmin", "2021-11-19 18:00:09", "18.188.65.70");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3429", "1", "digitaladmin", "2021-11-19 18:08:54", "3.142.153.204");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3430", "1", "digitaladmin", "2021-11-19 18:26:28", "3.14.147.98");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3431", "1", "digitaladmin", "2021-11-19 18:45:33", "3.143.229.53");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3432", "1", "digitaladmin", "2021-11-19 18:55:37", "18.118.199.48");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3433", "1", "digitaladmin", "2021-11-19 19:15:09", "3.15.33.73");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3434", "1", "digitaladmin", "2021-11-19 19:34:34", "3.142.211.70");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3435", "1", "digitaladmin", "2021-11-19 19:41:57", "3.16.24.97");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3436", "1", "digitaladmin", "2021-11-19 19:50:30", "54.177.57.248");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3437", "1", "digitaladmin", "2021-11-19 20:15:55", "54.183.205.133");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3438", "1", "digitaladmin", "2021-11-19 20:21:08", "54.157.40.180");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3439", "1", "digitaladmin", "2021-11-19 20:25:15", "54.183.222.5");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3440", "1", "digitaladmin", "2021-11-19 20:41:29", "3.144.177.172");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3441", "1", "digitaladmin", "2021-11-19 20:41:41", "18.220.64.160");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3442", "1", "digitaladmin", "2021-11-19 20:44:51", "35.175.140.10");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3443", "1", "digitaladmin", "2021-11-19 20:49:52", "3.138.188.51");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3444", "1", "digitaladmin", "2021-11-19 21:02:16", "18.217.51.13");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3445", "1", "digitaladmin", "2021-11-19 21:06:21", "18.119.10.125");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3446", "1", "digitaladmin", "2021-11-19 21:12:56", "18.191.255.138");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3447", "1", "digitaladmin", "2021-11-19 21:13:57", "3.144.151.22");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3448", "1", "digitaladmin", "2021-11-19 21:14:56", "18.118.101.34");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3449", "1", "digitaladmin", "2021-11-19 21:16:45", "18.188.50.40");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3450", "1", "digitaladmin", "2021-11-19 21:24:41", "18.220.150.199");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3451", "1", "digitaladmin", "2021-11-19 21:26:22", "52.14.74.164");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3452", "1", "digitaladmin", "2021-11-19 21:31:51", "18.221.94.174");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3453", "1", "digitaladmin", "2021-11-19 21:39:27", "18.216.49.239");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3454", "1", "digitaladmin", "2021-11-19 21:44:40", "3.15.166.72");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3455", "1", "digitaladmin", "2021-11-19 21:46:38", "18.223.30.76");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3456", "1", "digitaladmin", "2021-11-19 21:46:42", "18.117.196.17");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3457", "1", "digitaladmin", "2021-11-19 21:51:47", "52.15.87.17");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3458", "1", "digitaladmin", "2021-11-19 22:00:13", "54.90.88.142");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3459", "1", "digitaladmin", "2021-11-19 22:05:40", "18.118.111.74");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3460", "1", "digitaladmin", "2021-11-19 22:11:28", "3.131.157.14");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3461", "1", "digitaladmin", "2021-11-19 22:12:32", "18.117.193.195");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3462", "1", "digitaladmin", "2021-11-19 22:19:05", "18.117.240.202");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3463", "1", "digitaladmin", "2021-11-19 22:25:25", "3.144.130.156");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3464", "1", "digitaladmin", "2021-11-19 22:27:02", "3.144.202.200");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3465", "1", "digitaladmin", "2021-11-19 22:27:28", "52.22.31.200");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3466", "1", "digitaladmin", "2021-11-19 22:35:35", "3.14.85.28");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3467", "1", "digitaladmin", "2021-11-19 22:42:54", "3.144.176.166");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3468", "1", "digitaladmin", "2021-11-19 22:43:47", "18.117.181.44");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3469", "1", "digitaladmin", "2021-11-19 23:01:44", "18.191.116.31");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3470", "1", "digitaladmin", "2021-11-19 23:01:46", "3.137.137.245");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3471", "1", "digitaladmin", "2021-11-19 23:19:27", "3.21.166.52");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3472", "1", "digitaladmin", "2021-11-19 23:20:37", "3.144.240.177");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3473", "1", "digitaladmin", "2021-11-19 23:39:30", "18.224.107.25");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3474", "1", "digitaladmin", "2021-11-19 23:40:41", "18.216.53.152");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3475", "1", "digitaladmin", "2021-11-19 23:46:28", "3.15.9.64");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3476", "1", "digitaladmin", "2021-11-19 23:56:25", "3.22.172.236");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3477", "1", "digitaladmin", "2021-11-19 23:59:29", "13.57.34.13");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3478", "1", "digitaladmin", "2021-11-20 00:02:01", "3.15.169.33");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3479", "1", "digitaladmin", "2021-11-20 00:15:59", "3.86.113.104");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3480", "1", "digitaladmin", "2021-11-20 00:17:43", "18.220.58.76");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3481", "1", "digitaladmin", "2021-11-20 00:19:52", "18.118.3.118");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3482", "1", "digitaladmin", "2021-11-20 00:33:50", "3.17.149.141");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3483", "1", "digitaladmin", "2021-11-20 00:37:25", "3.144.157.45");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3484", "1", "digitaladmin", "2021-11-20 00:39:35", "3.17.67.180");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3485", "1", "digitaladmin", "2021-11-20 00:46:44", "18.118.18.230");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3486", "1", "digitaladmin", "2021-11-20 00:55:06", "54.175.108.224");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3487", "1", "digitaladmin", "2021-11-20 00:57:00", "18.116.73.189");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3488", "1", "digitaladmin", "2021-11-20 01:04:56", "3.101.141.59");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3489", "1", "digitaladmin", "2021-11-20 01:05:02", "18.219.100.215");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3490", "1", "digitaladmin", "2021-11-20 01:11:16", "54.146.238.210");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3491", "1", "digitaladmin", "2021-11-20 01:12:13", "18.223.133.230");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3492", "1", "digitaladmin", "2021-11-20 01:20:08", "18.217.161.68");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3493", "1", "digitaladmin", "2021-11-20 01:24:09", "18.116.100.175");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3494", "1", "digitaladmin", "2021-11-20 01:25:30", "18.224.27.225");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3495", "1", "digitaladmin", "2021-11-20 01:34:27", "3.144.75.206");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3496", "1", "digitaladmin", "2021-11-20 01:35:11", "18.118.143.9");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3497", "1", "digitaladmin", "2021-11-20 01:45:16", "18.224.251.27");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3498", "1", "digitaladmin", "2021-11-20 01:49:04", "3.144.186.87");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3499", "1", "digitaladmin", "2021-11-20 02:02:24", "18.217.51.13");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3500", "1", "digitaladmin", "2021-11-20 02:03:08", "18.118.185.54");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3501", "1", "digitaladmin", "2021-11-20 02:04:25", "3.144.159.8");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3502", "1", "digitaladmin", "2021-11-20 02:16:55", "18.188.69.4");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3503", "1", "digitaladmin", "2021-11-20 02:19:31", "18.222.145.205");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3504", "1", "digitaladmin", "2021-11-20 02:38:49", "3.129.208.203");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3505", "1", "digitaladmin", "2021-11-20 02:40:31", "3.129.92.92");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3506", "1", "digitaladmin", "2021-11-20 02:56:08", "18.220.236.192");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3507", "1", "digitaladmin", "2021-11-20 02:56:25", "3.140.248.168");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3508", "1", "digitaladmin", "2021-11-20 03:00:24", "18.220.135.8");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3509", "1", "digitaladmin", "2021-11-20 03:17:50", "18.216.123.108");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3510", "1", "digitaladmin", "2021-11-20 03:19:31", "54.183.177.209");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3511", "1", "digitaladmin", "2021-11-20 03:27:58", "54.174.22.179");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3512", "1", "digitaladmin", "2021-11-20 03:33:45", "18.144.163.249");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3513", "1", "digitaladmin", "2021-11-20 03:35:35", "3.133.102.26");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3514", "1", "digitaladmin", "2021-11-20 03:36:11", "3.144.80.12");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3515", "1", "digitaladmin", "2021-11-20 03:53:13", "3.129.208.203");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3516", "1", "digitaladmin", "2021-11-20 03:55:07", "18.191.228.157");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3517", "1", "digitaladmin", "2021-11-20 03:55:58", "54.67.74.213");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3518", "1", "digitaladmin", "2021-11-20 04:10:33", "18.188.45.44");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3519", "1", "digitaladmin", "2021-11-20 04:10:39", "3.144.159.8");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3520", "1", "digitaladmin", "2021-11-20 04:14:14", "54.90.88.142");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3521", "1", "digitaladmin", "2021-11-20 04:30:16", "18.118.143.9");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3522", "1", "digitaladmin", "2021-11-20 04:31:14", "52.14.74.164");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3523", "1", "digitaladmin", "2021-11-20 04:31:34", "3.138.244.85");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3524", "1", "digitaladmin", "2021-11-20 04:48:16", "184.169.242.224");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3525", "1", "digitaladmin", "2021-11-20 04:50:21", "18.188.151.108");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3526", "1", "digitaladmin", "2021-11-20 04:51:17", "13.52.221.222");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3527", "1", "digitaladmin", "2021-11-20 05:10:06", "18.117.155.234");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3528", "1", "digitaladmin", "2021-11-20 05:11:19", "3.143.111.139");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3529", "1", "digitaladmin", "2021-11-20 05:12:18", "3.14.5.160");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3530", "1", "digitaladmin", "2021-11-20 05:32:26", "3.143.143.102");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3531", "1", "digitaladmin", "2021-11-20 05:32:34", "18.224.170.240");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3532", "1", "digitaladmin", "2021-11-20 05:36:10", "18.219.66.180");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3533", "1", "digitaladmin", "2021-11-20 05:54:36", "18.188.151.108");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3534", "1", "digitaladmin", "2021-11-20 05:55:26", "18.225.34.183");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3535", "1", "digitaladmin", "2021-11-20 05:59:24", "18.117.223.39");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3536", "1", "digitaladmin", "2021-11-20 06:16:46", "54.177.126.75");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3537", "1", "digitaladmin", "2021-11-20 06:17:06", "18.117.169.232");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3538", "1", "digitaladmin", "2021-11-20 06:39:58", "54.153.3.164");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3539", "1", "digitaladmin", "2021-11-20 06:40:23", "3.144.167.73");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3540", "1", "digitaladmin", "2021-11-20 06:58:28", "18.117.248.174");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3541", "1", "digitaladmin", "2021-11-20 07:00:01", "3.19.57.248");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3542", "1", "digitaladmin", "2021-11-20 07:02:37", "3.21.156.171");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3543", "1", "digitaladmin", "2021-11-20 07:20:36", "18.220.237.222");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3544", "1", "digitaladmin", "2021-11-20 07:22:38", "18.220.50.199");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3545", "1", "digitaladmin", "2021-11-20 07:25:10", "3.19.57.248");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3546", "1", "digitaladmin", "2021-11-20 07:42:10", "3.139.65.219");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3547", "1", "digitaladmin", "2021-11-20 07:45:48", "3.17.109.228");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3548", "1", "digitaladmin", "2021-11-20 07:48:11", "13.57.41.163");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3549", "1", "digitaladmin", "2021-11-20 08:07:34", "3.144.159.8");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3550", "1", "digitaladmin", "2021-11-20 08:07:35", "13.52.81.152");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3551", "1", "digitaladmin", "2021-11-20 08:11:14", "18.118.83.194");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3552", "1", "digitaladmin", "2021-11-20 08:28:09", "18.118.29.198");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3553", "1", "digitaladmin", "2021-11-20 08:30:26", "18.217.120.154");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3554", "1", "digitaladmin", "2021-11-20 08:32:53", "3.129.58.226");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3555", "1", "digitaladmin", "2021-11-20 08:54:54", "18.191.246.15");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3556", "1", "digitaladmin", "2021-11-20 08:55:08", "3.143.115.12");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3557", "1", "digitaladmin", "2021-11-20 10:10:27", "13.59.31.150");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3558", "1", "digitaladmin", "2021-11-20 12:16:58", "54.146.238.210");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3559", "1", "digitaladmin", "2021-11-20 13:41:16", "18.188.76.227");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3560", "1", "digitaladmin", "2021-11-20 15:10:27", "18.234.125.232");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3561", "1", "digitaladmin", "2021-11-20 17:18:08", "3.144.195.41");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3562", "1", "digitaladmin", "2021-11-20 17:41:04", "18.117.223.50");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3563", "1", "digitaladmin", "2021-11-20 18:14:49", "18.117.84.204");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3564", "1", "digitaladmin", "2021-11-20 18:56:08", "3.134.84.20");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3565", "1", "digitaladmin", "2021-11-20 19:56:04", "18.222.153.107");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3566", "1", "digitaladmin", "2021-11-20 20:08:03", "52.14.158.90");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3567", "1", "digitaladmin", "2021-11-20 21:15:48", "3.141.10.168");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3568", "1", "digitaladmin", "2021-11-20 21:45:44", "3.136.160.107");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3569", "1", "digitaladmin", "2021-11-20 22:22:49", "18.216.219.87");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3570", "1", "digitaladmin", "2021-11-20 23:16:23", "3.144.179.199");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3571", "1", "digitaladmin", "2021-11-21 00:26:49", "3.17.203.252");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3572", "1", "digitaladmin", "2021-11-21 00:58:46", "3.15.19.228");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3573", "1", "digitaladmin", "2021-11-21 01:16:00", "18.118.170.124");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3574", "1", "digitaladmin", "2021-11-21 01:45:50", "18.223.121.82");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3575", "1", "digitaladmin", "2021-11-21 02:56:51", "18.188.34.90");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3576", "1", "digitaladmin", "2021-11-21 03:28:42", "18.221.188.81");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3577", "1", "digitaladmin", "2021-11-21 04:00:25", "3.15.45.102");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3578", "1", "digitaladmin", "2021-11-21 05:10:15", "18.224.82.43");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3579", "1", "digitaladmin", "2021-11-21 05:41:46", "18.117.153.150");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3580", "1", "digitaladmin", "2021-11-21 06:53:47", "18.191.201.0");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3581", "1", "digitaladmin", "2021-11-21 07:22:46", "184.73.65.162");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3582", "1", "digitaladmin", "2021-11-21 08:33:18", "3.142.150.68");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3583", "1", "digitaladmin", "2021-11-21 09:02:55", "18.222.252.105");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3584", "1", "digitaladmin", "2021-11-21 09:21:01", "18.191.169.51");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3585", "1", "digitaladmin", "2021-11-21 09:50:45", "54.153.3.164");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3586", "1", "digitaladmin", "2021-11-21 11:02:36", "3.131.95.34");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3587", "1", "digitaladmin", "2021-11-21 11:33:35", "18.191.201.0");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3588", "1", "digitaladmin", "2021-11-21 12:07:20", "3.132.215.232");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3589", "1", "digitaladmin", "2021-11-21 13:13:43", "3.134.79.5");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3590", "1", "digitaladmin", "2021-11-21 13:34:22", "18.224.1.185");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3591", "1", "digitaladmin", "2021-11-21 14:26:11", "3.139.58.117");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3592", "1", "digitaladmin", "2021-11-21 14:41:11", "3.145.22.172");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3593", "1", "digitaladmin", "2021-11-21 15:35:23", "3.19.221.24");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3594", "1", "digitaladmin", "2021-11-21 15:38:13", "18.188.32.228");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3595", "1", "digitaladmin", "2021-11-21 15:43:06", "54.176.65.143");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3596", "1", "digitaladmin", "2021-11-21 15:57:29", "18.117.86.174");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3597", "1", "digitaladmin", "2021-11-21 16:23:29", "3.15.24.218");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3598", "1", "digitaladmin", "2021-11-21 16:49:47", "18.117.218.0");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3599", "1", "digitaladmin", "2021-11-21 17:07:54", "18.218.163.130");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3600", "1", "digitaladmin", "2021-11-21 17:45:00", "3.19.71.44");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3601", "1", "digitaladmin", "2021-11-21 17:55:12", "3.14.13.226");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3602", "1", "digitaladmin", "2021-11-21 18:24:24", "18.216.233.44");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3603", "1", "digitaladmin", "2021-11-21 18:40:02", "52.53.185.19");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3604", "1", "digitaladmin", "2021-11-21 18:51:46", "18.191.232.145");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3605", "1", "digitaladmin", "2021-11-21 19:36:02", "18.218.231.140");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3606", "1", "digitaladmin", "2021-11-21 19:46:54", "18.217.162.49");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3607", "1", "digitaladmin", "2021-11-21 20:02:50", "3.145.48.22");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3608", "1", "digitaladmin", "2021-11-21 20:14:17", "3.142.52.70");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3609", "1", "digitaladmin", "2021-11-21 21:03:51", "13.59.17.156");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3610", "1", "digitaladmin", "2021-11-21 21:13:55", "3.15.26.161");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3611", "1", "digitaladmin", "2021-11-21 22:05:15", "3.16.131.9");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3612", "1", "digitaladmin", "2021-11-21 22:20:02", "3.133.98.223");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3613", "1", "digitaladmin", "2021-11-21 23:13:05", "54.215.94.153");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3614", "1", "digitaladmin", "2021-11-21 23:26:50", "18.191.201.0");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3615", "1", "digitaladmin", "2021-11-21 23:40:54", "3.15.217.83");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3616", "1", "digitaladmin", "2021-11-22 00:32:07", "3.14.13.226");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3617", "1", "digitaladmin", "2021-11-22 00:48:47", "18.222.102.191");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3618", "1", "digitaladmin", "2021-11-22 01:03:13", "18.219.130.44");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3619", "1", "digitaladmin", "2021-11-22 01:18:08", "3.15.191.242");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3620", "1", "digitaladmin", "2021-11-22 02:10:25", "18.223.33.160");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3621", "1", "digitaladmin", "2021-11-22 02:22:03", "3.143.248.22");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3622", "1", "digitaladmin", "2021-11-22 03:16:07", "3.12.104.77");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3623", "1", "digitaladmin", "2021-11-22 03:30:25", "52.14.138.226");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3624", "1", "digitaladmin", "2021-11-22 04:24:45", "3.19.14.72");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3625", "1", "digitaladmin", "2021-11-22 04:40:42", "3.139.100.121");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3626", "1", "digitaladmin", "2021-11-22 05:32:29", "18.117.163.233");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3627", "1", "digitaladmin", "2021-11-22 05:45:15", "18.116.71.125");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3628", "1", "digitaladmin", "2021-11-22 06:00:24", "3.21.19.54");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3629", "1", "digitaladmin", "2021-11-22 06:15:55", "18.188.116.199");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3630", "1", "digitaladmin", "2021-11-22 07:08:28", "3.12.104.163");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3631", "1", "digitaladmin", "2021-11-22 07:21:27", "3.144.69.183");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3632", "1", "digitaladmin", "2021-11-22 07:35:53", "18.222.189.41");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3633", "1", "digitaladmin", "2021-11-22 08:28:04", "3.142.201.250");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3634", "1", "digitaladmin", "2021-11-22 08:43:03", "3.144.154.73");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3635", "1", "digitaladmin", "2021-11-22 09:05:28", "18.222.210.8");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3636", "1", "digitaladmin", "2021-11-22 09:11:44", "18.223.121.82");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3637", "1", "digitaladmin", "2021-11-22 09:14:08", "3.144.176.166");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3638", "1", "digitaladmin", "2021-11-22 09:21:26", "18.191.101.173");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3639", "1", "digitaladmin", "2021-11-22 09:22:11", "18.216.85.74");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3640", "1", "digitaladmin", "2021-11-22 09:28:20", "18.191.163.105");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3641", "1", "digitaladmin", "2021-11-22 09:28:38", "18.118.167.199");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3642", "1", "digitaladmin", "2021-11-22 09:30:21", "54.177.233.67");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3643", "1", "digitaladmin", "2021-11-22 09:37:29", "18.191.172.39");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3644", "1", "digitaladmin", "2021-11-22 09:39:11", "18.222.19.145");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3645", "1", "digitaladmin", "2021-11-22 09:44:13", "3.144.156.230");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3646", "1", "digitaladmin", "2021-11-22 09:45:32", "18.191.61.82");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3647", "1", "digitaladmin", "2021-11-22 09:51:28", "18.221.162.66");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3648", "1", "digitaladmin", "2021-11-22 09:51:42", "18.220.187.47");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3649", "1", "digitaladmin", "2021-11-22 09:55:23", "3.134.79.5");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3650", "1", "digitaladmin", "2021-11-22 10:00:19", "3.144.169.78");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3651", "1", "digitaladmin", "2021-11-22 10:05:52", "3.142.240.82");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3652", "1", "digitaladmin", "2021-11-22 10:07:03", "3.18.110.188");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3653", "1", "digitaladmin", "2021-11-22 10:14:07", "18.118.209.49");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3654", "1", "digitaladmin", "2021-11-22 10:14:44", "3.22.187.191");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3655", "1", "digitaladmin", "2021-11-22 10:16:04", "13.59.135.99");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3656", "1", "digitaladmin", "2021-11-22 10:21:57", "18.217.202.229");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3657", "1", "digitaladmin", "2021-11-22 10:23:04", "18.188.83.51");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3658", "1", "digitaladmin", "2021-11-22 10:23:12", "3.19.69.38");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3659", "1", "digitaladmin", "2021-11-22 10:30:13", "3.135.244.119");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3660", "1", "digitaladmin", "2021-11-22 10:30:18", "18.222.93.42");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3661", "1", "digitaladmin", "2021-11-22 10:32:58", "18.144.84.23");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3662", "1", "digitaladmin", "2021-11-22 10:37:28", "52.14.42.232");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3663", "1", "digitaladmin", "2021-11-22 10:38:31", "3.20.221.123");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3664", "1", "digitaladmin", "2021-11-22 10:40:13", "18.218.152.98");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3665", "1", "digitaladmin", "2021-11-22 10:45:31", "3.129.206.171");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3666", "1", "digitaladmin", "2021-11-22 10:45:42", "3.16.129.24");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3667", "1", "digitaladmin", "2021-11-22 10:48:16", "3.129.25.154");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3668", "1", "digitaladmin", "2021-11-22 10:54:21", "13.52.74.144");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3669", "1", "digitaladmin", "2021-11-22 10:54:55", "18.222.140.211");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3670", "1", "digitaladmin", "2021-11-22 10:55:13", "3.143.224.90");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3671", "1", "digitaladmin", "2021-11-22 11:01:24", "3.143.249.24");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3672", "1", "digitaladmin", "2021-11-22 11:01:56", "3.138.109.220");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3673", "1", "digitaladmin", "2021-11-22 11:04:04", "3.140.243.112");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3674", "1", "digitaladmin", "2021-11-22 11:09:06", "18.219.134.45");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3675", "1", "digitaladmin", "2021-11-22 11:09:40", "54.151.23.68");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3676", "1", "digitaladmin", "2021-11-22 11:12:05", "18.191.167.142");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3677", "1", "digitaladmin", "2021-11-22 11:18:15", "18.222.189.41");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3678", "1", "digitaladmin", "2021-11-22 11:19:59", "18.191.32.57");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3679", "1", "digitaladmin", "2021-11-22 11:24:04", "3.142.185.89");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3680", "1", "digitaladmin", "2021-11-22 11:26:58", "18.222.205.92");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3681", "1", "digitaladmin", "2021-11-22 11:32:54", "3.16.162.187");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3682", "1", "digitaladmin", "2021-11-22 11:42:10", "3.145.26.97");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3683", "1", "digitaladmin", "2021-11-22 17:40:54", "3.142.185.69");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3684", "1", "digitaladmin", "2021-11-22 17:44:45", "3.129.6.88");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3685", "1", "digitaladmin", "2021-11-23 19:00:06", "3.14.69.166");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3686", "1", "digitaladmin", "2021-11-23 19:00:16", "3.145.73.132");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3687", "1", "digitaladmin", "2021-11-23 19:00:35", "3.145.50.199");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3688", "1", "digitaladmin", "2021-11-23 19:05:10", "3.144.127.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3689", "1", "digitaladmin", "2021-11-23 19:10:40", "3.21.247.191");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3690", "1", "digitaladmin", "2021-11-23 19:12:51", "18.117.12.141");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3691", "1", "digitaladmin", "2021-11-23 19:13:27", "3.142.185.202");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3692", "1", "digitaladmin", "2021-11-23 19:13:47", "3.16.125.103");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3693", "1", "digitaladmin", "2021-11-23 19:14:04", "3.138.172.44");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3694", "1", "digitaladmin", "2021-11-23 19:20:18", "3.144.239.5");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3695", "1", "digitaladmin", "2021-11-23 19:23:04", "18.116.50.141");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3696", "1", "digitaladmin", "2021-11-23 19:23:17", "18.119.165.25");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3697", "1", "digitaladmin", "2021-11-23 19:25:30", "18.144.84.23");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3698", "1", "digitaladmin", "2021-11-23 19:27:53", "3.144.107.219");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3699", "1", "digitaladmin", "2021-11-23 19:35:33", "3.12.241.12");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3700", "1", "digitaladmin", "2021-11-23 19:36:16", "3.144.109.115");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3701", "1", "digitaladmin", "2021-11-23 19:39:11", "3.144.160.112");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3702", "1", "digitaladmin", "2021-11-23 19:42:39", "3.142.208.122");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3703", "1", "digitaladmin", "2021-11-23 19:45:52", "18.188.95.125");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3704", "1", "digitaladmin", "2021-11-23 19:45:58", "3.145.26.55");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3705", "1", "digitaladmin", "2021-11-23 19:47:42", "18.216.210.81");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3706", "1", "digitaladmin", "2021-11-23 19:50:55", "3.21.163.177");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3707", "1", "digitaladmin", "2021-11-23 19:51:42", "3.142.91.106");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3708", "1", "digitaladmin", "2021-11-23 19:58:21", "3.144.132.196");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3709", "1", "digitaladmin", "2021-11-23 20:02:19", "18.191.143.70");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3710", "1", "digitaladmin", "2021-11-23 20:05:18", "3.14.1.24");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3711", "1", "digitaladmin", "2021-11-23 20:08:56", "18.222.196.75");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3712", "1", "digitaladmin", "2021-11-23 20:09:26", "3.17.74.158");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3713", "1", "digitaladmin", "2021-11-23 20:09:51", "3.144.210.130");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3714", "1", "digitaladmin", "2021-11-23 20:09:57", "3.21.166.101");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3715", "1", "digitaladmin", "2021-11-23 20:15:01", "3.144.119.157");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3716", "1", "digitaladmin", "2021-11-23 20:19:14", "18.119.12.189");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3717", "1", "digitaladmin", "2021-11-23 20:21:41", "3.143.22.186");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3718", "1", "digitaladmin", "2021-11-23 20:24:08", "18.221.204.64");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3719", "1", "digitaladmin", "2021-11-23 20:25:46", "18.118.153.124");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3720", "1", "digitaladmin", "2021-11-23 20:28:54", "18.220.254.106");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3721", "1", "digitaladmin", "2021-11-23 20:30:04", "18.117.218.109");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3722", "1", "digitaladmin", "2021-11-23 20:34:49", "18.118.168.200");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3723", "1", "digitaladmin", "2021-11-23 20:38:59", "3.23.128.161");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3724", "1", "digitaladmin", "2021-11-23 20:40:54", "3.144.127.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3725", "1", "digitaladmin", "2021-11-23 20:43:37", "18.119.115.133");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3726", "1", "digitaladmin", "2021-11-23 20:45:16", "18.191.179.178");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3727", "1", "digitaladmin", "2021-11-23 20:49:49", "3.144.109.115");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3728", "1", "digitaladmin", "2021-11-23 20:54:03", "18.117.228.117");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3729", "1", "digitaladmin", "2021-11-23 20:56:19", "3.142.194.102");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3730", "1", "digitaladmin", "2021-11-23 20:58:05", "3.14.85.28");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3731", "1", "digitaladmin", "2021-11-23 20:59:58", "3.22.41.105");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3732", "1", "digitaladmin", "2021-11-23 21:03:17", "18.220.135.225");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3733", "1", "digitaladmin", "2021-11-23 21:05:01", "18.224.94.90");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3734", "1", "digitaladmin", "2021-11-23 21:10:15", "3.138.37.98");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3735", "1", "digitaladmin", "2021-11-23 21:14:49", "18.191.169.114");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3736", "1", "digitaladmin", "2021-11-23 21:17:33", "3.142.208.122");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3737", "1", "digitaladmin", "2021-11-23 21:20:06", "13.57.212.239");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3738", "1", "digitaladmin", "2021-11-23 21:20:58", "13.58.60.131");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3739", "1", "digitaladmin", "2021-11-23 21:26:28", "18.118.82.174");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3740", "1", "digitaladmin", "2021-11-23 21:33:40", "3.139.84.85");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3741", "1", "digitaladmin", "2021-11-23 21:37:08", "3.16.38.180");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3742", "1", "digitaladmin", "2021-11-23 21:38:58", "3.140.243.27");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3743", "1", "digitaladmin", "2021-11-23 21:42:43", "3.19.57.248");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3744", "1", "digitaladmin", "2021-11-23 21:42:46", "18.219.157.209");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3745", "1", "digitaladmin", "2021-11-23 21:48:13", "3.144.249.158");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3746", "1", "digitaladmin", "2021-11-23 21:48:56", "3.12.198.198");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3747", "1", "digitaladmin", "2021-11-23 21:54:17", "18.118.148.175");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3748", "1", "digitaladmin", "2021-11-23 21:56:17", "3.141.11.14");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3749", "1", "digitaladmin", "2021-11-23 22:00:05", "13.58.13.213");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3750", "1", "digitaladmin", "2021-11-23 22:00:31", "3.134.83.128");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3751", "1", "digitaladmin", "2021-11-23 22:01:23", "3.21.207.233");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3752", "1", "digitaladmin", "2021-11-23 22:07:08", "18.223.152.202");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3753", "1", "digitaladmin", "2021-11-23 22:11:45", "18.218.162.170");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3754", "1", "digitaladmin", "2021-11-23 22:13:12", "52.15.132.124");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3755", "1", "digitaladmin", "2021-11-23 22:16:46", "18.188.183.93");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3756", "1", "digitaladmin", "2021-11-23 22:18:39", "3.17.131.88");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3757", "1", "digitaladmin", "2021-11-23 22:23:40", "3.138.68.127");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3758", "1", "digitaladmin", "2021-11-23 22:28:17", "18.218.22.175");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3759", "1", "digitaladmin", "2021-11-23 22:31:44", "18.222.209.57");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3760", "1", "digitaladmin", "2021-11-23 22:34:24", "3.134.93.252");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3761", "1", "digitaladmin", "2021-11-23 22:35:22", "3.15.217.83");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3762", "1", "digitaladmin", "2021-11-23 22:35:51", "3.141.202.194");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3763", "1", "digitaladmin", "2021-11-23 22:39:14", "3.133.95.236");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3764", "1", "digitaladmin", "2021-11-23 22:41:00", "3.136.87.81");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3765", "1", "digitaladmin", "2021-11-23 22:45:03", "3.133.87.188");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3766", "1", "digitaladmin", "2021-11-23 22:49:54", "13.58.49.69");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3767", "1", "digitaladmin", "2021-11-23 22:51:49", "18.118.158.30");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3768", "1", "digitaladmin", "2021-11-23 22:51:49", "3.144.136.217");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3769", "1", "digitaladmin", "2021-11-23 22:55:12", "18.118.29.47");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3770", "1", "digitaladmin", "2021-11-23 22:56:10", "18.216.7.231");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3771", "1", "digitaladmin", "2021-11-23 23:01:04", "52.53.149.146");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3772", "1", "digitaladmin", "2021-11-23 23:07:40", "3.135.194.4");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3773", "1", "digitaladmin", "2021-11-23 23:09:17", "3.134.79.148");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3774", "1", "digitaladmin", "2021-11-23 23:11:53", "3.17.60.22");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3775", "1", "digitaladmin", "2021-11-23 23:13:57", "54.219.110.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3776", "1", "digitaladmin", "2021-11-23 23:17:21", "18.119.28.130");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3777", "1", "digitaladmin", "2021-11-23 23:18:29", "3.145.48.42");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3778", "1", "digitaladmin", "2021-11-23 23:22:54", "52.14.209.168");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3779", "1", "digitaladmin", "2021-11-23 23:27:53", "3.17.189.104");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3780", "1", "digitaladmin", "2021-11-23 23:30:31", "18.216.29.127");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3781", "1", "digitaladmin", "2021-11-23 23:33:13", "3.17.70.64");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3782", "1", "digitaladmin", "2021-11-23 23:34:48", "3.139.63.72");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3783", "1", "digitaladmin", "2021-11-23 23:39:28", "3.144.125.53");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3784", "1", "digitaladmin", "2021-11-23 23:43:43", "18.118.84.123");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3785", "1", "digitaladmin", "2021-11-23 23:46:48", "3.20.236.42");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3786", "1", "digitaladmin", "2021-11-23 23:49:26", "3.133.96.33");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3787", "1", "digitaladmin", "2021-11-23 23:52:33", "52.14.138.226");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3788", "1", "digitaladmin", "2021-11-23 23:55:03", "18.217.92.235");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3789", "1", "digitaladmin", "2021-11-23 23:56:22", "18.216.172.75");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3790", "1", "digitaladmin", "2021-11-24 00:06:27", "3.129.87.134");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3791", "1", "digitaladmin", "2021-11-24 00:12:52", "18.216.109.43");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3792", "1", "digitaladmin", "2021-11-24 00:13:50", "3.141.153.22");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3793", "1", "digitaladmin", "2021-11-24 00:14:54", "18.118.167.4");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3794", "1", "digitaladmin", "2021-11-24 00:19:26", "18.117.178.92");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3795", "1", "digitaladmin", "2021-11-24 00:32:08", "13.58.107.105");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3796", "1", "digitaladmin", "2021-11-24 00:33:46", "18.218.91.20");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3797", "1", "digitaladmin", "2021-11-24 00:35:20", "3.17.208.215");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3798", "1", "digitaladmin", "2021-11-24 00:40:12", "3.137.154.158");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3799", "1", "digitaladmin", "2021-11-24 00:40:44", "3.17.161.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3800", "1", "digitaladmin", "2021-11-24 00:41:08", "3.142.225.210");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3801", "1", "digitaladmin", "2021-11-24 00:53:10", "18.118.185.178");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3802", "1", "digitaladmin", "2021-11-24 01:00:12", "3.133.126.39");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3803", "1", "digitaladmin", "2021-11-24 01:04:00", "18.117.123.78");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3804", "1", "digitaladmin", "2021-11-24 01:07:23", "18.189.43.53");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3805", "1", "digitaladmin", "2021-11-24 01:22:48", "18.116.62.160");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3806", "1", "digitaladmin", "2021-11-24 01:23:10", "3.136.234.199");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3807", "1", "digitaladmin", "2021-11-24 01:29:07", "3.144.159.8");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3808", "1", "digitaladmin", "2021-11-24 01:30:19", "13.59.232.84");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3809", "1", "digitaladmin", "2021-11-24 01:35:24", "3.142.122.53");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3810", "1", "digitaladmin", "2021-11-24 01:37:30", "18.116.90.203");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3811", "1", "digitaladmin", "2021-11-24 01:44:45", "18.219.51.160");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3812", "1", "digitaladmin", "2021-11-24 01:47:30", "18.188.36.103");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3813", "1", "digitaladmin", "2021-11-24 01:58:43", "3.137.171.222");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3814", "1", "digitaladmin", "2021-11-24 01:59:40", "3.144.73.50");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3815", "1", "digitaladmin", "2021-11-24 02:04:02", "3.133.125.142");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3816", "1", "digitaladmin", "2021-11-24 02:05:27", "3.17.152.40");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3817", "1", "digitaladmin", "2021-11-24 02:11:31", "13.58.66.72");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3818", "1", "digitaladmin", "2021-11-24 02:22:52", "18.118.254.248");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3819", "1", "digitaladmin", "2021-11-24 02:23:32", "18.216.154.197");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3820", "1", "digitaladmin", "2021-11-24 02:25:33", "3.21.241.100");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3821", "1", "digitaladmin", "2021-11-24 02:26:21", "18.191.169.51");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3822", "1", "digitaladmin", "2021-11-24 02:31:44", "3.139.238.17");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3823", "1", "digitaladmin", "2021-11-24 02:32:32", "18.216.109.43");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3824", "1", "digitaladmin", "2021-11-24 02:33:31", "3.144.252.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3825", "1", "digitaladmin", "2021-11-24 02:52:21", "3.17.133.136");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3826", "1", "digitaladmin", "2021-11-24 02:53:16", "3.131.96.72");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3827", "1", "digitaladmin", "2021-11-24 03:03:01", "13.59.138.79");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3828", "1", "digitaladmin", "2021-11-24 03:05:49", "18.224.150.102");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3829", "1", "digitaladmin", "2021-11-24 03:12:12", "3.142.151.109");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3830", "1", "digitaladmin", "2021-11-24 03:24:06", "3.12.132.144");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3831", "1", "digitaladmin", "2021-11-24 03:27:07", "3.144.72.89");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3832", "1", "digitaladmin", "2021-11-24 03:30:03", "18.118.205.166");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3833", "1", "digitaladmin", "2021-11-24 03:30:37", "54.215.186.43");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3834", "1", "digitaladmin", "2021-11-24 03:33:09", "3.19.73.78");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3835", "1", "digitaladmin", "2021-11-24 03:40:09", "3.144.239.209");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3836", "1", "digitaladmin", "2021-11-24 03:45:19", "3.144.172.36");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3837", "1", "digitaladmin", "2021-11-24 03:51:02", "18.119.157.202");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3838", "1", "digitaladmin", "2021-11-24 04:00:55", "18.222.183.71");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3839", "1", "digitaladmin", "2021-11-24 04:10:25", "3.21.234.22");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3840", "1", "digitaladmin", "2021-11-24 04:11:45", "18.218.110.134");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3841", "1", "digitaladmin", "2021-11-24 04:22:51", "3.140.243.27");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3842", "1", "digitaladmin", "2021-11-24 04:33:37", "3.139.55.131");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3843", "1", "digitaladmin", "2021-11-24 04:37:34", "18.220.138.30");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3844", "1", "digitaladmin", "2021-11-24 04:46:21", "3.12.104.138");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3845", "1", "digitaladmin", "2021-11-24 04:47:33", "18.119.97.78");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3846", "1", "digitaladmin", "2021-11-24 04:55:30", "3.139.88.23");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3847", "1", "digitaladmin", "2021-11-24 05:03:44", "3.145.35.8");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3848", "1", "digitaladmin", "2021-11-24 05:11:30", "3.133.103.94");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3849", "1", "digitaladmin", "2021-11-24 05:14:14", "18.218.83.9");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3850", "1", "digitaladmin", "2021-11-24 05:16:30", "18.118.189.154");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3851", "1", "digitaladmin", "2021-11-24 05:29:16", "3.139.59.144");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3852", "1", "digitaladmin", "2021-11-24 05:38:55", "3.145.60.104");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3853", "1", "digitaladmin", "2021-11-24 05:40:10", "3.128.27.126");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3854", "1", "digitaladmin", "2021-11-24 05:43:20", "18.117.135.6");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3855", "1", "digitaladmin", "2021-11-24 05:52:54", "18.216.243.17");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3856", "1", "digitaladmin", "2021-11-24 06:00:13", "52.15.239.114");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3857", "1", "digitaladmin", "2021-11-24 06:05:56", "3.21.162.203");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3858", "1", "digitaladmin", "2021-11-24 06:15:13", "3.15.212.227");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3859", "1", "digitaladmin", "2021-11-24 06:22:16", "18.191.118.226");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3860", "1", "digitaladmin", "2021-11-24 06:28:29", "18.117.189.108");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3861", "1", "digitaladmin", "2021-11-24 06:37:27", "13.59.118.253");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3862", "1", "digitaladmin", "2021-11-24 06:39:48", "18.117.80.143");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3863", "1", "digitaladmin", "2021-11-24 06:50:25", "3.132.214.92");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3864", "1", "digitaladmin", "2021-11-24 06:59:23", "3.141.44.202");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3865", "1", "digitaladmin", "2021-11-24 07:09:50", "18.119.100.210");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3866", "1", "digitaladmin", "2021-11-24 07:14:24", "3.144.230.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3867", "1", "digitaladmin", "2021-11-24 07:22:31", "18.225.11.168");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3868", "1", "digitaladmin", "2021-11-24 07:24:04", "54.215.72.41");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3869", "1", "digitaladmin", "2021-11-24 07:39:04", "3.140.195.220");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3870", "1", "digitaladmin", "2021-11-24 07:40:11", "3.144.226.173");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3871", "1", "digitaladmin", "2021-11-24 07:45:14", "3.135.231.58");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3872", "1", "digitaladmin", "2021-11-24 07:53:18", "3.142.232.85");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3873", "1", "digitaladmin", "2021-11-24 08:01:41", "18.224.183.137");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3874", "1", "digitaladmin", "2021-11-24 08:09:54", "18.221.50.215");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3875", "1", "digitaladmin", "2021-11-24 08:15:21", "18.116.162.28");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3876", "1", "digitaladmin", "2021-11-24 08:25:15", "52.15.42.90");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3877", "1", "digitaladmin", "2021-11-24 08:33:28", "18.118.46.249");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3878", "1", "digitaladmin", "2021-11-24 08:40:15", "18.191.81.171");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3879", "1", "digitaladmin", "2021-11-24 08:53:40", "3.144.165.186");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3880", "1", "digitaladmin", "2021-11-24 09:02:58", "18.220.246.173");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3881", "1", "digitaladmin", "2021-11-24 09:03:19", "18.217.221.20");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3882", "1", "digitaladmin", "2021-11-24 09:16:20", "52.14.147.51");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3883", "1", "digitaladmin", "2021-11-24 09:17:22", "3.14.85.28");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3884", "1", "digitaladmin", "2021-11-24 09:28:02", "18.223.101.181");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3885", "1", "digitaladmin", "2021-11-24 09:43:57", "3.143.113.186");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3886", "1", "digitaladmin", "2021-11-24 10:00:47", "18.188.90.206");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3887", "1", "digitaladmin", "2021-11-24 10:08:59", "3.142.150.68");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3888", "1", "digitaladmin", "2021-11-24 10:15:32", "3.141.19.40");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3889", "1", "digitaladmin", "2021-11-24 10:26:55", "18.222.197.201");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3890", "1", "digitaladmin", "2021-11-24 10:43:09", "3.16.10.91");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3891", "1", "digitaladmin", "2021-11-24 10:59:10", "3.135.248.180");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3892", "1", "digitaladmin", "2021-11-24 11:12:07", "18.189.186.105");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3893", "1", "digitaladmin", "2021-11-24 11:16:44", "18.221.180.38");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3894", "1", "digitaladmin", "2021-11-24 11:27:38", "52.14.37.150");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3895", "1", "digitaladmin", "2021-11-24 11:34:55", "52.15.203.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3896", "1", "digitaladmin", "2021-11-24 11:39:01", "3.14.5.160");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3897", "1", "digitaladmin", "2021-11-24 11:58:56", "3.140.239.232");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3898", "1", "digitaladmin", "2021-11-24 12:17:37", "18.118.212.43");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3899", "1", "digitaladmin", "2021-11-24 12:29:50", "3.145.50.228");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3900", "1", "digitaladmin", "2021-11-24 12:32:17", "3.140.201.50");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3901", "1", "digitaladmin", "2021-11-24 12:44:22", "3.128.205.178");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3902", "1", "digitaladmin", "2021-11-24 13:00:53", "3.23.102.52");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3903", "1", "digitaladmin", "2021-11-24 13:12:49", "3.131.128.49");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3904", "1", "digitaladmin", "2021-11-24 13:27:29", "3.142.225.210");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3905", "1", "digitaladmin", "2021-11-24 13:34:03", "52.14.117.248");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3906", "1", "digitaladmin", "2021-11-24 13:45:47", "18.117.249.105");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3907", "1", "digitaladmin", "2021-11-24 13:52:45", "3.128.32.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3908", "1", "digitaladmin", "2021-11-24 14:01:28", "18.188.79.94");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3909", "1", "digitaladmin", "2021-11-24 14:17:46", "3.141.85.151");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3910", "1", "digitaladmin", "2021-11-24 14:31:24", "18.220.247.14");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3911", "1", "digitaladmin", "2021-11-24 14:47:59", "18.223.239.190");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3912", "1", "digitaladmin", "2021-11-24 14:55:17", "18.219.12.243");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3913", "1", "digitaladmin", "2021-11-24 15:02:49", "18.118.112.139");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3914", "1", "digitaladmin", "2021-11-24 15:21:37", "18.223.16.30");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3915", "1", "digitaladmin", "2021-11-24 15:38:37", "18.117.100.28");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3916", "1", "digitaladmin", "2021-11-24 15:50:27", "18.216.233.30");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3917", "1", "digitaladmin", "2021-11-24 15:56:16", "18.188.255.85");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3918", "1", "digitaladmin", "2021-11-24 16:05:47", "18.216.77.164");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3919", "1", "digitaladmin", "2021-11-24 16:25:16", "52.14.85.139");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3920", "1", "digitaladmin", "2021-11-24 16:45:12", "18.216.130.40");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3921", "1", "digitaladmin", "2021-11-24 16:53:23", "18.222.27.248");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3922", "1", "digitaladmin", "2021-11-24 17:02:58", "3.144.44.162");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3923", "1", "digitaladmin", "2021-11-24 17:13:08", "18.191.168.55");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3924", "1", "digitaladmin", "2021-11-24 17:23:22", "54.183.177.209");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3925", "1", "digitaladmin", "2021-11-24 17:31:44", "18.221.169.111");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3926", "1", "digitaladmin", "2021-11-24 17:50:50", "18.221.125.1");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3927", "1", "digitaladmin", "2021-11-24 18:05:51", "3.23.115.191");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3928", "1", "digitaladmin", "2021-11-24 18:20:11", "3.144.164.199");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3929", "1", "digitaladmin", "2021-11-24 18:29:05", "18.218.224.228");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3930", "1", "digitaladmin", "2021-11-24 18:39:19", "18.223.2.213");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3931", "1", "digitaladmin", "2021-11-24 18:55:51", "3.135.20.92");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3932", "1", "digitaladmin", "2021-11-24 19:20:11", "3.143.213.176");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3933", "1", "digitaladmin", "2021-11-24 19:26:18", "3.15.196.56");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3934", "1", "digitaladmin", "2021-11-24 19:35:41", "18.189.26.191");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3935", "1", "digitaladmin", "2021-11-24 19:44:42", "18.189.17.28");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3936", "1", "digitaladmin", "2021-11-24 20:00:43", "3.145.68.96");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3937", "1", "digitaladmin", "2021-11-24 20:05:22", "18.222.93.42");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3938", "1", "digitaladmin", "2021-11-24 20:26:58", "3.136.87.121");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3939", "1", "digitaladmin", "2021-11-24 20:50:03", "3.14.66.123");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3940", "1", "digitaladmin", "2021-11-24 20:55:19", "3.132.213.76");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3941", "1", "digitaladmin", "2021-11-24 21:09:24", "3.144.252.25");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3942", "1", "digitaladmin", "2021-11-24 21:14:48", "18.217.72.56");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3943", "1", "digitaladmin", "2021-11-24 21:38:00", "3.140.207.102");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3944", "1", "digitaladmin", "2021-11-24 21:44:43", "3.21.134.56");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3945", "1", "digitaladmin", "2021-11-24 21:49:46", "18.191.137.231");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3946", "1", "digitaladmin", "2021-11-24 21:55:40", "3.144.234.191");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3947", "1", "digitaladmin", "2021-11-24 22:00:15", "18.188.177.133");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3948", "1", "digitaladmin", "2021-11-24 22:10:14", "18.220.155.140");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3949", "1", "digitaladmin", "2021-11-24 22:22:26", "3.15.165.152");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3950", "1", "digitaladmin", "2021-11-24 22:23:15", "3.144.17.65");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3951", "1", "digitaladmin", "2021-11-24 22:47:53", "18.119.98.39");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3952", "1", "digitaladmin", "2021-11-24 22:51:24", "18.118.146.1");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3953", "1", "digitaladmin", "2021-11-24 22:57:22", "3.15.165.152");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3954", "1", "digitaladmin", "2021-11-24 23:09:03", "18.117.217.200");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3955", "1", "digitaladmin", "2021-11-24 23:16:52", "3.144.196.95");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3956", "1", "digitaladmin", "2021-11-24 23:16:57", "3.144.29.13");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3957", "1", "digitaladmin", "2021-11-24 23:32:14", "3.142.73.191");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3958", "1", "digitaladmin", "2021-11-24 23:44:31", "18.225.32.24");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3959", "1", "digitaladmin", "2021-11-24 23:49:15", "18.221.129.121");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3960", "1", "digitaladmin", "2021-11-24 23:50:42", "3.144.45.44");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3961", "1", "digitaladmin", "2021-11-24 23:56:58", "3.145.48.224");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3962", "1", "digitaladmin", "2021-11-25 00:05:03", "3.144.138.26");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3963", "1", "digitaladmin", "2021-11-25 00:05:29", "3.134.245.125");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3964", "1", "digitaladmin", "2021-11-25 00:20:13", "3.21.207.11");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3965", "1", "digitaladmin", "2021-11-25 00:27:31", "18.217.196.10");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3966", "1", "digitaladmin", "2021-11-25 00:35:19", "18.188.41.224");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3967", "1", "digitaladmin", "2021-11-25 00:40:22", "18.118.12.80");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3968", "1", "digitaladmin", "2021-11-25 00:46:34", "3.136.160.85");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3969", "1", "digitaladmin", "2021-11-25 00:54:18", "3.15.26.4");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3970", "1", "digitaladmin", "2021-11-25 01:03:51", "18.188.200.226");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3971", "1", "digitaladmin", "2021-11-25 01:15:09", "13.58.77.212");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3972", "1", "digitaladmin", "2021-11-25 01:21:32", "3.144.18.27");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3973", "1", "digitaladmin", "2021-11-25 01:34:09", "18.222.113.168");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3974", "1", "digitaladmin", "2021-11-25 01:41:27", "18.119.118.216");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3975", "1", "digitaladmin", "2021-11-25 01:45:03", "3.17.80.240");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3976", "1", "digitaladmin", "2021-11-25 01:51:32", "3.144.80.253");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3977", "1", "digitaladmin", "2021-11-25 01:54:50", "3.19.215.193");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3978", "1", "digitaladmin", "2021-11-25 02:05:38", "18.188.96.26");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3979", "1", "digitaladmin", "2021-11-25 02:15:18", "3.131.96.72");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3980", "1", "digitaladmin", "2021-11-25 02:25:04", "18.225.32.24");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3981", "1", "digitaladmin", "2021-11-25 02:35:27", "18.216.91.108");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3982", "1", "digitaladmin", "2021-11-25 02:37:53", "18.117.122.49");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3983", "1", "digitaladmin", "2021-11-25 02:48:58", "3.129.68.154");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3984", "1", "digitaladmin", "2021-11-25 03:00:18", "3.133.150.58");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3985", "1", "digitaladmin", "2021-11-25 03:15:13", "18.118.143.248");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3986", "1", "digitaladmin", "2021-11-25 03:18:33", "3.15.212.208");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3987", "1", "digitaladmin", "2021-11-25 03:25:11", "18.118.48.197");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3988", "1", "digitaladmin", "2021-11-25 03:30:30", "3.134.105.230");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3989", "1", "digitaladmin", "2021-11-25 03:33:52", "3.144.245.144");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3990", "1", "digitaladmin", "2021-11-25 03:41:55", "18.117.135.6");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3991", "1", "digitaladmin", "2021-11-25 03:53:18", "3.16.46.18");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3992", "1", "digitaladmin", "2021-11-25 04:05:38", "18.220.163.136");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3993", "1", "digitaladmin", "2021-11-25 04:13:38", "3.144.165.3");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3994", "1", "digitaladmin", "2021-11-25 04:17:06", "18.118.46.42");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3995", "1", "digitaladmin", "2021-11-25 04:27:15", "18.117.159.187");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3996", "1", "digitaladmin", "2021-11-25 04:36:18", "18.191.100.79");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3997", "1", "digitaladmin", "2021-11-25 04:48:18", "3.145.68.109");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3998", "1", "digitaladmin", "2021-11-25 04:57:00", "18.117.186.111");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("3999", "1", "digitaladmin", "2021-11-25 05:02:10", "3.142.235.81");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4000", "1", "digitaladmin", "2021-11-25 05:07:58", "3.129.70.109");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4001", "1", "digitaladmin", "2021-11-25 05:11:48", "3.17.75.168");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4002", "1", "digitaladmin", "2021-11-25 05:20:55", "18.119.28.130");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4003", "1", "digitaladmin", "2021-11-25 05:31:13", "3.141.153.220");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4004", "1", "digitaladmin", "2021-11-25 05:42:42", "3.141.0.78");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4005", "1", "digitaladmin", "2021-11-25 05:50:33", "3.15.196.48");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4006", "1", "digitaladmin", "2021-11-25 05:55:14", "13.59.222.1");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4007", "1", "digitaladmin", "2021-11-25 06:06:05", "3.141.202.194");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4008", "1", "digitaladmin", "2021-11-25 06:16:12", "18.118.78.177");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4009", "1", "digitaladmin", "2021-11-25 06:26:38", "3.144.204.49");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4010", "1", "digitaladmin", "2021-11-25 06:38:27", "3.144.115.42");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4011", "1", "digitaladmin", "2021-11-25 06:42:31", "18.222.31.128");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4012", "1", "digitaladmin", "2021-11-25 06:47:12", "3.15.9.62");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4013", "1", "digitaladmin", "2021-11-25 06:50:23", "3.135.188.175");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4014", "1", "digitaladmin", "2021-11-25 06:58:32", "18.217.87.168");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4015", "1", "digitaladmin", "2021-11-25 07:09:58", "18.217.119.145");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4016", "1", "digitaladmin", "2021-11-25 07:19:07", "18.188.51.46");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4017", "1", "digitaladmin", "2021-11-25 07:30:11", "3.131.97.177");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4018", "1", "digitaladmin", "2021-11-25 07:35:00", "18.216.66.251");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4019", "1", "digitaladmin", "2021-11-25 07:44:47", "52.14.70.14");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4020", "1", "digitaladmin", "2021-11-25 07:54:36", "3.144.187.187");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4021", "1", "digitaladmin", "2021-11-25 08:04:28", "18.222.212.54");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4022", "1", "digitaladmin", "2021-11-25 08:14:05", "13.58.76.16");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4023", "1", "digitaladmin", "2021-11-25 08:17:53", "18.219.179.56");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4024", "1", "digitaladmin", "2021-11-25 08:28:41", "3.16.89.19");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4025", "1", "digitaladmin", "2021-11-25 08:39:36", "13.59.99.17");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4026", "1", "digitaladmin", "2021-11-25 09:06:29", "3.23.89.46");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4027", "1", "digitaladmin", "2021-11-25 09:12:23", "18.225.6.102");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4028", "1", "digitaladmin", "2021-11-25 09:20:50", "3.129.63.58");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4029", "1", "digitaladmin", "2021-11-25 09:25:18", "3.144.146.189");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4030", "1", "digitaladmin", "2021-11-25 09:35:14", "13.59.100.143");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4031", "1", "digitaladmin", "2021-11-25 09:50:18", "13.59.141.58");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4032", "1", "digitaladmin", "2021-11-25 10:03:50", "3.144.156.109");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4033", "1", "digitaladmin", "2021-11-25 10:21:54", "3.145.37.29");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4034", "1", "digitaladmin", "2021-11-25 10:25:21", "3.143.22.33");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4035", "1", "digitaladmin", "2021-11-25 10:31:36", "18.222.209.178");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4036", "1", "digitaladmin", "2021-11-25 10:45:18", "3.16.57.11");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4037", "1", "digitaladmin", "2021-11-25 11:02:08", "3.134.79.148");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4038", "1", "digitaladmin", "2021-11-25 11:14:26", "18.219.193.112");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4039", "1", "digitaladmin", "2021-11-25 11:17:46", "3.135.209.27");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4040", "1", "digitaladmin", "2021-11-25 11:29:02", "3.21.134.237");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4041", "1", "digitaladmin", "2021-11-25 11:35:11", "18.216.144.130");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4042", "1", "digitaladmin", "2021-11-25 11:46:00", "18.118.48.197");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4043", "1", "digitaladmin", "2021-11-25 11:57:51", "18.188.41.224");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4044", "1", "digitaladmin", "2021-11-25 12:18:07", "3.15.9.93");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4045", "1", "digitaladmin", "2021-11-25 12:29:57", "3.133.147.120");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4046", "1", "digitaladmin", "2021-11-25 12:33:36", "3.15.1.127");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4047", "1", "digitaladmin", "2021-11-25 12:44:20", "3.144.164.199");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4048", "1", "digitaladmin", "2021-11-25 13:00:58", "3.142.221.117");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4049", "1", "digitaladmin", "2021-11-25 13:17:00", "18.217.63.61");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4050", "1", "digitaladmin", "2021-11-25 13:28:07", "3.20.226.58");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4051", "1", "digitaladmin", "2021-11-25 13:38:46", "3.17.62.118");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4052", "1", "digitaladmin", "2021-11-25 13:44:29", "3.12.148.46");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4053", "1", "digitaladmin", "2021-11-25 13:52:22", "18.222.128.210");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4054", "1", "digitaladmin", "2021-11-25 14:00:31", "52.15.203.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4055", "1", "digitaladmin", "2021-11-25 14:20:31", "3.144.73.50");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4056", "1", "digitaladmin", "2021-11-25 14:35:55", "3.135.228.15");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4057", "1", "digitaladmin", "2021-11-25 14:44:31", "3.140.239.232");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4058", "1", "digitaladmin", "2021-11-25 14:55:14", "52.14.168.126");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4059", "1", "digitaladmin", "2021-11-25 15:05:53", "18.225.10.187");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4060", "1", "digitaladmin", "2021-11-25 15:21:14", "3.16.10.108");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4061", "1", "digitaladmin", "2021-11-25 15:41:21", "3.20.236.67");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4062", "1", "digitaladmin", "2021-11-25 15:50:21", "18.216.136.102");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4063", "1", "digitaladmin", "2021-11-25 15:59:13", "18.221.184.12");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4064", "1", "digitaladmin", "2021-11-25 16:16:51", "52.14.109.158");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4065", "1", "digitaladmin", "2021-11-25 16:22:47", "18.223.203.142");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4066", "1", "digitaladmin", "2021-11-25 16:29:53", "18.116.19.41");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4067", "1", "digitaladmin", "2021-11-25 16:51:15", "18.117.109.127");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4068", "1", "digitaladmin", "2021-11-25 17:14:37", "3.129.68.154");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4069", "1", "digitaladmin", "2021-11-25 17:22:57", "52.15.147.195");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4070", "1", "digitaladmin", "2021-11-25 17:40:12", "3.136.157.87");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4071", "1", "digitaladmin", "2021-11-25 17:45:34", "18.218.235.142");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4072", "1", "digitaladmin", "2021-11-25 18:10:07", "3.144.28.130");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4073", "1", "digitaladmin", "2021-11-25 18:34:10", "3.144.73.50");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4074", "1", "digitaladmin", "2021-11-25 18:40:14", "3.21.39.0");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4075", "1", "digitaladmin", "2021-11-25 18:58:09", "3.144.186.189");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4076", "1", "digitaladmin", "2021-11-25 19:06:02", "13.59.144.6");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4077", "1", "digitaladmin", "2021-11-25 19:30:13", "18.191.81.171");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4078", "1", "digitaladmin", "2021-11-25 19:58:05", "3.145.50.228");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4079", "1", "digitaladmin", "2021-11-25 20:05:18", "3.141.200.214");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4080", "1", "digitaladmin", "2021-11-25 20:26:35", "18.119.124.12");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4081", "1", "digitaladmin", "2021-11-25 20:30:20", "18.118.83.235");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4082", "1", "digitaladmin", "2021-11-25 20:59:40", "18.219.12.243");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4083", "1", "digitaladmin", "2021-11-25 21:01:11", "3.15.4.102");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4084", "1", "digitaladmin", "2021-11-25 21:30:15", "18.119.104.15");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4085", "1", "digitaladmin", "2021-11-25 22:01:48", "18.217.111.91");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4086", "1", "digitaladmin", "2021-11-25 22:30:13", "3.17.139.51");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4087", "1", "digitaladmin", "2021-11-25 22:32:51", "13.58.27.74");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4088", "1", "digitaladmin", "2021-11-25 22:45:46", "3.19.227.196");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4089", "1", "digitaladmin", "2021-11-25 23:02:20", "18.220.95.211");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4090", "1", "digitaladmin", "2021-11-25 23:20:51", "18.116.74.227");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4091", "1", "digitaladmin", "2021-11-25 23:36:17", "3.139.58.32");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4092", "1", "digitaladmin", "2021-11-25 23:50:08", "3.144.220.97");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4093", "1", "digitaladmin", "2021-11-25 23:57:37", "18.119.100.210");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4094", "1", "digitaladmin", "2021-11-26 00:03:37", "3.142.221.65");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4095", "1", "digitaladmin", "2021-11-26 00:25:12", "3.144.27.109");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4096", "1", "digitaladmin", "2021-11-26 00:43:22", "18.221.127.179");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4097", "1", "digitaladmin", "2021-11-26 00:54:44", "3.144.149.170");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4098", "1", "digitaladmin", "2021-11-26 00:59:23", "13.59.11.116");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4099", "1", "digitaladmin", "2021-11-26 01:06:45", "18.224.21.170");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4100", "1", "digitaladmin", "2021-11-26 01:27:14", "3.143.231.40");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4101", "1", "digitaladmin", "2021-11-26 01:54:27", "3.141.1.133");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4102", "1", "digitaladmin", "2021-11-26 02:05:24", "18.217.95.240");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4103", "1", "digitaladmin", "2021-11-26 02:08:09", "18.218.90.171");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4104", "1", "digitaladmin", "2021-11-26 02:17:57", "18.224.18.207");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4105", "1", "digitaladmin", "2021-11-26 02:30:49", "18.191.207.86");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4106", "1", "digitaladmin", "2021-11-26 02:38:08", "3.138.121.116");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4107", "1", "digitaladmin", "2021-11-26 02:54:29", "3.142.97.226");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4108", "1", "digitaladmin", "2021-11-26 03:18:54", "3.136.156.192");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4109", "1", "digitaladmin", "2021-11-26 03:27:32", "3.18.110.43");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4110", "1", "digitaladmin", "2021-11-26 03:40:16", "3.137.217.163");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4111", "1", "digitaladmin", "2021-11-26 03:49:36", "18.217.31.171");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4112", "1", "digitaladmin", "2021-11-26 04:01:53", "18.191.224.169");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4113", "1", "digitaladmin", "2021-11-26 04:29:04", "3.22.171.161");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4114", "1", "digitaladmin", "2021-11-26 04:40:50", "18.117.188.65");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4115", "1", "digitaladmin", "2021-11-26 04:48:28", "3.141.153.100");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4116", "1", "digitaladmin", "2021-11-26 05:07:25", "18.216.168.222");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4117", "1", "digitaladmin", "2021-11-26 05:12:31", "18.222.190.178");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4118", "1", "digitaladmin", "2021-11-26 05:25:36", "18.118.252.136");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4119", "1", "digitaladmin", "2021-11-26 05:39:56", "3.129.211.8");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4120", "1", "digitaladmin", "2021-11-26 05:59:10", "3.17.28.252");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4121", "1", "digitaladmin", "2021-11-26 06:12:08", "3.144.142.160");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4122", "1", "digitaladmin", "2021-11-26 06:19:07", "18.221.12.238");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4123", "1", "digitaladmin", "2021-11-26 06:28:26", "3.135.200.197");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4124", "1", "digitaladmin", "2021-11-26 06:49:23", "3.16.125.52");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4125", "1", "digitaladmin", "2021-11-26 07:10:22", "52.14.35.109");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4126", "1", "digitaladmin", "2021-11-26 07:20:34", "3.144.181.145");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4127", "1", "digitaladmin", "2021-11-26 07:30:19", "3.142.239.104");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4128", "1", "digitaladmin", "2021-11-26 07:38:10", "3.139.96.98");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4129", "1", "digitaladmin", "2021-11-26 07:59:21", "3.142.97.226");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4130", "1", "digitaladmin", "2021-11-26 08:18:29", "18.189.17.28");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4131", "1", "digitaladmin", "2021-11-26 08:29:41", "18.222.154.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4132", "1", "digitaladmin", "2021-11-26 08:33:15", "3.141.103.114");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4133", "1", "digitaladmin", "2021-11-26 08:45:09", "3.144.161.200");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4134", "1", "digitaladmin", "2021-11-26 08:45:53", "18.222.187.233");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4135", "1", "digitaladmin", "2021-11-26 08:55:34", "3.16.83.120");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4136", "1", "digitaladmin", "2021-11-26 08:56:38", "3.145.50.228");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4137", "1", "digitaladmin", "2021-11-26 09:08:55", "18.219.107.201");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4138", "1", "digitaladmin", "2021-11-26 09:18:20", "3.144.108.225");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4139", "1", "digitaladmin", "2021-11-26 09:22:11", "18.116.36.150");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4140", "1", "digitaladmin", "2021-11-26 09:27:02", "18.221.25.160");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4141", "1", "digitaladmin", "2021-11-26 09:47:02", "3.139.86.93");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4142", "1", "digitaladmin", "2021-11-26 09:54:34", "18.218.159.51");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4143", "1", "digitaladmin", "2021-11-26 10:23:58", "3.144.189.139");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4144", "1", "digitaladmin", "2021-11-26 10:24:06", "3.18.109.219");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4145", "1", "digitaladmin", "2021-11-26 10:30:23", "18.222.128.210");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4146", "1", "digitaladmin", "2021-11-26 10:36:58", "3.14.84.108");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4147", "1", "digitaladmin", "2021-11-26 10:45:14", "3.22.217.203");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4148", "1", "digitaladmin", "2021-11-26 11:05:22", "3.142.186.39");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4149", "1", "digitaladmin", "2021-11-26 11:20:44", "18.222.150.193");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4150", "1", "digitaladmin", "2021-11-26 11:31:15", "3.21.166.101");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4151", "1", "digitaladmin", "2021-11-26 11:39:21", "18.217.57.117");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4152", "1", "digitaladmin", "2021-11-26 11:47:30", "3.17.174.28");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4153", "1", "digitaladmin", "2021-11-26 12:05:25", "52.14.209.168");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4154", "1", "digitaladmin", "2021-11-26 12:21:34", "3.18.112.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4155", "1", "digitaladmin", "2021-11-26 12:33:39", "3.133.96.223");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4156", "1", "digitaladmin", "2021-11-26 12:39:28", "3.144.8.2");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4157", "1", "digitaladmin", "2021-11-26 12:48:51", "18.216.16.109");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4158", "1", "digitaladmin", "2021-11-26 12:59:34", "3.134.253.249");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4159", "1", "digitaladmin", "2021-11-26 13:09:34", "18.222.188.89");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4160", "1", "digitaladmin", "2021-11-26 13:28:57", "3.138.195.33");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4161", "1", "digitaladmin", "2021-11-26 13:41:46", "3.144.153.137");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4162", "1", "digitaladmin", "2021-11-26 13:50:45", "3.15.196.48");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4163", "1", "digitaladmin", "2021-11-26 13:57:39", "3.17.24.65");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4164", "1", "digitaladmin", "2021-11-26 14:08:27", "18.219.14.182");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4165", "1", "digitaladmin", "2021-11-26 14:27:18", "18.118.132.117");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4166", "1", "digitaladmin", "2021-11-26 14:43:49", "3.136.106.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4167", "1", "digitaladmin", "2021-11-26 14:54:02", "3.19.219.67");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4168", "1", "digitaladmin", "2021-11-26 15:00:16", "3.22.27.184");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4169", "1", "digitaladmin", "2021-11-26 15:18:01", "3.17.160.183");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4170", "1", "digitaladmin", "2021-11-26 15:21:32", "18.188.227.204");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4171", "1", "digitaladmin", "2021-11-26 15:29:22", "3.23.85.189");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4172", "1", "digitaladmin", "2021-11-26 15:46:44", "3.142.220.6");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4173", "1", "digitaladmin", "2021-11-26 16:08:44", "3.142.123.111");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4174", "1", "digitaladmin", "2021-11-26 16:16:26", "3.145.67.122");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4175", "1", "digitaladmin", "2021-11-26 16:29:29", "13.58.64.171");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4176", "1", "digitaladmin", "2021-11-26 16:36:05", "3.128.29.99");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4177", "1", "digitaladmin", "2021-11-26 16:57:22", "18.188.94.242");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4178", "1", "digitaladmin", "2021-11-26 17:18:48", "18.188.61.112");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4179", "1", "digitaladmin", "2021-11-26 17:22:03", "18.224.229.38");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4180", "1", "digitaladmin", "2021-11-26 17:43:16", "3.142.246.94");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4181", "1", "digitaladmin", "2021-11-26 17:50:17", "3.145.54.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4182", "1", "digitaladmin", "2021-11-26 18:15:13", "18.217.93.223");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4183", "1", "digitaladmin", "2021-11-26 18:41:21", "3.145.16.201");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4184", "1", "digitaladmin", "2021-11-26 18:47:07", "18.225.33.114");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4185", "1", "digitaladmin", "2021-11-26 19:08:34", "3.145.70.1");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4186", "1", "digitaladmin", "2021-11-26 19:13:28", "3.135.232.220");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4187", "1", "digitaladmin", "2021-11-26 19:34:34", "13.58.78.31");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4188", "1", "digitaladmin", "2021-11-26 19:39:18", "18.116.85.92");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4189", "1", "digitaladmin", "2021-11-26 20:10:33", "3.14.244.3");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4190", "1", "digitaladmin", "2021-11-26 20:33:47", "18.119.165.101");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4191", "1", "digitaladmin", "2021-11-26 20:38:16", "18.116.63.146");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4192", "1", "digitaladmin", "2021-11-26 21:00:11", "52.14.114.141");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4193", "1", "digitaladmin", "2021-11-26 21:03:09", "18.218.135.72");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4194", "1", "digitaladmin", "2021-11-26 21:30:13", "3.16.57.11");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4195", "1", "digitaladmin", "2021-11-26 21:53:26", "3.141.42.38");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4196", "1", "digitaladmin", "2021-11-26 22:08:16", "18.221.205.203");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4197", "1", "digitaladmin", "2021-11-26 22:11:44", "3.129.68.241");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4198", "1", "digitaladmin", "2021-11-26 22:20:54", "18.216.135.62");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4199", "1", "digitaladmin", "2021-11-26 22:22:54", "18.119.134.214");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4200", "1", "digitaladmin", "2021-11-26 22:34:17", "3.19.227.15");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4201", "1", "digitaladmin", "2021-11-26 22:47:40", "3.144.87.47");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4202", "1", "digitaladmin", "2021-11-26 23:04:10", "3.144.195.131");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4203", "1", "digitaladmin", "2021-11-26 23:14:03", "18.118.18.225");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4204", "1", "digitaladmin", "2021-11-26 23:16:56", "18.188.60.86");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4205", "1", "digitaladmin", "2021-11-26 23:32:20", "18.224.110.201");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4206", "1", "digitaladmin", "2021-11-26 23:42:36", "18.219.165.244");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4207", "1", "digitaladmin", "2021-11-26 23:45:03", "13.59.181.132");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4208", "1", "digitaladmin", "2021-11-27 00:02:24", "3.132.213.62");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4209", "1", "digitaladmin", "2021-11-27 00:05:45", "18.224.93.58");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4210", "1", "digitaladmin", "2021-11-27 00:14:37", "3.14.152.242");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4211", "1", "digitaladmin", "2021-11-27 00:19:28", "3.138.137.225");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4212", "1", "digitaladmin", "2021-11-27 00:21:11", "3.145.75.166");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4213", "1", "digitaladmin", "2021-11-27 00:51:39", "18.117.188.65");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4214", "1", "digitaladmin", "2021-11-27 00:52:13", "3.16.212.216");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4215", "1", "digitaladmin", "2021-11-27 00:55:41", "18.216.14.48");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4216", "1", "digitaladmin", "2021-11-27 01:02:44", "18.219.144.128");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4217", "1", "digitaladmin", "2021-11-27 01:06:48", "3.141.202.194");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4218", "1", "digitaladmin", "2021-11-27 01:26:09", "3.145.43.214");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4219", "1", "digitaladmin", "2021-11-27 01:36:16", "3.145.22.85");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4220", "1", "digitaladmin", "2021-11-27 01:49:10", "3.144.202.241");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4221", "1", "digitaladmin", "2021-11-27 01:49:22", "3.139.57.42");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4222", "1", "digitaladmin", "2021-11-27 02:01:31", "18.119.133.80");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4223", "1", "digitaladmin", "2021-11-27 02:04:33", "3.144.236.145");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4224", "1", "digitaladmin", "2021-11-27 02:13:45", "3.14.71.238");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4225", "1", "digitaladmin", "2021-11-27 02:28:40", "3.144.2.118");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4226", "1", "digitaladmin", "2021-11-27 02:39:31", "18.222.135.82");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4227", "1", "digitaladmin", "2021-11-27 02:53:34", "13.58.195.203");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4228", "1", "digitaladmin", "2021-11-27 02:55:16", "18.191.133.49");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4229", "1", "digitaladmin", "2021-11-27 03:04:22", "3.145.42.228");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4230", "1", "digitaladmin", "2021-11-27 03:21:02", "18.222.163.3");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4231", "1", "digitaladmin", "2021-11-27 03:32:40", "18.219.63.57");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4232", "1", "digitaladmin", "2021-11-27 03:44:03", "18.118.16.41");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4233", "1", "digitaladmin", "2021-11-27 03:45:05", "18.222.186.161");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4234", "1", "digitaladmin", "2021-11-27 03:59:59", "18.119.107.88");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4235", "1", "digitaladmin", "2021-11-27 04:10:59", "52.15.116.225");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4236", "1", "digitaladmin", "2021-11-27 04:26:06", "18.116.40.67");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4237", "1", "digitaladmin", "2021-11-27 04:34:55", "3.128.203.120");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4238", "1", "digitaladmin", "2021-11-27 04:40:58", "18.219.186.105");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4239", "1", "digitaladmin", "2021-11-27 04:50:24", "13.58.158.231");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4240", "1", "digitaladmin", "2021-11-27 04:52:16", "3.137.139.99");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4241", "1", "digitaladmin", "2021-11-27 05:02:46", "3.17.178.118");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4242", "1", "digitaladmin", "2021-11-27 05:15:15", "52.15.220.96");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4243", "1", "digitaladmin", "2021-11-27 05:29:25", "3.21.154.70");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4244", "1", "digitaladmin", "2021-11-27 05:40:19", "13.58.16.32");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4245", "1", "digitaladmin", "2021-11-27 05:40:45", "3.12.147.137");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4246", "1", "digitaladmin", "2021-11-27 05:53:33", "18.118.122.129");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4247", "1", "digitaladmin", "2021-11-27 06:07:04", "18.117.74.60");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4248", "1", "digitaladmin", "2021-11-27 06:20:47", "18.191.191.150");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4249", "1", "digitaladmin", "2021-11-27 06:32:26", "18.191.152.107");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4250", "1", "digitaladmin", "2021-11-27 06:32:38", "18.191.224.169");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4251", "1", "digitaladmin", "2021-11-27 06:44:27", "18.189.192.186");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4252", "1", "digitaladmin", "2021-11-27 06:46:34", "3.15.153.61");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4253", "1", "digitaladmin", "2021-11-27 06:58:01", "3.133.111.164");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4254", "1", "digitaladmin", "2021-11-27 07:12:18", "3.142.219.0");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4255", "1", "digitaladmin", "2021-11-27 07:24:46", "3.143.7.69");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4256", "1", "digitaladmin", "2021-11-27 07:37:18", "3.142.219.0");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4257", "1", "digitaladmin", "2021-11-27 07:38:42", "18.118.160.29");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4258", "1", "digitaladmin", "2021-11-27 07:52:17", "18.222.163.3");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4259", "1", "digitaladmin", "2021-11-27 08:04:58", "13.58.158.231");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4260", "1", "digitaladmin", "2021-11-27 08:16:25", "18.189.17.140");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4261", "1", "digitaladmin", "2021-11-27 08:29:02", "18.217.237.250");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4262", "1", "digitaladmin", "2021-11-27 08:31:30", "18.216.135.62");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4263", "1", "digitaladmin", "2021-11-27 08:43:03", "18.222.44.234");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4264", "1", "digitaladmin", "2021-11-27 08:45:30", "3.133.118.200");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4265", "1", "digitaladmin", "2021-11-27 08:53:59", "18.218.248.87");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4266", "1", "digitaladmin", "2021-11-27 09:10:54", "18.216.195.48");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4267", "1", "digitaladmin", "2021-11-27 09:23:43", "3.145.39.60");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4268", "1", "digitaladmin", "2021-11-27 09:38:38", "18.225.35.139");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4269", "1", "digitaladmin", "2021-11-27 09:40:21", "3.131.157.189");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4270", "1", "digitaladmin", "2021-11-27 09:51:37", "18.216.238.152");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4271", "1", "digitaladmin", "2021-11-27 10:03:14", "18.117.74.3");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4272", "1", "digitaladmin", "2021-11-27 10:20:27", "18.223.205.226");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4273", "1", "digitaladmin", "2021-11-27 10:30:43", "3.143.110.46");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4274", "1", "digitaladmin", "2021-11-27 10:36:39", "18.191.247.13");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4275", "1", "digitaladmin", "2021-11-27 10:48:58", "3.133.139.110");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4276", "1", "digitaladmin", "2021-11-27 10:54:45", "3.131.169.197");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4277", "1", "digitaladmin", "2021-11-27 11:05:08", "3.145.38.53");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4278", "1", "digitaladmin", "2021-11-27 11:19:39", "18.117.105.181");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4279", "1", "digitaladmin", "2021-11-27 11:34:53", "13.58.218.14");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4280", "1", "digitaladmin", "2021-11-27 11:51:25", "18.219.17.81");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4281", "1", "digitaladmin", "2021-11-27 11:54:52", "18.219.63.57");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4282", "1", "digitaladmin", "2021-11-27 12:03:47", "52.15.238.38");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4283", "1", "digitaladmin", "2021-11-27 12:20:13", "18.119.107.88");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4284", "1", "digitaladmin", "2021-11-27 12:40:16", "18.222.64.236");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4285", "1", "digitaladmin", "2021-11-27 12:46:35", "18.222.164.77");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4286", "1", "digitaladmin", "2021-11-27 12:51:38", "3.134.105.27");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4287", "1", "digitaladmin", "2021-11-27 13:02:17", "18.224.62.53");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4288", "1", "digitaladmin", "2021-11-27 13:23:40", "3.143.236.92");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4289", "1", "digitaladmin", "2021-11-27 13:35:21", "3.133.123.7");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4290", "1", "digitaladmin", "2021-11-27 13:45:14", "3.14.11.6");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4291", "1", "digitaladmin", "2021-11-27 13:51:41", "18.119.138.91");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4292", "1", "digitaladmin", "2021-11-27 14:02:50", "18.117.240.67");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4293", "1", "digitaladmin", "2021-11-27 14:13:02", "18.222.29.211");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4294", "1", "digitaladmin", "2021-11-27 14:46:47", "3.140.250.36");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4295", "1", "digitaladmin", "2021-11-27 15:01:00", "18.223.205.198");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4296", "1", "digitaladmin", "2021-11-27 15:05:22", "3.139.56.219");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4297", "1", "digitaladmin", "2021-11-27 15:34:35", "3.135.215.202");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4298", "1", "digitaladmin", "2021-11-27 15:35:16", "18.189.30.93");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4299", "1", "digitaladmin", "2021-11-27 16:11:31", "13.59.189.214");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4300", "1", "digitaladmin", "2021-11-27 16:20:01", "3.144.148.110");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4301", "1", "digitaladmin", "2021-11-27 16:30:05", "18.220.246.59");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4302", "1", "digitaladmin", "2021-11-27 17:06:52", "18.217.149.114");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4303", "1", "digitaladmin", "2021-11-27 17:12:58", "3.12.104.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4304", "1", "digitaladmin", "2021-11-27 17:45:22", "18.217.130.101");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4305", "1", "digitaladmin", "2021-11-27 17:49:38", "18.220.217.189");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4306", "0", "admin", "2021-11-27 18:27:41", "103.110.84.33");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4307", "1", "digitaladmin", "2021-11-27 18:31:13", "3.145.36.156");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4308", "0", "admin", "2021-11-27 18:33:43", "139.196.88.192");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4309", "0", "admin", "2021-11-27 18:36:01", "207.55.255.20");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4310", "0", "admin", "2021-11-27 18:41:17", "211.37.147.188");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4311", "1", "digitaladmin", "2021-11-27 18:43:27", "184.171.244.172");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4312", "1", "digitaladmin", "2021-11-27 18:48:18", "110.173.132.17");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4313", "1", "digitaladmin", "2021-11-27 18:50:12", "194.87.190.39");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4314", "1", "digitaladmin", "2021-11-27 18:54:55", "67.205.155.142");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4315", "1", "digitaladmin", "2021-11-27 18:56:57", "120.79.29.217");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4316", "1", "digitaladmin", "2021-11-27 19:01:33", "167.99.12.47");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4317", "1", "digitaladmin", "2021-11-27 19:03:04", "198.12.253.113");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4318", "1", "digitaladmin", "2021-11-27 19:08:04", "193.189.75.222");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4319", "1", "digitaladmin", "2021-11-27 19:09:16", "186.234.80.35");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4320", "1", "digitaladmin", "2021-11-27 19:14:12", "3.131.97.25");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4321", "1", "digitaladmin", "2021-11-27 19:15:43", "159.65.7.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4322", "1", "digitaladmin", "2021-11-27 19:17:26", "18.225.6.48");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4323", "1", "digitaladmin", "2021-11-27 19:20:58", "159.203.176.82");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4324", "1", "digitaladmin", "2021-11-27 19:22:15", "112.196.72.188");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4325", "1", "digitaladmin", "2021-11-27 19:26:53", "185.61.153.77");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4326", "1", "digitaladmin", "2021-11-27 19:28:31", "107.180.88.41");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4327", "1", "digitaladmin", "2021-11-27 19:33:15", "157.245.240.102");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4328", "1", "digitaladmin", "2021-11-27 19:34:48", "103.110.84.33");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4329", "1", "digitaladmin", "2021-11-27 19:39:38", "51.91.229.252");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4330", "1", "digitaladmin", "2021-11-27 19:41:08", "207.55.255.20");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4331", "1", "digitaladmin", "2021-11-27 19:45:35", "190.92.141.251");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4332", "1", "digitaladmin", "2021-11-27 19:46:47", "201.220.156.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4333", "1", "digitaladmin", "2021-11-27 19:51:43", "190.92.152.62");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4334", "1", "digitaladmin", "2021-11-27 19:52:51", "31.177.95.27");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4335", "1", "digitaladmin", "2021-11-27 19:57:20", "103.150.221.228");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4336", "1", "digitaladmin", "2021-11-27 19:58:59", "216.245.215.122");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4337", "1", "digitaladmin", "2021-11-27 19:59:54", "18.220.136.90");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4338", "1", "digitaladmin", "2021-11-27 20:01:18", "3.14.146.37");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4339", "1", "digitaladmin", "2021-11-27 20:03:41", "185.104.44.147");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4340", "1", "digitaladmin", "2021-11-27 20:05:03", "162.55.43.51");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4341", "1", "digitaladmin", "2021-11-27 20:09:40", "194.163.159.35");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4342", "1", "digitaladmin", "2021-11-27 20:11:15", "164.68.110.108");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4343", "1", "digitaladmin", "2021-11-27 20:15:17", "31.220.41.16");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4344", "1", "digitaladmin", "2021-11-27 20:16:55", "184.171.244.172");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4345", "1", "digitaladmin", "2021-11-27 20:21:07", "185.61.153.77");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4346", "1", "digitaladmin", "2021-11-27 20:22:46", "162.214.122.88");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4347", "1", "digitaladmin", "2021-11-27 20:27:11", "67.205.3.168");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4348", "1", "digitaladmin", "2021-11-27 20:28:21", "182.254.234.148");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4349", "1", "digitaladmin", "2021-11-27 20:32:36", "110.173.132.17");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4350", "1", "digitaladmin", "2021-11-27 20:34:22", "194.163.159.35");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4351", "1", "digitaladmin", "2021-11-27 20:38:36", "107.173.165.214");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4352", "1", "digitaladmin", "2021-11-27 20:39:54", "150.95.110.113");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4353", "1", "digitaladmin", "2021-11-27 20:43:49", "3.137.154.137");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4354", "1", "digitaladmin", "2021-11-27 20:43:57", "196.203.219.49");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4355", "1", "digitaladmin", "2021-11-27 20:49:17", "67.205.155.142");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4356", "1", "digitaladmin", "2021-11-27 20:51:06", "185.106.130.251");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4357", "1", "digitaladmin", "2021-11-27 20:55:31", "216.245.215.122");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4358", "1", "digitaladmin", "2021-11-27 20:56:45", "66.115.173.18");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4359", "1", "digitaladmin", "2021-11-27 21:01:07", "194.87.190.39");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4360", "1", "digitaladmin", "2021-11-27 21:02:22", "46.101.100.156");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4361", "1", "digitaladmin", "2021-11-27 21:06:26", "143.110.220.55");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4362", "1", "digitaladmin", "2021-11-27 21:07:40", "47.242.238.58");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4363", "1", "digitaladmin", "2021-11-27 21:12:04", "139.196.88.192");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4364", "1", "digitaladmin", "2021-11-27 21:18:02", "195.252.155.49");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4365", "1", "digitaladmin", "2021-11-27 21:19:04", "147.182.182.104");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4366", "1", "digitaladmin", "2021-11-27 21:23:28", "216.245.215.122");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4367", "1", "digitaladmin", "2021-11-27 21:24:32", "188.166.221.10");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4368", "1", "digitaladmin", "2021-11-27 21:29:01", "23.99.97.154");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4369", "1", "digitaladmin", "2021-11-27 21:30:35", "111.93.56.221");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4370", "1", "digitaladmin", "2021-11-27 21:31:35", "3.18.102.59");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4371", "1", "digitaladmin", "2021-11-27 21:34:35", "185.70.11.21");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4372", "1", "digitaladmin", "2021-11-27 21:35:32", "159.65.65.170");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4373", "1", "digitaladmin", "2021-11-27 21:37:07", "18.216.66.255");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4374", "1", "digitaladmin", "2021-11-27 21:39:45", "125.206.171.197");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4375", "1", "digitaladmin", "2021-11-27 21:41:36", "162.214.185.239");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4376", "1", "digitaladmin", "2021-11-27 21:45:38", "39.106.105.38");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4377", "1", "digitaladmin", "2021-11-27 21:47:06", "128.199.248.200");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4378", "1", "digitaladmin", "2021-11-27 21:51:30", "159.203.176.82");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4379", "1", "digitaladmin", "2021-11-27 21:52:58", "164.68.99.251");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4380", "1", "digitaladmin", "2021-11-27 21:58:48", "64.235.231.20");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4381", "1", "digitaladmin", "2021-11-27 22:03:05", "185.183.122.143");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4382", "1", "digitaladmin", "2021-11-27 22:04:32", "103.8.25.22");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4383", "1", "digitaladmin", "2021-11-27 22:08:57", "103.110.84.33");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4384", "1", "digitaladmin", "2021-11-27 22:10:06", "162.144.41.156");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4385", "1", "digitaladmin", "2021-11-27 22:14:50", "159.203.176.82");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4386", "1", "digitaladmin", "2021-11-27 22:15:12", "3.145.1.243");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4387", "1", "digitaladmin", "2021-11-27 22:16:19", "190.92.152.62");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4388", "1", "digitaladmin", "2021-11-27 22:20:39", "104.197.170.10");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4389", "1", "digitaladmin", "2021-11-27 22:21:55", "128.199.245.109");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4390", "1", "digitaladmin", "2021-11-27 22:22:28", "3.145.75.166");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4391", "1", "digitaladmin", "2021-11-27 22:26:38", "103.74.118.242");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4392", "1", "digitaladmin", "2021-11-27 22:28:21", "38.107.221.192");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4393", "1", "digitaladmin", "2021-11-27 22:32:51", "176.235.216.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4394", "1", "digitaladmin", "2021-11-27 22:34:01", "62.210.209.245");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4395", "1", "digitaladmin", "2021-11-27 22:40:16", "178.62.110.145");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4396", "1", "digitaladmin", "2021-11-27 22:45:00", "162.214.229.147");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4397", "1", "digitaladmin", "2021-11-27 22:46:14", "167.99.78.164");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4398", "1", "digitaladmin", "2021-11-27 22:51:05", "103.129.178.69");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4399", "1", "digitaladmin", "2021-11-27 22:52:49", "64.235.231.20");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4400", "1", "digitaladmin", "2021-11-27 22:56:54", "96.125.171.153");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4401", "1", "digitaladmin", "2021-11-27 22:58:44", "45.119.84.149");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4402", "1", "digitaladmin", "2021-11-27 22:58:49", "18.223.255.244");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4403", "1", "digitaladmin", "2021-11-27 23:03:29", "213.149.103.132");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4404", "1", "digitaladmin", "2021-11-27 23:04:25", "3.143.141.53");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4405", "1", "digitaladmin", "2021-11-27 23:04:47", "103.74.118.242");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4406", "1", "digitaladmin", "2021-11-27 23:09:19", "106.12.77.101");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4407", "1", "digitaladmin", "2021-11-27 23:10:53", "103.150.221.228");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4408", "1", "digitaladmin", "2021-11-27 23:15:35", "114.55.35.75");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4409", "1", "digitaladmin", "2021-11-27 23:17:08", "39.106.105.38");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4410", "1", "digitaladmin", "2021-11-27 23:22:13", "81.70.151.13");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4411", "1", "digitaladmin", "2021-11-27 23:23:52", "35.193.222.165");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4412", "1", "digitaladmin", "2021-11-27 23:28:27", "141.85.216.231");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4413", "1", "digitaladmin", "2021-11-27 23:30:00", "216.158.230.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4414", "1", "digitaladmin", "2021-11-27 23:36:22", "51.91.123.235");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4415", "1", "digitaladmin", "2021-11-27 23:41:21", "52.188.165.124");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4416", "1", "digitaladmin", "2021-11-27 23:42:36", "68.183.192.217");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4417", "1", "digitaladmin", "2021-11-27 23:47:18", "194.233.75.156");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4418", "1", "digitaladmin", "2021-11-27 23:49:09", "159.203.176.82");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4419", "1", "digitaladmin", "2021-11-27 23:50:04", "52.15.56.12");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4420", "1", "digitaladmin", "2021-11-27 23:54:12", "8.129.20.30");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4421", "1", "digitaladmin", "2021-11-27 23:55:40", "141.94.21.233");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4422", "1", "digitaladmin", "2021-11-28 00:00:39", "67.211.219.84");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4423", "1", "digitaladmin", "2021-11-28 00:01:58", "142.93.113.173");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4424", "1", "digitaladmin", "2021-11-28 00:08:45", "5.189.138.128");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4425", "1", "digitaladmin", "2021-11-28 00:13:38", "103.8.25.22");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4426", "1", "digitaladmin", "2021-11-28 00:15:16", "51.91.123.235");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4427", "1", "digitaladmin", "2021-11-28 00:20:30", "13.76.132.231");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4428", "1", "digitaladmin", "2021-11-28 00:21:47", "75.119.193.23");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4429", "1", "digitaladmin", "2021-11-28 00:24:52", "3.143.173.119");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4430", "1", "digitaladmin", "2021-11-28 00:26:35", "18.191.199.192");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4431", "1", "digitaladmin", "2021-11-28 00:28:34", "93.113.111.100");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4432", "1", "digitaladmin", "2021-11-28 00:33:30", "45.64.54.158");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4433", "1", "digitaladmin", "2021-11-28 00:35:09", "5.63.10.206");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4434", "1", "digitaladmin", "2021-11-28 00:40:14", "62.109.11.92");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4435", "0", "admin", "2021-11-28 00:57:33", "192.64.150.25");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4436", "0", "admin", "2021-11-28 01:04:04", "162.214.114.242");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4437", "0", "admin", "2021-11-28 01:09:08", "46.101.95.65");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4438", "1", "digitaladmin", "2021-11-28 01:10:26", "47.106.201.134");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4439", "1", "digitaladmin", "2021-11-28 01:14:43", "18.220.88.35");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4440", "1", "digitaladmin", "2021-11-28 01:15:51", "212.224.76.233");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4441", "1", "digitaladmin", "2021-11-28 01:16:49", "18.219.251.190");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4442", "1", "digitaladmin", "2021-11-28 01:17:33", "64.37.52.2");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4443", "1", "digitaladmin", "2021-11-28 01:22:41", "194.9.80.138");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4444", "1", "digitaladmin", "2021-11-28 01:23:55", "134.122.46.215");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4445", "1", "digitaladmin", "2021-11-28 01:29:29", "191.234.176.158");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4446", "1", "digitaladmin", "2021-11-28 01:31:05", "213.149.103.132");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4447", "1", "digitaladmin", "2021-11-28 01:36:18", "103.120.177.74");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4448", "1", "digitaladmin", "2021-11-28 01:37:56", "5.101.157.216");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4449", "1", "digitaladmin", "2021-11-28 01:43:09", "167.99.12.47");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4450", "1", "digitaladmin", "2021-11-28 01:44:34", "148.72.210.140");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4451", "1", "digitaladmin", "2021-11-28 01:51:48", "173.212.214.140");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4452", "1", "digitaladmin", "2021-11-28 01:57:03", "81.68.144.158");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4453", "1", "digitaladmin", "2021-11-28 01:58:21", "52.15.86.59");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4454", "1", "digitaladmin", "2021-11-28 01:58:36", "8.141.58.239");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4455", "1", "digitaladmin", "2021-11-28 02:04:00", "167.99.12.47");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4456", "1", "digitaladmin", "2021-11-28 02:05:53", "150.95.110.113");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4457", "1", "digitaladmin", "2021-11-28 02:11:12", "162.144.41.156");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4458", "1", "digitaladmin", "2021-11-28 02:12:47", "196.44.176.55");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4459", "1", "digitaladmin", "2021-11-28 02:17:45", "195.34.83.112");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4460", "1", "digitaladmin", "2021-11-28 02:19:33", "178.128.54.239");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4461", "1", "digitaladmin", "2021-11-28 02:24:54", "101.32.62.175");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4462", "1", "digitaladmin", "2021-11-28 02:26:42", "74.208.103.228");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4463", "1", "digitaladmin", "2021-11-28 02:32:23", "8.129.20.30");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4464", "1", "digitaladmin", "2021-11-28 02:34:00", "80.80.218.230");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4465", "1", "digitaladmin", "2021-11-28 02:39:05", "174.138.33.114");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4466", "1", "digitaladmin", "2021-11-28 02:41:15", "34.68.97.70");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4467", "1", "digitaladmin", "2021-11-28 02:41:40", "18.117.80.98");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4468", "1", "digitaladmin", "2021-11-28 02:46:46", "85.17.88.170");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4469", "1", "digitaladmin", "2021-11-28 02:48:03", "125.206.171.197");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4470", "1", "digitaladmin", "2021-11-28 02:49:26", "18.118.137.107");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4471", "1", "digitaladmin", "2021-11-28 02:53:55", "51.81.245.120");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4472", "1", "digitaladmin", "2021-11-28 02:55:45", "185.252.31.66");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4473", "1", "digitaladmin", "2021-11-28 03:01:03", "54.183.197.218");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4474", "1", "digitaladmin", "2021-11-28 03:02:26", "104.131.18.212");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4475", "1", "digitaladmin", "2021-11-28 03:07:53", "178.128.14.157");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4476", "1", "digitaladmin", "2021-11-28 03:10:03", "176.235.216.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4477", "1", "digitaladmin", "2021-11-28 03:15:38", "196.203.219.49");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4478", "1", "digitaladmin", "2021-11-28 03:17:13", "162.214.208.84");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4479", "1", "digitaladmin", "2021-11-28 03:23:03", "8.131.70.186");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4480", "1", "digitaladmin", "2021-11-28 03:24:45", "192.64.150.25");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4481", "1", "digitaladmin", "2021-11-28 03:30:04", "35.195.135.67");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4482", "1", "digitaladmin", "2021-11-28 03:30:43", "3.16.50.28");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4483", "1", "digitaladmin", "2021-11-28 03:31:05", "18.116.234.234");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4484", "1", "digitaladmin", "2021-11-28 03:31:56", "176.235.216.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4485", "1", "digitaladmin", "2021-11-28 03:37:21", "64.37.52.2");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4486", "1", "digitaladmin", "2021-11-28 03:39:13", "144.217.170.24");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4487", "1", "digitaladmin", "2021-11-28 03:44:22", "35.236.172.75");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4488", "1", "digitaladmin", "2021-11-28 03:46:34", "162.214.151.12");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4489", "1", "digitaladmin", "2021-11-28 03:52:17", "91.205.175.35");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4490", "1", "digitaladmin", "2021-11-28 03:54:01", "190.92.152.62");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4491", "1", "digitaladmin", "2021-11-28 04:01:18", "45.64.54.158");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4492", "1", "digitaladmin", "2021-11-28 04:07:01", "162.240.10.70");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4493", "1", "digitaladmin", "2021-11-28 04:08:54", "67.205.31.50");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4494", "1", "digitaladmin", "2021-11-28 04:14:03", "195.34.83.112");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4495", "1", "digitaladmin", "2021-11-28 04:16:20", "34.68.97.70");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4496", "1", "digitaladmin", "2021-11-28 04:17:44", "18.221.168.153");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4497", "1", "digitaladmin", "2021-11-28 04:19:51", "18.218.248.87");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4498", "1", "digitaladmin", "2021-11-28 04:22:01", "103.101.161.52");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4499", "1", "digitaladmin", "2021-11-28 04:24:04", "45.124.84.40");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4500", "1", "digitaladmin", "2021-11-28 04:29:50", "185.190.39.66");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4501", "1", "digitaladmin", "2021-11-28 04:31:20", "103.109.30.30");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4502", "1", "digitaladmin", "2021-11-28 04:37:24", "103.110.84.33");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4503", "1", "digitaladmin", "2021-11-28 04:39:05", "131.72.221.190");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4504", "1", "digitaladmin", "2021-11-28 04:45:22", "63.143.41.18");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4505", "1", "digitaladmin", "2021-11-28 04:46:41", "174.138.33.114");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4506", "1", "digitaladmin", "2021-11-28 04:53:05", "67.211.219.84");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4507", "1", "digitaladmin", "2021-11-28 04:54:41", "107.161.177.10");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4508", "1", "digitaladmin", "2021-11-28 04:56:50", "3.17.4.158");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4509", "1", "digitaladmin", "2021-11-28 05:00:16", "115.159.148.91");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4510", "1", "digitaladmin", "2021-11-28 05:02:25", "5.101.157.216");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4511", "1", "digitaladmin", "2021-11-28 05:08:23", "5.63.10.206");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4512", "1", "digitaladmin", "2021-11-28 05:10:13", "207.55.255.20");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4513", "1", "digitaladmin", "2021-11-28 05:24:02", "190.92.152.62");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4514", "1", "digitaladmin", "2021-11-28 05:25:29", "159.65.65.170");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4515", "1", "digitaladmin", "2021-11-28 05:32:39", "195.93.152.83");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4516", "1", "digitaladmin", "2021-11-28 05:33:16", "62.210.209.245");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4517", "1", "digitaladmin", "2021-11-28 05:39:39", "142.93.34.169");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4518", "1", "digitaladmin", "2021-11-28 05:41:42", "13.59.2.153");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4519", "1", "digitaladmin", "2021-11-28 05:44:50", "3.16.151.63");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4520", "1", "digitaladmin", "2021-11-28 06:31:04", "18.188.123.226");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4521", "1", "digitaladmin", "2021-11-28 06:36:38", "3.16.81.204");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4522", "1", "digitaladmin", "2021-11-28 07:11:27", "3.84.49.179");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4523", "1", "digitaladmin", "2021-11-28 07:55:47", "18.191.18.6");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4524", "1", "digitaladmin", "2021-11-28 07:59:16", "18.117.246.165");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4525", "1", "digitaladmin", "2021-11-28 08:40:35", "18.219.107.201");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4526", "1", "digitaladmin", "2021-11-28 08:48:43", "3.144.227.185");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4527", "1", "digitaladmin", "2021-11-28 09:26:36", "3.128.18.128");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4528", "1", "digitaladmin", "2021-11-28 10:10:55", "3.12.76.126");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4529", "1", "digitaladmin", "2021-11-28 10:20:42", "18.188.35.228");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4530", "1", "digitaladmin", "2021-11-28 10:55:21", "3.21.127.150");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4531", "1", "digitaladmin", "2021-11-28 11:03:15", "18.118.147.213");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4532", "1", "digitaladmin", "2021-11-28 11:45:16", "18.222.233.125");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4533", "1", "digitaladmin", "2021-11-28 11:52:04", "18.217.44.0");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4534", "1", "digitaladmin", "2021-11-28 12:33:49", "18.118.24.31");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4535", "1", "digitaladmin", "2021-11-28 13:15:32", "18.222.200.38");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4536", "1", "digitaladmin", "2021-11-28 13:24:01", "3.141.17.4");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4537", "1", "digitaladmin", "2021-11-28 14:08:24", "18.220.134.201");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4538", "1", "digitaladmin", "2021-11-28 14:10:10", "52.91.94.226");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4539", "1", "digitaladmin", "2021-11-28 14:22:14", "18.222.49.54");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4540", "1", "digitaladmin", "2021-11-28 14:37:09", "18.117.134.156");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4541", "1", "digitaladmin", "2021-11-28 14:55:41", "3.133.96.90");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4542", "1", "digitaladmin", "2021-11-28 15:07:18", "18.223.108.65");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4543", "1", "digitaladmin", "2021-11-28 15:22:06", "18.221.23.1");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4544", "1", "digitaladmin", "2021-11-28 15:26:13", "3.144.119.190");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4545", "1", "digitaladmin", "2021-11-28 15:39:34", "13.59.163.107");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4546", "1", "digitaladmin", "2021-11-28 15:48:17", "3.135.204.229");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4547", "1", "digitaladmin", "2021-11-28 15:51:54", "3.128.26.186");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4548", "1", "digitaladmin", "2021-11-28 15:55:46", "3.23.105.182");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4549", "1", "digitaladmin", "2021-11-28 16:00:32", "109.168.97.89");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4550", "1", "digitaladmin", "2021-11-28 16:10:58", "18.222.136.21");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4551", "1", "digitaladmin", "2021-11-28 16:23:12", "3.128.181.153");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4552", "1", "digitaladmin", "2021-11-28 16:34:23", "3.135.190.4");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4553", "1", "digitaladmin", "2021-11-28 16:40:31", "200.170.156.249");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4554", "1", "digitaladmin", "2021-11-28 16:41:03", "35.171.19.242");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4555", "1", "digitaladmin", "2021-11-28 16:51:35", "18.117.243.210");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4556", "1", "digitaladmin", "2021-11-28 17:00:50", "185.2.4.71");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4557", "1", "digitaladmin", "2021-11-28 17:11:17", "3.9.154.222");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4558", "1", "digitaladmin", "2021-11-28 17:12:18", "18.117.95.176");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4559", "1", "digitaladmin", "2021-11-28 17:21:39", "3.21.245.53");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4560", "1", "digitaladmin", "2021-11-28 17:30:18", "185.243.55.192");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4561", "1", "digitaladmin", "2021-11-28 17:35:11", "3.17.37.235");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4562", "1", "digitaladmin", "2021-11-28 17:44:00", "34.201.41.188");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4563", "1", "digitaladmin", "2021-11-28 18:02:32", "3.133.142.196");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4564", "1", "digitaladmin", "2021-11-28 18:12:10", "80.249.174.66");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4565", "1", "digitaladmin", "2021-11-28 18:22:27", "3.129.59.244");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4566", "1", "digitaladmin", "2021-11-28 18:32:26", "3.143.115.217");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4567", "1", "digitaladmin", "2021-11-28 18:32:44", "155.94.163.77");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4568", "1", "digitaladmin", "2021-11-28 18:40:02", "70.36.5.102");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4569", "1", "digitaladmin", "2021-11-28 18:45:14", "18.191.141.100");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4570", "1", "digitaladmin", "2021-11-28 18:53:35", "3.128.27.134");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4571", "1", "digitaladmin", "2021-11-28 18:58:00", "207.154.226.165");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4572", "1", "digitaladmin", "2021-11-28 19:11:50", "3.135.215.202");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4573", "1", "digitaladmin", "2021-11-28 19:23:45", "162.214.187.104");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4574", "1", "digitaladmin", "2021-11-28 19:33:46", "18.219.66.25");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4575", "1", "digitaladmin", "2021-11-28 19:45:08", "18.191.64.156");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4576", "1", "digitaladmin", "2021-11-28 19:45:47", "139.59.85.224");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4577", "1", "digitaladmin", "2021-11-28 19:52:25", "161.35.52.207");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4578", "1", "digitaladmin", "2021-11-28 19:53:22", "3.144.231.249");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4579", "1", "digitaladmin", "2021-11-28 20:04:23", "3.23.96.65");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4580", "1", "digitaladmin", "2021-11-28 20:09:43", "93.115.79.62");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4581", "1", "digitaladmin", "2021-11-28 20:16:44", "18.117.222.56");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4582", "1", "digitaladmin", "2021-11-28 20:22:41", "3.144.130.5");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4583", "1", "digitaladmin", "2021-11-28 20:45:14", "3.137.170.195");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4584", "1", "digitaladmin", "2021-11-28 20:51:29", "144.76.102.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4585", "1", "digitaladmin", "2021-11-28 20:58:13", "208.109.54.127");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4586", "1", "digitaladmin", "2021-11-28 21:04:26", "18.222.123.80");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4587", "1", "digitaladmin", "2021-11-28 21:14:46", "18.224.62.53");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4588", "1", "digitaladmin", "2021-11-28 21:14:47", "163.178.170.141");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4589", "1", "digitaladmin", "2021-11-28 21:20:19", "173.212.235.115");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4590", "1", "digitaladmin", "2021-11-28 21:26:01", "18.221.252.69");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4591", "1", "digitaladmin", "2021-11-28 21:33:10", "54.38.181.202");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4592", "1", "digitaladmin", "2021-11-28 21:34:12", "18.118.185.49");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4593", "1", "digitaladmin", "2021-11-28 21:53:39", "185.2.4.56");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4594", "1", "digitaladmin", "2021-11-28 22:03:15", "3.144.3.48");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4595", "1", "digitaladmin", "2021-11-28 22:17:01", "47.105.61.35");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4596", "1", "digitaladmin", "2021-11-28 22:17:12", "139.59.25.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4597", "0", "admin", "2021-11-28 22:17:15", "139.59.25.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4598", "1", "digitaladmin", "2021-11-28 22:17:17", "139.59.25.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4599", "0", "admin", "2021-11-28 22:17:18", "139.59.25.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4600", "1", "digitaladmin", "2021-11-28 22:17:20", "139.59.25.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4601", "0", "admin", "2021-11-28 22:17:22", "139.59.25.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4602", "1", "digitaladmin", "2021-11-28 22:17:24", "139.59.25.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4603", "0", "admin", "2021-11-28 22:17:25", "139.59.25.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4604", "1", "digitaladmin", "2021-11-28 22:17:27", "139.59.25.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4605", "0", "admin", "2021-11-28 22:17:28", "139.59.25.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4606", "1", "digitaladmin", "2021-11-28 22:17:30", "139.59.25.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4607", "0", "admin", "2021-11-28 22:17:31", "139.59.25.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4608", "1", "digitaladmin", "2021-11-28 22:17:33", "139.59.25.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4609", "0", "admin", "2021-11-28 22:17:34", "139.59.25.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4610", "1", "digitaladmin", "2021-11-28 22:17:35", "139.59.25.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4611", "0", "admin", "2021-11-28 22:17:37", "139.59.25.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4612", "1", "digitaladmin", "2021-11-28 22:17:38", "139.59.25.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4613", "0", "admin", "2021-11-28 22:17:40", "139.59.25.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4614", "1", "digitaladmin", "2021-11-28 22:17:41", "139.59.25.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4615", "0", "admin", "2021-11-28 22:17:43", "139.59.25.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4616", "1", "digitaladmin", "2021-11-28 22:17:44", "139.59.25.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4617", "0", "admin", "2021-11-28 22:17:46", "139.59.25.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4618", "1", "digitaladmin", "2021-11-28 22:17:47", "139.59.25.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4619", "0", "admin", "2021-11-28 22:17:49", "139.59.25.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4620", "1", "digitaladmin", "2021-11-28 22:17:50", "139.59.25.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4621", "0", "admin", "2021-11-28 22:17:51", "139.59.25.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4622", "1", "digitaladmin", "2021-11-28 22:17:53", "139.59.25.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4623", "0", "admin", "2021-11-28 22:17:54", "139.59.25.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4624", "1", "digitaladmin", "2021-11-28 22:17:56", "139.59.25.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4625", "0", "admin", "2021-11-28 22:17:57", "139.59.25.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4626", "1", "digitaladmin", "2021-11-28 22:17:59", "139.59.25.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4627", "0", "admin", "2021-11-28 22:18:00", "139.59.25.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4628", "1", "digitaladmin", "2021-11-28 22:18:02", "139.59.25.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4629", "0", "admin", "2021-11-28 22:18:03", "139.59.25.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4630", "1", "digitaladmin", "2021-11-28 22:18:05", "139.59.25.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4631", "0", "admin", "2021-11-28 22:18:06", "139.59.25.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4632", "1", "digitaladmin", "2021-11-28 22:18:08", "139.59.25.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4633", "0", "admin", "2021-11-28 22:18:09", "139.59.25.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4634", "1", "digitaladmin", "2021-11-28 22:18:11", "139.59.25.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4635", "0", "admin", "2021-11-28 22:18:12", "139.59.25.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4636", "1", "digitaladmin", "2021-11-28 22:18:13", "3.145.26.199");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4637", "1", "digitaladmin", "2021-11-28 22:18:14", "139.59.25.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4638", "0", "admin", "2021-11-28 22:18:15", "139.59.25.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4639", "1", "digitaladmin", "2021-11-28 22:25:54", "3.140.216.35");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4640", "1", "digitaladmin", "2021-11-28 22:38:43", "3.144.103.93");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4641", "1", "digitaladmin", "2021-11-28 22:41:32", "23.97.205.210");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4642", "1", "digitaladmin", "2021-11-28 22:45:55", "3.15.225.111");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4643", "1", "digitaladmin", "2021-11-28 22:47:51", "40.113.8.202");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4644", "1", "digitaladmin", "2021-11-28 23:02:31", "52.166.3.59");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4645", "1", "digitaladmin", "2021-11-28 23:08:44", "18.118.194.140");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4646", "1", "digitaladmin", "2021-11-28 23:30:23", "18.222.107.221");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4647", "1", "digitaladmin", "2021-11-28 23:30:39", "42.193.21.177");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4648", "1", "digitaladmin", "2021-11-28 23:40:24", "18.216.213.209");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4649", "1", "digitaladmin", "2021-11-28 23:44:36", "34.92.58.160");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4650", "1", "digitaladmin", "2021-11-28 23:50:16", "109.87.200.193");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4651", "1", "digitaladmin", "2021-11-28 23:55:44", "18.221.213.175");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4652", "1", "digitaladmin", "2021-11-29 00:01:53", "3.142.242.41");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4653", "1", "digitaladmin", "2021-11-29 00:20:10", "3.137.171.15");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4654", "1", "digitaladmin", "2021-11-29 00:25:27", "3.138.85.187");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4655", "1", "digitaladmin", "2021-11-29 00:48:30", "3.144.208.193");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4656", "1", "digitaladmin", "2021-11-29 00:49:00", "178.128.215.197");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4657", "1", "digitaladmin", "2021-11-29 00:54:58", "143.198.162.183");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4658", "1", "digitaladmin", "2021-11-29 01:10:12", "3.143.168.69");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4659", "1", "digitaladmin", "2021-11-29 01:11:36", "139.59.85.224");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4660", "1", "digitaladmin", "2021-11-29 01:18:36", "153.127.62.34");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4661", "1", "digitaladmin", "2021-11-29 01:18:40", "13.58.59.2");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4662", "1", "digitaladmin", "2021-11-29 01:33:01", "81.88.52.175");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4663", "1", "digitaladmin", "2021-11-29 01:35:10", "3.16.68.144");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4664", "1", "digitaladmin", "2021-11-29 01:44:20", "18.218.201.137");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4665", "1", "digitaladmin", "2021-11-29 01:53:11", "192.185.130.172");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4666", "1", "digitaladmin", "2021-11-29 01:57:58", "13.94.249.188");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4667", "1", "digitaladmin", "2021-11-29 02:04:40", "3.15.193.0");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4668", "1", "digitaladmin", "2021-11-29 02:12:50", "164.68.101.188");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4669", "1", "digitaladmin", "2021-11-29 02:18:28", "34.69.109.132");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4670", "1", "digitaladmin", "2021-11-29 02:28:28", "3.144.216.162");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4671", "1", "digitaladmin", "2021-11-29 02:31:55", "69.163.224.112");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4672", "1", "digitaladmin", "2021-11-29 02:35:16", "52.14.3.104");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4673", "1", "digitaladmin", "2021-11-29 02:51:31", "13.59.176.110");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4674", "1", "digitaladmin", "2021-11-29 02:54:29", "164.68.99.94");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4675", "1", "digitaladmin", "2021-11-29 02:59:13", "18.219.208.219");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4676", "1", "digitaladmin", "2021-11-29 03:15:26", "18.219.63.57");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4677", "1", "digitaladmin", "2021-11-29 03:17:37", "95.111.254.6");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4678", "1", "digitaladmin", "2021-11-29 03:22:48", "18.219.39.231");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4679", "1", "digitaladmin", "2021-11-29 03:40:40", "104.236.126.239");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4680", "1", "digitaladmin", "2021-11-29 03:45:17", "3.145.71.41");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4681", "1", "digitaladmin", "2021-11-29 04:04:12", "144.91.68.146");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4682", "1", "digitaladmin", "2021-11-29 04:08:15", "3.145.23.58");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4683", "1", "digitaladmin", "2021-11-29 04:14:53", "3.142.211.47");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4684", "1", "digitaladmin", "2021-11-29 04:28:59", "167.172.153.166");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4685", "1", "digitaladmin", "2021-11-29 04:31:37", "3.16.47.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4686", "1", "digitaladmin", "2021-11-29 04:34:39", "148.66.129.233");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4687", "1", "digitaladmin", "2021-11-29 04:38:47", "18.223.116.174");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4688", "1", "digitaladmin", "2021-11-29 04:49:47", "134.209.196.64");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4689", "1", "digitaladmin", "2021-11-29 04:54:08", "157.245.217.209");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4690", "1", "digitaladmin", "2021-11-29 05:04:05", "13.59.182.184");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4691", "1", "digitaladmin", "2021-11-29 05:08:42", "167.172.153.166");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4692", "1", "digitaladmin", "2021-11-29 05:26:20", "67.205.12.218");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4693", "1", "digitaladmin", "2021-11-29 05:27:55", "18.118.185.49");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4694", "1", "digitaladmin", "2021-11-29 05:32:49", "3.142.84.98");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4695", "1", "digitaladmin", "2021-11-29 05:47:39", "162.240.27.242");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4696", "1", "digitaladmin", "2021-11-29 05:48:42", "3.138.173.56");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4697", "1", "digitaladmin", "2021-11-29 05:56:20", "13.58.49.150");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4698", "1", "digitaladmin", "2021-11-29 06:02:00", "194.163.133.151");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4699", "1", "digitaladmin", "2021-11-29 06:09:35", "88.150.159.29");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4700", "1", "digitaladmin", "2021-11-29 06:15:12", "18.222.253.165");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4701", "1", "digitaladmin", "2021-11-29 06:18:50", "18.222.90.40");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4702", "1", "digitaladmin", "2021-11-29 06:43:09", "178.128.215.197");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4703", "1", "digitaladmin", "2021-11-29 06:43:57", "18.119.138.91");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4704", "1", "digitaladmin", "2021-11-29 06:49:05", "88.150.159.29");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4705", "1", "digitaladmin", "2021-11-29 07:04:36", "156.38.216.210");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4706", "1", "digitaladmin", "2021-11-29 07:06:54", "3.17.13.222");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4707", "1", "digitaladmin", "2021-11-29 07:12:12", "159.65.216.18");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4708", "1", "digitaladmin", "2021-11-29 07:15:09", "52.15.124.251");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4709", "1", "digitaladmin", "2021-11-29 07:26:40", "208.113.160.8");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4710", "1", "digitaladmin", "2021-11-29 07:33:03", "18.220.243.107");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4711", "1", "digitaladmin", "2021-11-29 07:38:38", "3.144.119.190");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4712", "1", "digitaladmin", "2021-11-29 07:45:01", "95.217.144.72");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4713", "1", "digitaladmin", "2021-11-29 08:05:12", "52.15.172.229");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4714", "1", "digitaladmin", "2021-11-29 08:08:40", "88.150.159.29");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4715", "1", "digitaladmin", "2021-11-29 08:30:33", "3.145.50.80");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4716", "1", "digitaladmin", "2021-11-29 08:31:51", "88.150.159.29");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4717", "1", "digitaladmin", "2021-11-29 08:36:21", "3.128.179.48");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4718", "1", "digitaladmin", "2021-11-29 08:38:15", "173.236.152.139");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4719", "1", "digitaladmin", "2021-11-29 08:53:08", "107.180.73.192");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4720", "1", "digitaladmin", "2021-11-29 08:53:38", "18.221.174.180");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4721", "1", "digitaladmin", "2021-11-29 08:58:50", "3.15.177.19");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4722", "1", "digitaladmin", "2021-11-29 09:17:31", "181.174.125.214");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4723", "1", "digitaladmin", "2021-11-29 09:21:09", "3.141.17.4");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4724", "1", "digitaladmin", "2021-11-29 09:23:30", "195.242.103.103");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4725", "1", "digitaladmin", "2021-11-29 09:26:40", "18.222.166.98");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4726", "1", "digitaladmin", "2021-11-29 09:44:26", "144.76.102.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4727", "1", "digitaladmin", "2021-11-29 09:51:05", "52.15.222.115");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4728", "1", "digitaladmin", "2021-11-29 09:59:09", "42.193.21.177");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4729", "1", "digitaladmin", "2021-11-29 10:07:50", "51.195.42.19");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4730", "1", "digitaladmin", "2021-11-29 10:16:06", "52.14.158.198");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4731", "1", "digitaladmin", "2021-11-29 10:21:29", "3.129.206.214");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4732", "1", "digitaladmin", "2021-11-29 10:24:08", "155.94.163.77");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4733", "1", "digitaladmin", "2021-11-29 10:41:46", "13.58.159.198");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4734", "1", "digitaladmin", "2021-11-29 10:45:52", "46.101.150.34");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4735", "1", "digitaladmin", "2021-11-29 10:48:43", "3.15.179.6");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4736", "1", "digitaladmin", "2021-11-29 10:51:40", "14.36.66.221");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4737", "1", "digitaladmin", "2021-11-29 11:07:03", "177.55.111.14");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4738", "1", "digitaladmin", "2021-11-29 11:13:50", "18.117.140.139");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4739", "1", "digitaladmin", "2021-11-29 11:44:31", "3.143.228.113");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4740", "1", "digitaladmin", "2021-11-29 11:46:35", "3.140.216.35");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4741", "1", "digitaladmin", "2021-11-29 12:04:51", "3.138.247.40");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4742", "1", "digitaladmin", "2021-11-29 12:08:39", "95.217.144.72");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4743", "1", "digitaladmin", "2021-11-29 12:11:43", "18.118.105.8");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4744", "1", "digitaladmin", "2021-11-29 12:14:15", "52.166.3.59");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4745", "1", "digitaladmin", "2021-11-29 12:28:10", "159.65.76.38");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4746", "1", "digitaladmin", "2021-11-29 12:35:14", "3.133.93.106");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4747", "1", "digitaladmin", "2021-11-29 12:46:17", "104.248.144.242");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4748", "1", "digitaladmin", "2021-11-29 13:01:02", "18.191.230.48");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4749", "1", "digitaladmin", "2021-11-29 13:04:12", "192.71.144.12");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4750", "1", "digitaladmin", "2021-11-29 13:08:52", "13.59.88.125");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4751", "1", "digitaladmin", "2021-11-29 13:28:36", "13.58.113.132");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4752", "1", "digitaladmin", "2021-11-29 13:33:51", "18.221.100.72");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4753", "0", "admin", "2021-11-29 13:47:53", "35.241.177.128");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4754", "1", "digitaladmin", "2021-11-29 13:55:17", "3.12.198.44");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4755", "1", "digitaladmin", "2021-11-29 13:59:24", "3.138.37.19");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4756", "1", "digitaladmin", "2021-11-29 14:27:12", "3.140.190.183");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4757", "1", "digitaladmin", "2021-11-29 14:53:30", "18.216.46.210");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4758", "1", "digitaladmin", "2021-11-29 15:00:59", "3.14.254.160");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4759", "1", "digitaladmin", "2021-11-29 15:22:57", "3.16.166.87");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4760", "1", "digitaladmin", "2021-11-29 15:30:01", "3.142.99.96");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4761", "1", "digitaladmin", "2021-11-29 16:04:39", "3.128.189.127");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4762", "1", "digitaladmin", "2021-11-29 16:25:00", "3.19.27.166");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4763", "1", "digitaladmin", "2021-11-29 16:39:56", "3.16.147.41");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4764", "1", "digitaladmin", "2021-11-29 16:51:12", "18.218.32.170");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4765", "1", "digitaladmin", "2021-11-29 17:03:28", "3.144.214.63");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4766", "1", "digitaladmin", "2021-11-29 17:24:25", "18.191.224.118");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4767", "1", "digitaladmin", "2021-11-29 17:25:01", "18.116.82.27");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4768", "1", "digitaladmin", "2021-11-29 17:56:48", "18.117.172.209");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4769", "1", "digitaladmin", "2021-11-29 18:27:14", "18.188.4.69");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4770", "1", "digitaladmin", "2021-11-29 18:28:54", "18.220.77.132");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4771", "1", "digitaladmin", "2021-11-29 18:56:44", "3.16.151.180");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4772", "1", "digitaladmin", "2021-11-29 19:01:30", "3.16.23.95");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4773", "1", "digitaladmin", "2021-11-29 19:29:43", "18.216.154.149");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4774", "1", "digitaladmin", "2021-11-29 19:59:42", "18.224.14.2");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4775", "1", "digitaladmin", "2021-11-29 20:05:19", "3.16.45.57");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4776", "1", "digitaladmin", "2021-11-29 20:27:54", "18.216.96.47");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4777", "1", "digitaladmin", "2021-11-29 20:31:46", "18.222.163.3");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4778", "1", "digitaladmin", "2021-11-29 21:00:16", "3.14.130.116");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4779", "1", "digitaladmin", "2021-11-29 21:03:36", "3.145.39.225");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4780", "1", "digitaladmin", "2021-11-29 21:34:21", "18.224.180.129");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4781", "1", "digitaladmin", "2021-11-29 22:03:36", "13.58.113.132");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4782", "1", "digitaladmin", "2021-11-29 22:05:54", "3.145.26.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4783", "1", "digitaladmin", "2021-11-29 22:35:24", "3.139.107.251");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4784", "1", "digitaladmin", "2021-11-29 22:36:49", "18.191.17.181");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4785", "1", "digitaladmin", "2021-11-29 23:09:18", "3.138.196.131");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4786", "1", "digitaladmin", "2021-11-29 23:40:52", "3.131.153.62");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4787", "1", "digitaladmin", "2021-11-29 23:43:43", "3.139.109.39");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4788", "1", "digitaladmin", "2021-11-30 00:13:33", "3.139.94.6");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4789", "1", "digitaladmin", "2021-11-30 00:15:54", "3.144.248.25");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4790", "1", "digitaladmin", "2021-11-30 00:43:43", "18.191.17.181");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4791", "1", "digitaladmin", "2021-11-30 00:46:25", "3.145.18.154");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4792", "1", "digitaladmin", "2021-11-30 01:16:15", "3.23.129.191");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4793", "1", "digitaladmin", "2021-11-30 01:46:14", "3.91.214.170");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4794", "1", "digitaladmin", "2021-11-30 01:49:55", "18.217.129.83");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4795", "1", "digitaladmin", "2021-11-30 02:16:37", "3.129.6.235");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4796", "1", "digitaladmin", "2021-11-30 02:19:52", "18.118.171.27");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4797", "1", "digitaladmin", "2021-11-30 02:51:23", "18.191.201.249");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4798", "1", "digitaladmin", "2021-11-30 03:24:10", "3.14.6.142");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4799", "1", "digitaladmin", "2021-11-30 03:25:47", "18.189.180.160");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4800", "1", "digitaladmin", "2021-11-30 03:52:38", "18.218.134.152");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4801", "1", "digitaladmin", "2021-11-30 03:56:07", "3.138.111.123");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4802", "1", "digitaladmin", "2021-11-30 04:26:02", "18.118.25.98");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4803", "1", "digitaladmin", "2021-11-30 04:56:41", "52.15.223.116");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4804", "1", "digitaladmin", "2021-11-30 05:03:58", "3.142.232.240");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4805", "1", "digitaladmin", "2021-11-30 05:27:50", "18.218.228.126");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4806", "1", "digitaladmin", "2021-11-30 05:29:49", "3.144.77.203");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4807", "1", "digitaladmin", "2021-11-30 06:00:20", "3.133.158.25");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4808", "1", "digitaladmin", "2021-11-30 06:02:04", "18.222.130.160");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4809", "1", "digitaladmin", "2021-11-30 06:33:37", "18.218.38.153");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4810", "1", "digitaladmin", "2021-11-30 07:04:21", "3.144.170.151");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4811", "1", "digitaladmin", "2021-11-30 07:09:21", "3.133.158.25");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4812", "1", "digitaladmin", "2021-11-30 07:38:37", "3.144.111.222");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4813", "1", "digitaladmin", "2021-11-30 07:39:45", "3.21.122.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4814", "1", "digitaladmin", "2021-11-30 08:14:59", "3.142.230.76");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4815", "1", "digitaladmin", "2021-11-30 09:01:06", "18.188.228.179");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4816", "1", "digitaladmin", "2021-11-30 09:48:32", "18.188.109.204");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4817", "1", "digitaladmin", "2021-11-30 09:58:17", "18.116.86.10");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4818", "1", "digitaladmin", "2021-11-30 10:49:23", "3.142.211.143");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4819", "1", "digitaladmin", "2021-11-30 11:05:22", "18.117.227.211");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4820", "1", "digitaladmin", "2021-11-30 12:03:13", "3.82.195.166");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4821", "1", "digitaladmin", "2021-11-30 12:55:09", "13.59.141.198");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4822", "1", "digitaladmin", "2021-11-30 13:13:25", "3.145.26.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4823", "1", "digitaladmin", "2021-11-30 14:18:48", "18.217.149.114");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4824", "1", "digitaladmin", "2021-11-30 14:50:01", "18.188.101.251");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4825", "1", "digitaladmin", "2021-11-30 16:25:13", "18.117.127.89");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4826", "1", "digitaladmin", "2021-11-30 17:58:59", "3.142.82.23");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4827", "1", "digitaladmin", "2021-11-30 18:55:41", "18.191.219.180");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4828", "0", "admin", "2021-11-30 20:47:32", "164.68.101.188");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4829", "0", "admin", "2021-11-30 20:53:37", "95.128.43.176");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4830", "0", "admin", "2021-11-30 21:13:32", "173.212.246.160");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4831", "0", "admin", "2021-11-30 21:18:03", "118.27.30.151");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4832", "0", "admin", "2021-11-30 21:34:47", "103.149.154.8");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4833", "1", "digitaladmin", "2021-11-30 21:40:29", "18.222.214.201");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4834", "0", "admin", "2021-11-30 22:24:52", "104.236.126.239");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4835", "0", "admin", "2021-11-30 22:30:24", "95.217.144.72");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4836", "1", "digitaladmin", "2021-11-30 22:46:00", "82.223.55.111");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4837", "1", "digitaladmin", "2021-11-30 23:08:23", "159.203.115.159");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4838", "1", "digitaladmin", "2021-11-30 23:28:51", "78.47.116.216");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4839", "1", "digitaladmin", "2021-11-30 23:31:37", "18.222.153.141");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4840", "1", "digitaladmin", "2021-11-30 23:35:31", "31.192.208.12");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4841", "1", "digitaladmin", "2021-11-30 23:49:21", "162.144.126.104");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4842", "1", "digitaladmin", "2021-12-01 00:06:00", "45.40.166.143");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4843", "1", "digitaladmin", "2021-12-01 00:19:12", "109.74.197.132");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4844", "1", "digitaladmin", "2021-12-01 00:22:59", "206.189.50.175");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4845", "0", "admin", "2021-12-01 00:32:28", "167.99.138.106");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4846", "0", "admin", "2021-12-01 00:36:12", "167.86.84.227");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4847", "0", "admin", "2021-12-01 00:45:37", "40.113.8.202");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4848", "0", "admin", "2021-12-01 00:49:23", "103.28.37.180");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4849", "1", "digitaladmin", "2021-12-01 00:51:34", "18.188.63.216");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4850", "0", "admin", "2021-12-01 00:58:51", "167.172.153.166");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4851", "0", "admin", "2021-12-01 01:12:20", "95.217.195.206");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4852", "0", "admin", "2021-12-01 01:16:06", "94.153.161.234");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4853", "0", "admin", "2021-12-01 01:25:39", "94.23.83.103");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4854", "0", "admin", "2021-12-01 01:29:29", "89.96.90.125");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4855", "0", "admin", "2021-12-01 01:39:08", "46.160.121.111");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4856", "0", "admin", "2021-12-01 01:52:21", "185.137.233.223");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4857", "0", "admin", "2021-12-01 02:05:46", "103.109.28.1");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4858", "0", "admin", "2021-12-01 02:09:33", "155.94.163.77");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4859", "0", "admin", "2021-12-01 02:19:06", "144.76.102.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4860", "1", "digitaladmin", "2021-12-01 02:32:24", "65.108.51.66");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4861", "1", "digitaladmin", "2021-12-01 02:49:27", "188.166.1.143");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4862", "1", "digitaladmin", "2021-12-01 02:50:46", "18.188.11.134");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4863", "1", "digitaladmin", "2021-12-01 03:02:52", "159.65.76.38");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4864", "1", "digitaladmin", "2021-12-01 03:12:33", "95.128.43.176");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4865", "1", "digitaladmin", "2021-12-01 03:16:22", "103.15.232.195");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4866", "1", "digitaladmin", "2021-12-01 03:26:03", "121.243.95.160");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4867", "1", "digitaladmin", "2021-12-01 03:29:50", "167.172.190.95");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4868", "1", "digitaladmin", "2021-12-01 03:39:26", "109.87.200.193");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4869", "1", "digitaladmin", "2021-12-01 03:43:15", "173.212.246.160");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4870", "1", "digitaladmin", "2021-12-01 04:06:29", "103.148.155.16");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4871", "1", "digitaladmin", "2021-12-01 04:19:54", "93.104.211.150");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4872", "1", "digitaladmin", "2021-12-01 04:23:45", "103.121.89.72");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4873", "1", "digitaladmin", "2021-12-01 04:33:18", "138.68.248.47");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4874", "1", "digitaladmin", "2021-12-01 04:46:34", "119.8.119.224");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4875", "1", "digitaladmin", "2021-12-01 04:59:41", "177.55.111.11");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4876", "1", "digitaladmin", "2021-12-01 05:03:30", "195.201.7.148");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4877", "1", "digitaladmin", "2021-12-01 05:13:04", "107.173.84.179");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4878", "1", "digitaladmin", "2021-12-01 05:16:46", "187.51.127.28");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4879", "1", "digitaladmin", "2021-12-01 05:26:07", "188.166.94.198");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4880", "1", "digitaladmin", "2021-12-01 05:38:53", "144.76.102.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4881", "1", "digitaladmin", "2021-12-01 05:51:44", "138.197.12.140");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4882", "1", "digitaladmin", "2021-12-01 05:55:23", "139.59.118.238");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4883", "1", "digitaladmin", "2021-12-01 06:04:53", "163.178.170.141");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4884", "1", "digitaladmin", "2021-12-01 06:08:40", "93.113.111.54");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4885", "1", "digitaladmin", "2021-12-01 06:35:02", "95.217.3.203");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4886", "1", "digitaladmin", "2021-12-01 06:57:41", "162.214.190.209");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4887", "1", "digitaladmin", "2021-12-01 07:11:07", "47.241.15.39");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4888", "1", "digitaladmin", "2021-12-01 07:24:25", "89.96.90.125");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4889", "1", "digitaladmin", "2021-12-01 07:37:35", "217.9.143.94");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4890", "1", "digitaladmin", "2021-12-01 07:41:20", "34.75.201.58");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4891", "1", "digitaladmin", "2021-12-01 08:03:51", "188.166.94.198");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4892", "1", "digitaladmin", "2021-12-01 08:07:37", "148.251.128.71");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4893", "1", "digitaladmin", "2021-12-01 08:17:02", "34.77.178.214");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4894", "1", "digitaladmin", "2021-12-01 08:20:45", "152.228.140.7");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4895", "1", "digitaladmin", "2021-12-01 08:30:15", "173.236.145.137");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4896", "1", "digitaladmin", "2021-12-01 08:56:48", "144.91.68.146");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4897", "1", "digitaladmin", "2021-12-01 09:00:42", "157.245.150.104");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4898", "1", "digitaladmin", "2021-12-01 09:10:22", "185.238.75.78");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4899", "1", "digitaladmin", "2021-12-01 09:14:10", "34.92.58.160");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4900", "1", "digitaladmin", "2021-12-01 09:23:46", "77.77.212.90");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4901", "1", "digitaladmin", "2021-12-01 09:37:15", "20.37.127.214");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4902", "1", "digitaladmin", "2021-12-01 09:40:58", "81.88.52.26");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4903", "1", "digitaladmin", "2021-12-01 09:50:31", "34.69.109.132");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4904", "1", "digitaladmin", "2021-12-01 09:54:18", "74.208.34.142");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4905", "1", "digitaladmin", "2021-12-01 10:03:59", "188.212.34.69");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4906", "1", "digitaladmin", "2021-12-01 10:17:34", "78.47.116.216");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4907", "1", "digitaladmin", "2021-12-01 10:31:07", "51.15.160.22");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4908", "1", "digitaladmin", "2021-12-01 10:34:50", "109.168.97.89");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4909", "1", "digitaladmin", "2021-12-01 10:48:36", "171.250.9.134");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4910", "1", "digitaladmin", "2021-12-01 10:58:11", "178.128.5.109");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4911", "1", "digitaladmin", "2021-12-01 11:12:10", "195.201.7.148");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4912", "1", "digitaladmin", "2021-12-01 11:30:07", "46.160.121.111");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4913", "1", "digitaladmin", "2021-12-01 11:35:13", "82.202.172.247");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4914", "1", "digitaladmin", "2021-12-01 11:49:17", "46.160.121.111");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4915", "1", "digitaladmin", "2021-12-01 12:25:49", "192.185.130.172");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4916", "1", "digitaladmin", "2021-12-01 12:29:46", "207.244.233.113");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4917", "1", "digitaladmin", "2021-12-01 12:39:44", "155.94.163.77");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4918", "1", "digitaladmin", "2021-12-01 12:53:52", "192.185.130.172");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4919", "1", "digitaladmin", "2021-12-01 13:08:20", "165.22.193.8");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4920", "1", "digitaladmin", "2021-12-01 13:12:14", "64.207.179.129");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4921", "1", "digitaladmin", "2021-12-01 13:22:04", "148.66.129.233");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4922", "1", "digitaladmin", "2021-12-01 13:26:01", "161.35.94.99");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4923", "1", "digitaladmin", "2021-12-01 13:49:52", "159.65.76.38");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4924", "1", "digitaladmin", "2021-12-01 14:03:51", "69.163.163.120");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4925", "1", "digitaladmin", "2021-12-02 23:58:16", "113.31.119.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4926", "0", "admin", "2021-12-02 23:58:18", "113.31.119.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4927", "1", "digitaladmin", "2021-12-02 23:58:20", "113.31.119.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4928", "0", "admin", "2021-12-02 23:58:22", "113.31.119.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4929", "1", "digitaladmin", "2021-12-02 23:58:23", "113.31.119.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4930", "0", "admin", "2021-12-02 23:58:25", "113.31.119.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4931", "1", "digitaladmin", "2021-12-02 23:58:27", "113.31.119.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4932", "0", "admin", "2021-12-02 23:58:29", "113.31.119.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4933", "1", "digitaladmin", "2021-12-02 23:58:31", "113.31.119.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4934", "0", "admin", "2021-12-02 23:58:32", "113.31.119.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4935", "1", "digitaladmin", "2021-12-02 23:58:34", "113.31.119.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4936", "0", "admin", "2021-12-02 23:58:36", "113.31.119.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4937", "1", "digitaladmin", "2021-12-02 23:58:38", "113.31.119.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4938", "0", "admin", "2021-12-02 23:58:40", "113.31.119.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4939", "1", "digitaladmin", "2021-12-02 23:58:42", "113.31.119.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4940", "0", "admin", "2021-12-02 23:58:43", "113.31.119.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4941", "1", "digitaladmin", "2021-12-02 23:58:45", "113.31.119.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4942", "0", "admin", "2021-12-02 23:58:47", "113.31.119.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4943", "1", "digitaladmin", "2021-12-02 23:58:49", "113.31.119.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4944", "0", "admin", "2021-12-02 23:58:51", "113.31.119.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4945", "1", "digitaladmin", "2021-12-02 23:58:53", "113.31.119.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4946", "0", "admin", "2021-12-02 23:58:54", "113.31.119.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4947", "1", "digitaladmin", "2021-12-02 23:58:56", "113.31.119.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4948", "0", "admin", "2021-12-02 23:58:58", "113.31.119.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4949", "1", "digitaladmin", "2021-12-02 23:59:00", "113.31.119.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4950", "0", "admin", "2021-12-02 23:59:02", "113.31.119.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4951", "1", "digitaladmin", "2021-12-02 23:59:04", "113.31.119.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4952", "0", "admin", "2021-12-02 23:59:05", "113.31.119.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4953", "1", "digitaladmin", "2021-12-02 23:59:07", "113.31.119.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4954", "0", "admin", "2021-12-02 23:59:09", "113.31.119.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4955", "1", "digitaladmin", "2021-12-02 23:59:11", "113.31.119.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4956", "0", "admin", "2021-12-02 23:59:13", "113.31.119.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4957", "1", "digitaladmin", "2021-12-02 23:59:14", "113.31.119.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4958", "0", "admin", "2021-12-02 23:59:16", "113.31.119.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4959", "1", "digitaladmin", "2021-12-02 23:59:18", "113.31.119.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4960", "0", "admin", "2021-12-02 23:59:20", "113.31.119.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4961", "1", "digitaladmin", "2021-12-02 23:59:22", "113.31.119.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4962", "0", "admin", "2021-12-02 23:59:24", "113.31.119.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4963", "1", "digitaladmin", "2021-12-02 23:59:25", "113.31.119.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4964", "0", "admin", "2021-12-02 23:59:27", "113.31.119.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4965", "1", "digitaladmin", "2021-12-02 23:59:29", "113.31.119.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4966", "0", "admin", "2021-12-02 23:59:31", "113.31.119.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4967", "1", "digitaladmin", "2021-12-03 07:06:09", "186.234.80.67");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4968", "1", "digitaladmin", "2021-12-03 07:58:54", "186.33.234.25");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4969", "1", "digitaladmin", "2021-12-03 08:48:17", "104.199.146.31");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4970", "1", "digitaladmin", "2021-12-03 09:40:26", "81.70.151.13");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4971", "1", "digitaladmin", "2021-12-03 10:33:39", "200.58.109.114");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4972", "1", "digitaladmin", "2021-12-03 11:30:12", "47.114.3.188");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4973", "1", "digitaladmin", "2021-12-03 12:29:27", "175.208.204.100");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4974", "1", "digitaladmin", "2021-12-03 14:31:20", "164.68.110.108");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4975", "1", "digitaladmin", "2021-12-03 15:35:04", "66.94.97.122");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4976", "1", "digitaladmin", "2021-12-04 02:43:17", "3.145.114.25");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4977", "1", "digitaladmin", "2021-12-04 02:54:10", "3.135.222.195");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4978", "1", "digitaladmin", "2021-12-04 03:08:47", "18.218.182.121");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4979", "1", "digitaladmin", "2021-12-04 03:15:14", "18.219.111.130");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4980", "1", "digitaladmin", "2021-12-04 03:36:17", "18.219.111.130");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4981", "1", "digitaladmin", "2021-12-04 03:52:19", "3.17.148.225");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4982", "1", "digitaladmin", "2021-12-04 03:55:23", "3.143.252.82");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4983", "1", "digitaladmin", "2021-12-04 03:59:51", "18.188.110.77");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4984", "1", "digitaladmin", "2021-12-04 04:02:48", "18.216.136.118");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4985", "1", "digitaladmin", "2021-12-04 04:13:34", "3.129.17.169");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4986", "1", "digitaladmin", "2021-12-04 04:16:03", "18.219.36.177");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4987", "1", "digitaladmin", "2021-12-04 04:36:25", "35.175.141.112");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4988", "1", "digitaladmin", "2021-12-04 04:37:04", "18.220.225.40");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4989", "1", "digitaladmin", "2021-12-04 04:41:20", "3.144.9.224");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4990", "1", "digitaladmin", "2021-12-04 04:48:51", "3.89.120.193");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4991", "1", "digitaladmin", "2021-12-04 04:52:03", "18.119.108.216");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4992", "1", "digitaladmin", "2021-12-04 05:09:38", "3.17.175.163");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4993", "1", "digitaladmin", "2021-12-04 05:34:16", "18.118.255.35");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4994", "1", "digitaladmin", "2021-12-04 05:43:50", "34.205.69.14");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4995", "1", "digitaladmin", "2021-12-04 05:50:23", "3.144.72.156");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4996", "0", "admin", "2021-12-04 05:57:08", "188.212.34.69");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4997", "1", "digitaladmin", "2021-12-04 06:05:12", "18.219.13.130");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4998", "1", "digitaladmin", "2021-12-04 06:18:40", "18.222.232.134");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("4999", "0", "admin", "2021-12-04 06:32:15", "156.38.216.210");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5000", "1", "digitaladmin", "2021-12-04 06:40:05", "3.133.150.198");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5001", "1", "digitaladmin", "2021-12-04 06:44:39", "3.144.156.203");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5002", "1", "digitaladmin", "2021-12-04 07:00:39", "3.135.214.192");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5003", "0", "admin", "2021-12-04 07:07:14", "109.87.200.193");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5004", "1", "digitaladmin", "2021-12-04 07:08:13", "3.83.242.80");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5005", "1", "digitaladmin", "2021-12-04 07:19:30", "3.21.102.229");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5006", "1", "digitaladmin", "2021-12-04 07:25:16", "3.143.252.82");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5007", "0", "admin", "2021-12-04 07:41:47", "156.38.216.210");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5008", "1", "digitaladmin", "2021-12-04 07:46:04", "3.16.155.13");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5009", "1", "digitaladmin", "2021-12-04 08:04:25", "3.128.91.153");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5010", "1", "digitaladmin", "2021-12-04 08:13:53", "3.17.173.227");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5011", "0", "admin", "2021-12-04 08:15:45", "78.47.116.216");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5012", "1", "digitaladmin", "2021-12-04 08:21:37", "3.144.146.214");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5013", "1", "digitaladmin", "2021-12-04 08:34:47", "18.217.97.115");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5014", "0", "admin", "2021-12-04 08:50:10", "40.69.160.139");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5015", "1", "digitaladmin", "2021-12-04 08:55:23", "54.204.131.240");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5016", "1", "digitaladmin", "2021-12-04 09:15:42", "18.222.182.140");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5017", "1", "digitaladmin", "2021-12-04 09:24:22", "3.15.157.82");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5018", "1", "digitaladmin", "2021-12-04 09:24:58", "208.109.54.127");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5019", "1", "digitaladmin", "2021-12-04 09:37:59", "3.144.156.162");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5020", "1", "digitaladmin", "2021-12-04 09:46:38", "3.144.91.51");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5021", "1", "digitaladmin", "2021-12-04 10:01:14", "18.220.14.15");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5022", "1", "digitaladmin", "2021-12-04 10:08:22", "3.145.129.194");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5023", "1", "digitaladmin", "2021-12-04 10:33:31", "54.159.89.0");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5024", "1", "digitaladmin", "2021-12-04 10:35:47", "94.153.161.234");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5025", "1", "digitaladmin", "2021-12-04 10:56:00", "18.118.12.84");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5026", "1", "digitaladmin", "2021-12-04 11:06:25", "52.38.176.21");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5027", "1", "digitaladmin", "2021-12-04 11:11:44", "173.212.235.115");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5028", "1", "digitaladmin", "2021-12-04 11:20:11", "13.58.152.76");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5029", "1", "digitaladmin", "2021-12-04 11:26:03", "3.14.153.76");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5030", "1", "digitaladmin", "2021-12-04 11:47:42", "46.63.80.162");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5031", "1", "digitaladmin", "2021-12-04 11:50:02", "3.22.51.14");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5032", "1", "digitaladmin", "2021-12-04 12:13:28", "18.118.152.22");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5033", "1", "digitaladmin", "2021-12-04 12:20:09", "3.142.237.71");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5034", "1", "digitaladmin", "2021-12-04 12:23:48", "34.69.109.132");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5035", "1", "digitaladmin", "2021-12-04 12:36:58", "18.221.6.206");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5036", "1", "digitaladmin", "2021-12-04 12:44:35", "18.207.225.74");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5037", "0", "admin", "2021-12-04 12:59:39", "95.216.221.91");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5038", "1", "digitaladmin", "2021-12-04 13:00:07", "18.219.103.247");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5039", "1", "digitaladmin", "2021-12-04 13:08:21", "3.16.76.159");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5040", "1", "digitaladmin", "2021-12-04 13:25:14", "3.145.120.143");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5041", "1", "digitaladmin", "2021-12-04 13:31:14", "3.23.96.223");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5042", "1", "digitaladmin", "2021-12-04 13:47:51", "3.138.103.119");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5043", "1", "digitaladmin", "2021-12-04 13:49:17", "18.224.59.207");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5044", "1", "digitaladmin", "2021-12-04 14:01:04", "13.59.64.65");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5045", "1", "digitaladmin", "2021-12-04 14:07:55", "18.117.246.97");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5046", "1", "digitaladmin", "2021-12-04 14:10:40", "3.141.244.182");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5047", "0", "admin", "2021-12-04 14:11:27", "64.207.179.129");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5048", "1", "digitaladmin", "2021-12-04 14:12:11", "18.116.165.3");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5049", "1", "digitaladmin", "2021-12-04 14:26:24", "52.14.113.2");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5050", "1", "digitaladmin", "2021-12-04 14:43:19", "3.15.197.205");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5051", "1", "digitaladmin", "2021-12-04 14:44:13", "3.16.11.239");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5052", "0", "admin", "2021-12-04 14:47:41", "74.208.25.176");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5053", "1", "digitaladmin", "2021-12-04 14:54:13", "3.143.0.120");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5054", "1", "digitaladmin", "2021-12-04 15:05:22", "3.138.199.85");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5055", "1", "digitaladmin", "2021-12-04 15:06:58", "54.161.190.139");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5056", "1", "digitaladmin", "2021-12-04 15:22:06", "54.145.72.173");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5057", "0", "admin", "2021-12-04 15:24:09", "66.11.120.48");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5058", "1", "digitaladmin", "2021-12-04 15:36:27", "18.188.228.120");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5059", "1", "digitaladmin", "2021-12-04 15:37:51", "13.58.208.88");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5060", "1", "digitaladmin", "2021-12-04 15:50:27", "3.88.217.17");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5061", "1", "digitaladmin", "2021-12-04 15:50:37", "3.145.50.60");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5062", "1", "digitaladmin", "2021-12-04 15:55:38", "3.144.43.126");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5063", "0", "admin", "2021-12-04 16:00:36", "51.15.160.22");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5064", "1", "digitaladmin", "2021-12-04 16:10:31", "3.18.214.122");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5065", "1", "digitaladmin", "2021-12-04 16:12:43", "3.142.98.128");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5066", "1", "digitaladmin", "2021-12-04 16:13:19", "18.119.10.125");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5067", "1", "digitaladmin", "2021-12-04 16:19:08", "3.14.82.168");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5068", "1", "digitaladmin", "2021-12-04 16:27:41", "34.205.69.14");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5069", "1", "digitaladmin", "2021-12-04 16:31:32", "3.135.20.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5070", "1", "digitaladmin", "2021-12-04 16:35:11", "54.159.152.211");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5071", "1", "digitaladmin", "2021-12-04 16:41:25", "3.138.120.117");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5072", "1", "digitaladmin", "2021-12-04 16:46:07", "18.205.188.157");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5073", "1", "digitaladmin", "2021-12-04 16:55:09", "18.222.17.179");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5074", "1", "digitaladmin", "2021-12-04 17:08:09", "3.82.149.192");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5075", "1", "digitaladmin", "2021-12-04 17:10:24", "18.116.25.206");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5076", "0", "admin", "2021-12-04 17:13:38", "176.31.0.242");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5077", "1", "digitaladmin", "2021-12-04 17:24:37", "18.117.109.172");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5078", "1", "digitaladmin", "2021-12-04 17:25:31", "54.89.140.247");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5079", "1", "digitaladmin", "2021-12-04 17:35:46", "3.22.167.211");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5080", "1", "digitaladmin", "2021-12-04 17:43:26", "18.116.165.3");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5081", "0", "admin", "2021-12-04 17:49:48", "173.236.176.10");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5082", "1", "digitaladmin", "2021-12-04 17:51:49", "52.87.204.79");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5083", "1", "digitaladmin", "2021-12-04 17:57:09", "35.164.147.95");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5084", "1", "digitaladmin", "2021-12-04 18:05:11", "18.117.137.140");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5085", "1", "digitaladmin", "2021-12-04 18:07:13", "18.218.255.202");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5086", "1", "digitaladmin", "2021-12-04 18:17:59", "18.118.135.21");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5087", "1", "digitaladmin", "2021-12-04 18:25:18", "3.141.97.6");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5088", "1", "digitaladmin", "2021-12-04 18:36:08", "52.14.147.140");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5089", "1", "digitaladmin", "2021-12-04 18:45:38", "3.18.108.220");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5090", "1", "digitaladmin", "2021-12-04 18:45:43", "18.188.57.120");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5091", "1", "digitaladmin", "2021-12-04 19:02:46", "184.73.64.34");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5092", "1", "digitaladmin", "2021-12-04 19:11:49", "18.117.226.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5093", "1", "digitaladmin", "2021-12-04 19:24:09", "3.145.91.79");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5094", "1", "digitaladmin", "2021-12-04 19:30:38", "3.14.8.183");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5095", "1", "digitaladmin", "2021-12-04 19:34:39", "181.174.125.214");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5096", "1", "digitaladmin", "2021-12-04 19:38:18", "52.207.53.42");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5097", "1", "digitaladmin", "2021-12-04 19:45:15", "3.144.207.117");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5098", "1", "digitaladmin", "2021-12-04 19:48:52", "34.205.31.207");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5099", "1", "digitaladmin", "2021-12-04 19:55:16", "18.217.173.80");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5100", "1", "digitaladmin", "2021-12-04 20:09:32", "3.145.125.188");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5101", "1", "digitaladmin", "2021-12-04 20:09:32", "89.38.209.176");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5102", "1", "digitaladmin", "2021-12-04 20:18:29", "3.21.92.10");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5103", "1", "digitaladmin", "2021-12-04 20:30:34", "34.238.255.171");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5104", "1", "digitaladmin", "2021-12-04 20:33:19", "3.135.228.203");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5105", "1", "digitaladmin", "2021-12-04 20:44:54", "35.241.177.128");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5106", "1", "digitaladmin", "2021-12-04 20:45:31", "54.92.246.248");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5107", "1", "digitaladmin", "2021-12-04 20:56:31", "54.234.242.143");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5108", "1", "digitaladmin", "2021-12-04 21:07:19", "3.87.69.76");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5109", "1", "digitaladmin", "2021-12-04 21:16:55", "3.12.74.39");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5110", "1", "digitaladmin", "2021-12-04 21:19:58", "194.163.152.242");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5111", "1", "digitaladmin", "2021-12-04 21:20:52", "18.118.129.222");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5112", "1", "digitaladmin", "2021-12-04 21:30:14", "3.135.189.78");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5113", "1", "digitaladmin", "2021-12-04 21:31:05", "3.144.242.62");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5114", "1", "digitaladmin", "2021-12-04 21:51:05", "3.20.225.3");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5115", "1", "digitaladmin", "2021-12-04 21:55:18", "185.238.75.78");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5116", "1", "digitaladmin", "2021-12-04 22:05:22", "54.174.152.149");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5117", "1", "digitaladmin", "2021-12-04 22:18:04", "3.87.196.107");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5118", "1", "digitaladmin", "2021-12-04 22:19:00", "3.135.199.245");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5119", "1", "digitaladmin", "2021-12-04 22:30:05", "34.238.41.158");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5120", "1", "digitaladmin", "2021-12-04 22:30:50", "45.12.32.57");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5121", "1", "digitaladmin", "2021-12-04 22:43:28", "3.94.90.232");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5122", "1", "digitaladmin", "2021-12-04 22:53:12", "34.238.125.58");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5123", "1", "digitaladmin", "2021-12-04 23:05:57", "3.144.83.156");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5124", "1", "digitaladmin", "2021-12-04 23:06:16", "150.95.83.201");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5125", "1", "digitaladmin", "2021-12-04 23:07:03", "54.210.117.8");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5126", "1", "digitaladmin", "2021-12-04 23:20:14", "3.82.148.165");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5127", "1", "digitaladmin", "2021-12-04 23:31:12", "18.217.136.75");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5128", "1", "digitaladmin", "2021-12-04 23:44:25", "52.91.86.175");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5129", "1", "digitaladmin", "2021-12-04 23:54:02", "35.164.147.95");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5130", "1", "digitaladmin", "2021-12-04 23:55:12", "18.116.35.158");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5131", "1", "digitaladmin", "2021-12-05 00:07:34", "13.59.152.231");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5132", "1", "digitaladmin", "2021-12-05 00:08:50", "3.144.197.231");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5133", "1", "digitaladmin", "2021-12-05 00:17:42", "178.128.5.109");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5134", "1", "digitaladmin", "2021-12-05 00:19:01", "3.145.125.62");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5135", "1", "digitaladmin", "2021-12-05 00:32:45", "18.118.99.195");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5136", "1", "digitaladmin", "2021-12-05 00:43:07", "18.221.226.22");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5137", "1", "digitaladmin", "2021-12-05 00:53:22", "45.120.69.121");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5138", "1", "digitaladmin", "2021-12-05 00:55:53", "3.139.86.34");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5139", "1", "digitaladmin", "2021-12-05 00:56:49", "3.16.11.239");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5140", "1", "digitaladmin", "2021-12-05 01:10:04", "3.93.4.196");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5141", "1", "digitaladmin", "2021-12-05 01:20:16", "3.145.104.148");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5142", "1", "digitaladmin", "2021-12-05 01:29:20", "42.193.21.177");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5143", "1", "digitaladmin", "2021-12-05 01:32:37", "54.202.226.95");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5144", "1", "digitaladmin", "2021-12-05 01:45:33", "54.196.45.54");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5145", "1", "digitaladmin", "2021-12-05 01:48:58", "52.55.76.190");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5146", "1", "digitaladmin", "2021-12-05 01:56:50", "18.222.88.148");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5147", "1", "digitaladmin", "2021-12-05 01:57:46", "3.129.73.141");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5148", "1", "digitaladmin", "2021-12-05 02:08:59", "3.131.38.91");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5149", "1", "digitaladmin", "2021-12-05 02:22:31", "18.190.155.51");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5150", "1", "digitaladmin", "2021-12-05 02:34:41", "18.224.228.110");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5151", "1", "digitaladmin", "2021-12-05 02:41:42", "104.236.126.239");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5152", "1", "digitaladmin", "2021-12-05 02:45:59", "54.175.84.187");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5153", "1", "digitaladmin", "2021-12-05 02:46:56", "18.217.188.216");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5154", "1", "digitaladmin", "2021-12-05 03:06:56", "3.23.126.199");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5155", "1", "digitaladmin", "2021-12-05 03:14:53", "3.145.7.158");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5156", "1", "digitaladmin", "2021-12-05 03:17:59", "143.110.224.182");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5157", "1", "digitaladmin", "2021-12-05 03:23:32", "3.91.217.32");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5158", "1", "digitaladmin", "2021-12-05 03:35:05", "3.131.169.231");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5159", "1", "digitaladmin", "2021-12-05 03:38:11", "54.235.5.228");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5160", "1", "digitaladmin", "2021-12-05 03:50:50", "52.1.74.42");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5161", "1", "digitaladmin", "2021-12-05 03:51:46", "3.87.73.128");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5162", "1", "digitaladmin", "2021-12-05 03:54:20", "103.149.154.8");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5163", "1", "digitaladmin", "2021-12-05 03:54:57", "3.144.94.235");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5164", "1", "digitaladmin", "2021-12-05 03:59:58", "54.208.68.119");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5165", "1", "digitaladmin", "2021-12-05 04:15:23", "54.144.64.252");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5166", "1", "digitaladmin", "2021-12-05 04:28:32", "54.197.14.216");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5167", "1", "digitaladmin", "2021-12-05 04:31:05", "185.238.75.78");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5168", "1", "digitaladmin", "2021-12-05 04:40:27", "3.134.116.100");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5169", "1", "digitaladmin", "2021-12-05 04:46:35", "18.191.82.119");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5170", "1", "digitaladmin", "2021-12-05 04:53:00", "3.88.85.49");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5171", "1", "digitaladmin", "2021-12-05 05:04:45", "3.144.207.117");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5172", "1", "digitaladmin", "2021-12-05 05:08:01", "185.238.75.78");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5173", "1", "digitaladmin", "2021-12-05 05:18:09", "35.172.134.166");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5174", "1", "digitaladmin", "2021-12-05 05:31:29", "18.220.135.143");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5175", "1", "digitaladmin", "2021-12-05 05:32:45", "18.220.69.171");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5176", "1", "digitaladmin", "2021-12-05 05:43:43", "54.210.171.178");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5177", "1", "digitaladmin", "2021-12-05 05:45:05", "23.88.38.58");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5178", "1", "digitaladmin", "2021-12-05 05:45:11", "34.201.172.36");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5179", "1", "digitaladmin", "2021-12-05 05:54:23", "3.135.227.128");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5180", "1", "digitaladmin", "2021-12-05 06:09:05", "18.220.193.129");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5181", "1", "digitaladmin", "2021-12-05 06:19:55", "18.118.132.76");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5182", "1", "digitaladmin", "2021-12-05 06:22:01", "148.251.128.71");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5183", "1", "digitaladmin", "2021-12-05 06:33:25", "18.119.113.235");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5184", "1", "digitaladmin", "2021-12-05 06:35:16", "3.22.99.74");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5185", "1", "digitaladmin", "2021-12-05 06:46:21", "3.138.199.85");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5186", "1", "digitaladmin", "2021-12-05 06:58:28", "51.77.223.41");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5187", "1", "digitaladmin", "2021-12-05 07:00:20", "3.137.201.63");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5188", "1", "digitaladmin", "2021-12-05 07:10:42", "3.145.65.208");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5189", "1", "digitaladmin", "2021-12-05 07:25:22", "3.14.82.168");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5190", "1", "digitaladmin", "2021-12-05 07:27:04", "18.206.223.122");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5191", "1", "digitaladmin", "2021-12-05 07:33:35", "187.51.127.28");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5192", "1", "digitaladmin", "2021-12-05 07:38:35", "3.145.100.45");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5193", "1", "digitaladmin", "2021-12-05 07:54:47", "3.86.218.90");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5194", "1", "digitaladmin", "2021-12-05 08:05:05", "3.21.92.10");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5195", "1", "digitaladmin", "2021-12-05 08:08:34", "139.59.118.238");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5196", "1", "digitaladmin", "2021-12-05 08:15:44", "18.224.27.95");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5197", "1", "digitaladmin", "2021-12-05 08:16:51", "34.212.139.48");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5198", "1", "digitaladmin", "2021-12-05 08:29:28", "54.167.144.110");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5199", "1", "digitaladmin", "2021-12-05 08:30:17", "18.117.254.55");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5200", "1", "digitaladmin", "2021-12-05 08:41:37", "18.212.26.39");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5201", "1", "digitaladmin", "2021-12-05 08:54:39", "34.221.116.144");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5202", "1", "digitaladmin", "2021-12-05 09:05:33", "18.191.145.66");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5203", "1", "digitaladmin", "2021-12-05 09:19:17", "139.59.115.136");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5204", "1", "digitaladmin", "2021-12-05 09:19:35", "18.117.111.198");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5205", "1", "digitaladmin", "2021-12-05 09:20:04", "3.136.236.190");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5206", "1", "digitaladmin", "2021-12-05 09:32:09", "54.212.177.226");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5207", "1", "digitaladmin", "2021-12-05 09:45:12", "3.16.89.154");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5208", "1", "digitaladmin", "2021-12-05 09:54:58", "51.75.15.189");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5209", "1", "digitaladmin", "2021-12-05 10:00:21", "3.83.239.176");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5210", "1", "digitaladmin", "2021-12-05 10:10:10", "3.144.178.144");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5211", "1", "digitaladmin", "2021-12-05 10:13:22", "54.145.163.32");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5212", "1", "digitaladmin", "2021-12-05 10:24:21", "3.88.168.15");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5213", "1", "digitaladmin", "2021-12-05 10:25:36", "3.135.61.227");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5214", "1", "digitaladmin", "2021-12-05 10:30:54", "177.53.67.186");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5215", "1", "digitaladmin", "2021-12-05 10:36:26", "13.58.103.82");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5216", "1", "digitaladmin", "2021-12-05 10:49:49", "35.173.198.52");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5217", "1", "digitaladmin", "2021-12-05 11:03:40", "18.191.82.119");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5218", "1", "digitaladmin", "2021-12-05 11:14:10", "18.225.11.211");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5219", "1", "digitaladmin", "2021-12-05 11:15:42", "18.117.225.212");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5220", "1", "digitaladmin", "2021-12-05 11:28:52", "3.17.75.115");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5221", "1", "digitaladmin", "2021-12-05 11:42:14", "18.118.5.81");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5222", "1", "digitaladmin", "2021-12-05 11:42:57", "185.243.55.192");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5223", "1", "digitaladmin", "2021-12-05 11:56:12", "3.144.96.45");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5224", "1", "digitaladmin", "2021-12-05 12:08:42", "3.145.48.251");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5225", "1", "digitaladmin", "2021-12-05 12:19:09", "52.183.137.156");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5226", "1", "digitaladmin", "2021-12-05 12:23:06", "54.226.207.77");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5227", "1", "digitaladmin", "2021-12-05 12:24:46", "3.143.243.74");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5228", "1", "digitaladmin", "2021-12-05 12:35:50", "18.222.251.250");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5229", "1", "digitaladmin", "2021-12-05 12:49:24", "3.15.30.158");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5230", "1", "digitaladmin", "2021-12-05 12:55:19", "119.8.119.224");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5231", "1", "digitaladmin", "2021-12-05 13:02:37", "18.119.165.33");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5232", "1", "digitaladmin", "2021-12-05 13:13:49", "100.27.22.171");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5233", "1", "digitaladmin", "2021-12-05 13:17:55", "184.73.64.34");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5234", "1", "digitaladmin", "2021-12-05 13:29:26", "3.20.235.208");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5235", "1", "digitaladmin", "2021-12-05 13:31:42", "138.197.12.140");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5236", "1", "digitaladmin", "2021-12-05 13:45:36", "3.142.52.45");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5237", "1", "digitaladmin", "2021-12-05 14:00:38", "18.233.10.106");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5238", "1", "digitaladmin", "2021-12-05 14:08:08", "206.189.50.175");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5239", "1", "digitaladmin", "2021-12-05 14:10:43", "18.116.237.140");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5240", "1", "digitaladmin", "2021-12-05 14:14:10", "54.210.161.27");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5241", "1", "digitaladmin", "2021-12-05 14:26:38", "3.86.221.98");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5242", "1", "digitaladmin", "2021-12-05 14:27:54", "35.171.6.161");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5243", "1", "digitaladmin", "2021-12-05 14:38:40", "18.206.114.82");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5244", "1", "digitaladmin", "2021-12-05 14:48:25", "52.14.189.218");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5245", "1", "digitaladmin", "2021-12-05 14:50:39", "3.144.164.94");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5246", "1", "digitaladmin", "2021-12-05 15:00:41", "3.144.197.48");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5247", "1", "digitaladmin", "2021-12-05 15:10:18", "18.212.23.121");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5248", "1", "digitaladmin", "2021-12-05 15:23:45", "18.118.78.228");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5249", "1", "digitaladmin", "2021-12-05 15:33:09", "52.207.219.137");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5250", "1", "digitaladmin", "2021-12-05 15:44:47", "18.191.120.210");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5251", "1", "digitaladmin", "2021-12-05 15:56:29", "3.135.221.139");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5252", "1", "digitaladmin", "2021-12-05 16:06:30", "18.191.92.168");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5253", "1", "digitaladmin", "2021-12-05 16:13:33", "34.201.132.109");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5254", "1", "digitaladmin", "2021-12-05 16:15:34", "18.117.74.70");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5255", "1", "digitaladmin", "2021-12-05 16:33:45", "3.144.41.138");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5256", "1", "digitaladmin", "2021-12-05 16:39:51", "3.138.107.80");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5257", "1", "digitaladmin", "2021-12-05 16:45:19", "3.17.158.148");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5258", "1", "digitaladmin", "2021-12-05 16:46:29", "18.219.76.200");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5259", "1", "digitaladmin", "2021-12-05 16:48:36", "18.116.202.106");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5260", "1", "digitaladmin", "2021-12-05 17:02:02", "52.14.189.218");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5261", "1", "digitaladmin", "2021-12-05 17:08:45", "18.191.104.92");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5262", "1", "digitaladmin", "2021-12-05 17:11:53", "54.166.39.139");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5263", "1", "digitaladmin", "2021-12-05 17:21:04", "3.92.214.70");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5264", "1", "digitaladmin", "2021-12-05 17:22:08", "3.129.204.139");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5265", "1", "digitaladmin", "2021-12-05 17:25:48", "3.17.26.220");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5266", "1", "digitaladmin", "2021-12-05 17:48:02", "18.223.122.71");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5267", "1", "digitaladmin", "2021-12-05 17:55:30", "3.144.202.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5268", "1", "digitaladmin", "2021-12-05 18:00:31", "18.212.187.14");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5269", "1", "digitaladmin", "2021-12-05 18:09:45", "52.90.56.237");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5270", "1", "digitaladmin", "2021-12-05 18:20:39", "3.144.251.100");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5271", "1", "digitaladmin", "2021-12-05 18:25:05", "3.137.221.3");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5272", "1", "digitaladmin", "2021-12-05 18:33:44", "3.145.80.206");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5273", "1", "digitaladmin", "2021-12-05 18:47:19", "3.87.189.224");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5274", "1", "digitaladmin", "2021-12-05 18:53:56", "18.117.140.236");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5275", "1", "digitaladmin", "2021-12-05 18:54:14", "18.221.63.233");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5276", "1", "digitaladmin", "2021-12-05 18:55:57", "18.191.10.24");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5277", "1", "digitaladmin", "2021-12-05 19:04:51", "100.26.101.58");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5278", "1", "digitaladmin", "2021-12-05 19:14:20", "18.222.172.9");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5279", "1", "digitaladmin", "2021-12-05 19:25:02", "18.212.37.12");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5280", "1", "digitaladmin", "2021-12-05 19:28:07", "3.16.128.218");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5281", "1", "digitaladmin", "2021-12-05 19:34:14", "3.84.249.165");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5282", "1", "digitaladmin", "2021-12-05 19:35:22", "18.221.140.52");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5283", "1", "digitaladmin", "2021-12-05 19:46:00", "18.221.83.253");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5284", "1", "digitaladmin", "2021-12-05 19:47:32", "3.143.226.64");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5285", "1", "digitaladmin", "2021-12-05 19:51:28", "18.219.206.198");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5286", "1", "digitaladmin", "2021-12-05 19:52:49", "3.129.208.154");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5287", "1", "digitaladmin", "2021-12-05 19:55:42", "3.84.232.65");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5288", "1", "digitaladmin", "2021-12-05 20:05:24", "3.15.233.193");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5289", "1", "digitaladmin", "2021-12-05 20:20:34", "3.19.232.220");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5290", "1", "digitaladmin", "2021-12-05 20:26:30", "3.144.132.2");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5291", "1", "digitaladmin", "2021-12-05 20:36:25", "3.145.89.156");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5292", "1", "digitaladmin", "2021-12-05 20:42:38", "18.216.157.51");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5293", "1", "digitaladmin", "2021-12-05 20:53:31", "3.19.66.115");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5294", "1", "digitaladmin", "2021-12-05 20:59:42", "18.218.173.42");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5295", "1", "digitaladmin", "2021-12-05 21:05:38", "3.144.154.111");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5296", "1", "digitaladmin", "2021-12-05 21:14:13", "3.138.135.124");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5297", "1", "digitaladmin", "2021-12-05 21:23:41", "18.117.130.2");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5298", "1", "digitaladmin", "2021-12-05 21:31:54", "3.145.134.164");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5299", "1", "digitaladmin", "2021-12-05 21:35:22", "18.118.29.55");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5300", "1", "digitaladmin", "2021-12-05 21:46:43", "3.141.21.228");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5301", "1", "digitaladmin", "2021-12-05 21:56:53", "3.136.25.4");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5302", "1", "digitaladmin", "2021-12-05 22:05:13", "34.239.120.171");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5303", "1", "digitaladmin", "2021-12-05 22:18:04", "3.144.39.35");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5304", "1", "digitaladmin", "2021-12-05 22:20:25", "18.117.247.98");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5305", "1", "digitaladmin", "2021-12-05 22:30:41", "3.83.102.15");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5306", "1", "digitaladmin", "2021-12-05 22:38:43", "18.222.113.131");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5307", "1", "digitaladmin", "2021-12-05 22:49:59", "52.23.176.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5308", "1", "digitaladmin", "2021-12-05 22:57:32", "18.118.134.205");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5309", "1", "digitaladmin", "2021-12-05 23:05:32", "3.82.93.143");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5310", "1", "digitaladmin", "2021-12-05 23:10:20", "35.173.231.255");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5311", "1", "digitaladmin", "2021-12-05 23:15:03", "18.118.99.195");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5312", "1", "digitaladmin", "2021-12-05 23:23:50", "3.145.29.63");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5313", "1", "digitaladmin", "2021-12-05 23:32:19", "18.117.179.67");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5314", "1", "digitaladmin", "2021-12-05 23:42:10", "3.141.16.241");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5315", "1", "digitaladmin", "2021-12-05 23:53:18", "18.117.149.218");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5316", "1", "digitaladmin", "2021-12-05 23:58:23", "18.119.112.115");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5317", "1", "digitaladmin", "2021-12-06 00:04:31", "18.217.161.222");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5318", "1", "digitaladmin", "2021-12-06 00:18:15", "18.216.17.117");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5319", "1", "digitaladmin", "2021-12-06 00:26:36", "3.145.26.200");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5320", "1", "digitaladmin", "2021-12-06 00:36:35", "3.145.117.138");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5321", "1", "digitaladmin", "2021-12-06 00:40:13", "3.138.153.150");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5322", "1", "digitaladmin", "2021-12-06 00:47:01", "18.224.18.40");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5323", "1", "digitaladmin", "2021-12-06 00:51:07", "34.239.115.111");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5324", "1", "digitaladmin", "2021-12-06 00:59:05", "18.188.12.41");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5325", "1", "digitaladmin", "2021-12-06 01:08:23", "18.216.21.126");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5326", "1", "digitaladmin", "2021-12-06 01:18:55", "3.134.113.67");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5327", "1", "digitaladmin", "2021-12-06 01:30:24", "18.218.18.50");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5328", "1", "digitaladmin", "2021-12-06 01:34:04", "18.225.32.175");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5329", "1", "digitaladmin", "2021-12-06 01:42:59", "3.18.102.211");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5330", "1", "digitaladmin", "2021-12-06 01:53:16", "18.217.124.23");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5331", "1", "digitaladmin", "2021-12-06 02:02:27", "3.142.151.76");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5332", "1", "digitaladmin", "2021-12-06 02:12:41", "3.145.137.25");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5333", "1", "digitaladmin", "2021-12-06 02:19:26", "3.145.128.242");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5334", "1", "digitaladmin", "2021-12-06 02:25:00", "3.88.19.147");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5335", "1", "digitaladmin", "2021-12-06 02:28:29", "184.72.147.126");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5336", "1", "digitaladmin", "2021-12-06 02:38:16", "54.89.210.209");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5337", "1", "digitaladmin", "2021-12-06 02:47:26", "3.129.65.102");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5338", "1", "digitaladmin", "2021-12-06 02:57:01", "18.222.90.222");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5339", "1", "digitaladmin", "2021-12-06 03:05:33", "54.236.173.84");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5340", "1", "digitaladmin", "2021-12-06 03:12:31", "3.83.45.69");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5341", "1", "digitaladmin", "2021-12-06 03:20:11", "3.136.87.139");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5342", "1", "digitaladmin", "2021-12-06 03:31:42", "18.188.76.95");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5343", "1", "digitaladmin", "2021-12-06 03:41:14", "54.196.45.54");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5344", "1", "digitaladmin", "2021-12-06 03:49:09", "3.86.205.10");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5345", "1", "digitaladmin", "2021-12-06 03:54:14", "3.144.181.92");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5346", "1", "digitaladmin", "2021-12-06 04:01:42", "3.84.57.239");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5347", "1", "digitaladmin", "2021-12-06 04:05:40", "34.207.164.194");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5348", "1", "digitaladmin", "2021-12-06 04:12:28", "3.136.106.118");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5349", "1", "digitaladmin", "2021-12-06 04:24:22", "3.144.7.176");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5350", "1", "digitaladmin", "2021-12-06 04:31:42", "3.145.92.35");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5351", "1", "digitaladmin", "2021-12-06 04:43:59", "18.217.235.85");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5352", "1", "digitaladmin", "2021-12-06 04:46:36", "18.223.111.222");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5353", "1", "digitaladmin", "2021-12-06 04:57:18", "54.159.134.57");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5354", "1", "digitaladmin", "2021-12-06 05:09:45", "18.191.44.224");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5355", "1", "digitaladmin", "2021-12-06 05:16:12", "3.145.3.234");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5356", "1", "digitaladmin", "2021-12-06 05:26:01", "3.145.26.200");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5357", "1", "digitaladmin", "2021-12-06 05:33:56", "54.145.128.185");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5358", "1", "digitaladmin", "2021-12-06 05:40:38", "18.117.154.169");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5359", "1", "digitaladmin", "2021-12-06 05:50:21", "3.16.109.159");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5360", "1", "digitaladmin", "2021-12-06 05:59:32", "3.89.20.124");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5361", "1", "digitaladmin", "2021-12-06 06:12:07", "18.216.210.214");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5362", "1", "digitaladmin", "2021-12-06 06:16:02", "52.55.76.190");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5363", "1", "digitaladmin", "2021-12-06 06:20:40", "18.219.253.123");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5364", "1", "digitaladmin", "2021-12-06 06:24:14", "3.145.81.196");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5365", "1", "digitaladmin", "2021-12-06 06:34:24", "18.219.204.146");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5366", "1", "digitaladmin", "2021-12-06 06:45:26", "3.83.222.129");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5367", "1", "digitaladmin", "2021-12-06 06:54:13", "18.118.159.178");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5368", "1", "digitaladmin", "2021-12-06 07:05:31", "100.26.101.76");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5369", "1", "digitaladmin", "2021-12-06 07:09:09", "3.144.83.208");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5370", "1", "digitaladmin", "2021-12-06 07:21:04", "18.217.111.136");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5371", "1", "digitaladmin", "2021-12-06 07:29:02", "18.224.27.95");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5372", "1", "digitaladmin", "2021-12-06 07:42:03", "3.138.184.214");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5373", "1", "digitaladmin", "2021-12-06 07:52:46", "18.216.17.117");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5374", "1", "digitaladmin", "2021-12-06 07:53:56", "3.145.144.125");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5375", "1", "digitaladmin", "2021-12-06 08:02:25", "52.15.135.190");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5376", "1", "digitaladmin", "2021-12-06 08:07:43", "3.144.204.20");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5377", "1", "digitaladmin", "2021-12-06 08:14:44", "52.90.220.214");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5378", "1", "digitaladmin", "2021-12-06 08:26:00", "3.145.8.45");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5379", "1", "digitaladmin", "2021-12-06 08:35:57", "13.59.78.82");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5380", "1", "digitaladmin", "2021-12-06 08:46:46", "52.15.115.164");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5381", "1", "digitaladmin", "2021-12-06 08:52:04", "3.145.38.229");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5382", "1", "digitaladmin", "2021-12-06 09:00:45", "54.234.88.16");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5383", "1", "digitaladmin", "2021-12-06 09:12:07", "18.222.229.14");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5384", "1", "digitaladmin", "2021-12-06 09:22:44", "3.144.83.208");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5385", "1", "digitaladmin", "2021-12-06 09:34:04", "3.145.115.43");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5386", "1", "digitaladmin", "2021-12-06 09:37:40", "3.144.134.116");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5387", "1", "digitaladmin", "2021-12-06 09:47:57", "18.216.196.231");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5388", "1", "digitaladmin", "2021-12-06 09:48:22", "3.140.248.117");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5389", "1", "digitaladmin", "2021-12-06 09:58:37", "18.118.84.64");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5390", "1", "digitaladmin", "2021-12-06 10:10:56", "52.87.179.233");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5391", "1", "digitaladmin", "2021-12-06 10:23:54", "18.222.204.23");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5392", "1", "digitaladmin", "2021-12-06 10:34:55", "18.218.141.124");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5393", "1", "digitaladmin", "2021-12-06 10:35:15", "54.166.117.225");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5394", "1", "digitaladmin", "2021-12-06 10:47:08", "3.137.204.209");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5395", "1", "digitaladmin", "2021-12-06 10:58:48", "18.217.111.136");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5396", "1", "digitaladmin", "2021-12-06 11:11:00", "18.216.48.161");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5397", "1", "digitaladmin", "2021-12-06 11:20:28", "18.219.117.253");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5398", "1", "digitaladmin", "2021-12-06 11:21:41", "3.138.202.10");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5399", "1", "digitaladmin", "2021-12-06 11:24:16", "54.152.38.193");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5400", "1", "digitaladmin", "2021-12-06 11:34:39", "3.17.167.55");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5401", "1", "digitaladmin", "2021-12-06 11:35:40", "3.86.199.147");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5402", "1", "digitaladmin", "2021-12-06 11:35:55", "18.222.24.204");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5403", "1", "digitaladmin", "2021-12-06 11:45:37", "18.117.197.161");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5404", "1", "digitaladmin", "2021-12-06 11:58:04", "18.118.34.224");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5405", "1", "digitaladmin", "2021-12-06 12:08:09", "18.218.18.50");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5406", "1", "digitaladmin", "2021-12-06 12:21:18", "3.137.212.111");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5407", "1", "digitaladmin", "2021-12-06 12:22:05", "52.15.36.88");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5408", "1", "digitaladmin", "2021-12-06 12:34:31", "18.117.113.189");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5409", "1", "digitaladmin", "2021-12-06 12:45:00", "18.223.2.214");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5410", "1", "digitaladmin", "2021-12-06 12:57:18", "18.191.89.146");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5411", "1", "digitaladmin", "2021-12-06 13:09:06", "3.144.74.23");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5412", "1", "digitaladmin", "2021-12-06 13:11:59", "18.221.18.158");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5413", "1", "digitaladmin", "2021-12-06 13:22:09", "18.188.62.63");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5414", "1", "digitaladmin", "2021-12-06 13:32:13", "3.84.13.133");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5415", "1", "digitaladmin", "2021-12-06 13:45:48", "18.217.185.213");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5416", "1", "digitaladmin", "2021-12-06 13:59:58", "18.224.94.179");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5417", "1", "digitaladmin", "2021-12-06 14:00:56", "18.117.217.148");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5418", "1", "digitaladmin", "2021-12-06 14:10:38", "3.144.242.80");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5419", "1", "digitaladmin", "2021-12-06 14:12:32", "18.216.157.51");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5420", "1", "digitaladmin", "2021-12-06 14:22:26", "3.140.199.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5421", "1", "digitaladmin", "2021-12-06 14:33:32", "3.12.123.206");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5422", "1", "digitaladmin", "2021-12-06 14:47:26", "18.118.12.84");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5423", "1", "digitaladmin", "2021-12-06 15:00:38", "18.222.135.177");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5424", "1", "digitaladmin", "2021-12-06 15:13:40", "18.216.210.214");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5425", "1", "digitaladmin", "2021-12-06 15:27:50", "18.224.18.40");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5426", "1", "digitaladmin", "2021-12-06 15:35:55", "3.139.57.22");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5427", "1", "digitaladmin", "2021-12-06 15:38:59", "18.191.38.255");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5428", "1", "digitaladmin", "2021-12-06 15:50:10", "18.222.51.135");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5429", "1", "digitaladmin", "2021-12-06 15:51:57", "3.17.26.29");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5430", "1", "digitaladmin", "2021-12-06 15:58:16", "3.132.213.186");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5431", "1", "digitaladmin", "2021-12-06 16:02:58", "3.145.142.77");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5432", "1", "digitaladmin", "2021-12-06 16:09:11", "3.89.31.46");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5433", "1", "digitaladmin", "2021-12-06 16:11:51", "3.144.205.109");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5434", "1", "digitaladmin", "2021-12-06 16:21:47", "13.59.73.195");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5435", "1", "digitaladmin", "2021-12-06 16:25:56", "3.144.216.125");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5436", "1", "digitaladmin", "2021-12-06 16:41:53", "3.136.26.244");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5437", "1", "digitaladmin", "2021-12-06 16:49:50", "3.143.245.12");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5438", "1", "digitaladmin", "2021-12-06 16:55:58", "18.189.178.42");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5439", "1", "digitaladmin", "2021-12-06 17:00:26", "3.133.87.14");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5440", "1", "digitaladmin", "2021-12-06 17:10:50", "3.144.80.5");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5441", "1", "digitaladmin", "2021-12-06 17:12:54", "3.142.82.68");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5442", "1", "digitaladmin", "2021-12-06 17:19:47", "3.144.102.66");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5443", "1", "digitaladmin", "2021-12-06 17:25:25", "18.117.77.38");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5444", "1", "digitaladmin", "2021-12-06 17:36:06", "18.188.126.34");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5445", "1", "digitaladmin", "2021-12-06 17:42:20", "3.17.182.244");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5446", "1", "digitaladmin", "2021-12-06 17:46:32", "18.191.243.147");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5447", "1", "digitaladmin", "2021-12-06 17:56:35", "18.191.93.198");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5448", "1", "digitaladmin", "2021-12-06 18:02:45", "3.141.36.235");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5449", "1", "digitaladmin", "2021-12-06 18:10:10", "18.116.61.76");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5450", "1", "digitaladmin", "2021-12-06 18:10:23", "3.137.201.185");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5451", "1", "digitaladmin", "2021-12-06 18:34:14", "34.201.52.177");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5452", "1", "digitaladmin", "2021-12-06 18:50:44", "18.219.135.17");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5453", "1", "digitaladmin", "2021-12-07 16:08:40", "18.221.133.19");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5454", "1", "digitaladmin", "2021-12-07 16:39:55", "18.118.193.80");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5455", "1", "digitaladmin", "2021-12-07 16:56:38", "3.144.191.123");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5456", "1", "digitaladmin", "2021-12-07 17:15:45", "18.117.180.233");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5457", "1", "digitaladmin", "2021-12-07 17:35:36", "52.14.127.1");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5458", "1", "digitaladmin", "2021-12-07 17:52:04", "3.137.221.189");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5459", "1", "digitaladmin", "2021-12-07 18:33:54", "18.217.250.136");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5460", "1", "digitaladmin", "2021-12-07 18:45:19", "3.144.118.128");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5461", "1", "digitaladmin", "2021-12-07 19:34:27", "18.222.130.51");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5462", "1", "digitaladmin", "2021-12-07 20:27:57", "3.145.117.199");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5463", "1", "digitaladmin", "2021-12-07 20:40:31", "3.145.142.61");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5464", "1", "digitaladmin", "2021-12-07 21:32:05", "3.145.83.187");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5465", "1", "digitaladmin", "2021-12-07 21:43:03", "18.191.203.36");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5466", "1", "digitaladmin", "2021-12-07 22:33:50", "18.117.180.233");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5467", "1", "digitaladmin", "2021-12-07 23:27:34", "18.191.116.199");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5468", "1", "digitaladmin", "2021-12-07 23:37:46", "18.118.165.128");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5469", "1", "digitaladmin", "2021-12-08 00:27:54", "18.188.39.239");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5470", "1", "digitaladmin", "2021-12-08 00:35:30", "3.138.139.44");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5471", "1", "digitaladmin", "2021-12-08 01:23:10", "3.21.52.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5472", "1", "digitaladmin", "2021-12-08 01:30:27", "18.222.207.19");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5473", "1", "digitaladmin", "2021-12-08 02:20:12", "3.19.26.58");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5474", "1", "digitaladmin", "2021-12-08 03:09:36", "3.17.57.205");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5475", "1", "digitaladmin", "2021-12-08 03:19:52", "3.145.48.97");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5476", "1", "digitaladmin", "2021-12-08 04:11:31", "18.221.47.21");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5477", "1", "digitaladmin", "2021-12-08 04:25:18", "3.14.126.134");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5478", "1", "digitaladmin", "2021-12-08 05:15:10", "3.14.151.91");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5479", "1", "digitaladmin", "2021-12-08 06:05:21", "3.19.60.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5480", "1", "digitaladmin", "2021-12-08 06:16:56", "3.145.149.251");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5481", "1", "digitaladmin", "2021-12-08 07:09:25", "3.144.205.235");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5482", "1", "digitaladmin", "2021-12-08 07:19:43", "3.145.117.48");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5483", "1", "digitaladmin", "2021-12-08 08:09:13", "3.144.4.34");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5484", "1", "digitaladmin", "2021-12-08 08:25:15", "3.17.133.71");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5485", "1", "digitaladmin", "2021-12-08 09:15:18", "3.144.158.0");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5486", "1", "digitaladmin", "2021-12-08 10:04:26", "3.133.146.98");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5487", "1", "digitaladmin", "2021-12-08 10:20:10", "18.221.1.0");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5488", "1", "digitaladmin", "2021-12-08 11:05:19", "18.188.221.160");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5489", "1", "digitaladmin", "2021-12-08 11:20:27", "3.145.89.250");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5490", "1", "digitaladmin", "2021-12-08 12:10:21", "18.191.214.14");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5491", "1", "digitaladmin", "2021-12-08 12:30:39", "3.17.109.130");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5492", "1", "digitaladmin", "2021-12-08 12:48:35", "3.145.142.38");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5493", "1", "digitaladmin", "2021-12-08 13:08:33", "52.15.198.93");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5494", "1", "digitaladmin", "2021-12-08 13:20:54", "3.144.218.116");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5495", "1", "digitaladmin", "2021-12-08 13:22:28", "13.58.143.116");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5496", "1", "digitaladmin", "2021-12-08 13:38:50", "3.140.200.33");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5497", "1", "digitaladmin", "2021-12-08 13:48:41", "18.216.197.33");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5498", "1", "digitaladmin", "2021-12-08 13:49:28", "18.220.233.100");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5499", "1", "digitaladmin", "2021-12-08 13:53:44", "3.145.126.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5500", "1", "digitaladmin", "2021-12-08 14:06:56", "3.23.101.179");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5501", "1", "digitaladmin", "2021-12-08 14:14:49", "3.21.27.222");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5502", "1", "digitaladmin", "2021-12-08 14:45:13", "3.145.28.135");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5503", "1", "digitaladmin", "2021-12-08 15:09:12", "3.145.154.70");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5504", "1", "digitaladmin", "2021-12-08 15:16:13", "18.116.40.157");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5505", "1", "digitaladmin", "2021-12-08 15:21:30", "3.144.169.88");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5506", "1", "digitaladmin", "2021-12-08 15:35:48", "18.117.72.107");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5507", "1", "digitaladmin", "2021-12-08 15:40:14", "3.134.253.211");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5508", "1", "digitaladmin", "2021-12-08 15:50:31", "18.117.131.86");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5509", "1", "digitaladmin", "2021-12-08 16:00:17", "18.191.244.211");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5510", "1", "digitaladmin", "2021-12-08 16:07:02", "18.191.193.119");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5511", "1", "digitaladmin", "2021-12-08 16:23:32", "3.22.120.47");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5512", "1", "digitaladmin", "2021-12-08 16:33:18", "3.17.141.151");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5513", "1", "digitaladmin", "2021-12-08 16:37:17", "3.145.114.225");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5514", "1", "digitaladmin", "2021-12-08 16:52:39", "3.144.158.0");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5515", "1", "digitaladmin", "2021-12-08 16:59:18", "18.188.22.27");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5516", "1", "digitaladmin", "2021-12-08 17:10:13", "3.15.164.163");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5517", "1", "digitaladmin", "2021-12-08 17:12:29", "3.142.54.200");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5518", "1", "digitaladmin", "2021-12-08 17:19:26", "18.117.174.190");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5519", "1", "digitaladmin", "2021-12-08 17:23:03", "3.129.16.30");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5520", "1", "digitaladmin", "2021-12-08 17:49:13", "3.145.99.62");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5521", "1", "digitaladmin", "2021-12-08 17:58:45", "18.222.50.188");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5522", "1", "digitaladmin", "2021-12-08 18:04:18", "18.116.199.231");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5523", "1", "digitaladmin", "2021-12-08 18:08:34", "3.142.80.252");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5524", "1", "digitaladmin", "2021-12-08 18:13:14", "13.58.65.147");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5525", "1", "digitaladmin", "2021-12-08 18:15:36", "3.144.79.179");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5526", "1", "digitaladmin", "2021-12-08 18:41:50", "3.142.12.243");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5527", "1", "digitaladmin", "2021-12-08 19:02:05", "18.191.170.154");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5528", "1", "digitaladmin", "2021-12-08 19:07:03", "3.144.203.166");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5529", "1", "digitaladmin", "2021-12-08 19:15:08", "3.145.137.182");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5530", "1", "digitaladmin", "2021-12-08 19:26:13", "18.118.185.52");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5531", "1", "digitaladmin", "2021-12-08 19:34:13", "18.188.93.80");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5532", "1", "digitaladmin", "2021-12-08 19:40:48", "3.144.216.19");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5533", "1", "digitaladmin", "2021-12-08 19:58:52", "3.137.194.2");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5534", "1", "digitaladmin", "2021-12-08 20:09:04", "3.15.236.30");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5535", "1", "digitaladmin", "2021-12-08 20:15:13", "18.218.29.59");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5536", "1", "digitaladmin", "2021-12-08 20:29:06", "18.223.205.47");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5537", "1", "digitaladmin", "2021-12-08 20:31:11", "18.217.140.95");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5538", "1", "digitaladmin", "2021-12-08 20:42:35", "18.117.193.210");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5539", "1", "digitaladmin", "2021-12-08 20:58:49", "18.191.210.45");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5540", "1", "digitaladmin", "2021-12-08 21:13:34", "18.191.169.179");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5541", "1", "digitaladmin", "2021-12-08 21:24:44", "18.116.46.95");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5542", "1", "digitaladmin", "2021-12-08 21:30:24", "18.223.239.232");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5543", "1", "digitaladmin", "2021-12-08 21:40:50", "3.145.131.146");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5544", "1", "digitaladmin", "2021-12-08 21:58:37", "18.222.135.37");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5545", "1", "digitaladmin", "2021-12-08 22:11:24", "18.117.178.56");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5546", "1", "digitaladmin", "2021-12-08 22:19:50", "3.144.255.225");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5547", "1", "digitaladmin", "2021-12-08 22:27:55", "18.222.89.5");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5548", "1", "digitaladmin", "2021-12-08 22:38:21", "18.220.193.82");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5549", "1", "digitaladmin", "2021-12-08 22:46:09", "3.138.193.85");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5550", "1", "digitaladmin", "2021-12-08 22:53:40", "3.144.188.195");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5551", "1", "digitaladmin", "2021-12-08 23:12:13", "3.138.108.88");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5552", "1", "digitaladmin", "2021-12-08 23:27:36", "18.188.195.135");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5553", "1", "digitaladmin", "2021-12-08 23:39:56", "3.16.130.106");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5554", "1", "digitaladmin", "2021-12-08 23:45:25", "18.222.204.255");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5555", "1", "digitaladmin", "2021-12-08 23:55:35", "3.144.205.233");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5556", "1", "digitaladmin", "2021-12-09 00:08:21", "3.144.171.89");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5557", "1", "digitaladmin", "2021-12-09 00:28:55", "3.144.91.216");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5558", "1", "digitaladmin", "2021-12-09 00:38:42", "3.135.63.118");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5559", "1", "digitaladmin", "2021-12-09 00:44:37", "3.142.242.22");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5560", "1", "digitaladmin", "2021-12-09 00:55:57", "3.145.98.70");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5561", "1", "digitaladmin", "2021-12-09 01:03:09", "3.143.255.245");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5562", "1", "digitaladmin", "2021-12-09 01:11:31", "3.145.81.189");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5563", "1", "digitaladmin", "2021-12-09 01:28:06", "18.118.169.221");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5564", "1", "digitaladmin", "2021-12-09 01:44:23", "3.145.115.143");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5565", "1", "digitaladmin", "2021-12-09 01:56:43", "52.15.66.104");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5566", "1", "digitaladmin", "2021-12-09 02:00:35", "3.21.100.171");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5567", "1", "digitaladmin", "2021-12-09 02:10:20", "18.118.141.62");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5568", "1", "digitaladmin", "2021-12-09 02:24:52", "18.224.19.156");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5569", "1", "digitaladmin", "2021-12-09 02:28:16", "3.18.104.25");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5570", "1", "digitaladmin", "2021-12-09 02:45:10", "18.191.245.81");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5571", "1", "digitaladmin", "2021-12-09 02:53:15", "3.134.111.124");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5572", "1", "digitaladmin", "2021-12-09 03:04:00", "18.216.219.147");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5573", "1", "digitaladmin", "2021-12-09 03:11:23", "3.145.116.203");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5574", "1", "digitaladmin", "2021-12-09 03:23:44", "18.119.108.47");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5575", "1", "digitaladmin", "2021-12-09 03:45:17", "18.218.153.158");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5576", "1", "digitaladmin", "2021-12-09 03:57:00", "3.145.116.21");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5577", "1", "digitaladmin", "2021-12-09 04:03:23", "18.220.243.17");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5578", "1", "digitaladmin", "2021-12-09 04:14:22", "18.191.214.14");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5579", "1", "digitaladmin", "2021-12-09 04:20:42", "18.117.108.225");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5580", "1", "digitaladmin", "2021-12-09 04:32:29", "3.17.182.218");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5581", "1", "digitaladmin", "2021-12-09 04:48:18", "18.188.54.245");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5582", "1", "digitaladmin", "2021-12-09 05:05:39", "18.221.186.15");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5583", "1", "digitaladmin", "2021-12-09 05:12:44", "3.17.67.48");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5584", "1", "digitaladmin", "2021-12-09 05:24:57", "3.142.92.27");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5585", "1", "digitaladmin", "2021-12-09 05:35:24", "18.119.103.127");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5586", "1", "digitaladmin", "2021-12-09 05:50:21", "3.129.92.158");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5587", "1", "digitaladmin", "2021-12-09 06:09:00", "18.188.134.111");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5588", "1", "digitaladmin", "2021-12-09 06:20:14", "3.145.90.25");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5589", "1", "digitaladmin", "2021-12-09 06:26:38", "18.219.56.111");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5590", "1", "digitaladmin", "2021-12-09 06:34:56", "13.58.118.41");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5591", "1", "digitaladmin", "2021-12-09 06:45:19", "3.144.221.136");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5592", "1", "digitaladmin", "2021-12-09 06:57:07", "18.222.51.200");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5593", "1", "digitaladmin", "2021-12-09 07:10:20", "18.224.19.58");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5594", "1", "digitaladmin", "2021-12-09 07:40:02", "18.189.27.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5595", "0", "admin", "2021-12-18 06:27:03", "207.55.255.20");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5596", "0", "admin", "2021-12-18 06:31:35", "34.64.218.102");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5597", "0", "admin", "2021-12-18 06:32:18", "35.200.90.127");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5598", "0", "admin", "2021-12-18 06:37:15", "199.192.30.216");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5599", "1", "digitaladmin", "2021-12-18 06:38:17", "162.0.239.41");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5600", "1", "digitaladmin", "2021-12-18 06:43:10", "190.92.152.62");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5601", "1", "digitaladmin", "2021-12-18 06:43:53", "141.94.21.233");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5602", "1", "digitaladmin", "2021-12-18 06:47:58", "185.3.235.221");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5603", "1", "digitaladmin", "2021-12-18 06:49:27", "103.109.30.30");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5604", "1", "digitaladmin", "2021-12-18 06:53:54", "194.163.159.35");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5605", "1", "digitaladmin", "2021-12-18 06:59:11", "157.245.107.81");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5606", "1", "digitaladmin", "2021-12-18 07:00:26", "93.113.111.34");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5607", "1", "digitaladmin", "2021-12-18 07:05:21", "97.79.236.218");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5608", "1", "digitaladmin", "2021-12-18 07:06:03", "194.233.88.149");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5609", "1", "digitaladmin", "2021-12-18 07:11:19", "198.12.253.113");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5610", "1", "digitaladmin", "2021-12-18 07:12:24", "67.211.219.84");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5611", "1", "digitaladmin", "2021-12-18 07:17:31", "97.79.236.218");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5612", "1", "digitaladmin", "2021-12-18 07:18:36", "112.213.103.164");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5613", "1", "digitaladmin", "2021-12-18 07:23:51", "103.13.112.90");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5614", "1", "digitaladmin", "2021-12-18 07:24:45", "91.206.201.131");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5615", "1", "digitaladmin", "2021-12-18 07:29:55", "47.241.26.170");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5616", "1", "digitaladmin", "2021-12-18 07:30:45", "82.196.10.165");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5617", "1", "digitaladmin", "2021-12-18 07:37:19", "185.67.100.197");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5618", "1", "digitaladmin", "2021-12-18 07:41:53", "52.196.12.209");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5619", "1", "digitaladmin", "2021-12-18 07:43:28", "176.235.216.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5620", "1", "digitaladmin", "2021-12-18 07:48:23", "203.171.21.225");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5621", "1", "digitaladmin", "2021-12-18 07:49:31", "112.213.103.164");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5622", "1", "digitaladmin", "2021-12-18 07:55:41", "46.226.148.217");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5623", "1", "digitaladmin", "2021-12-18 08:00:42", "80.80.218.230");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5624", "1", "digitaladmin", "2021-12-18 08:01:49", "134.122.46.215");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5625", "1", "digitaladmin", "2021-12-18 08:08:08", "192.64.150.25");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5626", "1", "digitaladmin", "2021-12-18 08:13:22", "199.195.254.132");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5627", "1", "digitaladmin", "2021-12-18 08:14:40", "116.62.102.247");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5628", "1", "digitaladmin", "2021-12-18 08:19:53", "97.79.236.218");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5629", "1", "digitaladmin", "2021-12-18 08:25:33", "194.35.12.109");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5630", "1", "digitaladmin", "2021-12-18 08:37:08", "119.8.119.224");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5631", "1", "digitaladmin", "2021-12-18 08:41:29", "161.35.237.119");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5632", "1", "digitaladmin", "2021-12-18 08:48:39", "185.243.55.192");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5633", "1", "digitaladmin", "2021-12-18 08:52:59", "95.128.43.176");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5634", "1", "digitaladmin", "2021-12-18 09:00:27", "138.197.156.223");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5635", "1", "digitaladmin", "2021-12-18 09:04:47", "147.182.192.77");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5636", "1", "digitaladmin", "2021-12-18 09:12:16", "159.65.76.38");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5637", "1", "digitaladmin", "2021-12-18 09:16:34", "74.208.25.176");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5638", "1", "digitaladmin", "2021-12-18 09:23:55", "198.252.110.1");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5639", "1", "digitaladmin", "2021-12-18 09:28:13", "134.209.231.225");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5640", "1", "digitaladmin", "2021-12-18 09:35:36", "45.40.166.142");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5641", "1", "digitaladmin", "2021-12-18 09:47:20", "185.2.4.44");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5642", "1", "digitaladmin", "2021-12-18 09:51:40", "134.209.231.225");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5643", "1", "digitaladmin", "2021-12-18 09:59:01", "143.198.162.183");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5644", "1", "digitaladmin", "2021-12-18 10:10:46", "167.172.153.166");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5645", "1", "digitaladmin", "2021-12-18 10:15:05", "5.9.55.176");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5646", "1", "digitaladmin", "2021-12-18 10:26:51", "144.76.102.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5647", "1", "digitaladmin", "2021-12-18 10:34:21", "94.130.58.196");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5648", "1", "digitaladmin", "2021-12-18 10:46:19", "121.43.170.78");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5649", "1", "digitaladmin", "2021-12-18 10:58:08", "162.240.27.242");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5650", "1", "digitaladmin", "2021-12-18 11:02:30", "46.63.80.162");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5651", "1", "digitaladmin", "2021-12-18 11:10:02", "185.190.117.89");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5652", "1", "digitaladmin", "2021-12-18 11:14:24", "46.101.244.141");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5653", "1", "digitaladmin", "2021-12-18 11:21:55", "46.101.121.131");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5654", "1", "digitaladmin", "2021-12-18 11:26:12", "188.166.56.218");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5655", "1", "digitaladmin", "2021-12-18 11:33:41", "167.172.153.166");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5656", "1", "digitaladmin", "2021-12-18 11:38:04", "167.71.89.92");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5657", "1", "digitaladmin", "2021-12-18 11:57:21", "193.70.114.2");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5658", "1", "digitaladmin", "2021-12-18 12:01:48", "14.36.66.221");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5659", "1", "digitaladmin", "2021-12-18 12:09:19", "34.77.178.214");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5660", "1", "digitaladmin", "2021-12-18 12:21:22", "14.36.66.221");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5661", "1", "digitaladmin", "2021-12-18 12:25:49", "161.35.52.207");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5662", "1", "digitaladmin", "2021-12-18 12:33:10", "52.183.137.156");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5663", "1", "digitaladmin", "2021-12-18 12:45:04", "212.110.92.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5664", "1", "digitaladmin", "2021-12-18 13:01:20", "194.67.91.197");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5665", "1", "digitaladmin", "2021-12-18 13:08:54", "167.172.151.91");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5666", "1", "digitaladmin", "2021-12-18 13:13:20", "103.149.154.8");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5667", "1", "digitaladmin", "2021-12-18 13:25:17", "176.9.91.103");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5668", "1", "digitaladmin", "2021-12-18 13:32:46", "81.88.52.205");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5669", "1", "digitaladmin", "2021-12-18 13:37:12", "23.99.229.218");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5670", "1", "digitaladmin", "2021-12-18 13:44:42", "104.37.84.5");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5671", "1", "digitaladmin", "2021-12-18 13:49:06", "46.101.244.141");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5672", "1", "digitaladmin", "2021-12-18 13:56:41", "207.154.226.165");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5673", "1", "digitaladmin", "2021-12-18 14:08:38", "185.2.4.44");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5674", "1", "digitaladmin", "2021-12-18 14:13:02", "138.68.69.48");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5675", "1", "digitaladmin", "2021-12-18 14:20:30", "173.212.235.115");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5676", "1", "digitaladmin", "2021-12-18 14:24:55", "8.130.55.145");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5677", "1", "digitaladmin", "2021-12-18 14:32:18", "107.172.82.148");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5678", "1", "digitaladmin", "2021-12-18 14:36:40", "194.35.12.109");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5679", "1", "digitaladmin", "2021-12-18 14:48:38", "194.163.153.230");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5680", "1", "digitaladmin", "2021-12-18 15:00:38", "194.67.91.197");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5681", "1", "digitaladmin", "2021-12-18 15:08:16", "194.233.72.23");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5682", "1", "digitaladmin", "2021-12-18 15:12:45", "162.144.126.104");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5683", "1", "digitaladmin", "2021-12-18 15:20:19", "185.126.219.43");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5684", "1", "digitaladmin", "2021-12-18 15:24:45", "116.203.150.71");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5685", "1", "digitaladmin", "2021-12-18 15:32:22", "94.23.72.30");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5686", "1", "digitaladmin", "2021-12-18 15:44:21", "23.97.205.210");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5687", "1", "digitaladmin", "2021-12-18 15:48:51", "163.178.170.141");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5688", "1", "digitaladmin", "2021-12-18 15:56:28", "173.255.112.220");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5689", "1", "digitaladmin", "2021-12-18 16:00:55", "92.63.106.95");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5690", "1", "digitaladmin", "2021-12-18 16:08:37", "194.35.12.109");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5691", "1", "digitaladmin", "2021-12-18 16:13:05", "103.109.28.1");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5692", "1", "digitaladmin", "2021-12-18 16:32:56", "148.251.128.71");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5693", "1", "digitaladmin", "2021-12-18 16:37:26", "209.97.162.248");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5694", "1", "digitaladmin", "2021-12-18 16:45:06", "188.166.1.143");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5695", "1", "digitaladmin", "2021-12-18 16:57:16", "34.75.201.58");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5696", "1", "digitaladmin", "2021-12-18 17:01:48", "13.229.221.204");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5697", "1", "digitaladmin", "2021-12-18 17:09:34", "95.216.235.214");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5698", "1", "digitaladmin", "2021-12-18 17:21:41", "45.40.166.143");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5699", "1", "digitaladmin", "2021-12-18 17:26:09", "31.192.208.12");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5700", "1", "digitaladmin", "2021-12-18 17:33:51", "65.21.234.156");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5701", "1", "digitaladmin", "2021-12-18 17:38:17", "193.70.114.2");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5702", "1", "digitaladmin", "2021-12-18 17:45:52", "13.81.59.92");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5703", "1", "digitaladmin", "2021-12-18 17:50:22", "188.166.33.234");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5704", "1", "digitaladmin", "2021-12-18 18:09:58", "46.101.208.60");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5705", "1", "digitaladmin", "2021-12-18 18:14:23", "95.128.43.176");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5706", "1", "digitaladmin", "2021-12-18 18:21:58", "13.81.59.92");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5707", "1", "digitaladmin", "2021-12-18 18:26:31", "194.163.152.242");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5708", "1", "digitaladmin", "2021-12-18 18:34:07", "157.245.110.251");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5709", "1", "digitaladmin", "2021-12-18 18:38:32", "148.251.128.71");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5710", "1", "digitaladmin", "2021-12-18 18:46:12", "195.242.103.103");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5711", "1", "digitaladmin", "2021-12-18 18:50:43", "185.206.92.65");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5712", "1", "digitaladmin", "2021-12-18 19:02:47", "103.130.218.178");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5713", "1", "digitaladmin", "2021-12-18 19:10:29", "159.65.115.75");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5714", "1", "digitaladmin", "2021-12-18 19:14:51", "159.203.115.159");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5715", "1", "digitaladmin", "2021-12-18 19:22:18", "207.180.213.165");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5716", "1", "digitaladmin", "2021-12-18 19:26:45", "161.35.52.207");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5717", "1", "digitaladmin", "2021-12-18 19:38:31", "14.36.66.221");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5718", "1", "digitaladmin", "2021-12-18 19:45:57", "159.65.216.18");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5719", "1", "digitaladmin", "2021-12-18 19:50:21", "103.1.100.202");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5720", "1", "digitaladmin", "2021-12-18 19:57:43", "144.76.102.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5721", "1", "digitaladmin", "2021-12-18 20:09:35", "167.99.252.52");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5722", "1", "digitaladmin", "2021-12-18 20:14:00", "208.109.54.127");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5723", "0", "admin", "2021-12-18 21:11:12", "194.13.83.88");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5724", "0", "admin", "2021-12-18 21:15:27", "103.39.134.190");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5725", "0", "admin", "2021-12-18 21:26:55", "82.223.111.249");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5726", "0", "admin", "2021-12-18 21:34:15", "64.141.87.4");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5727", "0", "admin", "2021-12-18 21:38:34", "5.189.133.114");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5728", "0", "admin", "2021-12-18 21:45:51", "103.39.134.190");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5729", "0", "admin", "2021-12-18 21:50:04", "45.12.32.57");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5730", "0", "admin", "2021-12-18 21:57:25", "116.203.150.71");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5731", "0", "admin", "2021-12-18 22:01:43", "139.59.75.162");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5732", "0", "admin", "2021-12-18 22:09:05", "103.39.134.190");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5733", "0", "admin", "2021-12-18 22:13:28", "18.195.159.140");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5734", "1", "digitaladmin", "2021-12-18 22:20:43", "67.227.155.85");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5735", "1", "digitaladmin", "2021-12-18 22:32:25", "178.128.54.225");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5736", "1", "digitaladmin", "2021-12-18 22:36:39", "5.9.55.176");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5737", "1", "digitaladmin", "2021-12-18 22:44:14", "134.209.196.64");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5738", "1", "digitaladmin", "2021-12-18 22:48:19", "89.96.90.125");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5739", "1", "digitaladmin", "2021-12-18 23:07:28", "65.21.234.156");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5740", "1", "digitaladmin", "2021-12-18 23:11:49", "23.94.120.151");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5741", "1", "digitaladmin", "2021-12-18 23:19:11", "178.128.194.13");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5742", "0", "admin", "2021-12-18 23:35:13", "188.166.94.198");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5743", "0", "admin", "2021-12-18 23:42:37", "34.69.109.132");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5744", "0", "admin", "2021-12-18 23:46:55", "78.157.40.35");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5745", "0", "admin", "2021-12-18 23:54:17", "47.105.61.35");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5746", "0", "admin", "2021-12-18 23:58:34", "81.88.52.168");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5747", "0", "admin", "2021-12-19 00:05:57", "81.88.52.163");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5748", "0", "admin", "2021-12-19 00:10:17", "212.103.4.29");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5749", "0", "admin", "2021-12-19 00:17:45", "139.59.118.238");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5750", "0", "admin", "2021-12-19 00:22:08", "208.109.54.127");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5751", "0", "admin", "2021-12-19 00:29:29", "133.18.77.118");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5752", "0", "admin", "2021-12-19 00:33:47", "177.55.111.11");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5753", "0", "admin", "2021-12-19 00:41:08", "157.245.217.209");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5754", "0", "admin", "2021-12-19 00:45:26", "45.40.166.142");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5755", "0", "admin", "2021-12-19 00:57:10", "159.65.76.38");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5756", "0", "admin", "2021-12-19 01:08:55", "34.92.58.160");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5757", "1", "digitaladmin", "2021-12-19 01:16:23", "93.90.192.123");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5758", "1", "digitaladmin", "2021-12-19 01:20:48", "46.101.150.34");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5759", "1", "digitaladmin", "2021-12-19 01:28:17", "161.35.34.204");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5760", "1", "digitaladmin", "2021-12-19 01:32:32", "181.174.125.214");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5761", "1", "digitaladmin", "2021-12-19 01:39:57", "194.13.83.88");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5762", "1", "digitaladmin", "2021-12-19 01:44:18", "104.37.84.5");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5763", "1", "digitaladmin", "2021-12-19 01:51:46", "68.183.108.18");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5764", "1", "digitaladmin", "2021-12-19 01:56:05", "103.149.154.8");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5765", "1", "digitaladmin", "2021-12-19 02:03:38", "185.2.4.56");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5766", "1", "digitaladmin", "2021-12-19 02:15:30", "93.113.110.104");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5767", "1", "digitaladmin", "2021-12-19 02:19:50", "188.166.94.198");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5768", "1", "digitaladmin", "2021-12-19 02:27:18", "116.255.160.108");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5769", "1", "digitaladmin", "2021-12-19 02:31:38", "167.99.252.52");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5770", "1", "digitaladmin", "2021-12-19 02:39:06", "195.242.103.103");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5771", "1", "digitaladmin", "2021-12-19 02:43:32", "207.154.226.165");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5772", "1", "digitaladmin", "2021-12-19 02:50:56", "13.81.59.92");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5773", "1", "digitaladmin", "2021-12-19 02:55:22", "34.92.58.160");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5774", "1", "digitaladmin", "2021-12-19 03:02:50", "133.18.77.118");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5775", "1", "digitaladmin", "2021-12-19 03:07:20", "104.131.92.191");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5776", "1", "digitaladmin", "2021-12-19 03:14:44", "103.28.49.63");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5777", "1", "digitaladmin", "2021-12-19 03:19:09", "167.99.138.106");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5778", "1", "digitaladmin", "2021-12-19 03:26:39", "141.94.247.170");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5779", "1", "digitaladmin", "2021-12-19 03:31:03", "111.231.4.211");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5780", "1", "digitaladmin", "2021-12-19 03:38:34", "103.142.26.247");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5781", "1", "digitaladmin", "2021-12-19 03:50:28", "162.144.63.211");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5782", "1", "digitaladmin", "2021-12-19 03:54:49", "161.97.181.141");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5783", "1", "digitaladmin", "2021-12-19 04:06:51", "161.97.82.55");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5784", "1", "digitaladmin", "2021-12-19 04:18:47", "46.160.121.111");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5785", "1", "digitaladmin", "2021-12-19 04:26:18", "89.207.146.189");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5786", "1", "digitaladmin", "2021-12-19 04:30:43", "45.40.166.142");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5787", "1", "digitaladmin", "2021-12-19 04:38:15", "148.72.214.245");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5788", "1", "digitaladmin", "2021-12-19 04:42:42", "161.35.34.204");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5789", "1", "digitaladmin", "2021-12-19 04:50:12", "64.141.87.4");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5790", "1", "digitaladmin", "2021-12-19 04:54:39", "159.203.115.159");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5791", "1", "digitaladmin", "2021-12-19 05:02:07", "134.209.196.64");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5792", "1", "digitaladmin", "2021-12-19 05:06:24", "177.53.67.186");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5793", "1", "digitaladmin", "2021-12-19 05:13:53", "138.197.12.140");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5794", "1", "digitaladmin", "2021-12-19 05:18:23", "144.34.132.181");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5795", "1", "digitaladmin", "2021-12-19 05:25:51", "95.217.201.199");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5796", "1", "digitaladmin", "2021-12-19 05:30:08", "94.23.72.30");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5797", "1", "digitaladmin", "2021-12-19 05:37:34", "34.72.140.173");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5798", "1", "digitaladmin", "2021-12-19 05:41:45", "64.225.70.87");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5799", "1", "digitaladmin", "2021-12-19 05:49:04", "74.208.25.176");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5800", "1", "digitaladmin", "2021-12-19 05:53:22", "77.240.13.186");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5801", "1", "digitaladmin", "2021-12-19 06:00:42", "81.88.52.26");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5802", "1", "digitaladmin", "2021-12-19 06:05:00", "83.169.37.4");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5803", "1", "digitaladmin", "2021-12-19 06:12:25", "88.87.206.123");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5804", "1", "digitaladmin", "2021-12-19 06:16:52", "187.51.127.28");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5805", "1", "digitaladmin", "2021-12-19 06:24:10", "159.65.216.18");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5806", "1", "digitaladmin", "2021-12-19 06:28:27", "116.203.150.71");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5807", "1", "digitaladmin", "2021-12-19 06:35:55", "138.68.140.0");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5808", "1", "digitaladmin", "2021-12-19 06:40:13", "107.172.82.148");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5809", "1", "digitaladmin", "2021-12-19 06:51:59", "5.35.247.166");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5810", "1", "digitaladmin", "2021-12-19 06:59:26", "185.126.219.43");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5811", "1", "digitaladmin", "2021-12-19 07:34:51", "173.255.112.220");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5812", "1", "digitaladmin", "2021-12-19 07:39:08", "93.90.192.123");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5813", "1", "digitaladmin", "2021-12-19 07:46:37", "77.240.13.186");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5814", "1", "digitaladmin", "2021-12-19 07:50:57", "162.240.27.242");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5815", "1", "digitaladmin", "2021-12-19 07:58:35", "46.101.150.34");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5816", "1", "digitaladmin", "2021-12-19 08:10:14", "161.35.99.169");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5817", "1", "digitaladmin", "2021-12-19 08:14:36", "188.166.94.198");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5818", "1", "digitaladmin", "2021-12-19 08:26:27", "185.2.4.71");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5819", "1", "digitaladmin", "2021-12-19 08:33:57", "185.243.55.192");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5820", "1", "digitaladmin", "2021-12-19 08:50:16", "147.182.192.77");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5821", "1", "digitaladmin", "2021-12-19 08:57:37", "103.130.218.178");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5822", "1", "digitaladmin", "2021-12-19 09:01:59", "173.249.36.84");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5823", "1", "digitaladmin", "2021-12-19 09:09:29", "18.183.151.66");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5824", "1", "digitaladmin", "2021-12-19 09:13:52", "177.55.111.11");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5825", "1", "digitaladmin", "2021-12-19 09:21:19", "81.88.52.205");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5826", "1", "digitaladmin", "2021-12-19 09:25:47", "20.37.127.214");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5827", "1", "digitaladmin", "2021-12-19 09:33:09", "39.106.55.148");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5828", "1", "digitaladmin", "2021-12-19 09:37:36", "187.51.127.28");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5829", "1", "digitaladmin", "2021-12-19 09:49:14", "148.72.207.163");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5830", "1", "digitaladmin", "2021-12-19 09:56:40", "212.103.4.29");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5831", "1", "digitaladmin", "2021-12-19 10:01:03", "145.239.30.120");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5832", "1", "digitaladmin", "2021-12-19 10:08:33", "185.2.4.44");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5833", "1", "digitaladmin", "2021-12-19 10:20:30", "195.93.152.83");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5834", "1", "digitaladmin", "2021-12-19 10:24:58", "220.132.196.5");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5835", "1", "digitaladmin", "2021-12-19 10:32:26", "95.216.221.91");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5836", "1", "digitaladmin", "2021-12-19 10:36:48", "185.2.4.71");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5837", "1", "digitaladmin", "2021-12-19 10:44:19", "89.96.90.125");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5838", "1", "digitaladmin", "2021-12-19 10:48:44", "157.245.250.226");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5839", "1", "digitaladmin", "2021-12-19 10:56:10", "206.189.6.60");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5840", "1", "digitaladmin", "2021-12-19 11:00:35", "103.159.138.24");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5841", "1", "digitaladmin", "2021-12-19 11:08:07", "78.157.40.35");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5842", "1", "digitaladmin", "2021-12-19 11:12:30", "195.93.152.83");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5843", "1", "digitaladmin", "2021-12-19 15:11:26", "81.88.52.114");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5844", "1", "digitaladmin", "2021-12-19 15:15:51", "185.25.205.159");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5845", "1", "digitaladmin", "2021-12-19 15:23:30", "77.240.13.186");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5846", "1", "digitaladmin", "2021-12-19 15:27:55", "87.249.49.150");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5847", "1", "digitaladmin", "2021-12-19 15:35:33", "138.197.12.140");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5848", "1", "digitaladmin", "2021-12-19 15:40:00", "5.9.55.176");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5849", "1", "digitaladmin", "2021-12-19 15:47:38", "177.55.111.14");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5850", "1", "digitaladmin", "2021-12-19 15:59:39", "119.8.119.224");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5851", "1", "digitaladmin", "2021-12-19 16:04:07", "185.137.233.223");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5852", "1", "digitaladmin", "2021-12-19 16:11:46", "194.67.91.197");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5853", "1", "digitaladmin", "2021-12-25 13:41:03", "107.180.108.16");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5854", "1", "digitaladmin", "2021-12-25 23:01:55", "160.116.83.28");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5855", "1", "digitaladmin", "2021-12-30 22:28:41", "184.168.96.248");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5856", "1", "digitaladmin", "2021-12-30 22:47:33", "173.201.178.186");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5857", "1", "digitaladmin", "2021-12-30 22:53:21", "207.154.196.6");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5858", "1", "digitaladmin", "2021-12-30 23:14:30", "207.180.213.165");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5859", "1", "digitaladmin", "2021-12-30 23:42:29", "51.15.160.148");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5860", "0", "[login]", "2021-12-30 23:42:30", "51.15.160.148");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5861", "1", "digitaladmin", "2021-12-30 23:47:01", "208.78.226.114");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5862", "0", "[login]", "2021-12-30 23:47:03", "208.78.226.114");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5863", "1", "digitaladmin", "2021-12-31 00:09:03", "72.167.67.108");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5864", "0", "[login]", "2021-12-31 00:09:05", "72.167.67.108");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5865", "1", "digitaladmin", "2021-12-31 00:14:46", "184.168.99.160");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5866", "0", "[login]", "2021-12-31 00:14:48", "184.168.99.160");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5867", "1", "digitaladmin", "2021-12-31 00:37:01", "77.68.27.144");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5868", "0", "[login]", "2021-12-31 00:37:02", "77.68.27.144");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5869", "1", "digitaladmin", "2021-12-31 00:43:48", "114.132.43.164");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5870", "0", "[login]", "2021-12-31 00:43:50", "114.132.43.164");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5871", "1", "digitaladmin", "2021-12-31 01:06:15", "184.168.112.225");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5872", "0", "[login]", "2021-12-31 01:06:17", "184.168.112.225");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5873", "1", "digitaladmin", "2021-12-31 01:12:00", "132.148.183.105");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5874", "1", "digitaladmin", "2021-12-31 02:07:01", "182.92.155.28");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5875", "1", "digitaladmin", "2021-12-31 02:12:34", "45.119.84.149");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5876", "1", "digitaladmin", "2021-12-31 02:36:06", "51.91.229.252");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5877", "1", "digitaladmin", "2021-12-31 02:43:30", "72.167.69.40");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5878", "1", "digitaladmin", "2021-12-31 03:08:47", "109.234.161.233");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5879", "1", "digitaladmin", "2021-12-31 03:15:20", "112.196.72.188");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5880", "1", "digitaladmin", "2021-12-31 03:41:20", "72.167.67.108");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5881", "1", "digitaladmin", "2021-12-31 03:47:52", "82.64.82.94");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5882", "1", "digitaladmin", "2021-12-31 04:15:28", "161.35.106.236");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5883", "1", "digitaladmin", "2021-12-31 04:22:00", "195.226.223.181");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5884", "1", "digitaladmin", "2021-12-31 04:48:17", "184.168.97.113");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5885", "1", "digitaladmin", "2021-12-31 04:55:28", "148.72.248.98");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5886", "1", "digitaladmin", "2021-12-31 05:22:28", "211.115.65.107");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5887", "1", "digitaladmin", "2021-12-31 05:29:45", "208.109.29.88");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5888", "1", "digitaladmin", "2021-12-31 05:53:54", "184.168.101.89");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5889", "1", "digitaladmin", "2021-12-31 05:57:04", "107.180.124.4");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5890", "1", "digitaladmin", "2021-12-31 06:12:37", "103.50.76.37");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5891", "0", "[login]", "2021-12-31 06:12:40", "103.50.76.37");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5892", "1", "digitaladmin", "2021-12-31 06:28:00", "185.165.118.46");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5893", "0", "[login]", "2021-12-31 06:28:02", "185.165.118.46");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5894", "1", "digitaladmin", "2021-12-31 06:32:57", "175.208.204.100");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5895", "1", "digitaladmin", "2021-12-31 06:47:12", "45.119.84.149");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5896", "1", "digitaladmin", "2021-12-31 06:50:03", "167.99.78.164");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5897", "0", "[login]", "2021-12-31 06:50:05", "167.99.78.164");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5898", "1", "digitaladmin", "2021-12-31 07:02:49", "185.61.154.35");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5899", "0", "[login]", "2021-12-31 07:02:50", "185.61.154.35");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5900", "1", "digitaladmin", "2021-12-31 07:07:32", "82.196.10.165");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5901", "1", "digitaladmin", "2021-12-31 07:11:55", "109.234.161.230");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5902", "1", "digitaladmin", "2021-12-31 07:13:12", "109.237.138.15");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5903", "1", "digitaladmin", "2021-12-31 07:18:48", "173.201.185.124");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5904", "1", "digitaladmin", "2021-12-31 07:20:34", "208.109.68.114");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5905", "1", "digitaladmin", "2021-12-31 07:27:56", "82.196.10.165");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5906", "1", "digitaladmin", "2021-12-31 07:33:42", "115.29.162.18");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5907", "1", "digitaladmin", "2021-12-31 07:35:21", "92.204.223.87");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5908", "1", "digitaladmin", "2021-12-31 07:41:07", "160.153.216.29");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5909", "1", "digitaladmin", "2021-12-31 07:42:55", "45.119.84.149");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5910", "1", "digitaladmin", "2021-12-31 07:48:25", "35.181.150.36");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5911", "1", "digitaladmin", "2021-12-31 07:50:13", "184.168.116.126");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5912", "1", "digitaladmin", "2021-12-31 07:55:51", "37.61.232.10");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5913", "1", "digitaladmin", "2021-12-31 07:57:32", "50.59.99.143");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5914", "1", "digitaladmin", "2021-12-31 08:03:21", "87.107.144.54");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5915", "1", "digitaladmin", "2021-12-31 08:04:58", "198.71.227.4");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5916", "1", "digitaladmin", "2021-12-31 08:10:53", "112.196.72.188");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5917", "1", "digitaladmin", "2021-12-31 08:12:31", "103.233.2.147");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5918", "1", "digitaladmin", "2021-12-31 08:18:10", "184.168.98.206");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5919", "1", "digitaladmin", "2021-12-31 08:19:49", "184.168.100.57");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5920", "1", "digitaladmin", "2021-12-31 08:25:34", "173.201.177.4");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5921", "1", "digitaladmin", "2021-12-31 08:27:28", "35.247.159.133");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5922", "1", "digitaladmin", "2021-12-31 08:33:08", "159.223.91.63");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5923", "1", "digitaladmin", "2021-12-31 08:34:45", "51.178.17.108");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5924", "1", "digitaladmin", "2021-12-31 08:40:30", "93.113.111.34");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5925", "1", "digitaladmin", "2021-12-31 08:42:10", "50.62.141.181");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5926", "1", "digitaladmin", "2021-12-31 08:49:44", "143.110.253.176");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5927", "1", "digitaladmin", "2021-12-31 08:55:14", "198.54.126.44");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5928", "1", "digitaladmin", "2021-12-31 08:57:00", "194.5.175.215");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5929", "1", "digitaladmin", "2021-12-31 09:02:53", "104.131.18.212");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5930", "1", "digitaladmin", "2021-12-31 09:04:27", "35.184.168.150");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5931", "1", "digitaladmin", "2021-12-31 09:10:30", "192.169.244.239");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5932", "1", "digitaladmin", "2021-12-31 09:17:42", "192.99.153.103");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5933", "1", "digitaladmin", "2021-12-31 09:19:22", "50.62.149.32");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5934", "1", "digitaladmin", "2021-12-31 09:25:05", "184.168.99.48");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5935", "1", "digitaladmin", "2021-12-31 09:26:55", "103.93.16.69");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5936", "1", "digitaladmin", "2021-12-31 09:32:33", "209.182.195.110");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5937", "1", "digitaladmin", "2021-12-31 09:34:32", "208.109.20.122");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5938", "1", "digitaladmin", "2021-12-31 09:41:52", "13.71.6.245");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5939", "1", "digitaladmin", "2021-12-31 09:47:25", "52.149.180.201");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5940", "1", "digitaladmin", "2021-12-31 09:49:05", "209.182.195.110");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5941", "1", "digitaladmin", "2021-12-31 09:54:49", "184.168.116.107");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5942", "1", "digitaladmin", "2021-12-31 09:56:34", "212.51.178.42");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5943", "1", "digitaladmin", "2021-12-31 10:02:21", "184.168.115.128");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5944", "1", "digitaladmin", "2021-12-31 10:04:09", "184.168.116.113");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5945", "1", "digitaladmin", "2021-12-31 10:10:03", "103.209.153.32");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5946", "1", "digitaladmin", "2021-12-31 10:11:48", "167.71.111.16");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5947", "1", "digitaladmin", "2021-12-31 10:17:35", "148.72.24.123");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5948", "1", "digitaladmin", "2021-12-31 10:19:23", "122.17.148.164");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5949", "1", "digitaladmin", "2021-12-31 10:25:11", "116.62.49.96");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5950", "1", "digitaladmin", "2021-12-31 10:27:01", "208.109.16.87");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5951", "1", "digitaladmin", "2021-12-31 10:32:45", "197.5.152.234");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5952", "1", "digitaladmin", "2021-12-31 10:34:26", "31.177.95.64");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5953", "1", "digitaladmin", "2021-12-31 10:40:08", "173.249.147.174");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5954", "1", "digitaladmin", "2021-12-31 10:41:57", "20.85.204.56");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5955", "1", "digitaladmin", "2021-12-31 10:47:40", "5.63.10.206");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5956", "1", "digitaladmin", "2021-12-31 10:55:10", "159.65.225.6");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5957", "1", "digitaladmin", "2021-12-31 10:57:05", "184.168.103.93");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5958", "1", "digitaladmin", "2021-12-31 11:02:30", "93.113.111.34");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5959", "1", "digitaladmin", "2021-12-31 11:04:21", "185.3.235.238");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5960", "1", "digitaladmin", "2021-12-31 11:10:08", "136.199.1.50");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5961", "1", "digitaladmin", "2021-12-31 11:11:47", "208.109.23.31");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5962", "1", "digitaladmin", "2021-12-31 11:17:39", "144.217.170.27");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5963", "1", "digitaladmin", "2021-12-31 11:19:10", "92.205.14.164");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5964", "1", "digitaladmin", "2021-12-31 11:25:09", "167.99.12.47");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5965", "1", "digitaladmin", "2021-12-31 11:26:43", "184.168.114.51");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5966", "1", "digitaladmin", "2021-12-31 11:32:26", "103.90.235.91");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5967", "1", "digitaladmin", "2021-12-31 11:39:52", "192.99.153.103");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5968", "1", "digitaladmin", "2021-12-31 11:41:37", "141.85.216.231");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5969", "1", "digitaladmin", "2021-12-31 11:47:18", "51.79.17.60");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5970", "1", "digitaladmin", "2021-12-31 11:49:02", "68.65.121.224");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5971", "1", "digitaladmin", "2021-12-31 11:54:42", "198.46.141.138");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5972", "1", "digitaladmin", "2021-12-31 11:56:37", "209.126.80.250");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5973", "1", "digitaladmin", "2021-12-31 12:02:12", "182.92.155.28");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5974", "1", "digitaladmin", "2021-12-31 12:03:50", "87.107.144.54");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5975", "1", "digitaladmin", "2021-12-31 12:09:32", "104.197.75.152");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5976", "1", "digitaladmin", "2021-12-31 12:11:21", "128.199.245.109");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5977", "1", "digitaladmin", "2021-12-31 12:16:58", "35.198.144.214");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5978", "1", "digitaladmin", "2021-12-31 12:18:40", "194.163.159.35");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5979", "1", "digitaladmin", "2021-12-31 12:24:18", "182.50.135.82");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5980", "1", "digitaladmin", "2021-12-31 12:26:03", "89.45.251.18");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5981", "1", "digitaladmin", "2021-12-31 12:31:39", "50.62.141.188");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5982", "1", "digitaladmin", "2021-12-31 12:33:22", "132.148.224.56");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5983", "1", "digitaladmin", "2021-12-31 12:39:04", "93.177.103.170");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5984", "1", "digitaladmin", "2021-12-31 12:40:55", "92.205.6.124");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5985", "1", "digitaladmin", "2021-12-31 12:46:34", "87.107.144.54");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5986", "1", "digitaladmin", "2021-12-31 12:48:13", "175.208.204.100");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5987", "1", "digitaladmin", "2021-12-31 12:54:02", "47.241.26.170");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5988", "1", "digitaladmin", "2021-12-31 12:55:45", "112.196.72.188");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5989", "1", "digitaladmin", "2021-12-31 13:01:36", "92.205.6.124");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5990", "1", "digitaladmin", "2021-12-31 13:03:12", "94.23.86.99");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5991", "1", "digitaladmin", "2021-12-31 13:08:55", "138.197.174.231");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5992", "1", "digitaladmin", "2021-12-31 13:10:38", "184.168.117.94");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5993", "1", "digitaladmin", "2021-12-31 13:16:03", "148.66.129.183");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5994", "1", "digitaladmin", "2021-12-31 13:17:42", "184.168.98.17");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5995", "1", "digitaladmin", "2021-12-31 13:25:17", "72.167.124.64");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5996", "1", "digitaladmin", "2021-12-31 13:31:07", "184.168.101.75");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5997", "1", "digitaladmin", "2021-12-31 13:32:58", "184.168.119.128");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5998", "1", "digitaladmin", "2021-12-31 13:38:34", "120.24.108.217");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("5999", "1", "digitaladmin", "2021-12-31 13:40:23", "186.201.49.58");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6000", "1", "digitaladmin", "2021-12-31 13:46:14", "184.168.99.248");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6001", "1", "digitaladmin", "2021-12-31 13:47:42", "92.204.223.87");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6002", "1", "digitaladmin", "2021-12-31 13:55:24", "72.167.71.145");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6003", "1", "digitaladmin", "2021-12-31 14:02:40", "89.45.251.18");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6004", "1", "digitaladmin", "2021-12-31 14:08:29", "63.35.118.131");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6005", "1", "digitaladmin", "2021-12-31 14:10:09", "92.205.14.164");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6006", "1", "digitaladmin", "2021-12-31 14:15:57", "72.167.71.145");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6007", "1", "digitaladmin", "2021-12-31 14:17:40", "92.205.7.127");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6008", "1", "digitaladmin", "2021-12-31 14:23:19", "92.204.221.14");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6009", "1", "digitaladmin", "2021-12-31 14:25:05", "174.138.30.81");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6010", "1", "digitaladmin", "2021-12-31 14:30:52", "132.148.196.75");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6011", "1", "digitaladmin", "2021-12-31 14:38:14", "184.168.100.57");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6012", "1", "digitaladmin", "2021-12-31 14:39:52", "208.109.68.114");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6013", "1", "digitaladmin", "2021-12-31 14:45:41", "141.94.21.233");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6014", "1", "digitaladmin", "2021-12-31 14:47:27", "141.94.21.233");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6015", "1", "digitaladmin", "2021-12-31 14:53:11", "142.93.43.186");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6016", "1", "digitaladmin", "2021-12-31 14:54:54", "192.138.189.160");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6017", "1", "digitaladmin", "2021-12-31 15:00:40", "199.167.202.112");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6018", "1", "digitaladmin", "2021-12-31 15:02:18", "51.79.17.60");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6019", "1", "digitaladmin", "2021-12-31 15:08:20", "81.70.151.13");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6020", "1", "digitaladmin", "2021-12-31 15:09:50", "123.31.41.38");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6021", "1", "digitaladmin", "2021-12-31 15:15:43", "64.227.53.63");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6022", "1", "digitaladmin", "2021-12-31 15:17:19", "184.168.116.113");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6023", "1", "digitaladmin", "2021-12-31 15:38:15", "184.168.99.248");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6024", "1", "digitaladmin", "2021-12-31 15:39:46", "72.167.124.187");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6025", "1", "digitaladmin", "2021-12-31 15:45:33", "184.168.101.75");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6026", "1", "digitaladmin", "2021-12-31 15:47:25", "107.181.185.226");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6027", "1", "digitaladmin", "2021-12-31 15:53:03", "104.45.41.45");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6028", "1", "digitaladmin", "2021-12-31 15:54:45", "184.168.98.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6029", "1", "digitaladmin", "2021-12-31 16:00:29", "173.201.177.4");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6030", "1", "digitaladmin", "2021-12-31 16:02:08", "72.167.105.198");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6031", "1", "digitaladmin", "2021-12-31 16:07:54", "103.153.214.231");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6032", "1", "digitaladmin", "2021-12-31 16:09:32", "195.226.223.181");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6033", "1", "digitaladmin", "2021-12-31 16:15:19", "34.147.103.188");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6034", "1", "digitaladmin", "2021-12-31 16:17:06", "185.3.235.221");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6035", "1", "digitaladmin", "2021-12-31 16:22:51", "198.11.177.173");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6036", "1", "digitaladmin", "2021-12-31 16:24:52", "89.46.109.153");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6037", "1", "digitaladmin", "2021-12-31 16:30:34", "142.93.99.56");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6038", "1", "digitaladmin", "2021-12-31 16:37:48", "167.250.5.29");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6039", "1", "digitaladmin", "2021-12-31 16:39:33", "184.168.103.93");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6040", "1", "digitaladmin", "2021-12-31 16:45:20", "148.72.210.140");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6041", "1", "digitaladmin", "2021-12-31 16:47:02", "184.168.97.21");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6042", "1", "digitaladmin", "2021-12-31 16:52:57", "43.129.212.158");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6043", "1", "digitaladmin", "2021-12-31 16:54:44", "128.199.125.232");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6044", "1", "digitaladmin", "2021-12-31 17:02:15", "142.4.4.131");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6045", "1", "digitaladmin", "2021-12-31 17:07:58", "184.168.96.149");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6046", "1", "digitaladmin", "2021-12-31 17:09:38", "182.50.135.82");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6047", "1", "digitaladmin", "2021-12-31 17:15:22", "178.128.244.166");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6048", "1", "digitaladmin", "2021-12-31 17:17:05", "199.167.202.112");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6049", "1", "digitaladmin", "2021-12-31 17:24:30", "184.168.114.51");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6050", "1", "digitaladmin", "2021-12-31 17:30:23", "142.93.170.99");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6051", "1", "digitaladmin", "2021-12-31 17:31:58", "198.46.141.138");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6052", "1", "digitaladmin", "2021-12-31 17:37:46", "3.24.51.182");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6053", "1", "digitaladmin", "2021-12-31 17:39:22", "95.128.46.215");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6054", "1", "digitaladmin", "2021-12-31 17:45:09", "93.114.234.242");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6055", "1", "digitaladmin", "2021-12-31 17:46:50", "185.145.252.60");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6056", "1", "digitaladmin", "2021-12-31 17:52:30", "92.205.6.124");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6057", "1", "digitaladmin", "2021-12-31 17:54:23", "93.113.111.193");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6058", "1", "digitaladmin", "2021-12-31 18:00:01", "125.227.127.195");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6059", "1", "digitaladmin", "2021-12-31 18:01:49", "139.59.33.202");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6060", "1", "digitaladmin", "2021-12-31 18:07:31", "173.201.178.226");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6061", "1", "digitaladmin", "2021-12-31 18:09:16", "123.31.41.38");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6062", "1", "digitaladmin", "2021-12-31 18:15:07", "47.242.50.8");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6063", "1", "digitaladmin", "2021-12-31 18:16:56", "123.31.41.38");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6064", "1", "digitaladmin", "2021-12-31 18:22:42", "198.54.126.44");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6065", "1", "digitaladmin", "2021-12-31 18:24:30", "51.79.146.95");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6066", "1", "digitaladmin", "2021-12-31 18:30:06", "149.210.227.173");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6067", "1", "digitaladmin", "2021-12-31 18:31:50", "54.36.109.56");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6068", "1", "digitaladmin", "2021-12-31 18:37:38", "173.201.188.181");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6069", "1", "digitaladmin", "2021-12-31 18:39:26", "184.168.102.31");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6070", "1", "digitaladmin", "2021-12-31 18:45:18", "157.245.196.32");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6071", "1", "digitaladmin", "2021-12-31 18:46:55", "103.1.239.107");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6072", "1", "digitaladmin", "2021-12-31 18:52:41", "150.95.110.113");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6073", "1", "digitaladmin", "2021-12-31 18:54:26", "186.201.49.58");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6074", "1", "digitaladmin", "2021-12-31 19:00:09", "186.201.49.58");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6075", "1", "digitaladmin", "2021-12-31 19:01:51", "185.18.212.66");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6076", "1", "digitaladmin", "2021-12-31 19:08:01", "185.101.158.220");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6077", "1", "digitaladmin", "2021-12-31 19:09:14", "142.93.212.172");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6078", "1", "digitaladmin", "2021-12-31 19:16:39", "185.61.154.35");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6079", "1", "digitaladmin", "2021-12-31 19:22:20", "148.72.124.124");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6080", "1", "digitaladmin", "2021-12-31 19:24:01", "89.35.28.66");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6081", "1", "digitaladmin", "2021-12-31 19:29:46", "184.168.103.68");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6082", "1", "digitaladmin", "2021-12-31 19:31:30", "52.183.137.156");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6083", "1", "digitaladmin", "2021-12-31 19:37:18", "103.50.76.37");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6084", "1", "digitaladmin", "2021-12-31 19:38:59", "91.203.111.125");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6085", "1", "digitaladmin", "2021-12-31 19:44:44", "112.196.72.188");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6086", "1", "digitaladmin", "2021-12-31 19:46:27", "125.227.127.195");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6087", "1", "digitaladmin", "2021-12-31 19:52:05", "54.36.109.56");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6088", "1", "digitaladmin", "2021-12-31 19:53:56", "184.168.103.26");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6089", "1", "digitaladmin", "2021-12-31 19:59:33", "148.72.83.149");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6090", "1", "digitaladmin", "2021-12-31 20:01:12", "103.90.235.91");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6091", "1", "digitaladmin", "2021-12-31 20:06:59", "184.168.102.31");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6092", "1", "digitaladmin", "2021-12-31 20:08:37", "132.148.196.75");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6093", "1", "digitaladmin", "2021-12-31 20:14:16", "47.103.12.183");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6094", "1", "digitaladmin", "2021-12-31 20:15:55", "185.145.252.60");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6095", "1", "digitaladmin", "2021-12-31 20:21:40", "170.249.236.83");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6096", "1", "digitaladmin", "2021-12-31 20:23:22", "63.35.118.131");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6097", "1", "digitaladmin", "2021-12-31 20:29:06", "194.163.147.193");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6098", "1", "digitaladmin", "2021-12-31 20:36:37", "50.63.194.152");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6099", "1", "digitaladmin", "2021-12-31 20:38:27", "194.5.175.215");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6100", "1", "digitaladmin", "2021-12-31 20:44:04", "132.148.47.21");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6101", "1", "digitaladmin", "2021-12-31 20:45:50", "103.104.73.82");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6102", "1", "digitaladmin", "2021-12-31 20:51:30", "185.3.235.221");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6103", "1", "digitaladmin", "2021-12-31 20:53:19", "82.196.10.165");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6104", "1", "digitaladmin", "2021-12-31 20:59:00", "93.113.111.193");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6105", "1", "digitaladmin", "2021-12-31 21:00:53", "51.91.123.235");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6106", "1", "digitaladmin", "2021-12-31 21:06:34", "35.198.144.214");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6107", "1", "digitaladmin", "2021-12-31 21:08:07", "47.107.33.26");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6108", "1", "digitaladmin", "2021-12-31 21:13:53", "37.228.136.74");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6109", "0", "admin", "2021-12-31 21:27:39", "72.167.67.108");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6110", "0", "admin", "2021-12-31 21:33:02", "143.110.247.244");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6111", "0", "admin", "2021-12-31 21:34:41", "92.205.0.137");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6112", "1", "digitaladmin", "2021-12-31 21:42:05", "184.168.117.94");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6113", "1", "digitaladmin", "2021-12-31 21:47:50", "72.167.105.198");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6114", "1", "digitaladmin", "2021-12-31 21:49:28", "47.107.33.26");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6115", "1", "digitaladmin", "2021-12-31 21:55:07", "72.167.67.108");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6116", "1", "digitaladmin", "2021-12-31 21:56:49", "184.168.103.39");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6117", "1", "digitaladmin", "2021-12-31 22:02:37", "192.99.76.109");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6118", "1", "digitaladmin", "2021-12-31 22:04:11", "93.104.213.124");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6119", "1", "digitaladmin", "2021-12-31 22:09:52", "72.167.67.108");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6120", "1", "digitaladmin", "2021-12-31 22:11:32", "47.242.50.8");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6121", "1", "digitaladmin", "2021-12-31 22:17:08", "92.243.15.140");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6122", "1", "digitaladmin", "2021-12-31 22:18:49", "103.233.2.147");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6123", "1", "digitaladmin", "2021-12-31 22:24:22", "93.113.111.193");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6124", "1", "digitaladmin", "2021-12-31 22:26:04", "184.168.114.51");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6125", "1", "digitaladmin", "2021-12-31 22:31:43", "199.195.254.132");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6126", "1", "digitaladmin", "2021-12-31 22:38:57", "92.205.0.137");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6127", "1", "digitaladmin", "2021-12-31 22:40:41", "184.168.119.128");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6128", "1", "digitaladmin", "2021-12-31 22:46:25", "153.122.75.248");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6129", "1", "digitaladmin", "2021-12-31 22:47:55", "177.55.124.21");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6130", "1", "digitaladmin", "2021-12-31 22:53:29", "132.148.196.75");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6131", "1", "digitaladmin", "2021-12-31 22:55:11", "184.168.102.151");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6132", "1", "digitaladmin", "2021-12-31 23:00:55", "117.3.54.194");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6133", "1", "digitaladmin", "2021-12-31 23:02:39", "142.93.170.99");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6134", "1", "digitaladmin", "2021-12-31 23:08:11", "186.201.49.58");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6135", "1", "digitaladmin", "2021-12-31 23:09:53", "195.226.223.181");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6136", "1", "digitaladmin", "2021-12-31 23:16:00", "109.234.161.230");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6137", "1", "digitaladmin", "2021-12-31 23:17:15", "184.168.112.225");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6138", "1", "digitaladmin", "2021-12-31 23:23:16", "51.178.249.189");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6139", "1", "digitaladmin", "2021-12-31 23:24:59", "34.147.103.188");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6140", "1", "digitaladmin", "2021-12-31 23:30:11", "184.168.112.225");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6141", "1", "digitaladmin", "2021-12-31 23:31:52", "173.201.178.186");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6142", "1", "digitaladmin", "2021-12-31 23:37:52", "167.172.56.36");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6143", "1", "digitaladmin", "2021-12-31 23:45:19", "185.70.11.21");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6144", "1", "digitaladmin", "2021-12-31 23:46:27", "35.193.222.165");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6145", "1", "digitaladmin", "2021-12-31 23:52:07", "128.199.245.109");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6146", "1", "digitaladmin", "2021-12-31 23:53:43", "117.3.54.194");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6147", "1", "digitaladmin", "2021-12-31 23:59:35", "64.225.69.194");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6148", "1", "digitaladmin", "2022-01-01 00:01:06", "84.201.143.131");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6149", "1", "digitaladmin", "2022-01-01 00:06:36", "173.201.176.153");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6150", "1", "digitaladmin", "2022-01-01 00:08:10", "148.66.129.183");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6151", "1", "digitaladmin", "2022-01-01 00:14:15", "192.99.76.109");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6152", "1", "digitaladmin", "2022-01-01 00:15:43", "35.198.144.214");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6153", "1", "digitaladmin", "2022-01-01 00:21:22", "207.180.213.165");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6154", "1", "digitaladmin", "2022-01-01 00:23:09", "51.91.123.235");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6155", "1", "digitaladmin", "2022-01-01 00:28:26", "141.85.216.231");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6156", "1", "digitaladmin", "2022-01-01 00:29:53", "35.247.159.133");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6157", "1", "digitaladmin", "2022-01-01 00:35:46", "93.104.213.124");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6158", "1", "digitaladmin", "2022-01-01 00:43:00", "93.113.111.34");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6159", "1", "digitaladmin", "2022-01-01 00:44:33", "95.128.46.215");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6160", "1", "digitaladmin", "2022-01-01 00:49:39", "159.75.71.179");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6161", "1", "digitaladmin", "2022-01-01 00:51:13", "8.12.17.18");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6162", "1", "digitaladmin", "2022-01-01 00:51:38", "89.96.90.125");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6163", "1", "digitaladmin", "2022-01-01 00:56:35", "173.201.176.23");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6164", "1", "digitaladmin", "2022-01-01 00:58:14", "184.168.99.250");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6165", "1", "digitaladmin", "2022-01-01 01:03:51", "93.113.111.193");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6166", "1", "digitaladmin", "2022-01-01 01:05:18", "128.199.199.157");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6167", "1", "digitaladmin", "2022-01-01 01:08:06", "194.163.153.230");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6168", "1", "digitaladmin", "2022-01-01 01:10:38", "159.203.31.171");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6169", "1", "digitaladmin", "2022-01-01 01:12:14", "177.11.48.209");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6170", "1", "digitaladmin", "2022-01-01 01:18:05", "192.99.76.109");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6171", "1", "digitaladmin", "2022-01-01 01:19:17", "103.63.215.26");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6172", "1", "digitaladmin", "2022-01-01 01:24:27", "128.199.14.4");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6173", "1", "digitaladmin", "2022-01-01 01:25:02", "115.29.199.218");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6174", "1", "digitaladmin", "2022-01-01 01:40:42", "51.77.223.41");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6175", "1", "digitaladmin", "2022-01-01 01:57:02", "107.172.219.253");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6176", "1", "digitaladmin", "2022-01-01 01:57:39", "45.56.93.18");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6177", "1", "digitaladmin", "2022-01-01 02:13:26", "95.217.195.206");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6178", "1", "digitaladmin", "2022-01-01 02:29:49", "51.75.15.189");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6179", "1", "digitaladmin", "2022-01-01 02:30:25", "195.242.103.103");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6180", "1", "digitaladmin", "2022-01-01 02:46:09", "158.69.63.179");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6181", "1", "digitaladmin", "2022-01-01 02:46:48", "68.183.108.18");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6182", "1", "digitaladmin", "2022-01-01 03:03:12", "167.99.252.52");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6183", "1", "digitaladmin", "2022-01-01 03:19:35", "176.9.91.103");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6184", "1", "digitaladmin", "2022-01-01 03:35:22", "45.40.166.142");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6185", "1", "digitaladmin", "2022-01-01 03:35:58", "177.55.111.14");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6186", "1", "digitaladmin", "2022-01-01 03:51:42", "47.52.190.102");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6187", "1", "digitaladmin", "2022-01-01 04:08:11", "163.178.170.141");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6188", "1", "digitaladmin", "2022-01-01 04:08:47", "187.51.127.28");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6189", "1", "digitaladmin", "2022-01-01 04:24:38", "207.244.233.113");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6190", "1", "digitaladmin", "2022-01-01 04:25:13", "195.242.103.103");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6191", "1", "digitaladmin", "2022-01-01 04:41:06", "185.182.59.44");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6192", "1", "digitaladmin", "2022-01-01 04:41:44", "207.244.233.113");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6193", "1", "digitaladmin", "2022-01-01 04:57:36", "95.216.221.91");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6194", "1", "digitaladmin", "2022-01-01 04:58:17", "165.232.180.174");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6195", "1", "digitaladmin", "2022-01-01 05:14:09", "80.249.174.66");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6196", "1", "digitaladmin", "2022-01-01 05:14:48", "72.167.34.14");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6197", "1", "digitaladmin", "2022-01-01 05:30:44", "165.227.141.125");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6198", "1", "digitaladmin", "2022-01-01 05:31:19", "46.160.121.111");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6199", "1", "digitaladmin", "2022-01-01 06:03:55", "143.244.184.195");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6200", "1", "digitaladmin", "2022-01-01 06:04:31", "8.130.55.145");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6201", "1", "digitaladmin", "2022-01-01 06:20:29", "34.75.201.58");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6202", "1", "digitaladmin", "2022-01-01 06:21:06", "145.239.30.120");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6203", "1", "digitaladmin", "2022-01-01 06:37:04", "94.23.72.30");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6204", "1", "digitaladmin", "2022-01-01 06:37:43", "64.227.16.181");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6205", "1", "digitaladmin", "2022-01-01 06:53:38", "157.245.110.251");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6206", "1", "digitaladmin", "2022-01-01 07:10:15", "91.228.56.162");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6207", "1", "digitaladmin", "2022-01-01 07:10:52", "150.95.83.201");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6208", "1", "digitaladmin", "2022-01-01 07:26:59", "46.160.121.111");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6209", "1", "digitaladmin", "2022-01-01 07:43:34", "5.9.55.176");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6210", "1", "digitaladmin", "2022-01-01 07:44:14", "119.8.119.224");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6211", "1", "digitaladmin", "2022-01-01 08:00:10", "93.113.110.104");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6212", "1", "digitaladmin", "2022-01-01 08:00:53", "178.128.247.244");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6213", "1", "digitaladmin", "2022-01-01 08:16:44", "74.208.25.176");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6214", "1", "digitaladmin", "2022-01-01 08:17:22", "45.56.93.18");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6215", "1", "digitaladmin", "2022-01-01 08:33:21", "161.35.34.204");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6216", "1", "digitaladmin", "2022-01-01 08:33:55", "156.38.216.210");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6217", "1", "digitaladmin", "2022-01-01 08:49:49", "95.217.3.203");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6218", "1", "digitaladmin", "2022-01-01 08:50:26", "161.35.15.239");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6219", "1", "digitaladmin", "2022-01-01 09:06:33", "51.77.223.41");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6220", "1", "digitaladmin", "2022-01-01 09:07:10", "178.32.89.175");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6221", "1", "digitaladmin", "2022-01-01 09:23:15", "93.113.111.54");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6222", "1", "digitaladmin", "2022-01-01 09:40:28", "111.231.4.211");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6223", "1", "digitaladmin", "2022-01-01 09:56:22", "40.69.160.139");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6224", "1", "digitaladmin", "2022-01-01 10:12:48", "133.130.103.36");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6225", "1", "digitaladmin", "2022-01-01 10:13:25", "81.88.52.175");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6226", "1", "digitaladmin", "2022-01-01 10:29:01", "171.244.188.22");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6227", "1", "digitaladmin", "2022-01-01 10:29:35", "206.189.6.60");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6228", "1", "digitaladmin", "2022-01-01 10:44:51", "164.68.99.94");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6229", "1", "digitaladmin", "2022-01-01 10:45:26", "34.121.130.98");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6230", "1", "digitaladmin", "2022-01-01 11:00:20", "157.90.80.180");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6231", "1", "digitaladmin", "2022-01-01 11:00:55", "185.2.4.44");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6232", "1", "digitaladmin", "2022-01-01 11:15:38", "187.51.127.28");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6233", "1", "digitaladmin", "2022-01-01 11:31:17", "139.59.75.162");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6234", "1", "digitaladmin", "2022-01-01 11:46:15", "72.167.34.14");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6235", "1", "digitaladmin", "2022-01-01 12:00:37", "147.182.192.77");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6236", "1", "digitaladmin", "2022-01-01 12:01:09", "148.66.129.233");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6237", "1", "digitaladmin", "2022-01-01 12:15:35", "82.223.111.249");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6238", "1", "digitaladmin", "2022-01-01 12:16:09", "74.208.25.176");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6239", "1", "digitaladmin", "2022-01-01 12:30:39", "194.35.12.109");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6240", "1", "digitaladmin", "2022-01-01 12:31:12", "46.101.244.141");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6241", "1", "digitaladmin", "2022-01-01 12:46:11", "46.101.244.141");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6242", "1", "digitaladmin", "2022-01-01 13:00:38", "103.1.100.202");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6243", "1", "digitaladmin", "2022-01-01 13:01:12", "173.212.235.115");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6244", "1", "digitaladmin", "2022-01-01 13:15:42", "46.43.9.213");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6245", "1", "digitaladmin", "2022-01-01 13:16:19", "104.236.126.239");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6246", "1", "digitaladmin", "2022-01-01 13:30:49", "157.245.95.172");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6247", "1", "digitaladmin", "2022-01-01 13:31:21", "194.163.153.230");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6248", "1", "digitaladmin", "2022-01-01 14:00:58", "139.59.75.162");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6249", "1", "digitaladmin", "2022-01-01 14:16:09", "188.212.34.69");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6250", "1", "digitaladmin", "2022-01-01 14:16:45", "121.43.170.78");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6251", "1", "digitaladmin", "2022-01-01 14:31:14", "178.32.89.175");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6252", "1", "digitaladmin", "2022-01-01 14:46:20", "77.240.13.186");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6253", "1", "digitaladmin", "2022-01-01 14:46:55", "74.208.34.142");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6254", "1", "digitaladmin", "2022-01-01 15:01:25", "34.121.222.87");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6255", "1", "digitaladmin", "2022-01-01 15:16:35", "81.88.52.205");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6256", "1", "digitaladmin", "2022-01-01 15:31:40", "195.242.103.103");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6257", "1", "digitaladmin", "2022-01-01 15:46:48", "46.101.115.116");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6258", "1", "digitaladmin", "2022-01-01 15:47:21", "23.88.38.58");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6259", "1", "digitaladmin", "2022-01-01 16:32:31", "167.172.151.91");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6260", "1", "digitaladmin", "2022-01-01 16:33:01", "193.70.114.2");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6261", "0", "admin", "2022-01-01 17:18:48", "35.202.251.51");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6262", "0", "admin", "2022-01-01 17:19:22", "206.189.129.168");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6263", "0", "admin", "2022-01-01 17:34:02", "167.172.151.91");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6264", "0", "admin", "2022-01-01 17:49:18", "178.128.215.197");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6265", "0", "admin", "2022-01-01 18:04:35", "77.240.13.186");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6266", "0", "admin", "2022-01-01 18:05:10", "94.153.161.234");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6267", "0", "admin", "2022-01-01 18:20:02", "23.94.120.151");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6268", "0", "admin", "2022-01-01 18:20:36", "150.95.83.201");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6269", "1", "digitaladmin", "2022-01-01 18:35:22", "78.47.116.216");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6270", "1", "digitaladmin", "2022-01-01 18:35:56", "74.208.25.176");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6271", "1", "digitaladmin", "2022-01-01 18:50:44", "116.203.150.71");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6272", "1", "digitaladmin", "2022-01-01 19:06:11", "207.180.213.165");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6273", "1", "digitaladmin", "2022-01-01 19:21:39", "103.90.232.219");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6274", "1", "digitaladmin", "2022-01-01 19:22:16", "35.241.123.16");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6275", "1", "digitaladmin", "2022-01-01 19:37:10", "167.71.89.92");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6276", "1", "digitaladmin", "2022-01-01 19:37:43", "119.8.119.224");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6277", "1", "digitaladmin", "2022-01-01 19:52:33", "217.9.143.94");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6278", "1", "digitaladmin", "2022-01-01 19:53:09", "119.8.119.224");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6279", "0", "admin", "2022-01-01 20:07:57", "195.201.42.236");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6280", "0", "admin", "2022-01-01 20:08:31", "185.137.233.223");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6281", "0", "admin", "2022-01-01 20:23:21", "173.255.112.220");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6282", "0", "admin", "2022-01-01 20:23:54", "185.243.55.192");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6283", "0", "admin", "2022-01-01 20:38:39", "82.223.111.249");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6284", "0", "admin", "2022-01-01 20:39:13", "89.96.90.125");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6285", "0", "admin", "2022-01-01 20:54:02", "62.178.170.93");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6286", "0", "admin", "2022-01-01 20:54:37", "103.109.28.1");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6287", "0", "admin", "2022-01-01 21:09:55", "74.208.25.176");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6288", "0", "admin", "2022-01-01 21:24:45", "195.242.103.103");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6289", "0", "admin", "2022-01-01 21:25:20", "143.198.162.183");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6290", "0", "admin", "2022-01-01 21:40:09", "103.109.28.1");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6291", "0", "admin", "2022-01-01 21:40:43", "34.92.58.160");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6292", "0", "admin", "2022-01-01 21:55:25", "119.8.119.224");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6293", "0", "admin", "2022-01-01 21:56:06", "166.62.125.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6294", "0", "admin", "2022-01-01 22:10:40", "35.194.58.218");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6295", "0", "admin", "2022-01-01 22:11:15", "115.29.199.218");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6296", "1", "digitaladmin", "2022-01-01 22:26:00", "95.217.3.203");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6297", "1", "digitaladmin", "2022-01-01 22:41:22", "192.3.165.138");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6298", "1", "digitaladmin", "2022-01-01 22:41:55", "77.77.212.90");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6299", "1", "digitaladmin", "2022-01-01 22:56:43", "47.100.208.57");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6300", "1", "digitaladmin", "2022-01-01 22:57:17", "5.189.133.114");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6301", "1", "digitaladmin", "2022-01-01 23:12:41", "103.159.138.24");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6302", "1", "digitaladmin", "2022-01-01 23:27:33", "39.106.55.148");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6303", "1", "digitaladmin", "2022-01-02 00:13:29", "194.35.12.109");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6304", "1", "digitaladmin", "2022-01-02 00:14:04", "173.212.235.115");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6305", "1", "digitaladmin", "2022-01-02 00:28:53", "207.244.233.113");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6306", "1", "digitaladmin", "2022-01-02 00:29:29", "142.93.245.196");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6307", "1", "digitaladmin", "2022-01-02 00:44:11", "13.81.59.92");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6308", "1", "digitaladmin", "2022-01-02 00:44:47", "46.101.244.141");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6309", "1", "digitaladmin", "2022-01-02 00:59:35", "158.69.63.179");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6310", "1", "digitaladmin", "2022-01-02 01:00:11", "144.76.102.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6311", "1", "digitaladmin", "2022-01-02 01:15:07", "95.217.3.203");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6312", "1", "digitaladmin", "2022-01-02 01:15:43", "47.100.208.57");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6313", "1", "digitaladmin", "2022-01-02 01:30:39", "46.160.121.111");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6314", "1", "digitaladmin", "2022-01-02 01:31:13", "68.79.63.93");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6315", "1", "digitaladmin", "2022-01-02 01:46:07", "161.35.15.239");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6316", "1", "digitaladmin", "2022-01-02 01:46:42", "34.72.140.173");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6317", "1", "digitaladmin", "2022-01-02 02:01:44", "47.241.15.39");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6318", "1", "digitaladmin", "2022-01-02 02:02:18", "148.66.129.233");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6319", "1", "digitaladmin", "2022-01-02 02:17:19", "23.94.120.151");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6320", "1", "digitaladmin", "2022-01-02 02:17:53", "88.150.159.29");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6321", "1", "digitaladmin", "2022-01-02 02:33:25", "103.109.28.1");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6322", "1", "digitaladmin", "2022-01-02 02:48:20", "64.141.87.4");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6323", "1", "digitaladmin", "2022-01-02 02:48:54", "23.99.229.218");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6324", "1", "digitaladmin", "2022-01-02 03:03:58", "14.36.66.221");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6325", "1", "digitaladmin", "2022-01-02 03:04:34", "103.28.49.63");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6326", "1", "digitaladmin", "2022-01-02 03:19:34", "94.153.161.234");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6327", "1", "digitaladmin", "2022-01-02 03:35:18", "207.180.213.165");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6328", "1", "digitaladmin", "2022-01-02 03:35:50", "106.52.171.211");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6329", "1", "digitaladmin", "2022-01-02 03:50:51", "188.212.34.69");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6330", "1", "digitaladmin", "2022-01-02 03:51:27", "91.228.56.162");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6331", "1", "digitaladmin", "2022-01-02 04:06:32", "77.77.212.90");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6332", "1", "digitaladmin", "2022-01-02 04:07:08", "94.130.58.196");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6333", "1", "digitaladmin", "2022-01-02 04:22:19", "35.202.251.51");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6334", "1", "digitaladmin", "2022-01-02 04:22:56", "217.9.143.94");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6335", "1", "digitaladmin", "2022-01-02 04:38:43", "164.68.101.188");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6336", "1", "digitaladmin", "2022-01-02 04:54:25", "94.23.72.30");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6337", "1", "digitaladmin", "2022-01-02 05:09:42", "104.37.84.5");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6338", "1", "digitaladmin", "2022-01-02 05:25:36", "47.100.208.57");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6339", "1", "digitaladmin", "2022-01-02 05:56:55", "37.139.13.163");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6340", "1", "digitaladmin", "2022-01-02 05:57:31", "122.170.98.32");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6341", "1", "digitaladmin", "2022-01-02 06:12:38", "82.202.172.247");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6342", "1", "digitaladmin", "2022-01-02 06:28:02", "37.139.13.163");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6343", "1", "digitaladmin", "2022-01-02 06:28:34", "94.23.72.30");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6344", "1", "digitaladmin", "2022-01-02 06:43:11", "45.56.93.18");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6345", "1", "digitaladmin", "2022-01-02 06:43:46", "119.8.119.224");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6346", "1", "digitaladmin", "2022-01-02 06:58:03", "188.166.1.143");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6347", "1", "digitaladmin", "2022-01-02 06:58:36", "138.68.69.48");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6348", "1", "digitaladmin", "2022-01-02 07:13:24", "217.9.143.94");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6349", "1", "digitaladmin", "2022-01-02 07:27:37", "45.120.69.121");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6350", "1", "digitaladmin", "2022-01-02 07:28:09", "115.29.199.218");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6351", "1", "digitaladmin", "2022-01-02 07:42:51", "5.9.55.176");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6352", "1", "digitaladmin", "2022-01-02 07:57:02", "34.69.57.244");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6353", "1", "digitaladmin", "2022-01-02 07:57:43", "70.36.5.102");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6354", "1", "digitaladmin", "2022-01-02 08:11:51", "66.11.120.48");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6355", "1", "digitaladmin", "2022-01-02 08:12:24", "162.214.190.209");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6356", "1", "digitaladmin", "2022-01-02 08:26:41", "35.202.150.249");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6357", "1", "digitaladmin", "2022-01-02 08:27:16", "121.243.95.160");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6358", "1", "digitaladmin", "2022-01-02 08:41:37", "68.79.63.93");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6359", "1", "digitaladmin", "2022-01-02 08:42:12", "142.93.245.196");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6360", "1", "digitaladmin", "2022-01-02 08:56:26", "185.126.219.43");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6361", "1", "digitaladmin", "2022-01-02 08:57:00", "34.121.130.98");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6362", "0", "admin", "2022-01-08 03:04:10", "120.79.29.217");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6363", "0", "admin", "2022-01-08 03:30:01", "208.109.29.88");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6364", "1", "digitaladmin", "2022-01-08 03:57:55", "199.195.254.132");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6365", "1", "digitaladmin", "2022-01-08 04:25:31", "50.63.194.153");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6366", "1", "digitaladmin", "2022-01-08 04:53:51", "47.92.73.121");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6367", "1", "digitaladmin", "2022-01-08 05:15:34", "185.49.20.78");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6368", "1", "digitaladmin", "2022-01-08 05:43:32", "128.199.186.197");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6369", "1", "digitaladmin", "2022-01-08 05:54:42", "207.154.244.58");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6370", "1", "digitaladmin", "2022-01-08 06:04:48", "43.129.172.101");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6371", "1", "digitaladmin", "2022-01-08 06:14:35", "173.249.147.174");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6372", "1", "digitaladmin", "2022-01-08 06:23:21", "68.65.123.76");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6373", "1", "digitaladmin", "2022-01-08 06:32:05", "184.168.97.210");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6374", "1", "digitaladmin", "2022-01-08 06:39:46", "20.85.204.56");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6375", "1", "digitaladmin", "2022-01-08 06:48:07", "104.45.41.45");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6376", "1", "digitaladmin", "2022-01-08 06:55:31", "31.24.128.55");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6377", "1", "digitaladmin", "2022-01-08 07:04:01", "67.222.152.219");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6378", "1", "digitaladmin", "2022-01-08 07:12:51", "39.103.194.111");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6379", "1", "digitaladmin", "2022-01-08 07:21:39", "150.95.110.113");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6380", "1", "digitaladmin", "2022-01-08 07:30:37", "172.105.234.191");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6381", "1", "digitaladmin", "2022-01-08 07:39:24", "160.153.216.29");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6382", "1", "digitaladmin", "2022-01-08 07:48:19", "74.208.103.228");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6383", "1", "digitaladmin", "2022-01-08 07:57:14", "43.241.58.180");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6384", "1", "digitaladmin", "2022-01-08 08:23:58", "164.68.110.108");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6385", "1", "digitaladmin", "2022-01-08 08:32:39", "109.234.161.230");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6386", "1", "digitaladmin", "2022-01-08 08:41:33", "82.64.82.94");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6387", "1", "digitaladmin", "2022-01-08 08:50:23", "184.168.97.210");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6388", "1", "digitaladmin", "2022-01-08 08:59:22", "173.201.186.32");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6389", "1", "digitaladmin", "2022-01-08 09:08:15", "82.64.82.94");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6390", "1", "digitaladmin", "2022-01-08 09:17:13", "173.201.183.5");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6391", "1", "digitaladmin", "2022-01-08 09:26:13", "35.193.222.165");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6392", "1", "digitaladmin", "2022-01-08 09:35:09", "185.18.212.66");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6393", "1", "digitaladmin", "2022-01-08 09:44:01", "93.113.110.240");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6394", "1", "digitaladmin", "2022-01-08 09:53:01", "148.66.147.38");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6395", "1", "digitaladmin", "2022-01-08 10:01:57", "124.158.12.202");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6396", "1", "digitaladmin", "2022-01-08 10:10:46", "135.125.2.121");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6397", "1", "digitaladmin", "2022-01-08 10:19:40", "72.167.42.45");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6398", "1", "digitaladmin", "2022-01-08 10:28:37", "167.172.56.36");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6399", "1", "digitaladmin", "2022-01-08 10:37:43", "184.168.112.225");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6400", "1", "digitaladmin", "2022-01-08 10:46:30", "104.131.18.212");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6401", "1", "digitaladmin", "2022-01-08 10:55:27", "133.167.92.28");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6402", "1", "digitaladmin", "2022-01-08 11:04:32", "184.168.96.164");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6403", "1", "digitaladmin", "2022-01-08 11:13:17", "216.158.230.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6404", "1", "digitaladmin", "2022-01-08 11:31:03", "185.106.130.251");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6405", "1", "digitaladmin", "2022-01-08 11:40:15", "51.15.160.148");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6406", "1", "digitaladmin", "2022-01-08 11:48:56", "47.254.69.97");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6407", "1", "digitaladmin", "2022-01-08 11:57:44", "199.195.254.132");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6408", "1", "digitaladmin", "2022-01-08 12:06:38", "162.214.122.88");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6409", "1", "digitaladmin", "2022-01-08 12:15:39", "184.168.115.59");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6410", "1", "digitaladmin", "2022-01-08 12:24:39", "159.65.56.30");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6411", "1", "digitaladmin", "2022-01-08 12:33:27", "184.168.101.75");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6412", "1", "digitaladmin", "2022-01-08 12:42:32", "178.62.77.224");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6413", "1", "digitaladmin", "2022-01-08 12:51:25", "103.74.118.242");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6414", "1", "digitaladmin", "2022-01-08 13:00:21", "178.128.215.197");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6415", "1", "digitaladmin", "2022-01-08 13:09:16", "103.153.214.231");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6416", "1", "digitaladmin", "2022-01-08 13:18:07", "192.81.214.168");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6417", "1", "digitaladmin", "2022-01-08 13:39:11", "93.113.111.193");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6418", "1", "digitaladmin", "2022-01-08 13:48:10", "104.131.60.249");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6419", "1", "digitaladmin", "2022-01-08 13:57:05", "148.72.197.134");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6420", "1", "digitaladmin", "2022-01-08 14:06:00", "176.235.216.155");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6421", "1", "digitaladmin", "2022-01-08 14:14:57", "185.101.158.220");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6422", "1", "digitaladmin", "2022-01-08 14:24:02", "47.254.247.161");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6423", "1", "digitaladmin", "2022-01-08 14:33:08", "207.180.213.165");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6424", "1", "digitaladmin", "2022-01-08 14:41:52", "184.168.119.128");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6425", "1", "digitaladmin", "2022-01-08 14:50:49", "95.111.250.205");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6426", "1", "digitaladmin", "2022-01-08 14:59:56", "45.55.60.110");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6427", "1", "digitaladmin", "2022-01-08 15:08:44", "184.168.103.143");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6428", "1", "digitaladmin", "2022-01-08 15:17:40", "109.234.161.230");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6429", "1", "digitaladmin", "2022-01-08 15:26:38", "150.95.110.113");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6430", "1", "digitaladmin", "2022-01-08 15:35:29", "206.81.16.252");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6431", "1", "digitaladmin", "2022-01-08 15:44:22", "103.130.218.132");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6432", "1", "digitaladmin", "2022-01-08 15:53:24", "60.205.205.107");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6433", "1", "digitaladmin", "2022-01-08 16:02:27", "94.23.86.99");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6434", "1", "digitaladmin", "2022-01-08 16:20:05", "184.168.99.253");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6435", "1", "digitaladmin", "2022-01-08 16:29:00", "184.168.99.48");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6436", "1", "digitaladmin", "2022-01-08 16:37:51", "80.88.88.149");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6437", "1", "digitaladmin", "2022-01-08 16:46:45", "101.0.97.134");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6438", "1", "digitaladmin", "2022-01-08 17:04:28", "177.55.124.21");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6439", "1", "digitaladmin", "2022-01-08 17:13:50", "206.189.6.60");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6440", "1", "digitaladmin", "2022-01-08 17:22:13", "184.168.98.94");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6441", "1", "digitaladmin", "2022-01-08 17:31:07", "184.168.96.164");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6442", "1", "digitaladmin", "2022-01-08 17:40:18", "167.99.84.255");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6443", "1", "digitaladmin", "2022-01-08 17:48:59", "103.13.242.99");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6444", "1", "digitaladmin", "2022-01-08 17:57:51", "184.168.96.248");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6445", "1", "digitaladmin", "2022-01-08 18:06:46", "184.168.98.206");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6446", "1", "digitaladmin", "2022-01-08 18:15:50", "47.114.72.18");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6447", "1", "digitaladmin", "2022-01-08 18:24:40", "197.248.5.23");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6448", "1", "digitaladmin", "2022-01-08 18:42:28", "192.81.214.91");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6449", "1", "digitaladmin", "2022-01-08 18:51:29", "47.105.86.21");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6450", "1", "digitaladmin", "2022-01-08 19:00:14", "173.249.147.104");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6451", "1", "digitaladmin", "2022-01-08 19:09:06", "185.61.153.77");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6452", "1", "digitaladmin", "2022-01-08 19:18:01", "162.214.208.84");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6453", "1", "digitaladmin", "2022-01-08 19:26:57", "35.193.222.165");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6454", "1", "digitaladmin", "2022-01-08 19:35:48", "184.168.103.39");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6455", "1", "digitaladmin", "2022-01-08 19:44:44", "103.28.39.137");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6456", "1", "digitaladmin", "2022-01-08 19:53:29", "125.227.127.195");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6457", "1", "digitaladmin", "2022-01-08 20:02:32", "167.99.12.47");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6458", "1", "digitaladmin", "2022-01-08 20:11:22", "103.13.112.90");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6459", "1", "digitaladmin", "2022-01-08 20:20:16", "34.123.125.44");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6460", "1", "digitaladmin", "2022-01-08 20:29:07", "162.0.208.15");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6461", "1", "digitaladmin", "2022-01-08 20:38:09", "116.12.48.101");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6462", "1", "digitaladmin", "2022-01-08 20:47:08", "208.109.68.114");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6463", "1", "digitaladmin", "2022-01-08 20:56:03", "139.59.153.133");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6464", "1", "digitaladmin", "2022-01-08 21:04:58", "51.79.146.95");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6465", "1", "digitaladmin", "2022-01-08 21:14:04", "159.75.71.179");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6466", "1", "digitaladmin", "2022-01-08 21:23:16", "91.205.175.35");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6467", "1", "digitaladmin", "2022-01-08 21:32:13", "208.109.23.235");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6468", "1", "digitaladmin", "2022-01-08 21:41:18", "92.204.223.147");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6469", "1", "digitaladmin", "2022-01-08 21:50:23", "137.184.78.118");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6470", "1", "digitaladmin", "2022-01-08 21:59:25", "51.178.17.108");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6471", "1", "digitaladmin", "2022-01-08 22:08:27", "134.209.145.228");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6472", "1", "digitaladmin", "2022-01-08 22:17:18", "92.204.223.27");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6473", "1", "digitaladmin", "2022-01-08 22:26:20", "75.119.140.175");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6474", "1", "digitaladmin", "2022-01-08 22:35:10", "184.168.96.164");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6475", "1", "digitaladmin", "2022-01-08 22:44:08", "185.146.20.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6476", "1", "digitaladmin", "2022-01-08 22:52:54", "184.168.97.42");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6477", "1", "digitaladmin", "2022-01-08 23:02:05", "64.227.53.63");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6478", "1", "digitaladmin", "2022-01-08 23:10:46", "184.168.116.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6479", "1", "digitaladmin", "2022-01-08 23:19:36", "1.203.77.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6480", "1", "digitaladmin", "2022-01-08 23:28:24", "82.64.82.94");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6481", "1", "digitaladmin", "2022-01-08 23:37:21", "167.99.84.255");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6482", "1", "digitaladmin", "2022-01-08 23:46:22", "184.168.97.113");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6483", "1", "digitaladmin", "2022-01-08 23:55:19", "173.201.178.186");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6484", "1", "digitaladmin", "2022-01-09 00:04:21", "208.109.28.66");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6485", "1", "digitaladmin", "2022-01-09 00:13:19", "159.75.71.179");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6486", "1", "digitaladmin", "2022-01-09 00:22:26", "152.136.15.140");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6487", "1", "digitaladmin", "2022-01-09 00:40:16", "184.168.116.113");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6488", "1", "digitaladmin", "2022-01-09 00:49:04", "184.168.113.203");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6489", "1", "digitaladmin", "2022-01-09 01:07:04", "104.131.60.249");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6490", "1", "digitaladmin", "2022-01-09 01:16:00", "186.33.211.76");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6491", "1", "digitaladmin", "2022-01-09 01:24:47", "93.104.213.124");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6492", "1", "digitaladmin", "2022-01-09 01:33:36", "46.101.95.65");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6493", "1", "digitaladmin", "2022-01-09 01:42:34", "173.212.214.140");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6494", "1", "digitaladmin", "2022-01-09 01:51:09", "82.64.82.94");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6495", "1", "digitaladmin", "2022-01-09 02:00:11", "103.93.16.69");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6496", "1", "digitaladmin", "2022-01-09 02:08:50", "206.189.6.60");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6497", "1", "digitaladmin", "2022-01-09 09:03:26", "157.90.80.180");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6498", "1", "digitaladmin", "2022-01-09 09:28:32", "185.2.4.71");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6499", "1", "digitaladmin", "2022-01-09 09:53:44", "82.192.85.41");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6500", "1", "digitaladmin", "2022-01-09 10:18:49", "82.192.85.41");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6501", "1", "digitaladmin", "2022-01-09 10:44:02", "142.93.201.0");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6502", "1", "digitaladmin", "2022-01-09 11:09:26", "162.214.190.209");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6503", "1", "digitaladmin", "2022-01-09 11:59:15", "133.130.103.36");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6504", "1", "digitaladmin", "2022-01-09 12:23:57", "82.192.85.41");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6505", "1", "digitaladmin", "2022-01-09 13:13:07", "82.192.85.41");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6506", "1", "digitaladmin", "2022-01-09 13:37:54", "138.197.12.140");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6507", "1", "digitaladmin", "2022-01-09 14:03:03", "84.112.89.42");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6508", "1", "digitaladmin", "2022-01-09 14:53:58", "47.241.15.39");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6509", "1", "digitaladmin", "2022-01-09 15:19:43", "137.117.208.19");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6510", "1", "digitaladmin", "2022-01-09 15:45:15", "72.167.34.14");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6511", "1", "digitaladmin", "2022-01-09 16:36:33", "39.106.55.148");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6512", "1", "digitaladmin", "2022-01-09 17:02:02", "121.43.170.78");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6513", "1", "digitaladmin", "2022-01-09 17:27:29", "185.2.5.25");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6514", "1", "digitaladmin", "2022-01-09 17:52:53", "20.37.127.214");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6515", "1", "digitaladmin", "2022-01-09 19:08:10", "162.144.63.211");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6516", "1", "digitaladmin", "2022-01-09 19:57:15", "137.117.208.19");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6517", "1", "digitaladmin", "2022-01-09 20:21:53", "188.166.33.234");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6518", "1", "digitaladmin", "2022-01-09 20:46:37", "64.225.70.87");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6519", "1", "digitaladmin", "2022-01-09 21:11:26", "37.139.13.163");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6520", "1", "digitaladmin", "2022-01-09 21:36:23", "195.201.42.236");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6521", "1", "digitaladmin", "2022-01-09 22:01:07", "139.59.118.238");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6522", "1", "digitaladmin", "2022-01-09 22:25:43", "95.216.235.214");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6523", "1", "digitaladmin", "2022-01-09 22:50:19", "185.153.208.38");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6524", "1", "digitaladmin", "2022-01-09 23:39:36", "157.245.95.172");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6525", "1", "digitaladmin", "2022-01-10 00:04:13", "167.99.114.53");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6526", "1", "digitaladmin", "2022-01-10 00:28:51", "81.88.52.114");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6527", "1", "digitaladmin", "2022-01-10 00:53:38", "121.243.95.160");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6528", "1", "digitaladmin", "2022-01-10 01:18:27", "188.166.236.240");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6529", "1", "digitaladmin", "2022-01-10 01:43:13", "173.255.112.220");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6530", "1", "digitaladmin", "2022-01-10 02:08:05", "164.68.101.188");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6531", "1", "digitaladmin", "2022-01-10 02:32:49", "31.192.208.12");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6532", "1", "digitaladmin", "2022-01-10 02:57:12", "194.35.12.109");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6533", "1", "digitaladmin", "2022-01-10 03:21:45", "13.81.59.92");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6534", "1", "digitaladmin", "2022-01-10 03:46:13", "185.2.5.25");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6535", "1", "digitaladmin", "2022-01-10 04:10:45", "141.94.247.170");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6536", "1", "digitaladmin", "2022-01-10 04:35:31", "23.97.205.210");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6537", "1", "digitaladmin", "2022-01-10 05:25:12", "119.8.119.224");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6538", "1", "digitaladmin", "2022-01-10 05:49:56", "46.43.9.213");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6539", "1", "digitaladmin", "2022-01-10 06:14:45", "156.38.216.210");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6540", "1", "digitaladmin", "2022-01-10 06:39:56", "64.141.87.4");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6541", "1", "digitaladmin", "2022-01-10 07:04:58", "161.35.15.239");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6542", "0", "admin", "2022-01-10 07:20:38", "94.153.161.234");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6543", "0", "admin", "2022-01-10 07:45:39", "46.43.9.213");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6544", "0", "admin", "2022-01-10 08:35:52", "181.174.125.214");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6545", "0", "admin", "2022-01-10 09:00:49", "161.97.82.55");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6546", "1", "digitaladmin", "2022-01-10 09:51:23", "68.183.108.18");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6547", "1", "digitaladmin", "2022-01-10 10:43:01", "72.167.34.14");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6548", "1", "digitaladmin", "2022-01-10 11:09:42", "194.233.72.23");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6549", "1", "digitaladmin", "2022-01-10 11:36:38", "162.144.63.211");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6550", "1", "digitaladmin", "2022-01-10 12:03:30", "34.140.57.55");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6551", "0", "admin", "2022-01-10 12:30:36", "167.71.89.92");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6552", "0", "admin", "2022-01-10 12:57:26", "34.69.109.132");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6553", "0", "admin", "2022-01-10 13:24:51", "77.240.13.186");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6554", "0", "admin", "2022-01-10 13:52:07", "134.209.231.225");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6555", "0", "admin", "2022-01-19 20:46:48", "107.150.57.36");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6556", "0", "admin", "2022-01-19 20:47:45", "107.150.57.36");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6557", "1", "digitaladmin", "2022-01-30 14:38:34", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6558", "1", "digitaladmin", "2022-01-30 14:38:35", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6559", "1", "digitaladmin", "2022-01-30 14:38:36", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6560", "1", "digitaladmin", "2022-01-30 14:38:38", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6561", "1", "digitaladmin", "2022-01-30 14:38:39", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6562", "1", "digitaladmin", "2022-01-30 14:38:41", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6563", "1", "digitaladmin", "2022-01-30 14:38:42", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6564", "1", "digitaladmin", "2022-01-30 14:38:43", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6565", "1", "digitaladmin", "2022-01-30 14:38:45", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6566", "1", "digitaladmin", "2022-01-30 14:38:46", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6567", "1", "digitaladmin", "2022-01-30 14:38:47", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6568", "1", "digitaladmin", "2022-01-30 14:38:49", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6569", "1", "digitaladmin", "2022-01-30 14:38:50", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6570", "1", "digitaladmin", "2022-01-30 14:38:52", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6571", "1", "digitaladmin", "2022-01-30 14:38:53", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6572", "1", "digitaladmin", "2022-01-30 14:38:54", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6573", "1", "digitaladmin", "2022-01-30 14:38:56", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6574", "1", "digitaladmin", "2022-01-30 14:38:57", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6575", "1", "digitaladmin", "2022-01-30 14:38:58", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6576", "1", "digitaladmin", "2022-01-30 14:39:00", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6577", "1", "digitaladmin", "2022-01-30 14:39:01", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6578", "1", "digitaladmin", "2022-01-30 14:39:03", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6579", "1", "digitaladmin", "2022-01-30 14:39:04", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6580", "1", "digitaladmin", "2022-01-30 14:39:05", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6581", "1", "digitaladmin", "2022-01-30 14:39:07", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6582", "1", "digitaladmin", "2022-01-30 14:39:08", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6583", "1", "digitaladmin", "2022-01-30 14:39:10", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6584", "1", "digitaladmin", "2022-01-30 14:39:11", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6585", "1", "digitaladmin", "2022-01-30 14:39:12", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6586", "1", "digitaladmin", "2022-01-30 14:39:14", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6587", "1", "digitaladmin", "2022-01-30 14:39:15", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6588", "1", "digitaladmin", "2022-01-30 14:39:17", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6589", "1", "digitaladmin", "2022-01-30 14:39:18", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6590", "1", "digitaladmin", "2022-01-30 14:39:19", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6591", "1", "digitaladmin", "2022-01-30 14:39:21", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6592", "1", "digitaladmin", "2022-01-30 14:39:22", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6593", "1", "digitaladmin", "2022-01-30 14:39:24", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6594", "1", "digitaladmin", "2022-01-30 14:39:25", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6595", "1", "digitaladmin", "2022-01-30 14:39:27", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6596", "1", "digitaladmin", "2022-01-30 14:39:28", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6597", "1", "digitaladmin", "2022-01-30 14:39:29", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6598", "1", "digitaladmin", "2022-01-30 14:39:31", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6599", "1", "digitaladmin", "2022-01-30 14:39:32", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6600", "1", "digitaladmin", "2022-01-30 14:39:33", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6601", "1", "digitaladmin", "2022-01-30 14:39:35", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6602", "1", "digitaladmin", "2022-01-30 14:39:36", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6603", "1", "digitaladmin", "2022-01-30 14:39:38", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6604", "1", "digitaladmin", "2022-01-30 14:39:39", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6605", "1", "digitaladmin", "2022-01-30 14:39:40", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6606", "1", "digitaladmin", "2022-01-30 14:39:42", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6607", "1", "digitaladmin", "2022-01-30 14:39:43", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6608", "1", "digitaladmin", "2022-01-30 14:39:45", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6609", "1", "digitaladmin", "2022-01-30 14:39:46", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6610", "1", "digitaladmin", "2022-01-30 14:39:47", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6611", "1", "digitaladmin", "2022-01-30 14:39:49", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6612", "1", "digitaladmin", "2022-01-30 14:39:50", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6613", "1", "digitaladmin", "2022-01-30 14:39:51", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6614", "1", "digitaladmin", "2022-01-30 14:39:52", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6615", "1", "digitaladmin", "2022-01-30 14:39:53", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6616", "1", "digitaladmin", "2022-01-30 14:39:54", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6617", "1", "digitaladmin", "2022-01-30 14:39:55", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6618", "1", "digitaladmin", "2022-01-30 14:39:56", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6619", "1", "digitaladmin", "2022-01-30 14:39:57", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6620", "1", "digitaladmin", "2022-01-30 14:39:59", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6621", "1", "digitaladmin", "2022-01-30 14:40:00", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6622", "1", "digitaladmin", "2022-01-30 14:40:01", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6623", "1", "digitaladmin", "2022-01-30 14:40:02", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6624", "1", "digitaladmin", "2022-01-30 14:40:04", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6625", "1", "digitaladmin", "2022-01-30 14:40:05", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6626", "1", "digitaladmin", "2022-01-30 14:40:06", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6627", "1", "digitaladmin", "2022-01-30 14:40:07", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6628", "1", "digitaladmin", "2022-01-30 14:40:09", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6629", "1", "digitaladmin", "2022-01-30 14:40:10", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6630", "1", "digitaladmin", "2022-01-30 14:40:11", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6631", "1", "digitaladmin", "2022-01-30 14:40:12", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6632", "1", "digitaladmin", "2022-01-30 14:40:13", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6633", "1", "digitaladmin", "2022-01-30 14:40:14", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6634", "1", "digitaladmin", "2022-01-30 14:40:15", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6635", "1", "digitaladmin", "2022-01-30 14:40:17", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6636", "1", "digitaladmin", "2022-01-30 14:40:18", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6637", "1", "digitaladmin", "2022-01-30 14:40:19", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6638", "1", "digitaladmin", "2022-01-30 14:40:20", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6639", "1", "digitaladmin", "2022-01-30 14:40:21", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6640", "1", "digitaladmin", "2022-01-30 14:40:22", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6641", "1", "digitaladmin", "2022-01-30 14:40:23", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6642", "1", "digitaladmin", "2022-01-30 14:40:24", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6643", "1", "digitaladmin", "2022-01-30 14:40:25", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6644", "1", "digitaladmin", "2022-01-30 14:40:26", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6645", "1", "digitaladmin", "2022-01-30 14:40:28", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6646", "1", "digitaladmin", "2022-01-30 14:40:29", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6647", "1", "digitaladmin", "2022-01-30 14:40:30", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6648", "1", "digitaladmin", "2022-01-30 14:40:31", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6649", "1", "digitaladmin", "2022-01-30 14:40:32", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6650", "1", "digitaladmin", "2022-01-30 14:40:33", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6651", "1", "digitaladmin", "2022-01-30 14:40:34", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6652", "1", "digitaladmin", "2022-01-30 14:40:35", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6653", "1", "digitaladmin", "2022-01-30 14:40:36", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6654", "1", "digitaladmin", "2022-01-30 14:40:37", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6655", "1", "digitaladmin", "2022-01-30 14:40:39", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6656", "1", "digitaladmin", "2022-01-30 14:40:40", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6657", "1", "digitaladmin", "2022-01-30 14:40:41", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6658", "1", "digitaladmin", "2022-01-30 14:40:42", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6659", "1", "digitaladmin", "2022-01-30 14:40:43", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6660", "1", "digitaladmin", "2022-01-30 14:40:44", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6661", "1", "digitaladmin", "2022-01-30 14:40:45", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6662", "1", "digitaladmin", "2022-01-30 14:40:46", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6663", "1", "digitaladmin", "2022-01-30 16:56:48", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6664", "1", "digitaladmin", "2022-01-30 16:56:49", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6665", "1", "digitaladmin", "2022-01-30 16:56:51", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6666", "1", "digitaladmin", "2022-01-30 16:56:52", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6667", "1", "digitaladmin", "2022-01-30 16:56:53", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6668", "1", "digitaladmin", "2022-01-30 16:56:55", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6669", "1", "digitaladmin", "2022-01-30 16:56:56", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6670", "1", "digitaladmin", "2022-01-30 16:56:58", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6671", "1", "digitaladmin", "2022-01-30 16:56:59", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6672", "1", "digitaladmin", "2022-01-30 16:57:00", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6673", "1", "digitaladmin", "2022-01-30 16:57:02", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6674", "1", "digitaladmin", "2022-01-30 16:57:03", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6675", "1", "digitaladmin", "2022-01-30 16:57:05", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6676", "1", "digitaladmin", "2022-01-30 16:57:06", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6677", "1", "digitaladmin", "2022-01-30 16:57:08", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6678", "1", "digitaladmin", "2022-01-30 16:57:09", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6679", "1", "digitaladmin", "2022-01-30 16:57:10", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6680", "1", "digitaladmin", "2022-01-30 16:57:12", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6681", "1", "digitaladmin", "2022-01-30 16:57:13", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6682", "1", "digitaladmin", "2022-01-30 16:57:14", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6683", "1", "digitaladmin", "2022-01-30 16:57:16", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6684", "1", "digitaladmin", "2022-01-30 16:57:17", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6685", "1", "digitaladmin", "2022-01-30 16:57:18", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6686", "1", "digitaladmin", "2022-01-30 16:57:20", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6687", "1", "digitaladmin", "2022-01-30 16:57:21", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6688", "1", "digitaladmin", "2022-01-30 16:57:23", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6689", "1", "digitaladmin", "2022-01-30 16:57:24", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6690", "1", "digitaladmin", "2022-01-30 16:57:25", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6691", "1", "digitaladmin", "2022-01-30 16:57:27", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6692", "1", "digitaladmin", "2022-01-30 16:57:28", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6693", "1", "digitaladmin", "2022-01-30 16:57:29", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6694", "1", "digitaladmin", "2022-01-30 16:57:31", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6695", "1", "digitaladmin", "2022-01-30 16:57:32", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6696", "1", "digitaladmin", "2022-01-30 16:57:33", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6697", "1", "digitaladmin", "2022-01-30 16:57:35", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6698", "1", "digitaladmin", "2022-01-30 16:57:36", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6699", "1", "digitaladmin", "2022-01-30 16:57:38", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6700", "1", "digitaladmin", "2022-01-30 16:57:39", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6701", "1", "digitaladmin", "2022-01-30 16:57:40", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6702", "1", "digitaladmin", "2022-01-30 16:57:42", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6703", "1", "digitaladmin", "2022-01-30 16:57:43", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6704", "1", "digitaladmin", "2022-01-30 16:57:44", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6705", "1", "digitaladmin", "2022-01-30 16:57:46", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6706", "1", "digitaladmin", "2022-01-30 16:57:47", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6707", "1", "digitaladmin", "2022-01-30 16:57:49", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6708", "1", "digitaladmin", "2022-01-30 16:57:50", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6709", "1", "digitaladmin", "2022-01-30 16:57:51", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6710", "1", "digitaladmin", "2022-01-30 16:57:53", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6711", "1", "digitaladmin", "2022-01-30 16:57:54", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6712", "1", "digitaladmin", "2022-01-30 16:57:55", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6713", "1", "digitaladmin", "2022-01-30 16:57:57", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6714", "1", "digitaladmin", "2022-01-30 16:57:58", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6715", "1", "digitaladmin", "2022-01-30 16:57:59", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6716", "1", "digitaladmin", "2022-01-30 16:58:01", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6717", "1", "digitaladmin", "2022-01-30 16:58:02", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6718", "1", "digitaladmin", "2022-01-30 16:58:03", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6719", "1", "digitaladmin", "2022-01-30 16:58:04", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6720", "1", "digitaladmin", "2022-01-30 16:58:05", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6721", "1", "digitaladmin", "2022-01-30 16:58:06", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6722", "1", "digitaladmin", "2022-01-30 16:58:07", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6723", "1", "digitaladmin", "2022-01-30 16:58:08", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6724", "1", "digitaladmin", "2022-01-30 16:58:10", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6725", "1", "digitaladmin", "2022-01-30 16:58:11", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6726", "1", "digitaladmin", "2022-01-30 16:58:12", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6727", "1", "digitaladmin", "2022-01-30 16:58:13", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6728", "1", "digitaladmin", "2022-01-30 16:58:14", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6729", "1", "digitaladmin", "2022-01-30 16:58:15", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6730", "1", "digitaladmin", "2022-01-30 16:58:16", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6731", "1", "digitaladmin", "2022-01-30 16:58:17", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6732", "1", "digitaladmin", "2022-01-30 16:58:18", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6733", "1", "digitaladmin", "2022-01-30 16:58:19", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6734", "1", "digitaladmin", "2022-01-30 16:58:20", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6735", "1", "digitaladmin", "2022-01-30 16:58:22", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6736", "1", "digitaladmin", "2022-01-30 16:58:23", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6737", "1", "digitaladmin", "2022-01-30 16:58:24", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6738", "1", "digitaladmin", "2022-01-30 16:58:25", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6739", "1", "digitaladmin", "2022-01-30 16:58:26", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6740", "1", "digitaladmin", "2022-01-30 16:58:27", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6741", "1", "digitaladmin", "2022-01-30 16:58:28", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6742", "1", "digitaladmin", "2022-01-30 16:58:29", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6743", "1", "digitaladmin", "2022-01-30 16:58:30", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6744", "1", "digitaladmin", "2022-01-30 16:58:31", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6745", "1", "digitaladmin", "2022-01-30 16:58:32", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6746", "1", "digitaladmin", "2022-01-30 16:58:33", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6747", "1", "digitaladmin", "2022-01-30 16:58:35", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6748", "1", "digitaladmin", "2022-01-30 16:58:36", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6749", "1", "digitaladmin", "2022-01-30 16:58:37", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6750", "1", "digitaladmin", "2022-01-30 16:58:38", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6751", "1", "digitaladmin", "2022-01-30 16:58:39", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6752", "1", "digitaladmin", "2022-01-30 16:58:40", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6753", "1", "digitaladmin", "2022-01-30 16:58:41", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6754", "1", "digitaladmin", "2022-01-30 16:58:42", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6755", "1", "digitaladmin", "2022-01-30 16:58:43", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6756", "1", "digitaladmin", "2022-01-30 16:58:44", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6757", "1", "digitaladmin", "2022-01-30 16:58:45", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6758", "1", "digitaladmin", "2022-01-30 16:58:46", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6759", "1", "digitaladmin", "2022-01-30 16:58:47", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6760", "1", "digitaladmin", "2022-01-30 16:58:49", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6761", "1", "digitaladmin", "2022-01-30 16:58:50", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6762", "1", "digitaladmin", "2022-01-30 16:58:51", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6763", "1", "digitaladmin", "2022-01-30 16:58:52", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6764", "1", "digitaladmin", "2022-01-30 16:58:53", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6765", "1", "digitaladmin", "2022-01-30 16:58:54", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6766", "1", "digitaladmin", "2022-01-30 16:58:55", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6767", "1", "digitaladmin", "2022-01-30 16:58:56", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6768", "1", "digitaladmin", "2022-01-30 16:58:57", "167.172.225.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6769", "0", "admin", "2022-02-01 08:46:39", "164.68.110.108");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6770", "0", "admin", "2022-02-01 09:28:35", "109.234.161.233");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6771", "1", "digitaladmin", "2022-02-01 10:55:58", "62.28.191.2");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6772", "1", "digitaladmin", "2022-02-01 11:42:07", "151.80.20.26");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6773", "1", "digitaladmin", "2022-02-01 12:27:20", "213.149.103.132");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6774", "1", "digitaladmin", "2022-02-01 13:11:48", "108.167.150.194");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6775", "1", "digitaladmin", "2022-02-01 13:48:12", "173.201.191.223");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6776", "1", "digitaladmin", "2022-02-01 13:58:16", "148.72.211.177");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6777", "1", "digitaladmin", "2022-02-01 14:05:20", "54.39.49.75");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6778", "1", "digitaladmin", "2022-02-01 14:11:09", "31.177.95.75");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6779", "1", "digitaladmin", "2022-02-01 14:16:36", "167.172.56.36");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6780", "1", "digitaladmin", "2022-02-01 14:21:01", "167.71.63.47");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6781", "1", "digitaladmin", "2022-02-01 14:25:19", "103.109.30.30");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6782", "1", "digitaladmin", "2022-02-01 14:32:35", "184.168.101.89");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6783", "1", "digitaladmin", "2022-02-01 14:37:23", "51.75.15.189");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6784", "1", "digitaladmin", "2022-02-01 14:40:30", "208.109.28.66");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6785", "1", "digitaladmin", "2022-02-01 14:43:59", "173.201.176.23");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6786", "0", "admin", "2022-02-01 14:47:26", "139.59.33.202");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6787", "0", "admin", "2022-02-01 14:50:45", "167.71.216.37");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6788", "0", "admin", "2022-02-01 14:54:06", "162.144.78.149");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6789", "0", "admin", "2022-02-01 14:57:24", "198.12.149.182");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6790", "0", "admin", "2022-02-01 15:00:31", "167.71.206.107");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6791", "0", "admin", "2022-02-01 15:03:45", "184.168.115.128");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6792", "0", "admin", "2022-02-01 15:06:56", "72.167.65.82");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6793", "0", "admin", "2022-02-01 15:10:25", "194.163.147.193");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6794", "0", "admin", "2022-02-01 15:13:08", "199.188.201.3");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6795", "0", "admin", "2022-02-01 15:16:36", "35.225.94.95");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6796", "0", "admin", "2022-02-01 15:22:30", "167.86.105.202");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6797", "0", "admin", "2022-02-01 15:25:06", "208.109.23.65");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6798", "0", "admin", "2022-02-01 15:27:58", "184.168.112.225");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6799", "0", "admin", "2022-02-01 15:31:00", "64.227.0.234");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6800", "0", "admin", "2022-02-01 15:33:57", "34.68.97.70");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6801", "0", "admin", "2022-02-01 15:36:35", "176.53.65.237");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6802", "0", "admin", "2022-02-01 15:38:47", "184.168.100.242");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6803", "0", "admin", "2022-02-01 15:41:21", "50.59.99.143");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6804", "0", "admin", "2022-02-01 15:43:55", "116.255.173.135");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6805", "0", "admin", "2022-02-01 15:46:29", "49.176.154.190");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6806", "0", "admin", "2022-02-01 15:51:23", "184.168.99.48");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6807", "0", "admin", "2022-02-01 15:54:22", "137.74.93.154");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6808", "0", "admin", "2022-02-01 15:58:53", "167.99.78.164");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6809", "0", "admin", "2022-02-01 16:01:40", "92.205.10.70");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6810", "0", "admin", "2022-02-01 16:03:48", "68.65.120.215");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6811", "0", "admin", "2022-02-01 16:06:22", "173.201.178.72");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6812", "0", "admin", "2022-02-01 16:09:16", "95.111.235.116");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6813", "0", "admin", "2022-02-01 16:11:16", "184.168.98.160");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6814", "0", "admin", "2022-02-01 16:14:16", "185.141.107.10");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6815", "0", "admin", "2022-02-01 16:16:06", "148.72.197.134");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6816", "0", "admin", "2022-02-01 16:18:30", "209.145.52.234");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6817", "0", "admin", "2022-02-01 16:20:51", "72.167.124.218");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6818", "0", "admin", "2022-02-01 16:23:35", "139.99.46.226");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6819", "0", "admin", "2022-02-01 16:25:36", "81.70.151.13");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6820", "0", "admin", "2022-02-01 16:28:00", "139.59.153.133");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6821", "0", "admin", "2022-02-01 16:30:34", "107.161.177.10");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6822", "0", "admin", "2022-02-01 16:32:48", "47.74.17.225");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6823", "0", "admin", "2022-02-01 16:35:15", "107.173.165.214");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6824", "0", "admin", "2022-02-01 16:37:47", "185.61.153.77");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6825", "0", "admin", "2022-02-01 16:40:43", "144.76.103.36");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6826", "1", "digitaladmin", "2022-02-01 16:42:47", "92.205.0.94");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6827", "1", "digitaladmin", "2022-02-01 16:45:25", "107.180.124.4");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6828", "1", "digitaladmin", "2022-02-01 16:47:39", "101.0.97.134");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6829", "1", "digitaladmin", "2022-02-01 16:50:43", "93.113.111.193");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6830", "1", "digitaladmin", "2022-02-01 16:52:53", "184.168.103.26");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6831", "1", "digitaladmin", "2022-02-01 16:55:28", "101.0.81.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6832", "1", "digitaladmin", "2022-02-01 16:58:10", "8.131.62.110");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6833", "1", "digitaladmin", "2022-02-01 17:00:46", "104.131.18.212");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6834", "1", "digitaladmin", "2022-02-01 17:03:29", "184.168.102.151");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6835", "1", "digitaladmin", "2022-02-01 17:06:17", "68.183.192.217");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6836", "1", "digitaladmin", "2022-02-01 17:09:11", "92.204.217.252");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6837", "1", "digitaladmin", "2022-02-01 17:12:05", "35.193.222.165");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6838", "1", "digitaladmin", "2022-02-01 17:14:49", "185.254.237.119");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6839", "1", "digitaladmin", "2022-02-01 17:17:19", "47.107.33.26");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6840", "1", "digitaladmin", "2022-02-01 17:20:02", "184.168.100.57");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6841", "1", "digitaladmin", "2022-02-01 17:22:43", "132.148.224.56");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6842", "1", "digitaladmin", "2022-02-01 17:25:28", "20.76.142.69");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6843", "1", "digitaladmin", "2022-02-01 17:28:18", "72.167.69.40");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6844", "1", "digitaladmin", "2022-02-01 17:34:31", "93.114.234.242");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6845", "1", "digitaladmin", "2022-02-01 17:37:27", "35.211.94.153");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6846", "1", "digitaladmin", "2022-02-01 17:40:48", "89.44.138.250");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6847", "1", "digitaladmin", "2022-02-01 17:43:25", "167.71.193.214");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6848", "1", "digitaladmin", "2022-02-01 17:46:46", "92.205.10.70");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6849", "1", "digitaladmin", "2022-02-01 17:49:34", "34.123.125.44");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6850", "1", "digitaladmin", "2022-02-01 17:55:44", "35.203.155.125");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6851", "1", "digitaladmin", "2022-02-01 17:59:01", "120.24.108.217");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6852", "1", "digitaladmin", "2022-02-01 18:02:16", "173.201.183.5");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6853", "1", "digitaladmin", "2022-02-01 18:05:28", "103.90.232.106");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6854", "1", "digitaladmin", "2022-02-01 18:09:01", "50.59.99.143");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6855", "1", "digitaladmin", "2022-02-01 18:12:15", "157.245.240.102");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6856", "1", "digitaladmin", "2022-02-01 18:15:53", "198.46.141.138");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6857", "1", "digitaladmin", "2022-02-01 18:18:45", "198.12.211.168");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6858", "1", "digitaladmin", "2022-02-01 18:22:21", "110.42.175.115");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6859", "1", "digitaladmin", "2022-02-01 18:25:51", "192.163.197.220");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6860", "1", "digitaladmin", "2022-02-01 18:29:25", "72.167.225.151");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6861", "1", "digitaladmin", "2022-02-01 18:33:42", "142.93.99.56");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6862", "1", "digitaladmin", "2022-02-01 18:37:27", "159.253.25.213");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6863", "1", "digitaladmin", "2022-02-01 18:40:43", "72.167.64.243");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6864", "1", "digitaladmin", "2022-02-01 18:45:18", "95.128.46.215");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6865", "1", "digitaladmin", "2022-02-01 18:49:09", "91.205.175.35");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6866", "0", "admin", "2022-02-01 19:27:16", "184.168.102.151");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6867", "0", "admin", "2022-02-01 19:30:10", "92.204.223.87");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6868", "1", "digitaladmin", "2022-02-01 19:32:30", "132.148.47.21");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6869", "1", "digitaladmin", "2022-02-01 19:34:45", "173.201.183.100");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6870", "1", "digitaladmin", "2022-02-01 19:37:18", "122.17.148.164");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6871", "1", "digitaladmin", "2022-02-01 19:40:09", "92.204.220.54");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6872", "1", "digitaladmin", "2022-02-01 19:42:49", "173.212.214.140");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6873", "1", "digitaladmin", "2022-02-01 19:45:04", "184.168.115.59");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6874", "1", "digitaladmin", "2022-02-01 19:47:35", "184.168.115.128");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6875", "1", "digitaladmin", "2022-02-01 19:50:34", "139.59.136.209");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6876", "1", "digitaladmin", "2022-02-01 19:53:04", "50.59.99.143");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6877", "1", "digitaladmin", "2022-02-01 19:55:50", "91.98.100.196");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6878", "1", "digitaladmin", "2022-02-01 19:58:01", "35.221.181.187");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6879", "1", "digitaladmin", "2022-02-01 20:01:02", "5.189.138.128");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6880", "1", "digitaladmin", "2022-02-01 20:03:24", "50.62.137.47");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6881", "1", "digitaladmin", "2022-02-01 20:06:37", "92.204.218.140");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6882", "1", "digitaladmin", "2022-02-01 20:09:21", "167.71.63.47");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6883", "1", "digitaladmin", "2022-02-01 20:12:17", "190.92.152.62");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6884", "1", "digitaladmin", "2022-02-01 20:14:47", "184.168.116.113");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6885", "1", "digitaladmin", "2022-02-01 20:18:15", "81.88.52.223");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6886", "1", "digitaladmin", "2022-02-01 20:20:43", "159.203.28.44");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6887", "1", "digitaladmin", "2022-02-01 20:24:14", "185.190.39.66");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6888", "1", "digitaladmin", "2022-02-01 20:26:37", "184.168.114.187");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6889", "1", "digitaladmin", "2022-02-01 20:30:05", "151.80.20.26");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6890", "1", "digitaladmin", "2022-02-01 20:32:26", "39.100.124.237");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6891", "1", "digitaladmin", "2022-02-01 20:35:31", "151.106.112.245");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6892", "1", "digitaladmin", "2022-02-01 20:38:20", "185.61.154.35");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6893", "1", "digitaladmin", "2022-02-01 20:41:29", "103.159.84.77");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6894", "1", "digitaladmin", "2022-02-01 20:44:30", "74.208.103.228");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6895", "1", "digitaladmin", "2022-02-01 20:47:52", "23.226.120.90");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6896", "1", "digitaladmin", "2022-02-01 20:51:20", "194.163.170.232");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6897", "1", "digitaladmin", "2022-02-01 20:54:31", "64.225.69.194");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6898", "1", "digitaladmin", "2022-02-01 20:57:08", "103.3.246.217");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6899", "1", "digitaladmin", "2022-02-01 21:04:09", "92.205.5.130");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6900", "1", "digitaladmin", "2022-02-01 21:07:36", "92.243.15.140");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6901", "1", "digitaladmin", "2022-02-01 21:11:03", "46.101.103.136");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6902", "1", "digitaladmin", "2022-02-01 21:14:30", "164.68.99.251");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6903", "1", "digitaladmin", "2022-02-01 21:17:37", "103.171.180.203");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6904", "1", "digitaladmin", "2022-02-01 21:21:03", "103.121.91.38");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6905", "1", "digitaladmin", "2022-02-01 21:24:38", "101.0.97.134");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6906", "1", "digitaladmin", "2022-02-01 21:32:24", "185.86.77.163");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6907", "1", "digitaladmin", "2022-02-01 21:35:49", "50.59.99.143");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6908", "1", "digitaladmin", "2022-02-01 21:39:11", "92.205.14.36");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6909", "1", "digitaladmin", "2022-02-01 21:42:49", "199.195.254.132");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6910", "1", "digitaladmin", "2022-02-01 21:46:19", "46.101.95.65");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6911", "1", "digitaladmin", "2022-02-01 21:50:04", "62.171.152.171");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6912", "1", "digitaladmin", "2022-02-01 21:53:19", "167.71.111.16");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6913", "1", "digitaladmin", "2022-02-01 21:57:05", "50.62.137.47");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6914", "1", "digitaladmin", "2022-02-01 22:00:52", "107.180.124.4");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6915", "1", "digitaladmin", "2022-02-01 22:05:01", "209.145.52.234");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6916", "1", "digitaladmin", "2022-02-01 22:08:55", "143.110.157.74");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6917", "1", "digitaladmin", "2022-02-01 22:13:01", "103.121.91.38");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6918", "1", "digitaladmin", "2022-02-01 22:16:58", "144.126.134.44");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6919", "1", "digitaladmin", "2022-02-01 22:25:37", "93.113.110.240");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6920", "1", "digitaladmin", "2022-02-01 22:29:08", "173.201.185.124");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6921", "1", "digitaladmin", "2022-02-01 22:33:23", "130.185.78.76");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6922", "1", "digitaladmin", "2022-02-01 22:37:45", "184.168.102.96");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6923", "1", "digitaladmin", "2022-02-01 22:42:12", "184.168.98.87");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6924", "0", "admin", "2022-02-01 22:57:37", "198.54.120.17");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6925", "0", "admin", "2022-02-01 23:01:10", "142.93.170.99");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6926", "1", "digitaladmin", "2022-02-01 23:03:56", "162.144.78.149");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6927", "1", "digitaladmin", "2022-02-01 23:07:14", "47.243.59.107");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6928", "1", "digitaladmin", "2022-02-01 23:11:12", "93.104.213.124");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6929", "1", "digitaladmin", "2022-02-01 23:14:20", "209.159.150.110");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6930", "1", "digitaladmin", "2022-02-01 23:17:23", "185.61.152.8");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6931", "1", "digitaladmin", "2022-02-01 23:20:43", "185.137.168.149");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6932", "1", "digitaladmin", "2022-02-01 23:24:34", "35.211.94.153");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6933", "1", "digitaladmin", "2022-02-01 23:28:13", "64.235.231.20");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6934", "1", "digitaladmin", "2022-02-01 23:31:15", "206.81.16.252");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6935", "1", "digitaladmin", "2022-02-01 23:34:35", "45.119.84.149");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6936", "1", "digitaladmin", "2022-02-01 23:38:44", "185.49.20.77");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6937", "1", "digitaladmin", "2022-02-01 23:41:46", "132.148.224.56");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6938", "1", "digitaladmin", "2022-02-01 23:45:21", "74.208.103.228");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6939", "1", "digitaladmin", "2022-02-01 23:49:05", "51.81.245.120");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6940", "1", "digitaladmin", "2022-02-01 23:53:17", "51.91.123.235");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6941", "1", "digitaladmin", "2022-02-01 23:56:34", "104.160.43.196");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6942", "1", "digitaladmin", "2022-02-02 00:00:22", "97.79.236.218");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6943", "1", "digitaladmin", "2022-02-02 00:04:35", "107.161.177.10");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6944", "1", "digitaladmin", "2022-02-02 00:07:55", "184.168.100.242");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6945", "1", "digitaladmin", "2022-02-02 00:11:36", "184.168.98.94");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6946", "1", "digitaladmin", "2022-02-02 00:15:46", "37.187.26.195");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6947", "1", "digitaladmin", "2022-02-02 00:19:26", "92.205.5.130");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6948", "1", "digitaladmin", "2022-02-02 00:22:51", "103.3.164.91");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6949", "1", "digitaladmin", "2022-02-02 00:27:06", "109.234.161.67");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6950", "1", "digitaladmin", "2022-02-02 00:30:34", "107.180.88.41");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6951", "1", "digitaladmin", "2022-02-02 00:34:54", "213.175.208.121");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6952", "1", "digitaladmin", "2022-02-02 00:42:32", "172.105.234.191");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6953", "1", "digitaladmin", "2022-02-02 00:46:31", "68.65.122.149");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6954", "1", "digitaladmin", "2022-02-02 00:50:41", "184.168.119.95");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6955", "1", "digitaladmin", "2022-02-02 00:55:06", "75.119.141.150");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6956", "1", "digitaladmin", "2022-02-02 00:58:47", "72.167.104.77");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6957", "1", "digitaladmin", "2022-02-02 01:03:34", "185.84.108.11");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6958", "1", "digitaladmin", "2022-02-02 01:08:02", "52.183.137.156");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6959", "1", "digitaladmin", "2022-02-02 01:12:04", "216.245.215.122");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6960", "1", "digitaladmin", "2022-02-02 01:16:44", "144.126.134.44");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6961", "1", "digitaladmin", "2022-02-02 01:21:22", "103.159.50.183");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6962", "1", "digitaladmin", "2022-02-02 01:26:06", "66.23.252.226");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6963", "1", "digitaladmin", "2022-02-02 01:31:19", "86.57.254.101");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6964", "1", "digitaladmin", "2022-02-02 01:36:05", "72.167.42.45");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6965", "1", "digitaladmin", "2022-02-02 01:41:52", "177.55.118.235");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6966", "1", "digitaladmin", "2022-02-02 01:46:59", "194.163.170.232");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6967", "1", "digitaladmin", "2022-02-02 01:52:23", "94.130.219.217");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6968", "1", "digitaladmin", "2022-02-02 02:02:46", "66.23.252.226");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6969", "1", "digitaladmin", "2022-02-02 02:08:35", "80.251.219.111");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6970", "1", "digitaladmin", "2022-02-02 02:14:16", "184.168.116.210");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6971", "1", "digitaladmin", "2022-02-02 02:25:48", "184.168.114.187");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6972", "1", "digitaladmin", "2022-02-02 02:31:47", "88.208.209.101");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6973", "1", "digitaladmin", "2022-02-02 02:37:44", "51.91.123.235");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6974", "1", "digitaladmin", "2022-02-02 02:43:17", "62.28.184.124");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6975", "1", "digitaladmin", "2022-02-02 02:48:30", "185.255.89.65");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6976", "1", "digitaladmin", "2022-02-02 02:54:26", "164.68.99.251");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6977", "1", "digitaladmin", "2022-02-02 03:00:19", "116.255.173.135");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6978", "1", "digitaladmin", "2022-02-02 03:06:19", "85.119.122.23");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6979", "1", "digitaladmin", "2022-02-02 03:11:42", "64.227.78.130");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6980", "1", "digitaladmin", "2022-02-02 03:17:21", "95.167.178.158");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6981", "1", "digitaladmin", "2022-02-02 03:23:25", "103.104.73.82");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6982", "0", "admin", "2022-02-02 03:29:22", "217.160.131.45");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6983", "0", "admin", "2022-02-02 03:34:27", "144.217.12.17");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6984", "1", "digitaladmin", "2022-02-02 03:40:00", "85.119.122.23");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6985", "1", "digitaladmin", "2022-02-02 03:44:45", "162.241.174.216");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6986", "1", "digitaladmin", "2022-02-02 03:50:53", "164.68.110.108");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6987", "1", "digitaladmin", "2022-02-02 03:55:49", "115.159.148.91");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6988", "1", "digitaladmin", "2022-02-02 04:02:11", "93.113.111.34");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6989", "1", "digitaladmin", "2022-02-02 04:08:38", "103.74.118.242");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6990", "1", "digitaladmin", "2022-02-02 04:14:35", "107.161.177.10");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6991", "1", "digitaladmin", "2022-02-02 04:20:22", "167.99.78.164");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6992", "1", "digitaladmin", "2022-02-02 04:26:17", "185.146.20.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6993", "1", "digitaladmin", "2022-02-02 04:31:52", "37.187.26.195");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6994", "1", "digitaladmin", "2022-02-02 04:36:59", "185.61.152.8");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6995", "1", "digitaladmin", "2022-02-02 04:42:38", "103.233.2.147");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6996", "1", "digitaladmin", "2022-02-02 04:54:31", "109.234.161.233");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6997", "1", "digitaladmin", "2022-02-02 04:59:29", "23.226.120.90");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6998", "1", "digitaladmin", "2022-02-02 05:05:04", "185.106.130.251");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("6999", "1", "digitaladmin", "2022-02-02 05:10:47", "185.146.20.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7000", "1", "digitaladmin", "2022-02-02 05:21:45", "103.109.30.30");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7001", "1", "digitaladmin", "2022-02-02 05:51:50", "173.212.235.115");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7002", "1", "digitaladmin", "2022-02-02 06:27:25", "167.86.74.70");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7003", "1", "digitaladmin", "2022-02-02 06:39:18", "138.197.12.140");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7004", "1", "digitaladmin", "2022-02-02 06:51:08", "178.217.190.82");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7005", "1", "digitaladmin", "2022-02-02 07:02:58", "110.4.40.183");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7006", "1", "digitaladmin", "2022-02-02 07:14:51", "52.166.3.59");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7007", "1", "digitaladmin", "2022-02-02 07:26:34", "103.121.89.72");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7008", "1", "digitaladmin", "2022-02-02 08:01:14", "173.212.212.180");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7009", "1", "digitaladmin", "2022-02-02 08:12:55", "13.81.59.92");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7010", "1", "digitaladmin", "2022-02-02 08:24:50", "162.144.63.211");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7011", "1", "digitaladmin", "2022-02-02 08:36:42", "138.68.248.47");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7012", "1", "digitaladmin", "2022-02-02 08:48:32", "84.112.89.42");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7013", "1", "digitaladmin", "2022-02-02 09:00:09", "51.77.223.41");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7014", "1", "digitaladmin", "2022-02-02 09:23:22", "148.72.214.245");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7015", "1", "digitaladmin", "2022-02-02 09:35:04", "2.59.117.55");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7016", "1", "digitaladmin", "2022-02-02 09:58:34", "138.68.248.47");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7017", "1", "digitaladmin", "2022-02-02 10:10:21", "185.2.5.25");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7018", "1", "digitaladmin", "2022-02-02 10:22:17", "52.70.81.167");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7019", "1", "digitaladmin", "2022-02-02 10:34:03", "138.68.180.112");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7020", "1", "digitaladmin", "2022-02-02 10:45:47", "185.49.20.77");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7021", "1", "digitaladmin", "2022-02-02 11:09:36", "159.89.27.131");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7022", "1", "digitaladmin", "2022-02-02 11:21:22", "34.92.58.160");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7023", "1", "digitaladmin", "2022-02-02 11:45:12", "157.245.110.251");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7024", "1", "digitaladmin", "2022-02-02 11:57:02", "34.122.210.151");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7025", "1", "digitaladmin", "2022-02-02 12:08:55", "195.67.74.174");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7026", "1", "digitaladmin", "2022-02-02 12:20:46", "185.50.199.194");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7027", "1", "digitaladmin", "2022-02-02 12:32:31", "155.94.163.77");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7028", "1", "digitaladmin", "2022-02-02 12:44:16", "81.88.52.114");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7029", "1", "digitaladmin", "2022-02-02 12:56:08", "143.244.184.195");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7030", "1", "digitaladmin", "2022-02-02 13:07:55", "103.121.89.72");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7031", "1", "digitaladmin", "2022-02-02 13:19:43", "93.113.110.104");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7032", "1", "digitaladmin", "2022-02-02 13:31:35", "138.68.180.112");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7033", "1", "digitaladmin", "2022-02-02 13:43:19", "72.167.34.14");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7034", "1", "digitaladmin", "2022-02-02 14:07:01", "92.53.123.166");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7035", "1", "digitaladmin", "2022-02-02 14:18:59", "138.201.36.60");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7036", "1", "digitaladmin", "2022-02-02 14:43:03", "138.68.140.0");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7037", "1", "digitaladmin", "2022-02-02 14:54:49", "101.32.178.221");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7038", "1", "digitaladmin", "2022-02-02 15:18:43", "162.214.190.209");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7039", "1", "digitaladmin", "2022-02-02 15:30:44", "46.160.121.111");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7040", "1", "digitaladmin", "2022-02-02 15:42:43", "162.144.63.211");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7041", "1", "digitaladmin", "2022-02-02 15:54:38", "188.166.1.143");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7042", "1", "digitaladmin", "2022-02-02 16:06:42", "85.187.158.113");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7043", "1", "digitaladmin", "2022-02-02 16:18:47", "66.11.120.48");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7044", "1", "digitaladmin", "2022-02-02 16:42:52", "104.236.126.239");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7045", "1", "digitaladmin", "2022-02-02 17:06:11", "210.211.116.118");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7046", "0", "admin", "2022-02-06 08:28:06", "8.210.146.161");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7047", "0", "admin", "2022-02-06 08:31:48", "92.205.6.232");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7048", "1", "digitaladmin", "2022-02-06 08:35:38", "184.168.116.232");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7049", "1", "digitaladmin", "2022-02-06 08:39:34", "213.149.103.132");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7050", "1", "digitaladmin", "2022-02-06 08:43:33", "92.205.3.251");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7051", "1", "digitaladmin", "2022-02-06 08:47:22", "207.55.255.20");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7052", "1", "digitaladmin", "2022-02-06 08:51:09", "173.201.177.4");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7053", "1", "digitaladmin", "2022-02-06 08:55:15", "101.37.28.132");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7054", "1", "digitaladmin", "2022-02-06 08:59:19", "35.247.159.133");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7055", "1", "digitaladmin", "2022-02-06 09:04:17", "208.109.16.231");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7056", "1", "digitaladmin", "2022-02-06 09:09:06", "27.111.82.74");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7057", "1", "digitaladmin", "2022-02-06 09:14:16", "189.125.37.42");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7058", "1", "digitaladmin", "2022-02-06 09:19:22", "184.168.116.203");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7059", "1", "digitaladmin", "2022-02-06 09:24:23", "162.214.145.74");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7060", "1", "digitaladmin", "2022-02-06 09:28:58", "142.4.4.131");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7061", "1", "digitaladmin", "2022-02-06 09:33:31", "92.205.3.203");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7062", "1", "digitaladmin", "2022-02-06 09:38:08", "184.168.115.128");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7063", "1", "digitaladmin", "2022-02-06 09:43:08", "103.153.68.244");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7064", "1", "digitaladmin", "2022-02-06 09:47:33", "39.103.157.70");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7065", "1", "digitaladmin", "2022-02-06 09:52:12", "34.123.125.44");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7066", "1", "digitaladmin", "2022-02-06 09:56:35", "159.203.31.171");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7067", "1", "digitaladmin", "2022-02-06 10:01:52", "208.109.68.1");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7068", "1", "digitaladmin", "2022-02-06 10:06:30", "35.189.23.248");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7069", "1", "digitaladmin", "2022-02-06 10:11:44", "104.236.126.239");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7070", "1", "digitaladmin", "2022-02-06 10:17:37", "8.141.58.239");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7071", "1", "digitaladmin", "2022-02-06 10:22:27", "184.168.115.128");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7072", "1", "digitaladmin", "2022-02-06 10:27:29", "139.162.112.41");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7073", "1", "digitaladmin", "2022-02-06 10:32:48", "109.234.161.233");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7074", "1", "digitaladmin", "2022-02-06 10:37:45", "103.50.76.37");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7075", "1", "digitaladmin", "2022-02-06 10:42:35", "173.201.178.226");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7076", "1", "digitaladmin", "2022-02-06 10:48:00", "94.23.211.205");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7077", "1", "digitaladmin", "2022-02-06 10:52:22", "43.129.212.158");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7078", "1", "digitaladmin", "2022-02-06 10:57:21", "101.32.26.66");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7079", "1", "digitaladmin", "2022-02-06 11:02:54", "46.101.95.65");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7080", "1", "digitaladmin", "2022-02-06 11:07:44", "94.130.219.217");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7081", "1", "digitaladmin", "2022-02-06 11:12:56", "190.92.152.62");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7082", "1", "digitaladmin", "2022-02-06 11:18:07", "66.115.173.18");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7083", "1", "digitaladmin", "2022-02-06 11:22:48", "64.227.78.130");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7084", "1", "digitaladmin", "2022-02-06 11:28:07", "186.234.80.77");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7085", "1", "digitaladmin", "2022-02-06 11:32:37", "175.24.121.59");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7086", "1", "digitaladmin", "2022-02-06 11:37:22", "47.104.66.61");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7087", "1", "digitaladmin", "2022-02-06 11:42:31", "173.201.185.124");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7088", "1", "digitaladmin", "2022-02-06 11:52:37", "94.23.211.205");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7089", "1", "digitaladmin", "2022-02-06 11:57:46", "185.162.147.26");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7090", "1", "digitaladmin", "2022-02-06 12:02:51", "103.3.164.91");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7091", "1", "digitaladmin", "2022-02-06 12:08:03", "92.205.3.54");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7092", "1", "digitaladmin", "2022-02-06 12:12:45", "49.176.154.190");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7093", "1", "digitaladmin", "2022-02-06 12:18:28", "93.104.213.124");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7094", "1", "digitaladmin", "2022-02-06 12:23:05", "185.3.235.238");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7095", "1", "digitaladmin", "2022-02-06 12:28:53", "164.68.110.108");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7096", "1", "digitaladmin", "2022-02-06 12:33:14", "125.227.127.195");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7097", "1", "digitaladmin", "2022-02-06 12:38:42", "72.167.225.151");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7098", "1", "digitaladmin", "2022-02-06 12:44:03", "34.123.125.44");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7099", "1", "digitaladmin", "2022-02-06 12:49:07", "162.144.78.149");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7100", "1", "digitaladmin", "2022-02-06 12:54:11", "184.168.112.180");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7101", "1", "digitaladmin", "2022-02-06 12:59:08", "77.68.16.200");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7102", "1", "digitaladmin", "2022-02-06 13:04:46", "184.168.115.59");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7103", "1", "digitaladmin", "2022-02-06 13:09:48", "35.189.23.248");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7104", "1", "digitaladmin", "2022-02-06 13:15:05", "39.106.105.38");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7105", "1", "digitaladmin", "2022-02-06 13:20:26", "101.0.97.134");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7106", "0", "admin", "2022-02-06 13:27:42", "185.254.237.119");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7107", "1", "digitaladmin", "2022-02-06 13:37:57", "185.137.168.149");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7108", "1", "digitaladmin", "2022-02-06 13:43:46", "95.167.178.158");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7109", "1", "digitaladmin", "2022-02-06 13:48:09", "104.131.18.212");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7110", "1", "digitaladmin", "2022-02-06 13:52:47", "72.167.69.35");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7111", "1", "digitaladmin", "2022-02-06 13:56:23", "159.65.219.142");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7112", "1", "digitaladmin", "2022-02-06 14:00:19", "159.75.100.193");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7113", "1", "digitaladmin", "2022-02-06 14:04:08", "184.168.97.101");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7114", "1", "digitaladmin", "2022-02-06 14:07:19", "92.205.10.70");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7115", "1", "digitaladmin", "2022-02-06 14:10:50", "68.178.220.188");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7116", "1", "digitaladmin", "2022-02-06 14:13:51", "54.39.49.75");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7117", "1", "digitaladmin", "2022-02-06 14:17:04", "173.201.185.124");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7118", "1", "digitaladmin", "2022-02-06 14:19:57", "173.201.186.32");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7119", "1", "digitaladmin", "2022-02-06 14:22:49", "3.110.115.35");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7120", "1", "digitaladmin", "2022-02-06 14:25:43", "184.168.113.249");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7121", "1", "digitaladmin", "2022-02-06 14:28:42", "85.119.122.23");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7122", "1", "digitaladmin", "2022-02-06 14:30:40", "199.188.201.153");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7123", "1", "digitaladmin", "2022-02-06 14:33:29", "109.234.161.233");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7124", "1", "digitaladmin", "2022-02-06 14:35:38", "64.227.12.160");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7125", "1", "digitaladmin", "2022-02-06 14:38:25", "196.203.219.49");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7126", "1", "digitaladmin", "2022-02-06 14:40:53", "62.28.184.124");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7127", "1", "digitaladmin", "2022-02-06 14:42:57", "35.198.137.137");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7128", "1", "digitaladmin", "2022-02-06 14:45:27", "185.165.116.22");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7129", "1", "digitaladmin", "2022-02-06 14:48:00", "162.241.174.216");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7130", "1", "digitaladmin", "2022-02-06 14:50:12", "208.109.16.87");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7131", "1", "digitaladmin", "2022-02-06 14:52:43", "34.68.97.70");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7132", "1", "digitaladmin", "2022-02-06 14:54:54", "193.151.131.43");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7133", "1", "digitaladmin", "2022-02-06 14:57:08", "92.205.5.130");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7134", "1", "digitaladmin", "2022-02-06 14:59:34", "92.205.13.208");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7135", "1", "digitaladmin", "2022-02-06 15:01:36", "159.65.223.194");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7136", "1", "digitaladmin", "2022-02-06 15:03:59", "216.158.224.16");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7137", "1", "digitaladmin", "2022-02-06 15:06:20", "93.114.234.242");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7138", "1", "digitaladmin", "2022-02-06 15:08:19", "208.109.23.31");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7139", "1", "digitaladmin", "2022-02-06 15:10:18", "162.0.235.14");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7140", "1", "digitaladmin", "2022-02-06 15:12:56", "35.193.222.165");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7141", "1", "digitaladmin", "2022-02-06 15:17:16", "193.151.131.43");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7142", "1", "digitaladmin", "2022-02-06 15:19:21", "72.167.104.77");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7143", "1", "digitaladmin", "2022-02-06 15:21:28", "184.168.119.95");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7144", "1", "digitaladmin", "2022-02-06 15:23:38", "72.167.65.133");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7145", "1", "digitaladmin", "2022-02-06 15:25:45", "92.205.1.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7146", "1", "digitaladmin", "2022-02-06 15:27:48", "208.109.23.65");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7147", "1", "digitaladmin", "2022-02-06 15:29:46", "173.201.177.4");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7148", "1", "digitaladmin", "2022-02-06 15:31:57", "51.222.138.98");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7149", "1", "digitaladmin", "2022-02-06 15:33:43", "39.106.105.38");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7150", "1", "digitaladmin", "2022-02-06 15:35:52", "107.180.124.232");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7151", "1", "digitaladmin", "2022-02-06 15:37:50", "92.205.4.19");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7152", "1", "digitaladmin", "2022-02-06 15:39:42", "39.106.105.38");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7153", "1", "digitaladmin", "2022-02-06 15:41:39", "112.78.1.204");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7154", "1", "digitaladmin", "2022-02-06 15:43:40", "68.65.120.121");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7155", "1", "digitaladmin", "2022-02-06 15:46:02", "197.5.152.234");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7156", "1", "digitaladmin", "2022-02-06 15:47:56", "72.167.67.108");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7157", "1", "digitaladmin", "2022-02-06 15:49:51", "72.167.104.77");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7158", "1", "digitaladmin", "2022-02-06 15:51:46", "35.213.170.208");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7159", "1", "digitaladmin", "2022-02-06 15:54:26", "195.93.152.83");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7160", "1", "digitaladmin", "2022-02-06 15:55:41", "184.154.219.138");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7161", "1", "digitaladmin", "2022-02-06 15:57:49", "92.205.10.38");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7162", "1", "digitaladmin", "2022-02-06 15:59:51", "176.53.65.237");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7163", "1", "digitaladmin", "2022-02-06 16:01:33", "92.205.3.203");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7164", "1", "digitaladmin", "2022-02-06 16:03:38", "92.204.221.14");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7165", "0", "admin", "2022-02-06 16:26:31", "47.74.17.225");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7166", "0", "admin", "2022-02-06 16:28:12", "138.197.153.219");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7167", "1", "digitaladmin", "2022-02-06 16:30:24", "45.156.185.97");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7168", "1", "digitaladmin", "2022-02-06 16:32:12", "104.45.41.45");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7169", "1", "digitaladmin", "2022-02-06 16:33:55", "97.79.236.218");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7170", "1", "digitaladmin", "2022-02-06 16:35:45", "50.62.141.188");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7171", "1", "digitaladmin", "2022-02-06 16:37:46", "184.168.112.180");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7172", "1", "digitaladmin", "2022-02-06 16:39:36", "82.202.160.186");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7173", "1", "digitaladmin", "2022-02-06 16:41:18", "92.205.15.114");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7174", "1", "digitaladmin", "2022-02-06 16:43:13", "68.178.220.188");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7175", "1", "digitaladmin", "2022-02-06 16:45:07", "160.153.216.29");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7176", "1", "digitaladmin", "2022-02-06 16:46:48", "212.227.132.232");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7177", "1", "digitaladmin", "2022-02-06 16:48:44", "178.170.244.102");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7178", "1", "digitaladmin", "2022-02-06 16:50:22", "134.122.46.215");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7179", "1", "digitaladmin", "2022-02-06 16:52:26", "92.205.1.246");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7180", "1", "digitaladmin", "2022-02-06 16:53:59", "72.167.69.40");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7181", "1", "digitaladmin", "2022-02-06 16:55:53", "208.109.16.231");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7182", "1", "digitaladmin", "2022-02-06 16:57:32", "47.74.17.225");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7183", "1", "digitaladmin", "2022-02-06 16:59:38", "208.109.76.93");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7184", "1", "digitaladmin", "2022-02-06 17:01:29", "173.201.185.124");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7185", "1", "digitaladmin", "2022-02-06 17:03:40", "35.193.222.165");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7186", "1", "digitaladmin", "2022-02-06 17:05:11", "159.223.91.63");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7187", "1", "digitaladmin", "2022-02-06 17:07:29", "68.178.221.138");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7188", "1", "digitaladmin", "2022-02-06 17:09:20", "208.109.68.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7189", "1", "digitaladmin", "2022-02-06 17:11:28", "92.205.5.169");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7190", "1", "digitaladmin", "2022-02-06 17:13:11", "198.54.126.110");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7191", "1", "digitaladmin", "2022-02-06 17:15:22", "49.176.154.190");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7192", "1", "digitaladmin", "2022-02-06 17:17:42", "142.4.4.131");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7193", "1", "digitaladmin", "2022-02-06 17:19:49", "176.56.239.171");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7194", "1", "digitaladmin", "2022-02-06 17:22:01", "51.15.4.99");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7195", "1", "digitaladmin", "2022-02-06 17:23:57", "217.174.148.212");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7196", "1", "digitaladmin", "2022-02-06 17:25:47", "184.168.102.191");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7197", "1", "digitaladmin", "2022-02-06 17:27:55", "92.205.10.38");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7198", "1", "digitaladmin", "2022-02-06 17:29:56", "192.99.76.111");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7199", "1", "digitaladmin", "2022-02-06 17:32:03", "92.205.10.38");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7200", "1", "digitaladmin", "2022-02-06 17:33:49", "92.205.5.183");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7201", "1", "digitaladmin", "2022-02-06 17:36:05", "93.113.111.34");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7202", "1", "digitaladmin", "2022-02-06 17:38:01", "50.59.99.143");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7203", "1", "digitaladmin", "2022-02-06 17:40:06", "185.165.116.22");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7204", "1", "digitaladmin", "2022-02-06 17:42:12", "167.99.84.255");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7205", "0", "admin", "2022-02-16 23:27:14", "185.2.5.77");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7206", "0", "admin", "2022-02-16 23:33:16", "92.205.0.94");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7207", "1", "digitaladmin", "2022-02-16 23:39:27", "184.168.96.164");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7208", "1", "digitaladmin", "2022-02-16 23:45:43", "148.72.122.94");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7209", "1", "digitaladmin", "2022-02-16 23:52:01", "209.159.150.110");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7210", "1", "digitaladmin", "2022-02-16 23:58:19", "184.168.102.31");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7211", "1", "digitaladmin", "2022-02-17 00:04:38", "112.196.72.188");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7212", "1", "digitaladmin", "2022-02-17 00:10:52", "8.210.158.38");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7213", "1", "digitaladmin", "2022-02-17 00:17:07", "167.172.67.151");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7214", "1", "digitaladmin", "2022-02-17 00:23:22", "35.198.25.12");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7215", "1", "digitaladmin", "2022-02-17 00:29:34", "184.168.96.164");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7216", "1", "digitaladmin", "2022-02-17 00:35:59", "185.190.39.66");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7217", "1", "digitaladmin", "2022-02-17 00:42:04", "184.168.99.48");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7218", "1", "digitaladmin", "2022-02-17 00:48:21", "162.241.174.216");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7219", "1", "digitaladmin", "2022-02-17 00:54:50", "95.128.46.215");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7220", "1", "digitaladmin", "2022-02-17 01:02:00", "167.71.216.37");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7221", "1", "digitaladmin", "2022-02-17 01:10:03", "139.59.147.218");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7222", "1", "digitaladmin", "2022-02-17 01:17:43", "103.3.164.91");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7223", "1", "digitaladmin", "2022-02-17 01:25:38", "132.148.199.24");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7224", "1", "digitaladmin", "2022-02-17 01:41:57", "47.74.17.225");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7225", "1", "digitaladmin", "2022-02-17 01:49:50", "217.174.148.212");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7226", "0", "admin", "2022-02-17 01:57:46", "72.167.124.64");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7227", "0", "admin", "2022-02-17 02:05:42", "184.168.96.164");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7228", "0", "admin", "2022-02-17 02:13:30", "185.61.154.35");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7229", "0", "admin", "2022-02-17 02:21:24", "39.103.214.1");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7230", "0", "admin", "2022-02-17 02:37:08", "103.90.235.91");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7231", "0", "admin", "2022-02-17 02:45:01", "184.168.102.31");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7232", "0", "admin", "2022-02-17 02:52:53", "51.81.245.120");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7233", "0", "admin", "2022-02-17 03:00:43", "184.168.103.39");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7234", "0", "admin", "2022-02-17 03:08:33", "107.180.103.185");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7235", "0", "admin", "2022-02-17 03:16:24", "185.2.5.77");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7236", "0", "admin", "2022-02-17 03:24:17", "184.168.102.191");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7237", "0", "admin", "2022-02-17 03:32:14", "93.104.213.124");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7238", "0", "admin", "2022-02-17 03:40:01", "104.248.23.214");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7239", "0", "admin", "2022-02-17 03:55:49", "211.115.65.107");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7240", "0", "admin", "2022-02-17 04:06:09", "173.201.177.4");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7241", "0", "admin", "2022-02-17 04:14:04", "109.234.161.233");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7242", "0", "admin", "2022-02-17 04:22:01", "92.204.223.27");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7243", "0", "admin", "2022-02-17 04:30:05", "93.104.213.124");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7244", "0", "admin", "2022-02-17 04:37:51", "144.217.170.27");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7245", "0", "admin", "2022-02-17 04:45:36", "184.168.98.206");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7246", "0", "admin", "2022-02-17 04:53:30", "173.201.177.4");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7247", "0", "admin", "2022-02-17 05:01:23", "93.113.111.34");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7248", "0", "admin", "2022-02-17 05:09:18", "68.183.192.217");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7249", "0", "admin", "2022-02-17 05:17:14", "123.31.41.38");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7250", "0", "admin", "2022-02-17 05:25:09", "72.167.65.133");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7251", "0", "admin", "2022-02-17 05:33:18", "143.110.137.82");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7252", "0", "admin", "2022-02-17 05:40:58", "103.153.214.231");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7253", "0", "admin", "2022-02-17 05:48:52", "89.145.112.48");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7254", "0", "admin", "2022-02-17 05:56:50", "198.20.170.59");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7255", "0", "admin", "2022-02-17 06:04:46", "68.178.220.188");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7256", "0", "admin", "2022-02-17 06:12:42", "209.159.150.110");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7257", "0", "admin", "2022-02-17 06:20:41", "143.110.247.7");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7258", "0", "admin", "2022-02-17 06:28:32", "51.68.141.94");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7259", "0", "admin", "2022-02-17 06:44:19", "159.65.157.154");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7260", "0", "admin", "2022-02-17 06:52:10", "94.130.219.217");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7261", "0", "admin", "2022-02-17 07:00:06", "167.99.12.47");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7262", "0", "admin", "2022-02-17 07:07:57", "66.29.132.64");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7263", "0", "admin", "2022-02-17 07:15:50", "216.245.215.122");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7264", "0", "admin", "2022-02-17 07:23:44", "148.72.199.192");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7265", "0", "admin", "2022-02-17 07:31:37", "123.31.41.38");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7266", "1", "digitaladmin", "2022-02-17 07:39:39", "92.243.15.140");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7267", "1", "digitaladmin", "2022-02-17 07:47:44", "200.147.58.13");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7268", "1", "digitaladmin", "2022-02-17 07:55:47", "62.171.152.171");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7269", "1", "digitaladmin", "2022-02-17 08:03:47", "88.208.209.101");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7270", "1", "digitaladmin", "2022-02-17 08:11:47", "173.201.181.53");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7271", "1", "digitaladmin", "2022-02-17 08:19:48", "198.54.114.106");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7272", "1", "digitaladmin", "2022-02-17 08:27:53", "161.35.210.101");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7273", "1", "digitaladmin", "2022-02-17 08:35:47", "178.62.9.122");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7274", "1", "digitaladmin", "2022-02-17 08:43:49", "43.229.129.91");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7275", "1", "digitaladmin", "2022-02-17 08:51:48", "185.146.20.254");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7276", "1", "digitaladmin", "2022-02-17 08:59:49", "116.12.48.101");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7277", "1", "digitaladmin", "2022-02-17 09:07:48", "173.201.185.124");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7278", "1", "digitaladmin", "2022-02-17 09:15:48", "97.79.236.218");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7279", "1", "digitaladmin", "2022-02-17 09:23:55", "34.122.210.151");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7280", "1", "digitaladmin", "2022-02-17 09:31:57", "198.71.227.4");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7281", "1", "digitaladmin", "2022-02-17 09:40:03", "50.59.99.143");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7282", "1", "digitaladmin", "2022-02-17 09:48:07", "173.201.178.72");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7283", "1", "digitaladmin", "2022-02-17 09:56:10", "184.168.112.180");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7284", "1", "digitaladmin", "2022-02-17 10:04:13", "92.205.15.114");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7285", "1", "digitaladmin", "2022-02-17 10:12:18", "178.62.110.145");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7286", "1", "digitaladmin", "2022-02-17 10:20:23", "163.44.198.33");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7287", "1", "digitaladmin", "2022-02-17 10:28:28", "185.18.212.66");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7288", "1", "digitaladmin", "2022-02-17 10:36:32", "92.205.0.94");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7289", "1", "digitaladmin", "2022-02-17 10:44:37", "65.1.106.34");
INSERT INTO `wpeng_aiowps_failed_logins` VALUES("7290", "1", "digitaladmin", "2022-02-17 10:52:40", "92.205.5.11");

/* INSERT TABLE DATA: wpeng_aiowps_login_activity */
INSERT INTO `wpeng_aiowps_login_activity` VALUES("1", "1", "digitaladmin", "2021-11-06 19:56:03", "1000-10-10 10:00:00", "46.246.143.61", "", "");
INSERT INTO `wpeng_aiowps_login_activity` VALUES("2", "1", "digitaladmin", "2021-11-10 10:43:32", "1000-10-10 10:00:00", "62.1.78.39", "", "");
INSERT INTO `wpeng_aiowps_login_activity` VALUES("3", "4", "tkostoulas", "2022-01-04 10:07:37", "1000-10-10 10:00:00", "45.134.22.40", "", "");
INSERT INTO `wpeng_aiowps_login_activity` VALUES("4", "1", "digitaladmin", "2022-01-19 10:14:41", "1000-10-10 10:00:00", "62.1.78.39", "", "");
INSERT INTO `wpeng_aiowps_login_activity` VALUES("5", "4", "tkostoulas", "2022-02-17 10:55:53", "1000-10-10 10:00:00", "62.1.78.39", "", "");

/* INSERT TABLE DATA: wpeng_comments */
INSERT INTO `wpeng_comments` VALUES("1", "1", "Ένας σχολιαστής WordPress", "wapuu@wordpress.example", "https://wordpress.org/", "", "2018-08-24 14:22:23", "2018-08-24 11:22:23", "Γεια σας, αυτό είναι ένα σχόλιο.\nΓια να ξεκινήσετε με την έγκριση, επεξεργασία και διαγραφή σχολίων, παρακαλώ επισκεφθείτε την οθόνη Σχόλια στον Πίνακα Ελέγχου.\nΤα άβαταρ των σχολιαστών προέρχονται από το <a href=\"https://gravatar.com\">Gravatar</a>.", "0", "1", "", "comment", "0", "0");

/* INSERT TABLE DATA: wpeng_duplicator_packages */
INSERT INTO `wpeng_duplicator_packages` VALUES("15", "yourstep", "a8dd45fdf83469194055_20230727081210", "100", "2023-07-27 08:12:18", "ntolakis", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-07-27 08:12:10\";s:7:\"Version\";s:7:\"1.5.5.1\";s:9:\"VersionWP\";s:5:\"6.2.2\";s:9:\"VersionDB\";s:6:\"5.7.43\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:15;s:4:\"Name\";s:8:\"yourstep\";s:4:\"Hash\";s:35:\"a8dd45fdf83469194055_20230727081210\";s:8:\"NameHash\";s:44:\"yourstep_a8dd45fdf83469194055_20230727081210\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:54:\"yourstep_a8dd45fdf83469194055_20230727081210_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:10:\"25.19 sec.\";s:7:\"ExeSize\";s:7:\"73.46KB\";s:7:\"ZipSize\";s:7:\"52.81MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:8:\"ntolakis\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:58:\"/home/demod4u/public_html/wordpress.engine.gp/wp-snapshots\";s:11:\"FilterFiles\";s:62:\"/home/demod4u/public_html/wordpress.engine.gp/wp-content/cache\";s:10:\"FilterExts\";s:22:\"zip;rar;tar;gz;bz2;7z;\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:1;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:56:\"yourstep_a8dd45fdf83469194055_20230727081210_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:45:\"/home/demod4u/public_html/wordpress.engine.gp\";s:4:\"Size\";i:55378106;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1405;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:7846;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:9250;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:54:\"/home/demod4u/public_html/wordpress.engine.gp/wp-admin\";i:1;s:57:\"/home/demod4u/public_html/wordpress.engine.gp/wp-includes\";i:2;s:66:\"/home/demod4u/public_html/wordpress.engine.gp/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:45:\"/home/demod4u/public_html/wordpress.engine.gp\";i:1;s:45:\"/home/demod4u/public_html/wordpress.engine.gp\";i:2;s:56:\"/home/demod4u/public_html/wordpress.engine.gp/wp-content\";i:3;s:64:\"/home/demod4u/public_html/wordpress.engine.gp/wp-content/uploads\";i:4;s:64:\"/home/demod4u/public_html/wordpress.engine.gp/wp-content/plugins\";i:5;s:67:\"/home/demod4u/public_html/wordpress.engine.gp/wp-content/mu-plugins\";i:6;s:63:\"/home/demod4u/public_html/wordpress.engine.gp/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:62:\"/home/demod4u/public_html/wordpress.engine.gp/wp-snapshots/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:62:\"yourstep_a8dd45fdf83469194055_20230727081210_installer.php.bak\";s:4:\"Size\";i:75228;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;s:17:\"\0*\0origFileManger\";O:40:\"Duplicator\\Libs\\Snap\\SnapOrigFileManager\":4:{s:18:\"\0*\0persistanceFile\";s:114:\"/home/demod4u/public_html/wordpress.engine.gp/wp-snapshots/tmp/original_files_a8dd45f-27081210/entries_stored.json\";s:18:\"\0*\0origFilesFolder\";s:94:\"/home/demod4u/public_html/wordpress.engine.gp/wp-snapshots/tmp/original_files_a8dd45f-27081210\";s:20:\"\0*\0origFolderEntries\";a:0:{}s:11:\"\0*\0rootPath\";s:45:\"/home/demod4u/public_html/wordpress.engine.gp\";}s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:59:\"/home/demod4u/public_html/wordpress.engine.gp/wp-config.php\";s:16:\"\0*\0wp_config_src\";s:3832:\"<?php\ndefine(\'WP_AUTO_UPDATE_CORE\', \'minor\');// This setting is required to make sure that WordPress updates can be properly managed in WordPress Toolkit. Remove this line if this WordPress website is not managed by WordPress Toolkit anymore.\ndefine( \'FORCE_SSL_LOGIN\', true );\ndefine( \'FORCE_SSL_ADMIN\', true );\n\ndefine( \'DISALLOW_FILE_EDIT\', true );\ndefine( \'AUTOMATIC_UPDATER_DISABLED\', true );\n\ndefine( \'WP_MEMORY_LIMIT\', \'256M\' );\ndefine( \'WP_MAX_MEMORY_LIMIT\', \'384M\' );\n/**\n * The base configuration for WordPress\n *\n * The wp-config.php creation script uses this file during the\n * installation. You don\'t have to use the web site, you can\n * copy this file to \"wp-config.php\" and fill in the values.\n *\n * This file contains the following configurations:\n *\n * * MySQL settings\n * * Secret keys\n * * Database table prefix\n * * ABSPATH\n *\n * @link https://codex.wordpress.org/Editing_wp-config.php\n *\n * @package WordPress\n */\n\n// ** MySQL settings - You can get this info from your web host ** //\n/** The name of the database for WordPress */\ndefine(\'DB_NAME\', \"demod4u_wp_engine_gp_db\");\n\n/** MySQL database username */\ndefine(\'DB_USER\', \"demod4u_wp_engine_gp_user\");\n\n/** MySQL database password */\ndefine(\'DB_PASSWORD\', \"7.}*DhdW3SQU\");\n\n/** MySQL hostname */\ndefine(\'DB_HOST\', \"localhost\");\n\n/** Database Charset to use in creating database tables. */\ndefine(\'DB_CHARSET\', \'utf8mb4\');\n\n/** The Database Collate type. Don\'t change this if in doubt. */\ndefine(\'DB_COLLATE\', \'\');\n\n/**#@+\n * Authentication Unique Keys and Salts.\n *\n * Change these to different unique phrases!\n * You can generate these using the {@link https://api.wordpress.org/secret-key/1.1/salt/ WordPress.org secret-key service}\n * You can change these at any point in time to invalidate all existing cookies. This will force all users to have to log in again.\n *\n * @since 2.6.0\n */\ndefine(\'AUTH_KEY\',         \'3]{KGw=h)D%s)Y%r/bTSc,1-kIK.yV;9Xaj%@Km7}%5161,.bCHE<eP+KdAjwa5g\');\ndefine(\'SECURE_AUTH_KEY\',  \'m,:nV9&qFJeg):d{*vP4h<056ubx1E=+mOnD2t.m+u(a~z8#oe!{y _v[OwXJ11T\');\ndefine(\'LOGGED_IN_KEY\',    \')wcNk}}r;[,Rjy(0^:pLEs|I,o:mu2Bxgm(7z^lccu[J{Cl^t7J.i=[C}u9HH[7#\');\ndefine(\'NONCE_KEY\',        \'(&q2&VEqS] @%zY,V.q[+.7lJx6EB=OQ8(c==sE@i&X%k?mV4pt8xun$@G#cZyj/\');\ndefine(\'AUTH_SALT\',        \'Y%-_s3K?iVh~lH/tRG{Qb}>{2R>;!=R`kABN|LM.+KFO?i}# a6%oQn=lejrD{j%\');\ndefine(\'SECURE_AUTH_SALT\', \'DsM6iQx@nu,?P 5}egCUsirOt`#);R(xjFP!|;N2q0$~/`cJ3(I.=fEV=X:g{?QK\');\ndefine(\'LOGGED_IN_SALT\',   \'KJ,!p:`^_(uNZWkKiTrby[mv-](KJ=I3F,T$IeIg%L~ s,:qD~vSoeC)7kb@HU!p\');\ndefine(\'NONCE_SALT\',       \'TSb#J)R!TBGr(B2!Ef^iXYFefmQ,5bipFj`<Q+@;a[I<SRW}HIYyGKJqii)y+gV9\');\n\n/**#@-*/\n\n/**\n * WordPress Database Table prefix.\n *\n * You can have multiple installations in one database if you give each\n * a unique prefix. Only numbers, letters, and underscores please!\n */\n$table_prefix  = \'wpeng_\';\n\n/**\n * For developers: WordPress debugging mode.\n *\n * Change this to true to enable the display of notices during development.\n * It is strongly recommended that plugin and theme developers use WP_DEBUG\n * in their development environments.\n *\n * For information on other constants that can be used for debugging,\n * visit the Codex.\n *\n * @link https://codex.wordpress.org/Debugging_in_WordPress\n */\ndefine(\'WP_DEBUG\', true);\n// Enable Debug logging to the /wp-content/debug.log file\ndefine(\'WP_DEBUG_LOG\', true);\ndefine(\'WP_DEBUG_DISPLAY\', false);\n\n//Specify the Number of Post Revisions\n//define(\'WP_POST_REVISIONS\', 3);\n\n//define(\'EMPTY_TRASH_DAYS\', 3);\n//define(\'AUTOSAVE_INTERVAL\', 240 ); // Seconds\n\n\n/* That\'s all, stop editing! Happy blogging. */\n\n/** Absolute path to the WordPress directory. */\nif ( !defined(\'ABSPATH\') )\n	define(\'ABSPATH\', dirname(__FILE__) . \'/\');\n\n/** Sets up WordPress vars and included files. */\nrequire_once(ABSPATH . \'wp-settings.php\');\n\";s:13:\"\0*\0wp_configs\";a:2:{s:8:\"constant\";a:25:{s:19:\"WP_AUTO_UPDATE_CORE\";a:3:{s:3:\"src\";s:39:\"define(\'WP_AUTO_UPDATE_CORE\', \'minor\');\";s:5:\"value\";s:7:\"\'minor\'\";s:5:\"parts\";a:3:{i:0;s:28:\"define(\'WP_AUTO_UPDATE_CORE\'\";i:1;s:9:\", \'minor\'\";i:2;s:2:\");\";}}s:15:\"FORCE_SSL_LOGIN\";a:3:{s:3:\"src\";s:34:\"define( \'FORCE_SSL_LOGIN\', true );\";s:5:\"value\";s:4:\"true\";s:5:\"parts\";a:3:{i:0;s:25:\"define( \'FORCE_SSL_LOGIN\'\";i:1;s:7:\", true \";i:2;s:2:\");\";}}s:15:\"FORCE_SSL_ADMIN\";a:3:{s:3:\"src\";s:34:\"define( \'FORCE_SSL_ADMIN\', true );\";s:5:\"value\";s:4:\"true\";s:5:\"parts\";a:3:{i:0;s:25:\"define( \'FORCE_SSL_ADMIN\'\";i:1;s:7:\", true \";i:2;s:2:\");\";}}s:18:\"DISALLOW_FILE_EDIT\";a:3:{s:3:\"src\";s:37:\"define( \'DISALLOW_FILE_EDIT\', true );\";s:5:\"value\";s:4:\"true\";s:5:\"parts\";a:3:{i:0;s:28:\"define( \'DISALLOW_FILE_EDIT\'\";i:1;s:7:\", true \";i:2;s:2:\");\";}}s:26:\"AUTOMATIC_UPDATER_DISABLED\";a:3:{s:3:\"src\";s:45:\"define( \'AUTOMATIC_UPDATER_DISABLED\', true );\";s:5:\"value\";s:4:\"true\";s:5:\"parts\";a:3:{i:0;s:36:\"define( \'AUTOMATIC_UPDATER_DISABLED\'\";i:1;s:7:\", true \";i:2;s:2:\");\";}}s:15:\"WP_MEMORY_LIMIT\";a:3:{s:3:\"src\";s:36:\"define( \'WP_MEMORY_LIMIT\', \'256M\' );\";s:5:\"value\";s:6:\"\'256M\'\";s:5:\"parts\";a:3:{i:0;s:25:\"define( \'WP_MEMORY_LIMIT\'\";i:1;s:9:\", \'256M\' \";i:2;s:2:\");\";}}s:19:\"WP_MAX_MEMORY_LIMIT\";a:3:{s:3:\"src\";s:40:\"define( \'WP_MAX_MEMORY_LIMIT\', \'384M\' );\";s:5:\"value\";s:6:\"\'384M\'\";s:5:\"parts\";a:3:{i:0;s:29:\"define( \'WP_MAX_MEMORY_LIMIT\'\";i:1;s:9:\", \'384M\' \";i:2;s:2:\");\";}}s:7:\"DB_NAME\";a:3:{s:3:\"src\";s:45:\"define(\'DB_NAME\', \"demod4u_wp_engine_gp_db\");\";s:5:\"value\";s:25:\"\"demod4u_wp_engine_gp_db\"\";s:5:\"parts\";a:3:{i:0;s:16:\"define(\'DB_NAME\'\";i:1;s:27:\", \"demod4u_wp_engine_gp_db\"\";i:2;s:2:\");\";}}s:7:\"DB_USER\";a:3:{s:3:\"src\";s:47:\"define(\'DB_USER\', \"demod4u_wp_engine_gp_user\");\";s:5:\"value\";s:27:\"\"demod4u_wp_engine_gp_user\"\";s:5:\"parts\";a:3:{i:0;s:16:\"define(\'DB_USER\'\";i:1;s:29:\", \"demod4u_wp_engine_gp_user\"\";i:2;s:2:\");\";}}s:11:\"DB_PASSWORD\";a:3:{s:3:\"src\";s:38:\"define(\'DB_PASSWORD\', \"7.}*DhdW3SQU\");\";s:5:\"value\";s:14:\"\"7.}*DhdW3SQU\"\";s:5:\"parts\";a:3:{i:0;s:20:\"define(\'DB_PASSWORD\'\";i:1;s:16:\", \"7.}*DhdW3SQU\"\";i:2;s:2:\");\";}}s:7:\"DB_HOST\";a:3:{s:3:\"src\";s:31:\"define(\'DB_HOST\', \"localhost\");\";s:5:\"value\";s:11:\"\"localhost\"\";s:5:\"parts\";a:3:{i:0;s:16:\"define(\'DB_HOST\'\";i:1;s:13:\", \"localhost\"\";i:2;s:2:\");\";}}s:10:\"DB_CHARSET\";a:3:{s:3:\"src\";s:32:\"define(\'DB_CHARSET\', \'utf8mb4\');\";s:5:\"value\";s:9:\"\'utf8mb4\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define(\'DB_CHARSET\'\";i:1;s:11:\", \'utf8mb4\'\";i:2;s:2:\");\";}}s:10:\"DB_COLLATE\";a:3:{s:3:\"src\";s:25:\"define(\'DB_COLLATE\', \'\');\";s:5:\"value\";s:2:\"\'\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define(\'DB_COLLATE\'\";i:1;s:4:\", \'\'\";i:2;s:2:\");\";}}s:8:\"AUTH_KEY\";a:3:{s:3:\"src\";s:95:\"define(\'AUTH_KEY\',         \'3]{KGw=h)D%s)Y%r/bTSc,1-kIK.yV;9Xaj%@Km7}%5161,.bCHE<eP+KdAjwa5g\');\";s:5:\"value\";s:66:\"\'3]{KGw=h)D%s)Y%r/bTSc,1-kIK.yV;9Xaj%@Km7}%5161,.bCHE<eP+KdAjwa5g\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define(\'AUTH_KEY\'\";i:1;s:76:\",         \'3]{KGw=h)D%s)Y%r/bTSc,1-kIK.yV;9Xaj%@Km7}%5161,.bCHE<eP+KdAjwa5g\'\";i:2;s:2:\");\";}}s:15:\"SECURE_AUTH_KEY\";a:3:{s:3:\"src\";s:95:\"define(\'SECURE_AUTH_KEY\',  \'m,:nV9&qFJeg):d{*vP4h<056ubx1E=+mOnD2t.m+u(a~z8#oe!{y _v[OwXJ11T\');\";s:5:\"value\";s:66:\"\'m,:nV9&qFJeg):d{*vP4h<056ubx1E=+mOnD2t.m+u(a~z8#oe!{y _v[OwXJ11T\'\";s:5:\"parts\";a:3:{i:0;s:24:\"define(\'SECURE_AUTH_KEY\'\";i:1;s:69:\",  \'m,:nV9&qFJeg):d{*vP4h<056ubx1E=+mOnD2t.m+u(a~z8#oe!{y _v[OwXJ11T\'\";i:2;s:2:\");\";}}s:13:\"LOGGED_IN_KEY\";a:3:{s:3:\"src\";s:95:\"define(\'LOGGED_IN_KEY\',    \')wcNk}}r;[,Rjy(0^:pLEs|I,o:mu2Bxgm(7z^lccu[J{Cl^t7J.i=[C}u9HH[7#\');\";s:5:\"value\";s:66:\"\')wcNk}}r;[,Rjy(0^:pLEs|I,o:mu2Bxgm(7z^lccu[J{Cl^t7J.i=[C}u9HH[7#\'\";s:5:\"parts\";a:3:{i:0;s:22:\"define(\'LOGGED_IN_KEY\'\";i:1;s:71:\",    \')wcNk}}r;[,Rjy(0^:pLEs|I,o:mu2Bxgm(7z^lccu[J{Cl^t7J.i=[C}u9HH[7#\'\";i:2;s:2:\");\";}}s:9:\"NONCE_KEY\";a:3:{s:3:\"src\";s:95:\"define(\'NONCE_KEY\',        \'(&q2&VEqS] @%zY,V.q[+.7lJx6EB=OQ8(c==sE@i&X%k?mV4pt8xun$@G#cZyj/\');\";s:5:\"value\";s:66:\"\'(&q2&VEqS] @%zY,V.q[+.7lJx6EB=OQ8(c==sE@i&X%k?mV4pt8xun$@G#cZyj/\'\";s:5:\"parts\";a:3:{i:0;s:18:\"define(\'NONCE_KEY\'\";i:1;s:75:\",        \'(&q2&VEqS] @%zY,V.q[+.7lJx6EB=OQ8(c==sE@i&X%k?mV4pt8xun$@G#cZyj/\'\";i:2;s:2:\");\";}}s:9:\"AUTH_SALT\";a:3:{s:3:\"src\";s:95:\"define(\'AUTH_SALT\',        \'Y%-_s3K?iVh~lH/tRG{Qb}>{2R>;!=R`kABN|LM.+KFO?i}# a6%oQn=lejrD{j%\');\";s:5:\"value\";s:66:\"\'Y%-_s3K?iVh~lH/tRG{Qb}>{2R>;!=R`kABN|LM.+KFO?i}# a6%oQn=lejrD{j%\'\";s:5:\"parts\";a:3:{i:0;s:18:\"define(\'AUTH_SALT\'\";i:1;s:75:\",        \'Y%-_s3K?iVh~lH/tRG{Qb}>{2R>;!=R`kABN|LM.+KFO?i}# a6%oQn=lejrD{j%\'\";i:2;s:2:\");\";}}s:16:\"SECURE_AUTH_SALT\";a:3:{s:3:\"src\";s:95:\"define(\'SECURE_AUTH_SALT\', \'DsM6iQx@nu,?P 5}egCUsirOt`#);R(xjFP!|;N2q0$~/`cJ3(I.=fEV=X:g{?QK\');\";s:5:\"value\";s:66:\"\'DsM6iQx@nu,?P 5}egCUsirOt`#);R(xjFP!|;N2q0$~/`cJ3(I.=fEV=X:g{?QK\'\";s:5:\"parts\";a:3:{i:0;s:25:\"define(\'SECURE_AUTH_SALT\'\";i:1;s:68:\", \'DsM6iQx@nu,?P 5}egCUsirOt`#);R(xjFP!|;N2q0$~/`cJ3(I.=fEV=X:g{?QK\'\";i:2;s:2:\");\";}}s:14:\"LOGGED_IN_SALT\";a:3:{s:3:\"src\";s:95:\"define(\'LOGGED_IN_SALT\',   \'KJ,!p:`^_(uNZWkKiTrby[mv-](KJ=I3F,T$IeIg%L~ s,:qD~vSoeC)7kb@HU!p\');\";s:5:\"value\";s:66:\"\'KJ,!p:`^_(uNZWkKiTrby[mv-](KJ=I3F,T$IeIg%L~ s,:qD~vSoeC)7kb@HU!p\'\";s:5:\"parts\";a:3:{i:0;s:23:\"define(\'LOGGED_IN_SALT\'\";i:1;s:70:\",   \'KJ,!p:`^_(uNZWkKiTrby[mv-](KJ=I3F,T$IeIg%L~ s,:qD~vSoeC)7kb@HU!p\'\";i:2;s:2:\");\";}}s:10:\"NONCE_SALT\";a:3:{s:3:\"src\";s:95:\"define(\'NONCE_SALT\',       \'TSb#J)R!TBGr(B2!Ef^iXYFefmQ,5bipFj`<Q+@;a[I<SRW}HIYyGKJqii)y+gV9\');\";s:5:\"value\";s:66:\"\'TSb#J)R!TBGr(B2!Ef^iXYFefmQ,5bipFj`<Q+@;a[I<SRW}HIYyGKJqii)y+gV9\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define(\'NONCE_SALT\'\";i:1;s:74:\",       \'TSb#J)R!TBGr(B2!Ef^iXYFefmQ,5bipFj`<Q+@;a[I<SRW}HIYyGKJqii)y+gV9\'\";i:2;s:2:\");\";}}s:8:\"WP_DEBUG\";a:3:{s:3:\"src\";s:25:\"define(\'WP_DEBUG\', true);\";s:5:\"value\";s:4:\"true\";s:5:\"parts\";a:3:{i:0;s:17:\"define(\'WP_DEBUG\'\";i:1;s:6:\", true\";i:2;s:2:\");\";}}s:12:\"WP_DEBUG_LOG\";a:3:{s:3:\"src\";s:29:\"define(\'WP_DEBUG_LOG\', true);\";s:5:\"value\";s:4:\"true\";s:5:\"parts\";a:3:{i:0;s:21:\"define(\'WP_DEBUG_LOG\'\";i:1;s:6:\", true\";i:2;s:2:\");\";}}s:16:\"WP_DEBUG_DISPLAY\";a:3:{s:3:\"src\";s:34:\"define(\'WP_DEBUG_DISPLAY\', false);\";s:5:\"value\";s:5:\"false\";s:5:\"parts\";a:3:{i:0;s:25:\"define(\'WP_DEBUG_DISPLAY\'\";i:1;s:7:\", false\";i:2;s:2:\");\";}}s:7:\"ABSPATH\";a:3:{s:3:\"src\";s:44:\"	define(\'ABSPATH\', dirname(__FILE__) . \'/\');\";s:5:\"value\";s:23:\"dirname(__FILE__) . \'/\'\";s:5:\"parts\";a:3:{i:0;s:17:\"	define(\'ABSPATH\'\";i:1;s:25:\", dirname(__FILE__) . \'/\'\";i:2;s:2:\");\";}}}s:8:\"variable\";a:1:{s:12:\"table_prefix\";a:3:{s:3:\"src\";s:26:\"$table_prefix  = \'wpeng_\';\";s:5:\"value\";s:8:\"\'wpeng_\'\";s:5:\"parts\";a:2:{i:0;s:16:\"$table_prefix  =\";i:1;s:10:\" \'wpeng_\';\";}}}}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:7662177;s:4:\"File\";s:57:\"yourstep_a8dd45fdf83469194055_20230727081210_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:3:{i:0;s:7:\"utf8mb4\";i:1;s:6:\"latin1\";i:2;s:4:\"utf8\";}s:13:\"collationList\";a:3:{i:0;s:17:\"latin1_swedish_ci\";i:1;s:15:\"utf8_general_ci\";i:2;s:22:\"utf8mb4_unicode_520_ci\";}s:10:\"engineList\";a:3:{i:0;s:6:\"InnoDB\";i:1;s:6:\"MyISAM\";i:2;s:6:\"MEMORY\";}s:17:\"isTablesUpperCase\";i:1;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:23:\"demod4u_wp_engine_gp_db\";s:15:\"tablesBaseCount\";i:54;s:16:\"tablesFinalCount\";i:54;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:27139;s:16:\"tablesSizeOnDisk\";i:13018062;s:10:\"tablesList\";a:54:{s:19:\"wpeng_aiowps_events\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:26:\"wpeng_aiowps_failed_logins\";a:3:{s:14:\"inaccurateRows\";i:5100;s:12:\"insertedRows\";i:5004;s:4:\"size\";i:393216;}s:24:\"wpeng_aiowps_global_meta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:27:\"wpeng_aiowps_login_activity\";a:3:{s:14:\"inaccurateRows\";i:5;s:12:\"insertedRows\";i:5;s:4:\"size\";i:16384;}s:27:\"wpeng_aiowps_login_lockdown\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:28:\"wpeng_aiowps_permanent_block\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:15:\"wpeng_cf7_vdata\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:21:\"wpeng_cf7_vdata_entry\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:17:\"wpeng_commentmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:14:\"wpeng_comments\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:98304;}s:15:\"wpeng_db7_forms\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:25:\"wpeng_duplicator_packages\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:32768;}s:19:\"wpeng_ewwwio_images\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:22:\"wpeng_hidemysiteSecure\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:2152;}s:11:\"wpeng_links\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:13:\"wpeng_options\";a:3:{s:14:\"inaccurateRows\";i:356;s:12:\"insertedRows\";i:344;s:4:\"size\";i:1212416;}s:14:\"wpeng_postmeta\";a:3:{s:14:\"inaccurateRows\";i:9;s:12:\"insertedRows\";i:10;s:4:\"size\";i:49152;}s:11:\"wpeng_posts\";a:3:{s:14:\"inaccurateRows\";i:8;s:12:\"insertedRows\";i:8;s:4:\"size\";i:98304;}s:14:\"wpeng_termmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:11:\"wpeng_terms\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:3;s:4:\"size\";i:49152;}s:24:\"wpeng_term_relationships\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:3;s:4:\"size\";i:32768;}s:19:\"wpeng_term_taxonomy\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:3;s:4:\"size\";i:49152;}s:14:\"wpeng_usermeta\";a:3:{s:14:\"inaccurateRows\";i:363;s:12:\"insertedRows\";i:366;s:4:\"size\";i:131072;}s:11:\"wpeng_users\";a:3:{s:14:\"inaccurateRows\";i:10;s:12:\"insertedRows\";i:10;s:4:\"size\";i:65536;}s:20:\"wpeng_wfBlockedIPLog\";a:3:{s:14:\"inaccurateRows\";i:1511;s:12:\"insertedRows\";i:2162;s:4:\"size\";i:131072;}s:15:\"wpeng_wfBlocks7\";a:3:{s:14:\"inaccurateRows\";i:172;s:12:\"insertedRows\";i:242;s:4:\"size\";i:98304;}s:14:\"wpeng_wfConfig\";a:3:{s:14:\"inaccurateRows\";i:287;s:12:\"insertedRows\";i:290;s:4:\"size\";i:1310720;}s:16:\"wpeng_wfCrawlers\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:19:\"wpeng_wfFileChanges\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:16:\"wpeng_wfFileMods\";a:3:{s:14:\"inaccurateRows\";i:6986;s:12:\"insertedRows\";i:7613;s:4:\"size\";i:3686400;}s:12:\"wpeng_wfHits\";a:3:{s:14:\"inaccurateRows\";i:1571;s:12:\"insertedRows\";i:1806;s:4:\"size\";i:1310720;}s:14:\"wpeng_wfHoover\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:14:\"wpeng_wfIssues\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:2;s:4:\"size\";i:81920;}s:21:\"wpeng_wfKnownFileList\";a:3:{s:14:\"inaccurateRows\";i:7635;s:12:\"insertedRows\";i:7613;s:4:\"size\";i:2637824;}s:24:\"wpeng_wfLiveTrafficHuman\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:12:\"wpeng_wfLocs\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:14:\"wpeng_wfLogins\";a:3:{s:14:\"inaccurateRows\";i:1999;s:12:\"insertedRows\";i:2006;s:4:\"size\";i:540672;}s:22:\"wpeng_wfls_2fa_secrets\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:22:\"wpeng_wfls_role_counts\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:0;}s:19:\"wpeng_wfls_settings\";a:3:{s:14:\"inaccurateRows\";i:32;s:12:\"insertedRows\";i:32;s:4:\"size\";i:16384;}s:21:\"wpeng_wfNotifications\";a:3:{s:14:\"inaccurateRows\";i:100;s:12:\"insertedRows\";i:130;s:4:\"size\";i:49152;}s:21:\"wpeng_wfPendingIssues\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:81920;}s:20:\"wpeng_wfReverseCache\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:22:\"wpeng_wfSecurityEvents\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:17:\"wpeng_wfSNIPCache\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:65536;}s:14:\"wpeng_wfStatus\";a:3:{s:14:\"inaccurateRows\";i:944;s:12:\"insertedRows\";i:944;s:4:\"size\";i:262144;}s:20:\"wpeng_wfTrafficRates\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:19:\"wpeng_wfWafFailures\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:21:\"wpeng_yoast_indexable\";a:3:{s:14:\"inaccurateRows\";i:9;s:12:\"insertedRows\";i:9;s:4:\"size\";i:15204;}s:31:\"wpeng_yoast_indexable_hierarchy\";a:3:{s:14:\"inaccurateRows\";i:6;s:12:\"insertedRows\";i:6;s:4:\"size\";i:5330;}s:22:\"wpeng_yoast_migrations\";a:3:{s:14:\"inaccurateRows\";i:24;s:12:\"insertedRows\";i:24;s:4:\"size\";i:9792;}s:24:\"wpeng_yoast_primary_term\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:21:\"wpeng_yoast_seo_links\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:4200;}s:20:\"wpeng_yoast_seo_meta\";a:3:{s:14:\"inaccurateRows\";i:8;s:12:\"insertedRows\";i:8;s:4:\"size\";i:2184;}}s:18:\"varLowerCaseTables\";s:1:\"0\";s:8:\"dbEngine\";s:5:\"MySQL\";s:7:\"version\";s:6:\"5.7.43\";s:14:\"versionComment\";s:28:\"MySQL Community Server (GPL)\";s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:120:\"/home/demod4u/public_html/wordpress.engine.gp/wp-snapshots/tmp/yourstep_a8dd45fdf83469194055_20230727081210_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";s:1:\"1\";}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-07-27 08:12:10\";s:7:\"Version\";s:7:\"1.5.5.1\";s:9:\"VersionWP\";s:5:\"6.2.2\";s:9:\"VersionDB\";s:6:\"5.7.43\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:8:\"yourstep\";s:4:\"Hash\";s:35:\"a8dd45fdf83469194055_20230727081210\";s:8:\"NameHash\";s:44:\"yourstep_a8dd45fdf83469194055_20230727081210\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:84;s:8:\"Database\";r:290;s:13:\"BuildProgress\";r:554;}}}");
INSERT INTO `wpeng_duplicator_packages` VALUES("16", "oneservices", "b94f130381fcc2e31360_20230727090147", "22", "2023-07-27 09:01:59", "ntolakis", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-07-27 09:01:47\";s:7:\"Version\";s:7:\"1.5.5.1\";s:9:\"VersionWP\";s:5:\"6.2.2\";s:9:\"VersionDB\";s:6:\"5.7.43\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:16;s:4:\"Name\";s:11:\"oneservices\";s:4:\"Hash\";s:35:\"b94f130381fcc2e31360_20230727090147\";s:8:\"NameHash\";s:47:\"oneservices_b94f130381fcc2e31360_20230727090147\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:57:\"oneservices_b94f130381fcc2e31360_20230727090147_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"22.2\";s:6:\"WPUser\";s:8:\"ntolakis\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:58:\"/home/demod4u/public_html/wordpress.engine.gp/wp-snapshots\";s:11:\"FilterFiles\";s:62:\"/home/demod4u/public_html/wordpress.engine.gp/wp-content/cache\";s:10:\"FilterExts\";s:22:\"zip;rar;tar;gz;bz2;7z;\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:1;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:59:\"oneservices_b94f130381fcc2e31360_20230727090147_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:45:\"/home/demod4u/public_html/wordpress.engine.gp\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1405;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:7846;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-07-27 09:01:47\";s:7:\"Version\";s:7:\"1.5.5.1\";s:9:\"VersionWP\";s:5:\"6.2.2\";s:9:\"VersionDB\";s:6:\"5.7.43\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:11:\"oneservices\";s:4:\"Hash\";s:35:\"b94f130381fcc2e31360_20230727090147\";s:8:\"NameHash\";s:47:\"oneservices_b94f130381fcc2e31360_20230727090147\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:65:\"oneservices_b94f130381fcc2e31360_20230727090147_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:59:\"/home/demod4u/public_html/wordpress.engine.gp/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:60:\"oneservices_b94f130381fcc2e31360_20230727090147_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:18:\"varLowerCaseTables\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:123:\"/home/demod4u/public_html/wordpress.engine.gp/wp-snapshots/tmp/oneservices_b94f130381fcc2e31360_20230727090147_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";s:1:\"1\";}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:54:\"/home/demod4u/public_html/wordpress.engine.gp/wp-admin\";i:1;s:57:\"/home/demod4u/public_html/wordpress.engine.gp/wp-includes\";i:2;s:66:\"/home/demod4u/public_html/wordpress.engine.gp/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:45:\"/home/demod4u/public_html/wordpress.engine.gp\";i:1;s:45:\"/home/demod4u/public_html/wordpress.engine.gp\";i:2;s:56:\"/home/demod4u/public_html/wordpress.engine.gp/wp-content\";i:3;s:64:\"/home/demod4u/public_html/wordpress.engine.gp/wp-content/uploads\";i:4;s:64:\"/home/demod4u/public_html/wordpress.engine.gp/wp-content/plugins\";i:5;s:67:\"/home/demod4u/public_html/wordpress.engine.gp/wp-content/mu-plugins\";i:6;s:63:\"/home/demod4u/public_html/wordpress.engine.gp/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:62:\"/home/demod4u/public_html/wordpress.engine.gp/wp-snapshots/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wpeng_hidemysiteSecure */
INSERT INTO `wpeng_hidemysiteSecure` VALUES("6", "94.66.57.149", "1620141262", "1");
INSERT INTO `wpeng_hidemysiteSecure` VALUES("15", "62.1.78.39", "1658832046", "1");

/* INSERT TABLE DATA: wpeng_options */
INSERT INTO `wpeng_options` VALUES("1", "siteurl", "https://wordpress.engine.gp.demod4u.gr", "yes");
INSERT INTO `wpeng_options` VALUES("2", "home", "https://wordpress.engine.gp.demod4u.gr", "yes");
INSERT INTO `wpeng_options` VALUES("3", "blogname", "WordPress Engine", "yes");
INSERT INTO `wpeng_options` VALUES("4", "blogdescription", "", "yes");
INSERT INTO `wpeng_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wpeng_options` VALUES("6", "admin_email", "dev@digital4u.gr", "yes");
INSERT INTO `wpeng_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `wpeng_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wpeng_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wpeng_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wpeng_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wpeng_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wpeng_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wpeng_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wpeng_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wpeng_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wpeng_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wpeng_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wpeng_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wpeng_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wpeng_options` VALUES("21", "default_pingback_flag", "0", "yes");
INSERT INTO `wpeng_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wpeng_options` VALUES("23", "date_format", "j F Y", "yes");
INSERT INTO `wpeng_options` VALUES("24", "time_format", "H:i", "yes");
INSERT INTO `wpeng_options` VALUES("25", "links_updated_date_format", "d/m/Y, H:i", "yes");
INSERT INTO `wpeng_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `wpeng_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wpeng_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wpeng_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wpeng_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wpeng_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wpeng_options` VALUES("33", "active_plugins", "a:18:{i:0;s:35:\"advanced-cf7-db/advanced-cf7-db.php\";i:1;s:55:\"autoconvert-greeklish-permalinks/auto-gr-permalinks.php\";i:2;s:36:\"contact-form-7/wp-contact-form-7.php\";i:3;s:31:\"cookie-notice/cookie-notice.php\";i:4;s:37:\"disable-comments/disable-comments.php\";i:5;s:33:\"duplicate-post/duplicate-post.php\";i:6;s:25:\"duplicator/duplicator.php\";i:7;s:45:\"enable-media-replace/enable-media-replace.php\";i:8;s:49:\"gallery-block-lightbox/gallery-block-lightbox.php\";i:9;s:25:\"generateblocks/plugin.php\";i:10;s:25:\"gp-premium/gp-premium.php\";i:11;s:33:\"gutenslider/eedee-gutenslider.php\";i:12;s:22:\"hide-my-site/index.php\";i:13;s:53:\"remove-uppercase-accents/remove-uppercase-accents.php\";i:14;s:39:\"resmushit-image-optimizer/resmushit.php\";i:15;s:53:\"webp-converter-for-media/webp-converter-for-media.php\";i:16;s:23:\"wordfence/wordfence.php\";i:17;s:24:\"wordpress-seo/wp-seo.php\";}", "yes");
INSERT INTO `wpeng_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wpeng_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wpeng_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wpeng_options` VALUES("37", "gmt_offset", "", "yes");
INSERT INTO `wpeng_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wpeng_options` VALUES("39", "recently_edited", "", "no");
INSERT INTO `wpeng_options` VALUES("40", "template", "generatepress", "yes");
INSERT INTO `wpeng_options` VALUES("41", "stylesheet", "generatepress_child", "yes");
INSERT INTO `wpeng_options` VALUES("44", "comment_registration", "0", "yes");
INSERT INTO `wpeng_options` VALUES("45", "html_type", "text/html", "yes");
INSERT INTO `wpeng_options` VALUES("46", "use_trackback", "0", "yes");
INSERT INTO `wpeng_options` VALUES("47", "default_role", "subscriber", "yes");
INSERT INTO `wpeng_options` VALUES("48", "db_version", "53496", "yes");
INSERT INTO `wpeng_options` VALUES("49", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wpeng_options` VALUES("50", "upload_path", "", "yes");
INSERT INTO `wpeng_options` VALUES("51", "blog_public", "0", "yes");
INSERT INTO `wpeng_options` VALUES("52", "default_link_category", "2", "yes");
INSERT INTO `wpeng_options` VALUES("53", "show_on_front", "posts", "yes");
INSERT INTO `wpeng_options` VALUES("54", "tag_base", "", "yes");
INSERT INTO `wpeng_options` VALUES("55", "show_avatars", "1", "yes");
INSERT INTO `wpeng_options` VALUES("56", "avatar_rating", "G", "yes");
INSERT INTO `wpeng_options` VALUES("57", "upload_url_path", "", "yes");
INSERT INTO `wpeng_options` VALUES("58", "thumbnail_size_w", "150", "yes");
INSERT INTO `wpeng_options` VALUES("59", "thumbnail_size_h", "150", "yes");
INSERT INTO `wpeng_options` VALUES("60", "thumbnail_crop", "1", "yes");
INSERT INTO `wpeng_options` VALUES("61", "medium_size_w", "300", "yes");
INSERT INTO `wpeng_options` VALUES("62", "medium_size_h", "300", "yes");
INSERT INTO `wpeng_options` VALUES("63", "avatar_default", "mystery", "yes");
INSERT INTO `wpeng_options` VALUES("64", "large_size_w", "1024", "yes");
INSERT INTO `wpeng_options` VALUES("65", "large_size_h", "1024", "yes");
INSERT INTO `wpeng_options` VALUES("66", "image_default_link_type", "none", "yes");
INSERT INTO `wpeng_options` VALUES("67", "image_default_size", "", "yes");
INSERT INTO `wpeng_options` VALUES("68", "image_default_align", "", "yes");
INSERT INTO `wpeng_options` VALUES("69", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `wpeng_options` VALUES("70", "close_comments_days_old", "14", "yes");
INSERT INTO `wpeng_options` VALUES("71", "thread_comments", "1", "yes");
INSERT INTO `wpeng_options` VALUES("72", "thread_comments_depth", "5", "yes");
INSERT INTO `wpeng_options` VALUES("73", "page_comments", "0", "yes");
INSERT INTO `wpeng_options` VALUES("74", "comments_per_page", "50", "yes");
INSERT INTO `wpeng_options` VALUES("75", "default_comments_page", "newest", "yes");
INSERT INTO `wpeng_options` VALUES("76", "comment_order", "asc", "yes");
INSERT INTO `wpeng_options` VALUES("77", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wpeng_options` VALUES("78", "widget_categories", "a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpeng_options` VALUES("79", "widget_text", "a:3:{i:2;a:4:{s:5:\"title\";s:54:\"Σχετικά με αυτόν τον ιστότοπο\";s:4:\"text\";s:236:\"Αυτό φαίνεται να είναι ένα καλό μέρος να κάνεις μία εισαγωγή για \'σένα και για τον ιστότοπό σου ή να περιλάβεις κάποιες συστάσεις.\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}i:3;a:4:{s:5:\"title\";s:19:\"Βρείτε Μας\";s:4:\"text\";s:245:\"<strong>Διεύθυνση</strong>\n3ης Σεπτεμβρίου 115\nΑθήνα, ΤΚ 11251\n\n<strong>Ώρες</strong>\nΔευτέρα&mdash;Παρασκευή: 9:00πμ&ndash;5:00μμ\nΣάββατο &amp; Κυριακή: 11:00πμ&ndash;3:00μμ\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpeng_options` VALUES("80", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpeng_options` VALUES("81", "uninstall_plugins", "a:6:{s:20:\"worker/functions.php\";s:13:\"mwp_uninstall\";s:27:\"wp-optimize/wp-optimize.php\";s:21:\"wpo_uninstall_actions\";s:45:\"ewww-image-optimizer/ewww-image-optimizer.php\";s:30:\"ewww_image_optimizer_uninstall\";s:45:\"enable-media-replace/enable-media-replace.php\";a:2:{i:0;s:33:\"\\EnableMediaReplace\\InstallHelper\";i:1;s:15:\"uninstallPlugin\";}s:53:\"webp-converter-for-media/webp-converter-for-media.php\";a:2:{i:0;s:30:\"WebpConverter\\Plugin\\Uninstall\";i:1;s:22:\"load_uninstall_actions\";}s:21:\"_worker/functions.php\";s:13:\"mwp_uninstall\";}", "no");
INSERT INTO `wpeng_options` VALUES("82", "timezone_string", "Europe/Athens", "yes");
INSERT INTO `wpeng_options` VALUES("83", "page_for_posts", "0", "yes");
INSERT INTO `wpeng_options` VALUES("84", "page_on_front", "0", "yes");
INSERT INTO `wpeng_options` VALUES("85", "default_post_format", "0", "yes");
INSERT INTO `wpeng_options` VALUES("86", "link_manager_enabled", "0", "yes");
INSERT INTO `wpeng_options` VALUES("87", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wpeng_options` VALUES("88", "site_icon", "0", "yes");
INSERT INTO `wpeng_options` VALUES("89", "medium_large_size_w", "768", "yes");
INSERT INTO `wpeng_options` VALUES("90", "medium_large_size_h", "0", "yes");
INSERT INTO `wpeng_options` VALUES("91", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `wpeng_options` VALUES("92", "show_comments_cookies_opt_in", "0", "yes");
INSERT INTO `wpeng_options` VALUES("93", "initial_db_version", "38590", "yes");
INSERT INTO `wpeng_options` VALUES("94", "wpeng_user_roles", "a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:68:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"wf2fa_activate_2fa_self\";b:1;s:25:\"wf2fa_activate_2fa_others\";b:1;s:21:\"wf2fa_manage_settings\";b:1;s:10:\"copy_posts\";b:1;s:17:\"cf7_db_form_view5\";b:1;s:18:\"cf7_db_form_edit_5\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:36:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:10:\"copy_posts\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:39:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"view_site_health_checks\";b:1;s:10:\"copy_posts\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:37:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:10:\"copy_posts\";b:1;}}}", "yes");
INSERT INTO `wpeng_options` VALUES("95", "fresh_site", "0", "yes");
INSERT INTO `wpeng_options` VALUES("96", "WPLANG", "el", "yes");
INSERT INTO `wpeng_options` VALUES("97", "widget_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpeng_options` VALUES("98", "widget_recent-posts", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpeng_options` VALUES("99", "widget_recent-comments", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpeng_options` VALUES("100", "widget_archives", "a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpeng_options` VALUES("101", "widget_meta", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpeng_options` VALUES("102", "sidebars_widgets", "a:12:{s:19:\"wp_inactive_widgets\";a:2:{i:0;s:6:\"text-2\";i:1;s:6:\"text-3\";}s:9:\"sidebar-1\";a:5:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:6:\"header\";a:0:{}s:8:\"footer-1\";a:0:{}s:8:\"footer-2\";a:0:{}s:8:\"footer-3\";a:0:{}s:8:\"footer-4\";a:0:{}s:8:\"footer-5\";a:0:{}s:10:\"footer-bar\";a:0:{}s:7:\"top-bar\";a:0:{}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wpeng_options` VALUES("103", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpeng_options` VALUES("104", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpeng_options` VALUES("105", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpeng_options` VALUES("106", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpeng_options` VALUES("107", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpeng_options` VALUES("108", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpeng_options` VALUES("109", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpeng_options` VALUES("110", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpeng_options` VALUES("111", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpeng_options` VALUES("112", "cron", "a:20:{i:1690448569;a:1:{s:15:\"wf_scan_monitor\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:24:\"wf_scan_monitor_interval\";s:4:\"args\";a:0:{}s:8:\"interval\";i:60;}}}i:1690448965;a:1:{s:21:\"wordfence_ls_ntp_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1690448971;a:2:{s:20:\"wordfence_daily_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:21:\"wordfence_hourly_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1690449722;a:2:{s:13:\"wpseo-reindex\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:31:\"wpseo_permalink_structure_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1690449743;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1690452065;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1690453439;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1690456943;a:2:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1690456964;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1690463436;a:1:{s:19:\"wpseo-reindex-links\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1690466289;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1690466746;a:1:{s:22:\"mwp_update_public_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1690486145;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1690486587;a:1:{s:18:\"wp_https_detection\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1690549835;a:1:{s:18:\"wpseo_onpage_fetch\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1690581000;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"7adfff8d942c62cc07c4093b3f993c3e\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1690581000;}}}}i:1690599297;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1690840200;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"fc48e58a9988cfd9b0197321a4234c0c\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1690840200;}}}}i:1690894800;a:1:{s:31:\"wordfence_email_activity_report\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wpeng_options` VALUES("113", "theme_mods_twentyseventeen", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1573812218;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}}}}", "yes");
INSERT INTO `wpeng_options` VALUES("148", "new_admin_email", "dev@digital4u.gr", "yes");
INSERT INTO `wpeng_options` VALUES("155", "wordfence_version", "7.10.2", "yes");
INSERT INTO `wpeng_options` VALUES("156", "wordfence_installed", "1", "yes");
INSERT INTO `wpeng_options` VALUES("157", "wordfenceActivated", "1", "yes");
INSERT INTO `wpeng_options` VALUES("158", "wf_plugin_act_error", "", "yes");
INSERT INTO `wpeng_options` VALUES("159", "recently_activated", "a:0:{}", "yes");
INSERT INTO `wpeng_options` VALUES("173", "disable_comments_options", "a:6:{s:19:\"disabled_post_types\";a:3:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:10:\"attachment\";}s:17:\"remove_everywhere\";b:1;s:9:\"permanent\";b:0;s:16:\"extra_post_types\";b:0;s:10:\"db_version\";i:7;s:17:\"sitewide_settings\";b:0;}", "yes");
INSERT INTO `wpeng_options` VALUES("181", "wpcf7", "a:2:{s:7:\"version\";s:5:\"5.7.7\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1647340746;s:7:\"version\";s:5:\"5.5.6\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:0;}}", "yes");
INSERT INTO `wpeng_options` VALUES("189", "cookie_notice_options", "a:41:{s:15:\"global_override\";b:0;s:13:\"global_cookie\";b:0;s:6:\"app_id\";s:0:\"\";s:7:\"app_key\";s:0:\"\";s:12:\"app_blocking\";b:1;s:18:\"conditional_active\";b:0;s:19:\"conditional_display\";s:4:\"hide\";s:17:\"conditional_rules\";a:0:{}s:10:\"debug_mode\";b:0;s:8:\"position\";s:6:\"bottom\";s:12:\"message_text\";s:329:\"Χρησιμοποιούμε cookies για να σας προσφέρουμε την καλύτερη δυνατή εμπειρία στη σελίδα μας. Εάν συνεχίσετε να χρησιμοποιείτε τη σελίδα, θα υποθέσουμε πως είστε ικανοποιημένοι με αυτό.\";s:9:\"css_class\";s:6:\"button\";s:11:\"accept_text\";s:14:\"Εντάξει\";s:11:\"refuse_text\";s:6:\"Όχι\";s:10:\"refuse_opt\";b:0;s:11:\"refuse_code\";s:0:\"\";s:16:\"refuse_code_head\";s:0:\"\";s:14:\"revoke_cookies\";b:0;s:18:\"revoke_cookies_opt\";s:9:\"automatic\";s:19:\"revoke_message_text\";s:0:\"\";s:11:\"revoke_text\";s:14:\"Revoke cookies\";s:11:\"redirection\";b:0;s:8:\"see_more\";b:0;s:11:\"link_target\";s:6:\"_blank\";s:13:\"link_position\";s:6:\"banner\";s:4:\"time\";s:5:\"month\";s:13:\"time_rejected\";s:5:\"month\";s:11:\"hide_effect\";s:4:\"fade\";s:9:\"on_scroll\";b:0;s:16:\"on_scroll_offset\";i:100;s:8:\"on_click\";b:0;s:6:\"colors\";a:4:{s:4:\"text\";s:4:\"#fff\";s:6:\"button\";s:7:\"#00a99d\";s:3:\"bar\";s:4:\"#000\";s:11:\"bar_opacity\";i:100;}s:12:\"see_more_opt\";a:5:{s:4:\"text\";s:14:\"Privacy policy\";s:9:\"link_type\";s:4:\"page\";s:2:\"id\";i:0;s:4:\"link\";s:0:\"\";s:4:\"sync\";b:0;}s:16:\"script_placement\";s:6:\"header\";s:9:\"translate\";b:0;s:19:\"deactivation_delete\";b:0;s:14:\"update_version\";i:9;s:13:\"update_notice\";b:1;s:18:\"update_notice_diss\";b:0;s:17:\"update_delay_date\";i:0;s:21:\"update_threshold_date\";i:0;}", "no");
INSERT INTO `wpeng_options` VALUES("190", "cookie_notice_version", "2.4.9", "no");
INSERT INTO `wpeng_options` VALUES("198", "ewww_image_optimizer_background_optimization", "1", "yes");
INSERT INTO `wpeng_options` VALUES("202", "ewww_image_optimizer_disable_pngout", "1", "no");
INSERT INTO `wpeng_options` VALUES("203", "ewww_image_optimizer_optipng_level", "2", "no");
INSERT INTO `wpeng_options` VALUES("204", "ewww_image_optimizer_pngout_level", "2", "no");
INSERT INTO `wpeng_options` VALUES("205", "ewww_image_optimizer_jpegtran_copy", "1", "no");
INSERT INTO `wpeng_options` VALUES("206", "ewww_image_optimizer_jpg_level", "10", "no");
INSERT INTO `wpeng_options` VALUES("207", "ewww_image_optimizer_png_level", "10", "no");
INSERT INTO `wpeng_options` VALUES("208", "ewww_image_optimizer_gif_level", "10", "no");
INSERT INTO `wpeng_options` VALUES("209", "ewww_image_optimizer_pdf_level", "0", "no");
INSERT INTO `wpeng_options` VALUES("210", "exactdn_all_the_things", "1", "no");
INSERT INTO `wpeng_options` VALUES("211", "ewww_image_optimizer_version", "442.0", "yes");
INSERT INTO `wpeng_options` VALUES("221", "ewww_image_optimizer_tracking_notice", "1", "yes");
INSERT INTO `wpeng_options` VALUES("242", "mwp_service_key", "d30d3976-02d7-4836-9def-f457be6bf513", "yes");
INSERT INTO `wpeng_options` VALUES("245", "mwp_openssl_parameters", "a:2:{s:4:\"time\";i:1613789172;s:7:\"working\";b:1;}", "yes");
INSERT INTO `wpeng_options` VALUES("246", "mwp_incremental_update_active", "", "yes");
INSERT INTO `wpeng_options` VALUES("247", "mwp_recovering", "", "yes");
INSERT INTO `wpeng_options` VALUES("248", "mwp_core_autoupdate", "", "yes");
INSERT INTO `wpeng_options` VALUES("249", "mwp_container_parameters", "a:0:{}", "yes");
INSERT INTO `wpeng_options` VALUES("250", "mwp_container_site_parameters", "a:0:{}", "yes");
INSERT INTO `wpeng_options` VALUES("251", "mwp_maintenace_mode", "a:0:{}", "yes");
INSERT INTO `wpeng_options` VALUES("253", "worker_migration_version", "2", "yes");
INSERT INTO `wpeng_options` VALUES("254", "_worker_nossl_key", "", "yes");
INSERT INTO `wpeng_options` VALUES("255", "_worker_public_key", "", "yes");
INSERT INTO `wpeng_options` VALUES("257", "mmb_worker_activation_time", "1535114985", "yes");
INSERT INTO `wpeng_options` VALUES("259", "mwp_public_keys", "a:9:{i:0;a:6:{s:2:\"id\";s:19:\"managewp_1611453901\";s:7:\"service\";s:8:\"managewp\";s:9:\"validFrom\";s:19:\"2021-02-08 01:26:15\";s:7:\"validTo\";s:19:\"2021-03-12 01:26:15\";s:9:\"publicKey\";s:451:\"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA3hF93JuaulKOMOtC+uys\nCCZaLkfNH5NhZmfqyfITyNxj0AwmPr4j61V0MjnH/0v5i9d/UOka7GhPeJCj3d68\n3T+pbrfY4xEcIu5phvhydOIykYAQcMAKyJ9DdtywrMssTLw43oHicVate1sKr/yt\nXyjrs2w7ukpOAfQvqIeOd9vfDYLsYnVQNImSKI8QE8cbOrcOBZRKlVzxROeSKDEo\npYXDXk0Vv2/NKJZjYbLEtBPZnIq9DQ3mIacnooNErfy43gXI2EUlnqBpEqg1K2Zo\nbGAp/laMyfRw62UCRbG7gIRKamSpfF2U7zeZ6FupKJVtXXiHVpEb1dJO6ZsQbQf9\nLQIDAQAB\n-----END PUBLIC KEY-----\n\";s:13:\"useServiceKey\";b:0;}i:1;a:6:{s:2:\"id\";s:23:\"managewp_dev_1611453902\";s:7:\"service\";s:12:\"managewp_dev\";s:9:\"validFrom\";s:19:\"2021-02-08 01:26:15\";s:7:\"validTo\";s:19:\"2021-03-12 01:26:15\";s:9:\"publicKey\";s:451:\"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA2sR2tXZBvt6ZU+IdCF0A\nA9dCli75kIuHg1tiS5IdnfY7fRvDspXj4QqzR8gC98p4opf16eSqYrEHVIbc8sUc\nICV+LE4aIrYY11fJS5gh8tnsPoe8YMwYoCNj76wV+SV9GqV/myvUDfbdDWveEG9v\nQO889BqVy5KPB6meAROXx6hsGxErHbnz0iPhjKkaoV3HRqt9jIuz4ayhO6+b0g6f\nRSJmxruL2skHQxnfhg+hlBg7pSr8ogLYfdZtZGVpjPmJSHuQa2jUtyy81VnbU3Se\n/TM15cjoqSySzWhbAq2nR5V5o8LFYkRh3G0mYFc51T0nln9ztz1dTEqipJC+FIWf\ntQIDAQAB\n-----END PUBLIC KEY-----\n\";s:13:\"useServiceKey\";b:0;}i:2;a:6:{s:2:\"id\";s:16:\"mwp20_1611453902\";s:7:\"service\";s:5:\"mwp20\";s:9:\"validFrom\";s:19:\"2021-02-08 01:26:15\";s:7:\"validTo\";s:19:\"2021-03-12 01:26:15\";s:9:\"publicKey\";s:451:\"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA01Ltn/k7BFSWToKkt/VH\ngrmdWfORNhME0BJf+PPZn1VQm7HBqzO5aBAyHjmx1sF7Dq5AUpkghYoMdAFaBqbU\n/lJK3ObB9pvXcf04/9eIksdc+ojbqjIv1Gg33U05B72hOzKmtgCspGSNYvqUauaS\n/KGtvlTheGQi9GzTVUSDE5M6G6QkfXPkUrT004k4Uo8GqTbNfEGPEqX9//1aw5Vx\neuXLDF/ejKCoRaVvKnLjwHMBBuIfkeIMJwgjZtVKemZTEwk70HEa19sy7UZ4/U1M\njFnH7Fj3MC9pVlPbHiN0qHqP8Kfp1qavGRce6zN/V0llq2M6GgvE7+AlUezLd5to\nmwIDAQAB\n-----END PUBLIC KEY-----\n\";s:13:\"useServiceKey\";b:1;}i:3;a:6:{s:2:\"id\";s:15:\"wpps_1611061501\";s:7:\"service\";s:4:\"wpps\";s:9:\"validFrom\";s:19:\"2021-02-03 13:05:01\";s:7:\"validTo\";s:19:\"2021-03-07 13:05:01\";s:9:\"publicKey\";s:451:\"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA6EIRoy8nBccFaql512/1\nOtsSm19jVENNNp5xOej36WHEqtQxNHYiUWtW5aGMDcGkG1WEX6jBk4d3rtWUNmT/\nrsiyPWNjJFIOUWK4zyTgJNg+ujJbF16U2/uQgscngUAuuJ0DaJyZE78SneoIjgsO\nk73k/qSnwrr7kLkrDJSPK3Ad/wnvYzh0Ww0tDHbdOGRBgfFy3qEnFAG/7b1TaL5p\n9k3MpV3iH2q9bt2hfWPcyaeA1MoK9SuhXLKnC94fJxpNfuvUbnFIi3Fu1KVUlY/R\nvkdoCS0WX9ypXOdPYUdhdyn36GnXwul2ba8qiiQeBqhUuKNC6rQTnEeU6ZUl4zU3\n0QIDAQAB\n-----END PUBLIC KEY-----\n\";s:13:\"useServiceKey\";b:1;}i:4;a:6:{s:2:\"id\";s:15:\"wpps_1613653501\";s:7:\"service\";s:4:\"wpps\";s:9:\"validFrom\";s:19:\"2021-03-05 13:05:01\";s:7:\"validTo\";s:19:\"2021-04-06 13:05:01\";s:9:\"publicKey\";s:451:\"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwTXCNIKzR15bokJ4/DQd\nTuoRvj1DNqykzvWm1Y6ehRj7MgDVJp300pmUBs5dkEztcoFaZTd7mcj8gczfUJX/\n4LCV7f10Ulz3Eppi4V/JbhAzx2OKCSbsZIwolbpxDwfWHb0IX4jNbpjlzbAs3oR4\nUM2MIYHB6HKBrk8yjGli06IbV9oHA+SS8zpvwmHmDJZ3FzNbrKsWnRQzBmrMrh80\nJThB6R8yCNxh5/C+/4w+m7pNnMejrHc4n4qoy2ih6Qvi2JYXGNDbpzljTwxcbfOL\nGiTRyi4aQLqkff67rpwgI3t0ZE+R//ADEZQLYq7pYq06o2HVIgmm45WjCuhfIm0G\n5wIDAQAB\n-----END PUBLIC KEY-----\n\";s:13:\"useServiceKey\";b:1;}i:5;a:6:{s:2:\"id\";s:25:\"cookie_service_1612285502\";s:7:\"service\";s:14:\"cookie_service\";s:9:\"validFrom\";s:19:\"2021-02-17 16:27:25\";s:7:\"validTo\";s:19:\"2021-03-21 16:27:25\";s:9:\"publicKey\";s:451:\"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA0KqvzL3RH1fv555jY9Fg\n++yfNy2X63c2GqA7CzPcq5YZyHBdDx38RLuJkoY4uai2m3/BKmXd4ki/Ti72IfZF\n+Nj+N1Eb0Q5cha6IsvqGVEZ6wuVFZSr/rglzreQKUtlx3RJDevT95dyv3m8dxdnY\nH1xvclxgsAQ6BrdS/tJvJgoE4vVk+ftAVJ/Q6rAwxMPAUl8cVUWjZ6jB2IQubw2s\nkxapu7VI2PUopP2zfbhCrn+ZshjDdGIWMMCMrOuY/MoPz+RUT9DVJVon430sNbqQ\n/VwzJIbmPEj+axEj1UcHbGMRMf+kFcSUBWM3gsTQ9rud2HqoMOU5mKpbq8JoGTmc\nGwIDAQAB\n-----END PUBLIC KEY-----\n\";s:13:\"useServiceKey\";b:1;}i:6;a:6:{s:2:\"id\";s:15:\"mwp1_1611151502\";s:7:\"service\";s:4:\"mwp1\";s:9:\"validFrom\";s:19:\"2021-02-04 14:05:01\";s:7:\"validTo\";s:19:\"2021-03-08 14:05:01\";s:9:\"publicKey\";s:451:\"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA6f1ww6iqo1dncWlpJ9OM\n4APLx1a8yFClAZn14+c1muJ4BUW7dyjW57B68jvddO+tUwBn4bWoyW7VgTjZjWni\nVFzeQ6TBnR3QMLTFk1znXjPuWXnGEbicovat0vScIcZ/0wPSBBtmF5oUrUyumn3B\nGvCHhq20qskZcVTz7gUVrIf9irvqsV/PBCfCHCZJvoc9kTWRNoLNZCG2n7JpPcs2\nRi4mb2CmemypiZMo2abQFZIpcYxO+cVXl0u7dWcbeza1964H0RtAL7Lu/HRlM1rT\nqclDpjCKwXsGH1bdVFlSxxSc4Ue1HxR1sxcVgJONf2pxBLLvU2IcNisl/bendiOC\nDQIDAQAB\n-----END PUBLIC KEY-----\n\";s:13:\"useServiceKey\";b:1;}i:7;a:6:{s:2:\"id\";s:15:\"mwp1_1613743502\";s:7:\"service\";s:4:\"mwp1\";s:9:\"validFrom\";s:19:\"2021-03-06 14:05:01\";s:7:\"validTo\";s:19:\"2021-04-07 14:05:01\";s:9:\"publicKey\";s:451:\"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA/FNadrDuSMfP7OxnG/Z0\nqSPZVfLHnS3ge0oo53tT+emsQxQOncf098GRft+zun5vbWkhEkpDL1kHJEBlR16P\nmCvJ1kGsIwA2gdcNeoRhIk4yjokRsUU48/brPrPomBFOXANaKcDeRPzUFG+T1iwL\nvv3QJP6xH/WQdUocza5hpS19OzHpJL85/xZOEuaRoLb7eOcwBioEJK0IpH65GDOQ\n/J84b+pktu6UHFPLs2lm20ag/IbmF4Wyujx1a19u3GjYT7aVBe1kNKDn6tBcEvA6\ndVxdwAiuPORcEQqkD5X2DKcyHUOAWs1hp/U8eF+1rGC0yTnzE4xwO7u9qS8dTe74\nvQIDAQAB\n-----END PUBLIC KEY-----\n\";s:13:\"useServiceKey\";b:1;}i:8;a:6:{s:2:\"id\";s:20:\"migration_1611410701\";s:7:\"service\";s:9:\"migration\";s:9:\"validFrom\";s:19:\"2021-02-07 13:05:02\";s:7:\"validTo\";s:19:\"2021-03-11 13:05:02\";s:9:\"publicKey\";s:451:\"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAzOLQCOiNlMcCN5nc2PRJ\ng245K7nIruBZiX9Lxn3Wdg4HbqIaof93xGP+MFk42fmVMKdmTDrGBVs+0MtnKTiF\n8xb8iBkShSY/5QnLR+yn4AfPlaaHX3bdHmxJMKzz5rtwgB1JM2CqQkkBte9nfoeL\nvoYirbqB2h59bp6u7pcRNMs0nzNhO2Q/Li0/+rvTbzQKlW0VKbft1TcCmwDIdldg\n0FTweG1muKuVmGAvVaUhtP0NuOx7HRLWQtCUm7q4kolVgdQ3Spv7M5eG4dVFtfGE\nPjCFxchfl9W4AKliTeewzEgJtpwpkYdIJwl05ObCsthU3UYvPdduTwss4QQeppjG\nxQIDAQAB\n-----END PUBLIC KEY-----\n\";s:13:\"useServiceKey\";b:1;}}", "yes");
INSERT INTO `wpeng_options` VALUES("262", "mwp_communication_key", "453a9082-0586-49ab-af6e-a9f88a1b0a50", "yes");
INSERT INTO `wpeng_options` VALUES("263", "mmb_stats_filter", "a:1:{s:7:\"plugins\";a:1:{s:7:\"cleanup\";a:1:{s:9:\"revisions\";a:1:{s:11:\"num_to_keep\";i:5;}}}}", "yes");
INSERT INTO `wpeng_options` VALUES("266", "user_hit_count", "a:45:{s:10:\"2020-12-07\";i:1;s:10:\"2020-12-08\";i:6;s:10:\"2020-12-09\";i:6;s:10:\"2020-12-10\";i:2;s:10:\"2020-12-12\";i:1;s:10:\"2020-12-13\";i:1;s:10:\"2020-12-15\";i:1;s:10:\"2020-12-17\";i:4;s:10:\"2020-12-18\";i:3;s:10:\"2020-12-20\";i:1;s:10:\"2020-12-22\";i:2;s:10:\"2020-12-25\";i:2;s:10:\"2020-12-27\";i:1;s:10:\"2020-12-28\";i:1;s:10:\"2020-12-31\";i:2;s:10:\"2021-01-01\";i:1;s:10:\"2021-01-02\";i:6;s:10:\"2021-01-03\";i:1;s:10:\"2021-01-04\";i:1;s:10:\"2021-01-06\";i:2;s:10:\"2021-01-08\";i:1;s:10:\"2021-01-09\";i:3;s:10:\"2021-01-10\";i:1;s:10:\"2021-01-11\";i:1;s:10:\"2021-01-12\";i:1;s:10:\"2021-01-13\";i:1;s:10:\"2021-01-14\";i:2;s:10:\"2021-01-15\";i:2;s:10:\"2021-01-16\";i:1;s:10:\"2021-01-17\";i:1;s:10:\"2021-01-18\";i:1;s:10:\"2021-01-21\";i:3;s:10:\"2021-01-22\";i:3;s:10:\"2021-01-23\";i:1;s:10:\"2021-01-24\";i:1;s:10:\"2021-01-26\";i:2;s:10:\"2021-01-27\";i:2;s:10:\"2021-01-28\";i:4;s:10:\"2021-01-29\";i:2;s:10:\"2021-01-30\";i:1;s:10:\"2021-01-31\";i:2;s:10:\"2021-02-01\";i:1;s:10:\"2021-02-02\";i:2;s:10:\"2021-02-03\";i:4;s:10:\"2021-02-04\";i:2;}", "yes");
INSERT INTO `wpeng_options` VALUES("274", "mwp_pro_connected", "pro_sites", "yes");
INSERT INTO `wpeng_options` VALUES("279", "category_children", "a:0:{}", "yes");
INSERT INTO `wpeng_options` VALUES("284", "duplicator_settings", "a:16:{s:7:\"version\";s:7:\"1.5.5.1\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:13:\"package_debug\";b:0;s:17:\"package_mysqldump\";s:1:\"1\";s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";s:1:\"1\";s:19:\"installer_name_mode\";s:6:\"simple\";s:16:\"storage_position\";s:6:\"legacy\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";s:1:\"2\";s:17:\"skip_archive_scan\";b:0;s:21:\"unhook_third_party_js\";b:0;s:22:\"unhook_third_party_css\";b:0;s:17:\"active_package_id\";i:16;}", "yes");
INSERT INTO `wpeng_options` VALUES("285", "duplicator_version_plugin", "1.5.5.1", "yes");
INSERT INTO `wpeng_options` VALUES("289", "wpseo", "a:105:{s:8:\"tracking\";b:0;s:16:\"toggled_tracking\";b:0;s:22:\"license_server_version\";s:1:\"2\";s:15:\"ms_defaults_set\";b:0;s:40:\"ignore_search_engines_discouraged_notice\";b:1;s:19:\"indexing_first_time\";b:1;s:16:\"indexing_started\";b:0;s:15:\"indexing_reason\";s:0:\"\";s:29:\"indexables_indexing_completed\";b:1;s:13:\"index_now_key\";s:0:\"\";s:7:\"version\";s:5:\"20.12\";s:16:\"previous_version\";s:5:\"20.10\";s:20:\"disableadvanced_meta\";b:1;s:30:\"enable_headless_rest_endpoints\";b:1;s:17:\"ryte_indexability\";b:0;s:11:\"baiduverify\";s:0:\"\";s:12:\"googleverify\";s:0:\"\";s:8:\"msverify\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";s:9:\"site_type\";s:0:\"\";s:20:\"has_multiple_authors\";s:0:\"\";s:16:\"environment_type\";s:0:\"\";s:23:\"content_analysis_active\";b:1;s:23:\"keyword_analysis_active\";b:1;s:34:\"inclusive_language_analysis_active\";b:0;s:21:\"enable_admin_bar_menu\";b:1;s:26:\"enable_cornerstone_content\";b:1;s:18:\"enable_xml_sitemap\";b:1;s:24:\"enable_text_link_counter\";b:1;s:16:\"enable_index_now\";b:1;s:22:\"show_onboarding_notice\";b:1;s:18:\"first_activated_on\";i:1535116235;s:13:\"myyoast-oauth\";b:0;s:26:\"semrush_integration_active\";b:1;s:14:\"semrush_tokens\";a:0:{}s:20:\"semrush_country_code\";s:2:\"us\";s:19:\"permalink_structure\";s:12:\"/%postname%/\";s:8:\"home_url\";s:38:\"https://wordpress.engine.gp.demod4u.gr\";s:18:\"dynamic_permalinks\";b:0;s:17:\"category_base_url\";s:0:\"\";s:12:\"tag_base_url\";s:0:\"\";s:21:\"custom_taxonomy_slugs\";a:0:{}s:29:\"enable_enhanced_slack_sharing\";b:1;s:25:\"zapier_integration_active\";b:1;s:19:\"zapier_subscription\";a:0:{}s:14:\"zapier_api_key\";s:0:\"\";s:23:\"enable_metabox_insights\";b:1;s:23:\"enable_link_suggestions\";b:1;s:26:\"algolia_integration_active\";b:0;s:14:\"import_cursors\";a:0:{}s:13:\"workouts_data\";a:1:{s:13:\"configuration\";a:1:{s:13:\"finishedSteps\";a:0:{}}}s:28:\"configuration_finished_steps\";a:0:{}s:36:\"dismiss_configuration_workout_notice\";b:0;s:34:\"dismiss_premium_deactivated_notice\";b:0;s:19:\"importing_completed\";a:0:{}s:26:\"wincher_integration_active\";b:1;s:14:\"wincher_tokens\";a:0:{}s:36:\"wincher_automatically_add_keyphrases\";b:0;s:18:\"wincher_website_id\";s:0:\"\";s:28:\"wordproof_integration_active\";b:0;s:29:\"wordproof_integration_changed\";b:0;s:18:\"first_time_install\";b:0;s:34:\"should_redirect_after_install_free\";b:0;s:34:\"activation_redirect_timestamp_free\";i:1652258756;s:18:\"remove_feed_global\";b:0;s:27:\"remove_feed_global_comments\";b:0;s:25:\"remove_feed_post_comments\";b:0;s:19:\"remove_feed_authors\";b:0;s:22:\"remove_feed_categories\";b:0;s:16:\"remove_feed_tags\";b:0;s:29:\"remove_feed_custom_taxonomies\";b:0;s:22:\"remove_feed_post_types\";b:0;s:18:\"remove_feed_search\";b:0;s:21:\"remove_atom_rdf_feeds\";b:0;s:17:\"remove_shortlinks\";b:0;s:21:\"remove_rest_api_links\";b:0;s:20:\"remove_rsd_wlw_links\";b:0;s:19:\"remove_oembed_links\";b:0;s:16:\"remove_generator\";b:0;s:20:\"remove_emoji_scripts\";b:0;s:24:\"remove_powered_by_header\";b:0;s:22:\"remove_pingback_header\";b:0;s:28:\"clean_campaign_tracking_urls\";b:0;s:16:\"clean_permalinks\";b:0;s:32:\"clean_permalinks_extra_variables\";s:0:\"\";s:14:\"search_cleanup\";b:0;s:20:\"search_cleanup_emoji\";b:0;s:23:\"search_cleanup_patterns\";b:0;s:22:\"search_character_limit\";i:50;s:20:\"deny_search_crawling\";b:0;s:21:\"deny_wp_json_crawling\";b:0;s:20:\"deny_adsbot_crawling\";b:0;s:27:\"redirect_search_pretty_urls\";b:0;s:29:\"least_readability_ignore_list\";a:0:{}s:27:\"least_seo_score_ignore_list\";a:0:{}s:23:\"most_linked_ignore_list\";a:0:{}s:24:\"least_linked_ignore_list\";a:0:{}s:28:\"indexables_page_reading_list\";a:5:{i:0;b:0;i:1;b:0;i:2;b:0;i:3;b:0;i:4;b:0;}s:25:\"indexables_overview_state\";s:21:\"dashboard-not-visited\";s:28:\"last_known_public_post_types\";a:3:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:10:\"attachment\";}s:28:\"last_known_public_taxonomies\";a:3:{i:0;s:8:\"category\";i:1;s:8:\"post_tag\";i:2;s:11:\"post_format\";}s:23:\"last_known_no_unindexed\";a:4:{s:40:\"wpseo_total_unindexed_post_type_archives\";i:1690445481;s:35:\"wpseo_total_unindexed_general_items\";i:1690445481;s:31:\"wpseo_unindexed_post_link_count\";i:1690445481;s:31:\"wpseo_unindexed_term_link_count\";i:1690445481;}s:14:\"new_post_types\";a:0:{}s:14:\"new_taxonomies\";a:0:{}s:34:\"show_new_content_type_notification\";b:0;}", "yes");
INSERT INTO `wpeng_options` VALUES("290", "wpseo_titles", "a:107:{s:17:\"forcerewritetitle\";b:0;s:9:\"separator\";s:7:\"sc-dash\";s:16:\"title-home-wpseo\";s:42:\"%%sitename%% %%page%% %%sep%% %%sitedesc%%\";s:18:\"title-author-wpseo\";s:41:\"%%name%%, Author at %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:63:\"You searched for %%searchphrase%% %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:35:\"Page not found %%sep%% %%sitename%%\";s:25:\"social-title-author-wpseo\";s:8:\"%%name%%\";s:26:\"social-title-archive-wpseo\";s:8:\"%%date%%\";s:31:\"social-description-author-wpseo\";s:0:\"\";s:32:\"social-description-archive-wpseo\";s:0:\"\";s:29:\"social-image-url-author-wpseo\";s:0:\"\";s:30:\"social-image-url-archive-wpseo\";s:0:\"\";s:28:\"social-image-id-author-wpseo\";i:0;s:29:\"social-image-id-archive-wpseo\";i:0;s:19:\"metadesc-home-wpseo\";s:0:\"\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:53:\"The post %%POSTLINK%% appeared first on %%BLOGLINK%%.\";s:20:\"noindex-author-wpseo\";b:0;s:28:\"noindex-author-noposts-wpseo\";b:1;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:0;s:12:\"disable-date\";b:0;s:19:\"disable-post_format\";b:0;s:18:\"disable-attachment\";b:1;s:23:\"is-media-purge-relevant\";b:0;s:20:\"breadcrumbs-404crumb\";s:25:\"Error 404: Page not found\";s:29:\"breadcrumbs-display-blog-page\";b:1;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:12:\"Archives for\";s:18:\"breadcrumbs-enable\";b:0;s:16:\"breadcrumbs-home\";s:4:\"Home\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:16:\"You searched for\";s:15:\"breadcrumbs-sep\";s:7:\"&raquo;\";s:12:\"website_name\";s:0:\"\";s:11:\"person_name\";s:0:\"\";s:11:\"person_logo\";s:0:\"\";s:22:\"alternate_website_name\";s:0:\"\";s:12:\"company_logo\";s:0:\"\";s:12:\"company_name\";s:0:\"\";s:17:\"company_or_person\";s:7:\"company\";s:25:\"company_or_person_user_id\";b:0;s:17:\"stripcategorybase\";b:0;s:26:\"open_graph_frontpage_title\";s:12:\"%%sitename%%\";s:25:\"open_graph_frontpage_desc\";s:0:\"\";s:26:\"open_graph_frontpage_image\";s:0:\"\";s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"noindex-post\";b:0;s:23:\"display-metabox-pt-post\";b:1;s:23:\"post_types-post-maintax\";i:0;s:21:\"schema-page-type-post\";s:7:\"WebPage\";s:24:\"schema-article-type-post\";s:7:\"Article\";s:17:\"social-title-post\";s:9:\"%%title%%\";s:23:\"social-description-post\";s:0:\"\";s:21:\"social-image-url-post\";s:0:\"\";s:20:\"social-image-id-post\";i:0;s:10:\"title-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:23:\"display-metabox-pt-page\";b:1;s:23:\"post_types-page-maintax\";i:0;s:21:\"schema-page-type-page\";s:7:\"WebPage\";s:24:\"schema-article-type-page\";s:4:\"None\";s:17:\"social-title-page\";s:9:\"%%title%%\";s:23:\"social-description-page\";s:0:\"\";s:21:\"social-image-url-page\";s:0:\"\";s:20:\"social-image-id-page\";i:0;s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:29:\"display-metabox-pt-attachment\";b:1;s:29:\"post_types-attachment-maintax\";i:0;s:27:\"schema-page-type-attachment\";s:7:\"WebPage\";s:30:\"schema-article-type-attachment\";s:4:\"None\";s:18:\"title-tax-category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:28:\"display-metabox-tax-category\";b:1;s:20:\"noindex-tax-category\";b:0;s:25:\"social-title-tax-category\";s:27:\"%%term_title%% Αρχεία\";s:31:\"social-description-tax-category\";s:0:\"\";s:29:\"social-image-url-tax-category\";s:0:\"\";s:28:\"social-image-id-tax-category\";i:0;s:18:\"title-tax-post_tag\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:28:\"display-metabox-tax-post_tag\";b:1;s:20:\"noindex-tax-post_tag\";b:0;s:25:\"social-title-tax-post_tag\";s:27:\"%%term_title%% Αρχεία\";s:31:\"social-description-tax-post_tag\";s:0:\"\";s:29:\"social-image-url-tax-post_tag\";s:0:\"\";s:28:\"social-image-id-tax-post_tag\";i:0;s:21:\"title-tax-post_format\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:31:\"display-metabox-tax-post_format\";b:1;s:23:\"noindex-tax-post_format\";b:1;s:28:\"social-title-tax-post_format\";s:27:\"%%term_title%% Αρχεία\";s:34:\"social-description-tax-post_format\";s:0:\"\";s:32:\"social-image-url-tax-post_format\";s:0:\"\";s:31:\"social-image-id-tax-post_format\";i:0;s:14:\"person_logo_id\";i:0;s:15:\"company_logo_id\";i:0;s:17:\"company_logo_meta\";b:0;s:16:\"person_logo_meta\";b:0;s:29:\"open_graph_frontpage_image_id\";i:0;}", "yes");
INSERT INTO `wpeng_options` VALUES("291", "wpseo_social", "a:18:{s:13:\"facebook_site\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:16:\"og_default_image\";s:0:\"\";s:19:\"og_default_image_id\";s:0:\"\";s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:21:\"og_frontpage_image_id\";s:0:\"\";s:9:\"opengraph\";b:1;s:13:\"pinterest_url\";s:0:\"\";s:15:\"pinterestverify\";s:0:\"\";s:7:\"twitter\";b:1;s:12:\"twitter_site\";s:0:\"\";s:17:\"twitter_card_type\";s:19:\"summary_large_image\";s:11:\"youtube_url\";s:0:\"\";s:13:\"wikipedia_url\";s:0:\"\";}", "yes");
INSERT INTO `wpeng_options` VALUES("292", "wpseo_flush_rewrite", "1", "yes");
INSERT INTO `wpeng_options` VALUES("303", "mwp_new_communication_established", "1", "yes");
INSERT INTO `wpeng_options` VALUES("495", "duplicator_ui_view_state", "a:9:{s:22:\"dup-pack-storage-panel\";s:1:\"1\";s:22:\"dup-pack-archive-panel\";s:1:\"1\";s:24:\"dup-pack-installer-panel\";s:1:\"1\";s:29:\"dup-package-dtl-general-panel\";s:1:\"1\";s:29:\"dup-package-dtl-install-panel\";s:1:\"1\";s:29:\"dup-package-dtl-archive-panel\";s:1:\"1\";s:29:\"dup-package-dtl-storage-panel\";s:1:\"1\";s:28:\"dup-settings-diag-opts-panel\";s:1:\"0\";s:27:\"dup-settings-diag-srv-panel\";s:1:\"0\";}", "yes");
INSERT INTO `wpeng_options` VALUES("496", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-07-27 09:01:47\";s:7:\"Version\";s:7:\"1.5.5.1\";s:9:\"VersionWP\";s:5:\"6.2.2\";s:9:\"VersionDB\";s:6:\"5.7.43\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:11:\"oneservices\";s:4:\"Hash\";s:35:\"b94f130381fcc2e31360_20230727090147\";s:8:\"NameHash\";s:47:\"oneservices_b94f130381fcc2e31360_20230727090147\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:57:\"oneservices_b94f130381fcc2e31360_20230727090147_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:58:\"/home/demod4u/public_html/wordpress.engine.gp/wp-snapshots\";s:11:\"FilterFiles\";s:62:\"/home/demod4u/public_html/wordpress.engine.gp/wp-content/cache\";s:10:\"FilterExts\";s:22:\"zip;rar;tar;gz;bz2;7z;\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:1;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:45:\"/home/demod4u/public_html/wordpress.engine.gp\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1405;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:7846;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-07-27 09:01:47\";s:7:\"Version\";s:7:\"1.5.5.1\";s:9:\"VersionWP\";s:5:\"6.2.2\";s:9:\"VersionDB\";s:6:\"5.7.43\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:11:\"oneservices\";s:4:\"Hash\";s:35:\"b94f130381fcc2e31360_20230727090147\";s:8:\"NameHash\";s:47:\"oneservices_b94f130381fcc2e31360_20230727090147\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:59:\"/home/demod4u/public_html/wordpress.engine.gp/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:19:\"sameNameTableExists\";N;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:18:\"varLowerCaseTables\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:65;s:24:\"\0DUP_Database\0tempDbPath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";s:1:\"1\";}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:54:\"/home/demod4u/public_html/wordpress.engine.gp/wp-admin\";i:1;s:57:\"/home/demod4u/public_html/wordpress.engine.gp/wp-includes\";i:2;s:66:\"/home/demod4u/public_html/wordpress.engine.gp/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:45:\"/home/demod4u/public_html/wordpress.engine.gp\";i:1;s:45:\"/home/demod4u/public_html/wordpress.engine.gp\";i:2;s:56:\"/home/demod4u/public_html/wordpress.engine.gp/wp-content\";i:3;s:64:\"/home/demod4u/public_html/wordpress.engine.gp/wp-content/uploads\";i:4;s:64:\"/home/demod4u/public_html/wordpress.engine.gp/wp-content/plugins\";i:5;s:67:\"/home/demod4u/public_html/wordpress.engine.gp/wp-content/mu-plugins\";i:6;s:63:\"/home/demod4u/public_html/wordpress.engine.gp/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:62:\"/home/demod4u/public_html/wordpress.engine.gp/wp-snapshots/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}", "yes");
INSERT INTO `wpeng_options` VALUES("827", "ewww_image_optimizer_bulk_attachments", "", "no");
INSERT INTO `wpeng_options` VALUES("828", "ewww_image_optimizer_flag_attachments", "", "no");
INSERT INTO `wpeng_options` VALUES("829", "ewww_image_optimizer_ngg_attachments", "", "no");
INSERT INTO `wpeng_options` VALUES("830", "ewww_image_optimizer_metadata_remove", "1", "no");
INSERT INTO `wpeng_options` VALUES("831", "exactdn_lossy", "1", "no");
INSERT INTO `wpeng_options` VALUES("961", "resmushit_qlty", "92", "yes");
INSERT INTO `wpeng_options` VALUES("962", "resmushit_on_upload", "1", "yes");
INSERT INTO `wpeng_options` VALUES("963", "resmushit_statistics", "1", "yes");
INSERT INTO `wpeng_options` VALUES("964", "resmushit_total_optimized", "11", "yes");
INSERT INTO `wpeng_options` VALUES("1444", "db_upgraded", "", "yes");
INSERT INTO `wpeng_options` VALUES("1844", "mwp_key_last_used_any", "1613828252", "yes");
INSERT INTO `wpeng_options` VALUES("1845", "mwp_communication_keys", "a:1:{i:2371149;a:2:{s:3:\"key\";s:36:\"453a9082-0586-49ab-af6e-a9f88a1b0a50\";s:5:\"added\";i:1551800001;}}", "yes");
INSERT INTO `wpeng_options` VALUES("1846", "mwp_key_last_used_453a9082-0586-49ab-af6e-a9f88a1b0a50", "1551800001", "yes");
INSERT INTO `wpeng_options` VALUES("1850", "mwp_potential_key", "d02a5bde-c4e3-4cc4-9594-2aaa1bc14a0f", "yes");
INSERT INTO `wpeng_options` VALUES("1851", "mwp_potential_key_time", "1613789172", "yes");
INSERT INTO `wpeng_options` VALUES("1855", "mwp_public_keys_refresh_time", "1613789177", "yes");
INSERT INTO `wpeng_options` VALUES("1871", "mwp_key_last_used_2371149", "1613620671", "yes");
INSERT INTO `wpeng_options` VALUES("1972", "emr_news", "1", "yes");
INSERT INTO `wpeng_options` VALUES("1986", "hide_my_site_plk", "", "yes");
INSERT INTO `wpeng_options` VALUES("1987", "hide_my_site_enabled", "1", "yes");
INSERT INTO `wpeng_options` VALUES("1988", "hide_my_site_password", "!@lockdown@!", "yes");
INSERT INTO `wpeng_options` VALUES("1989", "hide_my_site_password_hint", "", "yes");
INSERT INTO `wpeng_options` VALUES("1990", "hide_my_site_duration", "1", "yes");
INSERT INTO `wpeng_options` VALUES("1991", "hide_my_site_bruteforce", "1", "yes");
INSERT INTO `wpeng_options` VALUES("1992", "hide_my_site_allow_ips", "", "yes");
INSERT INTO `wpeng_options` VALUES("1993", "hide_my_site_custom_messaging_banner", "", "yes");
INSERT INTO `wpeng_options` VALUES("1994", "hide_my_site_custom_messaging_banner_override", "", "yes");
INSERT INTO `wpeng_options` VALUES("1995", "hide_my_site_pagetitle", "Password Protected Site", "yes");
INSERT INTO `wpeng_options` VALUES("1996", "hide_my_site_allow_admin", "1", "yes");
INSERT INTO `wpeng_options` VALUES("1997", "hide_my_site_public_rss", "", "yes");
INSERT INTO `wpeng_options` VALUES("1998", "hide_my_site_prev", "", "yes");
INSERT INTO `wpeng_options` VALUES("1999", "hide_my_site_current_theme", "hmsclassic", "yes");
INSERT INTO `wpeng_options` VALUES("2000", "hide_my_site_custom_background_image_upload", "", "yes");
INSERT INTO `wpeng_options` VALUES("2001", "hide_my_site_custom_background_image_position", "", "yes");
INSERT INTO `wpeng_options` VALUES("2002", "hide_my_site_background_color", "", "yes");
INSERT INTO `wpeng_options` VALUES("2003", "hide_my_site_custom_css", "", "yes");
INSERT INTO `wpeng_options` VALUES("2006", "hide_my_site_cookie2suffix", "3cf9165a26648cffd04eda38a9c3299217642e5ff49d5ee43ff84464afb6f5cd", "yes");
INSERT INTO `wpeng_options` VALUES("2029", "wpseo_upgrade_history", "a:1:{i:1554213287;a:3:{s:7:\"options\";a:3:{s:5:\"wpseo\";a:20:{s:15:\"ms_defaults_set\";b:0;s:7:\"version\";s:6:\"10.0.1\";s:20:\"disableadvanced_meta\";b:1;s:19:\"onpage_indexability\";b:1;s:11:\"baiduverify\";s:0:\"\";s:12:\"googleverify\";s:0:\"\";s:8:\"msverify\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";s:9:\"site_type\";s:0:\"\";s:20:\"has_multiple_authors\";s:0:\"\";s:16:\"environment_type\";s:0:\"\";s:23:\"content_analysis_active\";b:1;s:23:\"keyword_analysis_active\";b:1;s:21:\"enable_admin_bar_menu\";b:1;s:26:\"enable_cornerstone_content\";b:1;s:18:\"enable_xml_sitemap\";b:1;s:24:\"enable_text_link_counter\";b:1;s:22:\"show_onboarding_notice\";b:1;s:18:\"first_activated_on\";i:1535116235;s:13:\"myyoast-oauth\";a:2:{s:6:\"config\";a:2:{s:8:\"clientId\";N;s:6:\"secret\";N;}s:13:\"access_tokens\";a:0:{}}}s:12:\"wpseo_social\";a:18:{s:13:\"facebook_site\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:16:\"og_default_image\";s:0:\"\";s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:9:\"opengraph\";b:1;s:13:\"pinterest_url\";s:0:\"\";s:15:\"pinterestverify\";s:0:\"\";s:14:\"plus-publisher\";s:0:\"\";s:7:\"twitter\";b:1;s:12:\"twitter_site\";s:0:\"\";s:17:\"twitter_card_type\";s:19:\"summary_large_image\";s:11:\"youtube_url\";s:0:\"\";s:15:\"google_plus_url\";s:0:\"\";s:10:\"fbadminapp\";s:0:\"\";}s:12:\"wpseo_titles\";a:65:{s:10:\"title_test\";i:0;s:17:\"forcerewritetitle\";b:0;s:9:\"separator\";s:7:\"sc-dash\";s:16:\"title-home-wpseo\";s:42:\"%%sitename%% %%page%% %%sep%% %%sitedesc%%\";s:18:\"title-author-wpseo\";s:41:\"%%name%%, Author at %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:63:\"You searched for %%searchphrase%% %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:35:\"Page not found %%sep%% %%sitename%%\";s:19:\"metadesc-home-wpseo\";s:0:\"\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:53:\"The post %%POSTLINK%% appeared first on %%BLOGLINK%%.\";s:20:\"noindex-author-wpseo\";b:0;s:28:\"noindex-author-noposts-wpseo\";b:1;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:0;s:12:\"disable-date\";b:0;s:19:\"disable-post_format\";b:0;s:18:\"disable-attachment\";b:1;s:23:\"is-media-purge-relevant\";b:0;s:20:\"breadcrumbs-404crumb\";s:25:\"Error 404: Page not found\";s:29:\"breadcrumbs-display-blog-page\";b:1;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:12:\"Archives for\";s:18:\"breadcrumbs-enable\";b:0;s:16:\"breadcrumbs-home\";s:4:\"Home\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:16:\"You searched for\";s:15:\"breadcrumbs-sep\";s:7:\"&raquo;\";s:12:\"website_name\";s:0:\"\";s:11:\"person_name\";s:0:\"\";s:22:\"alternate_website_name\";s:0:\"\";s:12:\"company_logo\";s:0:\"\";s:12:\"company_name\";s:0:\"\";s:17:\"company_or_person\";s:0:\"\";s:17:\"stripcategorybase\";b:0;s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"noindex-post\";b:0;s:13:\"showdate-post\";b:0;s:23:\"display-metabox-pt-post\";b:1;s:10:\"title-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:13:\"showdate-page\";b:0;s:23:\"display-metabox-pt-page\";b:1;s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:19:\"showdate-attachment\";b:0;s:29:\"display-metabox-pt-attachment\";b:1;s:18:\"title-tax-category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:28:\"display-metabox-tax-category\";b:1;s:20:\"noindex-tax-category\";b:0;s:18:\"title-tax-post_tag\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:28:\"display-metabox-tax-post_tag\";b:1;s:20:\"noindex-tax-post_tag\";b:0;s:21:\"title-tax-post_format\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:31:\"display-metabox-tax-post_format\";b:1;s:23:\"noindex-tax-post_format\";b:1;s:23:\"post_types-post-maintax\";i:0;}}s:11:\"old_version\";s:6:\"10.0.1\";s:11:\"new_version\";s:6:\"10.1.1\";}}", "no");
INSERT INTO `wpeng_options` VALUES("2268", "recovery_keys", "a:0:{}", "yes");
INSERT INTO `wpeng_options` VALUES("2555", "wordfence_syncAttackDataAttempts", "0", "no");
INSERT INTO `wpeng_options` VALUES("2556", "wordfence_syncingAttackData", "0", "no");
INSERT INTO `wpeng_options` VALUES("2559", "wordfence_lastSyncAttackData", "1690447823", "no");
INSERT INTO `wpeng_options` VALUES("3864", "cookie_notice_activation_date", "1573632957", "yes");
INSERT INTO `wpeng_options` VALUES("3875", "admin_email_lifespan", "1693208664", "yes");
INSERT INTO `wpeng_options` VALUES("3919", "current_theme", "GeneratePress Child", "yes");
INSERT INTO `wpeng_options` VALUES("3920", "theme_mods_twentytwenty", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1651574542;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:2:{i:0;s:6:\"text-2\";i:1;s:6:\"text-3\";}s:9:\"sidebar-1\";a:5:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}}}}", "yes");
INSERT INTO `wpeng_options` VALUES("3921", "theme_switched", "", "yes");
INSERT INTO `wpeng_options` VALUES("4617", "resmushit_preserve_exif", "0", "yes");
INSERT INTO `wpeng_options` VALUES("4618", "resmushit_remove_unsmushed", "0", "yes");
INSERT INTO `wpeng_options` VALUES("4619", "resmushit_has_no_backup_files", "0", "yes");
INSERT INTO `wpeng_options` VALUES("4912", "wpseo_ryte", "a:2:{s:6:\"status\";i:0;s:10:\"last_fetch\";i:1583502948;}", "yes");
INSERT INTO `wpeng_options` VALUES("5612", "yoast_migrations_free", "a:1:{s:7:\"version\";s:5:\"20.12\";}", "yes");
INSERT INTO `wpeng_options` VALUES("5622", "cfdb7_view_install_date", "2020-05-05 8:18:02", "yes");
INSERT INTO `wpeng_options` VALUES("5776", "duplicator_lite_inst_hash_notice", "1", "yes");
INSERT INTO `wpeng_options` VALUES("6590", "duplicator_new_storage_position", "1", "yes");
INSERT INTO `wpeng_options` VALUES("7937", "resmushit_cron", "0", "yes");
INSERT INTO `wpeng_options` VALUES("7938", "resmushit_cron_lastaction", "0", "yes");
INSERT INTO `wpeng_options` VALUES("7939", "resmushit_cron_lastrun", "0", "yes");
INSERT INTO `wpeng_options` VALUES("7940", "resmushit_cron_firstactivation", "0", "yes");
INSERT INTO `wpeng_options` VALUES("8174", "disallowed_keys", "", "no");
INSERT INTO `wpeng_options` VALUES("8175", "comment_previously_approved", "1", "yes");
INSERT INTO `wpeng_options` VALUES("8176", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `wpeng_options` VALUES("8177", "finished_updating_comment_type", "1", "yes");
INSERT INTO `wpeng_options` VALUES("8275", "wpdg_specific_version_name", "5.4.2", "yes");
INSERT INTO `wpeng_options` VALUES("8276", "wpdg_download_url", "", "yes");
INSERT INTO `wpeng_options` VALUES("8277", "wpdg_edit_download_url", "", "yes");
INSERT INTO `wpeng_options` VALUES("9327", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `wpeng_options` VALUES("9328", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `wpeng_options` VALUES("9329", "auto_update_core_major", "unset", "yes");
INSERT INTO `wpeng_options` VALUES("10125", "webpc_notice_hidden", "1611072033", "yes");
INSERT INTO `wpeng_options` VALUES("10126", "webpc_is_new_installation", "0", "yes");
INSERT INTO `wpeng_options` VALUES("10127", "webpc_latest_version", "5.7.1", "yes");
INSERT INTO `wpeng_options` VALUES("10283", "webpc_settings", "a:6:{s:11:\"loader_type\";s:8:\"htaccess\";s:10:\"extensions\";a:3:{i:0;s:3:\"jpg\";i:1;s:4:\"jpeg\";i:2;s:3:\"png\";}s:4:\"dirs\";a:1:{i:0;s:7:\"uploads\";}s:6:\"method\";s:2:\"gd\";s:8:\"features\";a:3:{i:0;s:12:\"only_smaller\";i:1;s:11:\"mod_expires\";i:2;s:13:\"debug_enabled\";}s:7:\"quality\";i:85;}", "yes");
INSERT INTO `wpeng_options` VALUES("10454", "mwp_worker_configuration", "a:9:{s:10:\"master_url\";s:21:\"https://managewp.com/\";s:15:\"master_cron_url\";s:75:\"https://managewp.com/wp-content/plugins/master/mwp-notifications-handle.php\";s:20:\"noti_cache_life_time\";s:5:\"86400\";s:27:\"noti_treshold_spam_comments\";s:2:\"10\";s:30:\"noti_treshold_pending_comments\";s:1:\"0\";s:31:\"noti_treshold_approved_comments\";s:1:\"0\";s:19:\"noti_treshold_posts\";s:1:\"0\";s:20:\"noti_treshold_drafts\";s:1:\"0\";s:8:\"key_name\";s:8:\"managewp\";}", "yes");
INSERT INTO `wpeng_options` VALUES("10966", "https_detection_errors", "a:1:{s:19:\"bad_response_source\";a:1:{i:0;s:102:\"Φαίνεται πως η απάντηση δεν ήρθε από αυτόν τον ιστότοπο.\";}}", "yes");
INSERT INTO `wpeng_options` VALUES("11115", "wfls_last_role_change", "1690276156", "no");
INSERT INTO `wpeng_options` VALUES("12727", "wpins_block_notice", "a:1:{s:16:\"disable-comments\";s:16:\"disable-comments\";}", "yes");
INSERT INTO `wpeng_options` VALUES("13399", "widget_block", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpeng_options` VALUES("13405", "wp_force_deactivated_plugins", "a:0:{}", "yes");
INSERT INTO `wpeng_options` VALUES("13865", "theme_mods_betheme-child", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1633694205;s:4:\"data\";a:17:{s:19:\"wp_inactive_widgets\";a:7:{i:0;s:6:\"text-2\";i:1;s:6:\"text-3\";i:2;s:8:\"search-2\";i:3;s:14:\"recent-posts-2\";i:4;s:10:\"archives-2\";i:5;s:12:\"categories-2\";i:6;s:6:\"meta-2\";}s:13:\"footer-area-1\";a:0:{}s:13:\"footer-area-2\";a:0:{}s:13:\"footer-area-3\";a:0:{}s:13:\"footer-area-4\";a:0:{}s:13:\"footer-area-5\";a:0:{}s:10:\"top-area-1\";a:0:{}s:10:\"top-area-2\";a:0:{}s:10:\"top-area-3\";a:0:{}s:10:\"top-area-4\";a:0:{}s:10:\"mfn-search\";a:0:{}s:5:\"forum\";a:0:{}s:5:\"buddy\";a:0:{}s:6:\"events\";a:0:{}s:3:\"edd\";a:0:{}s:4:\"shop\";a:0:{}s:75:\"blog-cat-%ce%b1%cf%84%ce%b1%ce%be%ce%b9%ce%bd%cf%8c%ce%bc%ce%b7%cf%84%ce%b1\";a:0:{}}}}", "yes");
INSERT INTO `wpeng_options` VALUES("13872", "betheme", "a:562:{s:6:\"layout\";s:10:\"full-width\";s:10:\"grid-width\";i:1240;s:5:\"style\";s:0:\"\";s:11:\"img-page-bg\";s:0:\"\";s:16:\"position-page-bg\";s:20:\"center top no-repeat\";s:12:\"size-page-bg\";s:0:\"\";s:11:\"transparent\";s:0:\"\";s:11:\"favicon-img\";s:0:\"\";s:16:\"apple-touch-icon\";s:0:\"\";s:8:\"logo-img\";s:0:\"\";s:15:\"retina-logo-img\";s:0:\"\";s:15:\"sticky-logo-img\";s:0:\"\";s:22:\"sticky-retina-logo-img\";s:0:\"\";s:9:\"logo-link\";a:1:{s:4:\"link\";s:4:\"link\";}s:9:\"logo-text\";s:0:\"\";s:10:\"logo-width\";s:0:\"\";s:11:\"logo-height\";s:0:\"\";s:21:\"logo-vertical-padding\";s:0:\"\";s:19:\"logo-vertical-align\";s:0:\"\";s:13:\"logo-advanced\";s:0:\"\";s:12:\"button-style\";s:0:\"\";s:12:\"color-button\";s:7:\"#747474\";s:17:\"background-button\";s:7:\"#f7f7f7\";s:18:\"color-button-theme\";s:7:\"#ffffff\";s:19:\"color-action-button\";s:7:\"#ffffff\";s:24:\"background-action-button\";s:7:\"#0089f7\";s:18:\"button-font-family\";s:6:\"Roboto\";s:11:\"button-font\";a:3:{s:4:\"size\";i:14;s:12:\"weight_style\";s:3:\"400\";s:14:\"letter_spacing\";i:0;}s:14:\"button-padding\";a:5:{s:3:\"top\";i:12;s:5:\"right\";i:20;s:6:\"bottom\";i:12;s:4:\"left\";i:20;s:8:\"isLinked\";i:0;}s:19:\"button-border-width\";s:0:\"\";s:20:\"button-border-radius\";s:0:\"\";s:14:\"button-preview\";s:0:\"\";s:12:\"button-color\";a:2:{s:6:\"normal\";s:7:\"#626262\";s:5:\"hover\";s:7:\"#626262\";}s:17:\"button-background\";a:2:{s:6:\"normal\";s:7:\"#dbdddf\";s:5:\"hover\";s:7:\"#d3d3d3\";}s:19:\"button-border-color\";a:2:{s:6:\"normal\";s:0:\"\";s:5:\"hover\";s:0:\"\";}s:24:\"button-highlighted-color\";a:2:{s:6:\"normal\";s:7:\"#ffffff\";s:5:\"hover\";s:7:\"#ffffff\";}s:29:\"button-highlighted-background\";a:2:{s:6:\"normal\";s:7:\"#0095eb\";s:5:\"hover\";s:7:\"#007cc3\";}s:31:\"button-highlighted-border-color\";a:2:{s:6:\"normal\";s:0:\"\";s:5:\"hover\";s:0:\"\";}s:19:\"button-action-color\";a:2:{s:6:\"normal\";s:7:\"#626262\";s:5:\"hover\";s:7:\"#626262\";}s:24:\"button-action-background\";a:2:{s:6:\"normal\";s:7:\"#dbdddf\";s:5:\"hover\";s:7:\"#d3d3d3\";}s:26:\"button-action-border-color\";a:2:{s:6:\"normal\";s:0:\"\";s:5:\"hover\";s:0:\"\";}s:17:\"image-frame-style\";s:14:\"modern-overlay\";s:24:\"image-frame-border-width\";s:1:\"0\";s:19:\"image-frame-caption\";s:0:\"\";s:26:\"background-imageframe-link\";a:2:{s:6:\"normal\";s:7:\"#ffffff\";s:5:\"hover\";s:7:\"#ffffff\";}s:21:\"color-imageframe-link\";a:2:{s:6:\"normal\";s:7:\"#161922\";s:5:\"hover\";s:7:\"#0089f7\";}s:22:\"border-imageframe-link\";a:2:{s:6:\"normal\";s:0:\"\";s:5:\"hover\";s:0:\"\";}s:17:\"border-imageframe\";s:7:\"#f8f8f8\";s:25:\"color-imageframe-mask-new\";s:15:\"rgba(0,0,0,.15)\";s:19:\"slider-blog-timeout\";s:1:\"0\";s:22:\"slider-clients-timeout\";s:1:\"0\";s:20:\"slider-offer-timeout\";s:1:\"0\";s:24:\"slider-portfolio-timeout\";s:1:\"0\";s:19:\"slider-shop-timeout\";s:1:\"0\";s:21:\"slider-slider-timeout\";s:1:\"0\";s:27:\"slider-testimonials-timeout\";s:1:\"0\";s:15:\"info-navigation\";s:0:\"\";s:13:\"prev-next-nav\";s:0:\"\";s:15:\"prev-next-style\";s:7:\"minimal\";s:22:\"prev-next-sticky-style\";s:0:\"\";s:5:\"share\";s:1:\"1\";s:11:\"share-style\";s:6:\"simple\";s:20:\"layout-boxed-padding\";s:0:\"\";s:18:\"builder-visibility\";s:0:\"\";s:13:\"display-order\";s:0:\"\";s:22:\"content-remove-padding\";s:1:\"0\";s:8:\"no-hover\";s:0:\"\";s:19:\"google-maps-api-key\";s:0:\"\";s:11:\"table-hover\";s:0:\"\";s:23:\"math-animations-disable\";s:1:\"0\";s:14:\"layout-options\";s:0:\"\";s:17:\"post-type-disable\";s:0:\"\";s:13:\"theme-disable\";s:0:\"\";s:10:\"static-css\";s:1:\"0\";s:15:\"builder-storage\";s:0:\"\";s:16:\"slider-shortcode\";s:0:\"\";s:12:\"table_prefix\";s:0:\"\";s:8:\"hook-top\";s:0:\"\";s:19:\"hook-content-before\";s:0:\"\";s:18:\"hook-content-after\";s:0:\"\";s:11:\"hook-bottom\";s:0:\"\";s:12:\"header-style\";s:7:\"classic\";s:9:\"header-fw\";s:0:\"\";s:13:\"header-height\";i:250;s:16:\"img-subheader-bg\";s:0:\"\";s:24:\"img-subheader-attachment\";s:0:\"\";s:17:\"size-subheader-bg\";s:0:\"\";s:14:\"top-bar-bg-img\";s:0:\"\";s:19:\"top-bar-bg-position\";s:0:\"\";s:13:\"sticky-header\";s:1:\"1\";s:19:\"sticky-header-style\";s:0:\"\";s:15:\"subheader-style\";s:11:\"both-center\";s:9:\"subheader\";s:0:\"\";s:17:\"subheader-padding\";s:0:\"\";s:19:\"subheader-title-tag\";s:0:\"\";s:15:\"subheader-image\";s:0:\"\";s:18:\"subheader-position\";s:20:\"center top no-repeat\";s:14:\"subheader-size\";s:0:\"\";s:21:\"subheader-transparent\";s:3:\"100\";s:18:\"subheader-advanced\";s:0:\"\";s:18:\"top-bar-right-hide\";s:1:\"0\";s:19:\"header-action-title\";s:0:\"\";s:18:\"header-action-link\";s:0:\"\";s:20:\"header-action-target\";s:0:\"\";s:11:\"header-wpml\";s:0:\"\";s:19:\"header-wpml-options\";s:0:\"\";s:13:\"header-banner\";s:0:\"\";s:11:\"sliding-top\";s:1:\"0\";s:16:\"sliding-top-icon\";s:19:\"icon-down-open-mini\";s:10:\"menu-style\";s:10:\"link-color\";s:12:\"menu-options\";a:1:{s:11:\"align-right\";s:11:\"align-right\";}s:21:\"menu-creative-options\";s:0:\"\";s:15:\"menu-mega-style\";s:0:\"\";s:10:\"action-bar\";s:0:\"\";s:13:\"header-slogan\";s:0:\"\";s:12:\"header-phone\";s:0:\"\";s:14:\"header-phone-2\";s:0:\"\";s:12:\"header-email\";s:0:\"\";s:8:\"sidebars\";s:0:\"\";s:13:\"sidebar-width\";s:2:\"23\";s:13:\"sidebar-style\";s:6:\"simple\";s:13:\"sidebar-lines\";s:12:\"lines-hidden\";s:14:\"sidebar-sticky\";s:1:\"0\";s:16:\"ofcs-global-icon\";s:13:\"fas fa-indent\";s:18:\"single-page-layout\";s:0:\"\";s:19:\"single-page-sidebar\";s:0:\"\";s:20:\"single-page-sidebar2\";s:0:\"\";s:13:\"single-layout\";s:0:\"\";s:14:\"single-sidebar\";s:0:\"\";s:15:\"single-sidebar2\";s:0:\"\";s:23:\"single-portfolio-layout\";s:0:\"\";s:24:\"single-portfolio-sidebar\";s:0:\"\";s:25:\"single-portfolio-sidebar2\";s:0:\"\";s:13:\"search-layout\";s:10:\"no-sidebar\";s:19:\"pagination-show-all\";s:1:\"1\";s:4:\"love\";s:1:\"1\";s:22:\"featured-image-caption\";s:0:\"\";s:13:\"related-style\";s:6:\"simple\";s:13:\"title-heading\";s:1:\"1\";s:10:\"blog-posts\";i:9;s:11:\"blog-layout\";s:4:\"grid\";s:12:\"blog-columns\";i:3;s:14:\"blog-title-tag\";s:1:\"4\";s:11:\"blog-images\";s:0:\"\";s:15:\"blog-full-width\";s:1:\"0\";s:9:\"blog-page\";s:0:\"\";s:12:\"blog-orderby\";s:4:\"date\";s:10:\"blog-order\";s:4:\"DESC\";s:16:\"exclude-category\";s:0:\"\";s:14:\"excerpt-length\";s:2:\"26\";s:9:\"blog-meta\";a:3:{s:6:\"author\";s:6:\"author\";s:4:\"date\";s:4:\"date\";s:10:\"categories\";s:10:\"categories\";}s:14:\"blog-load-more\";s:1:\"0\";s:20:\"blog-infinite-scroll\";s:1:\"0\";s:12:\"blog-filters\";s:1:\"1\";s:12:\"blog-isotope\";s:1:\"0\";s:10:\"blog-title\";s:1:\"0\";s:11:\"blog-author\";s:1:\"1\";s:13:\"blog-comments\";s:1:\"1\";s:24:\"blog-featured-image-hide\";s:0:\"\";s:16:\"blog-single-zoom\";s:1:\"1\";s:18:\"blog-single-layout\";s:0:\"\";s:16:\"blog-single-menu\";s:0:\"\";s:12:\"blog-related\";i:3;s:20:\"blog-related-columns\";i:3;s:19:\"blog-related-images\";s:0:\"\";s:20:\"single-intro-padding\";s:0:\"\";s:14:\"blog-love-rand\";s:0:\"\";s:15:\"portfolio-posts\";i:9;s:16:\"portfolio-layout\";s:4:\"grid\";s:17:\"portfolio-columns\";i:3;s:20:\"portfolio-full-width\";s:1:\"0\";s:14:\"portfolio-page\";s:0:\"\";s:17:\"portfolio-orderby\";s:4:\"date\";s:15:\"portfolio-order\";s:4:\"DESC\";s:18:\"portfolio-external\";s:0:\"\";s:21:\"portfolio-hover-title\";s:1:\"0\";s:14:\"portfolio-meta\";a:3:{s:6:\"author\";s:6:\"author\";s:4:\"date\";s:4:\"date\";s:10:\"categories\";s:10:\"categories\";}s:19:\"portfolio-load-more\";s:1:\"0\";s:25:\"portfolio-infinite-scroll\";s:1:\"0\";s:17:\"portfolio-filters\";s:1:\"1\";s:17:\"portfolio-isotope\";s:1:\"1\";s:22:\"portfolio-single-title\";s:1:\"0\";s:29:\"portfolio-featured-image-hide\";s:0:\"\";s:17:\"portfolio-related\";i:3;s:25:\"portfolio-related-columns\";i:3;s:18:\"portfolio-comments\";s:1:\"0\";s:23:\"portfolio-single-layout\";s:0:\"\";s:21:\"portfolio-single-menu\";s:0:\"\";s:19:\"portfolio-love-rand\";s:0:\"\";s:14:\"portfolio-slug\";s:14:\"portfolio-item\";s:13:\"portfolio-tax\";s:15:\"portfolio-types\";s:21:\"info-force-regenerate\";s:0:\"\";s:29:\"featured-blog-portfolio-width\";s:3:\"960\";s:30:\"featured-blog-portfolio-height\";s:3:\"720\";s:28:\"featured-blog-portfolio-crop\";s:0:\"\";s:18:\"featured-desc-list\";s:0:\"\";s:21:\"featured-single-width\";s:4:\"1200\";s:22:\"featured-single-height\";s:3:\"675\";s:20:\"featured-single-crop\";s:0:\"\";s:20:\"featured-desc-single\";s:0:\"\";s:9:\"info-shop\";s:0:\"\";s:12:\"shop-sidebar\";s:0:\"\";s:11:\"shop-slider\";s:0:\"\";s:14:\"shop-catalogue\";s:1:\"0\";s:17:\"variable-swatches\";s:1:\"1\";s:13:\"shop-sidecart\";s:0:\"\";s:17:\"product-badge-new\";s:1:\"0\";s:22:\"product-badge-new-days\";s:2:\"14\";s:16:\"sale-badge-style\";s:5:\"label\";s:12:\"shop-soldout\";s:8:\"Sold out\";s:15:\"shop-icons-hide\";s:0:\"\";s:9:\"shop-user\";s:0:\"\";s:18:\"shop-icon-wishlist\";s:0:\"\";s:9:\"shop-cart\";s:0:\"\";s:20:\"shop-cart-total-hide\";s:0:\"\";s:23:\"shop-icon-count-if-zero\";s:1:\"1\";s:13:\"shop-wishlist\";s:1:\"0\";s:18:\"shop-wishlist-page\";s:0:\"\";s:22:\"shop-wishlist-position\";a:1:{i:2;s:1:\"2\";}s:16:\"sticky-shop-menu\";s:1:\"0\";s:13:\"shop-products\";s:2:\"12\";s:11:\"shop-layout\";s:4:\"grid\";s:19:\"mobile-products-row\";s:1:\"2\";s:13:\"shop-template\";s:0:\"\";s:11:\"shop-images\";s:0:\"\";s:10:\"shop-align\";s:0:\"\";s:14:\"shop-title-tag\";s:0:\"\";s:12:\"shop-excerpt\";s:1:\"0\";s:11:\"shop-button\";s:1:\"0\";s:18:\"shop-infinite-load\";i:0;s:15:\"shop-quick-view\";s:1:\"0\";s:24:\"shop-list-active-filters\";s:1:\"0\";s:17:\"shop-list-perpage\";s:1:\"0\";s:16:\"shop-list-layout\";s:1:\"0\";s:18:\"shop-product-style\";s:7:\"default\";s:21:\"shop-product-template\";s:0:\"\";s:17:\"shop-single-image\";s:0:\"\";s:20:\"shop-product-gallery\";s:0:\"\";s:28:\"shop-product-gallery-overlay\";s:22:\"mfn-thumbnails-outside\";s:30:\"shop-product-main-image-margin\";s:9:\"mfn-mim-0\";s:30:\"shop-product-thumbnails-margin\";s:0:\"\";s:18:\"shop-product-title\";s:0:\"\";s:12:\"shop-related\";i:3;s:13:\"page-comments\";s:1:\"0\";s:13:\"error404-icon\";s:17:\"icon-traffic-cone\";s:13:\"error404-page\";s:0:\"\";s:12:\"construction\";s:1:\"0\";s:18:\"construction-title\";s:11:\"Coming Soon\";s:17:\"construction-text\";s:0:\"\";s:17:\"construction-date\";s:19:\"12/30/2018 12:00:00\";s:19:\"construction-offset\";s:1:\"0\";s:20:\"construction-contact\";s:0:\"\";s:17:\"construction-page\";s:0:\"\";s:13:\"footer-layout\";s:0:\"\";s:12:\"footer-style\";s:0:\"\";s:14:\"footer-padding\";s:6:\"70px 0\";s:14:\"footer-options\";s:0:\"\";s:13:\"footer-bg-img\";s:0:\"\";s:22:\"footer-bg-img-position\";s:20:\"center top no-repeat\";s:18:\"footer-bg-img-size\";s:0:\"\";s:21:\"footer-call-to-action\";s:0:\"\";s:11:\"footer-copy\";s:0:\"\";s:11:\"footer-hide\";s:0:\"\";s:12:\"back-top-top\";s:0:\"\";s:18:\"popup-contact-form\";s:0:\"\";s:23:\"popup-contact-form-icon\";s:14:\"icon-mail-line\";s:13:\"header-search\";s:1:\"0\";s:25:\"header-search-input-width\";s:3:\"200\";s:18:\"header-search-live\";s:1:\"0\";s:33:\"header-search-live-min-characters\";s:1:\"3\";s:29:\"header-search-live-load-posts\";s:2:\"10\";s:35:\"header-search-live-container-height\";s:3:\"300\";s:33:\"header-search-live-featured_image\";s:1:\"1\";s:10:\"responsive\";s:1:\"1\";s:17:\"mobile-grid-width\";i:480;s:20:\"font-size-responsive\";s:1:\"1\";s:15:\"responsive-zoom\";s:1:\"0\";s:19:\"responsive-boxed2fw\";s:1:\"0\";s:13:\"no-section-bg\";s:0:\"\";s:19:\"responsive-parallax\";s:0:\"\";s:23:\"builder-section-padding\";s:0:\"\";s:19:\"builder-wrap-moveup\";s:0:\"\";s:12:\"footer-align\";s:0:\"\";s:14:\"mobile-sidebar\";s:1:\"0\";s:19:\"responsive-logo-img\";s:0:\"\";s:26:\"responsive-retina-logo-img\";s:0:\"\";s:26:\"responsive-sticky-logo-img\";s:0:\"\";s:33:\"responsive-sticky-retina-logo-img\";s:0:\"\";s:20:\"mobile-header-height\";s:0:\"\";s:24:\"mobile-subheader-padding\";s:0:\"\";s:19:\"mobile-menu-initial\";i:1240;s:22:\"responsive-mobile-menu\";s:10:\"side-slide\";s:27:\"responsive-side-slide-width\";i:250;s:21:\"responsive-side-slide\";s:0:\"\";s:16:\"header-menu-text\";s:0:\"\";s:11:\"mobile-menu\";s:0:\"\";s:25:\"responsive-header-minimal\";s:0:\"\";s:18:\"responsive-top-bar\";s:6:\"center\";s:24:\"responsive-header-mobile\";s:0:\"\";s:25:\"header-menu-mobile-sticky\";s:1:\"0\";s:16:\"mobile-icon-user\";s:2:\"ss\";s:20:\"mobile-icon-wishlist\";s:2:\"ss\";s:16:\"mobile-icon-cart\";s:0:\"\";s:18:\"mobile-icon-search\";s:2:\"ss\";s:16:\"mobile-icon-wpml\";s:2:\"ss\";s:18:\"mobile-icon-action\";s:2:\"ss\";s:24:\"responsive-header-tablet\";s:0:\"\";s:16:\"google-analytics\";s:0:\"\";s:14:\"facebook-pixel\";s:0:\"\";s:18:\"google-remarketing\";s:0:\"\";s:7:\"mfn-seo\";s:1:\"1\";s:16:\"meta-description\";s:0:\"\";s:13:\"meta-keywords\";s:0:\"\";s:16:\"mfn-seo-og-image\";s:0:\"\";s:13:\"seo-fb-app-id\";s:0:\"\";s:19:\"mfn-seo-schema-type\";s:1:\"1\";s:11:\"social-attr\";s:0:\"\";s:12:\"social-skype\";s:0:\"\";s:15:\"social-whatsapp\";s:0:\"\";s:15:\"social-facebook\";s:0:\"\";s:14:\"social-twitter\";s:0:\"\";s:12:\"social-vimeo\";s:0:\"\";s:14:\"social-youtube\";s:0:\"\";s:13:\"social-flickr\";s:0:\"\";s:15:\"social-linkedin\";s:0:\"\";s:16:\"social-pinterest\";s:0:\"\";s:15:\"social-dribbble\";s:0:\"\";s:16:\"social-instagram\";s:0:\"\";s:15:\"social-snapchat\";s:0:\"\";s:14:\"social-behance\";s:0:\"\";s:13:\"social-tumblr\";s:0:\"\";s:18:\"social-tripadvisor\";s:0:\"\";s:16:\"social-vkontakte\";s:0:\"\";s:13:\"social-viadeo\";s:0:\"\";s:11:\"social-xing\";s:0:\"\";s:18:\"social-custom-icon\";s:0:\"\";s:18:\"social-custom-link\";s:0:\"\";s:19:\"social-custom-title\";s:0:\"\";s:10:\"social-rss\";s:1:\"0\";s:9:\"cf7-error\";s:0:\"\";s:8:\"parallax\";s:0:\"\";s:19:\"prettyphoto-options\";s:0:\"\";s:18:\"sc-gallery-disable\";s:1:\"0\";s:12:\"info-plugins\";s:0:\"\";s:10:\"plugin-rev\";s:0:\"\";s:13:\"plugin-visual\";s:0:\"\";s:12:\"plugin-layer\";s:0:\"\";s:4:\"skin\";s:6:\"custom\";s:9:\"color-one\";s:7:\"#0095eb\";s:15:\"background-html\";s:7:\"#FCFCFC\";s:15:\"background-body\";s:7:\"#FCFCFC\";s:24:\"background-archives-post\";s:7:\"#FFFFFF\";s:29:\"background-archives-portfolio\";s:7:\"#FFFFFF\";s:27:\"background-archives-product\";s:0:\"\";s:17:\"background-header\";s:7:\"#13162f\";s:19:\"background-top-left\";s:7:\"#ffffff\";s:21:\"background-top-middle\";s:7:\"#e3e3e3\";s:20:\"background-top-right\";s:7:\"#f5f5f5\";s:17:\"color-top-right-a\";s:7:\"#333333\";s:14:\"border-top-bar\";s:0:\"\";s:20:\"background-subheader\";s:7:\"#f7f7f7\";s:15:\"color-subheader\";s:7:\"#161922\";s:12:\"color-menu-a\";s:7:\"#2a2b39\";s:19:\"color-menu-a-active\";s:7:\"#0089F7\";s:24:\"background-menu-a-active\";s:7:\"#F2F2F2\";s:18:\"background-submenu\";s:7:\"#F2F2F2\";s:15:\"color-submenu-a\";s:7:\"#5f5f5f\";s:21:\"color-submenu-a-hover\";s:7:\"#2e2e2e\";s:26:\"color-menu-responsive-icon\";s:7:\"#0089F7\";s:31:\"background-menu-responsive-icon\";s:0:\"\";s:23:\"background-overlay-menu\";s:7:\"#0089F7\";s:25:\"background-overlay-menu-a\";s:7:\"#FFFFFF\";s:32:\"background-overlay-menu-a-active\";s:7:\"#B1DCFB\";s:17:\"border-menu-plain\";s:7:\"#F2F2F2\";s:20:\"background-side-menu\";s:7:\"#191919\";s:17:\"color-side-menu-a\";s:7:\"#A6A6A6\";s:23:\"color-side-menu-a-hover\";s:7:\"#FFFFFF\";s:21:\"background-action-bar\";s:7:\"#101015\";s:16:\"color-action-bar\";s:7:\"#bbbbbb\";s:18:\"color-action-bar-a\";s:7:\"#006edf\";s:24:\"color-action-bar-a-hover\";s:7:\"#0089f7\";s:23:\"color-action-bar-social\";s:7:\"#bbbbbb\";s:29:\"color-action-bar-social-hover\";s:7:\"#FFFFFF\";s:28:\"mobile-background-action-bar\";s:7:\"#FFFFFF\";s:23:\"mobile-color-action-bar\";s:7:\"#222222\";s:25:\"mobile-color-action-bar-a\";s:7:\"#006edf\";s:31:\"mobile-color-action-bar-a-hover\";s:7:\"#0089f7\";s:30:\"mobile-color-action-bar-social\";s:7:\"#bbbbbb\";s:36:\"mobile-color-action-bar-social-hover\";s:7:\"#777777\";s:11:\"color-theme\";s:7:\"#0089F7\";s:10:\"color-text\";s:7:\"#626262\";s:15:\"color-selection\";s:7:\"#0089F7\";s:7:\"color-a\";s:7:\"#006edf\";s:13:\"color-a-hover\";s:7:\"#0089f7\";s:16:\"color-fancy-link\";s:7:\"#656B6F\";s:21:\"background-fancy-link\";s:7:\"#006edf\";s:22:\"color-fancy-link-hover\";s:7:\"#006edf\";s:27:\"background-fancy-link-hover\";s:7:\"#0089f7\";s:20:\"background-highlight\";s:7:\"#0089F7\";s:8:\"color-hr\";s:7:\"#0089F7\";s:10:\"color-list\";s:7:\"#737E86\";s:10:\"color-note\";s:7:\"#a8a8a8\";s:28:\"background-highlight-section\";s:7:\"#0089F7\";s:18:\"color-footer-theme\";s:7:\"#0089F7\";s:17:\"background-footer\";s:7:\"#101015\";s:12:\"color-footer\";s:7:\"#bababa\";s:20:\"color-footer-heading\";s:7:\"#ffffff\";s:17:\"color-footer-note\";s:7:\"#a8a8a8\";s:16:\"border-copyright\";s:21:\"rgba(255,255,255,0.1)\";s:14:\"color-footer-a\";s:7:\"#d1d1d1\";s:20:\"color-footer-a-hover\";s:7:\"#0089f7\";s:19:\"color-footer-social\";s:7:\"#65666C\";s:25:\"color-footer-social-hover\";s:7:\"#FFFFFF\";s:22:\"color-footer-backtotop\";s:7:\"#65666C\";s:27:\"background-footer-backtotop\";s:0:\"\";s:23:\"color-sliding-top-theme\";s:7:\"#0089F7\";s:22:\"background-sliding-top\";s:7:\"#545454\";s:17:\"color-sliding-top\";s:7:\"#cccccc\";s:19:\"color-sliding-top-a\";s:7:\"#006edf\";s:25:\"color-sliding-top-a-hover\";s:7:\"#0089f7\";s:25:\"color-sliding-top-heading\";s:7:\"#ffffff\";s:22:\"color-sliding-top-note\";s:7:\"#a8a8a8\";s:8:\"color-h1\";s:7:\"#161922\";s:8:\"color-h2\";s:7:\"#161922\";s:8:\"color-h3\";s:7:\"#161922\";s:8:\"color-h4\";s:7:\"#161922\";s:8:\"color-h5\";s:7:\"#5f6271\";s:8:\"color-h6\";s:7:\"#161922\";s:9:\"color-tab\";s:7:\"#444444\";s:15:\"color-tab-title\";s:7:\"#0089F7\";s:16:\"color-blockquote\";s:7:\"#444444\";s:21:\"background-getintouch\";s:7:\"#0089F7\";s:17:\"color-contentlink\";s:7:\"#0089F7\";s:13:\"color-counter\";s:7:\"#0089F7\";s:13:\"color-iconbar\";s:7:\"#0089F7\";s:13:\"color-iconbox\";s:7:\"#0089F7\";s:15:\"color-list-icon\";s:7:\"#0089F7\";s:19:\"color-pricing-price\";s:7:\"#0089F7\";s:27:\"background-pricing-featured\";s:7:\"#0089F7\";s:22:\"background-progressbar\";s:7:\"#0089F7\";s:22:\"color-quickfact-number\";s:7:\"#0089F7\";s:27:\"background-slidingbox-title\";s:7:\"#0089F7\";s:27:\"background-trailer-subtitle\";s:7:\"#0089F7\";s:24:\"background-alert-warning\";s:7:\"#fef8ea\";s:19:\"color-alert-warning\";s:7:\"#8a5b20\";s:22:\"background-alert-error\";s:7:\"#fae9e8\";s:17:\"color-alert-error\";s:7:\"#962317\";s:21:\"background-alert-info\";s:7:\"#efefef\";s:16:\"color-alert-info\";s:7:\"#57575b\";s:24:\"background-alert-success\";s:7:\"#eaf8ef\";s:19:\"color-alert-success\";s:7:\"#3a8b5b\";s:19:\"alert-border-radius\";s:0:\"\";s:10:\"color-form\";s:7:\"#626262\";s:15:\"background-form\";s:7:\"#FFFFFF\";s:11:\"border-form\";s:7:\"#EBEBEB\";s:22:\"color-form-placeholder\";s:7:\"#929292\";s:16:\"color-form-focus\";s:7:\"#0089F7\";s:21:\"background-form-focus\";s:7:\"#e9f5fc\";s:17:\"border-form-focus\";s:7:\"#d5e5ee\";s:28:\"color-form-placeholder-focus\";s:7:\"#929292\";s:17:\"form-border-width\";s:0:\"\";s:18:\"form-border-radius\";s:0:\"\";s:16:\"form-transparent\";s:3:\"100\";s:22:\"info-font-family-local\";s:0:\"\";s:12:\"font-content\";s:7:\"Poppins\";s:9:\"font-menu\";s:7:\"Poppins\";s:10:\"font-title\";s:7:\"Poppins\";s:13:\"font-headings\";s:7:\"Poppins\";s:19:\"font-headings-small\";s:7:\"Poppins\";s:15:\"font-blockquote\";s:7:\"Poppins\";s:15:\"font-decorative\";s:7:\"Poppins\";s:11:\"font-weight\";a:7:{i:300;s:3:\"300\";i:400;s:3:\"400\";s:9:\"400italic\";s:9:\"400italic\";i:500;s:3:\"500\";i:600;s:3:\"600\";i:700;s:3:\"700\";s:9:\"700italic\";s:9:\"700italic\";}s:11:\"font-subset\";s:0:\"\";s:17:\"font-size-content\";a:4:{s:4:\"size\";i:15;s:11:\"line_height\";i:28;s:12:\"weight_style\";s:3:\"400\";s:14:\"letter_spacing\";i:0;}s:13:\"font-size-big\";a:4:{s:4:\"size\";i:17;s:11:\"line_height\";i:30;s:12:\"weight_style\";s:3:\"400\";s:14:\"letter_spacing\";i:0;}s:14:\"font-size-menu\";a:4:{s:4:\"size\";i:15;s:11:\"line_height\";i:0;s:12:\"weight_style\";s:3:\"500\";s:14:\"letter_spacing\";i:0;}s:15:\"font-size-title\";a:4:{s:4:\"size\";i:50;s:11:\"line_height\";i:60;s:12:\"weight_style\";s:3:\"400\";s:14:\"letter_spacing\";i:0;}s:22:\"font-size-single-intro\";a:4:{s:4:\"size\";i:70;s:11:\"line_height\";i:70;s:12:\"weight_style\";s:3:\"400\";s:14:\"letter_spacing\";i:0;}s:12:\"font-size-h1\";a:4:{s:4:\"size\";i:50;s:11:\"line_height\";i:60;s:12:\"weight_style\";s:3:\"500\";s:14:\"letter_spacing\";i:0;}s:12:\"font-size-h2\";a:4:{s:4:\"size\";i:40;s:11:\"line_height\";i:50;s:12:\"weight_style\";s:3:\"500\";s:14:\"letter_spacing\";i:0;}s:12:\"font-size-h3\";a:4:{s:4:\"size\";i:30;s:11:\"line_height\";i:40;s:12:\"weight_style\";s:3:\"400\";s:14:\"letter_spacing\";i:0;}s:12:\"font-size-h4\";a:4:{s:4:\"size\";i:20;s:11:\"line_height\";i:30;s:12:\"weight_style\";s:3:\"600\";s:14:\"letter_spacing\";i:0;}s:12:\"font-size-h5\";a:4:{s:4:\"size\";i:18;s:11:\"line_height\";i:30;s:12:\"weight_style\";s:3:\"400\";s:14:\"letter_spacing\";i:0;}s:12:\"font-size-h6\";a:4:{s:4:\"size\";i:15;s:11:\"line_height\";i:26;s:12:\"weight_style\";s:3:\"700\";s:14:\"letter_spacing\";i:0;}s:10:\"info-fonts\";s:0:\"\";s:11:\"font-custom\";s:0:\"\";s:16:\"font-custom-woff\";s:0:\"\";s:15:\"font-custom-ttf\";s:0:\"\";s:12:\"font-custom2\";s:0:\"\";s:17:\"font-custom2-woff\";s:0:\"\";s:16:\"font-custom2-ttf\";s:0:\"\";s:14:\"info-translate\";s:0:\"\";s:9:\"translate\";s:1:\"1\";s:28:\"translate-search-placeholder\";s:17:\"Enter your search\";s:24:\"translate-search-results\";s:18:\"results found for:\";s:14:\"translate-home\";s:4:\"Home\";s:14:\"translate-prev\";s:9:\"Prev page\";s:14:\"translate-next\";s:9:\"Next page\";s:19:\"translate-load-more\";s:9:\"Load more\";s:17:\"translate-wpml-no\";s:39:\"No translations available for this page\";s:15:\"translate-share\";s:5:\"Share\";s:16:\"translate-before\";s:6:\"Before\";s:15:\"translate-after\";s:5:\"After\";s:14:\"translate-days\";s:4:\"days\";s:15:\"translate-hours\";s:5:\"hours\";s:17:\"translate-minutes\";s:7:\"minutes\";s:17:\"translate-seconds\";s:7:\"seconds\";s:25:\"translate-add-to-wishlist\";s:15:\"Add to wishlist\";s:16:\"translate-filter\";s:9:\"Filter by\";s:17:\"translate-authors\";s:7:\"Authors\";s:13:\"translate-all\";s:8:\"Show all\";s:18:\"translate-item-all\";s:3:\"All\";s:19:\"translate-published\";s:12:\"Published by\";s:12:\"translate-at\";s:2:\"on\";s:20:\"translate-categories\";s:10:\"Categories\";s:14:\"translate-tags\";s:4:\"Tags\";s:18:\"translate-readmore\";s:9:\"Read more\";s:14:\"translate-like\";s:15:\"Do you like it?\";s:17:\"translate-related\";s:13:\"Related posts\";s:16:\"translate-client\";s:6:\"Client\";s:14:\"translate-date\";s:4:\"Date\";s:17:\"translate-website\";s:7:\"Website\";s:14:\"translate-view\";s:12:\"View website\";s:14:\"translate-task\";s:4:\"Task\";s:22:\"translate-commented-on\";s:12:\"commented on\";s:19:\"translate-404-title\";s:18:\"Ooops... Error 404\";s:22:\"translate-404-subtitle\";s:62:\"We are sorry, but the page you are looking for does not exist.\";s:18:\"translate-404-text\";s:46:\"Please check entered address and try again or \";s:17:\"translate-404-btn\";s:14:\"go to homepage\";s:22:\"translate-search-title\";s:8:\"Ooops...\";s:25:\"translate-search-subtitle\";s:21:\"No results found for:\";s:9:\"info-wpml\";s:0:\"\";s:24:\"translate-wpml-installer\";s:0:\"\";s:4:\"gdpr\";s:0:\"\";s:22:\"gdpr-settings-position\";s:4:\"left\";s:23:\"gdpr-settings-animation\";s:5:\"slide\";s:27:\"gdpr-settings-cookie_expire\";s:3:\"365\";s:12:\"gdpr-content\";s:132:\"This website uses cookies to improve your experience. By using this website you agree to our <a href=\"#\">Data Protection Policy</a>.\";s:18:\"gdpr-content-image\";s:1:\"#\";s:24:\"gdpr-content-button_text\";s:10:\"Accept all\";s:27:\"gdpr-content-more_info_text\";s:9:\"Read more\";s:27:\"gdpr-content-more_info_link\";s:1:\"#\";s:27:\"gdpr-content-more_info_page\";s:0:\"\";s:25:\"gdpr-settings-link_target\";s:6:\"_blank\";s:10:\"info-shop2\";s:0:\"\";s:25:\"gdpr-container-background\";s:7:\"#eef2f5\";s:25:\"gdpr-container-font_color\";s:7:\"#626262\";s:28:\"gdpr-container-border-radius\";s:1:\"5\";s:25:\"gdpr-container-box_shadow\";a:6:{s:1:\"x\";s:1:\"0\";s:1:\"y\";s:2:\"15\";s:4:\"blur\";s:2:\"30\";s:6:\"spread\";s:1:\"0\";s:5:\"color\";s:16:\"rgba(1,7,39,.13)\";s:5:\"inset\";i:0;}s:22:\"gdpr-button-background\";a:2:{s:6:\"normal\";s:7:\"#006edf\";s:5:\"hover\";s:7:\"#0089f7\";}s:22:\"gdpr-button-font_color\";a:2:{s:6:\"normal\";s:7:\"#ffffff\";s:5:\"hover\";s:7:\"#ffffff\";}s:24:\"gdpr-button-border_color\";a:2:{s:6:\"normal\";s:0:\"\";s:5:\"hover\";s:0:\"\";}s:25:\"gdpr-more-info-font_color\";a:2:{s:6:\"normal\";s:7:\"#161922\";s:5:\"hover\";s:7:\"#0089f7\";}s:16:\"info-performance\";s:0:\"\";s:16:\"google-font-mode\";s:0:\"\";s:27:\"google-font-mode-regenerate\";s:0:\"\";s:26:\"performance-assets-disable\";s:0:\"\";s:22:\"performance-wp-disable\";s:0:\"\";s:15:\"jquery-location\";s:0:\"\";s:10:\"custom-css\";s:0:\"\";s:9:\"custom-js\";s:0:\"\";s:8:\"last_tab\";b:0;}", "yes");
INSERT INTO `wpeng_options` VALUES("13883", "duplicate_post_copytitle", "1", "yes");
INSERT INTO `wpeng_options` VALUES("13884", "duplicate_post_copydate", "0", "yes");
INSERT INTO `wpeng_options` VALUES("13885", "duplicate_post_copystatus", "0", "yes");
INSERT INTO `wpeng_options` VALUES("13886", "duplicate_post_copyslug", "0", "yes");
INSERT INTO `wpeng_options` VALUES("13887", "duplicate_post_copyexcerpt", "1", "yes");
INSERT INTO `wpeng_options` VALUES("13888", "duplicate_post_copycontent", "1", "yes");
INSERT INTO `wpeng_options` VALUES("13889", "duplicate_post_copythumbnail", "1", "yes");
INSERT INTO `wpeng_options` VALUES("13890", "duplicate_post_copytemplate", "1", "yes");
INSERT INTO `wpeng_options` VALUES("13891", "duplicate_post_copyformat", "1", "yes");
INSERT INTO `wpeng_options` VALUES("13892", "duplicate_post_copyauthor", "0", "yes");
INSERT INTO `wpeng_options` VALUES("13893", "duplicate_post_copypassword", "0", "yes");
INSERT INTO `wpeng_options` VALUES("13894", "duplicate_post_copyattachments", "0", "yes");
INSERT INTO `wpeng_options` VALUES("13895", "duplicate_post_copychildren", "0", "yes");
INSERT INTO `wpeng_options` VALUES("13896", "duplicate_post_copycomments", "0", "yes");
INSERT INTO `wpeng_options` VALUES("13897", "duplicate_post_copymenuorder", "1", "yes");
INSERT INTO `wpeng_options` VALUES("13898", "duplicate_post_taxonomies_blacklist", "a:0:{}", "yes");
INSERT INTO `wpeng_options` VALUES("13899", "duplicate_post_blacklist", "", "yes");
INSERT INTO `wpeng_options` VALUES("13900", "duplicate_post_types_enabled", "a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}", "yes");
INSERT INTO `wpeng_options` VALUES("13901", "duplicate_post_show_original_column", "0", "yes");
INSERT INTO `wpeng_options` VALUES("13902", "duplicate_post_show_original_in_post_states", "0", "yes");
INSERT INTO `wpeng_options` VALUES("13903", "duplicate_post_show_original_meta_box", "0", "yes");
INSERT INTO `wpeng_options` VALUES("13904", "duplicate_post_show_link", "a:3:{s:9:\"new_draft\";s:1:\"1\";s:5:\"clone\";s:1:\"1\";s:17:\"rewrite_republish\";s:1:\"1\";}", "yes");
INSERT INTO `wpeng_options` VALUES("13905", "duplicate_post_show_link_in", "a:4:{s:3:\"row\";s:1:\"1\";s:8:\"adminbar\";s:1:\"1\";s:9:\"submitbox\";s:1:\"1\";s:11:\"bulkactions\";s:1:\"1\";}", "yes");
INSERT INTO `wpeng_options` VALUES("14127", "vsz_cf7_db_version", "1.9.3", "yes");
INSERT INTO `wpeng_options` VALUES("14128", "webpc_notice_thanks", "1690988073", "yes");
INSERT INTO `wpeng_options` VALUES("14136", "agp_automatic", "enabled", "yes");
INSERT INTO `wpeng_options` VALUES("14137", "agp_diphthongs", "enabled", "yes");
INSERT INTO `wpeng_options` VALUES("14138", "agp_automatic_post", "a:1:{i:0;s:11:\"all_options\";}", "yes");
INSERT INTO `wpeng_options` VALUES("14139", "agp_automatic_tax", "a:1:{i:0;s:11:\"all_options\";}", "yes");
INSERT INTO `wpeng_options` VALUES("14140", "agp_version", "4.0.1", "yes");
INSERT INTO `wpeng_options` VALUES("14147", "aiowpsec_db_version", "1.9", "yes");
INSERT INTO `wpeng_options` VALUES("14148", "aio_wp_security_configs", "a:92:{s:19:\"aiowps_enable_debug\";s:0:\"\";s:36:\"aiowps_remove_wp_generator_meta_info\";s:0:\"\";s:25:\"aiowps_prevent_hotlinking\";s:0:\"\";s:28:\"aiowps_enable_login_lockdown\";s:0:\"\";s:28:\"aiowps_allow_unlock_requests\";s:0:\"\";s:25:\"aiowps_max_login_attempts\";s:1:\"3\";s:24:\"aiowps_retry_time_period\";s:1:\"5\";s:26:\"aiowps_lockout_time_length\";s:2:\"60\";s:28:\"aiowps_set_generic_login_msg\";s:0:\"\";s:26:\"aiowps_enable_email_notify\";s:0:\"\";s:20:\"aiowps_email_address\";s:16:\"dev@digital4u.gr\";s:27:\"aiowps_enable_forced_logout\";s:0:\"\";s:25:\"aiowps_logout_time_period\";s:2:\"60\";s:39:\"aiowps_enable_invalid_username_lockdown\";s:0:\"\";s:43:\"aiowps_instantly_lockout_specific_usernames\";a:0:{}s:32:\"aiowps_unlock_request_secret_key\";s:20:\"y9l32gxbwdgayo5xc3r8\";s:35:\"aiowps_lockdown_enable_whitelisting\";s:0:\"\";s:36:\"aiowps_lockdown_allowed_ip_addresses\";s:0:\"\";s:26:\"aiowps_enable_whitelisting\";s:0:\"\";s:27:\"aiowps_allowed_ip_addresses\";s:0:\"\";s:27:\"aiowps_enable_login_captcha\";s:0:\"\";s:34:\"aiowps_enable_custom_login_captcha\";s:0:\"\";s:31:\"aiowps_enable_woo_login_captcha\";s:0:\"\";s:34:\"aiowps_enable_woo_register_captcha\";s:0:\"\";s:38:\"aiowps_enable_woo_lostpassword_captcha\";s:0:\"\";s:25:\"aiowps_captcha_secret_key\";s:20:\"dtdjilpiq499u4444bng\";s:42:\"aiowps_enable_manual_registration_approval\";s:0:\"\";s:39:\"aiowps_enable_registration_page_captcha\";s:0:\"\";s:35:\"aiowps_enable_registration_honeypot\";s:0:\"\";s:27:\"aiowps_enable_random_prefix\";s:0:\"\";s:31:\"aiowps_enable_automated_backups\";s:0:\"\";s:26:\"aiowps_db_backup_frequency\";s:1:\"4\";s:25:\"aiowps_db_backup_interval\";s:1:\"2\";s:26:\"aiowps_backup_files_stored\";s:1:\"2\";s:32:\"aiowps_send_backup_email_address\";s:0:\"\";s:27:\"aiowps_backup_email_address\";s:16:\"dev@digital4u.gr\";s:27:\"aiowps_disable_file_editing\";s:0:\"\";s:37:\"aiowps_prevent_default_wp_file_access\";s:0:\"\";s:22:\"aiowps_system_log_file\";s:9:\"error_log\";s:26:\"aiowps_enable_blacklisting\";s:0:\"\";s:26:\"aiowps_banned_ip_addresses\";s:0:\"\";s:28:\"aiowps_enable_basic_firewall\";s:0:\"\";s:27:\"aiowps_max_file_upload_size\";s:2:\"10\";s:31:\"aiowps_enable_pingback_firewall\";s:0:\"\";s:38:\"aiowps_disable_xmlrpc_pingback_methods\";s:0:\"\";s:34:\"aiowps_block_debug_log_file_access\";s:0:\"\";s:26:\"aiowps_disable_index_views\";s:0:\"\";s:30:\"aiowps_disable_trace_and_track\";s:0:\"\";s:28:\"aiowps_forbid_proxy_comments\";s:0:\"\";s:29:\"aiowps_deny_bad_query_strings\";s:0:\"\";s:34:\"aiowps_advanced_char_string_filter\";s:0:\"\";s:25:\"aiowps_enable_5g_firewall\";s:0:\"\";s:25:\"aiowps_enable_6g_firewall\";s:0:\"\";s:26:\"aiowps_enable_custom_rules\";s:0:\"\";s:32:\"aiowps_place_custom_rules_at_top\";s:0:\"\";s:19:\"aiowps_custom_rules\";s:0:\"\";s:25:\"aiowps_enable_404_logging\";s:0:\"\";s:28:\"aiowps_enable_404_IP_lockout\";s:0:\"\";s:30:\"aiowps_404_lockout_time_length\";s:2:\"60\";s:28:\"aiowps_404_lock_redirect_url\";s:16:\"http://127.0.0.1\";s:31:\"aiowps_enable_rename_login_page\";s:0:\"\";s:28:\"aiowps_enable_login_honeypot\";s:0:\"\";s:43:\"aiowps_enable_brute_force_attack_prevention\";s:0:\"\";s:30:\"aiowps_brute_force_secret_word\";s:0:\"\";s:24:\"aiowps_cookie_brute_test\";s:0:\"\";s:44:\"aiowps_cookie_based_brute_force_redirect_url\";s:16:\"http://127.0.0.1\";s:59:\"aiowps_brute_force_attack_prevention_pw_protected_exception\";s:0:\"\";s:51:\"aiowps_brute_force_attack_prevention_ajax_exception\";s:0:\"\";s:19:\"aiowps_site_lockout\";s:0:\"\";s:23:\"aiowps_site_lockout_msg\";s:0:\"\";s:30:\"aiowps_enable_spambot_blocking\";s:0:\"\";s:29:\"aiowps_enable_comment_captcha\";s:0:\"\";s:31:\"aiowps_enable_autoblock_spam_ip\";s:0:\"\";s:33:\"aiowps_spam_ip_min_comments_block\";s:0:\"\";s:33:\"aiowps_enable_bp_register_captcha\";s:0:\"\";s:35:\"aiowps_enable_bbp_new_topic_captcha\";s:0:\"\";s:32:\"aiowps_enable_automated_fcd_scan\";s:0:\"\";s:25:\"aiowps_fcd_scan_frequency\";s:1:\"4\";s:24:\"aiowps_fcd_scan_interval\";s:1:\"2\";s:28:\"aiowps_fcd_exclude_filetypes\";s:0:\"\";s:24:\"aiowps_fcd_exclude_files\";s:0:\"\";s:26:\"aiowps_send_fcd_scan_email\";s:0:\"\";s:29:\"aiowps_fcd_scan_email_address\";s:16:\"dev@digital4u.gr\";s:27:\"aiowps_fcds_change_detected\";b:0;s:22:\"aiowps_copy_protection\";s:0:\"\";s:40:\"aiowps_prevent_site_display_inside_frame\";s:0:\"\";s:32:\"aiowps_prevent_users_enumeration\";s:0:\"\";s:42:\"aiowps_disallow_unauthorized_rest_requests\";s:0:\"\";s:25:\"aiowps_ip_retrieve_method\";s:1:\"0\";s:25:\"aiowps_recaptcha_site_key\";s:0:\"\";s:27:\"aiowps_recaptcha_secret_key\";s:0:\"\";s:24:\"aiowps_default_recaptcha\";s:0:\"\";}", "yes");
INSERT INTO `wpeng_options` VALUES("15357", "disable_comment_version", "2.4.4", "yes");
INSERT INTO `wpeng_options` VALUES("15363", "duplicate_post_show_notice", "0", "no");
INSERT INTO `wpeng_options` VALUES("15372", "aiowps_temp_configs", "a:92:{s:19:\"aiowps_enable_debug\";s:0:\"\";s:36:\"aiowps_remove_wp_generator_meta_info\";s:0:\"\";s:25:\"aiowps_prevent_hotlinking\";s:0:\"\";s:28:\"aiowps_enable_login_lockdown\";s:0:\"\";s:28:\"aiowps_allow_unlock_requests\";s:0:\"\";s:25:\"aiowps_max_login_attempts\";s:1:\"3\";s:24:\"aiowps_retry_time_period\";s:1:\"5\";s:26:\"aiowps_lockout_time_length\";s:2:\"60\";s:28:\"aiowps_set_generic_login_msg\";s:0:\"\";s:26:\"aiowps_enable_email_notify\";s:0:\"\";s:20:\"aiowps_email_address\";s:16:\"dev@digital4u.gr\";s:27:\"aiowps_enable_forced_logout\";s:0:\"\";s:25:\"aiowps_logout_time_period\";s:2:\"60\";s:39:\"aiowps_enable_invalid_username_lockdown\";s:0:\"\";s:43:\"aiowps_instantly_lockout_specific_usernames\";a:0:{}s:32:\"aiowps_unlock_request_secret_key\";s:20:\"y9l32gxbwdgayo5xc3r8\";s:35:\"aiowps_lockdown_enable_whitelisting\";s:0:\"\";s:36:\"aiowps_lockdown_allowed_ip_addresses\";s:0:\"\";s:26:\"aiowps_enable_whitelisting\";s:0:\"\";s:27:\"aiowps_allowed_ip_addresses\";s:0:\"\";s:27:\"aiowps_enable_login_captcha\";s:0:\"\";s:34:\"aiowps_enable_custom_login_captcha\";s:0:\"\";s:31:\"aiowps_enable_woo_login_captcha\";s:0:\"\";s:34:\"aiowps_enable_woo_register_captcha\";s:0:\"\";s:38:\"aiowps_enable_woo_lostpassword_captcha\";s:0:\"\";s:25:\"aiowps_captcha_secret_key\";s:20:\"dtdjilpiq499u4444bng\";s:42:\"aiowps_enable_manual_registration_approval\";s:0:\"\";s:39:\"aiowps_enable_registration_page_captcha\";s:0:\"\";s:35:\"aiowps_enable_registration_honeypot\";s:0:\"\";s:27:\"aiowps_enable_random_prefix\";s:0:\"\";s:31:\"aiowps_enable_automated_backups\";s:0:\"\";s:26:\"aiowps_db_backup_frequency\";s:1:\"4\";s:25:\"aiowps_db_backup_interval\";s:1:\"2\";s:26:\"aiowps_backup_files_stored\";s:1:\"2\";s:32:\"aiowps_send_backup_email_address\";s:0:\"\";s:27:\"aiowps_backup_email_address\";s:16:\"dev@digital4u.gr\";s:27:\"aiowps_disable_file_editing\";s:0:\"\";s:37:\"aiowps_prevent_default_wp_file_access\";s:0:\"\";s:22:\"aiowps_system_log_file\";s:9:\"error_log\";s:26:\"aiowps_enable_blacklisting\";s:0:\"\";s:26:\"aiowps_banned_ip_addresses\";s:0:\"\";s:28:\"aiowps_enable_basic_firewall\";s:0:\"\";s:27:\"aiowps_max_file_upload_size\";s:2:\"10\";s:31:\"aiowps_enable_pingback_firewall\";s:0:\"\";s:38:\"aiowps_disable_xmlrpc_pingback_methods\";s:0:\"\";s:34:\"aiowps_block_debug_log_file_access\";s:0:\"\";s:26:\"aiowps_disable_index_views\";s:0:\"\";s:30:\"aiowps_disable_trace_and_track\";s:0:\"\";s:28:\"aiowps_forbid_proxy_comments\";s:0:\"\";s:29:\"aiowps_deny_bad_query_strings\";s:0:\"\";s:34:\"aiowps_advanced_char_string_filter\";s:0:\"\";s:25:\"aiowps_enable_5g_firewall\";s:0:\"\";s:25:\"aiowps_enable_6g_firewall\";s:0:\"\";s:26:\"aiowps_enable_custom_rules\";s:0:\"\";s:32:\"aiowps_place_custom_rules_at_top\";s:0:\"\";s:19:\"aiowps_custom_rules\";s:0:\"\";s:25:\"aiowps_enable_404_logging\";s:0:\"\";s:28:\"aiowps_enable_404_IP_lockout\";s:0:\"\";s:30:\"aiowps_404_lockout_time_length\";s:2:\"60\";s:28:\"aiowps_404_lock_redirect_url\";s:16:\"http://127.0.0.1\";s:31:\"aiowps_enable_rename_login_page\";s:0:\"\";s:28:\"aiowps_enable_login_honeypot\";s:0:\"\";s:43:\"aiowps_enable_brute_force_attack_prevention\";s:0:\"\";s:30:\"aiowps_brute_force_secret_word\";s:0:\"\";s:24:\"aiowps_cookie_brute_test\";s:0:\"\";s:44:\"aiowps_cookie_based_brute_force_redirect_url\";s:16:\"http://127.0.0.1\";s:59:\"aiowps_brute_force_attack_prevention_pw_protected_exception\";s:0:\"\";s:51:\"aiowps_brute_force_attack_prevention_ajax_exception\";s:0:\"\";s:19:\"aiowps_site_lockout\";s:0:\"\";s:23:\"aiowps_site_lockout_msg\";s:0:\"\";s:30:\"aiowps_enable_spambot_blocking\";s:0:\"\";s:29:\"aiowps_enable_comment_captcha\";s:0:\"\";s:31:\"aiowps_enable_autoblock_spam_ip\";s:0:\"\";s:33:\"aiowps_spam_ip_min_comments_block\";s:0:\"\";s:33:\"aiowps_enable_bp_register_captcha\";s:0:\"\";s:35:\"aiowps_enable_bbp_new_topic_captcha\";s:0:\"\";s:32:\"aiowps_enable_automated_fcd_scan\";s:0:\"\";s:25:\"aiowps_fcd_scan_frequency\";s:1:\"4\";s:24:\"aiowps_fcd_scan_interval\";s:1:\"2\";s:28:\"aiowps_fcd_exclude_filetypes\";s:0:\"\";s:24:\"aiowps_fcd_exclude_files\";s:0:\"\";s:26:\"aiowps_send_fcd_scan_email\";s:0:\"\";s:29:\"aiowps_fcd_scan_email_address\";s:16:\"dev@digital4u.gr\";s:27:\"aiowps_fcds_change_detected\";b:0;s:22:\"aiowps_copy_protection\";s:0:\"\";s:40:\"aiowps_prevent_site_display_inside_frame\";s:0:\"\";s:32:\"aiowps_prevent_users_enumeration\";s:0:\"\";s:42:\"aiowps_disallow_unauthorized_rest_requests\";s:0:\"\";s:25:\"aiowps_ip_retrieve_method\";s:1:\"0\";s:25:\"aiowps_recaptcha_site_key\";s:0:\"\";s:27:\"aiowps_recaptcha_secret_key\";s:0:\"\";s:24:\"aiowps_default_recaptcha\";s:0:\"\";}", "yes");
INSERT INTO `wpeng_options` VALUES("15866", "wordfence_ls_version", "1.1.4", "yes");
INSERT INTO `wpeng_options` VALUES("16332", "webpc_notice_cloudflare", "", "yes");
INSERT INTO `wpeng_options` VALUES("17153", "duplicator_exe_safe_mode", "", "yes");
INSERT INTO `wpeng_options` VALUES("17209", "theme_mods_generatepress", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1651577986;s:4:\"data\";a:11:{s:19:\"wp_inactive_widgets\";a:2:{i:0;s:6:\"text-2\";i:1;s:6:\"text-3\";}s:9:\"sidebar-1\";a:5:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:6:\"header\";a:0:{}s:8:\"footer-1\";a:0:{}s:8:\"footer-2\";a:0:{}s:8:\"footer-3\";a:0:{}s:8:\"footer-4\";a:0:{}s:8:\"footer-5\";a:0:{}s:10:\"footer-bar\";a:0:{}s:7:\"top-bar\";a:0:{}}}}", "yes");
INSERT INTO `wpeng_options` VALUES("17212", "generate_db_version", "3.3.0", "yes");
INSERT INTO `wpeng_options` VALUES("17213", "gen_premium_license_key_status", "valid", "yes");
INSERT INTO `wpeng_options` VALUES("17214", "gen_premium_license_key", "9dbcfe380591c2a9736a5b0b44bff003", "yes");
INSERT INTO `wpeng_options` VALUES("17215", "generate_package_elements", "activated", "yes");
INSERT INTO `wpeng_options` VALUES("17216", "edd_sl_332d174c190f3e7000b435fcc500f495", "a:2:{s:7:\"timeout\";i:1690456287;s:5:\"value\";s:60850:\"{\"new_version\":\"2.3.1\",\"stable_version\":\"2.3.1\",\"name\":\"GP Premium\",\"slug\":\"gp-premium\",\"url\":\"https:\\/\\/generatepress.com\\/downloads\\/gp-premium\\/?changelog=1\",\"last_updated\":\"2023-03-30 20:17:25\",\"homepage\":\"https:\\/\\/generatepress.com\\/downloads\\/gp-premium\\/\",\"package\":\"https:\\/\\/generatepress.com\\/edd-sl\\/package_download\\/MTY5MDUwNjY4Njo5ZGJjZmUzODA1OTFjMmE5NzM2YTViMGI0NGJmZjAwMzoyNTQ0MToyZTJmMjU1YzdhYjg4YmRhY2E3OTA0NjYyZDEwNzIyMjpodHRwc0AvL3dvcmRwcmVzcy5lbmdpbmUuZ3AuZGVtb2Q0dS5ncjow\",\"download_link\":\"https:\\/\\/generatepress.com\\/edd-sl\\/package_download\\/MTY5MDUwNjY4Njo5ZGJjZmUzODA1OTFjMmE5NzM2YTViMGI0NGJmZjAwMzoyNTQ0MToyZTJmMjU1YzdhYjg4YmRhY2E3OTA0NjYyZDEwNzIyMjpodHRwc0AvL3dvcmRwcmVzcy5lbmdpbmUuZ3AuZGVtb2Q0dS5ncjow\",\"sections\":{\"description\":\"<p>The entire collection of GeneratePress premium modules. Once activated, each module extends certain aspects of GeneratePress, giving you more options to build your website.<\\/p>\\n<h4> Documentation <\\/h4>\\n<p>Check out our <a href=\\\"https:\\/\\/docs.generatepress.com\\\">documentation<\\/a> for more information on each module and how to use them.<\\/p>\",\"changelog\":\"<h4> 2.3.1 <\\/h4>\\n<ul>\\n<li>Fix: SelectSearch component infinite loop<\\/li>\\n<li>Fix: Block widths inside Block Elements<\\/li>\\n<\\/ul>\\n<h4> 2.3.0 <\\/h4>\\n<ul>\\n<li>Feature: Add Search Modal Element type<\\/li>\\n<li>Fix: Inline post meta feature in GenerateBlocks 1.7<\\/li>\\n<li>Fix: Close &quot;Choose Element Type&quot; modal with ESC key<\\/li>\\n<li>Fix: Replace WooCommerce secondary image attachment size<\\/li>\\n<li>Fix: WP Filesystem error missing credentials<\\/li>\\n<li>Fix: Undefined array keys in dynamic Container URL<\\/li>\\n<li>Fix: Author avatar in Header\\/Block Element titles<\\/li>\\n<li>Fix: Infinite loop error when autosaving with dynamic content block<\\/li>\\n<li>Fix: Add aria-label to off-canvas panel button<\\/li>\\n<li>Fix: WooCommerce button dynamic typography<\\/li>\\n<li>Fix: Empty WooCommerce quantity fields<\\/li>\\n<li>Fix: PHP 8.1 notice using disable elements in Customizer<\\/li>\\n<li>Tweak: Improve license key area<\\/li>\\n<li>Tweak: Improve off-canvas transitions<\\/li>\\n<li>Tweak: Check for WooCommerce functions<\\/li>\\n<li>Tweak: Open off-canvas using space bar<\\/li>\\n<li>Tweak: Use image ID in mobile header\\/sticky nav logos<\\/li>\\n<li>Tweak: Improve Elements hook selection dropdown UI<\\/li>\\n<li>Tweak: Add site library check for min GenerateBlocks version<\\/li>\\n<li>Tweak: Add Loop Template to Custom Post Type dropdown filters<\\/li>\\n<\\/ul>\\n<h4> 2.2.2 <\\/h4>\\n<ul>\\n<li>Fix: Off Canvas anchor links not working<\\/li>\\n<\\/ul>\\n<h4> 2.2.1 <\\/h4>\\n<ul>\\n<li>Fix: Add value to off-canvas aria-hidden attribute<\\/li>\\n<li>Tweak: Remove\\/add aria-hidden to off-canvas on toggle<\\/li>\\n<\\/ul>\\n<h4> 2.2.0 <\\/h4>\\n<ul>\\n<li>Feature: Allow block element autosave<\\/li>\\n<li>Feature: Add revisions to block elements<\\/li>\\n<li>Feature: Add Loop Template block element<\\/li>\\n<li>Feature: Dont display the raw license key in the Dashboard<\\/li>\\n<li>Feature: Add &quot;Paginated Results&quot; to Element Display Rules<\\/li>\\n<li>Fix: Element post navigation template PHP warning when not using GB Pro<\\/li>\\n<li>Fix: Remove unnecessary zoom CSS from featured images<\\/li>\\n<li>Fix: Font icon CSS order<\\/li>\\n<li>Fix: Load more button showing in product tax archives<\\/li>\\n<li>Fix: Prevent tabbing in hidden off-canvas panel<\\/li>\\n<li>Fix: Hide hidden off-canvas panel from screen readers<\\/li>\\n<li>Fix: menu-toggle aria-controls when using off-canvas panel<\\/li>\\n<li>Fix: Focus first focusable element when opening off-canvas panel<\\/li>\\n<li>Fix: Focus slideout toggle when closing off-canvas panel<\\/li>\\n<li>Fix: Off-Canvas Panel sub-menu a11y<\\/li>\\n<li>Fix: Prevent secondary nav legacy typography CSS<\\/li>\\n<li>Fix: Fix dynamic term meta link<\\/li>\\n<li>Fix: Block margins in the block element editor<\\/li>\\n<li>Fix: Embeds in Block Elements<\\/li>\\n<li>Fix: Apply display rules to editor with no ID<\\/li>\\n<li>Fix: Navigation background image applying to secondary nav<\\/li>\\n<li>Fix: WooCommerce order received page float issue<\\/li>\\n<li>Fix: Block element editor error in GenerateBlocks 1.7<\\/li>\\n<li>Tweak: Remove jquery-migrate from sticky script<\\/li>\\n<li>Tweak: Add message in Blog section about Loop Template<\\/li>\\n<\\/ul>\\n<h4> 2.1.2 <\\/h4>\\n<ul>\\n<li>Elements: Fix custom field value in dynamic container links<\\/li>\\n<li>Elements: Fix block widths in the editor<\\/li>\\n<li>General: Fix double slashes in dashboard file request<\\/li>\\n<li>General: Fix missing Customizer translations<\\/li>\\n<\\/ul>\\n<h4> 2.1.1 <\\/h4>\\n<ul>\\n<li>Menu Plus: Fix mobile header sticky auto hide<\\/li>\\n<li>Site Library: Fix broken CSS variables on import<\\/li>\\n<\\/ul>\\n<h4> 2.1.0 <\\/h4>\\n<ul>\\n<li>Blog: Fix masonry JS error if no archive pagination exists<\\/li>\\n<li>Blog: Fix full width featured blog column<\\/li>\\n<li>Colors: Deprecate module if using GP 3.1.0<\\/li>\\n<li>Elements: Add custom class option to dynamic image block<\\/li>\\n<li>Elements: Add support for post_type array in display rules<\\/li>\\n<li>Elements: Fix container link option when targeting next\\/previous posts<\\/li>\\n<li>Menu Plus: Integrate off-canvas panel with new dynamic typography system<\\/li>\\n<li>Menu Plus: Integrate off-canvas panel with new color system<\\/li>\\n<li>Menu Plus: Integrate mobile header HTML attributes with new HTML attribute system<\\/li>\\n<li>Menu Plus: Integrate mobile header and off-canvas panel with new generate_has_active_menu filter<\\/li>\\n<li>Menu Plus: Fix broken inline CSS when using floated sticky navigation<\\/li>\\n<li>Menu Plus: Add logo dimensions to navigation logo<\\/li>\\n<li>Secondary Navigation: Integrate with new color system<\\/li>\\n<li>Secondary Navigation: Integrate with new generate_has_active_menu filter<\\/li>\\n<li>Secondary Navigation: Integrate with new dynamic typography system<\\/li>\\n<li>Secondary Navigation: Reduce box-shadow to match main navigation<\\/li>\\n<li>Secondary Navigation: Change direction of sub-menu box-shadow when opening left<\\/li>\\n<li>Secondary Navigation: Fix sub-menu overlap when using dropdown click\\/mobile<\\/li>\\n<li>Secondary Navigation: Replace box-shadow with border-bottom when sub-menu opens down<\\/li>\\n<li>Site Library: Add site author attribution<\\/li>\\n<li>Typography: Deprecate module if using dynamic typography in GP 3.1.0<\\/li>\\n<li>WooCommerce: Integrate with new dynamic typography system<\\/li>\\n<li>WooCommerce: Integrate with new colors system<\\/li>\\n<li>WooCommerce: Remove category title\\/description if using page hero with title disabled<\\/li>\\n<li>WooCommerce: Remove &quot;speak&quot; CSS properties<\\/li>\\n<li>WooCommerce: Fix empty continue shopping link on mobile<\\/li>\\n<li>WooCommerce: Fix persistent sticky add to cart panel<\\/li>\\n<li>General: Integrate with new GP 3.1.0 Dashboard<\\/li>\\n<li>General: Remove featured-image-active body class if featured image is disabled<\\/li>\\n<li>General: Change date format in exported JSON filename<\\/li>\\n<li>General: Fix PHP error when license key activation returns 403<\\/li>\\n<\\/ul>\\n<h4> 2.0.3 <\\/h4>\\n<ul>\\n<li>Elements: Use block_categories_all filter in WP 5.8<\\/li>\\n<li>Elements: Remove wp-editor dependency from new widget editor<\\/li>\\n<\\/ul>\\n<h4> 2.0.2 <\\/h4>\\n<ul>\\n<li>Elements: Use blog page title for dynamic title if set<\\/li>\\n<li>Spacing: Fix reset button bug in Customizer controls<\\/li>\\n<li>WooCommerce: Fix infinite scroll applying to product taxonomy pages<\\/li>\\n<\\/ul>\\n<h4> 2.0.1 <\\/h4>\\n<ul>\\n<li>Blog: Fix infinite scroll bug on product archives<\\/li>\\n<li>Elements: Fix error in WP 4.9.x versions<\\/li>\\n<li>Menu Plus: Prevent 0x0 logo dimension attributes if no dimensions exist<\\/li>\\n<li>Site Library: Add vertical scroll ability to the Site Library control area<\\/li>\\n<\\/ul>\\n<h4> 2.0.0 <\\/h4>\\n<ul>\\n<li>Blog: Rewrite infinite scroll using vanilla javascript<\\/li>\\n<li>Blog: Rewrite masonry using vanilla javascript<\\/li>\\n<li>Blog: Add separate infinite scroll path element to footer<\\/li>\\n<li>Blog: Fix missing single\\/page featured image options when archive image disabled<\\/li>\\n<li>Blog: Add aria-label instead of screen-reader-text to read more button<\\/li>\\n<li>Colors: Fix back to top Customizer color preview<\\/li>\\n<li>Elements: New Content Template Element<\\/li>\\n<li>Elements: New Post Meta Template Element<\\/li>\\n<li>Elements: New Post Navigation Template Element<\\/li>\\n<li>Elements: New Page Hero Block Element<\\/li>\\n<li>Elements: New Archive Navigation Template Element<\\/li>\\n<li>Elements: New Editor Width option in Block Elements<\\/li>\\n<li>Elements: Move Block Elements options into editor sidebar<\\/li>\\n<li>Elements: Show Site Header options by default in Header Element<\\/li>\\n<li>Elements: Fix Classic Editor issue in Block Elements<\\/li>\\n<li>Elements: Add a list of active Elements to page editor<\\/li>\\n<li>Elements: Add a list of active Elements to the admin bar<\\/li>\\n<li>Elements: Add notices to Customizer if Elements may be overwriting options<\\/li>\\n<li>Elements: Disable mobile header menu if menu is disabled via Layout Element<\\/li>\\n<li>Elements: Improve Display Rule loading performance<\\/li>\\n<li>Elements: Add block type filter to Elements dashboard<\\/li>\\n<li>Elements: Add generate_element_display filter<\\/li>\\n<li>Elements: Add No Results as a Display Rule condition<\\/li>\\n<li>Menu Plus: Hide slideout toggle at set mobile menu breakpoint value<\\/li>\\n<li>Menu Plus: Fix sticky menu height when using navigation as header<\\/li>\\n<li>Menu Plus: Add dimensions to mobile\\/sticky logos<\\/li>\\n<li>Menu Plus: Make Off-Canvas menu take up full width of canvas<\\/li>\\n<li>Menu Plus: Fix menu bar item sticky transition<\\/li>\\n<li>Menu Plus: Prevent sticky sidebar nav if mobile header is set to sticky<\\/li>\\n<li>Secondary Nav: Fix centered secondary navigation items using flexbox<\\/li>\\n<li>Secondary Nav: Fix conflict with Nav as Header option<\\/li>\\n<li>Secondary Nav: Fix missing menu cart items when using click dropdowns<\\/li>\\n<li>Sections: Officially deprecate module<\\/li>\\n<li>Site Library: Completely rebuild Site Library using React<\\/li>\\n<li>WooCommerce: Move full width single product CSS to inline CSS<\\/li>\\n<li>WooCommerce: Use wc_get_product() instead of new WC_Product()<\\/li>\\n<li>WooCommerce: Add more checks for WC() class to prevent error logs<\\/li>\\n<li>WooCommerce: Add generate_wc_cart_panel_checkout_button_output filter<\\/li>\\n<li>WooCommerce: Add generate_wc_sticky_add_to_cart_action filter<\\/li>\\n<li>WooCommerce: Add generate_wc_show_sticky_add_to_cart filter<\\/li>\\n<li>WooCommerce: Re-write quantity button javascript to be more performant\\/extendable<\\/li>\\n<li>General: Update theme install link<\\/li>\\n<li>General: Update alpha color picker script<\\/li>\\n<li>General: Use correct URL scheme in external stylesheet URLs<\\/li>\\n<li>General: Check if FS_CHMOD_FILE is defined in external stylesheet generation<\\/li>\\n<li>General: Use inline CSS when using AMP plugin<\\/li>\\n<li>General: Update EDD_SL_Plugin_Updater class to 1.8.0<\\/li>\\n<li>General: Clean up javascript throughout plugin<\\/li>\\n<li>General: Replace deprecated jQuery functions<\\/li>\\n<\\/ul>\\n<h4> 1.12.3 <\\/h4>\\n<ul>\\n<li>WooCommerce: Fix quantity buttons in WP 5.6<\\/li>\\n<\\/ul>\\n<h4> 1.12.2 <\\/h4>\\n<ul>\\n<li>Blog: Load columns CSS when using filter to enable it anywhere<\\/li>\\n<li>Menu Plus: Fix sticky mobile header jump when using inline mobile toggle<\\/li>\\n<li>Menu Plus: Add margin to sticky nav branding when set to full width<\\/li>\\n<li>Menu Plus: Disable sticky nav container text align padding<\\/li>\\n<li>Menu Plus: Make mobile menu absolute only when smooth scroll is enabled<\\/li>\\n<li>Menu Plus: Improve nav as header\\/mobile header when using flexbox<\\/li>\\n<li>Menu Plus: Prevent off-canvas panel close button from flashing visible when closing<\\/li>\\n<li>Spacing: Fix custom nav search height<\\/li>\\n<\\/ul>\\n<h4> 1.12.1 <\\/h4>\\n<ul>\\n<li>Typography: Fix missing heading font size controls in the Customizer<\\/li>\\n<\\/ul>\\n<h4> 1.12.0 <\\/h4>\\n<ul>\\n<li>Blog: Fix column margin on mobile with some caching plugins<\\/li>\\n<li>Blog: Add post-load trigger to infinite scroll for better plugin compatibility<\\/li>\\n<li>Blog: Take generate_blog_columns filter into account when loading columns CSS<\\/li>\\n<li>Colors: Add search menu-bar-item color live preview to Customizer<\\/li>\\n<li>Elements: Fix broken custom hook field in Block Elements<\\/li>\\n<li>Elements: Integrate page hero with text container alignment in GP 3.0<\\/li>\\n<li>Elements: Better integrate Header Element colors with GP 3.0<\\/li>\\n<li>Elements: Only disable content title when {{post_title}} is present on single pages<\\/li>\\n<li>Elements: Fix  tag in metabox<\\/li>\\n<li>Elements: Add generate_elements_metabox_ajax_allow_editors filter<\\/li>\\n<li>Elements: Add new 3.0 hooks to hook selector<\\/li>\\n<li>Elements: Re-add generate_elements_custom_args filter<\\/li>\\n<li>Menu Plus: Better prepare navigation as header for GP 3.0<\\/li>\\n<li>Menu Plus: Better prepare Off-Canvas Panel for GP 3.0<\\/li>\\n<li>Menu Plus: Better prepare sticky navigation for GP 3.0<\\/li>\\n<li>Menu Plus: Add has-menu-bar-items class to mobile header if needed<\\/li>\\n<li>Menu Plus: Add is-logo-image class to all site logos<\\/li>\\n<li>Menu Plus: Fix mobile header alignment when it has menu bar items<\\/li>\\n<li>Secondary Nav: Better prepare sticky navigation for GP 3.0<\\/li>\\n<li>Secondary Nav: Fix hidden navigation widget in top bar when merged with secondary nav<\\/li>\\n<li>Sites: Improve the option-only import feature<\\/li>\\n<li>Sites: Improve the refresh sites button functionality<\\/li>\\n<li>Sites: Improve the undo site import functionality<\\/li>\\n<li>Sites: Fix Elementor site import issues<\\/li>\\n<li>Sites: Re-add Elementor sites to library<\\/li>\\n<li>Spacing: Better prepare Customizer live preview for GP 3.0<\\/li>\\n<li>Spacing: Fix blog column spacing Customizer live preview<\\/li>\\n<li>Spacing: Stop handling mobile header, widget and footer widget features added in GP 3.0<\\/li>\\n<li>Typography: Add mobile font size control for H3 (when using GP 3.0)<\\/li>\\n<li>Typography: Add mobile font size control for H4 (when using GP 3.0)<\\/li>\\n<li>Typography: Add mobile font size control for H5 (when using GP 3.0)<\\/li>\\n<li>Typography: Allow empty tablet and mobile site title font size values<\\/li>\\n<li>Typography: Make menu toggle CSS selector specific to primary navigation<\\/li>\\n<li>WooCommerce: Use CSS for secondary product image functionality instead of JS<\\/li>\\n<li>WooCommerce: Only load .js file if needed<\\/li>\\n<li>WooCommerce: Fix quantity box functionality when multiple quantity boxes exist on the page<\\/li>\\n<li>General: Improve alpha color picker script for better 5.5 compatibility<\\/li>\\n<li>General: Move child theme stylesheet after dynamic stylesheet if enabled<\\/li>\\n<li>General: Update gp-premium-de_DE.mo<\\/li>\\n<li>General: Update gp-premium-es_ES.mo<\\/li>\\n<li>General: Update gp-premium-fi.mo<\\/li>\\n<li>General: Update gp-premium-pt_PT.mo<\\/li>\\n<li>General: Update gp-premium-sv_SE.mo<\\/li>\\n<\\/ul>\\n<h4> 1.11.3 <\\/h4>\\n<ul>\\n<li>Blog: Set widths to grid-sizer element<\\/li>\\n<li>Elements: Fix legacy Page Header\\/Hooks buttons in the Elements dashboard<\\/li>\\n<li>Page Header: Replace .load() with .on(\'load\')<\\/li>\\n<li>Page Header: Fix color picker error in WP 5.5<\\/li>\\n<\\/ul>\\n<h4> 1.11.2 <\\/h4>\\n<ul>\\n<li>Blog: Remove negative featured image top margin from columns when using one container<\\/li>\\n<li>Blog: Fix infinite scroll items loading above viewport when using columns<\\/li>\\n<li>Blog: Fix infinite scroll featured images not displaying in Safari<\\/li>\\n<li>Elements: Prevent error in editor when generate_get_option() function doesn\'t exist<\\/li>\\n<li>General: Load inline CSS in previews when using external CSS option<\\/li>\\n<li>General: Update gp-premium-es_ES.mo<\\/li>\\n<li>General: Update gp-premium-pt_PT.mo<\\/li>\\n<\\/ul>\\n<h4> 1.11.1 <\\/h4>\\n<ul>\\n<li>Elements: Remove stray quote character in Layout Element metabox<\\/li>\\n<li>Sections: Fix color picker JS error in WP 5.5<\\/li>\\n<li>General: Fix external CSS option not removing inline CSS in some cases<\\/li>\\n<\\/ul>\\n<h4> 1.11.0 <\\/h4>\\n<ul>\\n<li>New: Block Elements<\\/li>\\n<li>New: Apply Layout Element options to the block editor if set<\\/li>\\n<li>New: Generate dynamic CSS in an external file<\\/li>\\n<li>Blog: Separate CSS and load only when needed<\\/li>\\n<li>Blog: Add column width classes to stylesheet<\\/li>\\n<li>Blog: Disable featured image itemprop if microdata is disabled<\\/li>\\n<li>Blog: Add generate_blog_masonry_init filter<\\/li>\\n<li>Blog: Add generate_blog_infinite_scroll_init filter<\\/li>\\n<li>Blog: Fix archive page header overlap when using no featured image padding\\/one container<\\/li>\\n<li>Blog: Replace screen reader text with aria-label in read more buttons<\\/li>\\n<li>Disable Elements: Add option to disable the Mobile Header<\\/li>\\n<li>Disable Elements: Disable top bar disables it even when combined with Secondary Nav<\\/li>\\n<li>Disable Elements: Use generate_show_post_navigation filter to disable single post navigation<\\/li>\\n<li>Elements: Use full hook name with generate_ prefix in dropdown<\\/li>\\n<li>Elements: Rebuild how Element types are chosen<\\/li>\\n<li>Elements: Add chosen hook under type column in edit.php<\\/li>\\n<li>Menu Plus: Add generate_after_mobile_header_menu_button filter<\\/li>\\n<li>Menu Plus: Add sticky placeholder only when nav becomes sticky<\\/li>\\n<li>Menu Plus: Add class to sticky nav when scrolling up<\\/li>\\n<li>Menu Plus: Fix navigation branding\\/mobile header layout when using RTL languages<\\/li>\\n<li>Page Header: Prevent PHP notices<\\/li>\\n<li>Secondary Nav: Clean up CSS<\\/li>\\n<li>Secondary Nav: Add generate_after_secondary_navigation hook<\\/li>\\n<li>Secondary Nav: Add generate_before_secondary_navigation hook<\\/li>\\n<li>Secondary Nav: Integrate with future flexbox option<\\/li>\\n<li>Secondary Nav: Add has-top-bar class if needed<\\/li>\\n<li>Secondary Nav: Add screen reader text to mobile menu toggle if no text exists<\\/li>\\n<li>Secondary Nav: Remove microdata if disabled<\\/li>\\n<li>Secondary Nav: Add generate_secondary_menu_bar_items hook<\\/li>\\n<li>Spacing: Set sidebar width in Customizer for future flexbox option<\\/li>\\n<li>WooCommerce: Add generate_woocommerce_show_add_to_cart_panel filter<\\/li>\\n<li>WooCommerce: Integrate with future flexbox option<\\/li>\\n<li>WooCommerce: Ensure WC()-&gt;cart is set<\\/li>\\n<li>WooCommerce: Remove left margin from SVG menu cart icon<\\/li>\\n<li>WooCommerce: Show sticky add to cart panel on sold individually products<\\/li>\\n<li>WooCommerce: Remove bottom margin from related\\/upsell products<\\/li>\\n<li>WooCommerce: Fix cart menu item spacing in RTL languages<\\/li>\\n<li>WooCommerce: Fix menu item cart dropdown design in RTL languages<\\/li>\\n<li>General: Update selectWoo<\\/li>\\n<li>General: Update select2<\\/li>\\n<li>General: Run all CSS through PostCSS<\\/li>\\n<li>General: Fix various text domains<\\/li>\\n<li>General: Fix JS error when toggling nav as header option without Colors\\/Typography modules<\\/li>\\n<li>General: Update all translations over 90% complete<\\/li>\\n<li>General: PHP cleanup\\/coding standards<\\/li>\\n<li>General: Add off_canvas_desktop_toggle_label to wpml-config.xml<\\/li>\\n<\\/ul>\\n<h4> 1.10.0 <\\/h4>\\n<ul>\\n<li>Blog: Remove existing on-the-fly featured image resizer (Image Processing Queue)<\\/li>\\n<li>Blog: Choose from existing image sizes for featured images<\\/li>\\n<li>Blog: Use CSS to further resize featured images if necessary<\\/li>\\n<li>Blog: Fix edge case persistent transient bug with old image resizer<\\/li>\\n<li>Elements: Fix broken closing element in metabox<\\/li>\\n<li>General: Change scroll variable to gpscroll in smooth scroll script to avoid conflicts<\\/li>\\n<li>General: Update responsive widths in Customizer<\\/li>\\n<li>General: Fix responsive Customizer views when using RTL<\\/li>\\n<li>Menu Plus: Don\'t output sticky nav branding if sticky nav is disabled<\\/li>\\n<li>Menu Plus: Fix focus when off canvas overlay is opened (a11y)<\\/li>\\n<li>Menu Plus: Fix sticky navigation jump when navigation branding is in use<\\/li>\\n<li>Sections: Fix visible block editor when Sections are enabled<\\/li>\\n<li>WooCommerce: Use minmax in grid template definitions to fix overflow issue<\\/li>\\n<li>WooCommerce: Prevent add to cart panel interfering with back to top button on mobile<\\/li>\\n<li>WooCommerce: WooCommerce: Fix secondary image position if HTML isn\'t ordered correctly<\\/li>\\n<li>General: Add\\/update all translations over 50% complete. Big thanks to all contributors!<\\/li>\\n<li>Translation: Added Arabic - thank you anass!<\\/li>\\n<li>Translation: Added Bengali - thank you gtmroy!<\\/li>\\n<li>Translation: Added Spanish (Spain) - thank you davidperez (closemarketing.es)!<\\/li>\\n<li>Translation: Added Spanish (Argentina) - thank you bratorr!<\\/li>\\n<li>Translation: Added Finnish - thank you Stedi!<\\/li>\\n<li>Translation: Add Dutch - thank you Robin!<\\/li>\\n<li>Translation: Added Ukrainian - thank you EUROMEDIA!<\\/li>\\n<li>Translation: Vietnamese added - thank you themevi!<\\/li>\\n<\\/ul>\\n<h4> 1.9.1 <\\/h4>\\n<ul>\\n<li>Blog: Fix &quot;null&quot; in infinite scroll load more button text<\\/li>\\n<li>WooCommerce: Fix hidden added to cart panel on mobile when sticky nav active<\\/li>\\n<li>WooCommerce: Fix missing SVG icon in mobile added to cart panel<\\/li>\\n<\\/ul>\\n<h4> 1.9.0 <\\/h4>\\n<ul>\\n<li>Blog: Support SVG icon feature<\\/li>\\n<li>Colors: Add navigation search color options<\\/li>\\n<li>Disable Elements: Disable mobile menu in Mobile Header if nav is disabled<\\/li>\\n<li>Elements: Add wp_body_open hook<\\/li>\\n<li>Elements: Allow 0 mobile padding in Elements<\\/li>\\n<li>Elements: Add generate_elements_admin_menu_capability filter<\\/li>\\n<li>Elements: Add generate_page_hero_css_output filter<\\/li>\\n<li>Elements: Prevent error in Header Element if taxonomy doesn\'t exist<\\/li>\\n<li>Elements: Fix double logo when Header Element has logo + using nav as header<\\/li>\\n<li>Elements: Fix mobile header logo not replacing if merge is disabled<\\/li>\\n<li>Elements: Fix missing arrow in Choose Element Type select in WP 5.3<\\/li>\\n<li>Elements: Add generate_inside_site_container hook option<\\/li>\\n<li>Elements: Add generate_after_entry_content hook option<\\/li>\\n<li>Menu Plus: Add off canvas desktop toggle label option<\\/li>\\n<li>Menu Plus: Add generate_off_canvas_toggle_output filter<\\/li>\\n<li>Menu Plus: Support SVG icon feature<\\/li>\\n<li>Menu Plus: Fix sticky navigation overlapping BB controls<\\/li>\\n<li>Menu Plus: Add align-items: center to nav as header, mobile header and sticky nav with branding<\\/li>\\n<li>Sections: Fix text\\/visual switch bug in Firefox<\\/li>\\n<li>Sites: Add option to revert site import<\\/li>\\n<li>Sites: Increase site library limit to 100<\\/li>\\n<li>Spacing: Add live preview to group container padding<\\/li>\\n<li>Typography: Add tablet site title\\/navigation font size options<\\/li>\\n<li>Typography: Add archive post title weight, transform, font size and line height<\\/li>\\n<li>Typography: Add single content title weight, transform, font size and line height<\\/li>\\n<li>Typography: Only call all google fonts once in the Customizer<\\/li>\\n<li>Typography: Get Google fonts from readable JSON list<\\/li>\\n<li>Typography: Make sure font settings aren\'t lost if list is changed<\\/li>\\n<li>Typography: Only call generate_get_all_google_fonts if needed<\\/li>\\n<li>WooCommerce: Add columns gap options (desktop, tablet, mobile)<\\/li>\\n<li>WooCommerce: Add tablet column options<\\/li>\\n<li>WooCommerce: Add related\\/upsell tablet column options<\\/li>\\n<li>WooCommerce: Support SVG icon feature<\\/li>\\n<li>WooCommerce: Prevent empty added to cart panel on single products<\\/li>\\n<li>WooCommerce: Fix woocommerce-ordering arrow in old FF versions<\\/li>\\n<li>WooCommerce: Make item\\/items string translatable<\\/li>\\n<li>General: Better customizer device widths<\\/li>\\n<li>General: Use generate_premium_get_media_query throughout modules<\\/li>\\n<li>General: Improve Customizer control styling<\\/li>\\n<\\/ul>\\n<h4> 1.8.3 <\\/h4>\\n<ul>\\n<li>Menu Plus: Use flexbox for center aligned nav with nav branding<\\/li>\\n<li>Menu Plus: Center overlay off canvas exit button on mobile<\\/li>\\n<li>Menu Plus: Add alt tag to sticky nav logo<\\/li>\\n<li>Menu Plus: Set generate_not_mobile_menu_media_query filter based on mobile menu breakpoint<\\/li>\\n<li>Sections: Remember when text tab is active<\\/li>\\n<li>Sections: Disable visual editor if turned off in profile<\\/li>\\n<li>Typography: Add generate_google_font_display filter<\\/li>\\n<li>WooCommerce: Fix single product sidebar layout metabox option<\\/li>\\n<li>WooCommerce: Reduce carousel thumbnail max-width to 100px to match new thumbnail sizes<\\/li>\\n<\\/ul>\\n<h4> 1.8.2 <\\/h4>\\n<ul>\\n<li>Elements: Use Page Hero site title color for mobile header site title<\\/li>\\n<li>Menu Plus: Give mobile header site title more left spacing<\\/li>\\n<li>Menu Plus: Fix nav search icon in sticky navigation when using nav branding in Firefox<\\/li>\\n<li>Site Library: Show Site Library tab even if no sites exist<\\/li>\\n<li>Site Library: Show an error message in Site Library if no sites exist<\\/li>\\n<li>Typography: Remove reference to generate_get_navigation_location() function<\\/li>\\n<li>WooCommerce: Remove quantity field arrows when using quantity buttons in Firefox<\\/li>\\n<li>WooCommerce: Remove extra border when loading quantity buttons<\\/li>\\n<li>WooCommerce: Use get_price_html() is sticky add to cart panel<\\/li>\\n<\\/ul>\\n<h4> 1.8.1 <\\/h4>\\n<ul>\\n<li>Menu Plus: Revert sticky nav duplicate ID fix due to Cyrillic script bug<\\/li>\\n<\\/ul>\\n<h4> 1.8 <\\/h4>\\n<ul>\\n<li>Blog: Apply columns filter to masonry grid sizer<\\/li>\\n<li>Colors: Merge Footer Widgets and Footer controls in Color panel<\\/li>\\n<li>Colors: Remove edit_theme_options capability to Customizer controls (set by default)<\\/li>\\n<li>Disable Elements: Make sure mobile header is disabled when primary navigation is disabled<\\/li>\\n<li>Elements: Add content width option in Layout Element<\\/li>\\n<li>Elements: Fix mobile header logo when mobile menu toggled<\\/li>\\n<li>Elements: Add generate_page_hero_location filter<\\/li>\\n<li>Elements: Add generate_elements_show_object_ids filter to show IDs in Display Rule values<\\/li>\\n<li>Elements: Prevent merged header wrap from conflicting with Elementor controls<\\/li>\\n<li>Elements: Change Container tab name to Content<\\/li>\\n<li>Elements: Add woocommerce_share option to Hooks<\\/li>\\n<li>Elements: Improve WPML compatibility<\\/li>\\n<li>Elements: Improve Polylang compatibility<\\/li>\\n<li>Elements: Prevent PHP notices when adding taxonomy locations to non-existent archives<\\/li>\\n<li>Elements: Add generate_mobile_cart_items hook to hook list<\\/li>\\n<li>Elements: Add generate_element_post_id filter<\\/li>\\n<li>Elements: Escape HTML elements inside Element textarea<\\/li>\\n<li>Elements: Add Beaver Builder templates to the Display Rules<\\/li>\\n<li>Menu Plus: Add mobile header breakpoint option<\\/li>\\n<li>Menu Plus: Add off canvas overlay option<\\/li>\\n<li>Menu Plus: Add navigation as header option<\\/li>\\n<li>Menu Plus: Remove navigation logo option if navigation as header set<\\/li>\\n<li>Menu Plus: Add sticky navigation logo option<\\/li>\\n<li>Menu Plus: Allow site title in mobile header instead of logo<\\/li>\\n<li>Menu Plus: Add option to move exit button inside the off canvas panel<\\/li>\\n<li>Menu Plus: Change Slideout Navigation name to Off Canvas Panel<\\/li>\\n<li>Menu Plus: Only re-focus after slideout close on escape key<\\/li>\\n<li>Menu Plus: Give close slideout event a name so it can be removed<\\/li>\\n<li>Menu Plus: Remove invalid transition-delay<\\/li>\\n<li>Menu Plus: Improve slideout overlay transition<\\/li>\\n<li>Menu Plus: Add mobile open\\/close icons to GPP font<\\/li>\\n<li>Menu Plus: Allow dynamic widget classes in off canvas panel (fixes WC range slider widget issue)<\\/li>\\n<li>Menu Plus: Basic compatibility with future SVG icons<\\/li>\\n<li>Menu Plus: Prevent duplicate IDs when sticky navigation is cloned<\\/li>\\n<li>Secondary Nav: Add dropdown direction option<\\/li>\\n<li>Secondary Nav: Basic compatibility with future SVG icons<\\/li>\\n<li>Sections: Fix section editor issues in WP 5.0<\\/li>\\n<li>Sections: Show Better Font Awesome icon in editor<\\/li>\\n<li>Sites: Re-design UI<\\/li>\\n<li>Sites: Add option to activate as a module like all the other modules<\\/li>\\n<li>Sites: Don\'t show backup options button if no options exist<\\/li>\\n<li>Sites: Make JS action classes more specific to the site library<\\/li>\\n<li>Sites: Set mime types of content.xml and widgets.wie<\\/li>\\n<li>Spacing: Add header padding option for mobile<\\/li>\\n<li>Spacing: Add widget padding option for mobile<\\/li>\\n<li>Spacing: Add footer widgets padding option for mobile<\\/li>\\n<li>Spacing: Add content separator option<\\/li>\\n<li>Spacing: Apply mobile menu item width to mobile bar only<\\/li>\\n<li>WooCommerce: Add option for mini cart in the menu<\\/li>\\n<li>WooCommerce: Add option to open off overlay panel on add to cart<\\/li>\\n<li>WooCommerce: Add option to open sticky add to cart panel on single products<\\/li>\\n<li>WooCommerce: Add option to add +\\/- buttons to the quantity fields<\\/li>\\n<li>WooCommerce: Add option to show number of items in cart menu item<\\/li>\\n<li>WooCommerce: Add option to choose single product image area width<\\/li>\\n<li>WooCommerce: Add color options for price slider widget<\\/li>\\n<li>WooCommerce: Use CSS grid for the product archives<\\/li>\\n<li>WooCommerce: Horizontally align add to cart buttons<\\/li>\\n<li>WooCommerce: Re-design the cart widget<\\/li>\\n<li>WooCommerce: Tighten up product info spacing<\\/li>\\n<li>WooCommerce: Improve product tab design to look more like tabs<\\/li>\\n<li>WooCommerce: Simplify single product image display<\\/li>\\n<li>WooCommerce: Use flexbox for quantity\\/add to cart alignment<\\/li>\\n<li>WooCommerce: Improve rating star styles<\\/li>\\n<li>WooCommerce: Use product alignment setting for related\\/upsell products<\\/li>\\n<li>WooCommerce: Remove bottom margin from product image<\\/li>\\n<li>WooCommerce: Organize colors in the Customizer<\\/li>\\n<li>WooCommerce: Remove title attribute from menu cart item<\\/li>\\n<li>WooCommerce: Improve coupon field design<\\/li>\\n<li>WooCommerce: Improve result count\\/ordering styling<\\/li>\\n<li>WooCommerce: Add gap around WC single product images<\\/li>\\n<li>WooCommerce: Remove arrow from checkout button<\\/li>\\n<li>WooCommerce: Hide view cart link on add to cart click<\\/li>\\n<li>WooCommerce: Organize CSS<\\/li>\\n<li>Introduce in-Customizer shortcuts<\\/li>\\n<li>Add generate_disable_customizer_shortcuts filter<\\/li>\\n<\\/ul>\"},\"banners\":{\"high\":\"\",\"low\":\"\"},\"icons\":{\"1x\":\"https:\\/\\/generatepress.com\\/wp-content\\/uploads\\/edd\\/2020\\/05\\/icon-128x128.png\",\"2x\":\"https:\\/\\/generatepress.com\\/wp-content\\/uploads\\/edd\\/2020\\/05\\/icon-256x256.png\"},\"stable_tag\":\"2.3.1\",\"tested\":\"6.2.2\",\"description\":[\"<p>The entire collection of GeneratePress premium modules. Once activated, each module extends certain aspects of GeneratePress, giving you more options to build your website.<\\/p>\\n<h4> Documentation <\\/h4>\\n<p>Check out our <a href=\\\"https:\\/\\/docs.generatepress.com\\\">documentation<\\/a> for more information on each module and how to use them.<\\/p>\"],\"changelog\":[\"<h4> 2.3.1 <\\/h4>\\n<ul>\\n<li>Fix: SelectSearch component infinite loop<\\/li>\\n<li>Fix: Block widths inside Block Elements<\\/li>\\n<\\/ul>\\n<h4> 2.3.0 <\\/h4>\\n<ul>\\n<li>Feature: Add Search Modal Element type<\\/li>\\n<li>Fix: Inline post meta feature in GenerateBlocks 1.7<\\/li>\\n<li>Fix: Close &quot;Choose Element Type&quot; modal with ESC key<\\/li>\\n<li>Fix: Replace WooCommerce secondary image attachment size<\\/li>\\n<li>Fix: WP Filesystem error missing credentials<\\/li>\\n<li>Fix: Undefined array keys in dynamic Container URL<\\/li>\\n<li>Fix: Author avatar in Header\\/Block Element titles<\\/li>\\n<li>Fix: Infinite loop error when autosaving with dynamic content block<\\/li>\\n<li>Fix: Add aria-label to off-canvas panel button<\\/li>\\n<li>Fix: WooCommerce button dynamic typography<\\/li>\\n<li>Fix: Empty WooCommerce quantity fields<\\/li>\\n<li>Fix: PHP 8.1 notice using disable elements in Customizer<\\/li>\\n<li>Tweak: Improve license key area<\\/li>\\n<li>Tweak: Improve off-canvas transitions<\\/li>\\n<li>Tweak: Check for WooCommerce functions<\\/li>\\n<li>Tweak: Open off-canvas using space bar<\\/li>\\n<li>Tweak: Use image ID in mobile header\\/sticky nav logos<\\/li>\\n<li>Tweak: Improve Elements hook selection dropdown UI<\\/li>\\n<li>Tweak: Add site library check for min GenerateBlocks version<\\/li>\\n<li>Tweak: Add Loop Template to Custom Post Type dropdown filters<\\/li>\\n<\\/ul>\\n<h4> 2.2.2 <\\/h4>\\n<ul>\\n<li>Fix: Off Canvas anchor links not working<\\/li>\\n<\\/ul>\\n<h4> 2.2.1 <\\/h4>\\n<ul>\\n<li>Fix: Add value to off-canvas aria-hidden attribute<\\/li>\\n<li>Tweak: Remove\\/add aria-hidden to off-canvas on toggle<\\/li>\\n<\\/ul>\\n<h4> 2.2.0 <\\/h4>\\n<ul>\\n<li>Feature: Allow block element autosave<\\/li>\\n<li>Feature: Add revisions to block elements<\\/li>\\n<li>Feature: Add Loop Template block element<\\/li>\\n<li>Feature: Dont display the raw license key in the Dashboard<\\/li>\\n<li>Feature: Add &quot;Paginated Results&quot; to Element Display Rules<\\/li>\\n<li>Fix: Element post navigation template PHP warning when not using GB Pro<\\/li>\\n<li>Fix: Remove unnecessary zoom CSS from featured images<\\/li>\\n<li>Fix: Font icon CSS order<\\/li>\\n<li>Fix: Load more button showing in product tax archives<\\/li>\\n<li>Fix: Prevent tabbing in hidden off-canvas panel<\\/li>\\n<li>Fix: Hide hidden off-canvas panel from screen readers<\\/li>\\n<li>Fix: menu-toggle aria-controls when using off-canvas panel<\\/li>\\n<li>Fix: Focus first focusable element when opening off-canvas panel<\\/li>\\n<li>Fix: Focus slideout toggle when closing off-canvas panel<\\/li>\\n<li>Fix: Off-Canvas Panel sub-menu a11y<\\/li>\\n<li>Fix: Prevent secondary nav legacy typography CSS<\\/li>\\n<li>Fix: Fix dynamic term meta link<\\/li>\\n<li>Fix: Block margins in the block element editor<\\/li>\\n<li>Fix: Embeds in Block Elements<\\/li>\\n<li>Fix: Apply display rules to editor with no ID<\\/li>\\n<li>Fix: Navigation background image applying to secondary nav<\\/li>\\n<li>Fix: WooCommerce order received page float issue<\\/li>\\n<li>Fix: Block element editor error in GenerateBlocks 1.7<\\/li>\\n<li>Tweak: Remove jquery-migrate from sticky script<\\/li>\\n<li>Tweak: Add message in Blog section about Loop Template<\\/li>\\n<\\/ul>\\n<h4> 2.1.2 <\\/h4>\\n<ul>\\n<li>Elements: Fix custom field value in dynamic container links<\\/li>\\n<li>Elements: Fix block widths in the editor<\\/li>\\n<li>General: Fix double slashes in dashboard file request<\\/li>\\n<li>General: Fix missing Customizer translations<\\/li>\\n<\\/ul>\\n<h4> 2.1.1 <\\/h4>\\n<ul>\\n<li>Menu Plus: Fix mobile header sticky auto hide<\\/li>\\n<li>Site Library: Fix broken CSS variables on import<\\/li>\\n<\\/ul>\\n<h4> 2.1.0 <\\/h4>\\n<ul>\\n<li>Blog: Fix masonry JS error if no archive pagination exists<\\/li>\\n<li>Blog: Fix full width featured blog column<\\/li>\\n<li>Colors: Deprecate module if using GP 3.1.0<\\/li>\\n<li>Elements: Add custom class option to dynamic image block<\\/li>\\n<li>Elements: Add support for post_type array in display rules<\\/li>\\n<li>Elements: Fix container link option when targeting next\\/previous posts<\\/li>\\n<li>Menu Plus: Integrate off-canvas panel with new dynamic typography system<\\/li>\\n<li>Menu Plus: Integrate off-canvas panel with new color system<\\/li>\\n<li>Menu Plus: Integrate mobile header HTML attributes with new HTML attribute system<\\/li>\\n<li>Menu Plus: Integrate mobile header and off-canvas panel with new generate_has_active_menu filter<\\/li>\\n<li>Menu Plus: Fix broken inline CSS when using floated sticky navigation<\\/li>\\n<li>Menu Plus: Add logo dimensions to navigation logo<\\/li>\\n<li>Secondary Navigation: Integrate with new color system<\\/li>\\n<li>Secondary Navigation: Integrate with new generate_has_active_menu filter<\\/li>\\n<li>Secondary Navigation: Integrate with new dynamic typography system<\\/li>\\n<li>Secondary Navigation: Reduce box-shadow to match main navigation<\\/li>\\n<li>Secondary Navigation: Change direction of sub-menu box-shadow when opening left<\\/li>\\n<li>Secondary Navigation: Fix sub-menu overlap when using dropdown click\\/mobile<\\/li>\\n<li>Secondary Navigation: Replace box-shadow with border-bottom when sub-menu opens down<\\/li>\\n<li>Site Library: Add site author attribution<\\/li>\\n<li>Typography: Deprecate module if using dynamic typography in GP 3.1.0<\\/li>\\n<li>WooCommerce: Integrate with new dynamic typography system<\\/li>\\n<li>WooCommerce: Integrate with new colors system<\\/li>\\n<li>WooCommerce: Remove category title\\/description if using page hero with title disabled<\\/li>\\n<li>WooCommerce: Remove &quot;speak&quot; CSS properties<\\/li>\\n<li>WooCommerce: Fix empty continue shopping link on mobile<\\/li>\\n<li>WooCommerce: Fix persistent sticky add to cart panel<\\/li>\\n<li>General: Integrate with new GP 3.1.0 Dashboard<\\/li>\\n<li>General: Remove featured-image-active body class if featured image is disabled<\\/li>\\n<li>General: Change date format in exported JSON filename<\\/li>\\n<li>General: Fix PHP error when license key activation returns 403<\\/li>\\n<\\/ul>\\n<h4> 2.0.3 <\\/h4>\\n<ul>\\n<li>Elements: Use block_categories_all filter in WP 5.8<\\/li>\\n<li>Elements: Remove wp-editor dependency from new widget editor<\\/li>\\n<\\/ul>\\n<h4> 2.0.2 <\\/h4>\\n<ul>\\n<li>Elements: Use blog page title for dynamic title if set<\\/li>\\n<li>Spacing: Fix reset button bug in Customizer controls<\\/li>\\n<li>WooCommerce: Fix infinite scroll applying to product taxonomy pages<\\/li>\\n<\\/ul>\\n<h4> 2.0.1 <\\/h4>\\n<ul>\\n<li>Blog: Fix infinite scroll bug on product archives<\\/li>\\n<li>Elements: Fix error in WP 4.9.x versions<\\/li>\\n<li>Menu Plus: Prevent 0x0 logo dimension attributes if no dimensions exist<\\/li>\\n<li>Site Library: Add vertical scroll ability to the Site Library control area<\\/li>\\n<\\/ul>\\n<h4> 2.0.0 <\\/h4>\\n<ul>\\n<li>Blog: Rewrite infinite scroll using vanilla javascript<\\/li>\\n<li>Blog: Rewrite masonry using vanilla javascript<\\/li>\\n<li>Blog: Add separate infinite scroll path element to footer<\\/li>\\n<li>Blog: Fix missing single\\/page featured image options when archive image disabled<\\/li>\\n<li>Blog: Add aria-label instead of screen-reader-text to read more button<\\/li>\\n<li>Colors: Fix back to top Customizer color preview<\\/li>\\n<li>Elements: New Content Template Element<\\/li>\\n<li>Elements: New Post Meta Template Element<\\/li>\\n<li>Elements: New Post Navigation Template Element<\\/li>\\n<li>Elements: New Page Hero Block Element<\\/li>\\n<li>Elements: New Archive Navigation Template Element<\\/li>\\n<li>Elements: New Editor Width option in Block Elements<\\/li>\\n<li>Elements: Move Block Elements options into editor sidebar<\\/li>\\n<li>Elements: Show Site Header options by default in Header Element<\\/li>\\n<li>Elements: Fix Classic Editor issue in Block Elements<\\/li>\\n<li>Elements: Add a list of active Elements to page editor<\\/li>\\n<li>Elements: Add a list of active Elements to the admin bar<\\/li>\\n<li>Elements: Add notices to Customizer if Elements may be overwriting options<\\/li>\\n<li>Elements: Disable mobile header menu if menu is disabled via Layout Element<\\/li>\\n<li>Elements: Improve Display Rule loading performance<\\/li>\\n<li>Elements: Add block type filter to Elements dashboard<\\/li>\\n<li>Elements: Add generate_element_display filter<\\/li>\\n<li>Elements: Add No Results as a Display Rule condition<\\/li>\\n<li>Menu Plus: Hide slideout toggle at set mobile menu breakpoint value<\\/li>\\n<li>Menu Plus: Fix sticky menu height when using navigation as header<\\/li>\\n<li>Menu Plus: Add dimensions to mobile\\/sticky logos<\\/li>\\n<li>Menu Plus: Make Off-Canvas menu take up full width of canvas<\\/li>\\n<li>Menu Plus: Fix menu bar item sticky transition<\\/li>\\n<li>Menu Plus: Prevent sticky sidebar nav if mobile header is set to sticky<\\/li>\\n<li>Secondary Nav: Fix centered secondary navigation items using flexbox<\\/li>\\n<li>Secondary Nav: Fix conflict with Nav as Header option<\\/li>\\n<li>Secondary Nav: Fix missing menu cart items when using click dropdowns<\\/li>\\n<li>Sections: Officially deprecate module<\\/li>\\n<li>Site Library: Completely rebuild Site Library using React<\\/li>\\n<li>WooCommerce: Move full width single product CSS to inline CSS<\\/li>\\n<li>WooCommerce: Use wc_get_product() instead of new WC_Product()<\\/li>\\n<li>WooCommerce: Add more checks for WC() class to prevent error logs<\\/li>\\n<li>WooCommerce: Add generate_wc_cart_panel_checkout_button_output filter<\\/li>\\n<li>WooCommerce: Add generate_wc_sticky_add_to_cart_action filter<\\/li>\\n<li>WooCommerce: Add generate_wc_show_sticky_add_to_cart filter<\\/li>\\n<li>WooCommerce: Re-write quantity button javascript to be more performant\\/extendable<\\/li>\\n<li>General: Update theme install link<\\/li>\\n<li>General: Update alpha color picker script<\\/li>\\n<li>General: Use correct URL scheme in external stylesheet URLs<\\/li>\\n<li>General: Check if FS_CHMOD_FILE is defined in external stylesheet generation<\\/li>\\n<li>General: Use inline CSS when using AMP plugin<\\/li>\\n<li>General: Update EDD_SL_Plugin_Updater class to 1.8.0<\\/li>\\n<li>General: Clean up javascript throughout plugin<\\/li>\\n<li>General: Replace deprecated jQuery functions<\\/li>\\n<\\/ul>\\n<h4> 1.12.3 <\\/h4>\\n<ul>\\n<li>WooCommerce: Fix quantity buttons in WP 5.6<\\/li>\\n<\\/ul>\\n<h4> 1.12.2 <\\/h4>\\n<ul>\\n<li>Blog: Load columns CSS when using filter to enable it anywhere<\\/li>\\n<li>Menu Plus: Fix sticky mobile header jump when using inline mobile toggle<\\/li>\\n<li>Menu Plus: Add margin to sticky nav branding when set to full width<\\/li>\\n<li>Menu Plus: Disable sticky nav container text align padding<\\/li>\\n<li>Menu Plus: Make mobile menu absolute only when smooth scroll is enabled<\\/li>\\n<li>Menu Plus: Improve nav as header\\/mobile header when using flexbox<\\/li>\\n<li>Menu Plus: Prevent off-canvas panel close button from flashing visible when closing<\\/li>\\n<li>Spacing: Fix custom nav search height<\\/li>\\n<\\/ul>\\n<h4> 1.12.1 <\\/h4>\\n<ul>\\n<li>Typography: Fix missing heading font size controls in the Customizer<\\/li>\\n<\\/ul>\\n<h4> 1.12.0 <\\/h4>\\n<ul>\\n<li>Blog: Fix column margin on mobile with some caching plugins<\\/li>\\n<li>Blog: Add post-load trigger to infinite scroll for better plugin compatibility<\\/li>\\n<li>Blog: Take generate_blog_columns filter into account when loading columns CSS<\\/li>\\n<li>Colors: Add search menu-bar-item color live preview to Customizer<\\/li>\\n<li>Elements: Fix broken custom hook field in Block Elements<\\/li>\\n<li>Elements: Integrate page hero with text container alignment in GP 3.0<\\/li>\\n<li>Elements: Better integrate Header Element colors with GP 3.0<\\/li>\\n<li>Elements: Only disable content title when {{post_title}} is present on single pages<\\/li>\\n<li>Elements: Fix  tag in metabox<\\/li>\\n<li>Elements: Add generate_elements_metabox_ajax_allow_editors filter<\\/li>\\n<li>Elements: Add new 3.0 hooks to hook selector<\\/li>\\n<li>Elements: Re-add generate_elements_custom_args filter<\\/li>\\n<li>Menu Plus: Better prepare navigation as header for GP 3.0<\\/li>\\n<li>Menu Plus: Better prepare Off-Canvas Panel for GP 3.0<\\/li>\\n<li>Menu Plus: Better prepare sticky navigation for GP 3.0<\\/li>\\n<li>Menu Plus: Add has-menu-bar-items class to mobile header if needed<\\/li>\\n<li>Menu Plus: Add is-logo-image class to all site logos<\\/li>\\n<li>Menu Plus: Fix mobile header alignment when it has menu bar items<\\/li>\\n<li>Secondary Nav: Better prepare sticky navigation for GP 3.0<\\/li>\\n<li>Secondary Nav: Fix hidden navigation widget in top bar when merged with secondary nav<\\/li>\\n<li>Sites: Improve the option-only import feature<\\/li>\\n<li>Sites: Improve the refresh sites button functionality<\\/li>\\n<li>Sites: Improve the undo site import functionality<\\/li>\\n<li>Sites: Fix Elementor site import issues<\\/li>\\n<li>Sites: Re-add Elementor sites to library<\\/li>\\n<li>Spacing: Better prepare Customizer live preview for GP 3.0<\\/li>\\n<li>Spacing: Fix blog column spacing Customizer live preview<\\/li>\\n<li>Spacing: Stop handling mobile header, widget and footer widget features added in GP 3.0<\\/li>\\n<li>Typography: Add mobile font size control for H3 (when using GP 3.0)<\\/li>\\n<li>Typography: Add mobile font size control for H4 (when using GP 3.0)<\\/li>\\n<li>Typography: Add mobile font size control for H5 (when using GP 3.0)<\\/li>\\n<li>Typography: Allow empty tablet and mobile site title font size values<\\/li>\\n<li>Typography: Make menu toggle CSS selector specific to primary navigation<\\/li>\\n<li>WooCommerce: Use CSS for secondary product image functionality instead of JS<\\/li>\\n<li>WooCommerce: Only load .js file if needed<\\/li>\\n<li>WooCommerce: Fix quantity box functionality when multiple quantity boxes exist on the page<\\/li>\\n<li>General: Improve alpha color picker script for better 5.5 compatibility<\\/li>\\n<li>General: Move child theme stylesheet after dynamic stylesheet if enabled<\\/li>\\n<li>General: Update gp-premium-de_DE.mo<\\/li>\\n<li>General: Update gp-premium-es_ES.mo<\\/li>\\n<li>General: Update gp-premium-fi.mo<\\/li>\\n<li>General: Update gp-premium-pt_PT.mo<\\/li>\\n<li>General: Update gp-premium-sv_SE.mo<\\/li>\\n<\\/ul>\\n<h4> 1.11.3 <\\/h4>\\n<ul>\\n<li>Blog: Set widths to grid-sizer element<\\/li>\\n<li>Elements: Fix legacy Page Header\\/Hooks buttons in the Elements dashboard<\\/li>\\n<li>Page Header: Replace .load() with .on(\'load\')<\\/li>\\n<li>Page Header: Fix color picker error in WP 5.5<\\/li>\\n<\\/ul>\\n<h4> 1.11.2 <\\/h4>\\n<ul>\\n<li>Blog: Remove negative featured image top margin from columns when using one container<\\/li>\\n<li>Blog: Fix infinite scroll items loading above viewport when using columns<\\/li>\\n<li>Blog: Fix infinite scroll featured images not displaying in Safari<\\/li>\\n<li>Elements: Prevent error in editor when generate_get_option() function doesn\'t exist<\\/li>\\n<li>General: Load inline CSS in previews when using external CSS option<\\/li>\\n<li>General: Update gp-premium-es_ES.mo<\\/li>\\n<li>General: Update gp-premium-pt_PT.mo<\\/li>\\n<\\/ul>\\n<h4> 1.11.1 <\\/h4>\\n<ul>\\n<li>Elements: Remove stray quote character in Layout Element metabox<\\/li>\\n<li>Sections: Fix color picker JS error in WP 5.5<\\/li>\\n<li>General: Fix external CSS option not removing inline CSS in some cases<\\/li>\\n<\\/ul>\\n<h4> 1.11.0 <\\/h4>\\n<ul>\\n<li>New: Block Elements<\\/li>\\n<li>New: Apply Layout Element options to the block editor if set<\\/li>\\n<li>New: Generate dynamic CSS in an external file<\\/li>\\n<li>Blog: Separate CSS and load only when needed<\\/li>\\n<li>Blog: Add column width classes to stylesheet<\\/li>\\n<li>Blog: Disable featured image itemprop if microdata is disabled<\\/li>\\n<li>Blog: Add generate_blog_masonry_init filter<\\/li>\\n<li>Blog: Add generate_blog_infinite_scroll_init filter<\\/li>\\n<li>Blog: Fix archive page header overlap when using no featured image padding\\/one container<\\/li>\\n<li>Blog: Replace screen reader text with aria-label in read more buttons<\\/li>\\n<li>Disable Elements: Add option to disable the Mobile Header<\\/li>\\n<li>Disable Elements: Disable top bar disables it even when combined with Secondary Nav<\\/li>\\n<li>Disable Elements: Use generate_show_post_navigation filter to disable single post navigation<\\/li>\\n<li>Elements: Use full hook name with generate_ prefix in dropdown<\\/li>\\n<li>Elements: Rebuild how Element types are chosen<\\/li>\\n<li>Elements: Add chosen hook under type column in edit.php<\\/li>\\n<li>Menu Plus: Add generate_after_mobile_header_menu_button filter<\\/li>\\n<li>Menu Plus: Add sticky placeholder only when nav becomes sticky<\\/li>\\n<li>Menu Plus: Add class to sticky nav when scrolling up<\\/li>\\n<li>Menu Plus: Fix navigation branding\\/mobile header layout when using RTL languages<\\/li>\\n<li>Page Header: Prevent PHP notices<\\/li>\\n<li>Secondary Nav: Clean up CSS<\\/li>\\n<li>Secondary Nav: Add generate_after_secondary_navigation hook<\\/li>\\n<li>Secondary Nav: Add generate_before_secondary_navigation hook<\\/li>\\n<li>Secondary Nav: Integrate with future flexbox option<\\/li>\\n<li>Secondary Nav: Add has-top-bar class if needed<\\/li>\\n<li>Secondary Nav: Add screen reader text to mobile menu toggle if no text exists<\\/li>\\n<li>Secondary Nav: Remove microdata if disabled<\\/li>\\n<li>Secondary Nav: Add generate_secondary_menu_bar_items hook<\\/li>\\n<li>Spacing: Set sidebar width in Customizer for future flexbox option<\\/li>\\n<li>WooCommerce: Add generate_woocommerce_show_add_to_cart_panel filter<\\/li>\\n<li>WooCommerce: Integrate with future flexbox option<\\/li>\\n<li>WooCommerce: Ensure WC()-&gt;cart is set<\\/li>\\n<li>WooCommerce: Remove left margin from SVG menu cart icon<\\/li>\\n<li>WooCommerce: Show sticky add to cart panel on sold individually products<\\/li>\\n<li>WooCommerce: Remove bottom margin from related\\/upsell products<\\/li>\\n<li>WooCommerce: Fix cart menu item spacing in RTL languages<\\/li>\\n<li>WooCommerce: Fix menu item cart dropdown design in RTL languages<\\/li>\\n<li>General: Update selectWoo<\\/li>\\n<li>General: Update select2<\\/li>\\n<li>General: Run all CSS through PostCSS<\\/li>\\n<li>General: Fix various text domains<\\/li>\\n<li>General: Fix JS error when toggling nav as header option without Colors\\/Typography modules<\\/li>\\n<li>General: Update all translations over 90% complete<\\/li>\\n<li>General: PHP cleanup\\/coding standards<\\/li>\\n<li>General: Add off_canvas_desktop_toggle_label to wpml-config.xml<\\/li>\\n<\\/ul>\\n<h4> 1.10.0 <\\/h4>\\n<ul>\\n<li>Blog: Remove existing on-the-fly featured image resizer (Image Processing Queue)<\\/li>\\n<li>Blog: Choose from existing image sizes for featured images<\\/li>\\n<li>Blog: Use CSS to further resize featured images if necessary<\\/li>\\n<li>Blog: Fix edge case persistent transient bug with old image resizer<\\/li>\\n<li>Elements: Fix broken closing element in metabox<\\/li>\\n<li>General: Change scroll variable to gpscroll in smooth scroll script to avoid conflicts<\\/li>\\n<li>General: Update responsive widths in Customizer<\\/li>\\n<li>General: Fix responsive Customizer views when using RTL<\\/li>\\n<li>Menu Plus: Don\'t output sticky nav branding if sticky nav is disabled<\\/li>\\n<li>Menu Plus: Fix focus when off canvas overlay is opened (a11y)<\\/li>\\n<li>Menu Plus: Fix sticky navigation jump when navigation branding is in use<\\/li>\\n<li>Sections: Fix visible block editor when Sections are enabled<\\/li>\\n<li>WooCommerce: Use minmax in grid template definitions to fix overflow issue<\\/li>\\n<li>WooCommerce: Prevent add to cart panel interfering with back to top button on mobile<\\/li>\\n<li>WooCommerce: WooCommerce: Fix secondary image position if HTML isn\'t ordered correctly<\\/li>\\n<li>General: Add\\/update all translations over 50% complete. Big thanks to all contributors!<\\/li>\\n<li>Translation: Added Arabic - thank you anass!<\\/li>\\n<li>Translation: Added Bengali - thank you gtmroy!<\\/li>\\n<li>Translation: Added Spanish (Spain) - thank you davidperez (closemarketing.es)!<\\/li>\\n<li>Translation: Added Spanish (Argentina) - thank you bratorr!<\\/li>\\n<li>Translation: Added Finnish - thank you Stedi!<\\/li>\\n<li>Translation: Add Dutch - thank you Robin!<\\/li>\\n<li>Translation: Added Ukrainian - thank you EUROMEDIA!<\\/li>\\n<li>Translation: Vietnamese added - thank you themevi!<\\/li>\\n<\\/ul>\\n<h4> 1.9.1 <\\/h4>\\n<ul>\\n<li>Blog: Fix &quot;null&quot; in infinite scroll load more button text<\\/li>\\n<li>WooCommerce: Fix hidden added to cart panel on mobile when sticky nav active<\\/li>\\n<li>WooCommerce: Fix missing SVG icon in mobile added to cart panel<\\/li>\\n<\\/ul>\\n<h4> 1.9.0 <\\/h4>\\n<ul>\\n<li>Blog: Support SVG icon feature<\\/li>\\n<li>Colors: Add navigation search color options<\\/li>\\n<li>Disable Elements: Disable mobile menu in Mobile Header if nav is disabled<\\/li>\\n<li>Elements: Add wp_body_open hook<\\/li>\\n<li>Elements: Allow 0 mobile padding in Elements<\\/li>\\n<li>Elements: Add generate_elements_admin_menu_capability filter<\\/li>\\n<li>Elements: Add generate_page_hero_css_output filter<\\/li>\\n<li>Elements: Prevent error in Header Element if taxonomy doesn\'t exist<\\/li>\\n<li>Elements: Fix double logo when Header Element has logo + using nav as header<\\/li>\\n<li>Elements: Fix mobile header logo not replacing if merge is disabled<\\/li>\\n<li>Elements: Fix missing arrow in Choose Element Type select in WP 5.3<\\/li>\\n<li>Elements: Add generate_inside_site_container hook option<\\/li>\\n<li>Elements: Add generate_after_entry_content hook option<\\/li>\\n<li>Menu Plus: Add off canvas desktop toggle label option<\\/li>\\n<li>Menu Plus: Add generate_off_canvas_toggle_output filter<\\/li>\\n<li>Menu Plus: Support SVG icon feature<\\/li>\\n<li>Menu Plus: Fix sticky navigation overlapping BB controls<\\/li>\\n<li>Menu Plus: Add align-items: center to nav as header, mobile header and sticky nav with branding<\\/li>\\n<li>Sections: Fix text\\/visual switch bug in Firefox<\\/li>\\n<li>Sites: Add option to revert site import<\\/li>\\n<li>Sites: Increase site library limit to 100<\\/li>\\n<li>Spacing: Add live preview to group container padding<\\/li>\\n<li>Typography: Add tablet site title\\/navigation font size options<\\/li>\\n<li>Typography: Add archive post title weight, transform, font size and line height<\\/li>\\n<li>Typography: Add single content title weight, transform, font size and line height<\\/li>\\n<li>Typography: Only call all google fonts once in the Customizer<\\/li>\\n<li>Typography: Get Google fonts from readable JSON list<\\/li>\\n<li>Typography: Make sure font settings aren\'t lost if list is changed<\\/li>\\n<li>Typography: Only call generate_get_all_google_fonts if needed<\\/li>\\n<li>WooCommerce: Add columns gap options (desktop, tablet, mobile)<\\/li>\\n<li>WooCommerce: Add tablet column options<\\/li>\\n<li>WooCommerce: Add related\\/upsell tablet column options<\\/li>\\n<li>WooCommerce: Support SVG icon feature<\\/li>\\n<li>WooCommerce: Prevent empty added to cart panel on single products<\\/li>\\n<li>WooCommerce: Fix woocommerce-ordering arrow in old FF versions<\\/li>\\n<li>WooCommerce: Make item\\/items string translatable<\\/li>\\n<li>General: Better customizer device widths<\\/li>\\n<li>General: Use generate_premium_get_media_query throughout modules<\\/li>\\n<li>General: Improve Customizer control styling<\\/li>\\n<\\/ul>\\n<h4> 1.8.3 <\\/h4>\\n<ul>\\n<li>Menu Plus: Use flexbox for center aligned nav with nav branding<\\/li>\\n<li>Menu Plus: Center overlay off canvas exit button on mobile<\\/li>\\n<li>Menu Plus: Add alt tag to sticky nav logo<\\/li>\\n<li>Menu Plus: Set generate_not_mobile_menu_media_query filter based on mobile menu breakpoint<\\/li>\\n<li>Sections: Remember when text tab is active<\\/li>\\n<li>Sections: Disable visual editor if turned off in profile<\\/li>\\n<li>Typography: Add generate_google_font_display filter<\\/li>\\n<li>WooCommerce: Fix single product sidebar layout metabox option<\\/li>\\n<li>WooCommerce: Reduce carousel thumbnail max-width to 100px to match new thumbnail sizes<\\/li>\\n<\\/ul>\\n<h4> 1.8.2 <\\/h4>\\n<ul>\\n<li>Elements: Use Page Hero site title color for mobile header site title<\\/li>\\n<li>Menu Plus: Give mobile header site title more left spacing<\\/li>\\n<li>Menu Plus: Fix nav search icon in sticky navigation when using nav branding in Firefox<\\/li>\\n<li>Site Library: Show Site Library tab even if no sites exist<\\/li>\\n<li>Site Library: Show an error message in Site Library if no sites exist<\\/li>\\n<li>Typography: Remove reference to generate_get_navigation_location() function<\\/li>\\n<li>WooCommerce: Remove quantity field arrows when using quantity buttons in Firefox<\\/li>\\n<li>WooCommerce: Remove extra border when loading quantity buttons<\\/li>\\n<li>WooCommerce: Use get_price_html() is sticky add to cart panel<\\/li>\\n<\\/ul>\\n<h4> 1.8.1 <\\/h4>\\n<ul>\\n<li>Menu Plus: Revert sticky nav duplicate ID fix due to Cyrillic script bug<\\/li>\\n<\\/ul>\\n<h4> 1.8 <\\/h4>\\n<ul>\\n<li>Blog: Apply columns filter to masonry grid sizer<\\/li>\\n<li>Colors: Merge Footer Widgets and Footer controls in Color panel<\\/li>\\n<li>Colors: Remove edit_theme_options capability to Customizer controls (set by default)<\\/li>\\n<li>Disable Elements: Make sure mobile header is disabled when primary navigation is disabled<\\/li>\\n<li>Elements: Add content width option in Layout Element<\\/li>\\n<li>Elements: Fix mobile header logo when mobile menu toggled<\\/li>\\n<li>Elements: Add generate_page_hero_location filter<\\/li>\\n<li>Elements: Add generate_elements_show_object_ids filter to show IDs in Display Rule values<\\/li>\\n<li>Elements: Prevent merged header wrap from conflicting with Elementor controls<\\/li>\\n<li>Elements: Change Container tab name to Content<\\/li>\\n<li>Elements: Add woocommerce_share option to Hooks<\\/li>\\n<li>Elements: Improve WPML compatibility<\\/li>\\n<li>Elements: Improve Polylang compatibility<\\/li>\\n<li>Elements: Prevent PHP notices when adding taxonomy locations to non-existent archives<\\/li>\\n<li>Elements: Add generate_mobile_cart_items hook to hook list<\\/li>\\n<li>Elements: Add generate_element_post_id filter<\\/li>\\n<li>Elements: Escape HTML elements inside Element textarea<\\/li>\\n<li>Elements: Add Beaver Builder templates to the Display Rules<\\/li>\\n<li>Menu Plus: Add mobile header breakpoint option<\\/li>\\n<li>Menu Plus: Add off canvas overlay option<\\/li>\\n<li>Menu Plus: Add navigation as header option<\\/li>\\n<li>Menu Plus: Remove navigation logo option if navigation as header set<\\/li>\\n<li>Menu Plus: Add sticky navigation logo option<\\/li>\\n<li>Menu Plus: Allow site title in mobile header instead of logo<\\/li>\\n<li>Menu Plus: Add option to move exit button inside the off canvas panel<\\/li>\\n<li>Menu Plus: Change Slideout Navigation name to Off Canvas Panel<\\/li>\\n<li>Menu Plus: Only re-focus after slideout close on escape key<\\/li>\\n<li>Menu Plus: Give close slideout event a name so it can be removed<\\/li>\\n<li>Menu Plus: Remove invalid transition-delay<\\/li>\\n<li>Menu Plus: Improve slideout overlay transition<\\/li>\\n<li>Menu Plus: Add mobile open\\/close icons to GPP font<\\/li>\\n<li>Menu Plus: Allow dynamic widget classes in off canvas panel (fixes WC range slider widget issue)<\\/li>\\n<li>Menu Plus: Basic compatibility with future SVG icons<\\/li>\\n<li>Menu Plus: Prevent duplicate IDs when sticky navigation is cloned<\\/li>\\n<li>Secondary Nav: Add dropdown direction option<\\/li>\\n<li>Secondary Nav: Basic compatibility with future SVG icons<\\/li>\\n<li>Sections: Fix section editor issues in WP 5.0<\\/li>\\n<li>Sections: Show Better Font Awesome icon in editor<\\/li>\\n<li>Sites: Re-design UI<\\/li>\\n<li>Sites: Add option to activate as a module like all the other modules<\\/li>\\n<li>Sites: Don\'t show backup options button if no options exist<\\/li>\\n<li>Sites: Make JS action classes more specific to the site library<\\/li>\\n<li>Sites: Set mime types of content.xml and widgets.wie<\\/li>\\n<li>Spacing: Add header padding option for mobile<\\/li>\\n<li>Spacing: Add widget padding option for mobile<\\/li>\\n<li>Spacing: Add footer widgets padding option for mobile<\\/li>\\n<li>Spacing: Add content separator option<\\/li>\\n<li>Spacing: Apply mobile menu item width to mobile bar only<\\/li>\\n<li>WooCommerce: Add option for mini cart in the menu<\\/li>\\n<li>WooCommerce: Add option to open off overlay panel on add to cart<\\/li>\\n<li>WooCommerce: Add option to open sticky add to cart panel on single products<\\/li>\\n<li>WooCommerce: Add option to add +\\/- buttons to the quantity fields<\\/li>\\n<li>WooCommerce: Add option to show number of items in cart menu item<\\/li>\\n<li>WooCommerce: Add option to choose single product image area width<\\/li>\\n<li>WooCommerce: Add color options for price slider widget<\\/li>\\n<li>WooCommerce: Use CSS grid for the product archives<\\/li>\\n<li>WooCommerce: Horizontally align add to cart buttons<\\/li>\\n<li>WooCommerce: Re-design the cart widget<\\/li>\\n<li>WooCommerce: Tighten up product info spacing<\\/li>\\n<li>WooCommerce: Improve product tab design to look more like tabs<\\/li>\\n<li>WooCommerce: Simplify single product image display<\\/li>\\n<li>WooCommerce: Use flexbox for quantity\\/add to cart alignment<\\/li>\\n<li>WooCommerce: Improve rating star styles<\\/li>\\n<li>WooCommerce: Use product alignment setting for related\\/upsell products<\\/li>\\n<li>WooCommerce: Remove bottom margin from product image<\\/li>\\n<li>WooCommerce: Organize colors in the Customizer<\\/li>\\n<li>WooCommerce: Remove title attribute from menu cart item<\\/li>\\n<li>WooCommerce: Improve coupon field design<\\/li>\\n<li>WooCommerce: Improve result count\\/ordering styling<\\/li>\\n<li>WooCommerce: Add gap around WC single product images<\\/li>\\n<li>WooCommerce: Remove arrow from checkout button<\\/li>\\n<li>WooCommerce: Hide view cart link on add to cart click<\\/li>\\n<li>WooCommerce: Organize CSS<\\/li>\\n<li>Introduce in-Customizer shortcuts<\\/li>\\n<li>Add generate_disable_customizer_shortcuts filter<\\/li>\\n<\\/ul>\"],\"plugin\":\"gp-premium\\/gp-premium.php\",\"id\":\"gp-premium\\/gp-premium.php\"}\";}", "no");
INSERT INTO `wpeng_options` VALUES("17226", "rewrite_rules", "a:107:{s:19:\"sitemap_index\\.xml$\";s:19:\"index.php?sitemap=1\";s:31:\"([^/]+?)-sitemap([0-9]+)?\\.xml$\";s:51:\"index.php?sitemap=$matches[1]&sitemap_n=$matches[2]\";s:24:\"([a-z]+)?-?sitemap\\.xsl$\";s:39:\"index.php?yoast-sitemap-xsl=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:37:\"gp_elements/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"gp_elements/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"gp_elements/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"gp_elements/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"gp_elements/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"gp_elements/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"gp_elements/(.+?)/embed/?$\";s:44:\"index.php?gp_elements=$matches[1]&embed=true\";s:30:\"gp_elements/(.+?)/trackback/?$\";s:38:\"index.php?gp_elements=$matches[1]&tb=1\";s:38:\"gp_elements/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?gp_elements=$matches[1]&paged=$matches[2]\";s:45:\"gp_elements/(.+?)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?gp_elements=$matches[1]&cpage=$matches[2]\";s:34:\"gp_elements/(.+?)(?:/([0-9]+))?/?$\";s:50:\"index.php?gp_elements=$matches[1]&page=$matches[2]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `wpeng_options` VALUES("17234", "generateblocks_dynamic_css_posts", "a:0:{}", "yes");
INSERT INTO `wpeng_options` VALUES("17235", "generateblocks_dynamic_css_time", "1651653497", "yes");
INSERT INTO `wpeng_options` VALUES("17237", "generateblocks_version", "1.8.1", "yes");
INSERT INTO `wpeng_options` VALUES("17254", "theme_mods_generatepress_child", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;s:11:\"custom_logo\";s:0:\"\";}", "yes");
INSERT INTO `wpeng_options` VALUES("17303", "_transient_health-check-site-status-result", "{\"good\":14,\"recommended\":5,\"critical\":3}", "yes");
INSERT INTO `wpeng_options` VALUES("17369", "generatepress_dynamic_css_data", "a:0:{}", "yes");
INSERT INTO `wpeng_options` VALUES("17490", "webpc_notice_avif_support", "1690988075", "yes");
INSERT INTO `wpeng_options` VALUES("17504", "fs_active_plugins", "O:8:\"stdClass\":3:{s:7:\"plugins\";a:1:{s:20:\"gutenslider/freemius\";O:8:\"stdClass\":4:{s:7:\"version\";s:6:\"2.5.10\";s:4:\"type\";s:6:\"plugin\";s:9:\"timestamp\";i:1688631919;s:11:\"plugin_path\";s:33:\"gutenslider/eedee-gutenslider.php\";}}s:7:\"abspath\";s:46:\"/home/demod4u/public_html/wordpress.engine.gp/\";s:6:\"newest\";O:8:\"stdClass\":5:{s:11:\"plugin_path\";s:33:\"gutenslider/eedee-gutenslider.php\";s:8:\"sdk_path\";s:20:\"gutenslider/freemius\";s:7:\"version\";s:6:\"2.5.10\";s:13:\"in_activation\";b:0;s:9:\"timestamp\";i:1688631919;}}", "yes");
INSERT INTO `wpeng_options` VALUES("17505", "fs_debug_mode", "", "yes");
INSERT INTO `wpeng_options` VALUES("17506", "fs_accounts", "a:6:{s:21:\"id_slug_type_path_map\";a:1:{i:3804;a:3:{s:4:\"slug\";s:11:\"gutenslider\";s:4:\"type\";s:6:\"plugin\";s:4:\"path\";s:33:\"gutenslider/eedee-gutenslider.php\";}}s:11:\"plugin_data\";a:1:{s:11:\"gutenslider\";a:18:{s:16:\"plugin_main_file\";O:8:\"stdClass\":1:{s:4:\"path\";s:33:\"gutenslider/eedee-gutenslider.php\";}s:20:\"is_network_activated\";b:0;s:17:\"install_timestamp\";i:1652970149;s:17:\"was_plugin_loaded\";b:1;s:21:\"is_plugin_new_install\";b:0;s:16:\"sdk_last_version\";s:5:\"2.5.2\";s:11:\"sdk_version\";s:6:\"2.5.10\";s:16:\"sdk_upgrade_mode\";b:1;s:18:\"sdk_downgrade_mode\";b:0;s:19:\"plugin_last_version\";s:6:\"5.10.1\";s:14:\"plugin_version\";s:6:\"5.10.2\";s:19:\"plugin_upgrade_mode\";b:1;s:21:\"plugin_downgrade_mode\";b:0;s:17:\"connectivity_test\";a:6:{s:12:\"is_connected\";b:1;s:4:\"host\";s:30:\"wordpress.engine.gp.demod4u.gr\";s:9:\"server_ip\";s:10:\"62.1.78.39\";s:9:\"is_active\";b:1;s:9:\"timestamp\";i:1652970149;s:7:\"version\";s:5:\"5.8.0\";}s:15:\"prev_is_premium\";b:0;s:12:\"is_anonymous\";a:3:{s:2:\"is\";b:1;s:9:\"timestamp\";i:1652970155;s:7:\"version\";s:5:\"5.8.0\";}s:21:\"trial_promotion_shown\";i:1662621827;s:30:\"affiliate_program_notice_shown\";i:1655803332;}}s:13:\"file_slug_map\";a:1:{s:33:\"gutenslider/eedee-gutenslider.php\";s:11:\"gutenslider\";}s:7:\"plugins\";a:1:{s:11:\"gutenslider\";O:9:\"FS_Plugin\":24:{s:16:\"parent_plugin_id\";N;s:5:\"title\";s:61:\"Gutenslider — The last WordPress slider you will ever need.\";s:4:\"slug\";s:11:\"gutenslider\";s:12:\"premium_slug\";s:19:\"gutenslider-premium\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";s:8:\"selected\";s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";N;s:4:\"file\";s:33:\"gutenslider/eedee-gutenslider.php\";s:7:\"version\";s:6:\"5.10.2\";s:11:\"auto_update\";N;s:4:\"info\";N;s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:17:\"opt_in_moderation\";N;s:10:\"public_key\";s:32:\"pk_b1382b7052729d6937e614cebce0a\";s:10:\"secret_key\";N;s:2:\"id\";s:4:\"3804\";s:7:\"updated\";N;s:7:\"created\";N;s:22:\"\0FS_Entity\0_is_updated\";b:1;}}s:9:\"unique_id\";s:32:\"8a2eb259f05d0e8d96da239495909fc6\";s:13:\"admin_notices\";a:1:{s:11:\"gutenslider\";a:1:{s:15:\"trial_promotion\";a:8:{s:7:\"message\";s:468:\"Hey! How do you like <b>Gutenslider — The last WordPress slider you will ever need.</b> so far? Test all our awesome premium features with a 7-day free trial. No credit card required!  <a style=\"margin-left: 10px; vertical-align: super;\" href=\"https://wordpress.engine.gp.demod4u.gr/wp-admin/options-general.php?billing_cycle=annual&trial=true&page=settings-page-gutenslider-pricing\"><button class=\"button button-primary\">Start free trial &nbsp;&#10140;</button></a>\";s:5:\"title\";s:0:\"\";s:4:\"type\";s:9:\"promotion\";s:6:\"sticky\";b:1;s:2:\"id\";s:15:\"trial_promotion\";s:10:\"manager_id\";s:11:\"gutenslider\";s:6:\"plugin\";s:61:\"Gutenslider — The last WordPress slider you will ever need.\";s:10:\"wp_user_id\";N;}}}}", "yes");
INSERT INTO `wpeng_options` VALUES("17507", "fs_gdpr", "a:1:{s:2:\"u3\";a:1:{s:8:\"required\";b:0;}}", "yes");
INSERT INTO `wpeng_options` VALUES("17508", "fs_api_cache", "a:0:{}", "no");
INSERT INTO `wpeng_options` VALUES("17886", "webpc_notice_litespeed", "", "yes");
INSERT INTO `wpeng_options` VALUES("17955", "duplicate_post_version", "4.5", "yes");
INSERT INTO `wpeng_options` VALUES("18151", "user_count", "10", "no");
INSERT INTO `wpeng_options` VALUES("18157", "can_compress_scripts", "0", "no");
INSERT INTO `wpeng_options` VALUES("18871", "webpc_notice_upgrade", "1664186626", "yes");
INSERT INTO `wpeng_options` VALUES("19389", "resmushit_notice_close", "0", "yes");
INSERT INTO `wpeng_options` VALUES("20568", "duplicator_activated", "a:1:{s:4:\"lite\";i:1676452134;}", "yes");
INSERT INTO `wpeng_options` VALUES("21670", "_site_transient_webpc_error_detector", "1678443107067", "no");
INSERT INTO `wpeng_options` VALUES("21671", "webpc_errors_cache", "a:0:{}", "yes");
INSERT INTO `wpeng_options` VALUES("21672", "webpc_stats_webp_all", "0", "yes");
INSERT INTO `wpeng_options` VALUES("21673", "webpc_stats_webp_unconverted", "0", "yes");
INSERT INTO `wpeng_options` VALUES("21674", "webpc_stats_avif_all", "0", "yes");
INSERT INTO `wpeng_options` VALUES("21675", "webpc_stats_avif_unconverted", "0", "yes");
INSERT INTO `wpeng_options` VALUES("22027", "duplicator_uninstall_package", "1", "yes");
INSERT INTO `wpeng_options` VALUES("22028", "duplicator_uninstall_settings", "1", "yes");
INSERT INTO `wpeng_options` VALUES("22404", "generate_dynamic_css_output", "body{background-color:var(--base-2);color:var(--contrast);}a{color:var(--accent);}a{text-decoration:underline;}.entry-title a, .site-branding a, a.button, .wp-block-button__link, .main-navigation a{text-decoration:none;}a:hover, a:focus, a:active{color:var(--contrast);}.wp-block-group__inner-container{max-width:1200px;margin-left:auto;margin-right:auto;}:root{--contrast:#222222;--contrast-2:#575760;--contrast-3:#b2b2be;--base:#f0f0f0;--base-2:#f7f8f9;--base-3:#ffffff;--accent:#1e73be;}:root .has-contrast-color{color:var(--contrast);}:root .has-contrast-background-color{background-color:var(--contrast);}:root .has-contrast-2-color{color:var(--contrast-2);}:root .has-contrast-2-background-color{background-color:var(--contrast-2);}:root .has-contrast-3-color{color:var(--contrast-3);}:root .has-contrast-3-background-color{background-color:var(--contrast-3);}:root .has-base-color{color:var(--base);}:root .has-base-background-color{background-color:var(--base);}:root .has-base-2-color{color:var(--base-2);}:root .has-base-2-background-color{background-color:var(--base-2);}:root .has-base-3-color{color:var(--base-3);}:root .has-base-3-background-color{background-color:var(--base-3);}:root .has-accent-color{color:var(--accent);}:root .has-accent-background-color{background-color:var(--accent);}.top-bar{background-color:#636363;color:#ffffff;}.top-bar a{color:#ffffff;}.top-bar a:hover{color:#303030;}.site-header{background-color:var(--base-3);}.main-title a,.main-title a:hover{color:var(--contrast);}.site-description{color:var(--contrast-2);}.mobile-menu-control-wrapper .menu-toggle,.mobile-menu-control-wrapper .menu-toggle:hover,.mobile-menu-control-wrapper .menu-toggle:focus,.has-inline-mobile-toggle #site-navigation.toggled{background-color:rgba(0, 0, 0, 0.02);}.main-navigation,.main-navigation ul ul{background-color:var(--base-3);}.main-navigation .main-nav ul li a, .main-navigation .menu-toggle, .main-navigation .menu-bar-items{color:var(--contrast);}.main-navigation .main-nav ul li:not([class*=\"current-menu-\"]):hover > a, .main-navigation .main-nav ul li:not([class*=\"current-menu-\"]):focus > a, .main-navigation .main-nav ul li.sfHover:not([class*=\"current-menu-\"]) > a, .main-navigation .menu-bar-item:hover > a, .main-navigation .menu-bar-item.sfHover > a{color:var(--accent);}button.menu-toggle:hover,button.menu-toggle:focus{color:var(--contrast);}.main-navigation .main-nav ul li[class*=\"current-menu-\"] > a{color:var(--accent);}.navigation-search input[type=\"search\"],.navigation-search input[type=\"search\"]:active, .navigation-search input[type=\"search\"]:focus, .main-navigation .main-nav ul li.search-item.active > a, .main-navigation .menu-bar-items .search-item.active > a{color:var(--accent);}.main-navigation ul ul{background-color:var(--base);}.separate-containers .inside-article, .separate-containers .comments-area, .separate-containers .page-header, .one-container .container, .separate-containers .paging-navigation, .inside-page-header{background-color:var(--base-3);}.entry-title a{color:var(--contrast);}.entry-title a:hover{color:var(--contrast-2);}.entry-meta{color:var(--contrast-2);}.sidebar .widget{background-color:var(--base-3);}.footer-widgets{background-color:var(--base-3);}.site-info{background-color:var(--base-3);}input[type=\"text\"],input[type=\"email\"],input[type=\"url\"],input[type=\"password\"],input[type=\"search\"],input[type=\"tel\"],input[type=\"number\"],textarea,select{color:var(--contrast);background-color:var(--base-2);border-color:var(--base);}input[type=\"text\"]:focus,input[type=\"email\"]:focus,input[type=\"url\"]:focus,input[type=\"password\"]:focus,input[type=\"search\"]:focus,input[type=\"tel\"]:focus,input[type=\"number\"]:focus,textarea:focus,select:focus{color:var(--contrast);background-color:var(--base-2);border-color:var(--contrast-3);}button,html input[type=\"button\"],input[type=\"reset\"],input[type=\"submit\"],a.button,a.wp-block-button__link:not(.has-background){color:#ffffff;background-color:#55555e;}button:hover,html input[type=\"button\"]:hover,input[type=\"reset\"]:hover,input[type=\"submit\"]:hover,a.button:hover,button:focus,html input[type=\"button\"]:focus,input[type=\"reset\"]:focus,input[type=\"submit\"]:focus,a.button:focus,a.wp-block-button__link:not(.has-background):active,a.wp-block-button__link:not(.has-background):focus,a.wp-block-button__link:not(.has-background):hover{color:#ffffff;background-color:#3f4047;}a.generate-back-to-top{background-color:rgba( 0,0,0,0.4 );color:#ffffff;}a.generate-back-to-top:hover,a.generate-back-to-top:focus{background-color:rgba( 0,0,0,0.6 );color:#ffffff;}:root{--gp-search-modal-bg-color:var(--base-3);--gp-search-modal-text-color:var(--contrast);--gp-search-modal-overlay-bg-color:rgba(0,0,0,0.2);}@media (max-width:768px){.main-navigation .menu-bar-item:hover > a, .main-navigation .menu-bar-item.sfHover > a{background:none;color:var(--contrast);}}.nav-below-header .main-navigation .inside-navigation.grid-container, .nav-above-header .main-navigation .inside-navigation.grid-container{padding:0px 20px 0px 20px;}.site-main .wp-block-group__inner-container{padding:40px;}.separate-containers .paging-navigation{padding-top:20px;padding-bottom:20px;}.entry-content .alignwide, body:not(.no-sidebar) .entry-content .alignfull{margin-left:-40px;width:calc(100% + 80px);max-width:calc(100% + 80px);}.rtl .menu-item-has-children .dropdown-menu-toggle{padding-left:20px;}.rtl .main-navigation .main-nav ul li.menu-item-has-children > a{padding-right:20px;}@media (max-width:768px){.separate-containers .inside-article, .separate-containers .comments-area, .separate-containers .page-header, .separate-containers .paging-navigation, .one-container .site-content, .inside-page-header{padding:30px;}.site-main .wp-block-group__inner-container{padding:30px;}.inside-top-bar{padding-right:30px;padding-left:30px;}.inside-header{padding-right:30px;padding-left:30px;}.widget-area .widget{padding-top:30px;padding-right:30px;padding-bottom:30px;padding-left:30px;}.footer-widgets-container{padding-top:30px;padding-right:30px;padding-bottom:30px;padding-left:30px;}.inside-site-info{padding-right:30px;padding-left:30px;}.entry-content .alignwide, body:not(.no-sidebar) .entry-content .alignfull{margin-left:-30px;width:calc(100% + 60px);max-width:calc(100% + 60px);}.one-container .site-main .paging-navigation{margin-bottom:20px;}}", "yes");
INSERT INTO `wpeng_options` VALUES("22405", "generate_dynamic_css_cached_version", "3.3.0", "yes");
INSERT INTO `wpeng_options` VALUES("27540", "duplicator_notifications", "a:4:{s:6:\"update\";i:1690445475;s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}", "yes");
INSERT INTO `wpeng_options` VALUES("28989", "_site_transient_timeout_browser_14d58a1ba286f087d9736249ec785314", "1690880912", "no");
INSERT INTO `wpeng_options` VALUES("28990", "_site_transient_browser_14d58a1ba286f087d9736249ec785314", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"114.0.0.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "no");
INSERT INTO `wpeng_options` VALUES("28991", "_site_transient_timeout_php_check_990bfacb848fa087bcfc06850f5e4447", "1690880912", "no");
INSERT INTO `wpeng_options` VALUES("28992", "_site_transient_php_check_990bfacb848fa087bcfc06850f5e4447", "a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:3:\"7.0\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}", "no");
INSERT INTO `wpeng_options` VALUES("29012", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:62:\"https://downloads.wordpress.org/release/el/wordpress-6.2.2.zip\";s:6:\"locale\";s:2:\"el\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:62:\"https://downloads.wordpress.org/release/el/wordpress-6.2.2.zip\";s:10:\"no_content\";s:0:\"\";s:11:\"new_bundled\";s:0:\"\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.2.2\";s:7:\"version\";s:5:\"6.2.2\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"6.1\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1690448453;s:15:\"version_checked\";s:5:\"6.2.2\";s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `wpeng_options` VALUES("29014", "_site_transient_update_themes", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1690445496;s:7:\"checked\";a:3:{s:13:\"generatepress\";s:5:\"3.3.0\";s:19:\"generatepress_child\";s:3:\"0.1\";s:17:\"twentytwentythree\";s:3:\"1.1\";}s:8:\"response\";a:0:{}s:9:\"no_update\";a:2:{s:13:\"generatepress\";a:6:{s:5:\"theme\";s:13:\"generatepress\";s:11:\"new_version\";s:5:\"3.3.0\";s:3:\"url\";s:43:\"https://wordpress.org/themes/generatepress/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/theme/generatepress.3.3.0.zip\";s:8:\"requires\";s:3:\"5.2\";s:12:\"requires_php\";s:3:\"5.6\";}s:17:\"twentytwentythree\";a:6:{s:5:\"theme\";s:17:\"twentytwentythree\";s:11:\"new_version\";s:3:\"1.1\";s:3:\"url\";s:47:\"https://wordpress.org/themes/twentytwentythree/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/theme/twentytwentythree.1.1.zip\";s:8:\"requires\";s:3:\"6.1\";s:12:\"requires_php\";s:3:\"5.6\";}}s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `wpeng_options` VALUES("29192", "_site_transient_timeout_available_translations", "1690456277", "no");
INSERT INTO `wpeng_options` VALUES("29193", "_site_transient_available_translations", "a:131:{s:2:\"af\";a:8:{s:8:\"language\";s:2:\"af\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-05-13 15:59:22\";s:12:\"english_name\";s:9:\"Afrikaans\";s:11:\"native_name\";s:9:\"Afrikaans\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/af.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"af\";i:2;s:3:\"afr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Gaan voort\";}}s:2:\"am\";a:8:{s:8:\"language\";s:2:\"am\";s:7:\"version\";s:5:\"6.0.5\";s:7:\"updated\";s:19:\"2022-09-29 20:43:49\";s:12:\"english_name\";s:7:\"Amharic\";s:11:\"native_name\";s:12:\"አማርኛ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.5/am.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"am\";i:2;s:3:\"amh\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"ቀጥል\";}}s:3:\"arg\";a:8:{s:8:\"language\";s:3:\"arg\";s:7:\"version\";s:8:\"6.2-beta\";s:7:\"updated\";s:19:\"2022-09-22 16:46:56\";s:12:\"english_name\";s:9:\"Aragonese\";s:11:\"native_name\";s:9:\"Aragonés\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.2-beta/arg.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"an\";i:2;s:3:\"arg\";i:3;s:3:\"arg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continar\";}}s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-06-18 08:25:23\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.2.2/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"متابعة\";}}s:3:\"ary\";a:8:{s:8:\"language\";s:3:\"ary\";s:7:\"version\";s:6:\"4.8.22\";s:7:\"updated\";s:19:\"2017-01-26 15:42:35\";s:12:\"english_name\";s:15:\"Moroccan Arabic\";s:11:\"native_name\";s:31:\"العربية المغربية\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.22/ary.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:3;s:3:\"ary\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"as\";a:8:{s:8:\"language\";s:2:\"as\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-06-17 14:44:15\";s:12:\"english_name\";s:8:\"Assamese\";s:11:\"native_name\";s:21:\"অসমীয়া\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.2.2/as.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"as\";i:2;s:3:\"asm\";i:3;s:3:\"asm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:3:\"azb\";a:8:{s:8:\"language\";s:3:\"azb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-12 20:34:31\";s:12:\"english_name\";s:17:\"South Azerbaijani\";s:11:\"native_name\";s:29:\"گؤنئی آذربایجان\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/azb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:3;s:3:\"azb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-06 00:09:27\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:3:\"bel\";a:8:{s:8:\"language\";s:3:\"bel\";s:7:\"version\";s:6:\"4.9.23\";s:7:\"updated\";s:19:\"2019-10-29 07:54:22\";s:12:\"english_name\";s:10:\"Belarusian\";s:11:\"native_name\";s:29:\"Беларуская мова\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.9.23/bel.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"be\";i:2;s:3:\"bel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Працягнуць\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-06-23 11:21:55\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.2/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Напред\";}}s:5:\"bn_BD\";a:8:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-07-15 14:46:58\";s:12:\"english_name\";s:20:\"Bengali (Bangladesh)\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.2/bn_BD.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"bn\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:28:\"চালিয়ে যান\";}}s:2:\"bo\";a:8:{s:8:\"language\";s:2:\"bo\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2020-10-30 03:24:38\";s:12:\"english_name\";s:7:\"Tibetan\";s:11:\"native_name\";s:21:\"བོད་ཡིག\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/bo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bo\";i:2;s:3:\"tib\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:33:\"མུ་མཐུད་དུ།\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-02-22 20:45:53\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.2/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-07-19 09:32:17\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.2.2/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:3:\"ceb\";a:8:{s:8:\"language\";s:3:\"ceb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-02 17:25:51\";s:12:\"english_name\";s:7:\"Cebuano\";s:11:\"native_name\";s:7:\"Cebuano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/ceb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"ceb\";i:3;s:3:\"ceb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Padayun\";}}s:5:\"cs_CZ\";a:8:{s:8:\"language\";s:5:\"cs_CZ\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-05-22 09:37:21\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.2/cs_CZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cs\";i:2;s:3:\"ces\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Pokračovat\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-05-10 08:48:02\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.2.2/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-07-14 12:12:09\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.2/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsæt\";}}s:12:\"de_DE_formal\";a:8:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-05-22 14:37:33\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.2.2/de_DE_formal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:14:\"de_CH_informal\";a:8:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-03-28 07:33:50\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/translation/core/6.2.2/de_CH_informal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_AT\";a:8:{s:8:\"language\";s:5:\"de_AT\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-03-29 21:14:35\";s:12:\"english_name\";s:16:\"German (Austria)\";s:11:\"native_name\";s:21:\"Deutsch (Österreich)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.2/de_AT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-05-22 12:57:54\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.2/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-03-28 07:37:41\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.2/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:3:\"dsb\";a:8:{s:8:\"language\";s:3:\"dsb\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2022-07-16 12:13:09\";s:12:\"english_name\";s:13:\"Lower Sorbian\";s:11:\"native_name\";s:16:\"Dolnoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.2/dsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"dsb\";i:3;s:3:\"dsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Dalej\";}}s:3:\"dzo\";a:8:{s:8:\"language\";s:3:\"dzo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-06-29 08:59:03\";s:12:\"english_name\";s:8:\"Dzongkha\";s:11:\"native_name\";s:18:\"རྫོང་ཁ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/dzo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"dz\";i:2;s:3:\"dzo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-06-22 15:41:41\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.2.2/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-06-04 17:36:42\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.2/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_NZ\";a:8:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:5:\"6.0.5\";s:7:\"updated\";s:19:\"2022-04-01 22:35:34\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.5/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-05-11 07:12:43\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.2/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-04-07 21:00:17\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.2/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_ZA\";a:8:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:5:\"6.0.5\";s:7:\"updated\";s:19:\"2021-12-24 12:36:39\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.5/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-05-17 04:31:21\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.2.2/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-06-20 17:07:49\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.2/es_ES.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CO\";a:8:{s:8:\"language\";s:5:\"es_CO\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-03-14 22:16:37\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Español de Colombia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.2/es_CO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_AR\";a:8:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-05-19 05:08:30\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.2/es_AR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_VE\";a:8:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-02-22 17:37:32\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.2/es_VE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_DO\";a:8:{s:8:\"language\";s:5:\"es_DO\";s:7:\"version\";s:5:\"5.8.7\";s:7:\"updated\";s:19:\"2021-10-08 14:32:50\";s:12:\"english_name\";s:28:\"Spanish (Dominican Republic)\";s:11:\"native_name\";s:33:\"Español de República Dominicana\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8.7/es_DO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:5:\"5.8.7\";s:7:\"updated\";s:19:\"2021-10-04 20:53:18\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8.7/es_PE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_UY\";a:8:{s:8:\"language\";s:5:\"es_UY\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-31 18:33:26\";s:12:\"english_name\";s:17:\"Spanish (Uruguay)\";s:11:\"native_name\";s:19:\"Español de Uruguay\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/es_UY.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-06-14 16:02:22\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/es_CL.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PR\";a:8:{s:8:\"language\";s:5:\"es_PR\";s:7:\"version\";s:6:\"5.4.13\";s:7:\"updated\";s:19:\"2020-04-29 15:36:59\";s:12:\"english_name\";s:21:\"Spanish (Puerto Rico)\";s:11:\"native_name\";s:23:\"Español de Puerto Rico\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.4.13/es_PR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_GT\";a:8:{s:8:\"language\";s:5:\"es_GT\";s:7:\"version\";s:6:\"5.2.18\";s:7:\"updated\";s:19:\"2019-03-02 06:35:01\";s:12:\"english_name\";s:19:\"Spanish (Guatemala)\";s:11:\"native_name\";s:21:\"Español de Guatemala\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.2.18/es_GT.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-05-22 14:08:08\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.2/es_MX.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CR\";a:8:{s:8:\"language\";s:5:\"es_CR\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-06-12 14:36:10\";s:12:\"english_name\";s:20:\"Spanish (Costa Rica)\";s:11:\"native_name\";s:22:\"Español de Costa Rica\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.2/es_CR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_EC\";a:8:{s:8:\"language\";s:5:\"es_EC\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-04-21 13:32:10\";s:12:\"english_name\";s:17:\"Spanish (Ecuador)\";s:11:\"native_name\";s:19:\"Español de Ecuador\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.2/es_EC.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"et\";a:8:{s:8:\"language\";s:2:\"et\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2020-08-12 08:38:59\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/et.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"et\";i:2;s:3:\"est\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Jätka\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-05-24 16:21:45\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.2.2/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-06-30 23:46:23\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.2/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"fa_AF\";a:8:{s:8:\"language\";s:5:\"fa_AF\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-07-02 10:08:01\";s:12:\"english_name\";s:21:\"Persian (Afghanistan)\";s:11:\"native_name\";s:31:\"(فارسی (افغانستان\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.2/fa_AF.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-05-17 05:20:27\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.2.2/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-05-25 15:00:05\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.2/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_CA\";a:8:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-05-30 14:40:46\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.2/fr_CA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_BE\";a:8:{s:8:\"language\";s:5:\"fr_BE\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-02-22 13:54:46\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Français de Belgique\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/fr_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:3:\"fur\";a:8:{s:8:\"language\";s:3:\"fur\";s:7:\"version\";s:6:\"4.8.22\";s:7:\"updated\";s:19:\"2023-04-30 13:56:46\";s:12:\"english_name\";s:8:\"Friulian\";s:11:\"native_name\";s:8:\"Friulian\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.22/fur.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"fur\";i:3;s:3:\"fur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"fy\";a:8:{s:8:\"language\";s:2:\"fy\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2022-12-25 12:53:23\";s:12:\"english_name\";s:7:\"Frisian\";s:11:\"native_name\";s:5:\"Frysk\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.2.2/fy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fy\";i:2;s:3:\"fry\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Trochgean\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-08-23 17:41:37\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-06-21 12:21:18\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.2/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"gu\";a:8:{s:8:\"language\";s:2:\"gu\";s:7:\"version\";s:6:\"4.9.23\";s:7:\"updated\";s:19:\"2023-07-25 11:17:47\";s:12:\"english_name\";s:8:\"Gujarati\";s:11:\"native_name\";s:21:\"ગુજરાતી\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.9.23/gu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gu\";i:2;s:3:\"guj\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ચાલુ રાખો\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:6:\"4.4.30\";s:7:\"updated\";s:19:\"2015-12-05 00:59:09\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.4.30/haz.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-05-28 22:06:16\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.2/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"המשך\";}}s:5:\"hi_IN\";a:8:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-07-26 12:33:49\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.2/hi_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hi\";i:2;s:3:\"hin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"जारी रखें\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-05-28 10:18:51\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.2.2/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:3:\"hsb\";a:8:{s:8:\"language\";s:3:\"hsb\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-02-22 17:37:32\";s:12:\"english_name\";s:13:\"Upper Sorbian\";s:11:\"native_name\";s:17:\"Hornjoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.2/hsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"hsb\";i:3;s:3:\"hsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:4:\"Dale\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-07-24 14:41:26\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.2/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Folytatás\";}}s:2:\"hy\";a:8:{s:8:\"language\";s:2:\"hy\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-03 16:21:10\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/hy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hy\";i:2;s:3:\"hye\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Շարունակել\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-07-07 13:57:04\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.2/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:6:\"4.9.23\";s:7:\"updated\";s:19:\"2018-12-11 10:40:02\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.23/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-07-17 21:01:33\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.2/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-07-07 19:56:16\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.2.2/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"次へ\";}}s:5:\"jv_ID\";a:8:{s:8:\"language\";s:5:\"jv_ID\";s:7:\"version\";s:6:\"4.9.23\";s:7:\"updated\";s:19:\"2019-02-16 23:58:56\";s:12:\"english_name\";s:8:\"Javanese\";s:11:\"native_name\";s:9:\"Basa Jawa\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.23/jv_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"jv\";i:2;s:3:\"jav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Nerusaké\";}}s:5:\"ka_GE\";a:8:{s:8:\"language\";s:5:\"ka_GE\";s:7:\"version\";s:5:\"6.0.5\";s:7:\"updated\";s:19:\"2023-05-19 07:40:56\";s:12:\"english_name\";s:8:\"Georgian\";s:11:\"native_name\";s:21:\"ქართული\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.5/ka_GE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ka\";i:2;s:3:\"kat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"გაგრძელება\";}}s:3:\"kab\";a:8:{s:8:\"language\";s:3:\"kab\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-07-05 11:40:39\";s:12:\"english_name\";s:6:\"Kabyle\";s:11:\"native_name\";s:9:\"Taqbaylit\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.2/kab.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"kab\";i:3;s:3:\"kab\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Kemmel\";}}s:2:\"kk\";a:8:{s:8:\"language\";s:2:\"kk\";s:7:\"version\";s:6:\"4.9.23\";s:7:\"updated\";s:19:\"2018-07-10 11:35:44\";s:12:\"english_name\";s:6:\"Kazakh\";s:11:\"native_name\";s:19:\"Қазақ тілі\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.9.23/kk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kk\";i:2;s:3:\"kaz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Жалғастыру\";}}s:2:\"km\";a:8:{s:8:\"language\";s:2:\"km\";s:7:\"version\";s:6:\"5.2.18\";s:7:\"updated\";s:19:\"2019-06-10 16:18:28\";s:12:\"english_name\";s:5:\"Khmer\";s:11:\"native_name\";s:27:\"ភាសាខ្មែរ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.2.18/km.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"km\";i:2;s:3:\"khm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"បន្ត\";}}s:2:\"kn\";a:8:{s:8:\"language\";s:2:\"kn\";s:7:\"version\";s:5:\"6.1.3\";s:7:\"updated\";s:19:\"2022-10-20 17:15:28\";s:12:\"english_name\";s:7:\"Kannada\";s:11:\"native_name\";s:15:\"ಕನ್ನಡ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.1.3/kn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kn\";i:2;s:3:\"kan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"ಮುಂದುವರಿಸು\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-05-30 08:24:13\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.2/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:3:\"ckb\";a:8:{s:8:\"language\";s:3:\"ckb\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-07-15 01:34:39\";s:12:\"english_name\";s:16:\"Kurdish (Sorani)\";s:11:\"native_name\";s:13:\"كوردی‎\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.2/ckb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ku\";i:3;s:3:\"ckb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"به‌رده‌وام به‌\";}}s:3:\"kir\";a:8:{s:8:\"language\";s:3:\"kir\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-07-11 18:16:48\";s:12:\"english_name\";s:6:\"Kyrgyz\";s:11:\"native_name\";s:16:\"Кыргызча\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.2/kir.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ky\";i:2;s:3:\"kir\";i:3;s:3:\"kir\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Улантуу\";}}s:2:\"lo\";a:8:{s:8:\"language\";s:2:\"lo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 09:59:23\";s:12:\"english_name\";s:3:\"Lao\";s:11:\"native_name\";s:21:\"ພາສາລາວ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/lo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lo\";i:2;s:3:\"lao\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"ຕໍ່​ໄປ\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:5:\"6.1.3\";s:7:\"updated\";s:19:\"2022-11-24 03:51:58\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.3/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}}s:2:\"lv\";a:8:{s:8:\"language\";s:2:\"lv\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-05-25 02:26:43\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:16:\"Latviešu valoda\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.2.2/lv.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lv\";i:2;s:3:\"lav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Turpināt\";}}s:5:\"mk_MK\";a:8:{s:8:\"language\";s:5:\"mk_MK\";s:7:\"version\";s:5:\"6.0.5\";s:7:\"updated\";s:19:\"2022-10-01 09:23:52\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:31:\"Македонски јазик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.5/mk_MK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mk\";i:2;s:3:\"mkd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Продолжи\";}}s:5:\"ml_IN\";a:8:{s:8:\"language\";s:5:\"ml_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:43:32\";s:12:\"english_name\";s:9:\"Malayalam\";s:11:\"native_name\";s:18:\"മലയാളം\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ml_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ml\";i:2;s:3:\"mal\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"തുടരുക\";}}s:2:\"mn\";a:8:{s:8:\"language\";s:2:\"mn\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-07-21 13:23:01\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:12:\"Монгол\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.2.2/mn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mn\";i:2;s:3:\"mon\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"mr\";a:8:{s:8:\"language\";s:2:\"mr\";s:7:\"version\";s:6:\"4.9.23\";s:7:\"updated\";s:19:\"2019-11-22 15:32:08\";s:12:\"english_name\";s:7:\"Marathi\";s:11:\"native_name\";s:15:\"मराठी\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.9.23/mr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mr\";i:2;s:3:\"mar\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"सुरु ठेवा\";}}s:5:\"ms_MY\";a:8:{s:8:\"language\";s:5:\"ms_MY\";s:7:\"version\";s:6:\"5.5.12\";s:7:\"updated\";s:19:\"2022-03-11 13:52:22\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:13:\"Bahasa Melayu\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.5.12/ms_MY.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ms\";i:2;s:3:\"msa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Teruskan\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:6:\"4.2.35\";s:7:\"updated\";s:19:\"2017-12-26 11:57:10\";s:12:\"english_name\";s:17:\"Myanmar (Burmese)\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.35/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ဆောင်ပါ။\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-07-24 18:22:13\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.2/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:5:\"ne_NP\";a:8:{s:8:\"language\";s:5:\"ne_NP\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-07-16 03:30:29\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:18:\"नेपाली\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.2/ne_NP.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ne\";i:2;s:3:\"nep\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:43:\"जारी राख्नुहोस्\";}}s:5:\"nl_BE\";a:8:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-07-18 17:21:22\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.2/nl_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:12:\"nl_NL_formal\";a:8:{s:8:\"language\";s:12:\"nl_NL_formal\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-02-22 21:20:14\";s:12:\"english_name\";s:14:\"Dutch (Formal)\";s:11:\"native_name\";s:20:\"Nederlands (Formeel)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.2.2/nl_NL_formal.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-07-08 07:12:34\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.2/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nn_NO\";a:8:{s:8:\"language\";s:5:\"nn_NO\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-18 10:59:16\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/nn_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}}s:3:\"oci\";a:8:{s:8:\"language\";s:3:\"oci\";s:7:\"version\";s:6:\"4.8.22\";s:7:\"updated\";s:19:\"2017-08-25 10:03:08\";s:12:\"english_name\";s:7:\"Occitan\";s:11:\"native_name\";s:7:\"Occitan\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.22/oci.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"oc\";i:2;s:3:\"oci\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Contunhar\";}}s:5:\"pa_IN\";a:8:{s:8:\"language\";s:5:\"pa_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-16 05:19:43\";s:12:\"english_name\";s:15:\"Panjabi (India)\";s:11:\"native_name\";s:18:\"ਪੰਜਾਬੀ\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/pa_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pa\";i:2;s:3:\"pan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ਜਾਰੀ ਰੱਖੋ\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-07-23 12:28:58\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.2/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:2:\"ps\";a:8:{s:8:\"language\";s:2:\"ps\";s:7:\"version\";s:6:\"4.3.31\";s:7:\"updated\";s:19:\"2015-12-02 21:41:29\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"پښتو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.3.31/ps.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ps\";i:2;s:3:\"pus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"دوام ورکړه\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-06-01 16:49:15\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.2/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_AO\";a:8:{s:8:\"language\";s:5:\"pt_AO\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2022-10-01 12:16:29\";s:12:\"english_name\";s:19:\"Portuguese (Angola)\";s:11:\"native_name\";s:20:\"Português de Angola\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.2/pt_AO.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:10:\"pt_PT_ao90\";a:8:{s:8:\"language\";s:10:\"pt_PT_ao90\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-03-30 23:24:56\";s:12:\"english_name\";s:27:\"Portuguese (Portugal, AO90)\";s:11:\"native_name\";s:17:\"Português (AO90)\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/core/6.2.2/pt_PT_ao90.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-07-26 12:00:56\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.2/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:3:\"rhg\";a:8:{s:8:\"language\";s:3:\"rhg\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-16 13:03:18\";s:12:\"english_name\";s:8:\"Rohingya\";s:11:\"native_name\";s:8:\"Ruáinga\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/rhg.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"rhg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-07-25 13:56:56\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.2/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-07-03 12:16:31\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.2/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:3:\"sah\";a:8:{s:8:\"language\";s:3:\"sah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-21 02:06:41\";s:12:\"english_name\";s:5:\"Sakha\";s:11:\"native_name\";s:14:\"Сахалыы\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/sah.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"sah\";i:3;s:3:\"sah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Салҕаа\";}}s:3:\"snd\";a:8:{s:8:\"language\";s:3:\"snd\";s:7:\"version\";s:6:\"5.4.13\";s:7:\"updated\";s:19:\"2020-07-07 01:53:37\";s:12:\"english_name\";s:6:\"Sindhi\";s:11:\"native_name\";s:8:\"سنڌي\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/5.4.13/snd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"sd\";i:2;s:3:\"snd\";i:3;s:3:\"snd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"اڳتي هلو\";}}s:5:\"si_LK\";a:8:{s:8:\"language\";s:5:\"si_LK\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 06:00:52\";s:12:\"english_name\";s:7:\"Sinhala\";s:11:\"native_name\";s:15:\"සිංහල\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/si_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"si\";i:2;s:3:\"sin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:44:\"දිගටම කරගෙන යන්න\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-06-23 12:06:50\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.2/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}}s:3:\"skr\";a:8:{s:8:\"language\";s:3:\"skr\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-04-03 08:30:58\";s:12:\"english_name\";s:7:\"Saraiki\";s:11:\"native_name\";s:14:\"سرائیکی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.2/skr.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"skr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"جاری رکھو\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-07-17 12:03:21\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.2/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Nadaljuj\";}}s:2:\"sq\";a:8:{s:8:\"language\";s:2:\"sq\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-05-10 11:33:13\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:5:\"Shqip\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.2.2/sq.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sq\";i:2;s:3:\"sqi\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Vazhdo\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:5:\"5.8.7\";s:7:\"updated\";s:19:\"2021-08-01 21:21:06\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8.7/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-05-11 17:06:50\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.2/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}}s:2:\"sw\";a:8:{s:8:\"language\";s:2:\"sw\";s:7:\"version\";s:6:\"5.3.15\";s:7:\"updated\";s:19:\"2019-10-13 15:35:35\";s:12:\"english_name\";s:7:\"Swahili\";s:11:\"native_name\";s:9:\"Kiswahili\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.3.15/sw.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sw\";i:2;s:3:\"swa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Endelea\";}}s:3:\"szl\";a:8:{s:8:\"language\";s:3:\"szl\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-24 19:58:14\";s:12:\"english_name\";s:8:\"Silesian\";s:11:\"native_name\";s:17:\"Ślōnskŏ gŏdka\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/szl.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"szl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:13:\"Kōntynuować\";}}s:5:\"ta_IN\";a:8:{s:8:\"language\";s:5:\"ta_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:22:47\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ta_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"தொடரவும்\";}}s:5:\"ta_LK\";a:8:{s:8:\"language\";s:5:\"ta_LK\";s:7:\"version\";s:6:\"4.2.35\";s:7:\"updated\";s:19:\"2015-12-03 01:07:44\";s:12:\"english_name\";s:17:\"Tamil (Sri Lanka)\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.35/ta_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"தொடர்க\";}}s:2:\"te\";a:8:{s:8:\"language\";s:2:\"te\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:47:39\";s:12:\"english_name\";s:6:\"Telugu\";s:11:\"native_name\";s:18:\"తెలుగు\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/te.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"te\";i:2;s:3:\"tel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"కొనసాగించు\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:5:\"5.8.7\";s:7:\"updated\";s:19:\"2022-06-08 04:30:30\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.8.7/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}}s:2:\"tl\";a:8:{s:8:\"language\";s:2:\"tl\";s:7:\"version\";s:6:\"4.8.22\";s:7:\"updated\";s:19:\"2017-09-30 09:04:29\";s:12:\"english_name\";s:7:\"Tagalog\";s:11:\"native_name\";s:7:\"Tagalog\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.8.22/tl.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tl\";i:2;s:3:\"tgl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Magpatuloy\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-05-22 10:14:53\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.2/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"tt_RU\";a:8:{s:8:\"language\";s:5:\"tt_RU\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-20 20:20:50\";s:12:\"english_name\";s:5:\"Tatar\";s:11:\"native_name\";s:19:\"Татар теле\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/tt_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tt\";i:2;s:3:\"tat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"дәвам итү\";}}s:3:\"tah\";a:8:{s:8:\"language\";s:3:\"tah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-06 18:39:39\";s:12:\"english_name\";s:8:\"Tahitian\";s:11:\"native_name\";s:10:\"Reo Tahiti\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/tah.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ty\";i:2;s:3:\"tah\";i:3;s:3:\"tah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ug_CN\";a:8:{s:8:\"language\";s:5:\"ug_CN\";s:7:\"version\";s:6:\"4.9.23\";s:7:\"updated\";s:19:\"2021-07-03 18:41:33\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:16:\"ئۇيغۇرچە\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.23/ug_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"داۋاملاشتۇرۇش\";}}s:2:\"uk\";a:8:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"6.1.3\";s:7:\"updated\";s:19:\"2023-03-04 10:46:30\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.1.3/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продовжити\";}}s:2:\"ur\";a:8:{s:8:\"language\";s:2:\"ur\";s:7:\"version\";s:6:\"5.4.13\";s:7:\"updated\";s:19:\"2020-04-09 11:17:33\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:8:\"اردو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.4.13/ur.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ur\";i:2;s:3:\"urd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"جاری رکھیں\";}}s:5:\"uz_UZ\";a:8:{s:8:\"language\";s:5:\"uz_UZ\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-02-28 12:02:22\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:11:\"O‘zbekcha\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/uz_UZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uz\";i:2;s:3:\"uzb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Davom etish\";}}s:2:\"vi\";a:8:{s:8:\"language\";s:2:\"vi\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-07-15 15:30:50\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.2.2/vi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"vi\";i:2;s:3:\"vie\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Tiếp tục\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-05-24 10:05:05\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.2/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2023-05-16 19:47:32\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.2/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_HK\";a:8:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:5:\"6.2.2\";s:7:\"updated\";s:19:\"2022-07-15 15:25:03\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:12:\"香港中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.2/zh_HK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}}", "no");
INSERT INTO `wpeng_options` VALUES("29194", "_transient_timeout_wfcredentialstatus_3", "1690449080", "no");
INSERT INTO `wpeng_options` VALUES("29195", "_transient_wfcredentialstatus_3", "08a808cff6f22780deac2f6859952f8981804d0418e744e70bd9050aa166cbb11", "no");
INSERT INTO `wpeng_options` VALUES("29200", "_transient_timeout_wpseo_total_unindexed_post_type_archives", "1690531881", "no");
INSERT INTO `wpeng_options` VALUES("29201", "_transient_wpseo_total_unindexed_post_type_archives", "0", "no");
INSERT INTO `wpeng_options` VALUES("29202", "_transient_timeout_wpseo_total_unindexed_general_items", "1690531881", "no");
INSERT INTO `wpeng_options` VALUES("29203", "_transient_wpseo_total_unindexed_general_items", "0", "no");
INSERT INTO `wpeng_options` VALUES("29204", "_transient_timeout_wpseo_unindexed_post_link_count", "1690531881", "no");
INSERT INTO `wpeng_options` VALUES("29205", "_transient_wpseo_unindexed_post_link_count", "0", "no");
INSERT INTO `wpeng_options` VALUES("29206", "_transient_timeout_wpseo_unindexed_term_link_count", "1690531881", "no");
INSERT INTO `wpeng_options` VALUES("29207", "_transient_wpseo_unindexed_term_link_count", "0", "no");
INSERT INTO `wpeng_options` VALUES("29208", "_transient_timeout_wpseo-statistics-totals", "1690531883", "no");
INSERT INTO `wpeng_options` VALUES("29209", "_transient_wpseo-statistics-totals", "a:1:{i:3;a:2:{s:6:\"scores\";a:1:{i:0;a:4:{s:8:\"seo_rank\";s:2:\"na\";s:5:\"label\";s:48:\"Posts <strong>without</strong> a focus keyphrase\";s:5:\"count\";i:1;s:4:\"link\";s:115:\"https://wordpress.engine.gp.demod4u.gr/wp-admin/edit.php?post_status=publish&#038;post_type=post&#038;seo_filter=na\";}}s:8:\"division\";a:5:{s:3:\"bad\";i:0;s:2:\"ok\";i:0;s:4:\"good\";i:0;s:2:\"na\";i:1;s:7:\"noindex\";i:0;}}}", "no");
INSERT INTO `wpeng_options` VALUES("29210", "_site_transient_timeout_community-events-fbef62985825bd5a8a980478e65fcc72", "1690488684", "no");
INSERT INTO `wpeng_options` VALUES("29211", "_site_transient_community-events-fbef62985825bd5a8a980478e65fcc72", "a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";s:11:\"77.49.197.0\";}s:6:\"events\";a:0:{}}", "no");
INSERT INTO `wpeng_options` VALUES("29212", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1690445496;s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:18:{s:35:\"advanced-cf7-db/advanced-cf7-db.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:29:\"w.org/plugins/advanced-cf7-db\";s:4:\"slug\";s:15:\"advanced-cf7-db\";s:6:\"plugin\";s:35:\"advanced-cf7-db/advanced-cf7-db.php\";s:11:\"new_version\";s:5:\"1.9.3\";s:3:\"url\";s:46:\"https://wordpress.org/plugins/advanced-cf7-db/\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/plugin/advanced-cf7-db.1.9.3.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:68:\"https://ps.w.org/advanced-cf7-db/assets/icon-256x256.jpg?rev=1696186\";s:2:\"1x\";s:68:\"https://ps.w.org/advanced-cf7-db/assets/icon-128x128.jpg?rev=1696186\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:71:\"https://ps.w.org/advanced-cf7-db/assets/banner-1544x500.jpg?rev=1696186\";s:2:\"1x\";s:70:\"https://ps.w.org/advanced-cf7-db/assets/banner-772x250.jpg?rev=1696186\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.0\";}s:55:\"autoconvert-greeklish-permalinks/auto-gr-permalinks.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:46:\"w.org/plugins/autoconvert-greeklish-permalinks\";s:4:\"slug\";s:32:\"autoconvert-greeklish-permalinks\";s:6:\"plugin\";s:55:\"autoconvert-greeklish-permalinks/auto-gr-permalinks.php\";s:11:\"new_version\";s:5:\"4.1.1\";s:3:\"url\";s:63:\"https://wordpress.org/plugins/autoconvert-greeklish-permalinks/\";s:7:\"package\";s:81:\"https://downloads.wordpress.org/plugin/autoconvert-greeklish-permalinks.4.1.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:85:\"https://ps.w.org/autoconvert-greeklish-permalinks/assets/icon-256x256.png?rev=2028765\";s:2:\"1x\";s:85:\"https://ps.w.org/autoconvert-greeklish-permalinks/assets/icon-128x128.png?rev=2028765\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:88:\"https://ps.w.org/autoconvert-greeklish-permalinks/assets/banner-1544x500.png?rev=2028765\";s:2:\"1x\";s:87:\"https://ps.w.org/autoconvert-greeklish-permalinks/assets/banner-772x250.png?rev=2028765\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"3.8\";}s:36:\"contact-form-7/wp-contact-form-7.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:28:\"w.org/plugins/contact-form-7\";s:4:\"slug\";s:14:\"contact-form-7\";s:6:\"plugin\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:11:\"new_version\";s:5:\"5.7.7\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/contact-form-7/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.7.7.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:59:\"https://ps.w.org/contact-form-7/assets/icon.svg?rev=2339255\";s:3:\"svg\";s:59:\"https://ps.w.org/contact-form-7/assets/icon.svg?rev=2339255\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/contact-form-7/assets/banner-1544x500.png?rev=860901\";s:2:\"1x\";s:68:\"https://ps.w.org/contact-form-7/assets/banner-772x250.png?rev=880427\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.0\";}s:53:\"webp-converter-for-media/webp-converter-for-media.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:38:\"w.org/plugins/webp-converter-for-media\";s:4:\"slug\";s:24:\"webp-converter-for-media\";s:6:\"plugin\";s:53:\"webp-converter-for-media/webp-converter-for-media.php\";s:11:\"new_version\";s:5:\"5.9.4\";s:3:\"url\";s:55:\"https://wordpress.org/plugins/webp-converter-for-media/\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/plugin/webp-converter-for-media.5.9.4.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:77:\"https://ps.w.org/webp-converter-for-media/assets/icon-256x256.png?rev=2636288\";s:2:\"1x\";s:77:\"https://ps.w.org/webp-converter-for-media/assets/icon-128x128.png?rev=2636288\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:80:\"https://ps.w.org/webp-converter-for-media/assets/banner-1544x500.png?rev=2757184\";s:2:\"1x\";s:79:\"https://ps.w.org/webp-converter-for-media/assets/banner-772x250.png?rev=2757184\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.9\";}s:31:\"cookie-notice/cookie-notice.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:27:\"w.org/plugins/cookie-notice\";s:4:\"slug\";s:13:\"cookie-notice\";s:6:\"plugin\";s:31:\"cookie-notice/cookie-notice.php\";s:11:\"new_version\";s:5:\"2.4.9\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/cookie-notice/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/cookie-notice.2.4.9.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/cookie-notice/assets/icon-256x256.png?rev=2466385\";s:2:\"1x\";s:66:\"https://ps.w.org/cookie-notice/assets/icon-128x128.png?rev=2466385\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:68:\"https://ps.w.org/cookie-notice/assets/banner-772x250.png?rev=2466385\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.7\";}s:37:\"disable-comments/disable-comments.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:30:\"w.org/plugins/disable-comments\";s:4:\"slug\";s:16:\"disable-comments\";s:6:\"plugin\";s:37:\"disable-comments/disable-comments.php\";s:11:\"new_version\";s:5:\"2.4.4\";s:3:\"url\";s:47:\"https://wordpress.org/plugins/disable-comments/\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/plugin/disable-comments.2.4.4.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/disable-comments/assets/icon-256x256.png?rev=2509854\";s:2:\"1x\";s:69:\"https://ps.w.org/disable-comments/assets/icon-128x128.png?rev=2509854\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:72:\"https://ps.w.org/disable-comments/assets/banner-1544x500.png?rev=2509854\";s:2:\"1x\";s:71:\"https://ps.w.org/disable-comments/assets/banner-772x250.png?rev=2509854\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.0\";}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:7:\"1.5.5.1\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/duplicator.1.5.5.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=2906985\";s:2:\"1x\";s:63:\"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=2906985\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/duplicator/assets/banner-1544x500.png?rev=2906985\";s:2:\"1x\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=2906985\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.0\";}s:45:\"enable-media-replace/enable-media-replace.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:34:\"w.org/plugins/enable-media-replace\";s:4:\"slug\";s:20:\"enable-media-replace\";s:6:\"plugin\";s:45:\"enable-media-replace/enable-media-replace.php\";s:11:\"new_version\";s:5:\"4.1.2\";s:3:\"url\";s:51:\"https://wordpress.org/plugins/enable-media-replace/\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/plugin/enable-media-replace.4.1.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:73:\"https://ps.w.org/enable-media-replace/assets/icon-256x256.png?rev=1940728\";s:2:\"1x\";s:73:\"https://ps.w.org/enable-media-replace/assets/icon-128x128.png?rev=1940728\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:76:\"https://ps.w.org/enable-media-replace/assets/banner-1544x500.png?rev=2322194\";s:2:\"1x\";s:75:\"https://ps.w.org/enable-media-replace/assets/banner-772x250.png?rev=2322194\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:5:\"4.9.7\";}s:25:\"generateblocks/plugin.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:28:\"w.org/plugins/generateblocks\";s:4:\"slug\";s:14:\"generateblocks\";s:6:\"plugin\";s:25:\"generateblocks/plugin.php\";s:11:\"new_version\";s:5:\"1.8.1\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/generateblocks/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/generateblocks.1.8.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/generateblocks/assets/icon-256x256.png?rev=2336822\";s:2:\"1x\";s:67:\"https://ps.w.org/generateblocks/assets/icon-128x128.png?rev=2336822\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/generateblocks/assets/banner-1544x500.png?rev=2336822\";s:2:\"1x\";s:69:\"https://ps.w.org/generateblocks/assets/banner-772x250.png?rev=2336822\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.9\";}s:33:\"gutenslider/eedee-gutenslider.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:25:\"w.org/plugins/gutenslider\";s:4:\"slug\";s:11:\"gutenslider\";s:6:\"plugin\";s:33:\"gutenslider/eedee-gutenslider.php\";s:11:\"new_version\";s:6:\"5.10.2\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/gutenslider/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/gutenslider.5.10.2.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:56:\"https://ps.w.org/gutenslider/assets/icon.svg?rev=2101871\";s:3:\"svg\";s:56:\"https://ps.w.org/gutenslider/assets/icon.svg?rev=2101871\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/gutenslider/assets/banner-1544x500.png?rev=2392054\";s:2:\"1x\";s:66:\"https://ps.w.org/gutenslider/assets/banner-772x250.png?rev=2392054\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.6\";}s:22:\"hide-my-site/index.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:26:\"w.org/plugins/hide-my-site\";s:4:\"slug\";s:12:\"hide-my-site\";s:6:\"plugin\";s:22:\"hide-my-site/index.php\";s:11:\"new_version\";s:3:\"2.2\";s:3:\"url\";s:43:\"https://wordpress.org/plugins/hide-my-site/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/hide-my-site.2.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/hide-my-site/assets/icon-256x256.png?rev=1008088\";s:2:\"1x\";s:65:\"https://ps.w.org/hide-my-site/assets/icon-128x128.png?rev=1008093\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:66:\"https://ps.w.org/hide-my-site/assets/banner-772x250.png?rev=714201\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"2.9\";}s:49:\"gallery-block-lightbox/gallery-block-lightbox.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:36:\"w.org/plugins/gallery-block-lightbox\";s:4:\"slug\";s:22:\"gallery-block-lightbox\";s:6:\"plugin\";s:49:\"gallery-block-lightbox/gallery-block-lightbox.php\";s:11:\"new_version\";s:4:\"1.13\";s:3:\"url\";s:53:\"https://wordpress.org/plugins/gallery-block-lightbox/\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/plugin/gallery-block-lightbox.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:67:\"https://ps.w.org/gallery-block-lightbox/assets/icon.svg?rev=2788519\";s:3:\"svg\";s:67:\"https://ps.w.org/gallery-block-lightbox/assets/icon.svg?rev=2788519\";}s:7:\"banners\";a:0:{}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.4\";}s:53:\"remove-uppercase-accents/remove-uppercase-accents.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:38:\"w.org/plugins/remove-uppercase-accents\";s:4:\"slug\";s:24:\"remove-uppercase-accents\";s:6:\"plugin\";s:53:\"remove-uppercase-accents/remove-uppercase-accents.php\";s:11:\"new_version\";s:5:\"1.1.1\";s:3:\"url\";s:55:\"https://wordpress.org/plugins/remove-uppercase-accents/\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/plugin/remove-uppercase-accents.1.1.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:77:\"https://ps.w.org/remove-uppercase-accents/assets/icon-256x256.jpg?rev=2841210\";s:2:\"1x\";s:77:\"https://ps.w.org/remove-uppercase-accents/assets/icon-128x128.jpg?rev=2841210\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:80:\"https://ps.w.org/remove-uppercase-accents/assets/banner-1544x500.jpg?rev=2841210\";s:2:\"1x\";s:79:\"https://ps.w.org/remove-uppercase-accents/assets/banner-772x250.jpg?rev=2841210\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"3.0\";}s:39:\"resmushit-image-optimizer/resmushit.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"w.org/plugins/resmushit-image-optimizer\";s:4:\"slug\";s:25:\"resmushit-image-optimizer\";s:6:\"plugin\";s:39:\"resmushit-image-optimizer/resmushit.php\";s:11:\"new_version\";s:6:\"0.4.11\";s:3:\"url\";s:56:\"https://wordpress.org/plugins/resmushit-image-optimizer/\";s:7:\"package\";s:75:\"https://downloads.wordpress.org/plugin/resmushit-image-optimizer.0.4.11.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:78:\"https://ps.w.org/resmushit-image-optimizer/assets/icon-256x256.png?rev=1447284\";s:2:\"1x\";s:78:\"https://ps.w.org/resmushit-image-optimizer/assets/icon-128x128.png?rev=1447284\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:81:\"https://ps.w.org/resmushit-image-optimizer/assets/banner-1544x500.png?rev=2296679\";s:2:\"1x\";s:80:\"https://ps.w.org/resmushit-image-optimizer/assets/banner-772x250.png?rev=2296679\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:5:\"4.0.0\";}s:23:\"wordfence/wordfence.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:23:\"w.org/plugins/wordfence\";s:4:\"slug\";s:9:\"wordfence\";s:6:\"plugin\";s:23:\"wordfence/wordfence.php\";s:11:\"new_version\";s:6:\"7.10.2\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/wordfence/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/wordfence.7.10.2.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:54:\"https://ps.w.org/wordfence/assets/icon.svg?rev=2070865\";s:3:\"svg\";s:54:\"https://ps.w.org/wordfence/assets/icon.svg?rev=2070865\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/wordfence/assets/banner-1544x500.jpg?rev=2124102\";s:2:\"1x\";s:64:\"https://ps.w.org/wordfence/assets/banner-772x250.jpg?rev=2124102\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"3.9\";}s:33:\"duplicate-post/duplicate-post.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:28:\"w.org/plugins/duplicate-post\";s:4:\"slug\";s:14:\"duplicate-post\";s:6:\"plugin\";s:33:\"duplicate-post/duplicate-post.php\";s:11:\"new_version\";s:3:\"4.5\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/duplicate-post/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/duplicate-post.4.5.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/duplicate-post/assets/icon-256x256.png?rev=2336666\";s:2:\"1x\";s:67:\"https://ps.w.org/duplicate-post/assets/icon-128x128.png?rev=2336666\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/duplicate-post/assets/banner-1544x500.png?rev=2336666\";s:2:\"1x\";s:69:\"https://ps.w.org/duplicate-post/assets/banner-772x250.png?rev=2336666\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.1\";}s:24:\"wordpress-seo/wp-seo.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:27:\"w.org/plugins/wordpress-seo\";s:4:\"slug\";s:13:\"wordpress-seo\";s:6:\"plugin\";s:24:\"wordpress-seo/wp-seo.php\";s:11:\"new_version\";s:5:\"20.12\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/wordpress-seo/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-seo.20.12.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:58:\"https://ps.w.org/wordpress-seo/assets/icon.svg?rev=2363699\";s:3:\"svg\";s:58:\"https://ps.w.org/wordpress-seo/assets/icon.svg?rev=2363699\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/wordpress-seo/assets/banner-1544x500.png?rev=2643727\";s:2:\"1x\";s:68:\"https://ps.w.org/wordpress-seo/assets/banner-772x250.png?rev=2643727\";}s:11:\"banners_rtl\";a:2:{s:2:\"2x\";s:73:\"https://ps.w.org/wordpress-seo/assets/banner-1544x500-rtl.png?rev=2643727\";s:2:\"1x\";s:72:\"https://ps.w.org/wordpress-seo/assets/banner-772x250-rtl.png?rev=2643727\";}s:8:\"requires\";s:3:\"6.1\";}s:25:\"gp-premium/gp-premium.php\";O:8:\"stdClass\":18:{s:11:\"new_version\";s:5:\"2.3.1\";s:14:\"stable_version\";s:5:\"2.3.1\";s:4:\"name\";s:10:\"GP Premium\";s:4:\"slug\";s:10:\"gp-premium\";s:3:\"url\";s:59:\"https://generatepress.com/downloads/gp-premium/?changelog=1\";s:12:\"last_updated\";s:19:\"2023-03-30 20:17:25\";s:8:\"homepage\";s:47:\"https://generatepress.com/downloads/gp-premium/\";s:7:\"package\";s:214:\"https://generatepress.com/edd-sl/package_download/MTY5MDUwNjY4Njo5ZGJjZmUzODA1OTFjMmE5NzM2YTViMGI0NGJmZjAwMzoyNTQ0MToyZTJmMjU1YzdhYjg4YmRhY2E3OTA0NjYyZDEwNzIyMjpodHRwc0AvL3dvcmRwcmVzcy5lbmdpbmUuZ3AuZGVtb2Q0dS5ncjow\";s:13:\"download_link\";s:214:\"https://generatepress.com/edd-sl/package_download/MTY5MDUwNjY4Njo5ZGJjZmUzODA1OTFjMmE5NzM2YTViMGI0NGJmZjAwMzoyNTQ0MToyZTJmMjU1YzdhYjg4YmRhY2E3OTA0NjYyZDEwNzIyMjpodHRwc0AvL3dvcmRwcmVzcy5lbmdpbmUuZ3AuZGVtb2Q0dS5ncjow\";s:8:\"sections\";O:8:\"stdClass\":2:{s:11:\"description\";s:341:\"<p>The entire collection of GeneratePress premium modules. Once activated, each module extends certain aspects of GeneratePress, giving you more options to build your website.</p>\n<h4> Documentation </h4>\n<p>Check out our <a href=\"https://docs.generatepress.com\">documentation</a> for more information on each module and how to use them.</p>\";s:9:\"changelog\";s:28506:\"<h4> 2.3.1 </h4>\n<ul>\n<li>Fix: SelectSearch component infinite loop</li>\n<li>Fix: Block widths inside Block Elements</li>\n</ul>\n<h4> 2.3.0 </h4>\n<ul>\n<li>Feature: Add Search Modal Element type</li>\n<li>Fix: Inline post meta feature in GenerateBlocks 1.7</li>\n<li>Fix: Close &quot;Choose Element Type&quot; modal with ESC key</li>\n<li>Fix: Replace WooCommerce secondary image attachment size</li>\n<li>Fix: WP Filesystem error missing credentials</li>\n<li>Fix: Undefined array keys in dynamic Container URL</li>\n<li>Fix: Author avatar in Header/Block Element titles</li>\n<li>Fix: Infinite loop error when autosaving with dynamic content block</li>\n<li>Fix: Add aria-label to off-canvas panel button</li>\n<li>Fix: WooCommerce button dynamic typography</li>\n<li>Fix: Empty WooCommerce quantity fields</li>\n<li>Fix: PHP 8.1 notice using disable elements in Customizer</li>\n<li>Tweak: Improve license key area</li>\n<li>Tweak: Improve off-canvas transitions</li>\n<li>Tweak: Check for WooCommerce functions</li>\n<li>Tweak: Open off-canvas using space bar</li>\n<li>Tweak: Use image ID in mobile header/sticky nav logos</li>\n<li>Tweak: Improve Elements hook selection dropdown UI</li>\n<li>Tweak: Add site library check for min GenerateBlocks version</li>\n<li>Tweak: Add Loop Template to Custom Post Type dropdown filters</li>\n</ul>\n<h4> 2.2.2 </h4>\n<ul>\n<li>Fix: Off Canvas anchor links not working</li>\n</ul>\n<h4> 2.2.1 </h4>\n<ul>\n<li>Fix: Add value to off-canvas aria-hidden attribute</li>\n<li>Tweak: Remove/add aria-hidden to off-canvas on toggle</li>\n</ul>\n<h4> 2.2.0 </h4>\n<ul>\n<li>Feature: Allow block element autosave</li>\n<li>Feature: Add revisions to block elements</li>\n<li>Feature: Add Loop Template block element</li>\n<li>Feature: Dont display the raw license key in the Dashboard</li>\n<li>Feature: Add &quot;Paginated Results&quot; to Element Display Rules</li>\n<li>Fix: Element post navigation template PHP warning when not using GB Pro</li>\n<li>Fix: Remove unnecessary zoom CSS from featured images</li>\n<li>Fix: Font icon CSS order</li>\n<li>Fix: Load more button showing in product tax archives</li>\n<li>Fix: Prevent tabbing in hidden off-canvas panel</li>\n<li>Fix: Hide hidden off-canvas panel from screen readers</li>\n<li>Fix: menu-toggle aria-controls when using off-canvas panel</li>\n<li>Fix: Focus first focusable element when opening off-canvas panel</li>\n<li>Fix: Focus slideout toggle when closing off-canvas panel</li>\n<li>Fix: Off-Canvas Panel sub-menu a11y</li>\n<li>Fix: Prevent secondary nav legacy typography CSS</li>\n<li>Fix: Fix dynamic term meta link</li>\n<li>Fix: Block margins in the block element editor</li>\n<li>Fix: Embeds in Block Elements</li>\n<li>Fix: Apply display rules to editor with no ID</li>\n<li>Fix: Navigation background image applying to secondary nav</li>\n<li>Fix: WooCommerce order received page float issue</li>\n<li>Fix: Block element editor error in GenerateBlocks 1.7</li>\n<li>Tweak: Remove jquery-migrate from sticky script</li>\n<li>Tweak: Add message in Blog section about Loop Template</li>\n</ul>\n<h4> 2.1.2 </h4>\n<ul>\n<li>Elements: Fix custom field value in dynamic container links</li>\n<li>Elements: Fix block widths in the editor</li>\n<li>General: Fix double slashes in dashboard file request</li>\n<li>General: Fix missing Customizer translations</li>\n</ul>\n<h4> 2.1.1 </h4>\n<ul>\n<li>Menu Plus: Fix mobile header sticky auto hide</li>\n<li>Site Library: Fix broken CSS variables on import</li>\n</ul>\n<h4> 2.1.0 </h4>\n<ul>\n<li>Blog: Fix masonry JS error if no archive pagination exists</li>\n<li>Blog: Fix full width featured blog column</li>\n<li>Colors: Deprecate module if using GP 3.1.0</li>\n<li>Elements: Add custom class option to dynamic image block</li>\n<li>Elements: Add support for post_type array in display rules</li>\n<li>Elements: Fix container link option when targeting next/previous posts</li>\n<li>Menu Plus: Integrate off-canvas panel with new dynamic typography system</li>\n<li>Menu Plus: Integrate off-canvas panel with new color system</li>\n<li>Menu Plus: Integrate mobile header HTML attributes with new HTML attribute system</li>\n<li>Menu Plus: Integrate mobile header and off-canvas panel with new generate_has_active_menu filter</li>\n<li>Menu Plus: Fix broken inline CSS when using floated sticky navigation</li>\n<li>Menu Plus: Add logo dimensions to navigation logo</li>\n<li>Secondary Navigation: Integrate with new color system</li>\n<li>Secondary Navigation: Integrate with new generate_has_active_menu filter</li>\n<li>Secondary Navigation: Integrate with new dynamic typography system</li>\n<li>Secondary Navigation: Reduce box-shadow to match main navigation</li>\n<li>Secondary Navigation: Change direction of sub-menu box-shadow when opening left</li>\n<li>Secondary Navigation: Fix sub-menu overlap when using dropdown click/mobile</li>\n<li>Secondary Navigation: Replace box-shadow with border-bottom when sub-menu opens down</li>\n<li>Site Library: Add site author attribution</li>\n<li>Typography: Deprecate module if using dynamic typography in GP 3.1.0</li>\n<li>WooCommerce: Integrate with new dynamic typography system</li>\n<li>WooCommerce: Integrate with new colors system</li>\n<li>WooCommerce: Remove category title/description if using page hero with title disabled</li>\n<li>WooCommerce: Remove &quot;speak&quot; CSS properties</li>\n<li>WooCommerce: Fix empty continue shopping link on mobile</li>\n<li>WooCommerce: Fix persistent sticky add to cart panel</li>\n<li>General: Integrate with new GP 3.1.0 Dashboard</li>\n<li>General: Remove featured-image-active body class if featured image is disabled</li>\n<li>General: Change date format in exported JSON filename</li>\n<li>General: Fix PHP error when license key activation returns 403</li>\n</ul>\n<h4> 2.0.3 </h4>\n<ul>\n<li>Elements: Use block_categories_all filter in WP 5.8</li>\n<li>Elements: Remove wp-editor dependency from new widget editor</li>\n</ul>\n<h4> 2.0.2 </h4>\n<ul>\n<li>Elements: Use blog page title for dynamic title if set</li>\n<li>Spacing: Fix reset button bug in Customizer controls</li>\n<li>WooCommerce: Fix infinite scroll applying to product taxonomy pages</li>\n</ul>\n<h4> 2.0.1 </h4>\n<ul>\n<li>Blog: Fix infinite scroll bug on product archives</li>\n<li>Elements: Fix error in WP 4.9.x versions</li>\n<li>Menu Plus: Prevent 0x0 logo dimension attributes if no dimensions exist</li>\n<li>Site Library: Add vertical scroll ability to the Site Library control area</li>\n</ul>\n<h4> 2.0.0 </h4>\n<ul>\n<li>Blog: Rewrite infinite scroll using vanilla javascript</li>\n<li>Blog: Rewrite masonry using vanilla javascript</li>\n<li>Blog: Add separate infinite scroll path element to footer</li>\n<li>Blog: Fix missing single/page featured image options when archive image disabled</li>\n<li>Blog: Add aria-label instead of screen-reader-text to read more button</li>\n<li>Colors: Fix back to top Customizer color preview</li>\n<li>Elements: New Content Template Element</li>\n<li>Elements: New Post Meta Template Element</li>\n<li>Elements: New Post Navigation Template Element</li>\n<li>Elements: New Page Hero Block Element</li>\n<li>Elements: New Archive Navigation Template Element</li>\n<li>Elements: New Editor Width option in Block Elements</li>\n<li>Elements: Move Block Elements options into editor sidebar</li>\n<li>Elements: Show Site Header options by default in Header Element</li>\n<li>Elements: Fix Classic Editor issue in Block Elements</li>\n<li>Elements: Add a list of active Elements to page editor</li>\n<li>Elements: Add a list of active Elements to the admin bar</li>\n<li>Elements: Add notices to Customizer if Elements may be overwriting options</li>\n<li>Elements: Disable mobile header menu if menu is disabled via Layout Element</li>\n<li>Elements: Improve Display Rule loading performance</li>\n<li>Elements: Add block type filter to Elements dashboard</li>\n<li>Elements: Add generate_element_display filter</li>\n<li>Elements: Add No Results as a Display Rule condition</li>\n<li>Menu Plus: Hide slideout toggle at set mobile menu breakpoint value</li>\n<li>Menu Plus: Fix sticky menu height when using navigation as header</li>\n<li>Menu Plus: Add dimensions to mobile/sticky logos</li>\n<li>Menu Plus: Make Off-Canvas menu take up full width of canvas</li>\n<li>Menu Plus: Fix menu bar item sticky transition</li>\n<li>Menu Plus: Prevent sticky sidebar nav if mobile header is set to sticky</li>\n<li>Secondary Nav: Fix centered secondary navigation items using flexbox</li>\n<li>Secondary Nav: Fix conflict with Nav as Header option</li>\n<li>Secondary Nav: Fix missing menu cart items when using click dropdowns</li>\n<li>Sections: Officially deprecate module</li>\n<li>Site Library: Completely rebuild Site Library using React</li>\n<li>WooCommerce: Move full width single product CSS to inline CSS</li>\n<li>WooCommerce: Use wc_get_product() instead of new WC_Product()</li>\n<li>WooCommerce: Add more checks for WC() class to prevent error logs</li>\n<li>WooCommerce: Add generate_wc_cart_panel_checkout_button_output filter</li>\n<li>WooCommerce: Add generate_wc_sticky_add_to_cart_action filter</li>\n<li>WooCommerce: Add generate_wc_show_sticky_add_to_cart filter</li>\n<li>WooCommerce: Re-write quantity button javascript to be more performant/extendable</li>\n<li>General: Update theme install link</li>\n<li>General: Update alpha color picker script</li>\n<li>General: Use correct URL scheme in external stylesheet URLs</li>\n<li>General: Check if FS_CHMOD_FILE is defined in external stylesheet generation</li>\n<li>General: Use inline CSS when using AMP plugin</li>\n<li>General: Update EDD_SL_Plugin_Updater class to 1.8.0</li>\n<li>General: Clean up javascript throughout plugin</li>\n<li>General: Replace deprecated jQuery functions</li>\n</ul>\n<h4> 1.12.3 </h4>\n<ul>\n<li>WooCommerce: Fix quantity buttons in WP 5.6</li>\n</ul>\n<h4> 1.12.2 </h4>\n<ul>\n<li>Blog: Load columns CSS when using filter to enable it anywhere</li>\n<li>Menu Plus: Fix sticky mobile header jump when using inline mobile toggle</li>\n<li>Menu Plus: Add margin to sticky nav branding when set to full width</li>\n<li>Menu Plus: Disable sticky nav container text align padding</li>\n<li>Menu Plus: Make mobile menu absolute only when smooth scroll is enabled</li>\n<li>Menu Plus: Improve nav as header/mobile header when using flexbox</li>\n<li>Menu Plus: Prevent off-canvas panel close button from flashing visible when closing</li>\n<li>Spacing: Fix custom nav search height</li>\n</ul>\n<h4> 1.12.1 </h4>\n<ul>\n<li>Typography: Fix missing heading font size controls in the Customizer</li>\n</ul>\n<h4> 1.12.0 </h4>\n<ul>\n<li>Blog: Fix column margin on mobile with some caching plugins</li>\n<li>Blog: Add post-load trigger to infinite scroll for better plugin compatibility</li>\n<li>Blog: Take generate_blog_columns filter into account when loading columns CSS</li>\n<li>Colors: Add search menu-bar-item color live preview to Customizer</li>\n<li>Elements: Fix broken custom hook field in Block Elements</li>\n<li>Elements: Integrate page hero with text container alignment in GP 3.0</li>\n<li>Elements: Better integrate Header Element colors with GP 3.0</li>\n<li>Elements: Only disable content title when {{post_title}} is present on single pages</li>\n<li>Elements: Fix  tag in metabox</li>\n<li>Elements: Add generate_elements_metabox_ajax_allow_editors filter</li>\n<li>Elements: Add new 3.0 hooks to hook selector</li>\n<li>Elements: Re-add generate_elements_custom_args filter</li>\n<li>Menu Plus: Better prepare navigation as header for GP 3.0</li>\n<li>Menu Plus: Better prepare Off-Canvas Panel for GP 3.0</li>\n<li>Menu Plus: Better prepare sticky navigation for GP 3.0</li>\n<li>Menu Plus: Add has-menu-bar-items class to mobile header if needed</li>\n<li>Menu Plus: Add is-logo-image class to all site logos</li>\n<li>Menu Plus: Fix mobile header alignment when it has menu bar items</li>\n<li>Secondary Nav: Better prepare sticky navigation for GP 3.0</li>\n<li>Secondary Nav: Fix hidden navigation widget in top bar when merged with secondary nav</li>\n<li>Sites: Improve the option-only import feature</li>\n<li>Sites: Improve the refresh sites button functionality</li>\n<li>Sites: Improve the undo site import functionality</li>\n<li>Sites: Fix Elementor site import issues</li>\n<li>Sites: Re-add Elementor sites to library</li>\n<li>Spacing: Better prepare Customizer live preview for GP 3.0</li>\n<li>Spacing: Fix blog column spacing Customizer live preview</li>\n<li>Spacing: Stop handling mobile header, widget and footer widget features added in GP 3.0</li>\n<li>Typography: Add mobile font size control for H3 (when using GP 3.0)</li>\n<li>Typography: Add mobile font size control for H4 (when using GP 3.0)</li>\n<li>Typography: Add mobile font size control for H5 (when using GP 3.0)</li>\n<li>Typography: Allow empty tablet and mobile site title font size values</li>\n<li>Typography: Make menu toggle CSS selector specific to primary navigation</li>\n<li>WooCommerce: Use CSS for secondary product image functionality instead of JS</li>\n<li>WooCommerce: Only load .js file if needed</li>\n<li>WooCommerce: Fix quantity box functionality when multiple quantity boxes exist on the page</li>\n<li>General: Improve alpha color picker script for better 5.5 compatibility</li>\n<li>General: Move child theme stylesheet after dynamic stylesheet if enabled</li>\n<li>General: Update gp-premium-de_DE.mo</li>\n<li>General: Update gp-premium-es_ES.mo</li>\n<li>General: Update gp-premium-fi.mo</li>\n<li>General: Update gp-premium-pt_PT.mo</li>\n<li>General: Update gp-premium-sv_SE.mo</li>\n</ul>\n<h4> 1.11.3 </h4>\n<ul>\n<li>Blog: Set widths to grid-sizer element</li>\n<li>Elements: Fix legacy Page Header/Hooks buttons in the Elements dashboard</li>\n<li>Page Header: Replace .load() with .on(\'load\')</li>\n<li>Page Header: Fix color picker error in WP 5.5</li>\n</ul>\n<h4> 1.11.2 </h4>\n<ul>\n<li>Blog: Remove negative featured image top margin from columns when using one container</li>\n<li>Blog: Fix infinite scroll items loading above viewport when using columns</li>\n<li>Blog: Fix infinite scroll featured images not displaying in Safari</li>\n<li>Elements: Prevent error in editor when generate_get_option() function doesn\'t exist</li>\n<li>General: Load inline CSS in previews when using external CSS option</li>\n<li>General: Update gp-premium-es_ES.mo</li>\n<li>General: Update gp-premium-pt_PT.mo</li>\n</ul>\n<h4> 1.11.1 </h4>\n<ul>\n<li>Elements: Remove stray quote character in Layout Element metabox</li>\n<li>Sections: Fix color picker JS error in WP 5.5</li>\n<li>General: Fix external CSS option not removing inline CSS in some cases</li>\n</ul>\n<h4> 1.11.0 </h4>\n<ul>\n<li>New: Block Elements</li>\n<li>New: Apply Layout Element options to the block editor if set</li>\n<li>New: Generate dynamic CSS in an external file</li>\n<li>Blog: Separate CSS and load only when needed</li>\n<li>Blog: Add column width classes to stylesheet</li>\n<li>Blog: Disable featured image itemprop if microdata is disabled</li>\n<li>Blog: Add generate_blog_masonry_init filter</li>\n<li>Blog: Add generate_blog_infinite_scroll_init filter</li>\n<li>Blog: Fix archive page header overlap when using no featured image padding/one container</li>\n<li>Blog: Replace screen reader text with aria-label in read more buttons</li>\n<li>Disable Elements: Add option to disable the Mobile Header</li>\n<li>Disable Elements: Disable top bar disables it even when combined with Secondary Nav</li>\n<li>Disable Elements: Use generate_show_post_navigation filter to disable single post navigation</li>\n<li>Elements: Use full hook name with generate_ prefix in dropdown</li>\n<li>Elements: Rebuild how Element types are chosen</li>\n<li>Elements: Add chosen hook under type column in edit.php</li>\n<li>Menu Plus: Add generate_after_mobile_header_menu_button filter</li>\n<li>Menu Plus: Add sticky placeholder only when nav becomes sticky</li>\n<li>Menu Plus: Add class to sticky nav when scrolling up</li>\n<li>Menu Plus: Fix navigation branding/mobile header layout when using RTL languages</li>\n<li>Page Header: Prevent PHP notices</li>\n<li>Secondary Nav: Clean up CSS</li>\n<li>Secondary Nav: Add generate_after_secondary_navigation hook</li>\n<li>Secondary Nav: Add generate_before_secondary_navigation hook</li>\n<li>Secondary Nav: Integrate with future flexbox option</li>\n<li>Secondary Nav: Add has-top-bar class if needed</li>\n<li>Secondary Nav: Add screen reader text to mobile menu toggle if no text exists</li>\n<li>Secondary Nav: Remove microdata if disabled</li>\n<li>Secondary Nav: Add generate_secondary_menu_bar_items hook</li>\n<li>Spacing: Set sidebar width in Customizer for future flexbox option</li>\n<li>WooCommerce: Add generate_woocommerce_show_add_to_cart_panel filter</li>\n<li>WooCommerce: Integrate with future flexbox option</li>\n<li>WooCommerce: Ensure WC()-&gt;cart is set</li>\n<li>WooCommerce: Remove left margin from SVG menu cart icon</li>\n<li>WooCommerce: Show sticky add to cart panel on sold individually products</li>\n<li>WooCommerce: Remove bottom margin from related/upsell products</li>\n<li>WooCommerce: Fix cart menu item spacing in RTL languages</li>\n<li>WooCommerce: Fix menu item cart dropdown design in RTL languages</li>\n<li>General: Update selectWoo</li>\n<li>General: Update select2</li>\n<li>General: Run all CSS through PostCSS</li>\n<li>General: Fix various text domains</li>\n<li>General: Fix JS error when toggling nav as header option without Colors/Typography modules</li>\n<li>General: Update all translations over 90% complete</li>\n<li>General: PHP cleanup/coding standards</li>\n<li>General: Add off_canvas_desktop_toggle_label to wpml-config.xml</li>\n</ul>\n<h4> 1.10.0 </h4>\n<ul>\n<li>Blog: Remove existing on-the-fly featured image resizer (Image Processing Queue)</li>\n<li>Blog: Choose from existing image sizes for featured images</li>\n<li>Blog: Use CSS to further resize featured images if necessary</li>\n<li>Blog: Fix edge case persistent transient bug with old image resizer</li>\n<li>Elements: Fix broken closing element in metabox</li>\n<li>General: Change scroll variable to gpscroll in smooth scroll script to avoid conflicts</li>\n<li>General: Update responsive widths in Customizer</li>\n<li>General: Fix responsive Customizer views when using RTL</li>\n<li>Menu Plus: Don\'t output sticky nav branding if sticky nav is disabled</li>\n<li>Menu Plus: Fix focus when off canvas overlay is opened (a11y)</li>\n<li>Menu Plus: Fix sticky navigation jump when navigation branding is in use</li>\n<li>Sections: Fix visible block editor when Sections are enabled</li>\n<li>WooCommerce: Use minmax in grid template definitions to fix overflow issue</li>\n<li>WooCommerce: Prevent add to cart panel interfering with back to top button on mobile</li>\n<li>WooCommerce: WooCommerce: Fix secondary image position if HTML isn\'t ordered correctly</li>\n<li>General: Add/update all translations over 50% complete. Big thanks to all contributors!</li>\n<li>Translation: Added Arabic - thank you anass!</li>\n<li>Translation: Added Bengali - thank you gtmroy!</li>\n<li>Translation: Added Spanish (Spain) - thank you davidperez (closemarketing.es)!</li>\n<li>Translation: Added Spanish (Argentina) - thank you bratorr!</li>\n<li>Translation: Added Finnish - thank you Stedi!</li>\n<li>Translation: Add Dutch - thank you Robin!</li>\n<li>Translation: Added Ukrainian - thank you EUROMEDIA!</li>\n<li>Translation: Vietnamese added - thank you themevi!</li>\n</ul>\n<h4> 1.9.1 </h4>\n<ul>\n<li>Blog: Fix &quot;null&quot; in infinite scroll load more button text</li>\n<li>WooCommerce: Fix hidden added to cart panel on mobile when sticky nav active</li>\n<li>WooCommerce: Fix missing SVG icon in mobile added to cart panel</li>\n</ul>\n<h4> 1.9.0 </h4>\n<ul>\n<li>Blog: Support SVG icon feature</li>\n<li>Colors: Add navigation search color options</li>\n<li>Disable Elements: Disable mobile menu in Mobile Header if nav is disabled</li>\n<li>Elements: Add wp_body_open hook</li>\n<li>Elements: Allow 0 mobile padding in Elements</li>\n<li>Elements: Add generate_elements_admin_menu_capability filter</li>\n<li>Elements: Add generate_page_hero_css_output filter</li>\n<li>Elements: Prevent error in Header Element if taxonomy doesn\'t exist</li>\n<li>Elements: Fix double logo when Header Element has logo + using nav as header</li>\n<li>Elements: Fix mobile header logo not replacing if merge is disabled</li>\n<li>Elements: Fix missing arrow in Choose Element Type select in WP 5.3</li>\n<li>Elements: Add generate_inside_site_container hook option</li>\n<li>Elements: Add generate_after_entry_content hook option</li>\n<li>Menu Plus: Add off canvas desktop toggle label option</li>\n<li>Menu Plus: Add generate_off_canvas_toggle_output filter</li>\n<li>Menu Plus: Support SVG icon feature</li>\n<li>Menu Plus: Fix sticky navigation overlapping BB controls</li>\n<li>Menu Plus: Add align-items: center to nav as header, mobile header and sticky nav with branding</li>\n<li>Sections: Fix text/visual switch bug in Firefox</li>\n<li>Sites: Add option to revert site import</li>\n<li>Sites: Increase site library limit to 100</li>\n<li>Spacing: Add live preview to group container padding</li>\n<li>Typography: Add tablet site title/navigation font size options</li>\n<li>Typography: Add archive post title weight, transform, font size and line height</li>\n<li>Typography: Add single content title weight, transform, font size and line height</li>\n<li>Typography: Only call all google fonts once in the Customizer</li>\n<li>Typography: Get Google fonts from readable JSON list</li>\n<li>Typography: Make sure font settings aren\'t lost if list is changed</li>\n<li>Typography: Only call generate_get_all_google_fonts if needed</li>\n<li>WooCommerce: Add columns gap options (desktop, tablet, mobile)</li>\n<li>WooCommerce: Add tablet column options</li>\n<li>WooCommerce: Add related/upsell tablet column options</li>\n<li>WooCommerce: Support SVG icon feature</li>\n<li>WooCommerce: Prevent empty added to cart panel on single products</li>\n<li>WooCommerce: Fix woocommerce-ordering arrow in old FF versions</li>\n<li>WooCommerce: Make item/items string translatable</li>\n<li>General: Better customizer device widths</li>\n<li>General: Use generate_premium_get_media_query throughout modules</li>\n<li>General: Improve Customizer control styling</li>\n</ul>\n<h4> 1.8.3 </h4>\n<ul>\n<li>Menu Plus: Use flexbox for center aligned nav with nav branding</li>\n<li>Menu Plus: Center overlay off canvas exit button on mobile</li>\n<li>Menu Plus: Add alt tag to sticky nav logo</li>\n<li>Menu Plus: Set generate_not_mobile_menu_media_query filter based on mobile menu breakpoint</li>\n<li>Sections: Remember when text tab is active</li>\n<li>Sections: Disable visual editor if turned off in profile</li>\n<li>Typography: Add generate_google_font_display filter</li>\n<li>WooCommerce: Fix single product sidebar layout metabox option</li>\n<li>WooCommerce: Reduce carousel thumbnail max-width to 100px to match new thumbnail sizes</li>\n</ul>\n<h4> 1.8.2 </h4>\n<ul>\n<li>Elements: Use Page Hero site title color for mobile header site title</li>\n<li>Menu Plus: Give mobile header site title more left spacing</li>\n<li>Menu Plus: Fix nav search icon in sticky navigation when using nav branding in Firefox</li>\n<li>Site Library: Show Site Library tab even if no sites exist</li>\n<li>Site Library: Show an error message in Site Library if no sites exist</li>\n<li>Typography: Remove reference to generate_get_navigation_location() function</li>\n<li>WooCommerce: Remove quantity field arrows when using quantity buttons in Firefox</li>\n<li>WooCommerce: Remove extra border when loading quantity buttons</li>\n<li>WooCommerce: Use get_price_html() is sticky add to cart panel</li>\n</ul>\n<h4> 1.8.1 </h4>\n<ul>\n<li>Menu Plus: Revert sticky nav duplicate ID fix due to Cyrillic script bug</li>\n</ul>\n<h4> 1.8 </h4>\n<ul>\n<li>Blog: Apply columns filter to masonry grid sizer</li>\n<li>Colors: Merge Footer Widgets and Footer controls in Color panel</li>\n<li>Colors: Remove edit_theme_options capability to Customizer controls (set by default)</li>\n<li>Disable Elements: Make sure mobile header is disabled when primary navigation is disabled</li>\n<li>Elements: Add content width option in Layout Element</li>\n<li>Elements: Fix mobile header logo when mobile menu toggled</li>\n<li>Elements: Add generate_page_hero_location filter</li>\n<li>Elements: Add generate_elements_show_object_ids filter to show IDs in Display Rule values</li>\n<li>Elements: Prevent merged header wrap from conflicting with Elementor controls</li>\n<li>Elements: Change Container tab name to Content</li>\n<li>Elements: Add woocommerce_share option to Hooks</li>\n<li>Elements: Improve WPML compatibility</li>\n<li>Elements: Improve Polylang compatibility</li>\n<li>Elements: Prevent PHP notices when adding taxonomy locations to non-existent archives</li>\n<li>Elements: Add generate_mobile_cart_items hook to hook list</li>\n<li>Elements: Add generate_element_post_id filter</li>\n<li>Elements: Escape HTML elements inside Element textarea</li>\n<li>Elements: Add Beaver Builder templates to the Display Rules</li>\n<li>Menu Plus: Add mobile header breakpoint option</li>\n<li>Menu Plus: Add off canvas overlay option</li>\n<li>Menu Plus: Add navigation as header option</li>\n<li>Menu Plus: Remove navigation logo option if navigation as header set</li>\n<li>Menu Plus: Add sticky navigation logo option</li>\n<li>Menu Plus: Allow site title in mobile header instead of logo</li>\n<li>Menu Plus: Add option to move exit button inside the off canvas panel</li>\n<li>Menu Plus: Change Slideout Navigation name to Off Canvas Panel</li>\n<li>Menu Plus: Only re-focus after slideout close on escape key</li>\n<li>Menu Plus: Give close slideout event a name so it can be removed</li>\n<li>Menu Plus: Remove invalid transition-delay</li>\n<li>Menu Plus: Improve slideout overlay transition</li>\n<li>Menu Plus: Add mobile open/close icons to GPP font</li>\n<li>Menu Plus: Allow dynamic widget classes in off canvas panel (fixes WC range slider widget issue)</li>\n<li>Menu Plus: Basic compatibility with future SVG icons</li>\n<li>Menu Plus: Prevent duplicate IDs when sticky navigation is cloned</li>\n<li>Secondary Nav: Add dropdown direction option</li>\n<li>Secondary Nav: Basic compatibility with future SVG icons</li>\n<li>Sections: Fix section editor issues in WP 5.0</li>\n<li>Sections: Show Better Font Awesome icon in editor</li>\n<li>Sites: Re-design UI</li>\n<li>Sites: Add option to activate as a module like all the other modules</li>\n<li>Sites: Don\'t show backup options button if no options exist</li>\n<li>Sites: Make JS action classes more specific to the site library</li>\n<li>Sites: Set mime types of content.xml and widgets.wie</li>\n<li>Spacing: Add header padding option for mobile</li>\n<li>Spacing: Add widget padding option for mobile</li>\n<li>Spacing: Add footer widgets padding option for mobile</li>\n<li>Spacing: Add content separator option</li>\n<li>Spacing: Apply mobile menu item width to mobile bar only</li>\n<li>WooCommerce: Add option for mini cart in the menu</li>\n<li>WooCommerce: Add option to open off overlay panel on add to cart</li>\n<li>WooCommerce: Add option to open sticky add to cart panel on single products</li>\n<li>WooCommerce: Add option to add +/- buttons to the quantity fields</li>\n<li>WooCommerce: Add option to show number of items in cart menu item</li>\n<li>WooCommerce: Add option to choose single product image area width</li>\n<li>WooCommerce: Add color options for price slider widget</li>\n<li>WooCommerce: Use CSS grid for the product archives</li>\n<li>WooCommerce: Horizontally align add to cart buttons</li>\n<li>WooCommerce: Re-design the cart widget</li>\n<li>WooCommerce: Tighten up product info spacing</li>\n<li>WooCommerce: Improve product tab design to look more like tabs</li>\n<li>WooCommerce: Simplify single product image display</li>\n<li>WooCommerce: Use flexbox for quantity/add to cart alignment</li>\n<li>WooCommerce: Improve rating star styles</li>\n<li>WooCommerce: Use product alignment setting for related/upsell products</li>\n<li>WooCommerce: Remove bottom margin from product image</li>\n<li>WooCommerce: Organize colors in the Customizer</li>\n<li>WooCommerce: Remove title attribute from menu cart item</li>\n<li>WooCommerce: Improve coupon field design</li>\n<li>WooCommerce: Improve result count/ordering styling</li>\n<li>WooCommerce: Add gap around WC single product images</li>\n<li>WooCommerce: Remove arrow from checkout button</li>\n<li>WooCommerce: Hide view cart link on add to cart click</li>\n<li>WooCommerce: Organize CSS</li>\n<li>Introduce in-Customizer shortcuts</li>\n<li>Add generate_disable_customizer_shortcuts filter</li>\n</ul>\";}s:7:\"banners\";O:8:\"stdClass\":2:{s:4:\"high\";s:0:\"\";s:3:\"low\";s:0:\"\";}s:5:\"icons\";a:2:{s:2:\"1x\";s:73:\"https://generatepress.com/wp-content/uploads/edd/2020/05/icon-128x128.png\";s:2:\"2x\";s:73:\"https://generatepress.com/wp-content/uploads/edd/2020/05/icon-256x256.png\";}s:10:\"stable_tag\";s:5:\"2.3.1\";s:6:\"tested\";s:5:\"6.2.2\";s:11:\"description\";a:1:{i:0;s:341:\"<p>The entire collection of GeneratePress premium modules. Once activated, each module extends certain aspects of GeneratePress, giving you more options to build your website.</p>\n<h4> Documentation </h4>\n<p>Check out our <a href=\"https://docs.generatepress.com\">documentation</a> for more information on each module and how to use them.</p>\";}s:9:\"changelog\";a:1:{i:0;s:28506:\"<h4> 2.3.1 </h4>\n<ul>\n<li>Fix: SelectSearch component infinite loop</li>\n<li>Fix: Block widths inside Block Elements</li>\n</ul>\n<h4> 2.3.0 </h4>\n<ul>\n<li>Feature: Add Search Modal Element type</li>\n<li>Fix: Inline post meta feature in GenerateBlocks 1.7</li>\n<li>Fix: Close &quot;Choose Element Type&quot; modal with ESC key</li>\n<li>Fix: Replace WooCommerce secondary image attachment size</li>\n<li>Fix: WP Filesystem error missing credentials</li>\n<li>Fix: Undefined array keys in dynamic Container URL</li>\n<li>Fix: Author avatar in Header/Block Element titles</li>\n<li>Fix: Infinite loop error when autosaving with dynamic content block</li>\n<li>Fix: Add aria-label to off-canvas panel button</li>\n<li>Fix: WooCommerce button dynamic typography</li>\n<li>Fix: Empty WooCommerce quantity fields</li>\n<li>Fix: PHP 8.1 notice using disable elements in Customizer</li>\n<li>Tweak: Improve license key area</li>\n<li>Tweak: Improve off-canvas transitions</li>\n<li>Tweak: Check for WooCommerce functions</li>\n<li>Tweak: Open off-canvas using space bar</li>\n<li>Tweak: Use image ID in mobile header/sticky nav logos</li>\n<li>Tweak: Improve Elements hook selection dropdown UI</li>\n<li>Tweak: Add site library check for min GenerateBlocks version</li>\n<li>Tweak: Add Loop Template to Custom Post Type dropdown filters</li>\n</ul>\n<h4> 2.2.2 </h4>\n<ul>\n<li>Fix: Off Canvas anchor links not working</li>\n</ul>\n<h4> 2.2.1 </h4>\n<ul>\n<li>Fix: Add value to off-canvas aria-hidden attribute</li>\n<li>Tweak: Remove/add aria-hidden to off-canvas on toggle</li>\n</ul>\n<h4> 2.2.0 </h4>\n<ul>\n<li>Feature: Allow block element autosave</li>\n<li>Feature: Add revisions to block elements</li>\n<li>Feature: Add Loop Template block element</li>\n<li>Feature: Dont display the raw license key in the Dashboard</li>\n<li>Feature: Add &quot;Paginated Results&quot; to Element Display Rules</li>\n<li>Fix: Element post navigation template PHP warning when not using GB Pro</li>\n<li>Fix: Remove unnecessary zoom CSS from featured images</li>\n<li>Fix: Font icon CSS order</li>\n<li>Fix: Load more button showing in product tax archives</li>\n<li>Fix: Prevent tabbing in hidden off-canvas panel</li>\n<li>Fix: Hide hidden off-canvas panel from screen readers</li>\n<li>Fix: menu-toggle aria-controls when using off-canvas panel</li>\n<li>Fix: Focus first focusable element when opening off-canvas panel</li>\n<li>Fix: Focus slideout toggle when closing off-canvas panel</li>\n<li>Fix: Off-Canvas Panel sub-menu a11y</li>\n<li>Fix: Prevent secondary nav legacy typography CSS</li>\n<li>Fix: Fix dynamic term meta link</li>\n<li>Fix: Block margins in the block element editor</li>\n<li>Fix: Embeds in Block Elements</li>\n<li>Fix: Apply display rules to editor with no ID</li>\n<li>Fix: Navigation background image applying to secondary nav</li>\n<li>Fix: WooCommerce order received page float issue</li>\n<li>Fix: Block element editor error in GenerateBlocks 1.7</li>\n<li>Tweak: Remove jquery-migrate from sticky script</li>\n<li>Tweak: Add message in Blog section about Loop Template</li>\n</ul>\n<h4> 2.1.2 </h4>\n<ul>\n<li>Elements: Fix custom field value in dynamic container links</li>\n<li>Elements: Fix block widths in the editor</li>\n<li>General: Fix double slashes in dashboard file request</li>\n<li>General: Fix missing Customizer translations</li>\n</ul>\n<h4> 2.1.1 </h4>\n<ul>\n<li>Menu Plus: Fix mobile header sticky auto hide</li>\n<li>Site Library: Fix broken CSS variables on import</li>\n</ul>\n<h4> 2.1.0 </h4>\n<ul>\n<li>Blog: Fix masonry JS error if no archive pagination exists</li>\n<li>Blog: Fix full width featured blog column</li>\n<li>Colors: Deprecate module if using GP 3.1.0</li>\n<li>Elements: Add custom class option to dynamic image block</li>\n<li>Elements: Add support for post_type array in display rules</li>\n<li>Elements: Fix container link option when targeting next/previous posts</li>\n<li>Menu Plus: Integrate off-canvas panel with new dynamic typography system</li>\n<li>Menu Plus: Integrate off-canvas panel with new color system</li>\n<li>Menu Plus: Integrate mobile header HTML attributes with new HTML attribute system</li>\n<li>Menu Plus: Integrate mobile header and off-canvas panel with new generate_has_active_menu filter</li>\n<li>Menu Plus: Fix broken inline CSS when using floated sticky navigation</li>\n<li>Menu Plus: Add logo dimensions to navigation logo</li>\n<li>Secondary Navigation: Integrate with new color system</li>\n<li>Secondary Navigation: Integrate with new generate_has_active_menu filter</li>\n<li>Secondary Navigation: Integrate with new dynamic typography system</li>\n<li>Secondary Navigation: Reduce box-shadow to match main navigation</li>\n<li>Secondary Navigation: Change direction of sub-menu box-shadow when opening left</li>\n<li>Secondary Navigation: Fix sub-menu overlap when using dropdown click/mobile</li>\n<li>Secondary Navigation: Replace box-shadow with border-bottom when sub-menu opens down</li>\n<li>Site Library: Add site author attribution</li>\n<li>Typography: Deprecate module if using dynamic typography in GP 3.1.0</li>\n<li>WooCommerce: Integrate with new dynamic typography system</li>\n<li>WooCommerce: Integrate with new colors system</li>\n<li>WooCommerce: Remove category title/description if using page hero with title disabled</li>\n<li>WooCommerce: Remove &quot;speak&quot; CSS properties</li>\n<li>WooCommerce: Fix empty continue shopping link on mobile</li>\n<li>WooCommerce: Fix persistent sticky add to cart panel</li>\n<li>General: Integrate with new GP 3.1.0 Dashboard</li>\n<li>General: Remove featured-image-active body class if featured image is disabled</li>\n<li>General: Change date format in exported JSON filename</li>\n<li>General: Fix PHP error when license key activation returns 403</li>\n</ul>\n<h4> 2.0.3 </h4>\n<ul>\n<li>Elements: Use block_categories_all filter in WP 5.8</li>\n<li>Elements: Remove wp-editor dependency from new widget editor</li>\n</ul>\n<h4> 2.0.2 </h4>\n<ul>\n<li>Elements: Use blog page title for dynamic title if set</li>\n<li>Spacing: Fix reset button bug in Customizer controls</li>\n<li>WooCommerce: Fix infinite scroll applying to product taxonomy pages</li>\n</ul>\n<h4> 2.0.1 </h4>\n<ul>\n<li>Blog: Fix infinite scroll bug on product archives</li>\n<li>Elements: Fix error in WP 4.9.x versions</li>\n<li>Menu Plus: Prevent 0x0 logo dimension attributes if no dimensions exist</li>\n<li>Site Library: Add vertical scroll ability to the Site Library control area</li>\n</ul>\n<h4> 2.0.0 </h4>\n<ul>\n<li>Blog: Rewrite infinite scroll using vanilla javascript</li>\n<li>Blog: Rewrite masonry using vanilla javascript</li>\n<li>Blog: Add separate infinite scroll path element to footer</li>\n<li>Blog: Fix missing single/page featured image options when archive image disabled</li>\n<li>Blog: Add aria-label instead of screen-reader-text to read more button</li>\n<li>Colors: Fix back to top Customizer color preview</li>\n<li>Elements: New Content Template Element</li>\n<li>Elements: New Post Meta Template Element</li>\n<li>Elements: New Post Navigation Template Element</li>\n<li>Elements: New Page Hero Block Element</li>\n<li>Elements: New Archive Navigation Template Element</li>\n<li>Elements: New Editor Width option in Block Elements</li>\n<li>Elements: Move Block Elements options into editor sidebar</li>\n<li>Elements: Show Site Header options by default in Header Element</li>\n<li>Elements: Fix Classic Editor issue in Block Elements</li>\n<li>Elements: Add a list of active Elements to page editor</li>\n<li>Elements: Add a list of active Elements to the admin bar</li>\n<li>Elements: Add notices to Customizer if Elements may be overwriting options</li>\n<li>Elements: Disable mobile header menu if menu is disabled via Layout Element</li>\n<li>Elements: Improve Display Rule loading performance</li>\n<li>Elements: Add block type filter to Elements dashboard</li>\n<li>Elements: Add generate_element_display filter</li>\n<li>Elements: Add No Results as a Display Rule condition</li>\n<li>Menu Plus: Hide slideout toggle at set mobile menu breakpoint value</li>\n<li>Menu Plus: Fix sticky menu height when using navigation as header</li>\n<li>Menu Plus: Add dimensions to mobile/sticky logos</li>\n<li>Menu Plus: Make Off-Canvas menu take up full width of canvas</li>\n<li>Menu Plus: Fix menu bar item sticky transition</li>\n<li>Menu Plus: Prevent sticky sidebar nav if mobile header is set to sticky</li>\n<li>Secondary Nav: Fix centered secondary navigation items using flexbox</li>\n<li>Secondary Nav: Fix conflict with Nav as Header option</li>\n<li>Secondary Nav: Fix missing menu cart items when using click dropdowns</li>\n<li>Sections: Officially deprecate module</li>\n<li>Site Library: Completely rebuild Site Library using React</li>\n<li>WooCommerce: Move full width single product CSS to inline CSS</li>\n<li>WooCommerce: Use wc_get_product() instead of new WC_Product()</li>\n<li>WooCommerce: Add more checks for WC() class to prevent error logs</li>\n<li>WooCommerce: Add generate_wc_cart_panel_checkout_button_output filter</li>\n<li>WooCommerce: Add generate_wc_sticky_add_to_cart_action filter</li>\n<li>WooCommerce: Add generate_wc_show_sticky_add_to_cart filter</li>\n<li>WooCommerce: Re-write quantity button javascript to be more performant/extendable</li>\n<li>General: Update theme install link</li>\n<li>General: Update alpha color picker script</li>\n<li>General: Use correct URL scheme in external stylesheet URLs</li>\n<li>General: Check if FS_CHMOD_FILE is defined in external stylesheet generation</li>\n<li>General: Use inline CSS when using AMP plugin</li>\n<li>General: Update EDD_SL_Plugin_Updater class to 1.8.0</li>\n<li>General: Clean up javascript throughout plugin</li>\n<li>General: Replace deprecated jQuery functions</li>\n</ul>\n<h4> 1.12.3 </h4>\n<ul>\n<li>WooCommerce: Fix quantity buttons in WP 5.6</li>\n</ul>\n<h4> 1.12.2 </h4>\n<ul>\n<li>Blog: Load columns CSS when using filter to enable it anywhere</li>\n<li>Menu Plus: Fix sticky mobile header jump when using inline mobile toggle</li>\n<li>Menu Plus: Add margin to sticky nav branding when set to full width</li>\n<li>Menu Plus: Disable sticky nav container text align padding</li>\n<li>Menu Plus: Make mobile menu absolute only when smooth scroll is enabled</li>\n<li>Menu Plus: Improve nav as header/mobile header when using flexbox</li>\n<li>Menu Plus: Prevent off-canvas panel close button from flashing visible when closing</li>\n<li>Spacing: Fix custom nav search height</li>\n</ul>\n<h4> 1.12.1 </h4>\n<ul>\n<li>Typography: Fix missing heading font size controls in the Customizer</li>\n</ul>\n<h4> 1.12.0 </h4>\n<ul>\n<li>Blog: Fix column margin on mobile with some caching plugins</li>\n<li>Blog: Add post-load trigger to infinite scroll for better plugin compatibility</li>\n<li>Blog: Take generate_blog_columns filter into account when loading columns CSS</li>\n<li>Colors: Add search menu-bar-item color live preview to Customizer</li>\n<li>Elements: Fix broken custom hook field in Block Elements</li>\n<li>Elements: Integrate page hero with text container alignment in GP 3.0</li>\n<li>Elements: Better integrate Header Element colors with GP 3.0</li>\n<li>Elements: Only disable content title when {{post_title}} is present on single pages</li>\n<li>Elements: Fix  tag in metabox</li>\n<li>Elements: Add generate_elements_metabox_ajax_allow_editors filter</li>\n<li>Elements: Add new 3.0 hooks to hook selector</li>\n<li>Elements: Re-add generate_elements_custom_args filter</li>\n<li>Menu Plus: Better prepare navigation as header for GP 3.0</li>\n<li>Menu Plus: Better prepare Off-Canvas Panel for GP 3.0</li>\n<li>Menu Plus: Better prepare sticky navigation for GP 3.0</li>\n<li>Menu Plus: Add has-menu-bar-items class to mobile header if needed</li>\n<li>Menu Plus: Add is-logo-image class to all site logos</li>\n<li>Menu Plus: Fix mobile header alignment when it has menu bar items</li>\n<li>Secondary Nav: Better prepare sticky navigation for GP 3.0</li>\n<li>Secondary Nav: Fix hidden navigation widget in top bar when merged with secondary nav</li>\n<li>Sites: Improve the option-only import feature</li>\n<li>Sites: Improve the refresh sites button functionality</li>\n<li>Sites: Improve the undo site import functionality</li>\n<li>Sites: Fix Elementor site import issues</li>\n<li>Sites: Re-add Elementor sites to library</li>\n<li>Spacing: Better prepare Customizer live preview for GP 3.0</li>\n<li>Spacing: Fix blog column spacing Customizer live preview</li>\n<li>Spacing: Stop handling mobile header, widget and footer widget features added in GP 3.0</li>\n<li>Typography: Add mobile font size control for H3 (when using GP 3.0)</li>\n<li>Typography: Add mobile font size control for H4 (when using GP 3.0)</li>\n<li>Typography: Add mobile font size control for H5 (when using GP 3.0)</li>\n<li>Typography: Allow empty tablet and mobile site title font size values</li>\n<li>Typography: Make menu toggle CSS selector specific to primary navigation</li>\n<li>WooCommerce: Use CSS for secondary product image functionality instead of JS</li>\n<li>WooCommerce: Only load .js file if needed</li>\n<li>WooCommerce: Fix quantity box functionality when multiple quantity boxes exist on the page</li>\n<li>General: Improve alpha color picker script for better 5.5 compatibility</li>\n<li>General: Move child theme stylesheet after dynamic stylesheet if enabled</li>\n<li>General: Update gp-premium-de_DE.mo</li>\n<li>General: Update gp-premium-es_ES.mo</li>\n<li>General: Update gp-premium-fi.mo</li>\n<li>General: Update gp-premium-pt_PT.mo</li>\n<li>General: Update gp-premium-sv_SE.mo</li>\n</ul>\n<h4> 1.11.3 </h4>\n<ul>\n<li>Blog: Set widths to grid-sizer element</li>\n<li>Elements: Fix legacy Page Header/Hooks buttons in the Elements dashboard</li>\n<li>Page Header: Replace .load() with .on(\'load\')</li>\n<li>Page Header: Fix color picker error in WP 5.5</li>\n</ul>\n<h4> 1.11.2 </h4>\n<ul>\n<li>Blog: Remove negative featured image top margin from columns when using one container</li>\n<li>Blog: Fix infinite scroll items loading above viewport when using columns</li>\n<li>Blog: Fix infinite scroll featured images not displaying in Safari</li>\n<li>Elements: Prevent error in editor when generate_get_option() function doesn\'t exist</li>\n<li>General: Load inline CSS in previews when using external CSS option</li>\n<li>General: Update gp-premium-es_ES.mo</li>\n<li>General: Update gp-premium-pt_PT.mo</li>\n</ul>\n<h4> 1.11.1 </h4>\n<ul>\n<li>Elements: Remove stray quote character in Layout Element metabox</li>\n<li>Sections: Fix color picker JS error in WP 5.5</li>\n<li>General: Fix external CSS option not removing inline CSS in some cases</li>\n</ul>\n<h4> 1.11.0 </h4>\n<ul>\n<li>New: Block Elements</li>\n<li>New: Apply Layout Element options to the block editor if set</li>\n<li>New: Generate dynamic CSS in an external file</li>\n<li>Blog: Separate CSS and load only when needed</li>\n<li>Blog: Add column width classes to stylesheet</li>\n<li>Blog: Disable featured image itemprop if microdata is disabled</li>\n<li>Blog: Add generate_blog_masonry_init filter</li>\n<li>Blog: Add generate_blog_infinite_scroll_init filter</li>\n<li>Blog: Fix archive page header overlap when using no featured image padding/one container</li>\n<li>Blog: Replace screen reader text with aria-label in read more buttons</li>\n<li>Disable Elements: Add option to disable the Mobile Header</li>\n<li>Disable Elements: Disable top bar disables it even when combined with Secondary Nav</li>\n<li>Disable Elements: Use generate_show_post_navigation filter to disable single post navigation</li>\n<li>Elements: Use full hook name with generate_ prefix in dropdown</li>\n<li>Elements: Rebuild how Element types are chosen</li>\n<li>Elements: Add chosen hook under type column in edit.php</li>\n<li>Menu Plus: Add generate_after_mobile_header_menu_button filter</li>\n<li>Menu Plus: Add sticky placeholder only when nav becomes sticky</li>\n<li>Menu Plus: Add class to sticky nav when scrolling up</li>\n<li>Menu Plus: Fix navigation branding/mobile header layout when using RTL languages</li>\n<li>Page Header: Prevent PHP notices</li>\n<li>Secondary Nav: Clean up CSS</li>\n<li>Secondary Nav: Add generate_after_secondary_navigation hook</li>\n<li>Secondary Nav: Add generate_before_secondary_navigation hook</li>\n<li>Secondary Nav: Integrate with future flexbox option</li>\n<li>Secondary Nav: Add has-top-bar class if needed</li>\n<li>Secondary Nav: Add screen reader text to mobile menu toggle if no text exists</li>\n<li>Secondary Nav: Remove microdata if disabled</li>\n<li>Secondary Nav: Add generate_secondary_menu_bar_items hook</li>\n<li>Spacing: Set sidebar width in Customizer for future flexbox option</li>\n<li>WooCommerce: Add generate_woocommerce_show_add_to_cart_panel filter</li>\n<li>WooCommerce: Integrate with future flexbox option</li>\n<li>WooCommerce: Ensure WC()-&gt;cart is set</li>\n<li>WooCommerce: Remove left margin from SVG menu cart icon</li>\n<li>WooCommerce: Show sticky add to cart panel on sold individually products</li>\n<li>WooCommerce: Remove bottom margin from related/upsell products</li>\n<li>WooCommerce: Fix cart menu item spacing in RTL languages</li>\n<li>WooCommerce: Fix menu item cart dropdown design in RTL languages</li>\n<li>General: Update selectWoo</li>\n<li>General: Update select2</li>\n<li>General: Run all CSS through PostCSS</li>\n<li>General: Fix various text domains</li>\n<li>General: Fix JS error when toggling nav as header option without Colors/Typography modules</li>\n<li>General: Update all translations over 90% complete</li>\n<li>General: PHP cleanup/coding standards</li>\n<li>General: Add off_canvas_desktop_toggle_label to wpml-config.xml</li>\n</ul>\n<h4> 1.10.0 </h4>\n<ul>\n<li>Blog: Remove existing on-the-fly featured image resizer (Image Processing Queue)</li>\n<li>Blog: Choose from existing image sizes for featured images</li>\n<li>Blog: Use CSS to further resize featured images if necessary</li>\n<li>Blog: Fix edge case persistent transient bug with old image resizer</li>\n<li>Elements: Fix broken closing element in metabox</li>\n<li>General: Change scroll variable to gpscroll in smooth scroll script to avoid conflicts</li>\n<li>General: Update responsive widths in Customizer</li>\n<li>General: Fix responsive Customizer views when using RTL</li>\n<li>Menu Plus: Don\'t output sticky nav branding if sticky nav is disabled</li>\n<li>Menu Plus: Fix focus when off canvas overlay is opened (a11y)</li>\n<li>Menu Plus: Fix sticky navigation jump when navigation branding is in use</li>\n<li>Sections: Fix visible block editor when Sections are enabled</li>\n<li>WooCommerce: Use minmax in grid template definitions to fix overflow issue</li>\n<li>WooCommerce: Prevent add to cart panel interfering with back to top button on mobile</li>\n<li>WooCommerce: WooCommerce: Fix secondary image position if HTML isn\'t ordered correctly</li>\n<li>General: Add/update all translations over 50% complete. Big thanks to all contributors!</li>\n<li>Translation: Added Arabic - thank you anass!</li>\n<li>Translation: Added Bengali - thank you gtmroy!</li>\n<li>Translation: Added Spanish (Spain) - thank you davidperez (closemarketing.es)!</li>\n<li>Translation: Added Spanish (Argentina) - thank you bratorr!</li>\n<li>Translation: Added Finnish - thank you Stedi!</li>\n<li>Translation: Add Dutch - thank you Robin!</li>\n<li>Translation: Added Ukrainian - thank you EUROMEDIA!</li>\n<li>Translation: Vietnamese added - thank you themevi!</li>\n</ul>\n<h4> 1.9.1 </h4>\n<ul>\n<li>Blog: Fix &quot;null&quot; in infinite scroll load more button text</li>\n<li>WooCommerce: Fix hidden added to cart panel on mobile when sticky nav active</li>\n<li>WooCommerce: Fix missing SVG icon in mobile added to cart panel</li>\n</ul>\n<h4> 1.9.0 </h4>\n<ul>\n<li>Blog: Support SVG icon feature</li>\n<li>Colors: Add navigation search color options</li>\n<li>Disable Elements: Disable mobile menu in Mobile Header if nav is disabled</li>\n<li>Elements: Add wp_body_open hook</li>\n<li>Elements: Allow 0 mobile padding in Elements</li>\n<li>Elements: Add generate_elements_admin_menu_capability filter</li>\n<li>Elements: Add generate_page_hero_css_output filter</li>\n<li>Elements: Prevent error in Header Element if taxonomy doesn\'t exist</li>\n<li>Elements: Fix double logo when Header Element has logo + using nav as header</li>\n<li>Elements: Fix mobile header logo not replacing if merge is disabled</li>\n<li>Elements: Fix missing arrow in Choose Element Type select in WP 5.3</li>\n<li>Elements: Add generate_inside_site_container hook option</li>\n<li>Elements: Add generate_after_entry_content hook option</li>\n<li>Menu Plus: Add off canvas desktop toggle label option</li>\n<li>Menu Plus: Add generate_off_canvas_toggle_output filter</li>\n<li>Menu Plus: Support SVG icon feature</li>\n<li>Menu Plus: Fix sticky navigation overlapping BB controls</li>\n<li>Menu Plus: Add align-items: center to nav as header, mobile header and sticky nav with branding</li>\n<li>Sections: Fix text/visual switch bug in Firefox</li>\n<li>Sites: Add option to revert site import</li>\n<li>Sites: Increase site library limit to 100</li>\n<li>Spacing: Add live preview to group container padding</li>\n<li>Typography: Add tablet site title/navigation font size options</li>\n<li>Typography: Add archive post title weight, transform, font size and line height</li>\n<li>Typography: Add single content title weight, transform, font size and line height</li>\n<li>Typography: Only call all google fonts once in the Customizer</li>\n<li>Typography: Get Google fonts from readable JSON list</li>\n<li>Typography: Make sure font settings aren\'t lost if list is changed</li>\n<li>Typography: Only call generate_get_all_google_fonts if needed</li>\n<li>WooCommerce: Add columns gap options (desktop, tablet, mobile)</li>\n<li>WooCommerce: Add tablet column options</li>\n<li>WooCommerce: Add related/upsell tablet column options</li>\n<li>WooCommerce: Support SVG icon feature</li>\n<li>WooCommerce: Prevent empty added to cart panel on single products</li>\n<li>WooCommerce: Fix woocommerce-ordering arrow in old FF versions</li>\n<li>WooCommerce: Make item/items string translatable</li>\n<li>General: Better customizer device widths</li>\n<li>General: Use generate_premium_get_media_query throughout modules</li>\n<li>General: Improve Customizer control styling</li>\n</ul>\n<h4> 1.8.3 </h4>\n<ul>\n<li>Menu Plus: Use flexbox for center aligned nav with nav branding</li>\n<li>Menu Plus: Center overlay off canvas exit button on mobile</li>\n<li>Menu Plus: Add alt tag to sticky nav logo</li>\n<li>Menu Plus: Set generate_not_mobile_menu_media_query filter based on mobile menu breakpoint</li>\n<li>Sections: Remember when text tab is active</li>\n<li>Sections: Disable visual editor if turned off in profile</li>\n<li>Typography: Add generate_google_font_display filter</li>\n<li>WooCommerce: Fix single product sidebar layout metabox option</li>\n<li>WooCommerce: Reduce carousel thumbnail max-width to 100px to match new thumbnail sizes</li>\n</ul>\n<h4> 1.8.2 </h4>\n<ul>\n<li>Elements: Use Page Hero site title color for mobile header site title</li>\n<li>Menu Plus: Give mobile header site title more left spacing</li>\n<li>Menu Plus: Fix nav search icon in sticky navigation when using nav branding in Firefox</li>\n<li>Site Library: Show Site Library tab even if no sites exist</li>\n<li>Site Library: Show an error message in Site Library if no sites exist</li>\n<li>Typography: Remove reference to generate_get_navigation_location() function</li>\n<li>WooCommerce: Remove quantity field arrows when using quantity buttons in Firefox</li>\n<li>WooCommerce: Remove extra border when loading quantity buttons</li>\n<li>WooCommerce: Use get_price_html() is sticky add to cart panel</li>\n</ul>\n<h4> 1.8.1 </h4>\n<ul>\n<li>Menu Plus: Revert sticky nav duplicate ID fix due to Cyrillic script bug</li>\n</ul>\n<h4> 1.8 </h4>\n<ul>\n<li>Blog: Apply columns filter to masonry grid sizer</li>\n<li>Colors: Merge Footer Widgets and Footer controls in Color panel</li>\n<li>Colors: Remove edit_theme_options capability to Customizer controls (set by default)</li>\n<li>Disable Elements: Make sure mobile header is disabled when primary navigation is disabled</li>\n<li>Elements: Add content width option in Layout Element</li>\n<li>Elements: Fix mobile header logo when mobile menu toggled</li>\n<li>Elements: Add generate_page_hero_location filter</li>\n<li>Elements: Add generate_elements_show_object_ids filter to show IDs in Display Rule values</li>\n<li>Elements: Prevent merged header wrap from conflicting with Elementor controls</li>\n<li>Elements: Change Container tab name to Content</li>\n<li>Elements: Add woocommerce_share option to Hooks</li>\n<li>Elements: Improve WPML compatibility</li>\n<li>Elements: Improve Polylang compatibility</li>\n<li>Elements: Prevent PHP notices when adding taxonomy locations to non-existent archives</li>\n<li>Elements: Add generate_mobile_cart_items hook to hook list</li>\n<li>Elements: Add generate_element_post_id filter</li>\n<li>Elements: Escape HTML elements inside Element textarea</li>\n<li>Elements: Add Beaver Builder templates to the Display Rules</li>\n<li>Menu Plus: Add mobile header breakpoint option</li>\n<li>Menu Plus: Add off canvas overlay option</li>\n<li>Menu Plus: Add navigation as header option</li>\n<li>Menu Plus: Remove navigation logo option if navigation as header set</li>\n<li>Menu Plus: Add sticky navigation logo option</li>\n<li>Menu Plus: Allow site title in mobile header instead of logo</li>\n<li>Menu Plus: Add option to move exit button inside the off canvas panel</li>\n<li>Menu Plus: Change Slideout Navigation name to Off Canvas Panel</li>\n<li>Menu Plus: Only re-focus after slideout close on escape key</li>\n<li>Menu Plus: Give close slideout event a name so it can be removed</li>\n<li>Menu Plus: Remove invalid transition-delay</li>\n<li>Menu Plus: Improve slideout overlay transition</li>\n<li>Menu Plus: Add mobile open/close icons to GPP font</li>\n<li>Menu Plus: Allow dynamic widget classes in off canvas panel (fixes WC range slider widget issue)</li>\n<li>Menu Plus: Basic compatibility with future SVG icons</li>\n<li>Menu Plus: Prevent duplicate IDs when sticky navigation is cloned</li>\n<li>Secondary Nav: Add dropdown direction option</li>\n<li>Secondary Nav: Basic compatibility with future SVG icons</li>\n<li>Sections: Fix section editor issues in WP 5.0</li>\n<li>Sections: Show Better Font Awesome icon in editor</li>\n<li>Sites: Re-design UI</li>\n<li>Sites: Add option to activate as a module like all the other modules</li>\n<li>Sites: Don\'t show backup options button if no options exist</li>\n<li>Sites: Make JS action classes more specific to the site library</li>\n<li>Sites: Set mime types of content.xml and widgets.wie</li>\n<li>Spacing: Add header padding option for mobile</li>\n<li>Spacing: Add widget padding option for mobile</li>\n<li>Spacing: Add footer widgets padding option for mobile</li>\n<li>Spacing: Add content separator option</li>\n<li>Spacing: Apply mobile menu item width to mobile bar only</li>\n<li>WooCommerce: Add option for mini cart in the menu</li>\n<li>WooCommerce: Add option to open off overlay panel on add to cart</li>\n<li>WooCommerce: Add option to open sticky add to cart panel on single products</li>\n<li>WooCommerce: Add option to add +/- buttons to the quantity fields</li>\n<li>WooCommerce: Add option to show number of items in cart menu item</li>\n<li>WooCommerce: Add option to choose single product image area width</li>\n<li>WooCommerce: Add color options for price slider widget</li>\n<li>WooCommerce: Use CSS grid for the product archives</li>\n<li>WooCommerce: Horizontally align add to cart buttons</li>\n<li>WooCommerce: Re-design the cart widget</li>\n<li>WooCommerce: Tighten up product info spacing</li>\n<li>WooCommerce: Improve product tab design to look more like tabs</li>\n<li>WooCommerce: Simplify single product image display</li>\n<li>WooCommerce: Use flexbox for quantity/add to cart alignment</li>\n<li>WooCommerce: Improve rating star styles</li>\n<li>WooCommerce: Use product alignment setting for related/upsell products</li>\n<li>WooCommerce: Remove bottom margin from product image</li>\n<li>WooCommerce: Organize colors in the Customizer</li>\n<li>WooCommerce: Remove title attribute from menu cart item</li>\n<li>WooCommerce: Improve coupon field design</li>\n<li>WooCommerce: Improve result count/ordering styling</li>\n<li>WooCommerce: Add gap around WC single product images</li>\n<li>WooCommerce: Remove arrow from checkout button</li>\n<li>WooCommerce: Hide view cart link on add to cart click</li>\n<li>WooCommerce: Organize CSS</li>\n<li>Introduce in-Customizer shortcuts</li>\n<li>Add generate_disable_customizer_shortcuts filter</li>\n</ul>\";}s:6:\"plugin\";s:25:\"gp-premium/gp-premium.php\";s:2:\"id\";s:25:\"gp-premium/gp-premium.php\";}}s:7:\"checked\";a:1:{s:25:\"gp-premium/gp-premium.php\";s:5:\"2.3.1\";}}", "no");
INSERT INTO `wpeng_options` VALUES("29213", "_site_transient_timeout_theme_roots", "1690447295", "no");
INSERT INTO `wpeng_options` VALUES("29214", "_site_transient_theme_roots", "a:3:{s:13:\"generatepress\";s:7:\"/themes\";s:19:\"generatepress_child\";s:7:\"/themes\";s:17:\"twentytwentythree\";s:7:\"/themes\";}", "no");
INSERT INTO `wpeng_options` VALUES("29227", "_transient_timeout_wpseo_total_unindexed_posts_limited", "1690449352", "no");
INSERT INTO `wpeng_options` VALUES("29228", "_transient_wpseo_total_unindexed_posts_limited", "0", "no");
INSERT INTO `wpeng_options` VALUES("29229", "_transient_timeout_wpseo_total_unindexed_terms_limited", "1690449352", "no");
INSERT INTO `wpeng_options` VALUES("29230", "_transient_wpseo_total_unindexed_terms_limited", "0", "no");
INSERT INTO `wpeng_options` VALUES("29231", "_site_transient_timeout_community-events-801595ecd1bfe9421117bec52f00a765", "1690491657", "no");
INSERT INTO `wpeng_options` VALUES("29232", "_site_transient_community-events-801595ecd1bfe9421117bec52f00a765", "a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";s:12:\"213.249.10.0\";}s:6:\"events\";a:0:{}}", "no");

/* INSERT TABLE DATA: wpeng_postmeta */
INSERT INTO `wpeng_postmeta` VALUES("1", "2", "_wp_page_template", "default");
INSERT INTO `wpeng_postmeta` VALUES("2", "3", "_wp_page_template", "default");
INSERT INTO `wpeng_postmeta` VALUES("3", "5", "_form", "<label> Το όνομά σας (απαραίτητο)\n    [text* your-name] </label>\n\n<label> Το email σας (απαραίτητο)\n    [email* your-email] </label>\n\n<label> Θέμα\n    [text your-subject] </label>\n\n<label> Το μήνυμά σας\n    [textarea your-message] </label>\n\n[submit \"Αποστολή\"]");
INSERT INTO `wpeng_postmeta` VALUES("4", "5", "_mail", "a:8:{s:7:\"subject\";s:33:\"WordPress Engine \"[your-subject]\"\";s:6:\"sender\";s:51:\"[your-name] <wordpress@wordpress.engine.demod4u.gr>\";s:4:\"body\";s:316:\"Από: [your-name] <[your-email]>\nΘέμα: [your-subject]\n\nΣώμα μηνύματος:\n[your-message]\n\n-- \nΑυτό το μήνυμα ηλεκτρονικού ταχυδρομείου εστάλει από την φόρμα επικοινωνίας του WordPress Engine (https://wordpress.engine.gp.demod4u.gr)\";s:9:\"recipient\";s:16:\"dev@digital4u.gr\";s:18:\"additional_headers\";s:22:\"Reply-To: [your-email]\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";i:0;s:13:\"exclude_blank\";i:0;}");
INSERT INTO `wpeng_postmeta` VALUES("5", "5", "_mail_2", "a:9:{s:6:\"active\";b:0;s:7:\"subject\";s:33:\"WordPress Engine \"[your-subject]\"\";s:6:\"sender\";s:56:\"WordPress Engine <wordpress@wordpress.engine.demod4u.gr>\";s:4:\"body\";s:255:\"Σώμα μηνύματος:\n[your-message]\n\n-- \nΑυτό το μήνυμα ηλεκτρονικού ταχυδρομείου εστάλει από την φόρμα επικοινωνίας του WordPress Engine (https://wordpress.engine.gp.demod4u.gr)\";s:9:\"recipient\";s:12:\"[your-email]\";s:18:\"additional_headers\";s:26:\"Reply-To: dev@digital4u.gr\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";i:0;s:13:\"exclude_blank\";i:0;}");
INSERT INTO `wpeng_postmeta` VALUES("6", "5", "_messages", "a:8:{s:12:\"mail_sent_ok\";s:97:\"Ευχαριστούμε για το μήνυμά σας. Στάλθηκε με επιτυχία.\";s:12:\"mail_sent_ng\";s:105:\"Υπήρξε σφάλμα κατά την αποστολή. Δοκιμάστε ξανά αργότερα.\";s:16:\"validation_error\";s:122:\"Ένα ή περισσότερα πεδία έχουν σφάλματα. Ελέγξτε και ξαναδοκιμάστε.\";s:4:\"spam\";s:105:\"Υπήρξε σφάλμα κατά την αποστολή. Δοκιμάστε ξανά αργότερα.\";s:12:\"accept_terms\";s:118:\"Πρέπει να αποδεχτείτε τους όρους χρήσης πριν στείλετε το μήνυμα.\";s:16:\"invalid_required\";s:59:\"Αυτο το πεδίο είναι υποχρεωτικό.\";s:16:\"invalid_too_long\";s:49:\"Το πεδίο είναι πολύ μεγάλο.\";s:17:\"invalid_too_short\";s:47:\"Το πεδίο είναι πολύ μικρό.\";}");
INSERT INTO `wpeng_postmeta` VALUES("7", "5", "_additional_settings", NULL);
INSERT INTO `wpeng_postmeta` VALUES("8", "5", "_locale", "el");
INSERT INTO `wpeng_postmeta` VALUES("11", "2", "_edit_lock", "1651653182:1");
INSERT INTO `wpeng_postmeta` VALUES("12", "1", "_edit_lock", "1689174076:3");

/* INSERT TABLE DATA: wpeng_posts */
INSERT INTO `wpeng_posts` VALUES("1", "1", "2018-08-24 14:22:23", "2018-08-24 11:22:23", "Καλωσήλθατε στο WordPress!  Αυτό είναι το πρώτο σας άρθρο.  Αλλάξτε το ή διαγράψτε το και αρχίστε να γράφετε!", "Καλημέρα κόσμε!", "", "publish", "open", "open", "", "hello-world", "", "", "2018-08-24 14:22:23", "2018-08-24 11:22:23", "", "0", "https://wordpress.engine.gp.demod4u.gr/?p=1", "0", "post", "", "1");
INSERT INTO `wpeng_posts` VALUES("2", "1", "2018-08-24 14:22:23", "2018-08-24 11:22:23", "Αυτό είναι ένα παράδειγμα σελίδας. Είναι διαφορετικό από ένα άρθρο γιατί παραμένει σε ένα μέρος και θα εμφανίζεται στην πλοήγηση (στα περισσότερα θέματα). Οι περισσότεροι ξεκινούν με μια Περί σελίδα που τους παρουσιάζει στους πιθανούς επισκέπτες. Μπορεί να λέει κάτι σαν αυτό:\n\n<blockquote>Γεια σου! Είμαι ένας ταχυδρόμος με ποδήλατο την ημέρα, και ένας εμπνευσμένος ηθοποιός την νύχτα, αυτός είναι ο ιστότοπος μου. Ζω στην Αθήνα, έχω έναν υπέροχο σκύλο που τον λένε Έκτορα, και μου αρέσει να πίνω Mojito (Και να χορεύω στην βροχή) </blockquote>\n\n...ή κάτι σαν αυτό:\n\n<blockquote>Η XYZ Εταιρία ιδρύθηκε το 1971, και παρέχει ποιοτικά εργαλεία για μηχανικούς αυτοκινήτων. Η εταιρία βρίσκεται στην Θεσσαλονίκη, και εργάζονται πάνω από 2000 άτομα και προσφέρει στην τοπική κοινότητα.</blockquote>\n\nΩς ένας νέος χρήστης WordPress, θα πρέπει να επισκεφθείτε την<a href=\"https://wordpress.engine.gp.demod4u.gr/wp-admin/\">διαχείρισή σας</a> για να διαγράψετε αυτή την σελίδα και να δημιουργήσετε νέες για το περιεχόμενό σας. Καλή διασκέδαση!", "Δείγμα σελίδας", "", "publish", "closed", "open", "", "sample-page", "", "", "2018-08-24 14:22:23", "2018-08-24 11:22:23", "", "0", "https://wordpress.engine.gp.demod4u.gr/?page_id=2", "0", "page", "", "0");
INSERT INTO `wpeng_posts` VALUES("3", "1", "2018-08-24 14:22:23", "2018-08-24 11:22:23", "<h2>Ποιοί είμαστε</h2><p>Η διεύθυνση της σελίδας είναι: https://wordpress.engine.gp.demod4u.gr.</p><h2>Ποιά προσωπικά δεδομένα συλλέγουμε και γιατί</h2><h3>Σχόλια</h3><p>Όταν οι επισκέπτες αφήνουν σχόλια στον ιστότοπο, συλλέγουμε τα δεδομένα που εμφανίζονται στη φόρμα σχολίων όπως επίσης τη διεύθυνση IP του επισκέπτη και τη συμβολοσειρά του χρήστη του προγράμματος περιήγησης ώστε να βοηθήσουμε στην ανίχνευση ανεπιθύμητων μηνυμάτων.</p><p>Μια ανωνυμοποιημένη συμβολοσειρά που δημιουργήθηκε από τη διεύθυνση ηλεκτρονικού ταχυδρομείου σας (επίσης αποκαλούμενη \"hash\") ενδέχεται να παρασχεθεί στην υπηρεσία Gravatar για να δει αν τη χρησιμοποιείτε. Η πολιτική απορρήτου της υπηρεσίας Gravatar διατίθεται εδώ: https://automattic.com/privacy/. Μετά την έγκριση του σχολίου σας, η εικόνα του προφίλ σας είναι ορατή στο κοινό μέσα στο πλαίσιο του σχολίου σας.</p><h3>Πολυμέσα</h3><p>Εάν μεταφορτώνετε εικόνες στον ιστότοπο, θα πρέπει να αποφύγετε τη μεταφόρτωση εικόνων με ενσωματωμένα δεδομένα τοποθεσίας (EXIF GPS). Οι επισκέπτες του ιστότοπου μπορούν να πραγματοποιήσουν λήψη και εξαγωγή οποιωνδήποτε δεδομένων τοποθεσίας από εικόνες στον ιστότοπο.</p><h3>Φόρμες Επικοινωνίας</h3><h3>Cookies</h3><p>Αν αφήσετε ένα σχόλιο στον ιστότοπό μας, μπορείτε να επιλέξετε να αποθηκεύσετε το όνομα, τη διεύθυνση ηλεκτρονικού ταχυδρομείου και τον ιστότοπό σας σε cookies. Αυτά είναι για την δική σας ευκολία, έτσι ώστε να μην χρειάζεται να συμπληρώσετε τα στοιχεία σας πάλι όταν αφήσετε ένα άλλο σχόλιο. Αυτά τα cookies θα διαρκέσουν για ένα έτος.</p><p>Αν έχετε έναν λογαριασμό και συνδεθείτε στον ιστότοπο, θα δημιουργήσουμε ένα πρόχειρο cookie για να προσδιορίσουμε αν ο πλοηγός δέχεται cookies. Το cookie δεν περιέχει προσωπικές πληροφορίες και διαγράφεται όταν κλείνετε τον πλοηγό σας.</p><p>Όταν συνδεθείτε, θα δημιουργήσουμε επίσης διάφορα cookies για να αποθηκεύσετε τις πληροφορίες σύνδεσης και τις επιλογές οθόνης. Τα cookie εισόδου διαρκούν για δύο ημέρες και τα cookie επιλογών οθόνης διαρκούν για ένα χρόνο. Αν επιλέξετε &quot;Να με θυμάσαι&quot;, η σύνδεσή σας θα παραμείνει για δύο εβδομάδες. Αν αποσυνδεθείτε από το λογαριασμό σας, τα cookie σύνδεσης θα καταργηθούν.</p><p>Εάν επεξεργαστείτε ή δημοσιεύσετε ένα άρθρο, ένα επιπλέον cookie θα αποθηκευτεί στο πρόγραμμα περιήγησης. Αυτό το cookie δεν περιλαμβάνει προσωπικά δεδομένα και υποδεικνύει απλώς το post ID του άρθρου που μόλις επεξεργαστήκατε. Λήγει μετά από 1 ημέρα.</p><h3>Ενσωματωμένο περιεχόμενο από άλλους ιστότοπους</h3><p>Τα άρθρα σε αυτόν τον ιστότοπο ενδέχεται να περιλαμβάνουν ενσωματωμένο περιεχόμενο (π.χ. βίντεο, εικόνες, άρθρα κ.λπ.). Το ενσωματωμένο περιεχόμενο από άλλους ιστότοπους συμπεριφέρεται με τον ίδιο ακριβώς τρόπο όπως και αν ο επισκέπτης επισκέφθηκε τον άλλο ιστότοπο.</p><p>Αυτοί οι ιστότοποι ενδέχεται να συλλέγουν δεδομένα για εσάς, χρησιμοποιούν cookies, ενσωματώνουν επιπλέον παρακολούθηση τρίτου μέρους και να παρακολουθούν την αλληλεπίδρασή σας με αυτό το περιλαμβανόμενο περιεχόμενο, συμπεριλαμβανομένης της ανίχνευσης της αλληλεπίδρασής σας με το περιλαμβανόμενο περιεχόμενο, εάν έχετε λογαριασμό και έχετε συνδεθεί στον συγκεκριμένο ιστότοπο.</p><h3>Αναλυτικά στοιχεία</h3><h2>Με ποιούς μοιραζόμαστε τα δεδομένα σας</h2><h2>Για πόσο καιρό διατηρούμε τα δεδομένα σας</h2><p>Εάν αφήσετε ένα σχόλιο, το σχόλιο και τα μεταδεδομένα του διατηρούνται επ\' αόριστον. Αυτό γίνεται ώστε να μπορούμε να αναγνωρίζουμε και να εγκρίνουμε αυτόματα τα σχόλια που ακολουθούν, αντί να τα κρατάμε σε ουρά συντονισμού.</p><p>Για χρήστες που εγγράφονται στον ιστότοπο μας, αποθηκεύουμε επίσης τα προσωπικά δεδομένα που καταχωρούν στο προφίλ χρήστη τους. Όλοι οι χρήστες μπορούν να βλέπουν, να επεξεργάζονται ή να διαγράφουν τα προσωπικά δεδομένα τους ανά πάσα στιγμή (εκτός από το να μπορούν να αλλάξουν το όνομα χρήστη τους). Οι διαχειριστές του παρόντος ιστότοπου μπορεί επίσης να βλέπουν και να επεξεργάζονται αυτές τις πληροφορίες.</p><h2>Ποια δικαιώματα έχετε στα δεδομένα σας</h2><p>Εάν έχετε λογαριασμό σε αυτόν τον ιστότοπο ή έχετε αφήσει σχόλια, μπορείτε να ζητήσετε να λάβετε ένα εξαγόμενο αρχείο των προσωπικών δεδομένων που διατηρούμε για εσάς, συμπεριλαμβανομένων τυχόν δεδομένων που έχετε παράσχει σε εμάς. Μπορείτε επίσης να αιτηθείτε να διαγράψουμε τα προσωπικά δεδομένα που διατηρούμε για εσάς. Αυτό δεν περιλαμβάνει δεδομένα που είμαστε υποχρεωμένοι να τηρούμε για διοικητικούς, νομικούς ή λόγους ασφαλείας.</p><h2>Που θα σταλούν τα δεδομένα σας</h2><p>Τα σχόλια επισκεπτών ενδέχεται να ελέγχονται μέσω ενός αυτοματοποιημένου συστήματος ανεπιθύμητης αλληλογραφίας.</p><h2>Τα στοιχεία επικοινωνίας σας</h2><h2>Επιπλέον πληροφορίες</h2><h3>Πως προστατεύουμε τα στοιχεία σας</h3><h3>Τι διαδικασίες έχουμε υιοθετήσει για την παραβίαση δεδομένων</h3><h3>Από ποιους τρίτους λαμβάνουμε δεδομένα</h3><h3>Σε τι αυτόματη λήψη απόφασης και/ή δημιουργία προφίλ προβαίνουμε με τα δεδομένα των χρηστών</h3><h3>Απαιτήσεις δημοσιοποίησης κανονιστικών ρυθμίσεων</h3>", "Πολιτική Απορρήτου", "", "draft", "closed", "open", "", "πολιτική απορρήτου", "", "", "2018-08-24 14:22:23", "2018-08-24 11:22:23", "", "0", "https://wordpress.engine.gp.demod4u.gr/?page_id=3", "0", "page", "", "0");
INSERT INTO `wpeng_posts` VALUES("5", "1", "2018-08-24 14:41:26", "2018-08-24 11:41:26", "<label> Το όνομά σας (απαραίτητο)\n    [text* your-name] </label>\n\n<label> Το email σας (απαραίτητο)\n    [email* your-email] </label>\n\n<label> Θέμα\n    [text your-subject] </label>\n\n<label> Το μήνυμά σας\n    [textarea your-message] </label>\n\n[submit \"Αποστολή\"]\nWordPress Engine \"[your-subject]\"\n[your-name] <wordpress@wordpress.engine.demod4u.gr>\nΑπό: [your-name] <[your-email]>\nΘέμα: [your-subject]\n\nΣώμα μηνύματος:\n[your-message]\n\n-- \nΑυτό το μήνυμα ηλεκτρονικού ταχυδρομείου εστάλει από την φόρμα επικοινωνίας του WordPress Engine (https://wordpress.engine.gp.demod4u.gr)\ndev@digital4u.gr\nReply-To: [your-email]\n\n0\n0\n\nWordPress Engine \"[your-subject]\"\nWordPress Engine <wordpress@wordpress.engine.demod4u.gr>\nΣώμα μηνύματος:\n[your-message]\n\n-- \nΑυτό το μήνυμα ηλεκτρονικού ταχυδρομείου εστάλει από την φόρμα επικοινωνίας του WordPress Engine (https://wordpress.engine.gp.demod4u.gr)\n[your-email]\nReply-To: dev@digital4u.gr\n\n0\n0\nΕυχαριστούμε για το μήνυμά σας. Στάλθηκε με επιτυχία.\nΥπήρξε σφάλμα κατά την αποστολή. Δοκιμάστε ξανά αργότερα.\nΈνα ή περισσότερα πεδία έχουν σφάλματα. Ελέγξτε και ξαναδοκιμάστε.\nΥπήρξε σφάλμα κατά την αποστολή. Δοκιμάστε ξανά αργότερα.\nΠρέπει να αποδεχτείτε τους όρους χρήσης πριν στείλετε το μήνυμα.\nΑυτο το πεδίο είναι υποχρεωτικό.\nΤο πεδίο είναι πολύ μεγάλο.\nΤο πεδίο είναι πολύ μικρό.", "Φόρμα επικοινωνίας 1", "", "publish", "closed", "closed", "", "forma-epikoinonias-1", "", "", "2018-08-24 14:41:26", "2018-08-24 11:41:26", "", "0", "https://wordpress.engine.gp.demod4u.gr/?post_type=wpcf7_contact_form&p=5", "0", "wpcf7_contact_form", "", "0");
INSERT INTO `wpeng_posts` VALUES("8", "5", "2022-05-03 13:45:34", "2022-05-03 10:45:34", "{\"version\": 2, \"isGlobalStylesUserThemeJSON\": true }", "Custom Styles", "", "publish", "closed", "closed", "", "wp-global-styles-generatepress", "", "", "2022-05-03 13:45:34", "2022-05-03 10:45:34", "", "0", "https://wordpress.engine.gp.demod4u.gr/wp-global-styles-generatepress/", "0", "wp_global_styles", "", "0");
INSERT INTO `wpeng_posts` VALUES("9", "5", "2022-05-03 13:46:37", "2022-05-03 10:46:37", "<!-- wp:paragraph -->\n<p>Αυτό είναι ένα παράδειγμα σελίδας. Είναι διαφορετικό από ένα άρθρο γιατί παραμένει σε ένα μέρος και θα εμφανίζεται στην πλοήγηση (στα περισσότερα θέματα). Οι περισσότεροι ξεκινούν με μια Περί σελίδα που τους παρουσιάζει στους πιθανούς επισκέπτες. Μπορεί να λέει κάτι σαν αυτό:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class=\"wp-block-quote\"><p>Γεια σου! Είμαι ένας ταχυδρόμος με ποδήλατο την ημέρα, και ένας εμπνευσμένος ηθοποιός την νύχτα, αυτός είναι ο ιστότοπος μου. Ζω στην Αθήνα, έχω έναν υπέροχο σκύλο που τον λένε Έκτορα, και μου αρέσει να πίνω Mojito (Και να χορεύω στην βροχή)</p></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>...ή κάτι σαν αυτό:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class=\"wp-block-quote\"><p>Η XYZ Εταιρία ιδρύθηκε το 1971, και παρέχει ποιοτικά εργαλεία για μηχανικούς αυτοκινήτων. Η εταιρία βρίσκεται στην Θεσσαλονίκη, και εργάζονται πάνω από 2000 άτομα και προσφέρει στην τοπική κοινότητα.</p></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>Ως ένας νέος χρήστης WordPress, θα πρέπει να επισκεφθείτε την<a href=\"https://wordpress.engine.gp.demod4u.gr/wp-admin/\">διαχείρισή σας</a> για να διαγράψετε αυτή την σελίδα και να δημιουργήσετε νέες για το περιεχόμενό σας. Καλή διασκέδαση!</p>\n<!-- /wp:paragraph -->", "Δείγμα σελίδας", "", "inherit", "closed", "closed", "", "2-autosave-v1", "", "", "2022-05-03 13:46:37", "2022-05-03 10:46:37", "", "2", "https://wordpress.engine.gp.demod4u.gr/?p=9", "0", "revision", "", "0");
INSERT INTO `wpeng_posts` VALUES("11", "1", "2022-05-04 11:35:20", "2022-05-04 08:35:20", "{\"version\": 2, \"isGlobalStylesUserThemeJSON\": true }", "Custom Styles", "", "publish", "closed", "closed", "", "wp-global-styles-generatepress_child", "", "", "2022-05-04 11:35:20", "2022-05-04 08:35:20", "", "0", "https://wordpress.engine.gp.demod4u.gr/wp-global-styles-generatepress_child/", "0", "wp_global_styles", "", "0");
INSERT INTO `wpeng_posts` VALUES("12", "3", "2023-07-25 12:08:33", "0000-00-00 00:00:00", "", "Auto Draft", "", "auto-draft", "closed", "closed", "", "", "", "", "2023-07-25 12:08:33", "0000-00-00 00:00:00", "", "0", "https://wordpress.engine.gp.demod4u.gr/?p=12", "0", "post", "", "0");

/* INSERT TABLE DATA: wpeng_term_relationships */
INSERT INTO `wpeng_term_relationships` VALUES("1", "1", "0");
INSERT INTO `wpeng_term_relationships` VALUES("8", "2", "0");
INSERT INTO `wpeng_term_relationships` VALUES("11", "3", "0");

/* INSERT TABLE DATA: wpeng_term_taxonomy */
INSERT INTO `wpeng_term_taxonomy` VALUES("1", "1", "category", "", "0", "1");
INSERT INTO `wpeng_term_taxonomy` VALUES("2", "2", "wp_theme", "", "0", "1");
INSERT INTO `wpeng_term_taxonomy` VALUES("3", "3", "wp_theme", "", "0", "1");

/* INSERT TABLE DATA: wpeng_terms */
INSERT INTO `wpeng_terms` VALUES("1", "Χωρίς κατηγορία", "%ce%b1%cf%84%ce%b1%ce%be%ce%b9%ce%bd%cf%8c%ce%bc%ce%b7%cf%84%ce%b1", "0");
INSERT INTO `wpeng_terms` VALUES("2", "generatepress", "generatepress", "0");
INSERT INTO `wpeng_terms` VALUES("3", "generatepress_child", "generatepress_child", "0");

/* INSERT TABLE DATA: wpeng_usermeta */
INSERT INTO `wpeng_usermeta` VALUES("1", "1", "nickname", "digitaladmin");
INSERT INTO `wpeng_usermeta` VALUES("2", "1", "first_name", "d");
INSERT INTO `wpeng_usermeta` VALUES("3", "1", "last_name", "g");
INSERT INTO `wpeng_usermeta` VALUES("4", "1", "description", "");
INSERT INTO `wpeng_usermeta` VALUES("5", "1", "rich_editing", "true");
INSERT INTO `wpeng_usermeta` VALUES("6", "1", "syntax_highlighting", "true");
INSERT INTO `wpeng_usermeta` VALUES("7", "1", "comment_shortcuts", "false");
INSERT INTO `wpeng_usermeta` VALUES("8", "1", "admin_color", "fresh");
INSERT INTO `wpeng_usermeta` VALUES("9", "1", "use_ssl", "0");
INSERT INTO `wpeng_usermeta` VALUES("10", "1", "show_admin_bar_front", "true");
INSERT INTO `wpeng_usermeta` VALUES("11", "1", "locale", "");
INSERT INTO `wpeng_usermeta` VALUES("12", "1", "wpeng_capabilities", "a:1:{s:13:\"administrator\";b:1;}");
INSERT INTO `wpeng_usermeta` VALUES("13", "1", "wpeng_user_level", "10");
INSERT INTO `wpeng_usermeta` VALUES("14", "1", "dismissed_wp_pointers", "wp496_privacy");
INSERT INTO `wpeng_usermeta` VALUES("15", "1", "show_welcome_panel", "1");
INSERT INTO `wpeng_usermeta` VALUES("17", "1", "wpeng_dashboard_quick_press_last_post_id", "21");
INSERT INTO `wpeng_usermeta` VALUES("18", "1", "community-events-location", "a:1:{s:2:\"ip\";s:9:\"62.1.78.0\";}");
INSERT INTO `wpeng_usermeta` VALUES("20", "2", "nickname", "nbranis");
INSERT INTO `wpeng_usermeta` VALUES("21", "2", "first_name", "n")